/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.bos.sql.dom.expr.SqlExpr;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.service.EnactmentServiceProxy;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.DynamicTableInfo;
import com.kingdee.eas.hr.compensation.CalCmpSchmFacadeFactory;
import com.kingdee.eas.hr.compensation.CmpFormulaFactory;
import com.kingdee.eas.hr.compensation.CmpFormulaInfo;
import com.kingdee.eas.hr.compensation.CmpItemCollection;
import com.kingdee.eas.hr.compensation.CmpItemFactory;
import com.kingdee.eas.hr.compensation.CmpItemInfo;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.compensation.CmpSchemeCollection;
import com.kingdee.eas.hr.compensation.CmpSchemeException;
import com.kingdee.eas.hr.compensation.CmpSchemeFactory;
import com.kingdee.eas.hr.compensation.CmpSchemeInfo;
import com.kingdee.eas.hr.compensation.CmpSchemeItemCollection;
import com.kingdee.eas.hr.compensation.CmpSchemeItemFactory;
import com.kingdee.eas.hr.compensation.CmpSchemeItemInfo;
import com.kingdee.eas.hr.compensation.CmpSchemePersonCollection;
import com.kingdee.eas.hr.compensation.CmpSchemePersonFactory;
import com.kingdee.eas.hr.compensation.CmpSchemePersonInfo;
import com.kingdee.eas.hr.compensation.ColumnMetasInfo;
import com.kingdee.eas.hr.compensation.CommonPermissionFacadeFactory;
import com.kingdee.eas.hr.compensation.EmpCmpSchmException;
import com.kingdee.eas.hr.compensation.EndInputPartFactory;
import com.kingdee.eas.hr.compensation.EndInputPartInfo;
import com.kingdee.eas.hr.compensation.HRParameterEnum;
import com.kingdee.eas.hr.compensation.HRParameterFactory;
import com.kingdee.eas.hr.compensation.ICalCmpSchmFacade;
import com.kingdee.eas.hr.compensation.ICmpFormula;
import com.kingdee.eas.hr.compensation.ICmpItem;
import com.kingdee.eas.hr.compensation.ICmpScheme;
import com.kingdee.eas.hr.compensation.ICmpSchemeItem;
import com.kingdee.eas.hr.compensation.ICmpSchemePerson;
import com.kingdee.eas.hr.compensation.IHRParameter;
import com.kingdee.eas.hr.compensation.IPEndInStatus;
import com.kingdee.eas.hr.compensation.ISchemeFacade;
import com.kingdee.eas.hr.compensation.ItemDataTypeEnum;
import com.kingdee.eas.hr.compensation.PEndInStatusFactory;
import com.kingdee.eas.hr.compensation.SchemeAuditedEnum;
import com.kingdee.eas.hr.compensation.SchemeFacadeFactory;
import com.kingdee.eas.hr.compensation.StateEnum;
import com.kingdee.eas.hr.compensation.app.AbstractCmpSchemeControllerBean;
import com.kingdee.eas.hr.compensation.app.AdapterDynamicDBTable;
import com.kingdee.eas.hr.compensation.util.CompUtils;
import com.kingdee.eas.hr.compensation.util.HRCmpIndexUtils;
import com.kingdee.eas.hr.compensation.util.HRDynamicTableUtils;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.hr.compensation.util.HRTableTools;
import com.kingdee.eas.hr.emp.INewEmployee;
import com.kingdee.eas.hr.emp.NewEmployeeFactory;
import com.kingdee.eas.hr.emp.PersonPositionCollection;
import com.kingdee.eas.hr.emp.PersonPositionFactory;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import org.apache.log4j.Logger;

public class CmpSchemeControllerBean
extends AbstractCmpSchemeControllerBean {
    private static Logger logger = Logger.getLogger(CmpSchemeControllerBean.class);

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, CmpSchemeException, EASBizException {
        ((CmpSchemeInfo)model).setHrOrgUnit(HRSchemeUtils.getServerHROrgUnitInfo(ctx));
        this._checkNumberDup(ctx, model);
        this._checkNameDup(ctx, model);
        CmpSchemeInfo info = (CmpSchemeInfo)model;
        CmpSchemeItemCollection colCmpSchemeItem = info.getItems();
        CmpSchemePersonCollection colCmpSchemePerson = info.getPersons();
        info.setItems(null);
        info.setCalCount(0);
        if (info.isIsTryScheme()) {
            info.setEnable(StateEnum.DISABLE);
            info.setIsDelete(true);
            info.setIsTryScheme(true);
        } else {
            info.setEnable(StateEnum.UNENABLE);
        }
        info.setHrOrgUnit(HRSchemeUtils.getServerHROrgUnitInfo(ctx));
        IObjectPK pk = super._addnew(ctx, (IObjectValue)info);
        this.doItem(ctx, colCmpSchemeItem, info);
        this.doPerson(ctx, colCmpSchemePerson, info, null);
        return pk;
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, CmpSchemeException, EASBizException {
        if (((CmpSchemeInfo)model).getHrOrgUnit() == null) {
            ((CmpSchemeInfo)model).setHrOrgUnit(HRSchemeUtils.getServerHROrgUnitInfo(ctx));
        }
        this._checkNumberDup(ctx, model);
        this._checkNameDup(ctx, model);
        CmpSchemeInfo info = (CmpSchemeInfo)model;
        CmpSchemeItemCollection col = info.getItems();
        CmpSchemePersonCollection colCmpSchemePerson = info.getPersons();
        info.setItems(null);
        info.setPersons(null);
        super._update(ctx, pk, model);
        this.doItem(ctx, col, info);
        this.doPerson(ctx, colCmpSchemePerson, info, info.getHorTableName());
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, CmpSchemeException, EASBizException {
        CmpSchemeInfo info = this.getCmpSchemeInfo(ctx, pk);
        if (info.isIsTryScheme()) {
            StringBuffer deleteSQL = new StringBuffer("");
            deleteSQL = new StringBuffer("");
            deleteSQL.append(" DELETE T_HR_CMPSCHEMEITEM WHERE FCmpSchemeID = '");
            deleteSQL.append(pk.toString());
            deleteSQL.append("'");
            DbUtil.execute((Context)ctx, (String)deleteSQL.toString());
            deleteSQL = new StringBuffer("");
            deleteSQL.append(" DELETE T_HR_CMPSCHEMEPERSON WHERE FCmpSchemeID = '");
            deleteSQL.append(pk.toString());
            deleteSQL.append("'");
            DbUtil.execute((Context)ctx, (String)deleteSQL.toString());
            deleteSQL = new StringBuffer("");
            deleteSQL.append(" DELETE T_HR_TryPeriodEndInput WHERE FCmpSchemeID = '");
            deleteSQL.append(pk.toString());
            deleteSQL.append("'");
            DbUtil.execute((Context)ctx, (String)deleteSQL.toString());
            if (info.getHorTableName() != null) {
                deleteSQL = new StringBuffer("drop table " + info.getHorTableName());
                DbUtil.execute((Context)ctx, (String)deleteSQL.toString());
            }
            deleteSQL = new StringBuffer("");
            deleteSQL.append(" DELETE T_HR_CMPSCHEME WHERE FID = '");
            deleteSQL.append(pk.toString());
            deleteSQL.append("'");
            DbUtil.execute((Context)ctx, (String)deleteSQL.toString());
        } else {
            if (info.getAudit().getValue() == 20) {
                throw new EmpCmpSchmException(EmpCmpSchmException.CMPSCHEME_NOTDELETE);
            }
            StringBuffer deleteSQL = new StringBuffer("");
            if (info.getHorTableName() == null || info.getHorTableName().equals("")) {
                deleteSQL = new StringBuffer("");
                deleteSQL.append(" DELETE T_HR_CMPSCHEMEITEM WHERE FCmpSchemeID = '");
                deleteSQL.append(pk.toString());
                deleteSQL.append("'");
                DbUtil.execute((Context)ctx, (String)deleteSQL.toString());
                deleteSQL = new StringBuffer("");
                deleteSQL.append(" DELETE T_HR_CMPSCHEMEPERSON WHERE FCmpSchemeID = '");
                deleteSQL.append(pk.toString());
                deleteSQL.append("'");
                DbUtil.execute((Context)ctx, (String)deleteSQL.toString());
                deleteSQL = new StringBuffer("");
                deleteSQL.append(" DELETE T_HR_CMPSCHEME WHERE FID = '");
                deleteSQL.append(pk.toString());
                deleteSQL.append("'");
                DbUtil.execute((Context)ctx, (String)deleteSQL.toString());
            } else {
                deleteSQL = new StringBuffer("");
                deleteSQL.append(" UPDATE T_HR_CMPSCHEME SET FIsDelete=1 WHERE FID = '");
                deleteSQL.append(pk.toString());
                deleteSQL.append("'");
                DbUtil.execute((Context)ctx, (String)deleteSQL.toString());
            }
        }
    }

    private String getNewTableName(Context ctx) throws BOSException, EASBizException {
        String tableName = null;
        IHRParameter iHRParameter = HRParameterFactory.getLocalInstance(ctx);
        String schm_prefix = iHRParameter.getParamterValue(HRParameterEnum.SCHM_TABLE_PREFIX);
        String schm_suffix = iHRParameter.getParamterValue(HRParameterEnum.SCHM_TABLE_SUFFIX);
        int int_schm_suffix = Integer.parseInt(schm_suffix);
        String newSchmValue = Integer.valueOf(++int_schm_suffix).toString();
        iHRParameter.updateParamterValue(HRParameterEnum.SCHM_TABLE_SUFFIX, newSchmValue);
        tableName = schm_prefix + schm_suffix;
        tableName = tableName + new Date().getTime();
        if (tableName.length() > 30) {
            tableName = tableName.substring(0, 30);
        }
        return tableName;
    }

    private Map getCurrentSchemePerson(Context ctx, String schemeid) throws BOSException, EASBizException {
        HashMap<String, String> map = new HashMap<String, String>();
        String sql = " SELECT FPERSONID FROM T_HR_CMPSCHEMEPERSON WHERE FCMPSCHEMEID=? and fisDelete = 0";
        Object[] param = new Object[]{schemeid};
        IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])param);
        String personid = null;
        try {
            while (iRowSet.next()) {
                personid = iRowSet.getString("FPERSONID");
                map.put(personid, personid);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)iRowSet, null, null);
        }
        return map;
    }

    private Map getCurrentDynamicPerson(Context ctx, String tablename) throws BOSException, EASBizException {
        HashMap<String, String> map = new HashMap<String, String>();
        if (tablename == null || tablename.equalsIgnoreCase("")) {
            return map;
        }
        String sql = " SELECT FPERSONID FROM " + tablename + "  ";
        IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        String personid = null;
        try {
            while (iRowSet.next()) {
                personid = iRowSet.getString("FPERSONID");
                map.put(personid, personid);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)iRowSet, null, null);
        }
        return map;
    }

    private void doPerson(Context ctx, CmpSchemePersonCollection col, CmpSchemeInfo infoCmpScheme, String tableName) throws BOSException, EASBizException {
        if (col == null || col.size() == 0) {
            return;
        }
        ArrayList<CmpSchemePersonInfo> lstAddPerson = new ArrayList<CmpSchemePersonInfo>();
        ArrayList<CmpSchemePersonInfo> lstDeletePerson = new ArrayList<CmpSchemePersonInfo>();
        ArrayList<CmpSchemePersonInfo> lstUpdatePerson = new ArrayList<CmpSchemePersonInfo>();
        Iterator itr = col.iterator();
        CmpSchemePersonInfo info = null;
        while (itr.hasNext()) {
            info = (CmpSchemePersonInfo)itr.next();
            if (info.getDataState() == 10) {
                lstAddPerson.add(info);
                continue;
            }
            if (info.getDataState() == 30) {
                lstUpdatePerson.add(info);
                continue;
            }
            if (info.getDataState() != 20) continue;
            lstDeletePerson.add(info);
        }
        this.addSchemePerson(ctx, lstAddPerson, infoCmpScheme, tableName);
        this.updateSchemePerson(ctx, lstUpdatePerson, infoCmpScheme, tableName);
        this.deleteFromSchemePerson(ctx, lstDeletePerson, infoCmpScheme, tableName);
    }

    private void addSchemePerson(Context ctx, List lstAddPerson, CmpSchemeInfo infoCmpScheme, String tableName) throws BOSException, EASBizException {
        int size = lstAddPerson.size();
        if (size <= 0 || infoCmpScheme.getId() == null) {
            return;
        }
        ArrayList personList = new ArrayList();
        Connection conn = null;
        PreparedStatement ps1 = null;
        PreparedStatement ps2 = null;
        String personAddTableName = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            String fid = null;
            int fSortOrder = 0;
            int maxSequence = 0;
            String fCmpSchemeID = infoCmpScheme.getId().toString();
            String fPersonID = null;
            String fPeriod = infoCmpScheme.getCmpPeriod().getId().toString();
            int time = infoCmpScheme.getTime();
            String strAddSchemePerson = " INSERT INTO T_HR_CMPSCHEMEPERSON(FID,FSortOrder,FCmpSchemeID,FPersonID,FADMINORGUNITID,FPositionID,FISDELETE,FIsSyncOperate) VALUES(?,?,?,?,?,?,?,?) ";
            ps1 = conn.prepareStatement(strAddSchemePerson);
            if (tableName != null) {
                String strAddHorTablePerson = " INSERT INTO " + tableName + "(FPersonID,FSequence,FPERIOD,FADMINORGUNITID,FPositionID,fTime,FCalType) VALUES(?,?,?,?,?,?,?) ";
                ps2 = conn.prepareStatement(strAddHorTablePerson);
            }
            ArrayList<String> tempList = new ArrayList<String>();
            for (int i = 0; i < size; ++i) {
                fPersonID = ((CmpSchemePersonInfo)lstAddPerson.get(i)).getPerson().getId().toString();
                tempList.add(fPersonID);
            }
            String sql = "delete from t_hr_cmpSchemePerson where fcmpschemeid='" + infoCmpScheme.getId() + "' ";
            String tempSql = null;
            String tempSql1 = null;
            if (size > 100) {
                personAddTableName = HRTableTools.createPersonTempTable(ctx, tempList, "FPersonID");
                tempSql = sql + " and fpersonid in (select FpersonID from " + personAddTableName + ")";
                if (tableName != null) {
                    tempSql1 = "DELETE FROM " + tableName + " where fpersonid in (select FpersonID from " + personAddTableName + ")";
                }
            } else {
                tempSql = sql + " and fpersonid in " + CompUtils.getStrFromList(tempList);
                if (tableName != null) {
                    tempSql1 = "DELETE FROM " + tableName + " where fpersonid in " + CompUtils.getStrFromList(tempList);
                }
            }
            DbUtil.execute((Context)ctx, (String)tempSql);
            if (tempSql1 != null) {
                DbUtil.execute((Context)ctx, tempSql1);
            }
            Map mapSchemePerson = this.getCurrentSchemePerson(ctx, infoCmpScheme.getId().toString());
            Map mapDynamicPerson = this.getCurrentDynamicPerson(ctx, infoCmpScheme.getHorTableName());
            CmpSchemePersonInfo info = null;
            int schemeCount = 0;
            int horTableCount = 0;
            ArrayList<String> tempList1 = new ArrayList<String>();
            for (int i = 0; i < size; ++i) {
                info = (CmpSchemePersonInfo)lstAddPerson.get(i);
                fid = BOSUuid.create((BOSObjectType)info.getBOSType()).toString();
                fSortOrder = info.getSortOrder();
                fPersonID = info.getPerson().getId().toString();
                tempList1.add(fPersonID);
                if (mapSchemePerson.get(fPersonID) == null) {
                    ps1.setString(1, fid);
                    ps1.setInt(2, fSortOrder);
                    ps1.setString(3, fCmpSchemeID);
                    ps1.setString(4, fPersonID);
                    if (info.getAdminOrgUnit() != null && info.getAdminOrgUnit().getId() != null) {
                        ps1.setString(5, info.getAdminOrgUnit().getId().toString());
                    } else {
                        ps1.setNull(5, 12);
                    }
                    if (info.getPosition() != null && info.getPosition().getId() != null) {
                        ps1.setString(6, info.getPosition().getId().toString());
                    } else {
                        ps1.setNull(6, 12);
                    }
                    ps1.setInt(7, 0);
                    ps1.setBoolean(8, info.getBoolean("isSyncOperate"));
                    ps1.addBatch();
                    if (++schemeCount == 8000) {
                        personList.addAll(tempList1);
                        tempList.clear();
                        ps1.executeBatch();
                        ps1.clearBatch();
                        schemeCount = 0;
                    }
                }
                if (tableName == null || mapDynamicPerson.get(fPersonID) != null) continue;
                ++maxSequence;
                ps2.setString(1, fPersonID);
                ps2.setInt(2, fSortOrder);
                ps2.setString(3, fPeriod);
                if (info.getAdminOrgUnit() != null && info.getAdminOrgUnit().getId() != null) {
                    ps2.setString(4, info.getAdminOrgUnit().getId().toString());
                } else {
                    ps2.setNull(4, 12);
                }
                if (info.getPosition() != null && info.getPosition().getId() != null) {
                    ps2.setString(5, info.getPosition().getId().toString());
                } else {
                    ps2.setNull(5, 12);
                }
                ps2.setInt(6, time);
                ps2.setInt(7, 0);
                ps2.addBatch();
                if (++horTableCount != 8000) continue;
                ps2.executeBatch();
                ps2.clearBatch();
                horTableCount = 0;
            }
            if (horTableCount > 0) {
                ps2.executeBatch();
            }
            if (schemeCount > 0) {
                personList.addAll(tempList);
                ps1.executeBatch();
            }
            INewEmployee iNewEmp = NewEmployeeFactory.getLocalInstance((Context)ctx);
            iNewEmp.batchUpdateBusinessState(personList, 1);
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps1);
                SQLUtils.cleanup(ps2, (Connection)conn);
                HRTableTools.releaseTmpTable(ctx, personAddTableName);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps1);
        SQLUtils.cleanup((Statement)ps2, (Connection)conn);
        HRTableTools.releaseTmpTable(ctx, personAddTableName);
    }

    private void updateSchemePerson(Context ctx, List lstUpdatePerson, CmpSchemeInfo infoCmpScheme, String tableName) throws BOSException, EASBizException {
        Connection conn;
        PreparedStatement ps2;
        PreparedStatement ps1;
        block17: {
            if (lstUpdatePerson.size() <= 0) {
                return;
            }
            ps1 = null;
            ps2 = null;
            conn = null;
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                String fid = null;
                String fPersonID = null;
                String strUpdatePerson1 = " UPDATE T_HR_CMPSCHEMEPERSON SET FADMINORGUNITID=?,FPositionID=?,FIsSyncOperate=? WHERE FID=? ";
                ps1 = conn.prepareStatement(strUpdatePerson1);
                if (tableName != null) {
                    String strUpdatePerson2 = " UPDATE " + tableName + " SET FADMINORGUNITID=?,FPositionID=? WHERE FPERSONID=? ";
                    ps2 = conn.prepareStatement(strUpdatePerson2);
                }
                int count = 0;
                CmpSchemePersonInfo info = null;
                int size = lstUpdatePerson.size();
                for (int i = 0; i < size; ++i) {
                    info = (CmpSchemePersonInfo)lstUpdatePerson.get(i);
                    fid = info.getId().toString();
                    fPersonID = info.getPerson().getId().toString();
                    if (info.getAdminOrgUnit() != null && info.getAdminOrgUnit().getId() != null) {
                        ps1.setString(1, info.getAdminOrgUnit().getId().toString());
                    } else {
                        ps1.setNull(1, 12);
                    }
                    if (info.getPosition() != null && info.getPosition().getId() != null) {
                        ps1.setString(2, info.getPosition().getId().toString());
                    } else {
                        ps1.setNull(2, 12);
                    }
                    ps1.setBoolean(3, info.getBoolean("isSyncOperate"));
                    ps1.setString(4, fid);
                    ps1.addBatch();
                    ++count;
                    if (tableName != null) {
                        if (info.getAdminOrgUnit() != null && info.getAdminOrgUnit().getId() != null) {
                            ps2.setString(1, info.getAdminOrgUnit().getId().toString());
                        } else {
                            ps2.setNull(1, 12);
                        }
                        if (info.getPosition() != null && info.getPosition().getId() != null) {
                            ps2.setString(2, info.getPosition().getId().toString());
                        } else {
                            ps2.setNull(2, 12);
                        }
                        ps2.setString(3, fPersonID);
                        ps2.addBatch();
                    }
                    if (count != 8000) continue;
                    count = 0;
                    ps1.executeBatch();
                    ps1.clearBatch();
                    if (tableName == null) continue;
                    ps2.executeBatch();
                    ps2.clearBatch();
                }
                if (count <= 0) break block17;
                ps1.executeBatch();
                if (tableName != null) {
                    ps2.executeBatch();
                }
            }
            catch (SQLException e) {
                try {
                    throw new SQLDataException(e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(ps1);
                    SQLUtils.cleanup(ps2, (Connection)conn);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((Statement)ps1);
        SQLUtils.cleanup((Statement)ps2, (Connection)conn);
    }

    private void deleteFromSchemePerson(Context ctx, List lstDeletePerson, CmpSchemeInfo infoCmpScheme, String tableName) throws BOSException, EASBizException {
        block22: {
            if (lstDeletePerson.size() <= 0) {
                return;
            }
            Connection conn = null;
            PreparedStatement ps = null;
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                if (lstDeletePerson.size() == 0) break block22;
                if (lstDeletePerson.size() > 2000) {
                    CmpSchemePersonInfo temp = null;
                    String sql = " create TABLE aa (FID varchar(44) not null,FPersonID varchar(44) not null ) ";
                    String temporaryTableName = null;
                    try {
                        temporaryTableName = TempTablePool.getInstance((Context)ctx).createTempTable(sql);
                    }
                    catch (Exception e) {
                        throw new BOSException();
                    }
                    StringBuffer sbInsert = new StringBuffer(512);
                    sbInsert.append(" INSERT INTO ").append(temporaryTableName).append("(FID,FPersonID)VALUES (?,?)");
                    int count = 0;
                    ps = conn.prepareStatement(sbInsert.toString());
                    int size = lstDeletePerson.size();
                    for (int i = 0; i < size; ++i) {
                        temp = (CmpSchemePersonInfo)lstDeletePerson.get(i);
                        ps.setString(1, temp.getId().toString());
                        ps.setString(2, temp.getPerson().getId().toString());
                        ps.addBatch();
                        if (++count != 8000) continue;
                        ps.executeBatch();
                        ps.clearBatch();
                        count = 0;
                    }
                    if (count > 0) {
                        ps.executeBatch();
                    }
                    if (infoCmpScheme.getHisTableName() == null) {
                        StringBuffer strDelete1 = new StringBuffer("DELETE FROM T_HR_CMPSCHEMEPERSON WHERE FID IN (");
                        strDelete1.append(" select FID from ").append(temporaryTableName).append(")");
                        DbUtil.execute((Context)ctx, (String)strDelete1.toString());
                    } else {
                        StringBuffer sql1 = new StringBuffer();
                        sql1.append("select fpersonid from ");
                        sql1.append(infoCmpScheme.getHisTableName());
                        sql1.append(" where fpersonid in (");
                        sql1.append(" select FPersonID from ").append(temporaryTableName).append(")");
                        StringBuffer strUpdate = new StringBuffer(" UPDATE T_HR_CMPSCHEMEPERSON SET FISDELETE = 1 WHERE FPERSONID IN (");
                        strUpdate.append(sql1).append(")");
                        strUpdate.append(" and fcmpschemeid = '");
                        strUpdate.append(infoCmpScheme.getId().toString());
                        strUpdate.append("'");
                        DbUtil.execute((Context)ctx, (String)strUpdate.toString());
                        StringBuffer strDelete1 = new StringBuffer("DELETE FROM T_HR_CMPSCHEMEPERSON WHERE FPERSONID IN (");
                        strDelete1.append("select fpersonid from ").append(temporaryTableName).append(" where fpersonid not in (");
                        strDelete1.append(sql1).append("))");
                        strDelete1.append(" and fcmpschemeid = '");
                        strDelete1.append(infoCmpScheme.getId().toString());
                        strDelete1.append("'");
                        DbUtil.execute((Context)ctx, (String)strDelete1.toString());
                    }
                    if (tableName != null) {
                        StringBuffer strDelete2 = new StringBuffer(" DELETE FROM " + tableName + " WHERE FPersonID IN(");
                        strDelete2.append(" select FPersonID from ").append(temporaryTableName).append(")");
                        DbUtil.execute((Context)ctx, (String)strDelete2.toString());
                    }
                    TempTablePool.getInstance((Context)ctx).releaseTable(temporaryTableName);
                    break block22;
                }
                HashSet<String> schemePerson = new HashSet<String>();
                HashSet<String> person = new HashSet<String>();
                CmpSchemePersonInfo temp = null;
                int size = lstDeletePerson.size();
                for (int i = 0; i < size; ++i) {
                    temp = (CmpSchemePersonInfo)lstDeletePerson.get(i);
                    schemePerson.add(temp.getId().toString());
                    person.add(temp.getPerson().getId().toString());
                }
                if (infoCmpScheme.getHisTableName() == null) {
                    StringBuffer strDelete1 = new StringBuffer("DELETE FROM T_HR_CMPSCHEMEPERSON WHERE FID IN ");
                    strDelete1.append(CompUtils.getStrFromSet(schemePerson));
                    DbUtil.execute((Context)ctx, (String)strDelete1.toString());
                    if (tableName != null) {
                        StringBuffer strDelete2 = new StringBuffer(" DELETE FROM " + tableName + " WHERE FPersonID IN ");
                        strDelete2 = strDelete2.append(CompUtils.getStrFromSet(person));
                        DbUtil.execute((Context)ctx, (String)strDelete2.toString());
                    }
                } else {
                    StringBuffer sql = new StringBuffer();
                    sql.append("select distinct fpersonid from ");
                    sql.append(infoCmpScheme.getHisTableName());
                    sql.append(" where fpersonid in ");
                    sql.append(CompUtils.getStrFromSet(person));
                    IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                    String personID = null;
                    HashSet<String> updatePerson = new HashSet<String>();
                    HashSet<String> person1 = new HashSet<String>();
                    person1.addAll(person);
                    while (rowSet.next()) {
                        personID = rowSet.getString("fpersonid");
                        if (!person.contains(personID)) continue;
                        updatePerson.add(personID);
                        person.remove(personID);
                    }
                    if (updatePerson.size() > 0) {
                        StringBuffer strUpdate = new StringBuffer(" UPDATE T_HR_CMPSCHEMEPERSON SET FISDELETE = 1 WHERE FPERSONID IN ");
                        strUpdate.append(CompUtils.getStrFromSet(updatePerson));
                        strUpdate.append(" and fcmpschemeid = '");
                        strUpdate.append(infoCmpScheme.getId().toString());
                        strUpdate.append("'");
                        DbUtil.execute((Context)ctx, (String)strUpdate.toString());
                    }
                    if (person.size() > 0) {
                        StringBuffer strDelete1 = new StringBuffer("DELETE FROM T_HR_CMPSCHEMEPERSON WHERE FPERSONID IN ");
                        strDelete1.append(CompUtils.getStrFromSet(person));
                        strDelete1.append(" and fcmpschemeid = '");
                        strDelete1.append(infoCmpScheme.getId().toString());
                        strDelete1.append("'");
                        DbUtil.execute((Context)ctx, (String)strDelete1.toString());
                    }
                    if (tableName != null) {
                        StringBuffer strDelete2 = new StringBuffer(" DELETE FROM " + tableName + " WHERE FPersonID IN ");
                        strDelete2 = strDelete2.append(CompUtils.getStrFromSet(person1));
                        DbUtil.execute((Context)ctx, (String)strDelete2.toString());
                    }
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            finally {
                SQLUtils.cleanup(ps, (Connection)conn);
            }
        }
    }

    private void doItem(Context ctx, CmpSchemeItemCollection col, CmpSchemeInfo infoCmpScheme) throws BOSException, EASBizException {
        ArrayList<CmpSchemeItemInfo> lstDeleteItem;
        ArrayList<CmpSchemeItemInfo> lstAddItem;
        Statement ps2;
        PreparedStatement ps1;
        Connection conn;
        block25: {
            String fid;
            if (col == null) {
                return;
            }
            conn = null;
            PreparedStatement ps = null;
            ps1 = null;
            ps2 = null;
            String strSql = " SELECT FID FROM T_HR_CMPSCHEMEITEM WHERE FCMPSCHEMEID=? AND FCMPITEMID=?";
            lstAddItem = new ArrayList<CmpSchemeItemInfo>();
            ArrayList<CmpSchemeItemInfo> lstUpdateItem = new ArrayList<CmpSchemeItemInfo>();
            lstDeleteItem = new ArrayList<CmpSchemeItemInfo>();
            Iterator itr = col.iterator();
            CmpSchemeItemInfo info = null;
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                ps = conn.prepareStatement(strSql);
                while (itr.hasNext()) {
                    info = (CmpSchemeItemInfo)itr.next();
                    info.setCmpScheme(infoCmpScheme);
                    info.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
                    if (info.getDataState() == 10) {
                        fid = null;
                        ps.setString(1, infoCmpScheme.getId().toString());
                        ps.setString(2, info.getCmpItem().getId().toString());
                        ResultSet iRowSet = ps.executeQuery();
                        while (iRowSet.next()) {
                            fid = iRowSet.getString("FID");
                        }
                        SQLUtils.cleanup((ResultSet)iRowSet, null, null);
                        if (fid != null) {
                            info.setId(BOSUuid.read((String)fid));
                            info.setIsDelete(false);
                            lstUpdateItem.add(info);
                            continue;
                        }
                        lstAddItem.add(info);
                        continue;
                    }
                    if (info.getDataState() == 30) {
                        lstUpdateItem.add(info);
                        continue;
                    }
                    if (info.getDataState() != 20) continue;
                    lstDeleteItem.add(info);
                }
            }
            catch (SQLException e) {
                try {
                    throw new SQLDataException(e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(ps, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)ps, (Connection)conn);
            fid = null;
            int fSortOrder = 0;
            int fCalLevel = 0;
            String fCmpItemID = null;
            String fCmpSchemeID = null;
            String fFormulaID = null;
            try {
                StringBuffer strDelete1;
                int i;
                int size;
                String str;
                conn = EJBFactory.getConnection((Context)ctx);
                if (lstAddItem.size() > 0) {
                    str = " INSERT INTO T_HR_CMPSCHEMEITEM(FID,FCalLevel,FSortOrder,FCmpItemID,FCmpSchemeID,FLastUpdateTime,FFormulaID,FIsValueKeep,FIsDelete,FIsVisible,FIsForGrant,FIsGroupStat,FisBGStat,fIsCollect,FIsNotVisibleZero,FIsEndInputEdit,FIsSignDataChange) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
                    ps1 = conn.prepareStatement(str);
                    size = lstAddItem.size();
                    for (i = 0; i < size; ++i) {
                        info = (CmpSchemeItemInfo)lstAddItem.get(i);
                        fid = BOSUuid.create((BOSObjectType)info.getBOSType()).toString();
                        ps1.setString(1, fid);
                        fCalLevel = info.getCalLevel();
                        ps1.setInt(2, fCalLevel);
                        fSortOrder = info.getSortOrder();
                        ps1.setInt(3, fSortOrder);
                        fCmpItemID = info.getCmpItem().getId().toString();
                        ps1.setString(4, fCmpItemID);
                        fCmpSchemeID = info.getCmpScheme().getId().toString();
                        ps1.setString(5, fCmpSchemeID);
                        ps1.setTimestamp(6, info.getLastUpdateTime());
                        if (info.getCmpItemFormula() != null && info.getCmpItemFormula().getId() != null) {
                            fFormulaID = info.getCmpItemFormula().getId().toString();
                            ps1.setString(7, fFormulaID);
                        } else {
                            ps1.setNull(7, 12);
                        }
                        ps1.setBoolean(8, info.isIsValueKeep());
                        ps1.setBoolean(9, false);
                        ps1.setBoolean(10, info.isIsVisible());
                        ps1.setBoolean(11, info.isIsForGrant());
                        ps1.setBoolean(12, info.isIsGroupStat());
                        ps1.setBoolean(13, info.isIsBGStat());
                        ps1.setBoolean(14, info.isIsCollect());
                        ps1.setBoolean(15, info.isIsNotVisibleZero());
                        ps1.setBoolean(16, info.isIsEndInputEdit());
                        ps1.setBoolean(17, info.isIsSignDataChange());
                        ps1.addBatch();
                    }
                    ps1.executeBatch();
                    SQLUtils.cleanup(null, (Statement)ps1, null);
                }
                if (lstUpdateItem.size() > 0) {
                    str = " UPDATE T_HR_CMPSCHEMEITEM SET FSortOrder=?,FLastUpdateTime=?,FFormulaID=?,FIsValueKeep=?,FIsDelete=?,FIsVisible=?,FIsForGrant=?,FIsGroupStat=?,FisBGStat=? ,fIsCollect=?, FIsNotVisibleZero=?, FIsEndInputEdit=?, FISSIGNDATACHANGE=? WHERE FID=? ";
                    ps1 = conn.prepareStatement(str);
                    size = lstUpdateItem.size();
                    for (i = 0; i < size; ++i) {
                        info = (CmpSchemeItemInfo)lstUpdateItem.get(i);
                        fid = info.getId().toString();
                        ps1.setString(14, fid);
                        fSortOrder = info.getSortOrder();
                        ps1.setInt(1, fSortOrder);
                        fCmpItemID = info.getCmpItem().getId().toString();
                        ps1.setTimestamp(2, info.getLastUpdateTime());
                        if (info.getCmpItemFormula() != null && info.getCmpItemFormula().getId() != null) {
                            fFormulaID = info.getCmpItemFormula().getId().toString();
                            ps1.setString(3, fFormulaID);
                        } else {
                            ps1.setNull(3, 12);
                        }
                        ps1.setBoolean(4, info.isIsValueKeep());
                        ps1.setBoolean(5, info.isIsDelete());
                        ps1.setBoolean(6, info.isIsVisible());
                        ps1.setBoolean(7, info.isIsForGrant());
                        ps1.setBoolean(8, info.isIsGroupStat());
                        ps1.setBoolean(9, info.isIsBGStat());
                        ps1.setBoolean(10, info.isIsCollect());
                        ps1.setBoolean(11, info.isIsNotVisibleZero());
                        ps1.setBoolean(12, info.isIsEndInputEdit());
                        ps1.setBoolean(13, info.isIsSignDataChange());
                        ps1.addBatch();
                    }
                    ps1.executeBatch();
                }
                if (lstDeleteItem.size() == 0) break block25;
                if (infoCmpScheme.getHorTableName() == null || infoCmpScheme.getHorTableName().equals("")) {
                    strDelete1 = new StringBuffer(" DELETE T_HR_CMPSCHEMEITEM  WHERE FID IN(");
                    size = lstDeleteItem.size();
                    for (i = 0; i < size; ++i) {
                        info = (CmpSchemeItemInfo)lstDeleteItem.get(i);
                        fid = info.getId().toString();
                        strDelete1.append("'");
                        strDelete1.append(fid);
                        strDelete1.append("',");
                    }
                    strDelete1.deleteCharAt(strDelete1.length() - 1);
                    strDelete1.append(") ");
                    DbUtil.execute((Context)ctx, (String)strDelete1.toString());
                    break block25;
                }
                strDelete1 = new StringBuffer(" UPDATE T_HR_CMPSCHEMEITEM SET FIsDelete=1,FFormulaID=null WHERE FID IN(");
                size = lstDeleteItem.size();
                for (i = 0; i < size; ++i) {
                    info = (CmpSchemeItemInfo)lstDeleteItem.get(i);
                    fid = info.getId().toString();
                    strDelete1.append("'");
                    strDelete1.append(fid);
                    strDelete1.append("',");
                }
                strDelete1.deleteCharAt(strDelete1.length() - 1);
                strDelete1.append(") ");
                DbUtil.execute((Context)ctx, (String)strDelete1.toString());
            }
            catch (SQLException e) {
                try {
                    throw new SQLDataException(e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(ps1, (Connection)conn);
                    SQLUtils.cleanup(ps2, (Connection)conn);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((Statement)ps1, (Connection)conn);
        SQLUtils.cleanup(ps2, (Connection)conn);
        this.doUpdateTableItem(ctx, lstAddItem, lstDeleteItem, infoCmpScheme);
    }

    private void doUpdateTableItem(Context ctx, List lstAddItem, List lstDelItem, CmpSchemeInfo infoCmpScheme) throws BOSException, EASBizException {
        String horTableName = infoCmpScheme.getHorTableName();
        String hisTableName = infoCmpScheme.getHisTableName();
        String futureTableName = infoCmpScheme.getFutureTableName();
        if (horTableName == null && hisTableName == null) {
            return;
        }
        if (lstAddItem == null || lstAddItem.size() < 1) {
            return;
        }
        CmpItemInfo infoCmpItem = null;
        HashSet<String> setID = new HashSet<String>();
        int size = lstAddItem.size();
        for (int i = 0; i < size; ++i) {
            infoCmpItem = ((CmpSchemeItemInfo)lstAddItem.get(i)).getCmpItem();
            if (infoCmpItem.getNumber().substring(0, 4).equalsIgnoreCase("FPer")) continue;
            setID.add(infoCmpItem.getId().toString());
        }
        if (setID.isEmpty()) {
            return;
        }
        ICmpItem iCmpItem = CmpItemFactory.getLocalInstance(ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", setID, CompareType.INCLUDE));
        evi.setFilter(filterInfo);
        SelectorItemCollection sic = evi.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("dataType"));
        sic.add(new SelectorItemInfo("decDigital"));
        sic.add(new SelectorItemInfo("length"));
        sic.add(new SelectorItemInfo("precisionType"));
        CmpItemCollection colCmpItem = iCmpItem.getCmpItemCollection(evi);
        try {
            ColumnMetasInfo infoColumnMetas = null;
            ArrayList<ColumnMetasInfo> lstAddColumns = new ArrayList<ColumnMetasInfo>();
            int size2 = colCmpItem.size();
            for (int i = 0; i < size2; ++i) {
                infoCmpItem = colCmpItem.get(i);
                infoColumnMetas = new ColumnMetasInfo();
                infoColumnMetas.setName(infoCmpItem.getNumber());
                infoColumnMetas.setDataType(HRSchemeUtils.getDataType(infoCmpItem.getDataType().getValue()));
                infoColumnMetas.setAllowNull(Boolean.TRUE);
                if (infoCmpItem.getNumber().equals("FSAL000")) {
                    infoColumnMetas.setDataType(HRSchemeUtils.getDataType(100));
                    infoColumnMetas.setPrecision(44);
                    infoColumnMetas.setLength(44);
                    infoColumnMetas.setAllowNull(Boolean.TRUE);
                    infoColumnMetas.setPrimaryKey(false);
                } else if (infoCmpItem.getDataType().equals((Object)ItemDataTypeEnum.CURRENCY)) {
                    infoColumnMetas.setPrecision(17);
                    infoColumnMetas.setScale(4);
                    infoColumnMetas.setLength(17);
                    infoColumnMetas.defaultValueExpr = SqlExpr.toExpr((int)0);
                } else if (infoCmpItem.getDataType().equals((Object)ItemDataTypeEnum.FLOAT)) {
                    infoColumnMetas.setPrecision(21);
                    infoColumnMetas.setScale(8);
                    infoColumnMetas.setLength(21);
                    infoColumnMetas.defaultValueExpr = SqlExpr.toExpr((int)0);
                } else if (infoCmpItem.getDataType().equals((Object)ItemDataTypeEnum.INT)) {
                    infoColumnMetas.setPrecision(infoCmpItem.getLength());
                    infoColumnMetas.setScale(infoCmpItem.getDecDigital());
                    infoColumnMetas.setLength(infoCmpItem.getLength());
                    infoColumnMetas.defaultValueExpr = SqlExpr.toExpr((int)0);
                } else {
                    infoColumnMetas.setPrecision(infoCmpItem.getLength());
                    infoColumnMetas.setScale(infoCmpItem.getDecDigital());
                    infoColumnMetas.setLength(infoCmpItem.getLength());
                }
                infoColumnMetas.setIntDataState(10);
                lstAddColumns.add(infoColumnMetas);
            }
            AdapterDynamicDBTable iDynamicDBTable = new AdapterDynamicDBTable();
            iDynamicDBTable.setContext(ctx);
            iDynamicDBTable.setListColumn(lstAddColumns);
            if (horTableName != null) {
                iDynamicDBTable.setTableName(horTableName);
                iDynamicDBTable.alter();
            }
            if (hisTableName != null) {
                iDynamicDBTable.setTableName(hisTableName);
                iDynamicDBTable.alter();
            }
            if (futureTableName != null) {
                iDynamicDBTable.setTableName(futureTableName);
                iDynamicDBTable.alter();
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            throw new BOSException((Throwable)e);
        }
    }

    protected boolean _updateEmpCmpSchmTable(Context ctx, String tableName, List lstColumn, List lstValue) throws BOSException, CmpSchemeException, EASBizException {
        StringBuffer sqlUpdate = new StringBuffer(" UPDATE " + tableName + " SET ");
        int countLine = lstColumn.size();
        DynamicTableInfo.ColumnInfo infoColumn = null;
        for (int i = 1; i < countLine; ++i) {
            infoColumn = (DynamicTableInfo.ColumnInfo)lstColumn.get(i);
            sqlUpdate.append(infoColumn.getColumnNumber() + "=? ,");
        }
        sqlUpdate.deleteCharAt(sqlUpdate.length() - 1);
        sqlUpdate.append(" WHERE FPersonID = ?");
        Iterator itr = lstValue.iterator();
        Object[] value = null;
        Object[] tempValue = null;
        while (itr.hasNext()) {
            value = (Object[])itr.next();
            tempValue = new Object[value.length];
            tempValue[countLine - 1] = value[0];
            for (int i = 0; i < countLine - 1; ++i) {
                tempValue[i] = value[i + 1];
            }
            DbUtil.execute((Context)ctx, (String)sqlUpdate.toString(), (Object[])tempValue);
        }
        return false;
    }

    @Override
    protected void _enableScheme(Context ctx, IObjectPK pk) throws BOSException, CmpSchemeException, EASBizException {
        if (pk == null) {
            return;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("cmpPeriod.*"));
        sic.add(new SelectorItemInfo("hrOrgUnit.id"));
        CmpSchemeInfo infoCmpScheme = this.getCmpSchemeInfo(ctx, pk, sic);
        int schemeState = infoCmpScheme.getEnable().getValue();
        if (schemeState == 1) {
            return;
        }
        if (schemeState == 0) {
            this.assign(ctx, infoCmpScheme);
        }
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)infoCmpScheme.getBOSType(), (IObjectPK)pk, (String)infoCmpScheme.getName(), (String)"cmpscheme_enable");
        if (infoCmpScheme.getHorTableName() != null) {
            if (infoCmpScheme.isIsTryScheme()) {
                return;
            }
            String sql = " UPDATE T_HR_CMPSCHEME SET FEnable=1,FIsDelete=0 WHERE FID=?";
            Object[] param = new Object[]{pk.toString()};
            DbUtil.execute((Context)ctx, (String)sql, (Object[])param);
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
            return;
        }
        if (infoCmpScheme.getCmpPeriod() == null) {
            throw new CmpSchemeException(CmpSchemeException.CMPSCHEME_NOTCMPPERRIOD);
        }
        String pkCmpPeriod = infoCmpScheme.getCmpPeriod().getId().toString();
        Connection conn = null;
        PreparedStatement ps1 = null;
        try {
            String tableName = this.getNewTableName(ctx);
            AdapterDynamicDBTable iDynamicDBTable = new AdapterDynamicDBTable(ctx, tableName, HRDynamicTableUtils.getSchemeDynamicTableInfosSchmItem(ctx, pk));
            iDynamicDBTable.create();
            HRCmpIndexUtils.createIndexForSCHM(ctx, tableName);
            CmpSchemePersonCollection col = this.getPerson(ctx, pk);
            conn = EJBFactory.getConnection((Context)ctx);
            if (col != null && col.size() > 0) {
                int maxSequence = 0;
                StringBuffer sqlInsertPerson = new StringBuffer(" INSERT INTO ");
                sqlInsertPerson.append(tableName);
                sqlInsertPerson.append("(");
                sqlInsertPerson.append("FPersonID");
                sqlInsertPerson.append(",");
                sqlInsertPerson.append("FSequence");
                sqlInsertPerson.append(",");
                sqlInsertPerson.append("FADMINORGUNITID");
                sqlInsertPerson.append(",");
                sqlInsertPerson.append("FPOSITIONID");
                sqlInsertPerson.append(",");
                sqlInsertPerson.append("FPERIOD");
                sqlInsertPerson.append(",");
                sqlInsertPerson.append("FTIME");
                sqlInsertPerson.append(",");
                sqlInsertPerson.append("FCalType");
                sqlInsertPerson.append(") VALUES(?,?,?,?,?,?,?) ");
                ps1 = conn.prepareStatement(sqlInsertPerson.toString());
                Iterator itr = col.iterator();
                CmpSchemePersonInfo info = null;
                PersonInfo infoPerson = null;
                while (itr.hasNext()) {
                    info = (CmpSchemePersonInfo)itr.next();
                    infoPerson = info.getPerson();
                    ps1.setString(1, infoPerson.getId().toString());
                    int n = ++maxSequence;
                    ++maxSequence;
                    ps1.setInt(2, n);
                    if (info.getAdminOrgUnit() != null && info.getAdminOrgUnit().getId() != null) {
                        ps1.setString(3, info.getAdminOrgUnit().getId().toString());
                    } else {
                        ps1.setNull(3, 12);
                    }
                    if (info.getPosition() != null && info.getPosition().getId() != null) {
                        ps1.setString(4, info.getPosition().getId().toString());
                    } else {
                        ps1.setNull(4, 12);
                    }
                    ps1.setString(5, pkCmpPeriod);
                    ps1.setInt(6, infoCmpScheme.getTime());
                    ps1.setInt(7, 0);
                    ps1.addBatch();
                }
                ps1.executeBatch();
            }
            if (!infoCmpScheme.isIsTryScheme()) {
                infoCmpScheme.setEnable(StateEnum.ENABLE);
            }
            infoCmpScheme.setHorTableName(tableName);
            Date date = new Date();
            date.setYear(1900);
            long time = date.getTime();
            Calendar d = Calendar.getInstance();
            d.setTime(new Timestamp(time));
            d.set(14, 0);
            infoCmpScheme.setLastUpdateTime(new Timestamp(d.getTime().getTime()));
            this.update(ctx, pk, (CoreBaseInfo)infoCmpScheme);
        }
        catch (Exception e) {
            try {
                throw new BOSException(e.getMessage(), e.getCause());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(null, ps1, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(null, ps1, (Connection)conn);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    private CmpSchemePersonCollection getPerson(Context ctx, IObjectPK pk) throws BOSException, CmpSchemeException, EASBizException {
        ICmpSchemePerson iCmpSchemePerson = CmpSchemePersonFactory.getLocalInstance(ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("cmpScheme.id", (Object)pk.toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("isDelete", (Object)0));
        filterInfo.setMaskString("#0 and #1");
        evi.setFilter(filterInfo);
        evi.getSelector().add(new SelectorItemInfo("*"));
        evi.getSelector().add(new SelectorItemInfo("adminOrgUnit.id"));
        evi.getSelector().add(new SelectorItemInfo("position.id"));
        return iCmpSchemePerson.getCmpSchemePersonCollection(evi);
    }

    @Override
    protected boolean _calculate(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        CmpSchemeInfo infoCmpScheme = this.getCmpSchemeInfo(ctx, "select *,cmpPeriod.* where id='" + pk.toString() + "'");
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)infoCmpScheme.getBOSType(), (IObjectPK)pk, (String)infoCmpScheme.getName(), (String)"cmpscheme_cal");
        if (infoCmpScheme.getAudit() == SchemeAuditedEnum.AUDITING || infoCmpScheme.getAudit() == SchemeAuditedEnum.AUDITEDPASS) {
            throw new CmpSchemeException(CmpSchemeException.CMPSCHEME_NOT_CALCULATE);
        }
        ICalCmpSchmFacade iCalCmpSchmFacade = CalCmpSchmFacadeFactory.getLocalInstance(ctx);
        iCalCmpSchmFacade.calculateEmpScheme(pk);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        return true;
    }

    @Override
    protected IObjectValue _valueCopy(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        String oqlCmpItem;
        CmpSchemeInfo infoCmpScheme = this.getCmpSchemeInfo(ctx, pk);
        ICmpSchemeItem iCmpSchemeItem = CmpSchemeItemFactory.getLocalInstance(ctx);
        CmpSchemeItemCollection colCmpSchemeItem = iCmpSchemeItem.getCmpSchemeItemCollection(oqlCmpItem = "select *,cmpItem.* where cmpScheme='" + pk.toString() + "'");
        if (colCmpSchemeItem != null && colCmpSchemeItem.size() > 0) {
            Iterator itr = colCmpSchemeItem.iterator();
            while (itr.hasNext()) {
                CmpSchemeItemInfo infoCmpSchemeItem = (CmpSchemeItemInfo)itr.next();
                infoCmpSchemeItem.setId(null);
            }
        }
        infoCmpScheme.setItems(colCmpSchemeItem);
        ICmpSchemePerson iCmpSchemePerson = CmpSchemePersonFactory.getLocalInstance(ctx);
        String oqlCmpPerson = "select *,person.* where cmpScheme='" + pk.toString() + "'";
        CmpSchemePersonCollection colCmpSchemePerson = iCmpSchemePerson.getCmpSchemePersonCollection(oqlCmpPerson);
        if (colCmpSchemePerson != null && colCmpSchemePerson.size() > 0) {
            Iterator itr = colCmpSchemePerson.iterator();
            while (itr.hasNext()) {
                CmpSchemePersonInfo infoCmpSchemePerson = (CmpSchemePersonInfo)itr.next();
                infoCmpSchemePerson.setId(null);
            }
        }
        infoCmpScheme.setPersons(colCmpSchemePerson);
        return infoCmpScheme;
    }

    @Override
    protected void _auditPass(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        if (id == null) {
            return;
        }
        ObjectUuidPK pkScheme = new ObjectUuidPK(id);
        ICmpScheme iCmpScheme = CmpSchemeFactory.getLocalInstance(ctx);
        CmpSchemeInfo infoCmpScheme = iCmpScheme.getCmpSchemeInfo(" select *,cmpPeriod.* where id='" + id.toString() + "'");
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)infoCmpScheme.getBOSType(), (IObjectPK)pkScheme, (String)infoCmpScheme.getName(), (String)"cmpscheme_audit");
        ISchemeFacade sch = SchemeFacadeFactory.getLocalInstance(ctx);
        sch.auditCmpScheme((IObjectPK)new ObjectUuidPK(id));
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    @Override
    protected void _aduitNotPass(Context ctx, BOSUuid cmpSchID) throws BOSException, EASBizException {
        if (cmpSchID == null) {
            return;
        }
        ObjectUuidPK pkScheme = new ObjectUuidPK(cmpSchID);
        ICmpScheme iCmpScheme = CmpSchemeFactory.getLocalInstance(ctx);
        CmpSchemeInfo infoCmpScheme = iCmpScheme.getCmpSchemeInfo(" select *,cmpPeriod.* where id='" + cmpSchID.toString() + "'");
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)infoCmpScheme.getBOSType(), (IObjectPK)pkScheme, (String)infoCmpScheme.getName(), (String)"cmpscheme_audit");
        ICmpScheme sch = CmpSchemeFactory.getLocalInstance(ctx);
        infoCmpScheme.setAudit(SchemeAuditedEnum.AUDITEDNOTPASS);
        sch.submit((CoreBaseInfo)infoCmpScheme);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    @Override
    protected void _auditInProcessing(Context ctx, BOSUuid cmpSchID) throws BOSException, EASBizException {
        String temp;
        if (cmpSchID == null) {
            return;
        }
        ObjectUuidPK pkScheme = new ObjectUuidPK(cmpSchID);
        ICmpScheme iCmpScheme = CmpSchemeFactory.getLocalInstance(ctx);
        CmpSchemeInfo infoCmpScheme = iCmpScheme.getCmpSchemeInfo(" select *,cmpPeriod.* where id='" + cmpSchID.toString() + "'");
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)infoCmpScheme.getBOSType(), (IObjectPK)pkScheme, (String)infoCmpScheme.getName(), (String)"cmpscheme_audit");
        ICmpScheme sch = CmpSchemeFactory.getLocalInstance(ctx);
        String userid = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String fromOrg = (String)ctx.get((Object)"hr_cmpSendByOrg");
        String functionName = "com.kingdee.eas.hr.compensation.EmpCompenTabFun";
        String operationName = "ActionSubmit";
        if (fromOrg != null && "yes".equals(fromOrg)) {
            functionName = "com.kingdee.eas.hr.compensation.CmpSchemeTabStatFun";
            operationName = "ActionSubmit";
            ctx.remove((Object)"hr_cmpSendByOrg");
        }
        if ((temp = EnactmentServiceProxy.getEnacementService((Context)ctx).findSubmitProcDef(userid, (IObjectValue)infoCmpScheme, functionName, operationName)) == null || temp.trim().equals("")) {
            throw new CmpSchemeException(CmpSchemeException.CMP_WFNOTENABLE);
        }
        infoCmpScheme.setAudit(SchemeAuditedEnum.AUDITING);
        sch.submit((CoreBaseInfo)infoCmpScheme);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    protected FilterInfo getFilterForCheckNumber(IObjectValue model) {
        FilterInfo filter = new FilterInfo();
        CmpSchemeInfo info = (CmpSchemeInfo)model;
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)info.getHrOrgUnit().getId().toString()));
        return filter;
    }

    @Override
    protected String _copyScheme(Context ctx, IObjectPK pkOld, Map mapParameter) throws BOSException, CmpSchemeException, EASBizException {
        Random ran = new Random();
        String strHZ = "_new" + ran.nextInt(1234);
        IObjectPK pkNew = this.copyCmpSchemeInfo(ctx, pkOld, strHZ, false);
        if (pkNew == null) {
            return null;
        }
        return pkNew.toString();
    }

    @Override
    protected String _copyTryScheme(Context ctx, String strCmpSchemeId) throws BOSException, EASBizException {
        Random ran = new Random();
        String strTryNewFlag = "_new" + ran.nextInt(1234);
        IObjectPK pkNew = this.copyCmpSchemeInfo(ctx, (IObjectPK)new ObjectUuidPK(strCmpSchemeId), strTryNewFlag, true);
        if (pkNew == null) {
            return null;
        }
        return pkNew.toString();
    }

    private IObjectPK copyCmpSchemeInfo(Context ctx, IObjectPK pkOld, String strNewFlag, boolean isTryScheme) throws BOSException, EASBizException {
        CmpSchemeInfo infoCmpSchemeOld = this.getCmpSchemeInfo(ctx, " select *,currency.id,cmpPeriod.id where id='" + pkOld.toString() + "'");
        CmpSchemeInfo infoCmpSchemeNew = new CmpSchemeInfo();
        infoCmpSchemeNew.setAudit(SchemeAuditedEnum.NOTAUDITED);
        infoCmpSchemeNew.setCurrency(infoCmpSchemeOld.getCurrency());
        infoCmpSchemeNew.setCmpPeriod(infoCmpSchemeOld.getCmpPeriod());
        if (isTryScheme) {
            infoCmpSchemeNew.setEnable(StateEnum.DISABLE);
            infoCmpSchemeNew.put("name", ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"45_CmpSchemeControllerBean", (Locale)LocaleUtils.locale_en_US) + infoCmpSchemeOld.getName() + strNewFlag, LocaleUtils.locale_en_US);
            infoCmpSchemeNew.put("name", ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"45_CmpSchemeControllerBean", (Locale)LocaleUtils.locale_zh_CN) + infoCmpSchemeOld.getName() + strNewFlag, LocaleUtils.locale_zh_CN);
            infoCmpSchemeNew.put("name", ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"45_CmpSchemeControllerBean", (Locale)LocaleUtils.locale_zh_TW) + infoCmpSchemeOld.getName() + strNewFlag, LocaleUtils.locale_zh_TW);
            infoCmpSchemeNew.setNumber("try_" + infoCmpSchemeOld.getNumber() + strNewFlag);
            infoCmpSchemeNew.setIsDelete(true);
            infoCmpSchemeNew.setIsTryScheme(true);
        } else {
            infoCmpSchemeNew.setEnable(StateEnum.UNENABLE);
            infoCmpSchemeNew.put("name", infoCmpSchemeOld.getName() + strNewFlag, LocaleUtils.locale_en_US);
            infoCmpSchemeNew.put("name", infoCmpSchemeOld.getName() + strNewFlag, LocaleUtils.locale_zh_CN);
            infoCmpSchemeNew.put("name", infoCmpSchemeOld.getName() + strNewFlag, LocaleUtils.locale_zh_TW);
            infoCmpSchemeNew.setNumber(infoCmpSchemeOld.getNumber() + strNewFlag);
        }
        infoCmpSchemeNew.setIsDisplayName(infoCmpSchemeOld.isIsDisplayName());
        infoCmpSchemeNew.setDescription(infoCmpSchemeOld.getDescription());
        infoCmpSchemeNew.setItems(null);
        infoCmpSchemeNew.setPersons(null);
        infoCmpSchemeNew.setCalCount(0);
        infoCmpSchemeNew.setHrOrgUnit(HRSchemeUtils.getServerHROrgUnitInfo(ctx));
        infoCmpSchemeNew.setAdminOrg(infoCmpSchemeOld.getAdminOrg());
        IObjectPK pkNew = super._addnew(ctx, (IObjectValue)infoCmpSchemeNew);
        IObjectPK logPK = null;
        if (isTryScheme) {
            logPK = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)infoCmpSchemeNew.getBOSType(), (IObjectPK)pkNew, (String)infoCmpSchemeNew.getName(), (String)"cmpTryScheme_copy");
        } else {
            logPK = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)infoCmpSchemeNew.getBOSType(), (IObjectPK)pkNew, (String)infoCmpSchemeNew.getName(), (String)"cmpscheme_copy");
            CmpSchemePersonCollection colCmpSchemePersonOld = null;
            ICmpSchemePerson iCmpSchemePerson = CmpSchemePersonFactory.getLocalInstance(ctx);
            colCmpSchemePersonOld = iCmpSchemePerson.getCmpSchemePersonCollection(" select sortOrder,person.id,adminOrgUnit.id,position.id,isSyncOperate  where cmpScheme.id='" + pkOld.toString() + "' and isDelete = 0 ");
            if (colCmpSchemePersonOld != null) {
                CmpSchemePersonCollection colCmpSchemePersonNew = new CmpSchemePersonCollection();
                CmpSchemePersonInfo infoCmpSchemePersonNew = null;
                CmpSchemePersonInfo infoCmpSchemePersonOld = null;
                int size = colCmpSchemePersonOld.size();
                for (int i = 0; i < size; ++i) {
                    infoCmpSchemePersonOld = colCmpSchemePersonOld.get(i);
                    infoCmpSchemePersonNew = new CmpSchemePersonInfo();
                    infoCmpSchemePersonNew.setDataState(10);
                    infoCmpSchemePersonNew.setSortOrder(infoCmpSchemePersonOld.getSortOrder());
                    infoCmpSchemePersonNew.setCmpScheme(infoCmpSchemeNew);
                    infoCmpSchemePersonNew.setPerson(infoCmpSchemePersonOld.getPerson());
                    infoCmpSchemePersonNew.setAdminOrgUnit(infoCmpSchemePersonOld.getAdminOrgUnit());
                    infoCmpSchemePersonNew.setPosition(infoCmpSchemePersonOld.getPosition());
                    infoCmpSchemePersonNew.setIsSyncOperate(infoCmpSchemePersonOld.isIsSyncOperate());
                    colCmpSchemePersonNew.add(infoCmpSchemePersonNew);
                }
                this.doPerson(ctx, colCmpSchemePersonNew, infoCmpSchemeNew, null);
            }
        }
        CmpSchemeItemCollection colCmpSchemeItemOld = null;
        ICmpSchemeItem iCmpSchemeItem = CmpSchemeItemFactory.getLocalInstance(ctx);
        colCmpSchemeItemOld = iCmpSchemeItem.getCmpSchemeItemCollection(" select *,cmpItem.id,cmpItemFormula.*,cmpItemFormula.hrOrgUnit.id,cmpItemFormula.CU.id  where isDelete = 0 and cmpScheme.id='" + pkOld.toString() + "'");
        if (colCmpSchemeItemOld != null) {
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            String hrOrgid = HRSchemeUtils.getServerHROrgUnitInfo(ctx).getId().toString();
            CmpFormulaInfo infoCmpFormula = new CmpFormulaInfo();
            boolean isCodingRule = iCodingRuleManager.isExist((IObjectValue)infoCmpFormula, hrOrgid);
            CmpSchemeItemInfo infoCmpSchemeItem = null;
            CmpSchemeItemCollection colCmpSchemeItemNew = new CmpSchemeItemCollection();
            ICmpFormula iCmpFormula = CmpFormulaFactory.getLocalInstance(ctx);
            int size = colCmpSchemeItemOld.size();
            for (int i = 0; i < size; ++i) {
                infoCmpSchemeItem = colCmpSchemeItemOld.get(i);
                infoCmpSchemeItem.setId(null);
                infoCmpSchemeItem.setDataState(10);
                infoCmpSchemeItem.setCmpScheme(infoCmpSchemeNew);
                infoCmpFormula = infoCmpSchemeItem.getCmpItemFormula();
                if (infoCmpFormula != null && infoCmpFormula.getIsPublic() != 1) {
                    infoCmpFormula.setId(null);
                    infoCmpFormula.setCmpShemeID(pkNew.toString());
                    if (isCodingRule) {
                        infoCmpFormula.setNumber(null);
                        infoCmpFormula.setNumber(iCodingRuleManager.getNumber((IObjectValue)infoCmpFormula, hrOrgid));
                    } else {
                        infoCmpFormula.setNumber(infoCmpFormula.getNumber() + strNewFlag);
                    }
                    IObjectPK pkFormula = iCmpFormula.addnew((CoreBaseInfo)infoCmpFormula);
                    infoCmpSchemeItem.setCmpItemFormula(infoCmpFormula);
                }
                colCmpSchemeItemNew.add(infoCmpSchemeItem);
            }
            this.doItem(ctx, colCmpSchemeItemNew, infoCmpSchemeNew);
        }
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        return pkNew;
    }

    @Override
    protected void _disableScheme(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (pk == null) {
            return;
        }
        CmpSchemeInfo info = this.getCmpSchemeInfo(ctx, pk);
        if (info.getAudit().getValue() == 20) {
            throw new EmpCmpSchmException(EmpCmpSchmException.CMPSCHEME_NOTDISABLE);
        }
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)info.getBOSType(), (IObjectPK)pk, (String)info.getName(), (String)"cmpscheme_disable");
        String sql = " UPDATE T_HR_CMPSCHEME SET FEnable=3 WHERE FID=?";
        Object[] param = new Object[]{pk.toString()};
        DbUtil.execute((Context)ctx, (String)sql, (Object[])param);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CmpSchemeInfo dataBaseInfo = (CmpSchemeInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)dataBaseInfo.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        String hrOrgId = null;
        hrOrgId = HRSchemeUtils.getServerHROrgUnitInfo(ctx) != null ? HRSchemeUtils.getServerHROrgUnitInfo(ctx).getId().toString() : dataBaseInfo.getHrOrgUnit().getId().toString();
        filterItem = new FilterItemInfo("HRORGUNIT.id", (Object)hrOrgId, CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (dataBaseInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)dataBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        if (super._exists(ctx, filter)) {
            String number = this._getPropertyAlias(ctx, dataBaseInfo, "number") + " \uff1a" + dataBaseInfo.getNumber();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{number});
        }
    }

    protected void _checkNameDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CmpSchemeInfo dataBaseInfo = (CmpSchemeInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("name", (Object)dataBaseInfo.getName(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        String hrOrgId = null;
        hrOrgId = HRSchemeUtils.getServerHROrgUnitInfo(ctx) != null ? HRSchemeUtils.getServerHROrgUnitInfo(ctx).getId().toString() : dataBaseInfo.getHrOrgUnit().getId().toString();
        filterItem = new FilterItemInfo("HRORGUNIT.id", (Object)hrOrgId, CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (dataBaseInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)dataBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        if (super._exists(ctx, filter)) {
            String name = this._getPropertyAlias(ctx, dataBaseInfo, "name") + " \uff1a" + dataBaseInfo.getName();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{name});
        }
    }

    @Override
    protected void _auditSubmitForStat(Context ctx, BOSUuid cmpSchemeId) throws BOSException, EASBizException {
        ctx.put((Object)"hr_cmpSendByOrg", (Object)"yes");
        this._auditInProcessing(ctx, cmpSchemeId);
    }

    @Override
    protected void _upgradeCmpData(Context ctx) throws BOSException, EASBizException {
        IRowSet result = null;
        String tableName = null;
        Connection conn = null;
        Statement stmt = null;
        Statement stmt1 = null;
        int dbType = -1;
        String sql = null;
        boolean hasResult = false;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.createStatement();
            stmt1 = conn.createStatement();
            dbType = KSqlUtil.getDbType((Connection)conn);
            StringBuffer sb = new StringBuffer(512);
            sb.append(" SELECT KSQL_TABNAME FROM KSQL_USERTABLES").append(" WHERE KSQL_TABNAME LIKE 'T_HR_SCHM%'").append(" and KSQL_TABNAME not in (");
            if (3 == dbType) {
                sb.append(" SELECT distinct SYSOBJ.name FROM SYSCOLUMNS SYSCOL ").append(" INNER JOIN SYSOBJECTS SYSOBJ ON SYSCOL.ID = SYSOBJ.ID ").append(" WHERE SYSCOL.NAME = 'FTIME' and ").append(" SYSOBJ.name LIKE 'T_HR_SCHM%' ");
            } else {
                sb.append(" select distinct T2.KSQL_TABNAME from KSQL_USERCOLUMNS T1 ").append(" INNER join KSQL_USERTABLES T2 on T1.KSQL_COL_TABNAME = T2.KSQL_TABNAME ").append(" where T1.KSQL_COL_NAME ='FTIME' and ").append(" T2.KSQL_TABNAME LIKE 'T_HR_SCHM%'");
            }
            sb.append(" ) ");
            result = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            int i = 0;
            String updateSql = null;
            while (result.next()) {
                hasResult = true;
                tableName = result.getString("KSQL_TABNAME");
                sql = "ALTER TABLE " + tableName + " ADD FTIME INT DEFAULT 1";
                updateSql = "update " + tableName + " set ftime = 1 where ftime is null";
                stmt.addBatch(sql);
                stmt1.addBatch(updateSql);
                if (++i != 500) continue;
                i = 0;
                stmt.executeBatch();
                stmt.clearBatch();
            }
            if (i > 0) {
                stmt.executeBatch();
                stmt.clearBatch();
            }
            if (hasResult && 3 == dbType) {
                stmt1.executeBatch();
                stmt1.clearBatch();
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e.getMessage());
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                SQLUtils.cleanup(stmt1, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        SQLUtils.cleanup((Statement)stmt1, (Connection)conn);
        IPEndInStatus pEndStatus = PEndInStatusFactory.getLocalInstance(ctx);
        pEndStatus.updatePeriodEndInputAuditData();
        if (!hasResult) {
            return;
        }
        sql = 3 == dbType ? "select obj.name TABNAME,idx.name INDEXNAME from SYSOBJECTS obj  inner JOIN sysindexes AS idx ON obj.id = idx.id  where obj.name like 'T_HR_SCHMHIS_%' and idx.name like 'UX_HR_SCHHIS_%'" : "select KSQL_INDNAME as indexName,KSQL_COL_TABNAME AS TABNAME from KSQL_INDEXES where KSQL_INDNAME like 'UX_HR_SCHHIS_%'";
        result = DbUtil.executeQuery((Context)ctx, (String)sql);
        String hisTableName = null;
        String indexName = null;
        try {
            int i = 0;
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.createStatement();
            while (result.next()) {
                hisTableName = result.getString("TABNAME");
                indexName = result.getString("INDEXNAME");
                if (StringUtils.isEmpty((String)hisTableName) || StringUtils.isEmpty((String)indexName)) continue;
                sql = " drop index " + hisTableName + "." + indexName;
                stmt.addBatch(sql);
                if (++i != 500) continue;
                i = 0;
                stmt.executeBatch();
                stmt.clearBatch();
            }
            if (i > 0) {
                stmt.executeBatch();
                stmt.clearBatch();
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        }
    }

    @Override
    protected int _getMaxTimeFromScheme(Context ctx, String cmpschemePK, String cmpPeriodPK) throws BOSException, EASBizException {
        CmpSchemeInfo cmpSchemeInfo = this.getCmpSchemeInfo(ctx, (IObjectPK)new ObjectUuidPK(cmpschemePK));
        String hisTableName = cmpSchemeInfo.getHisTableName();
        if (hisTableName == null) {
            return cmpSchemeInfo.getTime();
        }
        if (cmpSchemeInfo.getCmpPeriod().getId().toString().equals(cmpPeriodPK)) {
            return cmpSchemeInfo.getTime();
        }
        StringBuffer sb = new StringBuffer();
        sb.append("Select max(ftime) maxTime from ").append(hisTableName);
        sb.append(" where fperiod='").append(cmpPeriodPK).append("'");
        int maxTime = 0;
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        try {
            while (result.next()) {
                maxTime = result.getInt("maxTime");
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw new BOSException((Throwable)e);
        }
        return maxTime;
    }

    @Override
    protected Map _getPeriodsMaxTimes(Context ctx, String cmpSchemeID, IObjectCollection periodColl) throws BOSException, EASBizException {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        CmpSchemeInfo schemeInfo = this.getCmpSchemeInfo(ctx, (IObjectPK)new ObjectUuidPK(cmpSchemeID));
        CmpPeriodInfo periodInfo = null;
        StringBuffer periodIDs = new StringBuffer();
        for (int i = 0; i < periodColl.size(); ++i) {
            periodInfo = (CmpPeriodInfo)periodColl.getObject(i);
            map.put(periodInfo.getId().toString(), 1);
            if (periodIDs.length() > 0) {
                periodIDs.append(",");
            }
            periodIDs.append("'").append(periodInfo.getId()).append("'");
        }
        if (schemeInfo.getHorTableName() == null) {
            return map;
        }
        String horTableName = schemeInfo.getHorTableName();
        String hisTableName = schemeInfo.getHisTableName();
        StringBuffer sb = new StringBuffer();
        if (hisTableName == null) {
            sb.append("Select fperiod,ftime from ").append(horTableName);
        } else {
            sb.append(" SELECT TT.FPERIOD,max(TT.FTIME) AS FTIME FROM (").append("Select fperiod,ftime from ").append(horTableName).append(" union ").append(" select fperiod,max(ftime) as ftime from ").append(hisTableName).append(" group by fperiod ").append(")TT where TT.Fperiod in(").append(periodIDs).append(") group by TT.fperiod");
        }
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        try {
            String periodId = null;
            int time = 1;
            while (result.next()) {
                periodId = result.getString("FPERIOD");
                time = result.getInt("FTIME");
                if (!map.containsKey(periodId)) continue;
                map.put(periodId, time);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw new BOSException((Throwable)e);
        }
        return map;
    }

    @Override
    protected CmpSchemeCollection _getSchemeCollNoDataPermission(Context ctx, EntityViewInfo viewInfo) throws BOSException, EASBizException {
        return this.getSchemeCollNoDataPermission(ctx, viewInfo, false);
    }

    @Override
    protected CmpSchemeInfo _getSchemeNoDataPermission(Context ctx, String schemeID, boolean isGetItem) throws BOSException, EASBizException {
        IQueryExecutor exec = null;
        exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.compensation.app.CmpSchemeNoDataPermssionQuery"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)schemeID));
        HashSet hroSet = CompUtils.getHROrgUnitIds(ctx, "cmpScheme_view");
        EntityViewInfo viewInfo = CommonPermissionFacadeFactory.getLocalInstance(ctx).getHRsDataPermission(hroSet, "hrOrgUnit.id", "cmpScheme_view");
        if (viewInfo.getFilter() != null && viewInfo.getFilter().size() > 0) {
            filter.mergeFilter(viewInfo.getFilter(), "and");
            viewInfo.setFilter(filter);
        }
        exec.setObjectView(viewInfo);
        CmpSchemeInfo cmpschemeInfo = null;
        CmpPeriodInfo periodInfo = null;
        HROrgUnitInfo hro = null;
        IRowSet rowSet = exec.executeQuery();
        try {
            while (rowSet.next()) {
                cmpschemeInfo = new CmpSchemeInfo();
                cmpschemeInfo.setId(BOSUuid.read((String)rowSet.getString("id")));
                cmpschemeInfo.setNumber(rowSet.getString("number"));
                cmpschemeInfo.setName(rowSet.getString("name"));
                cmpschemeInfo.setTime(rowSet.getInt("time"));
                cmpschemeInfo.setEnable(StateEnum.getEnum(rowSet.getString("enable")));
                cmpschemeInfo.setIsDelete(rowSet.getBoolean("isDelete"));
                cmpschemeInfo.setAudit(SchemeAuditedEnum.getEnum(rowSet.getString("audit")));
                cmpschemeInfo.setHorTableName(rowSet.getString("horTableName"));
                cmpschemeInfo.setHisTableName(rowSet.getString("hisTableName"));
                periodInfo = new CmpPeriodInfo();
                periodInfo.setId(BOSUuid.read((String)rowSet.getString("cmpPeriod.id")));
                periodInfo.setNumber(rowSet.getString("cmpPeriod.number"));
                periodInfo.setName(rowSet.getString("cmpPeriod.name"));
                periodInfo.setBeginDate(rowSet.getDate("cmpPeriod.beginDate"));
                periodInfo.setEndDate(rowSet.getDate("cmpPeriod.endDate"));
                cmpschemeInfo.setCmpPeriod(periodInfo);
                hro = new HROrgUnitInfo();
                hro.setId(BOSUuid.read((String)rowSet.getString("hrOrgUnit.id")));
                cmpschemeInfo.setHrOrgUnit(hro);
                if (!isGetItem) continue;
                ICmpSchemeItem iCmpSchemeItem = CmpSchemeItemFactory.getLocalInstance(ctx);
                CmpSchemeItemCollection col = iCmpSchemeItem.getCmpSchemeItemCollection("select cmpItem.* where cmpScheme.id='" + cmpschemeInfo.getId() + "'");
                cmpschemeInfo.setItems(col);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
        }
        return cmpschemeInfo;
    }

    protected CmpSchemeCollection getSchemeCollNoDataPermission(Context ctx, EntityViewInfo viewInfo, boolean isGetItem) throws BOSException, EASBizException {
        HashSet hroSet = CompUtils.getHROrgUnitIds(ctx, "cmpScheme_view");
        FilterInfo filter = viewInfo.getFilter();
        EntityViewInfo view = CommonPermissionFacadeFactory.getLocalInstance(ctx).getHRsDataPermission(hroSet, "hrOrgUnit.id", "cmpScheme_view");
        if (view.getFilter() != null && view.getFilter().size() > 0) {
            filter.mergeFilter(view.getFilter(), "and");
        }
        IQueryExecutor exec = null;
        exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.compensation.app.CmpSchemeNoDataPermssionQuery"));
        exec.setObjectView(viewInfo);
        IRowSet rowSet = exec.executeQuery();
        CmpSchemeCollection coll = new CmpSchemeCollection();
        CmpSchemeInfo cmpschemeInfo = null;
        CmpPeriodInfo periodInfo = null;
        HROrgUnitInfo hro = null;
        try {
            while (rowSet.next()) {
                cmpschemeInfo = new CmpSchemeInfo();
                cmpschemeInfo.setId(BOSUuid.read((String)rowSet.getString("id")));
                cmpschemeInfo.setNumber(rowSet.getString("number"));
                cmpschemeInfo.setName(rowSet.getString("name"));
                cmpschemeInfo.setTime(rowSet.getInt("time"));
                cmpschemeInfo.setEnable(StateEnum.getEnum(rowSet.getString("enable")));
                cmpschemeInfo.setIsDelete(rowSet.getBoolean("isDelete"));
                cmpschemeInfo.setAudit(SchemeAuditedEnum.getEnum(rowSet.getString("audit")));
                cmpschemeInfo.setHorTableName(rowSet.getString("horTableName"));
                cmpschemeInfo.setHisTableName(rowSet.getString("hisTableName"));
                periodInfo = new CmpPeriodInfo();
                periodInfo.setId(BOSUuid.read((String)rowSet.getString("cmpPeriod.id")));
                periodInfo.setNumber(rowSet.getString("cmpPeriod.number"));
                periodInfo.setName(rowSet.getString("cmpPeriod.name"));
                periodInfo.setBeginDate(rowSet.getDate("cmpPeriod.beginDate"));
                periodInfo.setEndDate(rowSet.getDate("cmpPeriod.endDate"));
                cmpschemeInfo.setCmpPeriod(periodInfo);
                hro = new HROrgUnitInfo();
                hro.setId(BOSUuid.read((String)rowSet.getString("hrOrgUnit.id")));
                cmpschemeInfo.setHrOrgUnit(hro);
                if (isGetItem) {
                    ICmpSchemeItem iCmpSchemeItem = CmpSchemeItemFactory.getLocalInstance(ctx);
                    CmpSchemeItemCollection col = iCmpSchemeItem.getCmpSchemeItemCollection("select cmpItem.* where cmpScheme.id='" + cmpschemeInfo.getId() + "'");
                    cmpschemeInfo.setItems(col);
                }
                coll.add(cmpschemeInfo);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
        }
        return coll;
    }

    @Override
    protected CmpSchemeCollection _getSchemeCollNoDataPermission(Context ctx, EntityViewInfo viewInfo, HashSet hrIdSet) throws BOSException, EASBizException {
        CmpSchemeCollection coll = new CmpSchemeCollection();
        if (hrIdSet == null || hrIdSet != null && hrIdSet.size() == 0) {
            coll = this._getSchemeCollNoDataPermission(ctx, viewInfo);
        } else {
            EntityViewInfo view = CommonPermissionFacadeFactory.getLocalInstance(ctx).getHRsDataPermission(hrIdSet, "hrOrgUnit.id", "cmpScheme_view");
            FilterInfo filter = viewInfo.getFilter();
            if (view.getFilter() != null && view.getFilter().size() > 0) {
                filter.mergeFilter(view.getFilter(), "and");
            }
            IQueryExecutor exec = null;
            exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.compensation.app.CmpSchemeNoDataPermssionQuery"));
            exec.setObjectView(viewInfo);
            IRowSet rowSet = exec.executeQuery();
            CmpSchemeInfo cmpschemeInfo = null;
            CmpPeriodInfo periodInfo = null;
            HROrgUnitInfo hro = null;
            try {
                while (rowSet.next()) {
                    cmpschemeInfo = new CmpSchemeInfo();
                    cmpschemeInfo.setId(BOSUuid.read((String)rowSet.getString("id")));
                    cmpschemeInfo.setNumber(rowSet.getString("number"));
                    cmpschemeInfo.setName(rowSet.getString("name"));
                    cmpschemeInfo.setTime(rowSet.getInt("time"));
                    cmpschemeInfo.setEnable(StateEnum.getEnum(rowSet.getString("enable")));
                    cmpschemeInfo.setIsDelete(rowSet.getBoolean("isDelete"));
                    cmpschemeInfo.setAudit(SchemeAuditedEnum.getEnum(rowSet.getString("audit")));
                    cmpschemeInfo.setHorTableName(rowSet.getString("horTableName"));
                    cmpschemeInfo.setHisTableName(rowSet.getString("hisTableName"));
                    periodInfo = new CmpPeriodInfo();
                    periodInfo.setId(BOSUuid.read((String)rowSet.getString("cmpPeriod.id")));
                    periodInfo.setNumber(rowSet.getString("cmpPeriod.number"));
                    periodInfo.setName(rowSet.getString("cmpPeriod.name"));
                    periodInfo.setBeginDate(rowSet.getDate("cmpPeriod.beginDate"));
                    periodInfo.setEndDate(rowSet.getDate("cmpPeriod.endDate"));
                    cmpschemeInfo.setCmpPeriod(periodInfo);
                    hro = new HROrgUnitInfo();
                    hro.setId(BOSUuid.read((String)rowSet.getString("hrOrgUnit.id")));
                    cmpschemeInfo.setHrOrgUnit(hro);
                    coll.add(cmpschemeInfo);
                }
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage());
            }
        }
        return coll;
    }

    @Override
    protected void _auditPass1(Context ctx, BOSUuid id, BOSUuid personId) throws BOSException, EASBizException {
        this._auditPass(ctx, id);
        if (personId != null && !StringUtils.isEmpty((String)personId.toString())) {
            StringBuffer sql = new StringBuffer("");
            sql.append(" update T_HR_CMPSCHEME set FAuditPerson =(select top 1 fpersonid  from t_pm_user where fid ='" + personId.toString() + "')");
            sql.append(" where FID='" + id.toString() + "'");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
    }

    @Override
    protected PersonPositionCollection _getPersonPositionCollection(Context ctx, Date startDate, Date endDate, String cmpSchemeId) throws BOSException {
        String sql = "select fpersonid from T_HR_CMPSCHEMEPERSON where fcmpschemeid ='" + cmpSchemeId + "' and FISDelete = 0";
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)sql, CompareType.NOTINNER));
        filterInfo.getFilterItems().add(new FilterItemInfo("enterDate", (Object)startDate, CompareType.GREATER_EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("enterDate", (Object)endDate, CompareType.LESS_EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("person.employeeType.inService", (Object)1, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("person.employeeType.inService", (Object)4, CompareType.EQUALS));
        String sql2 = HRSchemeUtils.getAdminByUserRange(ctx);
        FilterItemInfo item1 = new FilterItemInfo("personDep.id", (Object)sql2, CompareType.INNER);
        filterInfo.getFilterItems().add(item1);
        sql = "select fpersonid from t_hr_personcmp where FIsPayPerson =1";
        filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)sql, CompareType.INNER));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        filterInfo.setMaskString("#0 and #1 and  #2 and (#3 or #4) and #5 and #6");
        SorterItemInfo sorterOrderItem = new SorterItemInfo("enterDate");
        sorterOrderItem.setSortType(SortType.DESCEND);
        evi.getSorter().add(sorterOrderItem);
        evi.getSelector().add(new SelectorItemInfo("person.id"));
        evi.getSelector().add(new SelectorItemInfo("person.name"));
        evi.getSelector().add(new SelectorItemInfo("person.number"));
        evi.getSelector().add(new SelectorItemInfo("person.gender"));
        evi.getSelector().add(new SelectorItemInfo("person.employeeType.id"));
        evi.getSelector().add(new SelectorItemInfo("person.employeeType.name"));
        evi.getSelector().add(new SelectorItemInfo("personDep.id"));
        evi.getSelector().add(new SelectorItemInfo("personDep.name"));
        evi.getSelector().add(new SelectorItemInfo("personDep.number"));
        evi.getSelector().add(new SelectorItemInfo("personDep.displayName"));
        evi.getSelector().add(new SelectorItemInfo("primaryPosition.id"));
        evi.getSelector().add(new SelectorItemInfo("primaryPosition.name"));
        evi.getSelector().add(new SelectorItemInfo("primaryPosition.number"));
        evi.getSelector().add(new SelectorItemInfo("enterDate"));
        PersonPositionCollection ppColl = PersonPositionFactory.getLocalInstance((Context)ctx).getPersonPositionCollection(evi);
        return ppColl;
    }

    @Override
    protected void _upgradeCmpTableAndData(Context ctx) throws BOSException, EASBizException {
        String oql = "select horTableName,hisTableName,futureTableName,calCount ";
        CmpSchemeCollection schemeColl = this.getCmpSchemeCollection(ctx, oql);
        if (schemeColl == null || schemeColl.size() <= 0) {
            return;
        }
        CmpSchemeInfo schemeInfo = null;
        String horTableName = null;
        String hisTableName = null;
        String futureTableName = null;
        int calCount = 0;
        int calType = 0;
        String sql = null;
        String updateSql = null;
        IRowSet rs = null;
        Connection conn = null;
        Statement stmt = null;
        Statement stmt1 = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.createStatement();
            stmt1 = conn.createStatement();
            for (int i = 0; i < schemeColl.size(); ++i) {
                schemeInfo = schemeColl.get(i);
                horTableName = schemeInfo.getHorTableName();
                hisTableName = schemeInfo.getHisTableName();
                futureTableName = schemeInfo.getFutureTableName();
                calCount = schemeInfo.getCalCount();
                if (!StringUtils.isEmpty((String)horTableName) && (rs = DbUtil.executeQuery((Context)ctx, (String)(sql = " SELECT 1 FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FCalType' AND KSQL_COL_TABNAME='" + horTableName + "'"))).size() == 0) {
                    sql = "ALTER TABLE " + horTableName + " ADD FCalType INT DEFAULT 0 ";
                    calType = calCount > 0 ? 1 : 0;
                    updateSql = "update " + horTableName + " set FCalType = " + calType;
                    stmt.addBatch(sql);
                    stmt1.addBatch(updateSql);
                }
                if (!StringUtils.isEmpty((String)hisTableName) && (rs = DbUtil.executeQuery((Context)ctx, (String)(sql = " SELECT 1 FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FCalType' AND KSQL_COL_TABNAME='" + hisTableName + "'"))).size() == 0) {
                    sql = "ALTER TABLE " + hisTableName + " ADD FCalType INT DEFAULT 0 ";
                    updateSql = "update " + hisTableName + " set FCalType = 1 ";
                    stmt.addBatch(sql);
                    stmt1.addBatch(updateSql);
                }
                if (StringUtils.isEmpty((String)futureTableName) || (rs = DbUtil.executeQuery((Context)ctx, (String)(sql = " SELECT 1 FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FCalType' AND KSQL_COL_TABNAME='" + futureTableName + "'"))).size() != 0) continue;
                sql = "ALTER TABLE " + futureTableName + " ADD FCalType INT DEFAULT 0 ";
                updateSql = "update " + futureTableName + " set FCalType = ( CASE FCalCount when 0 then 0 else 1 end)";
                stmt.addBatch(sql);
                stmt1.addBatch(updateSql);
            }
            stmt.executeBatch();
            stmt1.executeBatch();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e.getMessage());
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                SQLUtils.cleanup(stmt1, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        SQLUtils.cleanup((Statement)stmt1, (Connection)conn);
    }

    @Override
    protected void _updateCmpSchemePersonData(Context ctx, CmpSchemePersonCollection coll, String cmpSchemeID) throws BOSException, EASBizException {
        String oql = "select id,time,horTableName,cmpPeriod.id,cmpPeriod.number,hisTableName where id = '" + cmpSchemeID + "'";
        CmpSchemeInfo infoCmpScheme = CmpSchemeFactory.getLocalInstance(ctx).getCmpSchemeInfo(oql);
        String tableName = infoCmpScheme.getHorTableName();
        this.doPerson(ctx, coll, infoCmpScheme, tableName);
    }

    @Override
    protected void _updateSchemeXingDianColum(Context ctx) throws BOSException, EASBizException {
        String oql = "select horTableName,hisTableName,futureTableName,calCount ";
        CmpSchemeCollection schemeColl = this.getCmpSchemeCollection(ctx, oql);
        if (schemeColl == null || schemeColl.size() <= 0) {
            return;
        }
        CmpSchemeInfo schemeInfo = null;
        String horTableName = null;
        String hisTableName = null;
        String futureTableName = null;
        for (int i = 0; i < schemeColl.size(); ++i) {
            schemeInfo = schemeColl.get(i);
            horTableName = schemeInfo.getHorTableName();
            hisTableName = schemeInfo.getHisTableName();
            futureTableName = schemeInfo.getFutureTableName();
            if (!StringUtils.isEmpty((String)horTableName)) {
                this.alterTableXingdian(ctx, horTableName);
            }
            if (!StringUtils.isEmpty((String)hisTableName)) {
                this.alterTableXingdian(ctx, hisTableName);
            }
            if (StringUtils.isEmpty((String)futureTableName)) continue;
            this.alterTableXingdian(ctx, futureTableName);
        }
    }

    private void alterTableXingdian(Context ctx, String tableName) throws BOSException {
        String sql = " SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FSAL000' AND KSQL_COL_TABNAME='" + tableName + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        if (rs.size() <= 0) {
            return;
        }
        sql = "alter table " + tableName + " add FSAL000_bak varchar(44)";
        DbUtil.execute((Context)ctx, (String)sql);
        sql = "update " + tableName + " set FSAL000_bak = FSAL000";
        DbUtil.execute((Context)ctx, (String)sql);
        sql = "update " + tableName + " set FSAL000 = null";
        DbUtil.execute((Context)ctx, (String)sql);
        sql = "alter table " + tableName + " alter FSAL000 varchar(44)";
        DbUtil.execute((Context)ctx, (String)sql);
        sql = "update " + tableName + " set FSAL000 = FSAL000_bak";
        DbUtil.execute((Context)ctx, (String)sql);
        sql = "alter table " + tableName + " drop COLUMN FSAL000_bak";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    private void assign(Context ctx, CmpSchemeInfo infoCmpScheme) throws BOSException, EASBizException {
        String hrOrgUnitId = infoCmpScheme.getHrOrgUnit().getId().toString();
        String cmpSchemeId = infoCmpScheme.getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("select top 1 t1.FTableName from T_HR_EndInputPart t1,t_hr_cmpScheme t2  ").append(" where t1.FCmpSchemeID = t2.fid").append(" and t2.fhrOrgUnitID = ? and (t2.fid >? or t2.fid <?)");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{hrOrgUnitId, cmpSchemeId, cmpSchemeId});
        String tableName = null;
        try {
            while (rs.next()) {
                tableName = rs.getString(1);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (!StringUtils.isEmpty(tableName)) {
            EndInputPartInfo endInputPartInfo = new EndInputPartInfo();
            endInputPartInfo.setCmpScheme(infoCmpScheme);
            endInputPartInfo.setTableName(tableName);
            EndInputPartFactory.getLocalInstance(ctx).addnew(endInputPartInfo);
        }
    }
}

