/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.kscript.dom.expr.BinaryOpExpr;
import com.kingdee.bos.kscript.dom.expr.BoolExpr;
import com.kingdee.bos.kscript.dom.expr.CodeExpr;
import com.kingdee.bos.kscript.dom.expr.IdentifierExpr;
import com.kingdee.bos.kscript.dom.expr.IntExpr;
import com.kingdee.bos.kscript.dom.expr.MethodInvokeExpr;
import com.kingdee.bos.kscript.dom.expr.PropertyExpr;
import com.kingdee.bos.kscript.dom.expr.StringExpr;
import com.kingdee.bos.kscript.dom.stmt.CodeStmt;
import com.kingdee.bos.kscript.dom.stmt.ElseIfItem;
import com.kingdee.bos.kscript.dom.stmt.ExprStmt;
import com.kingdee.bos.kscript.dom.stmt.IfStmt;
import com.kingdee.bos.kscript.parser.KScriptParser;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.PropertyRefInfo;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SubEntityInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.query.util.QueryUtil;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.service.formula.builder.hr.IHRObject;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.sql.dom.SqlJoinedTableSource;
import com.kingdee.bos.sql.dom.SqlSelect;
import com.kingdee.bos.sql.dom.SqlSelectBase;
import com.kingdee.bos.sql.dom.SqlSelectItem;
import com.kingdee.bos.sql.dom.SqlTableSource;
import com.kingdee.bos.sql.dom.SqlTableSourceBase;
import com.kingdee.bos.sql.dom.SqlUpdate;
import com.kingdee.bos.sql.dom.SqlUpdateItem;
import com.kingdee.bos.sql.dom.expr.QueryExpr;
import com.kingdee.bos.sql.dom.expr.SqlBinaryOpExpr;
import com.kingdee.bos.sql.dom.expr.SqlExpr;
import com.kingdee.bos.sql.dom.expr.SqlIdentifierExpr;
import com.kingdee.bos.sql.dom.expr.SqlInSubQueryExpr;
import com.kingdee.bos.sql.dom.stmt.SqlUpdateStmt;
import com.kingdee.bos.sql.formater.DrSQLFormater;
import com.kingdee.bos.sql.formater.FormaterException;
import com.kingdee.bos.sql.parser.SelectParser;
import com.kingdee.bos.sql.parser.SqlExprParser;
import com.kingdee.eas.basedata.hraux.util.HRMulCUChangeUtil;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.person.Genders;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.EASDBException;
import com.kingdee.eas.hr.base.util.HRUtil;
import com.kingdee.eas.hr.compensation.CalEmpSchmException;
import com.kingdee.eas.hr.compensation.CmpSchemeItemCollection;
import com.kingdee.eas.hr.compensation.CmpSchemeItemFactory;
import com.kingdee.eas.hr.compensation.CompenItemFormuleException;
import com.kingdee.eas.hr.compensation.EmpCompenseException;
import com.kingdee.eas.hr.compensation.FormulaCmpItemData;
import com.kingdee.eas.hr.compensation.ICmpSchemeItem;
import com.kingdee.eas.hr.compensation.ITaxRateList;
import com.kingdee.eas.hr.compensation.TaxRateListCollection;
import com.kingdee.eas.hr.compensation.TaxRateListFactory;
import com.kingdee.eas.hr.compensation.app.AbstractFormulaFacadeControllerBean;
import com.kingdee.eas.hr.compensation.app.CmpItemTempTableUtil;
import com.kingdee.eas.hr.compensation.util.HRCmpItemUtils;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.hr.compensation.util.HRUtils;
import com.kingdee.eas.hr.compensation.util.TODOException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import com.kingdee.util.enums.EnumUtils;
import com.kingdee.util.enums.IntEnum;
import com.kingdee.util.enums.StringEnum;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FormulaFacadeControllerBean
extends AbstractFormulaFacadeControllerBean {
    boolean showTODOException = false;
    static final String KSQLMETHODLIST = "ABS,SQRT,ROUND,LEN,AVG,MAX,MIN,EXP,POWER,NOW,YEAR,MONTH,HOUR,MINUTE,SECOND,DAYOFMONTH,DAYOFWEEK,DAYOFYEAR,DATEDIFF";

    @Override
    public String _toKSQL(Context ctx, String formulaScript, IObjectPK schemePK) throws BOSException, EASBizException {
        if (formulaScript == null || formulaScript.length() == 0) {
            return "";
        }
        KScriptParser kParser = null;
        List stmtList = null;
        kParser = new KScriptParser(formulaScript);
        kParser.parse();
        stmtList = kParser.stmtList;
        this.scriptBizRuleCheck(stmtList);
        CodeStmt scriptStmt = (CodeStmt)stmtList.get(0);
        this.formatScript(scriptStmt, ctx);
        List updateExprList = null;
        try {
            if (scriptStmt instanceof ExprStmt) {
                updateExprList = this.trans_ExprStmt(ctx, (ExprStmt)scriptStmt, schemePK);
            } else if (scriptStmt instanceof IfStmt) {
                updateExprList = this.trans_IfStmt(ctx, (IfStmt)scriptStmt, schemePK);
            }
        }
        catch (FormaterException e) {
            throw new CompenItemFormuleException(CompenItemFormuleException.FORMAT_EXEC, e);
        }
        catch (ParserException e) {
            throw new CompenItemFormuleException(CompenItemFormuleException.PARSER_EXEC, e);
        }
        StringBuffer buff = new StringBuffer();
        String horTableName = this.getHorTableName(ctx, schemePK);
        if (updateExprList != null) {
            int size = updateExprList.size();
            for (int i = 0; i < size; ++i) {
                buff.append((String)updateExprList.get(i));
                buff.append(";");
            }
        }
        if (buff.lastIndexOf(";") > 0) {
            buff.deleteCharAt(buff.lastIndexOf(";"));
        }
        return this.trans_Method(buff.toString(), horTableName);
    }

    private String trans_Method(String sql, String tableName) {
        String regex = "MAX\\((\\w)*\\)|MIN\\((\\w)*\\)|AVG\\((\\w)*\\)";
        StringBuffer rst = new StringBuffer();
        String value = "";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(sql);
        String key = "";
        int start = 0;
        int end = 0;
        int currentPost = 0;
        while (m.find()) {
            start = m.start();
            end = m.end();
            key = sql.substring(start, end);
            value = "(SELECT " + key + " FROM " + tableName + " )";
            rst.append(sql.substring(currentPost, start));
            rst.append(value);
            currentPost = end;
        }
        rst.append(sql.substring(end));
        return rst.toString();
    }

    private StringBuffer roundExp(StringBuffer exp, int length) {
        StringBuffer rst = new StringBuffer();
        if (exp != null && exp.length() > 0) {
            rst.append(" ROUND(");
            rst.append(exp);
            rst.append(", ");
            rst.append(length);
            rst.append(" )");
        }
        return rst;
    }

    private List trans_ExprStmt(Context ctx, ExprStmt exprStmt, IObjectPK schemePK) throws EASBizException, BOSException, FormaterException, ParserException {
        int roundLength = this.getRoundLength();
        String horTableName = this.getHorTableName(ctx, schemePK);
        StringBuffer perItemRegex = this.getCmpPerItemList(ctx, schemePK);
        StringBuffer sql = new StringBuffer();
        BinaryOpExpr expr = (BinaryOpExpr)exprStmt.expr;
        SqlUpdate update = new SqlUpdate();
        SqlUpdateItem updItem = null;
        update.updateTable.name = horTableName;
        String updateColName = ((IdentifierExpr)expr.left).value;
        StringBuffer sb = new StringBuffer();
        expr.right.output(sb);
        sb = this.roundExp(sb, roundLength);
        String exprString = this.formatNumberAndComma(sb.toString());
        if (this.isDependPersonItem(exprStmt.expr, perItemRegex.toString())) {
            List cmpItemList = this.getCmpItemList(ctx, schemePK);
            Map personMap = this.getPersonSelectItems(ctx);
            SqlSelect subSelect = this.getSelectStmt(ctx, horTableName);
            subSelect.selectList.clear();
            StringBuffer subSelectExpr = new StringBuffer();
            StringBuffer cmpItemRegex = new StringBuffer();
            int size = cmpItemList.size();
            for (int i = 0; i < size; ++i) {
                cmpItemRegex.append((String)cmpItemList.get(i));
                if (i == size - 1) continue;
                cmpItemRegex.append("|");
            }
            Pattern p = Pattern.compile(cmpItemRegex.toString());
            Matcher m = p.matcher(exprString);
            int start = 0;
            String matcherString = "";
            while (m.find()) {
                matcherString = exprString.substring(m.start(), m.end());
                subSelectExpr.append(exprString.substring(start, m.start()));
                if (perItemRegex.toString().indexOf(matcherString) >= 0) {
                    subSelectExpr.append((String)personMap.get(matcherString));
                } else {
                    subSelectExpr.append(horTableName);
                    subSelectExpr.append(".");
                    subSelectExpr.append(matcherString);
                }
                start = m.end();
            }
            subSelectExpr.append(exprString.substring(start));
            SqlExprParser parser = new SqlExprParser(subSelectExpr.toString());
            subSelect.selectList.add(new SqlSelectItem(parser.expr(), ""));
            QueryExpr queryExpr = new QueryExpr((SqlSelectBase)subSelect);
            updItem = new SqlUpdateItem(updateColName, (SqlExpr)queryExpr);
        } else {
            SqlExprParser sqlParser = new SqlExprParser(exprString);
            updItem = new SqlUpdateItem(updateColName, sqlParser.expr());
        }
        update.updateList.add(updItem);
        SqlUpdateStmt updateStmt = new SqlUpdateStmt(update);
        DrSQLFormater formater = new DrSQLFormater(sql);
        formater.formatUpdateStmt(updateStmt);
        ArrayList<String> rst = new ArrayList<String>();
        rst.add(sql.toString());
        return rst;
    }

    private boolean isDependPersonItem(CodeExpr expr, String regex) {
        if (regex == null || regex.length() == 0) {
            return false;
        }
        StringBuffer buff = new StringBuffer();
        expr.output(buff);
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(buff.toString());
        return m.find();
    }

    private List trans_IfStmt(Context ctx, IfStmt ifStmt, IObjectPK schemePK) throws EASBizException, ParserException, BOSException, FormaterException {
        int roundLength = this.getRoundLength();
        String horTableName = this.getHorTableName(ctx, schemePK);
        StringBuffer perItemList = this.getCmpPerItemList(ctx, schemePK);
        ArrayList<String> rst = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        BinaryOpExpr elseCondition = null;
        SqlUpdate ifUpdate = new SqlUpdate();
        ExprStmt trueStmt = (ExprStmt)ifStmt.trueStmtList.get(0);
        ((BinaryOpExpr)trueStmt.expr).left.output(sql);
        String left = this.formatNumberAndComma(sql.toString());
        sql.delete(0, sql.length());
        ((BinaryOpExpr)trueStmt.expr).right.output(sql);
        sql = this.roundExp(sql, roundLength);
        SqlExprParser sqlParser = new SqlExprParser(this.formatNumberAndComma(sql.toString()));
        ifUpdate.updateList.add(new SqlUpdateItem(left, sqlParser.expr()));
        ifUpdate.updateTable.name = horTableName;
        ifUpdate.condition = this.toSqlCondition(ctx, ifStmt.testExpr, false, perItemList, horTableName);
        elseCondition = (BinaryOpExpr)ifStmt.testExpr;
        SqlUpdateStmt updateStmt = new SqlUpdateStmt(ifUpdate);
        sql.delete(0, sql.length());
        DrSQLFormater formater = new DrSQLFormater(sql);
        formater.formatUpdateStmt(updateStmt);
        rst.add(sql.toString());
        sql.delete(0, sql.length());
        int size = ifStmt.elseIfList.size();
        for (int i = 0; i < size; ++i) {
            sql.delete(0, sql.length());
            SqlUpdate update = new SqlUpdate();
            ElseIfItem item = (ElseIfItem)ifStmt.elseIfList.get(i);
            BinaryOpExpr testExpr = (BinaryOpExpr)item.testExpr;
            update.updateTable.name = horTableName;
            update.condition = this.toSqlCondition(ctx, (CodeExpr)testExpr, false, perItemList, horTableName);
            elseCondition = new BinaryOpExpr((CodeExpr)elseCondition, 8, (CodeExpr)testExpr);
            BinaryOpExpr expr = (BinaryOpExpr)((ExprStmt)item.stmtList.get((int)0)).expr;
            expr.left.output(sql);
            String updateCol = this.formatNumberAndComma(sql.toString());
            sql.delete(0, sql.length());
            expr.right.output(sql);
            sql = this.roundExp(sql, roundLength);
            sqlParser = new SqlExprParser(this.formatNumberAndComma(sql.toString()));
            update.updateList.add(new SqlUpdateItem(updateCol, sqlParser.expr()));
            sql.delete(0, sql.length());
            formater = new DrSQLFormater(sql);
            formater.formatUpdateStmt(updateStmt);
            rst.add(sql.toString());
        }
        if (ifStmt.elseStmtList.size() > 0) {
            SqlUpdate elseUpdate = new SqlUpdate();
            BinaryOpExpr elseExpr = (BinaryOpExpr)((ExprStmt)ifStmt.elseStmtList.get((int)0)).expr;
            sql.delete(0, sql.length());
            elseExpr.left.output(sql);
            String elseLeft = this.formatNumberAndComma(sql.toString());
            sql.delete(0, sql.length());
            elseExpr.right.output(sql);
            sql = this.roundExp(sql, roundLength);
            sqlParser = new SqlExprParser(this.formatNumberAndComma(sql.toString()));
            elseUpdate.updateList.add(new SqlUpdateItem(elseLeft, sqlParser.expr()));
            elseUpdate.updateTable.name = horTableName;
            elseUpdate.condition = this.toSqlCondition(ctx, (CodeExpr)elseCondition, true, perItemList, horTableName);
            sql.delete(0, sql.length());
            formater = new DrSQLFormater(sql);
            formater.formatUpdateStmt(updateStmt);
            rst.add(sql.toString());
        }
        return rst;
    }

    private SqlExpr toSqlCondition(Context ctx, CodeExpr expr, boolean isElseStmt, StringBuffer perItemList, String tableName) throws ParserException, EASBizException, BOSException, FormaterException {
        SqlSelect selectStmt = null;
        selectStmt = this.getSelectStmt(ctx, tableName);
        if (!this.isDependPersonItem(expr, perItemList.toString())) {
            if (isElseStmt) {
                SqlSelect subQuery = new SqlSelect();
                subQuery.selectList.add(new SqlSelectItem((SqlExpr)new SqlIdentifierExpr("FPersonID"), "FPersonID"));
                subQuery.tableSource = new SqlTableSource(tableName);
                subQuery.condition = this.ifTestExprToSqlExpr((BinaryOpExpr)expr);
                SqlInSubQueryExpr inSubQuery = new SqlInSubQueryExpr();
                inSubQuery.expr = new SqlIdentifierExpr("FPersonID");
                inSubQuery.not = true;
                inSubQuery.subQuery = subQuery;
                return inSubQuery;
            }
            return this.ifTestExprToSqlExpr((BinaryOpExpr)expr);
        }
        SqlInSubQueryExpr subQuery = new SqlInSubQueryExpr();
        subQuery.expr = new SqlIdentifierExpr("FPersonID");
        SqlSelect subQuerySelect = new SqlSelect();
        subQuerySelect.selectList = selectStmt.selectList;
        subQuerySelect.tableSource = selectStmt.tableSource;
        SqlBinaryOpExpr tempExpr = this.ifTestExprToSqlExpr((BinaryOpExpr)expr);
        SqlBinaryOpExpr sqlConditionExpr = this.formatPersonItem(ctx, tempExpr, perItemList.toString());
        tempExpr = null;
        SqlBinaryOpExpr whereExpr = new SqlBinaryOpExpr(selectStmt.condition, 7, (SqlExpr)sqlConditionExpr);
        subQuerySelect.condition = whereExpr;
        subQuery.subQuery = subQuerySelect;
        subQuery.not = isElseStmt;
        return subQuery;
    }

    private SqlBinaryOpExpr formatPersonItem(Context ctx, SqlBinaryOpExpr expr, String regex) throws ParserException, BOSException, FormaterException {
        if (expr == null) {
            return null;
        }
        StringBuffer buff = new StringBuffer();
        Map personItems = this.getPersonSelectItems(ctx);
        DrSQLFormater formater = new DrSQLFormater(buff);
        formater.formatBinaryOpExpr(expr, false);
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(buff.toString());
        String key = "";
        String value = "";
        int start = 0;
        int end = 0;
        int tag = 0;
        StringBuffer sql = new StringBuffer();
        while (m.find()) {
            start = m.start();
            end = m.end();
            key = buff.substring(start, end);
            value = (String)personItems.get(key);
            sql.append(buff.substring(tag, start));
            sql.append(value);
            tag = end;
        }
        sql.append(buff.substring(tag));
        SqlExprParser parser = new SqlExprParser(sql.toString());
        return (SqlBinaryOpExpr)parser.expr();
    }

    private SqlBinaryOpExpr ifTestExprToSqlExpr(BinaryOpExpr expr) throws ParserException {
        StringBuffer sb = new StringBuffer();
        expr.output(sb);
        String sql = this.formatNumberAndComma(sb.toString());
        sql = sql.replaceAll("\\|\\|", " OR ");
        sql = sql.replaceAll("\\&\\&", " AND ");
        sql = sql.replaceAll("==", "=");
        sql = sql.replaceAll("\"", "'");
        SqlExprParser parser = new SqlExprParser(sql);
        return (SqlBinaryOpExpr)parser.expr();
    }

    private String formatNumberAndComma(String kScript) {
        Pattern p = Pattern.compile("[\\d][.](\\d)*E(\\d)*");
        Matcher m = p.matcher(kScript);
        String temp = "";
        StringBuffer rst = new StringBuffer();
        int start = 0;
        int end = 0;
        int tag = 0;
        BigDecimal big = null;
        while (m.find()) {
            start = m.start();
            end = m.end();
            temp = kScript.substring(start, end);
            big = new BigDecimal(temp);
            rst.append(kScript.substring(tag, start));
            rst.append(big.toString());
            tag = end;
        }
        rst.append(kScript.substring(end));
        return rst.toString().replaceAll("\"", "'");
    }

    private String getHorTableName(Context ctx, IObjectPK schemePK) throws SQLDataException, CalEmpSchmException {
        Connection con = this.getConnection(ctx);
        ResultSet rs = null;
        PreparedStatement stm = null;
        String horTableName = "";
        try {
            String sql = "select FHorTableName from T_HR_CMPSCHEME  EMPSCH WHERE  EMPSCH.FID = ?";
            stm = con.prepareStatement(sql);
            stm.setString(1, schemePK.toString());
            rs = stm.executeQuery();
            while (rs.next()) {
                horTableName = rs.getString(1);
            }
        }
        catch (SQLException e) {
            try {
                throw new CalEmpSchmException(CalEmpSchmException.GET_HORTAB_EXEC);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup((Connection)con);
                SQLUtils.cleanup((Statement)stm);
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Connection)con);
        SQLUtils.cleanup((Statement)stm);
        SQLUtils.cleanup((ResultSet)rs);
        return horTableName;
    }

    private List getCmpItemList(Context ctx, IObjectPK schemePK) throws SQLDataException, CalEmpSchmException {
        ArrayList<String> cmpItemList = new ArrayList<String>();
        Connection con = this.getConnection(ctx);
        ResultSet rs = null;
        PreparedStatement stm = null;
        try {
            String sql = "select CMPITEM.FNUMBER from T_HR_CMPSCHEMEITEM SCHITEM , T_HR_CMPITEM CMPITEM  WHERE SCHITEM.FCMPITEMID = CMPITEM.FID AND SCHITEM.FCMPSCHEMEID = ?";
            stm = con.prepareStatement(sql);
            stm.setString(1, schemePK.toString());
            rs = stm.executeQuery();
            while (rs.next()) {
                cmpItemList.add(rs.getString(1));
            }
        }
        catch (SQLException e) {
            try {
                throw new CalEmpSchmException(CalEmpSchmException.GET_HORTAB_EXEC);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup((Connection)con);
                SQLUtils.cleanup((Statement)stm);
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Connection)con);
        SQLUtils.cleanup((Statement)stm);
        SQLUtils.cleanup((ResultSet)rs);
        return cmpItemList;
    }

    private StringBuffer getCmpPerItemList(Context ctx, IObjectPK schemePK) throws SQLDataException, CalEmpSchmException {
        StringBuffer cmpPerItemList = new StringBuffer();
        Connection con = this.getConnection(ctx);
        ResultSet rs = null;
        PreparedStatement stm = null;
        try {
            String sql = "SELECT CMPITEM.FNUMBER FROM T_HR_CMPSCHEMEITEM SCHITM ,T_HR_CMPITEM CMPITEM ,T_HR_CMPITEMCAT CAT WHERE SCHITM.FCMPITEMID = CMPITEM.FID AND CMPITEM.FCmpItemCatalogID = CAT.FID AND CAT.FNUMBER='FPER' AND CMPITEM.FSubject=10 AND SCHITM.FCMPSCHEMEID= ?";
            stm = con.prepareStatement(sql);
            stm.setString(1, schemePK.toString());
            rs = stm.executeQuery();
            while (rs.next()) {
                cmpPerItemList.append(rs.getString(1));
                cmpPerItemList.append("|");
            }
            if (cmpPerItemList.lastIndexOf("|") > 0) {
                cmpPerItemList.deleteCharAt(cmpPerItemList.lastIndexOf("|"));
            }
        }
        catch (SQLException e) {
            try {
                throw new CalEmpSchmException(CalEmpSchmException.GET_HORTAB_EXEC);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup((Connection)con);
                SQLUtils.cleanup((Statement)stm);
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Connection)con);
        SQLUtils.cleanup((Statement)stm);
        SQLUtils.cleanup((ResultSet)rs);
        return cmpPerItemList;
    }

    private Map getPersonSelectItems(Context ctx) throws ParserException, BOSException, FormaterException {
        HashMap<String, String> rst = new HashMap<String, String>();
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.compensation.app.EmpCompenUpdQuery"));
        SelectParser parser = new SelectParser(exec.getSQL());
        SqlSelectBase sb = parser.select();
        if (sb instanceof SqlSelect) {
            SqlSelect selectStmt = (SqlSelect)sb;
            SqlSelectItem selectItem = null;
            int size = selectStmt.selectList.size();
            for (int i = 0; i < size; ++i) {
                StringBuffer selectExpr = new StringBuffer();
                selectItem = (SqlSelectItem)selectStmt.selectList.get(i);
                DrSQLFormater formater = new DrSQLFormater(selectExpr);
                formater.formatExpr(selectItem.expr, false);
                rst.put(selectItem.alias.replaceAll("\"", ""), selectExpr.toString().replaceAll("\"", ""));
            }
        }
        return rst;
    }

    private SqlSelect getSelectStmt(Context ctx, String hortabName) throws EASBizException, ParserException, BOSException, FormaterException {
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.compensation.app.EmpCompenUpdQuery"));
        SelectParser parser = new SelectParser(exec.getSQL());
        SqlSelect selectStmt = null;
        SqlSelectBase sb = parser.select();
        if (sb instanceof SqlSelect) {
            selectStmt = (SqlSelect)sb;
            ArrayList<SqlSelectItem> selectItemList = new ArrayList<SqlSelectItem>();
            SqlExprParser identParser = new SqlExprParser(hortabName + ".FPERSONID");
            selectItemList.add(new SqlSelectItem(identParser.expr(), "PERSON"));
            selectStmt.selectList = null;
            selectStmt.selectList = selectItemList;
            SqlTableSource tableSource = new SqlTableSource(hortabName);
            selectStmt.tableSource = new SqlJoinedTableSource(selectStmt.tableSource, (SqlTableSourceBase)tableSource, 4, null);
            SqlBinaryOpExpr newExpr = null;
            try {
                newExpr = new SqlBinaryOpExpr(new SqlExprParser("PERSON.FID").expr(), 10, new SqlExprParser(hortabName + ".FPersonID").expr());
            }
            catch (ParserException e1) {
                throw new EmpCompenseException(EmpCompenseException.SQLFORMATTING_ERROR);
            }
            selectStmt.condition = new SqlBinaryOpExpr(selectStmt.condition, 7, (SqlExpr)newExpr);
            selectStmt.orderBy.clear();
        }
        return selectStmt;
    }

    private void scriptBizRuleCheck(List stmtList) throws EASBizException {
    }

    private void formatScript(CodeStmt stmt, Context ctx) throws CompenItemFormuleException {
        if (stmt instanceof ExprStmt) {
            this.formatExpr(((ExprStmt)stmt).expr, ctx);
        } else if (stmt instanceof IfStmt) {
            IfStmt ifStmt = (IfStmt)stmt;
            ExprStmt tempStmt = null;
            ifStmt.testExpr = this.formatExpr(ifStmt.testExpr, ctx);
            List trueStmtList = ifStmt.trueStmtList;
            int size = trueStmtList.size();
            for (int i = 0; i < size; ++i) {
                if (!(trueStmtList.get(i) instanceof ExprStmt)) continue;
                tempStmt = (ExprStmt)trueStmtList.get(i);
                tempStmt.expr = this.formatExpr(tempStmt.expr, ctx);
            }
            List elseifStmtList = ifStmt.elseIfList;
            int size2 = elseifStmtList.size();
            for (int i = 0; i < size2; ++i) {
                ElseIfItem item = (ElseIfItem)elseifStmtList.get(i);
                item.testExpr = this.formatExpr(item.testExpr, ctx);
                int jsize = item.stmtList.size();
                for (int j = 0; j < jsize; ++j) {
                    if (!(item.stmtList.get(j) instanceof ExprStmt)) continue;
                    tempStmt = (ExprStmt)item.stmtList.get(j);
                    tempStmt.expr = this.formatExpr(tempStmt.expr, ctx);
                }
            }
            List elseStmtList = ifStmt.elseStmtList;
            int size3 = elseStmtList.size();
            for (int i = 0; i < size3; ++i) {
                if (!(elseStmtList.get(i) instanceof ExprStmt)) continue;
                tempStmt = (ExprStmt)elseStmtList.get(i);
                tempStmt.expr = this.formatExpr(tempStmt.expr, ctx);
            }
        }
    }

    private CodeExpr formatExpr(CodeExpr expr, Context ctx) throws CompenItemFormuleException {
        if (expr instanceof PropertyExpr) {
            expr = this.proptExprCheck((PropertyExpr)expr, ctx);
            return expr;
        }
        if (expr instanceof StringExpr) {
            expr = this.constantCheck((CodeExpr)((StringExpr)expr));
            return expr;
        }
        if (expr instanceof BoolExpr) {
            if (((BoolExpr)expr).val) {
                return new IntExpr(1);
            }
            return new IntExpr(0);
        }
        if (expr instanceof MethodInvokeExpr) {
            expr = this.methodCheck((MethodInvokeExpr)expr);
            String methodName = ((MethodInvokeExpr)expr).methodName;
            if (KSQLMETHODLIST.indexOf(methodName = methodName.toUpperCase()) < 0) {
                throw new CompenItemFormuleException(CompenItemFormuleException.MODTH_NOT_SUPPORT);
            }
        }
        if (expr instanceof BinaryOpExpr) {
            ((BinaryOpExpr)expr).left = this.formatExpr(((BinaryOpExpr)expr).left, ctx);
            ((BinaryOpExpr)expr).right = this.formatExpr(((BinaryOpExpr)expr).right, ctx);
            return expr;
        }
        return expr;
    }

    private CodeExpr methodCheck(MethodInvokeExpr expr) {
        if (expr.methodName.equals("date")) {
            expr.methodName = "DAYOFMONTH";
        } else if (expr.methodName.equals("yearday")) {
            expr.methodName = "DAYOFYEAR";
        } else if (expr.methodName.equals("weekday")) {
            expr.methodName = "DAYOFWEEK";
        } else if (expr.methodName.equals("year")) {
            expr.methodName = "YEAR";
        } else if (expr.methodName.equals("month")) {
            expr.methodName = "MONTH";
        } else if (expr.methodName.equals("hour")) {
            expr.methodName = "HOUR";
        } else if (expr.methodName.equals("minute")) {
            expr.methodName = "MINUTE";
        } else if (expr.methodName.equals("second")) {
            expr.methodName = "SECOND";
        } else if (expr.methodName.equals("now")) {
            expr.methodName = "NOW";
        }
        return expr;
    }

    private CodeExpr proptExprCheck(PropertyExpr proptExpr, Context ctx) throws CompenItemFormuleException {
        throw new TODOException(ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"48_FormulaFacadeControllerBean", (Locale)ctx.getOriginLocale()));
    }

    private CodeExpr constantCheck(CodeExpr expr) throws CompenItemFormuleException {
        if (expr instanceof StringExpr) {
            String[] strExprArray;
            String strExpr = ((StringExpr)expr).text;
            if (strExpr.indexOf(";") >= 0) {
                throw new CompenItemFormuleException(CompenItemFormuleException.BIZ_EXISTCOMMA_EXEC);
            }
            if (strExpr.lastIndexOf(";") > 0 && (strExprArray = strExpr.split(";"))[0] != null && strExprArray[0].length() > 0 && strExprArray[0].equals("com.kingdee.eas.basedata.person.Genders")) {
                IntExpr intExpr = new IntExpr(strExprArray[1]);
                return intExpr;
            }
        }
        return expr;
    }

    private boolean ifNestCheck(IfStmt stmt) {
        if (stmt instanceof IfStmt) {
            int i;
            int size;
            IfStmt ifStmt = stmt;
            if (ifStmt.trueStmtList != null) {
                size = ifStmt.trueStmtList.size();
                for (i = 0; i < size; ++i) {
                    if (!(ifStmt.trueStmtList.get(i) instanceof IfStmt)) continue;
                    return true;
                }
            }
            if (ifStmt.elseStmtList != null) {
                ElseIfItem elseItem = null;
                int size2 = ifStmt.elseIfList.size();
                for (int i2 = 0; i2 < size2; ++i2) {
                    elseItem = (ElseIfItem)ifStmt.elseIfList.get(i2);
                    if (elseItem.stmtList == null) continue;
                    int jsize = elseItem.stmtList.size();
                    for (int j = 0; j < jsize; ++j) {
                        if (!(elseItem.stmtList.get(j) instanceof IfStmt)) continue;
                        return true;
                    }
                }
            }
            if (ifStmt.elseStmtList != null) {
                size = ifStmt.elseStmtList.size();
                for (i = 0; i < size; ++i) {
                    if (!(ifStmt.elseStmtList.get(i) instanceof IfStmt)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean _bizVerify(Context ctx, String formulaScript) throws BOSException, EASBizException {
        return false;
    }

    @Override
    protected Map _getAllCmpItemInstanceList(Context ctx, List cmpItemList) throws BOSException, EASBizException, EASDBException {
        return this._getAllCmpItemInstanceList(ctx, cmpItemList, null);
    }

    private EntityViewInfo getEntityViewInfoForQuery(Context ctx, String itemNumber) throws BOSException, EASBizException {
        EntityViewInfo eviInfo = new EntityViewInfo();
        String currCu = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        FilterInfo filterInfo = new FilterInfo();
        if (!itemNumber.equalsIgnoreCase("FPER007")) {
            if (itemNumber.equalsIgnoreCase("FPER009")) {
                Set set = new HashSet();
                CtrlUnitInfo cu = CtrlUnitFactory.getLocalInstance((Context)ctx).getCtrlUnitInfo((IObjectPK)new ObjectUuidPK(currCu));
                set = HRMulCUChangeUtil.getParentOneCU((CtrlUnitInfo)cu, set);
                filterInfo.getFilterItems().add(new FilterItemInfo("CU.number", set, CompareType.INCLUDE));
            } else if (itemNumber.equalsIgnoreCase("FPER017")) {
                filterInfo.getFilterItems().add(new FilterItemInfo("jobGradeModule.enable", (Object)"1"));
            } else if (itemNumber.equalsIgnoreCase("FPER016")) {
                StringBuffer sql = new StringBuffer();
                sql.append("select fjoblevelid  from T_ORG_Job \n");
                sql.append("where FControlUnitID = '").append(currCu).append("' \n");
                sql.append("OR fid IN ");
                sql.append("(SELECT FDataBaseDID FROM T_BD_DataBaseDAssign WHERE FBOSObjectType = '75702498' \n");
                sql.append("and FAssignCUID = '").append(currCu).append("')");
                filterInfo.getFilterItems().add(new FilterItemInfo("ID", (Object)sql, CompareType.INNER));
            } else if (itemNumber.equalsIgnoreCase("FPER006")) {
                StringBuffer sql = new StringBuffer("SELECT FORGID FROM T_PM_ORGRANGE WHERE FTYPE = 20 ");
                sql.append("AND FUSERID = '");
                sql.append(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
                sql.append("'");
                filterInfo.getFilterItems().add(new FilterItemInfo("adminOrgUnit.id", (Object)sql.toString(), CompareType.INNER));
            }
        }
        eviInfo.setFilter(filterInfo);
        return eviInfo;
    }

    @Override
    protected Map _getAllCmpItemInstanceList(Context ctx, List cmpItemList, String hrOrgUnitID) throws BOSException, EASBizException, EASDBException {
        String type = null;
        if (cmpItemList != null && cmpItemList.size() > 0 && cmpItemList.get(cmpItemList.size() - 1) != null && "formula@@@20120328".equals(type = cmpItemList.get(cmpItemList.size() - 1).toString())) {
            cmpItemList.remove(cmpItemList.size() - 1);
        }
        Hashtable<String, FormulaCmpItemData> allItemInstance = new Hashtable<String, FormulaCmpItemData>();
        if (cmpItemList == null || cmpItemList.size() == 0) {
            return allItemInstance;
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        HashSet<String> setItem = new HashSet<String>();
        int size = cmpItemList.size();
        for (int i = 0; i < size; ++i) {
            setItem.add(cmpItemList.get(i).toString());
        }
        if (StringUtils.isEmpty((String)hrOrgUnitID)) {
            hrOrgUnitID = HRSchemeUtils.getServerHROrgUnitInfo(ctx).getId().toString();
        }
        filter.getFilterItems().add(new FilterItemInfo("number", setItem, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)hrOrgUnitID));
        filter.setMaskString("#0 and #1");
        ev.setFilter(filter);
        SorterItemInfo sorterOrderItem = new SorterItemInfo("cmpItemCatalog.number");
        sorterOrderItem.setSortType(SortType.ASCEND);
        ev.getSorter().add(sorterOrderItem);
        sorterOrderItem = new SorterItemInfo("defaultOrder");
        sorterOrderItem.setSortType(SortType.ASCEND);
        ev.getSorter().add(sorterOrderItem);
        ev.getSelector().add(new SelectorItemInfo("number"));
        ev.getSelector().add(new SelectorItemInfo("name"));
        ev.getSelector().add(new SelectorItemInfo("itemValue"));
        ev.getSelector().add(new SelectorItemInfo("defaultOrder"));
        ev.getSelector().add(new SelectorItemInfo("cmpItemCatalog.number"));
        ev.getSelector().add(new SelectorItemInfo("cmpItemCatalog.name"));
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.compensation.app.CmpItemQuery"));
        exec.setObjectView(ev);
        IRowSet rs = exec.executeQuery();
        String cmpItemNum = "";
        String cmpItemName = "";
        String cmpItemType = "";
        String cmpItemValue = "";
        IRowSet rsInst = null;
        try {
            String strQueryPK = "com.kingdee.eas.hr.compensation.app.PersonInfoQuery";
            MetaDataPK queryPK = new MetaDataPK(strQueryPK);
            QueryInfo queryInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getQuery((IMetaDataPK)queryPK);
            EntityViewInfo evi = HRCmpItemUtils.getCmpItemDynQueryFilter(ctx, HRUtils.getSchemeQueryType(strQueryPK));
            QueryInfo newQueryInfo = (QueryInfo)queryInfo.clone();
            newQueryInfo.updateQuery(evi);
            SelectorItemCollection selectorColl = evi.getSelector();
            String propertyName = null;
            int orderIndex = 0;
            while (rs.next()) {
                PropertyRefInfo ref;
                SubEntityInfo subEntity;
                cmpItemNum = rs.getString("NUMBER");
                cmpItemName = rs.getString("NAME");
                cmpItemType = rs.getString("cmpItemCatalog.name");
                cmpItemValue = rs.getString("ITEMVALUE");
                orderIndex = rs.getInt("defaultOrder");
                FormulaCmpItemData itemData = new FormulaCmpItemData(cmpItemNum, cmpItemName, cmpItemType);
                itemData.setIndex(orderIndex);
                allItemInstance.put(cmpItemNum, itemData);
                if (cmpItemValue != null && cmpItemValue.length() > 0) {
                    List enumList;
                    String enumFullName;
                    String[] itemDesc = null;
                    String queryName = "";
                    itemDesc = cmpItemValue.split(";");
                    if (itemDesc.length != 5) continue;
                    Integer dataType = Integer.valueOf(itemDesc[0]);
                    if (dataType.equals(10)) {
                        queryName = itemDesc[2];
                        if (queryName == null || queryName.length() <= 0) continue;
                        exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK(queryName));
                        if (cmpItemNum.equalsIgnoreCase("FPER009") || cmpItemNum.equalsIgnoreCase("FPER007") || cmpItemNum.equalsIgnoreCase("FPER006") || cmpItemNum.equalsIgnoreCase("FPER016") || cmpItemNum.equalsIgnoreCase("FPER017")) {
                            exec.setObjectView(this.getEntityViewInfoForQuery(ctx, cmpItemNum));
                        }
                        rsInst = DbUtil.executeQuery((Context)ctx, (String)exec.getSQL());
                        ArrayList<FormulaCmpItemData> instDataList = new ArrayList<FormulaCmpItemData>();
                        try {
                            Locale l2 = new Locale("l2");
                            Locale l3 = new Locale("l3");
                            FormulaCmpItemData instData = null;
                            if (cmpItemNum.equalsIgnoreCase("FPER009") || cmpItemNum.equalsIgnoreCase("FPER007") || cmpItemNum.equalsIgnoreCase("FPER006") || cmpItemNum.equalsIgnoreCase("FPER016") || cmpItemNum.equalsIgnoreCase("FPER008") || cmpItemNum.equalsIgnoreCase("FPER051")) {
                                while (rsInst.next()) {
                                    instData = "formula@@@20120328".equals(type) ? (ctx.getLocale().equals(l2) || ctx.getLocale().equals(l3) ? new FormulaCmpItemData(rsInst.getString("id"), StringUtils.replace((String)rsInst.getString("name"), (String)".", (String)"#") + "_" + StringUtils.replace((String)rsInst.getString("number"), (String)".", (String)"#"), null) : new FormulaCmpItemData(rsInst.getString("id"), StringUtils.replace((String)rsInst.getString("number"), (String)".", (String)"#"), null)) : (ctx.getLocale().equals(l2) || ctx.getLocale().equals(l3) ? new FormulaCmpItemData(rsInst.getString("id"), rsInst.getString("name") + "_" + StringUtils.replace((String)rsInst.getString("number"), (String)".", (String)"."), null) : new FormulaCmpItemData(rsInst.getString("id"), StringUtils.replace((String)rsInst.getString("number"), (String)".", (String)"."), null));
                                    instDataList.add(instData);
                                }
                            } else {
                                while (rsInst.next()) {
                                    instData = ctx.getLocale().equals(l2) || ctx.getLocale().equals(l3) ? new FormulaCmpItemData(rsInst.getString("id"), rsInst.getString("name"), null) : new FormulaCmpItemData(rsInst.getString("id"), rsInst.getString("number"), null);
                                    instDataList.add(instData);
                                }
                            }
                            IHRObject[] instDataArray = new IHRObject[instDataList.size()];
                            int size2 = instDataList.size();
                            for (int i = 0; i < size2; ++i) {
                                instDataArray[i] = (IHRObject)instDataList.get(i);
                            }
                            itemData.setCmpItemInstList(instDataArray);
                            continue;
                        }
                        catch (SQLException e1) {
                            throw new EASDBException(EASDBException.EXEC_SQL_ERROR, (Throwable)e1);
                        }
                        finally {
                            SQLUtils.cleanup((ResultSet)rsInst);
                            continue;
                        }
                    }
                    if (!dataType.equals(20) || (enumFullName = itemDesc[1]) == null || enumFullName.length() <= 0 || (enumList = EnumUtils.getEnumList((String)enumFullName)) == null || enumList.size() <= 0) continue;
                    int size3 = enumList.size();
                    IHRObject[] instDataArray = new IHRObject[size3];
                    for (int i = 0; i < size3; ++i) {
                        if (enumList.get(i) instanceof Genders) {
                            Genders gender = (Genders)enumList.get(i);
                            String uuid = enumFullName + ";" + gender.getValue();
                            FormulaCmpItemData instData = new FormulaCmpItemData(uuid, gender.getAlias(), null);
                            instDataArray[i] = instData;
                            continue;
                        }
                        FormulaCmpItemData instData = new FormulaCmpItemData("00000000000000000000000000000", "Default Node", null);
                        instDataArray[i] = instData;
                    }
                    itemData.setCmpItemInstList(instDataArray);
                    continue;
                }
                if (!cmpItemType.equals(ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"49_FormulaFacadeControllerBean", (Locale)ctx.getOriginLocale())) || StringUtils.isEmpty((String)(propertyName = HRUtils.getPropertyNameFromSelector(cmpItemNum, selectorColl)))) continue;
                QueryFieldInfo queryFieldInfo = QueryUtil.getQueryFieldByName((QueryInfo)newQueryInfo, (String)propertyName);
                if (queryFieldInfo == null) {
                    queryFieldInfo = QueryUtil.getQueryFieldByName((QueryInfo)newQueryInfo, (String)cmpItemNum);
                }
                if (queryFieldInfo == null || queryFieldInfo.getPropertyRefs().size() != 1 || (subEntity = (ref = queryFieldInfo.getPropertyRefs().get(0)).getSubEntity()) == null || ref.getRefProperty() == null || !(ref.getRefProperty() instanceof OwnPropertyInfo)) continue;
                if (ref.getRefProperty().toString().equals("id")) {
                    EntityObjectInfo entityInfo = subEntity.getEntityRef();
                    if (entityInfo == null || entityInfo.getExtendedProperty("defaultF7Query") == null) continue;
                    String queryName = entityInfo.getExtendedProperty("defaultF7Query");
                    itemData = this.getQueryData(ctx, itemData, queryName);
                    continue;
                }
                if (!((OwnPropertyInfo)ref.getRefProperty()).getDataType().equals((Object)DataType.ENUM)) continue;
                itemData = this.getEnumData(ctx, itemData, queryFieldInfo);
            }
        }
        catch (SQLException e) {
            throw new EASDBException(EASDBException.EXEC_SQL_ERROR, (Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
        return allItemInstance;
    }

    private FormulaCmpItemData getEnumData(Context ctx, FormulaCmpItemData itemData, QueryFieldInfo queryFieldInfo) {
        BizEnumInfo enumInfo = HRUtil.getEnum((QueryFieldInfo)queryFieldInfo);
        if (enumInfo == null) {
            return itemData;
        }
        List enumList = EnumUtils.getEnumList((String)enumInfo.getClassName());
        if (enumList != null && enumList.size() > 0) {
            int size = enumList.size();
            IHRObject[] instDataArray = new IHRObject[size];
            for (int i = 0; i < size; ++i) {
                FormulaCmpItemData instData;
                String uuid;
                StringEnum intEnum;
                if (enumList.get(i) instanceof StringEnum) {
                    intEnum = (StringEnum)enumList.get(i);
                    uuid = "Enum;" + enumInfo.getClassName() + ";StringEnum;" + intEnum.getValue() + ";Enum";
                    instData = new FormulaCmpItemData(uuid, intEnum.getAlias(), null);
                    instDataArray[i] = instData;
                    continue;
                }
                if (enumList.get(i) instanceof IntEnum) {
                    intEnum = (IntEnum)enumList.get(i);
                    uuid = "Enum;" + enumInfo.getClassName() + ";IntEnum;" + intEnum.getValue() + ";Enum";
                    instData = new FormulaCmpItemData(uuid, intEnum.getAlias(), null);
                    instDataArray[i] = instData;
                    continue;
                }
                FormulaCmpItemData instData2 = new FormulaCmpItemData("00000000000000000000000000000", "Default Node", null);
                instDataArray[i] = instData2;
            }
            itemData.setCmpItemInstList(instDataArray);
        }
        return itemData;
    }

    private FormulaCmpItemData getQueryData(Context ctx, FormulaCmpItemData itemData, String queryName) throws BOSException, EASBizException, EASDBException {
        if (queryName != null && queryName.length() > 0) {
            IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK(queryName));
            IRowSet rows = exec.executeQuery();
            ArrayList<FormulaCmpItemData> instDataList = new ArrayList<FormulaCmpItemData>();
            try {
                while (rows.next()) {
                    FormulaCmpItemData instData = new FormulaCmpItemData(rows.getString("id"), rows.getString("name"), null);
                    instDataList.add(instData);
                }
                IHRObject[] instDataArray = new IHRObject[instDataList.size()];
                int size = instDataList.size();
                for (int i = 0; i < size; ++i) {
                    instDataArray[i] = (IHRObject)instDataList.get(i);
                }
                itemData.setCmpItemInstList(instDataArray);
            }
            catch (SQLException e1) {
                throw new EASDBException(EASDBException.EXEC_SQL_ERROR, (Throwable)e1);
            }
            finally {
                SQLUtils.cleanup((ResultSet)rows);
            }
        }
        return itemData;
    }

    @Override
    protected Map _getSchemeInitFormula(Context ctx, IObjectPK schemePK) throws BOSException, EASBizException {
        HashMap<String, String> itemsFormula = new HashMap<String, String>();
        if (schemePK == null) {
            return itemsFormula;
        }
        String oql = "select cmpItem.number where cmpScheme.id='" + schemePK.toString() + "'";
        ICmpSchemeItem schemeItem = CmpSchemeItemFactory.getLocalInstance(ctx);
        CmpSchemeItemCollection itemCols = schemeItem.getCmpSchemeItemCollection(oql);
        int size = itemCols.size();
        for (int i = 0; i < size; ++i) {
            if (itemCols.get(i).getCmpItem().getNumber().equals("FSAL004")) {
                itemsFormula.put("FSAL004", this.getDipenseToatal(schemePK, ctx));
                continue;
            }
            if (itemCols.get(i).getCmpItem().getNumber().equals("FSAL006")) {
                itemsFormula.put("FSAL006", this.getDipenseFact(schemePK, ctx));
                continue;
            }
            if (itemCols.get(i).getCmpItem().getNumber().equals("FSAL027") || !itemCols.get(i).getCmpItem().getNumber().equals("FSAL007")) continue;
            itemsFormula.put("FSAL007", this.getTax(ctx));
        }
        return itemsFormula;
    }

    private String getDipenseToatal(IObjectPK schemePK, Context ctx) throws BOSException {
        StringBuffer formula = new StringBuffer();
        String notIncludeItem = "FSAL004,FSAL005,FSAL006,FSAL007,FSAL008,FSAL009,FSAL010,FSAL011,FSAL027,FSAL029,";
        String allCurrencyItems = this.getCmpSchemesCurrItems(schemePK, ctx);
        if (allCurrencyItems.length() > 0) {
            formula.append("FSAL004 = ");
            String[] itemList = allCurrencyItems.split(";");
            int size = itemList.length;
            for (int i = 0; i < size; ++i) {
                if (notIncludeItem.indexOf(itemList[i]) >= 0) continue;
                formula.append(itemList[i]);
                formula.append(" + ");
            }
            if (formula.lastIndexOf("+") > 0) {
                formula.deleteCharAt(formula.lastIndexOf("+"));
            }
            formula.append(";");
        }
        return formula.toString();
    }

    private String getDipenseFact(IObjectPK schemePK, Context ctx) {
        String formula = "FSAL006=FSAL004-FSAL007;";
        return formula;
    }

    private String getTaxBase(IObjectPK schemePK, Context ctx) throws BOSException {
        StringBuffer formula = new StringBuffer();
        String notIncludeItem = "FSAL004,FSAL005,FSAL006,FSAL007,FSAL008,FSAL009,FSAL010,FSAL011,FSAL027,FSAL029,";
        String allCurrencyItems = this.getCmpSchemesCurrItems(schemePK, ctx);
        if (allCurrencyItems.length() > 0) {
            formula.append("FSAL027 = ");
            String[] itemList = allCurrencyItems.split(";");
            int size = itemList.length;
            for (int i = 0; i < size; ++i) {
                if (notIncludeItem.indexOf(itemList[i]) >= 0) continue;
                formula.append(itemList[i]);
                formula.append(" + ");
            }
            if (formula.lastIndexOf("+") > 0) {
                formula.deleteCharAt(formula.lastIndexOf("+"));
            }
            formula.append(" - FSAL029");
            formula.append(";");
        }
        return formula.toString();
    }

    private String getPrizeYearTaxPri(Context ctx) throws BOSException {
        StringBuffer formula = new StringBuffer();
        String tax = "FSAL007";
        String taxOwenValue = "FSAL014";
        ITaxRateList taxList = TaxRateListFactory.getLocalInstance(ctx);
        String oql = "select * where enabled = 1";
        TaxRateListCollection taxListCols = taxList.getTaxRateListCollection(oql);
        int size = taxListCols.size();
        for (int i = 0; i < size; ++i) {
            if (i == 0) {
                formula.append("if ");
            } else {
                formula.append(" else if ");
            }
            formula.append("( " + taxOwenValue + "/12 > ");
            formula.append(taxListCols.get(i).getBeginPoint());
            formula.append(" && ");
            formula.append(" " + taxOwenValue + "/12 <= ");
            formula.append(taxListCols.get(i).getEndPoint());
            formula.append(" ) { " + tax + "= " + taxOwenValue + " * ");
            formula.append(taxListCols.get(i).getTaxRate().setScale(5).divide(new BigDecimal("100.00"), 5));
            formula.append(" - ");
            formula.append(taxListCols.get(i).getFastSub());
            formula.append(" ; }");
        }
        formula.append("else if(" + taxOwenValue + " <=0  ) { " + tax + " = 0; } ");
        return formula.toString();
    }

    private String getTax(Context ctx) throws BOSException {
        StringBuffer formula = new StringBuffer();
        ITaxRateList taxList = TaxRateListFactory.getLocalInstance(ctx);
        String oql = "select * where enabled = 1";
        TaxRateListCollection taxListCols = taxList.getTaxRateListCollection(oql);
        int size = taxListCols.size();
        for (int i = 0; i < size; ++i) {
            if (i == 0) {
                formula.append("if ");
            } else {
                formula.append(" else if ");
            }
            formula.append("( FSAL027 - FSAL029 > ");
            formula.append(taxListCols.get(i).getBeginPoint().setScale(2, 4));
            formula.append(" && ");
            formula.append(" FSAL027 - FSAL029 <= ");
            formula.append(taxListCols.get(i).getEndPoint());
            formula.append(" ) { FSAL007 = (FSAL027-FSAL029) * ");
            formula.append(taxListCols.get(i).getTaxRate().setScale(5));
            formula.append("/100.00 ");
            formula.append(" - ");
            formula.append(taxListCols.get(i).getFastSub().setScale(2, 4));
            formula.append(" ; }");
        }
        formula.append("else if(FSAL027 - FSAL029 <=0  ) { FSAL007 = (FSAL027-FSAL029) * 0; } ");
        return formula.toString();
    }

    private String getCmpSchemesCurrItems(IObjectPK schemePK, Context ctx) throws BOSException {
        StringBuffer currencyItemList = new StringBuffer();
        String oql = "select cmpItem.number where cmpItem.dataType=60 and cmpScheme.id='" + schemePK.toString() + "'";
        ICmpSchemeItem schemeItem = CmpSchemeItemFactory.getLocalInstance(ctx);
        CmpSchemeItemCollection itemCols = schemeItem.getCmpSchemeItemCollection(oql);
        int size = itemCols.size();
        for (int i = 0; i < size; ++i) {
            currencyItemList.append(itemCols.get(i).getCmpItem().getNumber());
            currencyItemList.append(";");
        }
        if (currencyItemList.lastIndexOf(";") > 0) {
            currencyItemList.deleteCharAt(currencyItemList.lastIndexOf(";"));
        }
        return currencyItemList.toString();
    }

    private int getRoundLength() {
        return 2;
    }

    @Override
    protected String _getTaxFormula(Context ctx) throws BOSException {
        String formula = "";
        formula = this.getTax(ctx);
        return formula;
    }

    @Override
    protected String _getPrizeYearTax(Context ctx) throws BOSException, EASBizException {
        return this.getPrizeYearTaxPri(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IRowSet _getAllFormulasByScheme(Context ctx, String schemeId) throws BOSException, EASBizException {
        IMetaDataPK pk = MetaDataPKFactory.getMetaDataPK((String)"com.kingdee.eas.hr.compensation.app.CmpSchemeItemFormulaQuery");
        IQueryExecutor exe = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)pk);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("cmpScheme.id", (Object)schemeId));
        filter.getFilterItems().add(new FilterItemInfo("isDelete", (Object)0));
        CmpItemTempTableUtil util = new CmpItemTempTableUtil();
        try {
            IRowSet rs;
            FilterInfo ruleFilter = new FilterInfo("CMPITEM.ID in " + util.getCmpItemViewConstraintSql(ctx, this.getBOSType()));
            filter.mergeFilter(ruleFilter, "and");
            view.setFilter(filter);
            exe.setObjectView(view);
            IRowSet iRowSet = rs = exe.executeQuery();
            return iRowSet;
        }
        catch (Exception e) {
            e.printStackTrace();
            IRowSet iRowSet = null;
            return iRowSet;
        }
        finally {
            util.release();
        }
    }
}

