/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.hr.util.HRParamUtil;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.compensation.CmpItemCollection;
import com.kingdee.eas.hr.compensation.CmpItemInfo;
import com.kingdee.eas.hr.compensation.CmpItemPrecisionTypeEnum;
import com.kingdee.eas.hr.compensation.FixedCmpSchemeException;
import com.kingdee.eas.hr.compensation.FixedCmpSchemeFacadeFactory;
import com.kingdee.eas.hr.compensation.FixedCmpSchemeFactory;
import com.kingdee.eas.hr.compensation.FixedCmpSchemeInfo;
import com.kingdee.eas.hr.compensation.HRParameterEnum;
import com.kingdee.eas.hr.compensation.HRParameterFactory;
import com.kingdee.eas.hr.compensation.IFixedCmpScheme;
import com.kingdee.eas.hr.compensation.IFixedCmpSchemeFacade;
import com.kingdee.eas.hr.compensation.ISalariatHiberProps;
import com.kingdee.eas.hr.compensation.ISalariatScheme;
import com.kingdee.eas.hr.compensation.ItemDataTypeEnum;
import com.kingdee.eas.hr.compensation.ItemObjectTypeEnum;
import com.kingdee.eas.hr.compensation.ItemSubjectEnum;
import com.kingdee.eas.hr.compensation.ItemTypeEnum;
import com.kingdee.eas.hr.compensation.ItemUsedEnum;
import com.kingdee.eas.hr.compensation.SalariatException;
import com.kingdee.eas.hr.compensation.SalariatHiberPropsCollection;
import com.kingdee.eas.hr.compensation.SalariatHiberPropsFactory;
import com.kingdee.eas.hr.compensation.SalariatHiberPropsInfo;
import com.kingdee.eas.hr.compensation.SalariatSchemeFactory;
import com.kingdee.eas.hr.compensation.SalariatSchemeInfo;
import com.kingdee.eas.hr.compensation.StateEnum;
import com.kingdee.eas.hr.compensation.app.AbstractSalariatSchemeFacadeControllerBean;
import com.kingdee.eas.hr.compensation.util.HRUtils;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import com.kingdee.util.enums.IntEnum;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class SalariatSchemeFacadeControllerBean
extends AbstractSalariatSchemeFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.compensation.app.SalariatSchemeFacadeControllerBean");
    public static final String HRORGUNIT = "hrOrgUnit.id";

    @Override
    protected boolean _saveSignlePointData(Context ctx, String tableName, List columnNames, List columnTypes, Map columnValues) throws BOSException, EASBizException {
        boolean isSuccess = true;
        Connection cn = this.getConnection(ctx);
        Statement stmt = null;
        String insertSql = this._getPointInsertSQL(ctx, tableName, columnNames, columnTypes, columnValues);
        try {
            stmt = cn.createStatement();
            isSuccess = stmt.execute(insertSql);
        }
        catch (SQLException sqle) {
            throw new BOSException((Throwable)sqle);
        }
        finally {
            SQLUtils.cleanup(null, (Statement)stmt, (Connection)cn);
        }
        return isSuccess;
    }

    @Override
    protected boolean _saveListPointData(Context ctx, String tableName, List columnNames, List columnTypes, List lstColumnValues, String salPointSalGradeID) throws BOSException, EASBizException {
        String deleteSQL;
        boolean isUpgrade = false;
        String sql = "SELECT 1 FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FSalPointSalGradeID' AND KSQL_COL_TABNAME='" + tableName + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        if (rs.size() == 0) {
            deleteSQL = "delete from " + tableName;
        } else {
            deleteSQL = salPointSalGradeID == null ? "delete from " + tableName + " where FsalPointSalGradeID is null" : "delete from " + tableName + " where FsalPointSalGradeID ='" + salPointSalGradeID + "'";
            isUpgrade = true;
        }
        Connection cn = this.getConnection(ctx);
        Statement stmt = null;
        ctx.put((Object)"isUpgrade", (Object)isUpgrade);
        ctx.put((Object)"FsalPointSalGradeID", (Object)salPointSalGradeID);
        try {
            stmt = cn.createStatement();
            stmt.execute(deleteSQL);
            for (int i = 0; i < lstColumnValues.size(); ++i) {
                Map columnValues = (Map)lstColumnValues.get(i);
                String insertSQL = this._getPointInsertSQL(ctx, tableName, columnNames, columnTypes, columnValues);
                stmt.execute(insertSQL);
            }
        }
        catch (SQLException sqle) {
            throw new SalariatException(SalariatException.INSERTSQL_POINT_ERROR, sqle);
        }
        finally {
            SQLUtils.cleanup(null, (Statement)stmt, (Connection)cn);
        }
        return false;
    }

    @Override
    protected String _getPointInsertSQL(Context ctx, String tableName, List columnNames, List columnTypes, Map columnValues) throws BOSException, EASBizException {
        if (columnNames.size() == 0) {
            return null;
        }
        boolean isUpgrade = (Boolean)ctx.get((Object)"isUpgrade");
        String salPointSalGradeID = (String)ctx.get((Object)"FsalPointSalGradeID");
        StringBuffer sqlInsert = new StringBuffer("INSERT INTO ");
        sqlInsert.append(tableName);
        StringBuffer columns = new StringBuffer(" ( ");
        StringBuffer values = new StringBuffer(" values ( ");
        boolean isFirst = true;
        for (int i = 0; i < columnNames.size(); ++i) {
            Object columnValue;
            String columnName = (String)columnNames.get(i);
            Object columnType = columnTypes.get(i);
            Object appendObj = columnValue = columnValues.get(columnName);
            boolean isStr = true;
            if (columnType.equals((Object)ItemObjectTypeEnum.BIZOBJECT)) {
                appendObj = ((SalariatHiberPropsInfo)columnValue).getId().toString();
                isStr = true;
            } else if (columnType.equals((Object)ItemObjectTypeEnum.ENUM)) {
                appendObj = ((IntEnum)columnValue).getValue();
                isStr = true;
            } else if (columnType.equals((Object)ItemDataTypeEnum.STRING) || columnType.equals((Object)ItemDataTypeEnum.DATE)) {
                isStr = true;
            } else if (columnType.equals((Object)ItemDataTypeEnum.INT) || columnType.equals((Object)ItemDataTypeEnum.FLOAT) || columnType.equals((Object)ItemDataTypeEnum.CURRENCY)) {
                isStr = false;
            }
            if (isFirst) {
                isFirst = false;
            } else {
                columns.append(" , ");
                values.append(" , ");
            }
            columns.append(columnName);
            if (isStr) {
                values.append("'").append(appendObj).append("'");
                continue;
            }
            values.append(appendObj);
        }
        if (isUpgrade && salPointSalGradeID != null) {
            columns.append(",FsalPointSalGradeID").append(" ) ");
            values.append(",'").append(salPointSalGradeID).append("' ) ");
        } else {
            columns.append(" ) ");
            values.append(" ) ");
        }
        sqlInsert.append(columns).append(values);
        return sqlInsert.toString();
    }

    @Override
    protected IRowSet _getListPointData(Context ctx, String tableName) throws BOSException, EASBizException {
        String HRO_ID;
        if (tableName == null) {
            return new DynamicRowSet();
        }
        String sql = "SELECT 1 FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FSalPointSalGradeID' AND KSQL_COL_TABNAME='" + tableName + "'";
        IRowSet rst = DbUtil.executeQuery((Context)ctx, (String)sql);
        String querySQL = null;
        querySQL = rst.size() == 0 ? " select * from " + tableName : (HRParamUtil.getParamOfHR((Context)ctx, (String)"hr_cmp_011", (String)(HRO_ID = ((HROrgUnitInfo)ctx.get((Object)OrgType.HRO)).getId().toString())) ? " select * from " + tableName + " where FSalPointSalGradeID is not null" : " select * from " + tableName + " where FSalPointSalGradeID is null");
        ISQLExecutor exec = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)querySQL);
        IRowSet rs = exec.executeSQL();
        return rs;
    }

    @Override
    protected boolean _saveListGradeData(Context ctx, String schemeID, String tableName, List pointColumnNames, List lstColumnValues, String salPointSalGradeID) throws BOSException, EASBizException {
        String HRO_ID;
        if (pointColumnNames.size() == 0) {
            return false;
        }
        String deleteSQL = null;
        boolean isUpgrade = false;
        String sql = "SELECT 1 FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FSalPointSalGradeID' AND KSQL_COL_TABNAME='" + tableName + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        if (rs.size() == 0) {
            deleteSQL = "delete from " + tableName;
            HRO_ID = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
            if (HRParamUtil.getParamOfHR((Context)ctx, (String)"hr_cmp_004", (String)HRO_ID)) {
                deleteSQL = deleteSQL + this.getColumnfilterSqls(ctx, tableName);
            }
        } else {
            if (salPointSalGradeID == null) {
                deleteSQL = "delete from " + tableName;
                HRO_ID = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
                if (HRParamUtil.getParamOfHR((Context)ctx, (String)"hr_cmp_004", (String)HRO_ID)) {
                    deleteSQL = deleteSQL + this.getColumnfilterSqls(ctx, tableName);
                    deleteSQL = deleteSQL + " and FsalPointSalGradeID is null";
                } else {
                    deleteSQL = deleteSQL + " where FsalPointSalGradeID is null";
                }
            } else {
                deleteSQL = "delete from " + tableName + " where FsalPointSalGradeID ='" + salPointSalGradeID + "'";
            }
            isUpgrade = true;
        }
        CmpItemCollection personItems = null;
        try {
            personItems = HRUtils.getPersonItemsByScheme(ctx, schemeID);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        Connection cn = this.getConnection(ctx);
        PreparedStatement ps = null;
        try {
            ps = cn.prepareStatement(deleteSQL);
            ps.executeUpdate();
            String insertSQL = null;
            Map personItemMap = null;
            Map valueMap = null;
            for (int i = 0; i < lstColumnValues.size(); ++i) {
                int t;
                insertSQL = this.getGradeInsertSQL(tableName, pointColumnNames, personItems, isUpgrade);
                valueMap = (Map)lstColumnValues.get(i);
                personItemMap = (Map)valueMap.get("map_person");
                ps = cn.prepareStatement(insertSQL);
                int size = personItems.size();
                for (t = 0; t < size; ++t) {
                    if (personItemMap.get(personItems.get(t).getNumber()) == null) {
                        ps.setObject(t + 1, null, 0);
                        continue;
                    }
                    if (personItems.get(t).getDataType().equals((Object)ItemDataTypeEnum.DATE)) {
                        java.util.Date utilDate = (java.util.Date)personItemMap.get(personItems.get(t).getNumber());
                        Date sqlDate = new Date(utilDate.getTime());
                        ps.setDate(t + 1, sqlDate);
                        continue;
                    }
                    ps.setObject(t + 1, personItemMap.get(personItems.get(t).getNumber()));
                }
                size = pointColumnNames.size();
                for (t = 0; t < size; ++t) {
                    if (valueMap.get(pointColumnNames.get(t)) == null) {
                        ps.setObject(t + 1 + personItems.size(), null, 0);
                        continue;
                    }
                    ps.setObject(t + 1 + personItems.size(), valueMap.get(pointColumnNames.get(t)));
                }
                if (isUpgrade) {
                    ps.setObject(personItems.size() + pointColumnNames.size() + 1, salPointSalGradeID);
                }
                ps.executeUpdate();
                SQLUtils.cleanup((Statement)ps);
            }
        }
        catch (SQLException sqle) {
            logger.error((Object)sqle.getMessage());
            throw new SalariatException(SalariatException.INSERTSQL_POINT_ERROR, sqle);
        }
        finally {
            SQLUtils.cleanup(null, (Statement)ps, (Connection)cn);
        }
        return false;
    }

    private String getGradeInsertSQL(String tableName, List pointColumnNames, CmpItemCollection personItems, boolean isUpgrade) throws BOSException, EASBizException {
        int i;
        StringBuffer sqlInsert = new StringBuffer("INSERT INTO ");
        sqlInsert.append(tableName);
        sqlInsert.append(" (");
        CmpItemInfo cmpItemInfo = null;
        int size = personItems.size();
        for (int i2 = 0; i2 < size; ++i2) {
            cmpItemInfo = personItems.get(i2);
            sqlInsert.append(cmpItemInfo.getNumber());
            sqlInsert.append(",");
        }
        String columnName = null;
        int size2 = pointColumnNames.size() - 1;
        for (i = 0; i < size2; ++i) {
            columnName = (String)pointColumnNames.get(i);
            sqlInsert.append(columnName);
            sqlInsert.append(",");
        }
        columnName = (String)pointColumnNames.get(pointColumnNames.size() - 1);
        sqlInsert.append(columnName);
        if (isUpgrade) {
            sqlInsert.append(",FsalPointSalGradeID");
        }
        sqlInsert.append(") VALUES (");
        size2 = personItems.size() + pointColumnNames.size() - 1;
        for (i = 0; i < size2; ++i) {
            sqlInsert.append("?");
            sqlInsert.append(",");
        }
        if (isUpgrade) {
            sqlInsert.append("?,");
        }
        sqlInsert.append("?)");
        return sqlInsert.toString();
    }

    @Override
    protected IRowSet _getListGradeData(Context ctx, String tableName) throws BOSException, EASBizException {
        String HRO_ID;
        String sql = "SELECT 1 FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FSalPointSalGradeID' AND KSQL_COL_TABNAME='" + tableName + "'";
        IRowSet rst = DbUtil.executeQuery((Context)ctx, (String)sql);
        String querySQL = null;
        if (rst.size() == 0) {
            querySQL = " select * from " + tableName;
            HRO_ID = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
            if (HRParamUtil.getParamOfHR((Context)ctx, (String)"hr_cmp_004", (String)HRO_ID)) {
                querySQL = querySQL + this.getColumnfilterSqls(ctx, tableName);
            }
        } else {
            querySQL = " select * from " + tableName;
            HRO_ID = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
            if (HRParamUtil.getParamOfHR((Context)ctx, (String)"hr_cmp_004", (String)HRO_ID)) {
                querySQL = querySQL + this.getColumnfilterSqls(ctx, tableName);
                querySQL = querySQL + " and FSalPointSalGradeID is null";
            } else {
                querySQL = querySQL + " where FSalPointSalGradeID is null";
            }
        }
        ISQLExecutor exec = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)querySQL);
        IRowSet rs = exec.executeSQL();
        return rs;
    }

    private String getColumnfilterSqls(Context ctx, String tableName) throws BOSException {
        if (tableName == null) {
            return null;
        }
        StringBuffer sqlGetColumns = new StringBuffer();
        StringBuffer filterSqls = new StringBuffer();
        sqlGetColumns.append("select KSQL_COL_NAME from KSQL_USERCOLUMNS where KSQL_COL_TABNAME = '");
        sqlGetColumns.append(tableName);
        sqlGetColumns.append("'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlGetColumns.toString());
        boolean isFirst = true;
        try {
            while (rs.next()) {
                if ("FPER004".equals(rs.getString(1)) || "FPER005".equals(rs.getString(1)) || "FPER003".equals(rs.getString(1))) {
                    if (isFirst) {
                        filterSqls.append(" where ");
                        isFirst = false;
                    } else {
                        filterSqls.append(" and ");
                    }
                    filterSqls.append(" ( ");
                    filterSqls.append(rs.getString(1));
                    filterSqls.append(" in (");
                    filterSqls.append("SELECT distinct ADMIN.fid ");
                    filterSqls.append("FROM T_ORG_ADMIN ADMIN ");
                    filterSqls.append("LEFT JOIN T_PM_OrgRange ORGR ON ADMIN.FID = ORGR.FORGID ");
                    filterSqls.append("LEFT JOIN T_PM_USER PUSER ON PUSER.FID = ORGR.FUSERID ");
                    filterSqls.append("WHERE ORGR.FType = 20 AND PUSER.FID = '");
                    filterSqls.append(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
                    filterSqls.append("'");
                    filterSqls.append(") ");
                    filterSqls.append("or " + rs.getString(1) + " is null )");
                }
                if (!"FPER006".equals(rs.getString(1))) continue;
                if (isFirst) {
                    filterSqls.append(" where ");
                    isFirst = false;
                } else {
                    filterSqls.append(" and ");
                }
                filterSqls.append(" ( ");
                filterSqls.append(rs.getString(1));
                filterSqls.append(" in (");
                filterSqls.append("SELECT distinct posi.fid ");
                filterSqls.append("FROM T_ORG_Position posi ");
                filterSqls.append("left join T_ORG_ADMIN ADMIN on posi.FAdminOrgUnitID  = ADMIN.fid ");
                filterSqls.append("LEFT JOIN T_PM_OrgRange ORGR ON ADMIN.FID = ORGR.FORGID ");
                filterSqls.append("LEFT JOIN T_PM_USER PUSER ON PUSER.FID = ORGR.FUSERID ");
                filterSqls.append("WHERE ORGR.FType = 20 AND PUSER.FID = '");
                filterSqls.append(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
                filterSqls.append("'");
                filterSqls.append(") ");
                filterSqls.append(" or " + rs.getString(1) + " is null )");
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), e.getCause());
        }
        return filterSqls.toString();
    }

    private SalariatSchemeInfo getCurrentHRSalSchm(Context ctx) throws BOSException, EASBizException {
        SalariatSchemeInfo info = null;
        ISalariatScheme iSalariatScheme = null;
        String hrID = null;
        hrID = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        iSalariatScheme = SalariatSchemeFactory.getLocalInstance(ctx);
        try {
            info = iSalariatScheme.getSalariatSchemeInfo("select *  where  state=1 and hrOrgUnit.id ='" + hrID + "' ");
        }
        catch (Exception e) {
            throw new FixedCmpSchemeException(FixedCmpSchemeException.NOT_ENABLE_SALARIATSCHEME);
        }
        return info;
    }

    private Map getSalPointInfo(Context ctx, String salSchemeID) throws BOSException, EASBizException {
        if (salSchemeID == null) {
            return null;
        }
        HashMap<String, SalariatHiberPropsInfo> hst = new HashMap<String, SalariatHiberPropsInfo>();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfoItem = new FilterInfo();
        filterInfoItem.getFilterItems().add(new FilterItemInfo("scheme", (Object)salSchemeID));
        evi.setFilter(filterInfoItem);
        SelectorItemCollection sic = evi.getSelector();
        sic.add(new SelectorItemInfo("parent.*"));
        sic.add(new SelectorItemInfo("*"));
        ISalariatHiberProps iSalariatHiberProps = SalariatHiberPropsFactory.getLocalInstance(ctx);
        SalariatHiberPropsCollection col = iSalariatHiberProps.getSalariatHiberPropsCollection(evi);
        if (col == null || col.size() <= 0) {
            return null;
        }
        Iterator itr = col.iterator();
        SalariatHiberPropsInfo info = null;
        while (itr.hasNext()) {
            info = (SalariatHiberPropsInfo)itr.next();
            hst.put(info.getId().toString(), info);
        }
        return hst;
    }

    private Map getPointValueMap(Context ctx, String salSchmID) throws BOSException, EASBizException {
        CmpItemCollection cmpItems;
        ObjectUuidPK schemePK;
        HashMap pointMap = new HashMap();
        if (salSchmID == null) {
            return pointMap;
        }
        ISalariatScheme iBiz = SalariatSchemeFactory.getLocalInstance(ctx);
        SalariatSchemeInfo schemeInfo = (SalariatSchemeInfo)iBiz.getValue((IObjectPK)(schemePK = new ObjectUuidPK(BOSUuid.read((String)salSchmID))));
        if (schemeInfo == null) {
            return pointMap;
        }
        if (!StateEnum.ENABLE.equals((Object)schemeInfo.getState())) {
            // empty if block
        }
        BigDecimal stand = new BigDecimal("1.0");
        if (schemeInfo.isFlagStandardBase()) {
            stand = new BigDecimal(schemeInfo.getStandardBase());
        }
        ArrayList<String> columnNames = new ArrayList<String>();
        ArrayList<IntEnum> columnTypes = new ArrayList<IntEnum>();
        columnNames.add("FPointID");
        columnTypes.add(ItemObjectTypeEnum.BIZOBJECT);
        try {
            cmpItems = this.getCmpItemsByScheme(ctx, salSchmID);
        }
        catch (Exception e) {
            throw new EASBizException(EASBizException.DBDEADLOCK);
        }
        int size = cmpItems.size();
        for (int i = 0; i < size; ++i) {
            columnNames.add(cmpItems.get(i).getNumber());
            columnTypes.add(cmpItems.get(i).getDataType());
        }
        IRowSet rowSet = this._getListPointData(ctx, schemeInfo.getPointTableName());
        try {
            while (rowSet.next()) {
                String pointID = rowSet.getString("FPointID");
                HashMap<String, Object> pointValueMap = new HashMap<String, Object>();
                for (int i = 1; i < columnNames.size(); ++i) {
                    String columnName = (String)columnNames.get(i);
                    Object columnType = columnTypes.get(i);
                    if (columnType.equals((Object)ItemDataTypeEnum.STRING)) {
                        String strValue = rowSet.getString(columnName);
                        pointValueMap.put(columnName, strValue);
                        continue;
                    }
                    if (columnType.equals((Object)ItemDataTypeEnum.FLOAT) || columnType.equals((Object)ItemDataTypeEnum.CURRENCY)) {
                        BigDecimal value = rowSet.getBigDecimal(columnName);
                        if (value != null) {
                            pointValueMap.put(columnName, value.multiply(stand));
                            value = value.multiply(stand);
                            pointValueMap.put(columnName, value);
                            continue;
                        }
                        pointValueMap.put(columnName, null);
                        continue;
                    }
                    if (!columnType.equals((Object)ItemDataTypeEnum.INT)) continue;
                    int intValue = rowSet.getInt(columnName);
                    pointValueMap.put(columnName, intValue);
                }
                pointMap.put(pointID, pointValueMap);
            }
        }
        catch (Exception e) {
            throw new EASBizException(EASBizException.DBDEADLOCK);
        }
        return pointMap;
    }

    private CmpItemCollection getCmpItemsByScheme(Context ctx, String schemeID) throws Exception {
        CmpItemCollection items = new CmpItemCollection();
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.compensation.app.SalSchCmpItemsQuery");
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        EntityViewInfo entityView = new EntityViewInfo();
        FilterInfo filterInfoItem = new FilterInfo();
        filterInfoItem.getFilterItems().add(new FilterItemInfo("scheme.id", (Object)schemeID));
        entityView.setFilter(filterInfoItem);
        exec.setObjectView(entityView);
        IRowSet selectItemRowSet = exec.executeQuery();
        Object cmpItem = null;
        while (selectItemRowSet.next()) {
            items.add(this.getItemInfo(selectItemRowSet));
        }
        return items;
    }

    private CmpItemInfo getItemInfo(IRowSet selectItemRowSet) throws Exception {
        CmpItemInfo cmpItem = new CmpItemInfo();
        cmpItem.setId(BOSUuid.read((String)selectItemRowSet.getString("item.id")));
        cmpItem.setNumber(selectItemRowSet.getString("item.number"));
        cmpItem.setName(selectItemRowSet.getString("item.name"));
        cmpItem.setEnable(StateEnum.getEnum(selectItemRowSet.getInt("item.enable")));
        cmpItem.setLength(selectItemRowSet.getInt("item.length"));
        cmpItem.setDecDigital(selectItemRowSet.getInt("item.decDigital"));
        cmpItem.setItemValue(selectItemRowSet.getString("item.itemValue"));
        cmpItem.setDefaultOrder(selectItemRowSet.getInt("item.defaultOrder"));
        cmpItem.setType(ItemTypeEnum.getEnum(selectItemRowSet.getInt("item.type")));
        cmpItem.setDataType(ItemDataTypeEnum.getEnum(selectItemRowSet.getInt("item.dataType")));
        cmpItem.setPrecisionType(CmpItemPrecisionTypeEnum.getEnum(selectItemRowSet.getInt("item.precisionType")));
        cmpItem.setSubject(ItemSubjectEnum.getEnum(selectItemRowSet.getInt("item.subject")));
        cmpItem.setUsed(ItemUsedEnum.getEnum(selectItemRowSet.getInt("item.used")));
        return cmpItem;
    }

    private String getFixedCmpSchemeID(Context ctx, String salSchemeID) throws BOSException, EASBizException {
        String fixedCmpSchemeID = null;
        String hrID = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        String sql = "select fid from t_hr_fixedcmpScheme where fenable = 1 and fhrOrgUnitID = ? ";
        IRowSet coll = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{hrID});
        try {
            while (coll.next()) {
                fixedCmpSchemeID = coll.getString("fid");
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (StringUtils.isEmpty(fixedCmpSchemeID)) {
            IFixedCmpSchemeFacade iFixedCmpSchemeFacade = FixedCmpSchemeFacadeFactory.getLocalInstance(ctx);
            iFixedCmpSchemeFacade.initFixedCmpScheme(null, null, salSchemeID);
            IFixedCmpScheme iFixedCmpScheme = FixedCmpSchemeFactory.getLocalInstance(ctx);
            FixedCmpSchemeInfo infoFixedCmpScheme = iFixedCmpScheme.getFixedCmpSchemeInfo(" where hrOrgUnit.id = '" + hrID + "'");
            fixedCmpSchemeID = infoFixedCmpScheme.getId().toString();
        }
        return fixedCmpSchemeID;
    }

    @Override
    protected Map _getPointAndSalSchm(Context ctx, String fixedSchemeID) throws BOSException, EASBizException {
        FixedCmpSchemeInfo fixedInfo = FixedCmpSchemeFactory.getLocalInstance(ctx).getFixedCmpSchemeInfo((IObjectPK)new ObjectUuidPK(fixedSchemeID));
        HashMap<String, Object> map = new HashMap<String, Object>();
        SalariatSchemeInfo info = fixedInfo.getSalariatScheme();
        map.put("fixedCmpSchemeState", (Object)fixedInfo.getEnable());
        if (info == null) {
            return map;
        }
        String salSchemeID = info.getId().toString();
        map.put("salSchemeID", salSchemeID);
        Map mapSal = this.getSalPointInfo(ctx, salSchemeID);
        map.put("mapSal", mapSal);
        Map mapPoint = this.getPointValueMap(ctx, salSchemeID);
        map.put("mapPoint", mapPoint);
        return map;
    }

    @Override
    protected Map _getDynTableName(Context ctx) throws BOSException, EASBizException {
        HashMap<String, String> map = new HashMap<String, String>();
        String point_prefix = HRParameterFactory.getLocalInstance(ctx).getParamterValue(HRParameterEnum.SAL_POINT_TABLE_PREFIX);
        String point_suffix = HRParameterFactory.getLocalInstance(ctx).getParamterValue(HRParameterEnum.SAL_POINT_TABLE_SUFFIX);
        String grade_prefix = HRParameterFactory.getLocalInstance(ctx).getParamterValue(HRParameterEnum.SAL_POINTGRADE_TABLE_PREFIX);
        String grade_suffix = HRParameterFactory.getLocalInstance(ctx).getParamterValue(HRParameterEnum.SAL_POINTGRADE_TABLE_SUFFIX);
        int int_point_suffix = Integer.parseInt(point_suffix);
        String newPointValue = Integer.valueOf(++int_point_suffix).toString();
        HRParameterFactory.getLocalInstance(ctx).updateParamterValue(HRParameterEnum.SAL_POINT_TABLE_SUFFIX, newPointValue);
        int int_grade_suffix = Integer.parseInt(point_suffix);
        String newGradeValue = Integer.valueOf(++int_grade_suffix).toString();
        HRParameterFactory.getLocalInstance(ctx).updateParamterValue(HRParameterEnum.SAL_POINTGRADE_TABLE_SUFFIX, newGradeValue);
        String pointTableName = point_prefix + point_suffix;
        String gradeTableName = grade_prefix + grade_suffix;
        pointTableName = pointTableName + new java.util.Date().getTime();
        if (pointTableName.length() > 30) {
            pointTableName = pointTableName.substring(0, 30);
        }
        if ((gradeTableName = gradeTableName + new java.util.Date().getTime()).length() > 30) {
            gradeTableName = gradeTableName.substring(0, 30);
        }
        map.put("pointTableName", pointTableName);
        map.put("gradeTableName", gradeTableName);
        return map;
    }
}

