/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.person.Genders;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.person.PersonStates;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.EASDBException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.util.HRParamUtil;
import com.kingdee.eas.hr.benefit.util.BenefitUtils;
import com.kingdee.eas.hr.compensation.AuditForJointAssCollection;
import com.kingdee.eas.hr.compensation.AuditForJointAssFactory;
import com.kingdee.eas.hr.compensation.CmpDataCheckFacadeFactory;
import com.kingdee.eas.hr.compensation.CmpItemInfo;
import com.kingdee.eas.hr.compensation.CmpPeriodCollection;
import com.kingdee.eas.hr.compensation.CmpPeriodException;
import com.kingdee.eas.hr.compensation.CmpPeriodFactory;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.compensation.CmpSchemeException;
import com.kingdee.eas.hr.compensation.CmpSchemeFactory;
import com.kingdee.eas.hr.compensation.CmpSchemeInfo;
import com.kingdee.eas.hr.compensation.CmpSchemeItemCollection;
import com.kingdee.eas.hr.compensation.CmpSchemeItemFactory;
import com.kingdee.eas.hr.compensation.CmpSchemeItemInfo;
import com.kingdee.eas.hr.compensation.CmpSchmException;
import com.kingdee.eas.hr.compensation.ColumnMetasInfo;
import com.kingdee.eas.hr.compensation.EmpCmpSchmFacadeFactory;
import com.kingdee.eas.hr.compensation.GrantFactory;
import com.kingdee.eas.hr.compensation.HRParameterEnum;
import com.kingdee.eas.hr.compensation.HRParameterFactory;
import com.kingdee.eas.hr.compensation.ICmpDataCheckFacade;
import com.kingdee.eas.hr.compensation.ICmpPeriod;
import com.kingdee.eas.hr.compensation.ICmpScheme;
import com.kingdee.eas.hr.compensation.ICmpSchemeItem;
import com.kingdee.eas.hr.compensation.IEmpCmpSchmFacade;
import com.kingdee.eas.hr.compensation.IHRParameter;
import com.kingdee.eas.hr.compensation.ItemDataTypeEnum;
import com.kingdee.eas.hr.compensation.JointAssessmentCollection;
import com.kingdee.eas.hr.compensation.JointAssessmentFactory;
import com.kingdee.eas.hr.compensation.JointAssessmentInfo;
import com.kingdee.eas.hr.compensation.SchemeAuditedEnum;
import com.kingdee.eas.hr.compensation.SchemeException;
import com.kingdee.eas.hr.compensation.SchmPersonInfo;
import com.kingdee.eas.hr.compensation.TaxRateException;
import com.kingdee.eas.hr.compensation.app.AbstractSchemeFacadeControllerBean;
import com.kingdee.eas.hr.compensation.app.AdapterDynamicDBTable;
import com.kingdee.eas.hr.compensation.util.CmpGrantUtil;
import com.kingdee.eas.hr.compensation.util.CompUtils;
import com.kingdee.eas.hr.compensation.util.HRCmpIndexUtils;
import com.kingdee.eas.hr.compensation.util.HRCmpItemUtils;
import com.kingdee.eas.hr.compensation.util.HRDynamicTableUtils;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.hr.compensation.util.HRTableTools;
import com.kingdee.eas.hr.compensation.util.HRUtils;
import com.kingdee.eas.hr.compensation.util.syn.SynCompensationData80New;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;

public class SchemeFacadeControllerBean
extends AbstractSchemeFacadeControllerBean {
    private HashMap noAccountPersonMap = new HashMap();
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.compensation.app.SchemeFacadeControllerBean");

    @Override
    protected SchmPersonInfo[] _getPerson(Context ctx, String strSchemeID, String strOrgUnitID) throws BOSException, SchemeException, EASBizException {
        SchmPersonInfo[] schemePersonInfos = null;
        String sql = this.getSchmPersonSql(ctx, strSchemeID);
        IRowSet rs = null;
        try {
            Object[] params = new Object[]{strOrgUnitID};
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
            int count = 0;
            schemePersonInfos = new SchmPersonInfo[rs.size()];
            SchmPersonInfo info = null;
            PersonInfo personInfo = null;
            while (rs.next()) {
                info = new SchmPersonInfo();
                personInfo = new PersonInfo();
                personInfo.setName(rs.getString("name"));
                personInfo.setId(BOSUuid.read((String)rs.getString("id")));
                personInfo.setGender(Genders.getEnum((int)rs.getInt("gender")));
                personInfo.setNumber(rs.getString("number"));
                if (rs.getInt("state") >= 0) {
                    personInfo.setState(PersonStates.getEnum((int)rs.getInt("state")));
                }
                info.setPersonInfo(personInfo);
                info.setOrgUnitID(rs.getString("orgunitid"));
                info.setOrgUnitName(rs.getString("orgunitname"));
                info.setPositionID(rs.getString("positionid"));
                info.setPositionName(rs.getString("positionname"));
                if (strSchemeID == null) {
                    info.setId(null);
                } else {
                    info.setId(rs.getString("fpersonid"));
                }
                if (info.getId() == null) {
                    info.setUsed(false);
                } else {
                    info.setUsed(true);
                }
                schemePersonInfos[count] = info;
                ++count;
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        return schemePersonInfos;
    }

    public String getSchmPersonSql(Context ctx, String tableName) {
        if (tableName == null) {
            return this.getSchmPersonSql(ctx);
        }
        String ml = "_" + ctx.getLocale().toString();
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT emp.id,emp.name,emp.gender,emp.state,emp.number,emp.orgunitname,emp.orgunitid,");
        sql.append(" emp.positionid,emp.positionname,tblHor.fpersonid ");
        sql.append(" FROM (SELECT FPERSONID FROM ");
        sql.append(tableName);
        sql.append(" ) as tblHor ");
        sql.append(" RIGHT OUTER JOIN ");
        sql.append(" (SELECT DISTINCT person.fid as id,person.fnumber as number,person.fname");
        sql.append(ml);
        sql.append(" as name,");
        sql.append(" person.fgender as gender,person.fstate as state,baseunit.fname");
        sql.append(ml);
        sql.append(" as orgunitname,");
        sql.append(" position.FAdminOrgUnitID as orgunitid,");
        sql.append(" position.fid as positionid,position.fname");
        sql.append(ml);
        sql.append(" as positionname");
        sql.append(" FROM t_bd_person as person");
        sql.append(" INNER JOIN t_org_positionmember as positionmember on person.fid = positionmember.fpersonid");
        sql.append(" INNER JOIN t_org_position       as position       on positionmember.fpositionid = position.fid");
        sql.append(" LEFT OUTER JOIN t_org_admin     as adminorgunit   on position.FAdminOrgUnitID = adminorgunit.fid");
        sql.append(" LEFT OUTER JOIN t_org_baseunit  as baseunit       on adminorgunit.fid = baseunit.fid");
        sql.append("  ) as emp");
        sql.append(" ON emp.id = tblHor.fpersonid");
        sql.append(" WHERE emp.orgunitid = ?  order by tblHor.FPERSONID DESC");
        return sql.toString();
    }

    public String getSchmPersonSql(Context ctx) {
        String ml = "_" + ctx.getLocale().toString();
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT emp.id,emp.name,emp.gender,emp.state,emp.number,emp.orgunitname,emp.orgunitid,");
        sql.append(" emp.positionid,emp.positionname ");
        sql.append(" FROM ");
        sql.append(" (SELECT DISTINCT person.fid as id,person.fnumber as number,person.fname");
        sql.append(ml);
        sql.append(" as name,");
        sql.append(" person.fgender as gender,person.fstate as state,baseunit.fname");
        sql.append(ml);
        sql.append(" as orgunitname,");
        sql.append(" position.FAdminOrgUnitID as orgunitid,");
        sql.append(" position.fid as positionid,position.fname");
        sql.append(ml);
        sql.append(" as positionname");
        sql.append(" FROM t_bd_person as person");
        sql.append(" INNER JOIN t_org_positionmember as positionmember on person.fid = positionmember.fpersonid");
        sql.append(" INNER JOIN t_org_position       as position       on positionmember.fpositionid = position.fid");
        sql.append(" LEFT OUTER JOIN t_org_admin     as adminorgunit   on position.FAdminOrgUnitID = adminorgunit.fid");
        sql.append(" LEFT OUTER JOIN t_org_baseunit  as baseunit       on adminorgunit.fid = baseunit.fid");
        sql.append("  ) as emp WHERE emp.orgunitid = ?  ");
        return sql.toString();
    }

    @Override
    protected boolean _updateEmpCmpSchmTable(Context ctx, String tableName, List lstColumn, List lstValue) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement ps = null;
        StringBuffer sqlUpdate = new StringBuffer(" UPDATE " + tableName);
        int countLine = lstColumn.size();
        boolean ifFirstColumn = true;
        CmpItemInfo infoColumn = null;
        for (int i = 1; i < countLine; ++i) {
            infoColumn = (CmpItemInfo)lstColumn.get(i);
            if (ifFirstColumn) {
                sqlUpdate.append(" SET " + infoColumn.getNumber() + "=?");
                ifFirstColumn = false;
                continue;
            }
            sqlUpdate.append(',' + infoColumn.getNumber() + "=?");
        }
        sqlUpdate.append(" WHERE FPersonID = ?");
        Iterator itr = lstValue.iterator();
        Object[] value = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.prepareStatement(sqlUpdate.toString());
            while (itr.hasNext()) {
                value = (Object[])itr.next();
                int i = 1;
                int param = 1;
                while (i < countLine) {
                    if (value[i] instanceof Integer) {
                        if (value[i] == null) {
                            ps.setNull(param, 4);
                        } else {
                            ps.setInt(param, (Integer)value[i]);
                        }
                    } else if (value[i] instanceof BigDecimal) {
                        if (value[i] == null) {
                            ps.setNull(param, 3);
                        } else {
                            ps.setBigDecimal(param, (BigDecimal)value[i]);
                        }
                    } else if (value[i] instanceof Date) {
                        if (value[i] == null) {
                            ps.setNull(param, 91);
                        } else {
                            ps.setDate(param, new java.sql.Date(((Date)value[i]).getTime()));
                        }
                    } else if (value[i] instanceof Boolean) {
                        if (value[i] == null) {
                            ps.setNull(param, 16);
                        } else {
                            ps.setBoolean(param, (Boolean)value[i]);
                        }
                    } else if (value[i] == null) {
                        ps.setNull(param, 12);
                    } else {
                        ps.setString(param, value[i].toString());
                    }
                    ++i;
                    ++param;
                }
                ps.setString(countLine, value[0].toString());
                ps.execute();
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
        return true;
    }

    @Override
    protected void _auditCmpScheme(Context ctx, IObjectPK id) throws BOSException, EASBizException {
        ICmpScheme iCmpScheme = CmpSchemeFactory.getLocalInstance(ctx);
        CmpSchemeInfo infoCmpScheme = iCmpScheme.getCmpSchemeInfo(" select *,cmpPeriod.* where id='" + id.toString() + "'");
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)infoCmpScheme.getBOSType(), (IObjectPK)id, (String)infoCmpScheme.getName(), (String)"cmpscheme_audit");
        if (infoCmpScheme.getCalCount() <= 0) {
            throw new CmpSchemeException(CmpSchemeException.CMPSCHEME_CALCULATE_NOT);
        }
        if (infoCmpScheme.getAudit().equals((Object)SchemeAuditedEnum.NOTAUDITED) || infoCmpScheme.getAudit().equals((Object)SchemeAuditedEnum.AUDITEDNOTPASS)) {
            this._checkEndInputAuditValue(ctx, infoCmpScheme.getId().toString(), infoCmpScheme.getCmpPeriod().getId().toString(), infoCmpScheme.getTime());
        }
        this.changeCmpSchemeToAudited(ctx, infoCmpScheme);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    private void changeCmpSchemeToAudited(Context ctx, CmpSchemeInfo infoCmpScheme) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer("");
        sql.append(" update T_HR_CMPSCHEME set FAudit=40 ");
        if (ctx != null && ContextUtil.getCurrentUserInfo((Context)ctx) != null && ContextUtil.getCurrentUserInfo((Context)ctx).getPerson() != null) {
            sql.append(",FAuditPerson = '" + ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString() + "' ");
        }
        sql.append(" where FID='" + infoCmpScheme.getId() + "'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    @Override
    protected String _checkDateOfFuTble(Context ctx, IObjectPK pk, String closeType) throws BOSException, EASBizException {
        String getCurPeriodTime = null;
        ICmpScheme iCmpScheme = CmpSchemeFactory.getLocalInstance(ctx);
        CmpSchemeInfo infoCmpScheme = iCmpScheme.getCmpSchemeInfo("select *,currency.*,cmpPeriod.* where id='" + pk.toString() + "'");
        CmpPeriodInfo infoCmpPeriod = infoCmpScheme.getCmpPeriod();
        int time = infoCmpScheme.getTime();
        String futureTblName = infoCmpScheme.getFutureTableName();
        if (futureTblName != null && !"".equals(futureTblName)) {
            try {
                int maxTimeInFuTbl;
                int count = this.getFuTblDataCount(ctx, infoCmpScheme);
                if (count > 0 && (maxTimeInFuTbl = this.getMaxTimeOfFuTble(ctx, futureTblName, infoCmpPeriod)) > time && "period".equals(closeType)) {
                    StringBuffer getCurPeriodTimeSql = new StringBuffer();
                    getCurPeriodTimeSql.append("select distinct cmpPeriod.fnumber fnumber, fuTblName.ftime futbltime from ").append(futureTblName).append(" fuTblName").append(" inner join t_hr_cmpperiod cmpPeriod on fuTblName.fPeriod=cmpPeriod.fid").append(" where cmpPeriod.fid ='" + infoCmpPeriod.getId().toString() + "'").append("order by ftime asc");
                    IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)getCurPeriodTimeSql.toString());
                    StringBuffer getCurPeriodTimebuf = null;
                    while (iRowSet.next()) {
                        if (getCurPeriodTimebuf == null) {
                            getCurPeriodTimebuf = new StringBuffer();
                        }
                        getCurPeriodTimebuf.append(iRowSet.getString("futbltime")).append(",");
                    }
                    if (getCurPeriodTimebuf != null && getCurPeriodTimebuf.lastIndexOf(",") != -1) {
                        getCurPeriodTime = getCurPeriodTimebuf.deleteCharAt(getCurPeriodTimebuf.length() - 1).toString();
                    }
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return getCurPeriodTime;
    }

    @Override
    protected void _closeCmpScheme(Context ctx, IObjectPK pk, String colseType) throws BOSException, EASBizException {
        try {
            ICmpScheme iCmpScheme = CmpSchemeFactory.getLocalInstance(ctx);
            CmpSchemeInfo infoCmpScheme = iCmpScheme.getCmpSchemeInfo("select *,currency.*,cmpPeriod.* where id='" + pk.toString() + "'");
            CmpSchemeInfo infoCmpScheme_oldInfo = (CmpSchemeInfo)infoCmpScheme.clone();
            CmpPeriodInfo infoCmpPeriod = infoCmpScheme.getCmpPeriod();
            int time = infoCmpScheme.getTime();
            IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)infoCmpScheme.getBOSType(), (IObjectPK)pk, (String)infoCmpScheme.getName(), (String)"cmphisdata_settle");
            infoCmpScheme.setHisTableName(this.doHistoryTable(ctx, pk, infoCmpScheme, iCmpScheme));
            infoCmpScheme.setPerDataTableName(this.doPerDataTable(ctx, pk, infoCmpScheme, infoCmpPeriod.getId().toString(), infoCmpScheme.getHorTableName()));
            String futureTblName = infoCmpScheme.getFutureTableName();
            String endInputTableName = HRTableTools.getEndInputTableName(ctx, pk.toString());
            if (futureTblName != null && !"".equals(futureTblName)) {
                this.closeSchemeHasFuture(ctx, infoCmpScheme, infoCmpPeriod, time, colseType, endInputTableName, futureTblName);
                this.syncPersonFromDynTable(ctx, infoCmpScheme.getHorTableName(), infoCmpScheme.getId().toString(), infoCmpScheme.getCmpPeriod().getId().toString(), infoCmpScheme.getTime());
            } else {
                this.closeSchemeNoFuture(ctx, infoCmpScheme, infoCmpPeriod, time, colseType, endInputTableName);
            }
            this.doWithPeriodEndInputTable(ctx, infoCmpScheme, infoCmpPeriod, time, endInputTableName);
            this.doWithPeriodEndInputStatus(ctx, infoCmpScheme, infoCmpPeriod, time);
            if (HRParamUtil.getParamOfHR((Context)ctx, (String)"hr_cmp_017", (String)ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString())) {
                infoCmpScheme_oldInfo.setHisTableName(infoCmpScheme.getHisTableName());
                logger.info((Object)">>>>>>>>>>>>>>>>_closeCmpScheme synCloseData begin");
                new SynCompensationData80New().synCloseData(ctx, infoCmpScheme_oldInfo);
                logger.info((Object)">>>>>>>>>>>>>>>>_closeCmpScheme synCloseData end");
            }
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        }
        catch (CmpPeriodException e) {
            throw e;
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (BOSException e) {
            throw e;
        }
        catch (Exception e) {
            logger.info((Object)e);
            throw new CmpSchemeException(CmpSchemeException.CMPSCHEME_CLOSE_FAIL);
        }
    }

    private void updateCheckState(Context ctx, CmpSchemeInfo infoCmpScheme) throws BOSException, EASBizException {
        String horTable = infoCmpScheme.getHorTableName();
        if (!StringUtils.isEmpty((String)horTable)) {
            String sql = "update " + horTable + " set FCalType = 0 ";
            DbUtil.execute((Context)ctx, (String)sql);
        }
    }

    @Override
    protected void _checkHasUpdate(Context ctx, CmpSchemeInfo schemeInfo) throws BOSException, EASBizException {
        String str;
        IRowSet rs;
        String horTable = schemeInfo.getHorTableName();
        if (!StringUtils.isEmpty((String)horTable) && (rs = DbUtil.executeQuery((Context)ctx, (String)(str = " SELECT 1 FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FCalType' AND KSQL_COL_TABNAME='" + horTable + "'"))).size() == 0) {
            throw new CmpSchmException(CmpSchmException.SCHEME_UPDATE_ERROR);
        }
    }

    private void closeSchemeNoFuture(Context ctx, CmpSchemeInfo infoCmpScheme, CmpPeriodInfo infoCmpPeriod, int time, String colseType, String endInputTableName) throws BOSException, SQLException, EASBizException {
        ICmpScheme iCmpScheme = CmpSchemeFactory.getLocalInstance(ctx);
        this.recordAuditor(ctx, infoCmpScheme, infoCmpPeriod, time);
        this.doClearCmpScheme(ctx, infoCmpScheme, iCmpScheme, colseType);
        this.doValueKeep(ctx, infoCmpScheme, endInputTableName);
        this.doClearCmpSchemeTable(ctx, infoCmpScheme);
        this.clearClosedSchemeAuditPerson(ctx, infoCmpScheme.getId().toString());
        HRSchemeUtils.checkShemeUpdate(ctx, infoCmpScheme);
        this.updateCheckState(ctx, infoCmpScheme);
    }

    private void closeSchemeHasFuture(Context ctx, CmpSchemeInfo infoCmpScheme, CmpPeriodInfo infoCmpPeriod, int time, String colseType, String endInputTableName, String futureTblName) throws BOSException, SQLException, EASBizException {
        ICmpScheme iCmpScheme = CmpSchemeFactory.getLocalInstance(ctx);
        int count = this.getFuTblDataCount(ctx, infoCmpScheme);
        if (count <= 0) {
            this.closeSchemeNoFuture(ctx, infoCmpScheme, infoCmpPeriod, time, colseType, endInputTableName);
            return;
        }
        if ("period".equals(colseType)) {
            int maxTimeInFuTbl = this.getMaxTimeOfFuTble(ctx, futureTblName, infoCmpPeriod);
            if (maxTimeInFuTbl > time) {
                this.delPeriodDateOfFuTble(ctx, futureTblName, infoCmpPeriod);
                this.delPeriodDateOfPerInput(ctx, infoCmpScheme, infoCmpPeriod, maxTimeInFuTbl, time, endInputTableName);
                this.delEndInputStatus(ctx, infoCmpScheme, infoCmpPeriod, maxTimeInFuTbl, time);
            }
            if (this.getFuTblDataCount(ctx, infoCmpScheme) > 0) {
                this.putFuDataToHorTbl(ctx, infoCmpScheme, iCmpScheme);
                this.doValueKeepForAccountClose(ctx, infoCmpScheme, iCmpScheme, infoCmpPeriod, endInputTableName);
            } else {
                this.closeSchemeNoFuture(ctx, infoCmpScheme, infoCmpPeriod, time, colseType, endInputTableName);
            }
        } else {
            int maxTimeInFuTbl = this.getMaxTimeOfFuTble(ctx, futureTblName, infoCmpPeriod);
            if (maxTimeInFuTbl > time) {
                this.putFuDataToHorTbl(ctx, infoCmpScheme, iCmpScheme);
                this.doValueKeepForAccountClose(ctx, infoCmpScheme, iCmpScheme, infoCmpPeriod, endInputTableName);
            } else {
                this.closeSchemeNoFuture(ctx, infoCmpScheme, infoCmpPeriod, time, colseType, endInputTableName);
            }
        }
    }

    private void recordAuditor(Context ctx, CmpSchemeInfo infoCmpScheme, CmpPeriodInfo infoCmpPeriod, int time) throws BOSException, SQLException {
        String schemeId = infoCmpScheme.getId().toString();
        String periodId = infoCmpPeriod.getId().toString();
        String personId = null;
        personId = this.getCmpSendAuditor(ctx, infoCmpScheme.getId().toString(), infoCmpScheme.getCmpPeriod().getId().toString(), time);
        if (personId != null) {
            StringBuffer udAditorSql = new StringBuffer();
            if (infoCmpScheme.getAuditPerson() != null) {
                personId = infoCmpScheme.getAuditPerson().getId().toString();
                udAditorSql.append("update T_HR_CmpSAuditor set fAuditor='").append(personId).append("'").append(" where FCmpSchemeID='").append(schemeId).append("'").append(" and FCmpPeriodID='").append(periodId).append("'").append(" and fTime=").append(time);
                DbUtil.execute((Context)ctx, (String)udAditorSql.toString());
            } else {
                udAditorSql.append("delete from T_HR_CmpSAuditor").append(" where FCmpSchemeID='").append(schemeId).append("'").append(" and FCmpPeriodID='").append(periodId).append("'").append(" and fTime=").append(time);
                DbUtil.execute((Context)ctx, (String)udAditorSql.toString());
            }
        } else if (infoCmpScheme.getAuditPerson() != null) {
            personId = infoCmpScheme.getAuditPerson().getId().toString();
            StringBuffer insertAditorSql = new StringBuffer();
            insertAditorSql.append("insert into T_HR_CmpSAuditor (FID,FCmpSchemeID,FCmpPeriodID,fTime,fAuditor) values('").append(BOSUuid.create((BOSObjectType)BOSObjectType.create((String)"CEB14BF2"))).append("','").append(schemeId).append("','").append(periodId).append("',").append("" + time).append(",'").append(personId).append("')");
            DbUtil.execute((Context)ctx, (String)insertAditorSql.toString());
        }
    }

    private String getCmpSendAuditor(Context ctx, String cmpSchemeId, String periodId, int time) throws BOSException, SQLException {
        StringBuffer auditPersonSql = new StringBuffer();
        auditPersonSql.append("select fAuditor from T_HR_CmpSAuditor where FCmpSchemeID='").append(cmpSchemeId).append("'").append(" and FCmpPeriodID='").append(periodId).append("'").append(" and fTime=").append(time);
        IRowSet iAuditRowSet = DbUtil.executeQuery((Context)ctx, (String)auditPersonSql.toString());
        String personId = null;
        if (iAuditRowSet.next()) {
            personId = iAuditRowSet.getString("fAuditor");
        }
        return personId;
    }

    private int getMaxTimeOfFuTble(Context ctx, String futureTblName, CmpPeriodInfo infoCmpPeriod) throws BOSException, SQLException {
        StringBuffer getMaxTimeSql = new StringBuffer();
        getMaxTimeSql.append("select MAX(fTime) as fTime from ").append(futureTblName).append(" where fPeriod='").append(infoCmpPeriod.getId().toString()).append("'");
        IRowSet maxRowSet = DbUtil.executeQuery((Context)ctx, (String)getMaxTimeSql.toString());
        int maxTimeInFuTbl = -1;
        while (maxRowSet.next()) {
            maxTimeInFuTbl = maxRowSet.getInt("fTime");
        }
        return maxTimeInFuTbl;
    }

    private void delPeriodDateOfFuTble(Context ctx, String futureTblName, CmpPeriodInfo infoCmpPeriod) throws BOSException, SQLException {
        StringBuffer delPeriodDateSql = new StringBuffer();
        delPeriodDateSql.append("delete from ").append(futureTblName).append(" where fPeriod='").append(infoCmpPeriod.getId().toString()).append("'");
        DbUtil.execute((Context)ctx, (String)delPeriodDateSql.toString());
    }

    private void delPeriodDateOfPerInput(Context ctx, CmpSchemeInfo infoCmpScheme, CmpPeriodInfo infoCmpPeriod, int maxTimeInFuTbl, int time, String tableName) throws BOSException, SQLException {
        StringBuffer delPeriodDateSql = new StringBuffer();
        delPeriodDateSql.append("delete from ").append(tableName).append(" where fcmpperiodid='").append(infoCmpPeriod.getId().toString()).append("'").append(" and fcmpschemeid='").append(infoCmpScheme.getId().toString()).append("'").append(" and ftime>").append(time).append(" and ftime<=").append(maxTimeInFuTbl);
        DbUtil.execute((Context)ctx, (String)delPeriodDateSql.toString());
    }

    private void delEndInputStatus(Context ctx, CmpSchemeInfo infoCmpScheme, CmpPeriodInfo infoCmpPeriod, int maxTimeInFuTbl, int time) throws BOSException, SQLException {
        StringBuffer delAuditSql = new StringBuffer();
        delAuditSql.append("delete from T_HR_PEndInStatus where ").append(" FCmpSchemeID='").append(infoCmpScheme.getId().toString()).append("'").append(" and FCmpPeriodID='").append(infoCmpPeriod.getId().toString()).append("'").append(" and ftime>").append(time).append(" and ftime<=").append(maxTimeInFuTbl);
        DbUtil.execute((Context)ctx, (String)delAuditSql.toString());
    }

    private int getFuTblDataCount(Context ctx, CmpSchemeInfo infoCmpScheme) throws BOSException, SQLException {
        String futureTblName = infoCmpScheme.getFutureTableName();
        StringBuffer futureSql = new StringBuffer();
        futureSql.append("select count(*) from ").append(futureTblName).append(" fuTbl");
        IRowSet countRow = DbUtil.executeQuery((Context)ctx, (String)futureSql.toString());
        int count = 0;
        while (countRow.next()) {
            count = countRow.getInt(1);
        }
        return count;
    }

    private void putFuDataToHorTbl(Context ctx, CmpSchemeInfo infoCmpScheme, ICmpScheme iCmpScheme) throws BOSException, SQLException, EASBizException {
        String futureTblName = infoCmpScheme.getFutureTableName();
        String horTblName = infoCmpScheme.getHorTableName();
        StringBuffer delHorSql = new StringBuffer();
        delHorSql.append("delete from ").append(horTblName);
        DbUtil.execute((Context)ctx, (String)delHorSql.toString());
        StringBuffer getNexPeriodTimeSql = new StringBuffer();
        getNexPeriodTimeSql.append("select top 1 fPeriod,fAudit,FCalCount,FBeginDate,fTime as fTime from ").append(futureTblName).append(" fuTblName").append(" inner join t_hr_cmpPeriod cmpPeriod on fuTblName.fPeriod=cmpPeriod.fid").append(" group by fPeriod,FBeginDate,fTime,fAudit,FCalCount order by FBeginDate,fuTblName.fTime asc");
        IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)getNexPeriodTimeSql.toString());
        int time = 0;
        String cmpPeriodID = "";
        while (iRowSet.next()) {
            cmpPeriodID = iRowSet.getString("fPeriod");
            time = iRowSet.getInt("fTime");
            int FCalCount = iRowSet.getInt("FCalCount");
            infoCmpScheme.setAudit(SchemeAuditedEnum.getEnum(iRowSet.getInt("fAudit")));
            infoCmpScheme.setTime(time);
            if (iRowSet.getInt("fAudit") != 40) {
                infoCmpScheme.setCalCount(FCalCount);
            }
            CmpPeriodInfo period = new CmpPeriodInfo();
            period.setId(BOSUuid.read((String)cmpPeriodID));
            infoCmpScheme.setCmpPeriod(period);
            String personId = this.getCmpSendAuditor(ctx, infoCmpScheme.getId().toString(), infoCmpScheme.getCmpPeriod().getId().toString(), time);
            if (personId != null) {
                PersonInfo person = new PersonInfo();
                person.setId(BOSUuid.read((String)personId));
                infoCmpScheme.setAuditPerson(person);
            } else if (iRowSet.getInt("fAudit") == 40) {
                infoCmpScheme.setAuditPerson(ContextUtil.getCurrentUserInfo((Context)ctx).getPerson());
                infoCmpScheme.setCalCount(FCalCount);
            } else {
                infoCmpScheme.setAuditPerson(null);
            }
            if (iRowSet.getInt("fAudit") != 40 && iRowSet.getInt("fAudit") != 20) continue;
            infoCmpScheme.setCalCount(1);
        }
        String horTableName = infoCmpScheme.getHorTableName();
        iRowSet = DbUtil.executeQuery((Context)ctx, (String)(" SELECT * FROM " + horTableName));
        ResultSetMetaData temp = iRowSet.getMetaData();
        StringBuffer sql = new StringBuffer("");
        sql.append("insert into ").append(horTableName).append(" select ");
        int size = temp.getColumnCount();
        for (int i = 1; i <= size; ++i) {
            String columnName = temp.getColumnName(i).toUpperCase();
            if (i != size) {
                sql.append(" fuTbl.").append(columnName).append(",");
                continue;
            }
            sql.append(" fuTbl.").append(columnName);
        }
        sql.append(" from ").append(futureTblName).append(" fuTbl").append(" where fuTbl.fPeriod='").append(cmpPeriodID).append("' and fuTbl.FTime=").append("" + time);
        DbUtil.execute((Context)ctx, (String)sql.toString());
        StringBuffer delSql = new StringBuffer();
        delSql.append("delete from ").append(futureTblName).append(" where fPeriod='").append(cmpPeriodID).append("'").append(" and fTime=").append("" + time);
        DbUtil.execute((Context)ctx, (String)delSql.toString());
        iCmpScheme.submit((CoreBaseInfo)infoCmpScheme);
    }

    private void doWithPeriodEndInputTable(Context ctx, CmpSchemeInfo infoCmpScheme, CmpPeriodInfo infoCmpPeriod, int time, String tableName) throws BOSException, EASBizException {
        StringBuffer endInputHissql = new StringBuffer("");
        endInputHissql.append("insert into T_Hr_PeriodEndInputBak ").append("(FID,FVALUE,FCMPPERIODID,FCMPITEMID,FPERSONID,FCMPSCHEMEID,FSUPPLY,FFLOATVALUE,").append("FINTVALUE,FSTRINGVALUE,FDATEVALUE,FTIME)").append("select ").append("FID,FVALUE,FCMPPERIODID,FCMPITEMID,FPERSONID,FCMPSCHEMEID,FSUPPLY,FFLOATVALUE,").append("FINTVALUE,FSTRINGVALUE,FDATEVALUE,FTIME ").append("from  ").append(tableName).append(" curTbl").append(" where curTbl.FCmpSchemeID=? ").append(" and  curTbl.FCmpPeriodID=? ").append(" and  curTbl.fTime=?");
        Object[] param = new Object[]{infoCmpScheme.getId().toString(), infoCmpPeriod.getId().toString(), new Integer(time)};
        DbUtil.execute((Context)ctx, (String)endInputHissql.toString(), (Object[])param);
        String strSql = " DELETE FROM " + tableName + " WHERE FCmpSchemeID=? and FCmpPeriodID=? and Ftime=?";
        DbUtil.execute((Context)ctx, (String)strSql, (Object[])param);
    }

    private String doHistoryTable(Context ctx, IObjectPK pk, CmpSchemeInfo infoCmpScheme, ICmpScheme iCmpScheme) throws Exception {
        String horTableName = infoCmpScheme.getHorTableName();
        String historyTableName = infoCmpScheme.getHisTableName();
        IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)(" SELECT top 1 * FROM " + horTableName));
        ResultSetMetaData temp = iRowSet.getMetaData();
        if (historyTableName == null || historyTableName.equals("")) {
            historyTableName = this.getNewHistoryTableName(ctx);
            ArrayList lstColumns = HRDynamicTableUtils.getSchemeDynamicTableInfosSchmItem(ctx, pk);
            ArrayList<ColumnMetasInfo> lstNewColumns = new ArrayList<ColumnMetasInfo>();
            if (lstColumns != null && lstColumns.size() > 0) {
                int i;
                HashMap<String, ColumnMetasInfo> mapColumns = new HashMap<String, ColumnMetasInfo>();
                ColumnMetasInfo infoColumnMetas = null;
                int size = lstColumns.size();
                for (i = 0; i < size; ++i) {
                    infoColumnMetas = (ColumnMetasInfo)lstColumns.get(i);
                    mapColumns.put(infoColumnMetas.getName().toUpperCase(), infoColumnMetas);
                }
                size = temp.getColumnCount();
                for (i = 1; i <= size; ++i) {
                    infoColumnMetas = (ColumnMetasInfo)mapColumns.get(temp.getColumnName(i).toUpperCase());
                    if (infoColumnMetas == null) {
                        throw new EASBizException(new NumericExceptionSubItem("100", ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"79_SchemeFacadeControllerBean", (Locale)ctx.getLocale()) + "\uff08" + temp.getColumnName(i) + "\uff09" + ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"80_SchemeFacadeControllerBean", (Locale)ctx.getLocale())));
                    }
                    lstNewColumns.add(infoColumnMetas);
                }
            }
            AdapterDynamicDBTable iDynamicDBTable = new AdapterDynamicDBTable(ctx, historyTableName, lstNewColumns);
            iDynamicDBTable.create();
            HRCmpIndexUtils.createIndexForSCHMHIS(ctx, historyTableName);
        }
        StringBuffer delDirtyDataSql = new StringBuffer();
        delDirtyDataSql.append("DELETE From ").append(historyTableName).append(" where fPeriod='").append(infoCmpScheme.getCmpPeriod().getId().toString()).append("' and fTime=").append(infoCmpScheme.getTime()).append("");
        DbUtil.execute((Context)ctx, (String)delDirtyDataSql.toString());
        String columnStr = this.getDynTableColumn(temp);
        StringBuffer sql = new StringBuffer("");
        sql.append("insert into ");
        sql.append(historyTableName).append("(").append(columnStr).append(")");
        sql.append(" select ").append(columnStr);
        sql.append(" from ");
        sql.append(horTableName);
        DbUtil.execute((Context)ctx, (String)sql.toString());
        return historyTableName;
    }

    private String getDynTableColumn(ResultSetMetaData columnMeta) throws SQLException {
        StringBuffer columnStr = new StringBuffer();
        int size = columnMeta.getColumnCount();
        for (int i = 1; i <= size; ++i) {
            if (i != 1) {
                columnStr.append(",");
            }
            columnStr.append(columnMeta.getColumnName(i).toUpperCase());
        }
        return columnStr.toString();
    }

    private String doPerDataTable(Context ctx, IObjectPK pk, CmpSchemeInfo infoCmpScheme, String strCmpPeriodID, String strHorTableName) throws Exception {
        String perDataTableName = infoCmpScheme.getPerDataTableName();
        if (perDataTableName == null || perDataTableName.equals("")) {
            perDataTableName = this.getNewHistoryTableName(ctx);
            StringBuffer sbCreateTable = new StringBuffer(" CREATE TABLE ");
            sbCreateTable.append(perDataTableName);
            sbCreateTable.append("(");
            sbCreateTable.append("FPersonID Varchar(44) ,");
            sbCreateTable.append("FPER001 NVarchar(80) ,");
            sbCreateTable.append("FPER002 NVarchar(80) ,");
            sbCreateTable.append("FPER004 NVarchar(80) ,");
            sbCreateTable.append("FPER005 NVarchar(100) ,");
            sbCreateTable.append("FPER003 NVarchar(255) ,");
            sbCreateTable.append("FPER006 NVarchar(80) ,");
            sbCreateTable.append("FPER007 NVarchar(80) ,");
            sbCreateTable.append("FPER009 NVarchar(80) ,");
            sbCreateTable.append("FPER011 NVarchar(80) ,");
            sbCreateTable.append("FPER012 NVarchar(80) ,");
            sbCreateTable.append("FPER013 NVarchar(80) ,");
            sbCreateTable.append("FPER016 NVarchar(80) ,");
            sbCreateTable.append("FPER017 NVarchar(80) ,");
            sbCreateTable.append("FPER018 NVarchar(80) ,");
            sbCreateTable.append("FPER019 NVarchar(80) ,");
            sbCreateTable.append("FPER021 NVarchar(80) ,");
            sbCreateTable.append("FPER022 NVarchar(80) ,");
            sbCreateTable.append("FPER023 NVarchar(80) ,");
            sbCreateTable.append("FPER025 NVarchar(80) ,");
            sbCreateTable.append("FPER026 NVarchar(80) ,");
            sbCreateTable.append("FPER027 NVarchar(80) ,");
            sbCreateTable.append("FPER030 NVarchar(80),");
            sbCreateTable.append("FPERIOD Varchar(44), ");
            sbCreateTable.append("FTime int ");
            sbCreateTable.append("   ) ");
            DbUtil.execute((Context)ctx, (String)sbCreateTable.toString());
        }
        String ml = "_" + ctx.getLocale().toString();
        StringBuffer sbInsert = new StringBuffer(" INSERT INTO ");
        sbInsert.append(perDataTableName);
        sbInsert.append(" (FPERSONID,FPER001,FPER002, FPER003,FPER004, FPER005, FPER006, FPER007, FPER009, FPER011, FPER012, FPER013, ");
        sbInsert.append("FPER016,FPER017,FPER018,FPER019,FPER021,FPER022,FPER023,FPER025,FPER026,FPER027, ");
        sbInsert.append(" FPER030, FPERIOD,FTime ");
        sbInsert.append(" ) SELECT  ");
        sbInsert.append("DISTINCT PERSON.FID  FPERSONID,  ");
        sbInsert.append("PERSON.FName" + ml + "  FPER001,  ");
        sbInsert.append("PERSON.FNumber  FPER002,  ");
        sbInsert.append("ATTACHDEPT.FDisplayName" + ml + "  FPER003,  ");
        sbInsert.append("ATTACHDEPT.FNumber  FPER004,  ");
        sbInsert.append("ATTACHDEPT.FName" + ml + "  FPER005,  ");
        sbInsert.append("POSITION.FName" + ml + "  FPER006,  ");
        sbInsert.append("JOB.FName" + ml + "  FPER007, ");
        sbInsert.append("JOBCATALOG.FName" + ml + "  FPER009,");
        sbInsert.append("WED.FName" + ml + "  FPER011, ");
        sbInsert.append("TECHPOSTTYPE.FName" + ml + "  FPER012,  ");
        sbInsert.append("TECHNICALPOST.FName" + ml + "  FPER013,  ");
        sbInsert.append("JOBLEVEL.FName" + ml + "  FPER016,  ");
        sbInsert.append("JOBGRADE.FName" + ml + "  FPER017,  ");
        sbInsert.append("EMPTYPE.FName" + ml + "  FPER018,  ");
        sbInsert.append("FORK.FName" + ml + "  FPER019,  ");
        sbInsert.append("DIPLOMA.FName" + ml + "  FPER021,  ");
        sbInsert.append("DEGREE1.FName" + ml + "  FPER022,  ");
        sbInsert.append("PERSON.FIDCardNO  FPER023,  ");
        sbInsert.append("PERSONCMP.FAccountOne  FPER025,  ");
        sbInsert.append("PERSONCMP.FAccountTwo  FPER026,  ");
        sbInsert.append("PERSONCMP.FAccountThree  FPER027,  ");
        sbInsert.append("PERSON.FPassportNO  FPER030,  ");
        sbInsert.append("'" + strCmpPeriodID + "' FPERIOD, ");
        sbInsert.append(infoCmpScheme.getTime() + " FTime ");
        sbInsert.append("FROM T_BD_Person  PERSON ");
        sbInsert.append("LEFT OUTER JOIN ");
        sbInsert.append(strHorTableName);
        sbInsert.append(" ON " + strHorTableName + ".Fpersonid = PERSON.fid ");
        sbInsert.append("LEFT OUTER JOIN T_HR_PersonDegree  PERSONDEGR ");
        sbInsert.append("ON PERSON.FID = PERSONDEGR.FPersonId ");
        sbInsert.append("LEFT OUTER JOIN T_HR_PersonPosition  PERSONPOSIT ");
        sbInsert.append("ON PERSON.FID = PERSONPOSIT.FPersonID ");
        sbInsert.append("LEFT OUTER JOIN T_BD_HRFolk  FORK ");
        sbInsert.append("ON PERSON.FFolkID = FORK.FID ");
        sbInsert.append("LEFT OUTER JOIN T_BD_HRWed  WED ");
        sbInsert.append("ON PERSON.FWedID = WED.FID ");
        sbInsert.append("LEFT OUTER JOIN T_HR_PersonCmp  PERSONCMP ");
        sbInsert.append("ON PERSON.FID = PERSONCMP.FPersonID ");
        sbInsert.append("LEFT OUTER JOIN T_HR_SocialInsurance  SOCIALINSURANCE ");
        sbInsert.append("ON PERSON.FID = SOCIALINSURANCE.FPersonID ");
        sbInsert.append("LEFT OUTER JOIN T_HR_BDEmployeeType  EMPTYPE ");
        sbInsert.append("ON PERSON.FEmployeeTypeID = EMPTYPE.FID ");
        sbInsert.append("LEFT OUTER JOIN T_HR_PersonContactMethod  PERSONCONTACTMETHOD ");
        sbInsert.append("ON PERSON.FID = PERSONCONTACTMETHOD.FPersonID ");
        sbInsert.append("LEFT OUTER JOIN T_BD_HRDiploma  DIPLOMA ");
        sbInsert.append("ON PERSON.FHighestDegreeID = DIPLOMA.FID ");
        sbInsert.append("LEFT OUTER JOIN T_HR_BDTechnicalPost  TECHNICALPOST ");
        sbInsert.append("ON PERSON.FHighestTechPostID = TECHNICALPOST.FID ");
        sbInsert.append("LEFT OUTER JOIN T_BD_HRDegree  DEGREE1 ");
        sbInsert.append("ON PERSONDEGR.FDegree = DEGREE1.FID ");
        sbInsert.append("LEFT OUTER JOIN T_HR_JobGrade  JOBGRADE ");
        sbInsert.append("ON PERSONPOSIT.FJobGrade = JOBGRADE.FID ");
        sbInsert.append("LEFT OUTER JOIN T_ORG_Admin  ATTACHDEPT ");
        sbInsert.append("ON PERSONPOSIT.FPersonDep = ATTACHDEPT.FID ");
        sbInsert.append("LEFT OUTER JOIN T_HR_JobLevel  JOBLEVEL ");
        sbInsert.append("ON PERSONPOSIT.FJobLevelID = JOBLEVEL.FID ");
        sbInsert.append("LEFT OUTER JOIN T_ORG_Position  POSITION ");
        sbInsert.append("ON PERSONPOSIT.FPrimaryPositionID = POSITION.FID ");
        sbInsert.append("LEFT OUTER JOIN T_HR_BDTechPostType  TECHPOSTTYPE ");
        sbInsert.append("ON TECHNICALPOST.FCategoryID = TECHPOSTTYPE.FID ");
        sbInsert.append("LEFT OUTER JOIN T_ORG_Job JOB ");
        sbInsert.append("ON POSITION.FJobID = JOB.FID ");
        sbInsert.append("LEFT OUTER JOIN T_ORG_JobCategory JOBCATALOG ");
        sbInsert.append("ON JOB.FJobCategoryID = JOBCATALOG.FID ");
        sbInsert.append("WHERE " + strHorTableName + ".FPERIOD IS NOT NULL ");
        DbUtil.execute((Context)ctx, (String)sbInsert.toString());
        return perDataTableName;
    }

    private void doValueKeep(Context ctx, CmpSchemeInfo infoCmpScheme, String tableName) throws BOSException, EASBizException {
        String sqlItem = " SELECT T_HR_CMPITEM.FID,T_HR_CMPITEM.FNUMBER,T_HR_CMPITEM.FDataType FROM T_HR_CMPSCHEMEITEM  LEFT OUTER JOIN T_HR_CMPITEM ON T_HR_CMPITEM.FID=T_HR_CMPSCHEMEITEM.FCMPITEMID WHERE FCMPSCHEMEID='" + infoCmpScheme.getId().toString() + "' AND FIsValueKeep =1 AND FIsDelete=0";
        IRowSet iRowSetItem = DbUtil.executeQuery((Context)ctx, (String)sqlItem);
        ArrayList<String> lstItem = new ArrayList<String>();
        HashMap<String, String> mapItem = new HashMap<String, String>();
        HashMap<String, Integer> mapItemDataType = new HashMap<String, Integer>();
        Connection conn = null;
        try {
            while (iRowSetItem.next()) {
                lstItem.add(iRowSetItem.getString(1));
                mapItem.put(iRowSetItem.getString(1), iRowSetItem.getString(2));
                mapItemDataType.put(iRowSetItem.getString(1), iRowSetItem.getInt(3));
            }
            if (lstItem.size() < 1) {
                return;
            }
            String fid = null;
            String personID = null;
            String itemID = null;
            String itemNumber = null;
            String cmpPeriodID = infoCmpScheme.getCmpPeriod().getId().toString();
            int time = infoCmpScheme.getTime();
            String cmpSchemeID = infoCmpScheme.getId().toString();
            StringBuffer sqlSelect = new StringBuffer();
            sqlSelect.append(" SELECT FID,FPERSONID,FCMPITEMID ");
            sqlSelect.append(" FROM ").append(tableName).append(" WHERE FCMPSCHEMEID='");
            sqlSelect.append(cmpSchemeID);
            sqlSelect.append("' AND FCmpPeriodID='");
            sqlSelect.append(cmpPeriodID);
            sqlSelect.append("' AND FTime=");
            sqlSelect.append(time);
            sqlSelect.append(" AND FCMPITEMID IN (");
            int size = lstItem.size();
            for (int i = 0; i < size; ++i) {
                sqlSelect.append("'");
                sqlSelect.append(lstItem.get(i));
                sqlSelect.append("',");
            }
            sqlSelect.deleteCharAt(sqlSelect.length() - 1);
            sqlSelect.append(")");
            IRowSet iRowSetSelect = DbUtil.executeQuery((Context)ctx, (String)sqlSelect.toString());
            HashMap<String, HashMap> mapData = new HashMap<String, HashMap>();
            HashMap mapPerson = null;
            while (iRowSetSelect.next()) {
                fid = iRowSetSelect.getString("FID");
                personID = iRowSetSelect.getString("FPERSONID");
                mapPerson = (HashMap)mapData.get(personID);
                if (mapPerson == null) {
                    mapPerson = new HashMap();
                }
                itemID = iRowSetSelect.getString("FCMPITEMID");
                mapPerson.put(itemID, fid);
                mapData.put(personID, mapPerson);
            }
            StringBuffer querySql = new StringBuffer();
            querySql.append(" SELECT FPERSONID FROM T_HR_PEndInStatus ");
            querySql.append(" WHERE FCMPSCHEMEID ='").append(cmpSchemeID).append("'");
            querySql.append(" and ftime = ").append(time).append(" and FCMPPERIODID = '").append(cmpPeriodID).append("' ");
            querySql.append(" and fempauditflag = 1 ");
            IRowSet iAuditSet = DbUtil.executeQuery((Context)ctx, (String)querySql.toString());
            HashMap autidPerosn = new HashMap();
            while (iAuditSet.next()) {
                autidPerosn.put(iAuditSet.getString("FPERSONID"), null);
            }
            Object objValue = null;
            Vector vecAdd = new Vector();
            Vector vecEdit = new Vector();
            Vector<Object> vecTemp = null;
            String sqlHorTable = " SELECT * FROM " + infoCmpScheme.getHorTableName();
            IRowSet iRowSetHorTable = DbUtil.executeQuery((Context)ctx, (String)sqlHorTable);
            while (iRowSetHorTable.next()) {
                personID = iRowSetHorTable.getString("FPERSONID");
                if (autidPerosn.containsKey(personID)) continue;
                mapPerson = (HashMap)mapData.get(personID);
                int size2 = lstItem.size();
                for (int i = 0; i < size2; ++i) {
                    itemID = lstItem.get(i).toString();
                    itemNumber = mapItem.get(itemID).toString();
                    objValue = iRowSetHorTable.getObject(itemNumber);
                    vecTemp = new Vector<Object>();
                    if (mapPerson != null && mapPerson.get(itemID) != null) {
                        fid = mapPerson.get(itemID).toString();
                        vecTemp.add(fid);
                        vecTemp.add(objValue);
                        vecTemp.add(itemID);
                        vecEdit.add(vecTemp);
                        continue;
                    }
                    vecTemp.add(personID);
                    vecTemp.add(itemID);
                    vecTemp.add(objValue);
                    vecAdd.add(vecTemp);
                }
            }
            conn = EJBFactory.getConnection((Context)ctx);
            int count = 0;
            Vector vecTempAdd = new Vector();
            int size3 = vecAdd.size();
            for (int i = 0; i < size3; ++i) {
                vecTempAdd.add(vecAdd.get(i));
                if (++count != 5000) continue;
                this.addBatchPeriodEndInputVaule(conn, vecTempAdd, tableName, cmpSchemeID, cmpPeriodID, time, mapItemDataType);
                vecTempAdd = new Vector();
                count = 0;
            }
            if (count > 0) {
                this.addBatchPeriodEndInputVaule(conn, vecTempAdd, tableName, cmpSchemeID, cmpPeriodID, time, mapItemDataType);
            }
            count = 0;
            Vector vecTempEdit = new Vector();
            int size4 = vecEdit.size();
            for (int i = 0; i < size4; ++i) {
                vecTempEdit.add(vecEdit.get(i));
                if (++count != 5000) continue;
                this.editBatchPeriodEndInputVaule(conn, vecTempEdit, mapItemDataType, tableName);
                vecTempEdit = new Vector();
                count = 0;
            }
            if (count > 0) {
                this.editBatchPeriodEndInputVaule(conn, vecTempEdit, mapItemDataType, tableName);
            }
            SQLUtils.cleanup((Connection)conn);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup(conn);
        }
    }

    private void editBatchPeriodEndInputVaule(Connection conn, Vector vecEdit, HashMap mapItemDataType, String tableName) throws BOSException, EASBizException {
        String sqlEdit = " UPDATE " + tableName + " SET FVALUE=?,FFloatValue=?,FIntValue=?,FStringValue=?,FDateValue=? WHERE FID=? ";
        PreparedStatement psEdit = null;
        try {
            psEdit = conn.prepareStatement(sqlEdit);
            Vector vecTemp = null;
            int size = vecEdit.size();
            for (int i = 0; i < size; ++i) {
                vecTemp = (Vector)vecEdit.get(i);
                int iDataType = (Integer)mapItemDataType.get(vecTemp.get(2).toString());
                psEdit.setObject(1, HRCmpItemUtils.convertCmpItemValueByDataType(60, vecTemp.get(1), iDataType), HRCmpItemUtils.getSqlTypeByCmpItemDataType(ItemDataTypeEnum.CURRENCY));
                psEdit.setObject(2, HRCmpItemUtils.convertCmpItemValueByDataType(50, vecTemp.get(1), iDataType), HRCmpItemUtils.getSqlTypeByCmpItemDataType(ItemDataTypeEnum.FLOAT));
                psEdit.setObject(3, HRCmpItemUtils.convertCmpItemValueByDataType(40, vecTemp.get(1), iDataType), HRCmpItemUtils.getSqlTypeByCmpItemDataType(ItemDataTypeEnum.INT));
                psEdit.setObject(4, HRCmpItemUtils.convertCmpItemValueByDataType(30, vecTemp.get(1), iDataType), HRCmpItemUtils.getSqlTypeByCmpItemDataType(ItemDataTypeEnum.STRING));
                psEdit.setObject(5, HRCmpItemUtils.convertCmpItemValueByDataType(20, vecTemp.get(1), iDataType), HRCmpItemUtils.getSqlTypeByCmpItemDataType(ItemDataTypeEnum.DATE));
                psEdit.setString(6, vecTemp.get(0).toString());
                psEdit.addBatch();
            }
            psEdit.executeBatch();
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup((Statement)psEdit);
        }
    }

    private void addBatchPeriodEndInputVaule(Connection conn, Vector vecAdd, String tableName, String cmpSchemeID, String cmpPeriodID, int time, HashMap mapItemDataType) throws BOSException, EASBizException, SQLException {
        String sqlAdd = " INSERT INTO " + tableName + "(FID,FValue,FFloatValue,FIntValue,FStringValue,FDateValue,FCmpPeriodID,FCmpItemID,FPersonID,FCmpSchemeID,FTime) VALUES(?,?,?,?,?,?,?,?,?,?,?)";
        PreparedStatement psAdd = null;
        try {
            psAdd = conn.prepareStatement(sqlAdd);
            Vector vecTemp = null;
            String fid = null;
            int size = vecAdd.size();
            for (int i = 0; i < size; ++i) {
                vecTemp = (Vector)vecAdd.get(i);
                fid = BOSUuid.create((String)"07D06752").toString();
                psAdd.setString(1, fid);
                int iDataType = (Integer)mapItemDataType.get(vecTemp.get(1).toString());
                psAdd.setObject(2, HRCmpItemUtils.convertCmpItemValueByDataType(60, vecTemp.get(2), iDataType), HRCmpItemUtils.getSqlTypeByCmpItemDataType(ItemDataTypeEnum.CURRENCY));
                psAdd.setObject(3, HRCmpItemUtils.convertCmpItemValueByDataType(50, vecTemp.get(2), iDataType), HRCmpItemUtils.getSqlTypeByCmpItemDataType(ItemDataTypeEnum.FLOAT));
                psAdd.setObject(4, HRCmpItemUtils.convertCmpItemValueByDataType(40, vecTemp.get(2), iDataType), HRCmpItemUtils.getSqlTypeByCmpItemDataType(ItemDataTypeEnum.INT));
                psAdd.setObject(5, HRCmpItemUtils.convertCmpItemValueByDataType(30, vecTemp.get(2), iDataType), HRCmpItemUtils.getSqlTypeByCmpItemDataType(ItemDataTypeEnum.STRING));
                psAdd.setObject(6, HRCmpItemUtils.convertCmpItemValueByDataType(20, vecTemp.get(2), iDataType), HRCmpItemUtils.getSqlTypeByCmpItemDataType(ItemDataTypeEnum.DATE));
                psAdd.setString(7, cmpPeriodID);
                psAdd.setString(8, vecTemp.get(1).toString());
                psAdd.setString(9, vecTemp.get(0).toString());
                psAdd.setString(10, cmpSchemeID);
                psAdd.setInt(11, time);
                psAdd.addBatch();
            }
            psAdd.executeBatch();
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup((Statement)psAdd);
        }
    }

    private void doClearCmpSchemeTable(Context ctx, CmpSchemeInfo infoCmpScheme) throws BOSException, EASBizException {
        String tableName = infoCmpScheme.getHorTableName();
        StringBuffer sql = new StringBuffer("");
        sql.append("UPDATE  ");
        sql.append(tableName);
        sql.append(" SET ");
        ICmpSchemeItem iCmpSchemeItem = CmpSchemeItemFactory.getLocalInstance(ctx);
        CmpSchemeItemCollection col = iCmpSchemeItem.getCmpSchemeItemCollection("select *,cmpItem.*,cmpItem.cmpItemCatalog.* where cmpScheme.id='" + infoCmpScheme.getId().toString() + "'");
        if (col != null && col.size() > 0) {
            Iterator itr = col.iterator();
            CmpSchemeItemInfo info = null;
            CmpItemInfo infoCmpItem = null;
            while (itr.hasNext()) {
                info = (CmpSchemeItemInfo)itr.next();
                infoCmpItem = info.getCmpItem();
                if (infoCmpItem == null || infoCmpItem.getNumber() == null || infoCmpItem.getType().getValue() != 20 && infoCmpItem.getDataType().getValue() != 60 && infoCmpItem.getDataType().getValue() != 50 && infoCmpItem.getDataType().getValue() != 40 || infoCmpItem.getCmpItemCatalog().getNumber().equalsIgnoreCase("FPER")) continue;
                String number = infoCmpItem.getNumber();
                sql.append(number);
                if (!(infoCmpItem.getDataType().getValue() != 60 && infoCmpItem.getDataType().getValue() != 50 && infoCmpItem.getDataType().getValue() != 40 || infoCmpItem.getCmpItemCatalog().getNumber().equalsIgnoreCase("FPER"))) {
                    sql.append(" =0 ,");
                    continue;
                }
                sql.append(" =null ,");
            }
        }
        sql.append("FPERIOD");
        sql.append("='");
        sql.append(infoCmpScheme.getCmpPeriod().getId().toString());
        sql.append("',FTime=");
        sql.append(infoCmpScheme.getTime());
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void doClearCmpScheme(Context ctx, CmpSchemeInfo infoCmpScheme, ICmpScheme iCmpScheme, String closedType) throws BOSException, EASBizException, CmpPeriodException {
        if ("period".equals(closedType)) {
            CmpPeriodInfo infoCmpPeriodInfo = this.doCmpPeriod(ctx, infoCmpScheme.getCmpPeriod());
            infoCmpScheme.setCmpPeriod(infoCmpPeriodInfo);
            infoCmpScheme.setTime(1);
        } else {
            infoCmpScheme.setTime(infoCmpScheme.getTime() + 1);
        }
        infoCmpScheme.setAudit(SchemeAuditedEnum.NOTAUDITED);
        infoCmpScheme.setCalCount(0);
        iCmpScheme.submit((CoreBaseInfo)infoCmpScheme);
    }

    private CmpPeriodInfo doCmpPeriod(Context ctx, CmpPeriodInfo infoCmpPeriod) throws BOSException, EASBizException {
        if ((infoCmpPeriod = HRUtils.getCmpPeriodInfoByConstantServer(ctx, infoCmpPeriod, 1)) == null) {
            throw new CmpPeriodException(CmpPeriodException.NOT_NEXT_PERIOD);
        }
        return infoCmpPeriod;
    }

    private String getNewHistoryTableName(Context ctx) throws BOSException, EASBizException {
        String tableName = null;
        IHRParameter iHRParameter = HRParameterFactory.getLocalInstance(ctx);
        String schm_prefix = iHRParameter.getParamterValue(HRParameterEnum.SCHM_HISTABLE_PREFIX);
        String schm_suffix = iHRParameter.getParamterValue(HRParameterEnum.SCHM_HISTABLE_SUFFIX);
        int int_schm_suffix = Integer.parseInt(schm_suffix);
        String newSchmValue = Integer.valueOf(++int_schm_suffix).toString();
        iHRParameter.updateParamterValue(HRParameterEnum.SCHM_HISTABLE_SUFFIX, newSchmValue);
        tableName = schm_prefix + schm_suffix;
        tableName = tableName + new Date().getTime();
        if (tableName.length() > 30) {
            tableName = tableName.substring(0, 30);
        }
        return tableName;
    }

    @Override
    protected IRowSet _getCmpSchemeAllData(Context ctx, IObjectPK pkScheme) throws BOSException, EASBizException {
        IRowSet iRowSet = null;
        IEmpCmpSchmFacade iEmpCmpSchmFacade = EmpCmpSchmFacadeFactory.getLocalInstance(ctx);
        try {
            iRowSet = iEmpCmpSchmFacade.getEmpCompenseData(pkScheme, null, null);
        }
        catch (EASDBException e) {
            try {
                throw new SQLDataException(e.getMessage());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(iRowSet);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)iRowSet);
        return iRowSet;
    }

    @Override
    protected IRowSet _getCmpSchemeData(Context ctx, IObjectPK pkScheme, List lstPersonID, List orderByList) throws BOSException, EASBizException {
        IRowSet iRowSet = null;
        IEmpCmpSchmFacade iEmpCmpSchmFacade = EmpCmpSchmFacadeFactory.getLocalInstance(ctx);
        try {
            iRowSet = iEmpCmpSchmFacade.getEmpCompenseData(pkScheme, lstPersonID, null);
        }
        catch (EASDBException e) {
            try {
                throw new SQLDataException(e.getMessage());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(iRowSet);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)iRowSet);
        return iRowSet;
    }

    @Override
    protected void _delHistoryData(Context ctx, IObjectPK pkScheme, IObjectPK pkBeginCmpPeriod, IObjectPK pkEndCmpPeriod) throws BOSException, EASBizException {
    }

    private CmpPeriodCollection getCmpPeriodCollection(Context ctx, IObjectPK pkScheme, Date beginDate, Date endDate) throws BOSException, EASBizException {
        ICmpScheme iCmpScheme = CmpSchemeFactory.getLocalInstance(ctx);
        CmpSchemeInfo infoCmpScheme = iCmpScheme.getCmpSchemeInfo("select *,currency.*,cmpPeriod.* where id='" + pkScheme.toString() + "'");
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)infoCmpScheme.getBOSType(), (IObjectPK)pkScheme, (String)infoCmpScheme.getName(), (String)"cmphisdata_delete");
        ICmpPeriod iCmpPeriod = CmpPeriodFactory.getLocalInstance(ctx);
        StringBuffer sql = new StringBuffer("");
        sql.append("select * where beginDate>='");
        sql.append(beginDate.toString());
        sql.append("' and endDate<='");
        sql.append(endDate.toString());
        sql.append("'");
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        return iCmpPeriod.getCmpPeriodCollection(sql.toString());
    }

    @Override
    protected void _delHistoryData(Context ctx, IObjectPK pkScheme, Date beginDate, Date endDate) throws BOSException, EASBizException {
        CmpSchemeInfo infoCmpScheme = CmpSchemeFactory.getLocalInstance(ctx).getCmpSchemeInfo(pkScheme);
        String nameHistoryTable = infoCmpScheme.getHisTableName();
        if (nameHistoryTable != null) {
            CmpPeriodCollection colCmpPeriod = this.getCmpPeriodCollection(ctx, pkScheme, beginDate, endDate);
            if (colCmpPeriod == null || colCmpPeriod.size() <= 0) {
                return;
            }
            StringBuffer sql = new StringBuffer("");
            sql.append(" delete from ");
            sql.append(nameHistoryTable);
            sql.append(" where FPERIOD in(");
            int size = colCmpPeriod.size();
            for (int i = 0; i < size; ++i) {
                if (i > 0) {
                    sql.append(",");
                }
                CmpPeriodInfo infoCmpPeriod = colCmpPeriod.get(i);
                sql.append("'");
                sql.append(infoCmpPeriod.getId().toString());
                sql.append("'");
            }
            sql.append(")");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
    }

    private void insertValue(Context ctx, boolean flag, IObjectPK pkScheme) throws BOSException, EASBizException {
        HROrgUnitInfo hrUnitInfo = ContextUtil.getCurrentHRUnit((Context)ctx);
        if (hrUnitInfo == null || hrUnitInfo.getId() == null) {
            return;
        }
        try {
            JointAssessmentCollection jointassconsToTax = this.getJointAssconsToTax(ctx, pkScheme);
            String cmpPeriodNumber = null;
            int time = 0;
            HashSet<String> cmpSchemeSet = new HashSet<String>();
            CmpSchemeInfo cmpSchemeInfo = null;
            CmpSchemeInfo pKCmpSchemeInfo = null;
            if (jointassconsToTax != null && jointassconsToTax.size() > 0) {
                int size = jointassconsToTax.size();
                for (int i = 0; i < size; ++i) {
                    cmpSchemeInfo = jointassconsToTax.get(i).getCmpScheme();
                    if (pkScheme.toString().equalsIgnoreCase(cmpSchemeInfo.getId().toString())) {
                        cmpPeriodNumber = cmpSchemeInfo.getCmpPeriod().getNumber();
                        pKCmpSchemeInfo = jointassconsToTax.get(i).getCmpScheme();
                        time = cmpSchemeInfo.getTime();
                        cmpSchemeSet.add(cmpSchemeInfo.getId().toString());
                        continue;
                    }
                    cmpSchemeSet.add(cmpSchemeInfo.getId().toString());
                }
                EntityViewInfo view = new EntityViewInfo();
                String sorterItem = "seqNumber";
                SorterItemInfo sortInfo = new SorterItemInfo(sorterItem);
                sortInfo.setSortType(SortType.DESCEND);
                SorterItemCollection sortCollectiom = view.getSorter();
                sortCollectiom.add(sortInfo);
                view.getSelector().add(new SelectorItemInfo("*"));
                view.getSelector().add(new SelectorItemInfo("cmpScheme.id"));
                view.getSelector().add(new SelectorItemInfo("cmpScheme.name"));
                view.getSelector().add(new SelectorItemInfo("hrOrgUnit"));
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("cmpScheme.id", cmpSchemeSet, CompareType.INCLUDE));
                filterInfo.getFilterItems().add(new FilterItemInfo("cmpPeriodNumber", (Object)cmpPeriodNumber, CompareType.EQUALS));
                view.setFilter(filterInfo);
                AuditForJointAssCollection auditforJointColl = AuditForJointAssFactory.getLocalInstance(ctx).getCollection(view);
                int seqNumber = 0;
                new FilterItemInfo("cmpPeriodNumber", (Object)cmpPeriodNumber, CompareType.EQUALS).toString();
                if (auditforJointColl.size() > 0 && flag) {
                    seqNumber = auditforJointColl.get(0).getSeqNumber();
                    FilterInfo PkFilterInfo = new FilterInfo();
                    PkFilterInfo.getFilterItems().add(new FilterItemInfo("cmpScheme.id", (Object)pKCmpSchemeInfo.getId().toString(), CompareType.EQUALS));
                    PkFilterInfo.getFilterItems().add(new FilterItemInfo("cmpPeriodNumber", (Object)cmpPeriodNumber, CompareType.EQUALS));
                    PkFilterInfo.getFilterItems().add(new FilterItemInfo("time", (Object)(time + ""), CompareType.EQUALS));
                    view.setFilter(PkFilterInfo);
                    AuditForJointAssCollection PkAuditforJointColl = AuditForJointAssFactory.getLocalInstance(ctx).getCollection(view);
                    if (PkAuditforJointColl.size() > 0 && PkAuditforJointColl.get(0).getSeqNumber() == seqNumber) {
                        String sql2 = "delete from T_HR_AuditForJointAss where fid='" + PkAuditforJointColl.get(0).getId().toString() + "'";
                        DbUtil.execute((Context)ctx, (String)sql2);
                    } else if (PkAuditforJointColl.size() > 0) {
                        int size2 = auditforJointColl.size();
                        for (int i = 0; i < size2; ++i) {
                            String msg = null;
                            int msg1 = 0;
                            if (auditforJointColl.get(i).getSeqNumber() != PkAuditforJointColl.get(0).getSeqNumber() + 1) continue;
                            msg = auditforJointColl.get(i).getCmpScheme().getName();
                            msg1 = auditforJointColl.get(i).getTime();
                            throw new TaxRateException(TaxRateException.CANNOTUNAUDIT, new Object[]{msg, msg1 + ""});
                        }
                    }
                } else if (auditforJointColl.size() > 0 && !flag) {
                    seqNumber = auditforJointColl.get(0).getSeqNumber();
                    String fid = null;
                    String sql = "select top 1 newbosid('79D5E4F7') as fid  from t_hr_cmpitem";
                    IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
                    if (rowSet.next()) {
                        fid = rowSet.getString("fid");
                    }
                    String sql2 = "insert into T_HR_AuditForJointAss(fcmpschemeid,fhrorgunitid,fcmpperiodnumber,ftime,fseqnumber,fid) values('" + pKCmpSchemeInfo.getId().toString() + "','" + hrUnitInfo.getId().toString() + "','" + cmpPeriodNumber + "'," + pKCmpSchemeInfo.getTime() + "," + (seqNumber + 1) + ",'" + fid + "')";
                    DbUtil.execute((Context)ctx, (String)sql2);
                } else if (!flag) {
                    String fid = null;
                    String sql = "select top 1 newbosid('79D5E4F7') as fid  from t_hr_cmpitem";
                    IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
                    if (rowSet.next()) {
                        fid = rowSet.getString("fid");
                    }
                    String sql2 = "insert into T_HR_AuditForJointAss(fcmpschemeid,fhrorgunitid,fcmpperiodnumber,ftime,fseqnumber,fid) values('" + pKCmpSchemeInfo.getId().toString() + "','" + hrUnitInfo.getId().toString() + "','" + cmpPeriodNumber + "'," + pKCmpSchemeInfo.getTime() + ",1,'" + fid + "')";
                    DbUtil.execute((Context)ctx, (String)sql2);
                }
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    @Override
    protected void _unAuditCmpScheme(Context ctx, IObjectPK pkScheme) throws BOSException, EASBizException {
        this.insertValue(ctx, true, pkScheme);
        ICmpScheme iCmpScheme = CmpSchemeFactory.getLocalInstance(ctx);
        CmpSchemeInfo infoCmpScheme = iCmpScheme.getCmpSchemeInfo(" select *,cmpPeriod.* where id='" + pkScheme.toString() + "'");
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)infoCmpScheme.getBOSType(), (IObjectPK)pkScheme, (String)infoCmpScheme.getName(), (String)"cmpscheme_unaudit");
        StringBuffer sql = new StringBuffer("");
        sql.append(" update T_HR_CMPSCHEME set FCalCount=0, FAudit=");
        sql.append(10);
        sql.append(",FLastCalTime={ts'");
        sql.append(DateTimeUtils.format((Date)new Date()));
        sql.append("'} ");
        sql.append(", FAuditPerson = '' ");
        sql.append(" where FID='" + pkScheme.toString() + "'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        HRSchemeUtils.checkShemeUpdate(ctx, infoCmpScheme);
        this.updateCheckState(ctx, infoCmpScheme);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    private JointAssessmentCollection getJointAssconsToTax(Context ctx, IObjectPK pkScheme) throws EASBizException, BOSException, SQLException {
        if (!JointAssessmentFactory.getLocalInstance(ctx).exists("where cmpScheme.id = '" + pkScheme.toString() + "'")) {
            return null;
        }
        HROrgUnitInfo hrUnitInfo = ContextUtil.getCurrentHRUnit((Context)ctx);
        if (hrUnitInfo == null || hrUnitInfo.getId() == null) {
            return null;
        }
        if (!JointAssessmentFactory.getLocalInstance(ctx).exists("where cmpScheme.id = '" + pkScheme.toString() + "' and hrOrgUnit.id = '" + hrUnitInfo.getId().toString() + "'")) {
            return null;
        }
        JointAssessmentCollection jointassconsToTax = null;
        JointAssessmentInfo jointassInfo = JointAssessmentFactory.getLocalInstance(ctx).getJointAssessmentInfo("select treeid.id,treeid.name where cmpScheme.id = '" + pkScheme.toString() + "' and hrOrgUnit.id = '" + hrUnitInfo.getId().toString() + "'");
        jointassconsToTax = JointAssessmentFactory.getLocalInstance(ctx).getJointAssessmentCollection("select id,name,cmpScheme.id,cmpScheme.name,cmpScheme.cmpPeriod.id,cmpScheme.cmpPeriod.number,cmpScheme.cmpPeriod.name,cmpScheme.audit,cmpScheme.time where treeid.id = '" + jointassInfo.getTreeid().getId().toString() + "'");
        return jointassconsToTax;
    }

    private void clearClosedSchemeAuditPerson(Context ctx, String pkScheme) throws BOSException {
        if (pkScheme != null) {
            StringBuffer sql = new StringBuffer("");
            sql.append(" update T_HR_CMPSCHEME set ");
            sql.append(" FAuditPerson = '' ");
            sql.append(" where FID=?");
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{pkScheme});
        }
    }

    private void doWithPeriodEndInputStatus(Context ctx, CmpSchemeInfo infoCmpScheme, CmpPeriodInfo infoCmpPeriod, int time) throws BOSException, SQLException {
        StringBuffer delAuditSql = new StringBuffer();
        delAuditSql.append("delete from T_HR_PEndInStatus where ").append(" FCmpSchemeID='").append(infoCmpScheme.getId().toString()).append("'").append(" and FCmpPeriodID='").append(infoCmpPeriod.getId().toString()).append("'").append(" and fTime=").append(time);
        DbUtil.execute((Context)ctx, (String)delAuditSql.toString());
    }

    @Override
    protected void _checkSendStyle(Context ctx, String strCmpSchemeID) throws BOSException, EASBizException {
        block6: {
            StringBuffer strSql = new StringBuffer(" SELECT T_HR_CMPSCHEMEITEM.FID FROM T_HR_CMPSCHEMEITEM  ");
            strSql.append(" LEFT OUTER JOIN T_HR_CMPITEM ON T_HR_CMPSCHEMEITEM.FCmpItemID = T_HR_CMPITEM.FID ");
            strSql.append(" WHERE FCMPSCHEMEID =? AND FIsDelete = 0 AND T_HR_CMPITEM.FNUMBER=?");
            Object[] param = new Object[]{strCmpSchemeID, "FOTH001"};
            IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)strSql.toString(), (Object[])param);
            try {
                if (iRowSet.next()) {
                    break block6;
                }
                throw new CmpSchemeException(CmpSchemeException.CMP_SENDSTYLE_NOTALLOW);
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage());
                throw new SQLDataException(e);
            }
            finally {
                SQLUtils.cleanup((ResultSet)iRowSet);
            }
        }
    }

    @Override
    protected void _jumpToNextPeriod(Context ctx, String pk, String jumpPeriod) throws BOSException, SchemeException {
        ICmpScheme iCmpScheme = CmpSchemeFactory.getLocalInstance(ctx);
        CmpSchemeInfo infoCmpScheme = null;
        try {
            infoCmpScheme = iCmpScheme.getCmpSchemeInfo(" select *,currency.*,cmpPeriod.* where id='" + pk + "'");
        }
        catch (EASBizException e1) {
            logger.error((Object)e1.getMessage());
            throw new BOSException((Throwable)e1);
        }
        ObjectUuidPK pkScheme = new ObjectUuidPK(pk);
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)infoCmpScheme.getBOSType(), (IObjectPK)pkScheme, (String)infoCmpScheme.getName(), (String)"cmpscheme_jumptonextperiod");
        if (SchemeAuditedEnum.AUDITING.equals((Object)infoCmpScheme.getAudit()) || SchemeAuditedEnum.AUDITEDPASS.equals((Object)infoCmpScheme.getAudit())) {
            throw new SchemeException(SchemeException.TO_NEXT_PERIOD_FAIL);
        }
        if (infoCmpScheme.getCmpPeriod() == null) {
            return;
        }
        CmpPeriodInfo infoCurrentCmpPeriod = infoCmpScheme.getCmpPeriod();
        ICmpPeriod cmpPeriod = CmpPeriodFactory.getLocalInstance(ctx);
        CmpPeriodInfo infoNextCmpPeriod = null;
        try {
            infoNextCmpPeriod = cmpPeriod.getCmpPeriodInfo((IObjectPK)new ObjectUuidPK(jumpPeriod));
        }
        catch (EASBizException e1) {
            throw new BOSException((Throwable)e1);
        }
        if (infoNextCmpPeriod == null) {
            throw new SchemeException(SchemeException.CUR_PERIOD_IN_END);
        }
        CmpPeriodInfo infoCmpPeriod = infoCmpScheme.getCmpPeriod();
        int time = infoCmpScheme.getTime();
        String tableName = HRTableTools.getEndInputTableName(ctx, pk);
        CmpPeriodInfo infoJumpLastCmpPeriod = HRUtils.getCmpPeriodInfoByConstantServer(ctx, infoNextCmpPeriod, -1);
        List periodList = HRUtils.getCmpPeriodList(ctx, infoCmpPeriod, infoJumpLastCmpPeriod, false);
        try {
            this.doHistoryTableForHor(ctx, infoCmpScheme, infoNextCmpPeriod, periodList);
            String futureTblName = infoCmpScheme.getFutureTableName();
            if (futureTblName != null && !"".equals(futureTblName)) {
                int count = this.getFuTblDataCount(ctx, infoCmpScheme);
                if (count > 0) {
                    int maxTimeInFuTbl = this.getMaxTimeOfFuTble(ctx, futureTblName, infoCurrentCmpPeriod);
                    if (maxTimeInFuTbl > time) {
                        this.delPeriodDateOfPerInput(ctx, infoCmpScheme, infoCurrentCmpPeriod, maxTimeInFuTbl, infoCmpScheme.getTime(), tableName);
                        this.delEndInputStatus(ctx, infoCmpScheme, infoCmpPeriod, maxTimeInFuTbl, time);
                    }
                    int size = periodList.size();
                    for (int i = 0; i < size; ++i) {
                        this.delPeriodDateOfFuTble(ctx, futureTblName, (CmpPeriodInfo)periodList.get(i));
                    }
                    count = this.getFuTblDataCount(ctx, infoCmpScheme);
                    if (count > 0) {
                        this.putFuDataToHorTbl(ctx, infoCmpScheme, iCmpScheme);
                    } else {
                        this.doClearCmpSchemeForJump(ctx, infoCmpScheme, infoNextCmpPeriod, iCmpScheme, "period");
                    }
                } else {
                    this.doClearCmpSchemeForJump(ctx, infoCmpScheme, infoNextCmpPeriod, iCmpScheme, "period");
                }
            } else {
                this.doClearCmpSchemeForJump(ctx, infoCmpScheme, infoNextCmpPeriod, iCmpScheme, "period");
            }
            int size = periodList.size();
            for (int i = 0; i < size; ++i) {
                if (i == 0) {
                    this.deletePeriodEndInputTable(ctx, infoCmpScheme, infoCmpPeriod, time, tableName);
                    this.doWithPeriodEndInputStatus(ctx, infoCmpScheme, infoCmpPeriod, time);
                    this.doWithUpdateHorTableAndClearAuditor(ctx, infoCmpScheme, infoCmpPeriod, time);
                    continue;
                }
                this.deleteData(ctx, infoCmpScheme, (CmpPeriodInfo)periodList.get(i), tableName);
            }
            this.doClearCmpSchemeTable(ctx, infoCmpScheme);
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        }
        catch (Exception e) {
            throw new BOSException();
        }
    }

    private void doClearCmpSchemeForJump(Context ctx, CmpSchemeInfo infoCmpScheme, CmpPeriodInfo infoNextCmpPeriod, ICmpScheme iCmpScheme, String closedType) throws BOSException, EASBizException, CmpPeriodException {
        if ("period".equals(closedType)) {
            infoCmpScheme.setCmpPeriod(infoNextCmpPeriod);
            infoCmpScheme.setTime(1);
            infoCmpScheme.setAudit(SchemeAuditedEnum.NOTAUDITED);
            this.updateCheckState(ctx, infoCmpScheme);
            iCmpScheme.submit((CoreBaseInfo)infoCmpScheme);
        }
    }

    private String doHistoryTableForHor(Context ctx, CmpSchemeInfo infoCmpScheme, CmpPeriodInfo jumpPeriodInfo, List periodList) throws Exception {
        String horTableName = infoCmpScheme.getHorTableName();
        String historyTableName = infoCmpScheme.getHisTableName();
        if (historyTableName != null) {
            StringBuffer delDirtyDataSql = new StringBuffer();
            delDirtyDataSql.append("DELETE From ").append(historyTableName).append(" where fPeriod='").append(infoCmpScheme.getCmpPeriod().getId().toString()).append("' and fTime=").append(infoCmpScheme.getTime()).append("");
            DbUtil.execute((Context)ctx, (String)delDirtyDataSql.toString());
            this.insertIntoHistoryTableName(ctx, horTableName, historyTableName, periodList);
        }
        return historyTableName;
    }

    private void insertIntoHistoryTableName(Context ctx, String horTableName, String historyTableName, List periodList) throws BOSException {
        String columnStr = "FPersonID, FPERIOD, FTIME, FADMINORGUNITID, FPOSITIONID, FSequence";
        StringBuffer sql = null;
        String periodID = null;
        int size = periodList.size();
        for (int i = 0; i < size; ++i) {
            periodID = ((CmpPeriodInfo)periodList.get(i)).getId().toString();
            sql = new StringBuffer();
            sql.append("insert into ");
            sql.append(historyTableName).append("(").append(columnStr).append(")");
            sql.append(" select FPersonID, ").append("'").append(periodID).append("' ,");
            if (i == 0) {
                sql.append(" FTIME ");
            } else {
                sql.append(" 1 ");
            }
            sql.append(", FADMINORGUNITID, FPOSITIONID, FSequence ");
            sql.append(" from ");
            sql.append(horTableName);
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
    }

    private void doWithUpdateHorTableAndClearAuditor(Context ctx, CmpSchemeInfo infoCmpScheme, CmpPeriodInfo infoCmpPeriod, int time) throws BOSException, EASBizException {
        StringBuffer udAditorSql = new StringBuffer("");
        udAditorSql.append("delete from T_HR_CmpSAuditor").append(" where FCmpSchemeID='").append(infoCmpScheme.getId().toString()).append("'").append(" and FCmpPeriodID='").append(infoCmpPeriod.getId().toString()).append("'").append(" and fTime=").append(time);
        DbUtil.execute((Context)ctx, (String)udAditorSql.toString());
    }

    private void deletePeriodEndInputTable(Context ctx, CmpSchemeInfo infoCmpScheme, CmpPeriodInfo infoCmpPeriod, int time, String tableName) throws BOSException, EASBizException {
        String strSql = " DELETE FROM " + tableName + " WHERE FCmpSchemeID=? and FCmpPeriodID=? and Ftime=?";
        Object[] param = new Object[]{infoCmpScheme.getId().toString(), infoCmpPeriod.getId().toString(), time};
        DbUtil.execute((Context)ctx, (String)strSql, (Object[])param);
    }

    private void deleteData(Context ctx, CmpSchemeInfo infoCmpScheme, CmpPeriodInfo infoCmpPeriod, String tableName) throws BOSException, EASBizException {
        String strSql = " DELETE FROM " + tableName + " WHERE FCmpSchemeID=? and FCmpPeriodID=?";
        Object[] param = new Object[]{infoCmpScheme.getId().toString(), infoCmpPeriod.getId().toString()};
        DbUtil.execute((Context)ctx, (String)strSql, (Object[])param);
        strSql = " DELETE FROM T_HR_PEndInStatus WHERE FCmpSchemeID=? and FCmpPeriodID=?";
        param = new Object[]{infoCmpScheme.getId().toString(), infoCmpPeriod.getId().toString()};
        DbUtil.execute((Context)ctx, (String)strSql, (Object[])param);
        strSql = " DELETE FROM T_HR_CmpSAuditor WHERE FCmpSchemeID=? and FCmpPeriodID=?";
        param = new Object[]{infoCmpScheme.getId().toString(), infoCmpPeriod.getId().toString()};
        DbUtil.execute((Context)ctx, (String)strSql, (Object[])param);
    }

    @Override
    protected String _checkAddPerson(Context ctx, List lstPersonID) throws BOSException, EASBizException {
        StringBuffer sbReturnID = new StringBuffer("");
        if (lstPersonID == null || lstPersonID.size() == 0) {
            return null;
        }
        String id = null;
        StringBuffer sbSql = new StringBuffer(" SELECT DISTINCT FPERSONID FROM T_HR_CMPSCHEMEPERSON WHERE FPERSONID IN(");
        int size = lstPersonID.size();
        for (int i = 0; i < size; ++i) {
            sbSql.append("'");
            id = lstPersonID.get(i).toString();
            sbSql.append(id);
            sbSql.append("',");
        }
        sbSql.deleteCharAt(sbSql.length() - 1);
        sbSql.append(") and fisDelete = 0 ");
        IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sbSql.toString());
        try {
            while (iRowSet.next()) {
                id = iRowSet.getString("FPERSONID");
                sbReturnID.append(id);
                sbReturnID.append(";");
            }
            if (sbReturnID.length() > 1) {
                sbReturnID.deleteCharAt(sbReturnID.length() - 1);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)iRowSet);
        }
        return sbReturnID.toString();
    }

    @Override
    protected void _auditCmpScheme(Context ctx, IObjectPK id, boolean isDirect) throws BOSException, EASBizException {
        this.insertValue(ctx, false, id);
        if (isDirect) {
            ICmpScheme iCmpScheme = CmpSchemeFactory.getLocalInstance(ctx);
            CmpSchemeInfo infoCmpScheme = iCmpScheme.getCmpSchemeInfo(" select *,cmpPeriod.* where id='" + id.toString() + "'");
            IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)infoCmpScheme.getBOSType(), (IObjectPK)id, (String)infoCmpScheme.getName(), (String)"cmpscheme_audit");
            if (infoCmpScheme.getCalCount() <= 0) {
                throw new CmpSchemeException(CmpSchemeException.CMPSCHEME_CALCULATE_NOT);
            }
            this.checkEndInputAuditValue(ctx, infoCmpScheme.getId().toString(), infoCmpScheme.getCmpPeriod().getId().toString(), infoCmpScheme.getTime());
            this.changeCmpSchemeToAudited(ctx, infoCmpScheme, isDirect);
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        } else {
            this._auditCmpScheme(ctx, id);
        }
    }

    @Override
    protected void _checkEndInputAuditValue(Context ctx, String cmpSchemeId, String cmpPeriodId, int time) throws BOSException, EASBizException {
        ICmpDataCheckFacade dataCheck;
        Map map;
        Integer unAuditPersonCount;
        if (!HRSchemeUtils.getPeriodAuditCase(ctx) && (unAuditPersonCount = (Integer)(map = (dataCheck = CmpDataCheckFacadeFactory.getLocalInstance(ctx)).checkPeriodEndInputAudit(cmpSchemeId, cmpPeriodId, time, null)).get("unAuditPersonCount")) > 0) {
            throw new CmpSchemeException(CmpSchemeException.ENDINPUT_ANAUDITED);
        }
    }

    private void changeCmpSchemeToAudited(Context ctx, CmpSchemeInfo infoCmpScheme, boolean isDirect) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer("");
        sql.append(" update T_HR_CMPSCHEME set FAudit=40 ");
        if (isDirect) {
            if (ContextUtil.getCurrentUserInfo((Context)ctx).getPerson() != null) {
                sql.append(",FAuditPerson = '" + ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString() + "' ");
            } else {
                sql.append(",FAuditPerson = null");
            }
        }
        sql.append(" where FID='" + infoCmpScheme.getId() + "'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    @Override
    protected void _CounterAccountClose(Context ctx, IObjectPK pk, boolean actionFlag, boolean isdelData) throws BOSException, EASBizException {
        this._counterAccountClose(ctx, pk, actionFlag, isdelData);
    }

    @Override
    protected void _counterAccountClose(Context ctx, IObjectPK pk, boolean actionFlag, boolean isdelData) throws BOSException, EASBizException {
        try {
            ICmpScheme iCmpScheme = CmpSchemeFactory.getLocalInstance(ctx);
            CmpSchemeInfo infoCmpScheme = iCmpScheme.getCmpSchemeInfo("select *,cmpPeriod.* where id='" + pk.toString() + "'");
            HRSchemeUtils.checkShemeUpdate(ctx, infoCmpScheme);
            String tableName = HRTableTools.getEndInputTableName(ctx, infoCmpScheme.getId().toString());
            IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)infoCmpScheme.getBOSType(), (IObjectPK)pk, (String)infoCmpScheme.getName(), (String)"cmpCounterAccountdata_settle");
            if (isdelData) {
                this.delCurrentData(ctx, infoCmpScheme, iCmpScheme, tableName);
                this.updateCheckState(ctx, infoCmpScheme);
            }
            if (actionFlag) {
                String futureTblName = this.doFutureTable(ctx, pk, infoCmpScheme);
                this.putHisTblDataToHortable(ctx, infoCmpScheme);
                this.delHisPerDataTable(ctx, infoCmpScheme);
                this.putPeriodHisToCurrentPeriodTbl(ctx, infoCmpScheme, tableName);
                this.setCmpschemeStatus(ctx, iCmpScheme, infoCmpScheme, futureTblName);
                this.syncPersonFromDynTable(ctx, infoCmpScheme.getHorTableName(), infoCmpScheme.getId().toString(), infoCmpScheme.getCmpPeriod().getId().toString(), infoCmpScheme.getTime());
            }
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        }
        catch (CmpPeriodException e) {
            throw e;
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (BOSException e) {
            throw e;
        }
        catch (Exception e) {
            logger.info((Object)e);
            throw new CmpSchemeException(CmpSchemeException.CMPSCHEME_COUNTERACOUTCLOSE_FAIL);
        }
    }

    private void setCmpschemeStatus(Context ctx, ICmpScheme iCmpScheme, CmpSchemeInfo infoCmpScheme, String futureTblName) throws BOSException, SQLException, EASBizException {
        String horTblName = infoCmpScheme.getHorTableName();
        StringBuffer getTimesql = new StringBuffer();
        getTimesql.append("select top 1 fTime from ").append(horTblName);
        IRowSet timeRowSet = DbUtil.executeQuery((Context)ctx, (String)getTimesql.toString());
        while (timeRowSet.next()) {
            infoCmpScheme.setTime(timeRowSet.getInt("fTime"));
        }
        infoCmpScheme.setCalCount(1);
        infoCmpScheme.setAudit(SchemeAuditedEnum.AUDITEDPASS);
        String personId = this.getCmpSendAuditor(ctx, infoCmpScheme.getId().toString(), infoCmpScheme.getCmpPeriod().getId().toString(), infoCmpScheme.getTime());
        if (personId != null) {
            PersonInfo person = new PersonInfo();
            person.setId(BOSUuid.read((String)personId));
            infoCmpScheme.setAuditPerson(person);
        } else {
            infoCmpScheme.setAuditPerson(null);
            infoCmpScheme.setAudit(SchemeAuditedEnum.NOTAUDITED);
            infoCmpScheme.setCalCount(0);
        }
        infoCmpScheme.setFutureTableName(futureTblName);
        iCmpScheme.submit((CoreBaseInfo)infoCmpScheme);
    }

    private void delCurrentData(Context ctx, CmpSchemeInfo infoCmpScheme, ICmpScheme iCmpScheme, String tableName) throws Exception {
        String cmpPeriodID = infoCmpScheme.getCmpPeriod().getId().toString();
        int time = infoCmpScheme.getTime();
        this.doClearCmpSchemeTable(ctx, infoCmpScheme);
        Object[] param = new Object[]{infoCmpScheme.getId().toString(), cmpPeriodID, new Integer(infoCmpScheme.getTime())};
        String delPeriodEndSql = "delete from " + tableName + " where fCmpSchemeID= ? and fCmpPeriodID=? and fTime=? ";
        DbUtil.execute((Context)ctx, (String)delPeriodEndSql.toString(), (Object[])param);
        String delPeriodEndBakSql = "delete from t_hr_PeriodEndInputBak where fCmpSchemeID =? and fCmpPeriodID=? and ftime = ?";
        DbUtil.execute((Context)ctx, (String)delPeriodEndBakSql, (Object[])param);
        String perTblName = infoCmpScheme.getPerDataTableName();
        StringBuffer delPersql = new StringBuffer("");
        delPersql.append("delete from ").append(perTblName).append(" where ").append(perTblName).append(".fPeriod='").append(cmpPeriodID).append("'").append(" and ").append(perTblName).append(".fTime=").append(time);
        DbUtil.execute((Context)ctx, (String)delPersql.toString());
        String auditPersonSql = "delete from T_HR_CmpSAuditor where FCmpSchemeId=? and FCmpPeriodId=? and fTime=? ";
        DbUtil.execute((Context)ctx, (String)auditPersonSql, (Object[])param);
        String strSql = " DELETE FROM T_HR_PEndInputState WHERE FCmpSchemeId=? and FCmpPerioidId=? and fTime=?";
        DbUtil.execute((Context)ctx, (String)strSql, (Object[])param);
        strSql = " DELETE FROM T_HR_PEndInStatus WHERE FCmpSchemeId=? and FCmpPeriodID=? and fTime=?";
        DbUtil.execute((Context)ctx, (String)strSql, (Object[])param);
        infoCmpScheme.setAudit(SchemeAuditedEnum.NOTAUDITED);
        infoCmpScheme.setCalCount(0);
        iCmpScheme.submit((CoreBaseInfo)infoCmpScheme);
    }

    private String doFutureTable(Context ctx, IObjectPK pk, CmpSchemeInfo infoCmpScheme) throws Exception {
        String futureTableName = infoCmpScheme.getFutureTableName();
        int auditStat = infoCmpScheme.getAudit().getValue();
        if (futureTableName == null || futureTableName.equals("")) {
            futureTableName = this.getNewHistoryTableName(ctx);
            ArrayList lstColumns = HRDynamicTableUtils.getSchemeDynamicTableInfosSchmItem(ctx, pk);
            ArrayList<ColumnMetasInfo> lstNewColumns = new ArrayList<ColumnMetasInfo>();
            if (lstColumns != null && lstColumns.size() > 0) {
                String horTableName = infoCmpScheme.getHorTableName();
                IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)(" SELECT TOP 1 * FROM " + horTableName));
                HashMap<String, ColumnMetasInfo> mapColumns = new HashMap<String, ColumnMetasInfo>();
                ColumnMetasInfo infoColumnMetas = null;
                int size = lstColumns.size();
                for (int i = 0; i < size; ++i) {
                    infoColumnMetas = (ColumnMetasInfo)lstColumns.get(i);
                    mapColumns.put(infoColumnMetas.getName().toUpperCase(), infoColumnMetas);
                }
                ResultSetMetaData temp = iRowSet.getMetaData();
                int size2 = temp.getColumnCount();
                for (int i = 1; i <= size2; ++i) {
                    infoColumnMetas = (ColumnMetasInfo)mapColumns.get(temp.getColumnName(i).toUpperCase());
                    if (infoColumnMetas == null) {
                        throw new EASBizException(new NumericExceptionSubItem("100", ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"81_SchemeFacadeControllerBean", (Locale)ctx.getLocale()) + temp.getColumnName(i) + ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"82_SchemeFacadeControllerBean", (Locale)ctx.getLocale())));
                    }
                    lstNewColumns.add(infoColumnMetas);
                }
            }
            ColumnMetasInfo infoColumnMetas = new ColumnMetasInfo();
            infoColumnMetas.setName("FAudit");
            infoColumnMetas.setDataType(HRSchemeUtils.getDataType(40));
            infoColumnMetas.setPrecision(4);
            infoColumnMetas.setLength(4);
            infoColumnMetas.setAllowNull(Boolean.FALSE);
            infoColumnMetas.setPrimaryKey(false);
            lstNewColumns.add(infoColumnMetas);
            infoColumnMetas = new ColumnMetasInfo();
            infoColumnMetas.setName("FCalCount");
            infoColumnMetas.setDataType(HRSchemeUtils.getDataType(40));
            infoColumnMetas.setPrecision(4);
            infoColumnMetas.setLength(4);
            infoColumnMetas.setAllowNull(Boolean.FALSE);
            infoColumnMetas.setPrimaryKey(false);
            lstNewColumns.add(infoColumnMetas);
            AdapterDynamicDBTable iDynamicDBTable = new AdapterDynamicDBTable(ctx, futureTableName, lstNewColumns);
            iDynamicDBTable.create();
            HRCmpIndexUtils.createIndexForSCHMHIS(ctx, futureTableName);
        }
        String horTableName = infoCmpScheme.getHorTableName();
        StringBuffer sql = new StringBuffer("");
        IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)(" SELECT * FROM " + futureTableName));
        ResultSetMetaData temp = iRowSet.getMetaData();
        sql.append("insert into ").append(futureTableName).append(" select ");
        int size = temp.getColumnCount();
        for (int i = 1; i <= size; ++i) {
            String columnName = temp.getColumnName(i).toUpperCase();
            if (i != size) {
                if (columnName.equalsIgnoreCase("FAudit")) {
                    sql.append("" + auditStat).append(" FAudit,");
                    continue;
                }
                if (columnName.equalsIgnoreCase("FCalCount")) {
                    sql.append(infoCmpScheme.getCalCount()).append(" FCalCount, ");
                    continue;
                }
                sql.append(" curTbl.").append(columnName).append(",");
                continue;
            }
            if (columnName.equalsIgnoreCase("FAudit")) {
                sql.append("" + auditStat).append(" FAudit ");
                continue;
            }
            if (columnName.equalsIgnoreCase("FCalCount")) {
                sql.append("" + infoCmpScheme.getCalCount()).append(" FCalCount ");
                continue;
            }
            sql.append(" curTbl.").append(columnName);
        }
        sql.append(" from ").append(horTableName).append(" curTbl");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        StringBuffer delSql = new StringBuffer();
        delSql.append("delete from ").append(horTableName);
        DbUtil.execute((Context)ctx, (String)delSql.toString());
        return futureTableName;
    }

    private void putHisTblDataToHortable(Context ctx, CmpSchemeInfo infoCmpScheme) throws Exception {
        String horTblName = infoCmpScheme.getHorTableName();
        String hisTblName = infoCmpScheme.getHisTableName();
        CmpPeriodInfo cmpPeriodInfo = infoCmpScheme.getCmpPeriod();
        int time = infoCmpScheme.getTime();
        StringBuffer getNexPeriodTimeSql = new StringBuffer();
        getNexPeriodTimeSql.append("select top 1 fPeriod,FBeginDate,fTime as fTime from ").append(hisTblName).append(" hisTblName").append(" inner join t_hr_cmpPeriod cmpPeriod on hisTblName.fPeriod=cmpPeriod.fid").append(" group by fPeriod,FBeginDate,fTime order by FBeginDate desc,fTime desc");
        IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)getNexPeriodTimeSql.toString());
        while (iRowSet.next()) {
            String cmpPeriodID = iRowSet.getString("fPeriod");
            time = iRowSet.getInt("fTime");
            cmpPeriodInfo = new CmpPeriodInfo();
            cmpPeriodInfo.setId(BOSUuid.read((String)cmpPeriodID));
        }
        infoCmpScheme.setTime(time);
        infoCmpScheme.setCmpPeriod(cmpPeriodInfo);
        StringBuffer sql = new StringBuffer("");
        iRowSet = DbUtil.executeQuery((Context)ctx, (String)(" SELECT TOP 1 * FROM " + horTblName));
        ResultSetMetaData temp = iRowSet.getMetaData();
        sql.append("insert into ").append(horTblName).append(" select ");
        int size = temp.getColumnCount();
        for (int i = 1; i <= size; ++i) {
            String columnName = temp.getColumnName(i).toUpperCase();
            if (i != size) {
                sql.append(" hisTbl.").append(columnName).append(",");
                continue;
            }
            sql.append(" hisTbl.").append(columnName);
        }
        sql.append(" from ").append(hisTblName).append(" hisTbl ");
        sql.append(" where ").append(" hisTbl.fPeriod='").append(cmpPeriodInfo.getId().toString()).append("'");
        sql.append(" and ").append(" hisTbl.fTime=").append(time);
        DbUtil.execute((Context)ctx, (String)sql.toString());
        StringBuffer delHissql = new StringBuffer("");
        delHissql.append("delete from ").append(hisTblName).append(" where ").append(hisTblName).append(".fPeriod='").append(cmpPeriodInfo.getId().toString()).append("'").append(" and ").append(hisTblName).append(".fTime=").append(time);
        DbUtil.execute((Context)ctx, (String)delHissql.toString());
    }

    private void putPeriodHisToCurrentPeriodTbl(Context ctx, CmpSchemeInfo infoCmpScheme, String tableName) throws Exception {
        CmpPeriodInfo cmpPeriodInfo = infoCmpScheme.getCmpPeriod();
        int time = infoCmpScheme.getTime();
        StringBuffer endInputHissql = new StringBuffer("");
        String periodHisTbl = "T_Hr_PeriodEndInputBak";
        endInputHissql.append("insert into ").append(tableName).append(" (").append("FID,FVALUE,FCMPPERIODID,FCMPITEMID,FPERSONID,FCMPSCHEMEID,FSUPPLY,FFLOATVALUE,").append("FINTVALUE,FSTRINGVALUE,FDATEVALUE,FTIME) ").append(" select ").append("FID,FVALUE,FCMPPERIODID,FCMPITEMID,FPERSONID,FCMPSCHEMEID,FSUPPLY,FFLOATVALUE,").append("FINTVALUE,FSTRINGVALUE,FDATEVALUE,FTIME from ").append(periodHisTbl).append(" where FCmpSchemeID= ? ").append(" and FCmpPeriodID= ?").append(" and fTime = ?");
        Object[] param = new Object[]{infoCmpScheme.getId().toString(), cmpPeriodInfo.getId().toString(), new Integer(time)};
        DbUtil.execute((Context)ctx, (String)endInputHissql.toString(), (Object[])param);
        String strSql = " DELETE FROM T_Hr_PeriodEndInputBak WHERE FCmpSchemeID=? and FCmpPeriodID=? and Ftime=?";
        DbUtil.execute((Context)ctx, (String)strSql, (Object[])param);
        if (!HRSchemeUtils.getPeriodAuditCase(ctx)) {
            StringBuffer updateAuditSql = new StringBuffer();
            String schemeId = infoCmpScheme.getId().toString();
            String periodId = cmpPeriodInfo.getId().toString();
            String horTblName = infoCmpScheme.getHorTableName();
            StringBuffer getTimesql = new StringBuffer();
            getTimesql.append("select top 1 fTime from ").append(horTblName);
            IRowSet timeRowSet = DbUtil.executeQuery((Context)ctx, (String)getTimesql.toString());
            int currentTime = 0;
            while (timeRowSet.next()) {
                currentTime = timeRowSet.getInt("fTime");
            }
            try {
                updateAuditSql.append("insert into T_HR_PEndInStatus(FCmpSchemeID,FCmpPeriodID,fTime,FPersonID,fEmpAuditFlag)").append(" select '").append(schemeId).append("' as FCmpSchemeID,'").append(periodId).append("' as FCmpPeriodID,").append(currentTime).append(" as fTime,").append(" FPersonID,1 as fEmpAuditFlag from ").append(horTblName);
                DbUtil.execute((Context)ctx, (String)updateAuditSql.toString());
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    private void delHisPerDataTable(Context ctx, CmpSchemeInfo infoCmpScheme) throws Exception {
        CmpPeriodInfo cmpPeriodInfo = infoCmpScheme.getCmpPeriod();
        String perTblName = infoCmpScheme.getPerDataTableName();
        int time = infoCmpScheme.getTime();
        StringBuffer delHissql = new StringBuffer("");
        delHissql.append("delete from ").append(perTblName).append(" where ").append(perTblName).append(".fPeriod='").append(cmpPeriodInfo.getId().toString()).append("'").append(" and ").append(perTblName).append(".fTime=").append(time);
        DbUtil.execute((Context)ctx, (String)delHissql.toString());
    }

    private void syncPersonFromDynTable(Context ctx, String tableName, String cmpschemeID, String cmpPeriodID, int time) throws BOSException {
        StringBuffer updateSql = new StringBuffer();
        updateSql.append(" update t_hr_cmpschemeperson set fisDelete = 1 ").append("where fcmpschemeid='").append(cmpschemeID).append("'").append(" and fisDelete = 0 ").append(" and fpersonid not in (").append("select T.fpersonid from ").append(tableName).append(" T ").append(" where T.fperiod = '").append(cmpPeriodID).append("'").append(" and T.ftime = ").append(time).append(")");
        DbUtil.execute((Context)ctx, (String)updateSql.toString());
        updateSql = new StringBuffer();
        updateSql.append(" update t_hr_cmpschemeperson set fisDelete = 0 ").append("where fcmpschemeid='").append(cmpschemeID).append("'").append(" and fisDelete = 1 ").append(" and fpersonid in (").append("select T.fpersonid from ").append(tableName).append(" T ").append(" where T.fperiod = '").append(cmpPeriodID).append("'").append(" and T.ftime = ").append(time).append(")");
        DbUtil.execute((Context)ctx, (String)updateSql.toString());
        StringBuffer synAdminAndPostionSql = new StringBuffer();
        synAdminAndPostionSql.append("update t_hr_cmpschemeperson as T set (FADMINORGUNITID,FPositionID)").append(" = (select top 1 d.FADMINORGUNITID,d.FPositionID ").append(" from ").append(tableName).append(" d ").append(" where d.fperiod = '").append(cmpPeriodID).append("'").append(" and d.ftime = ").append(time).append(" and d.fpersonid = T.fpersonid )").append("where T.fcmpschemeid='").append(cmpschemeID).append("'").append(" and T.fisDelete = 0 ");
        DbUtil.execute((Context)ctx, (String)synAdminAndPostionSql.toString());
    }

    @Override
    protected HashMap _getErrorPersonInfo(Context ctx, Set personIDs, String tableName) throws BOSException, EASBizException {
        if (tableName == null || personIDs == null || personIDs.size() == 0) {
            return new HashMap();
        }
        StringBuffer buffer = new StringBuffer();
        String personID = null;
        String name = null;
        String adminName = null;
        String number = null;
        Locale local = ContextUtils.getLocaleFromEnv();
        buffer.append(" select cmp.FPersonID as personID, person.").append(BenefitUtils.getLocaleStr((Locale)local, (String)"FName")).append(" as name \n");
        buffer.append(" ,person.FNumber as number \n");
        buffer.append(" ,admin.").append(BenefitUtils.getLocaleStr((Locale)local, (String)"FName")).append(" as adminName \n");
        buffer.append("from ");
        buffer.append(tableName);
        buffer.append(" cmp ");
        buffer.append("inner join t_bd_person person on cmp.FPersonID = person.fid \n");
        buffer.append("inner join t_org_admin admin on cmp.FAdminOrgUnitID = admin.fid \n");
        buffer.append("where cmp.FPersonID in ");
        buffer.append(CompUtils.getStrFromSet(personIDs));
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)buffer.toString());
        HashMap map = new HashMap();
        ArrayList<String> list = null;
        try {
            while (rs.next()) {
                personID = rs.getString("personID");
                name = rs.getString("name");
                number = rs.getString("number");
                adminName = rs.getString("adminName");
                list = new ArrayList<String>();
                list.add(name);
                list.add(adminName);
                list.add(number);
                map.put(personID, list);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return map;
    }

    @Override
    protected int _getAuditStateForFuture(Context ctx, String cmpSchemeId, String cmpPeriodId, int time) throws BOSException, EASBizException {
        CmpSchemeInfo schemeInfo;
        String futureTblName;
        int SchemeAuditState = -1;
        if ((cmpSchemeId != null || cmpPeriodId != null) && (futureTblName = (schemeInfo = CmpSchemeFactory.getLocalInstance(ctx).getCmpSchemeInfo((IObjectPK)new ObjectUuidPK(cmpSchemeId))).getFutureTableName()) != null) {
            StringBuffer sql = new StringBuffer();
            sql.append("select top 1 fAudit from ").append(futureTblName).append(" where fperiod = '" + cmpPeriodId + "' ").append(" and  ftime = " + time);
            IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            try {
                if (iRowSet.next()) {
                    SchemeAuditState = iRowSet.getInt("fAudit");
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        return SchemeAuditState;
    }

    @Override
    protected boolean _canAudit(Context ctx, String cmpSchemeID) throws BOSException, EASBizException {
        CmpSchemeInfo info = CmpSchemeFactory.getLocalInstance(ctx).getCmpSchemeInfo((IObjectPK)new ObjectStringPK(cmpSchemeID));
        String horTable = info.getHorTableName();
        if (!StringUtils.isEmpty((String)horTable)) {
            HRSchemeUtils.checkShemeUpdate(ctx, info);
            StringBuffer sb = new StringBuffer();
            sb.append(" select csp.FPersonID from T_HR_CMPSCHEMEPERSON csp \n").append(" inner join ").append(horTable).append(" horTable \n").append(" on csp.FPersonID = horTable.FPersonID \n").append(" where csp.FISDelete = 0 and horTable.FCalType <> 1 ");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            if (rs.size() == 0) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected void _makeGrantBill(Context ctx, IObjectPK id, String periodID, int time, Map map) throws BOSException, EASBizException {
        ICmpScheme iCmpScheme = CmpSchemeFactory.getLocalInstance(ctx);
        CmpSchemeInfo infoCmpScheme = iCmpScheme.getCmpSchemeInfo(" select *,cmpPeriod.* where id='" + id.toString() + "'");
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)infoCmpScheme.getBOSType(), (IObjectPK)id, (String)infoCmpScheme.getName(), (String)"cmpscheme_audit");
        CmpGrantUtil cmpGrant = null;
        Map mapEmpAccount = (Map)map.get("mapEmpAccount");
        List cmpItemList = (List)map.get("cmpItemList");
        if (mapEmpAccount != null && cmpItemList != null) {
            cmpGrant = new CmpGrantUtil(ctx, infoCmpScheme);
            cmpGrant.setGrantType();
            cmpGrant.setMapEmpAccount(mapEmpAccount);
            cmpGrant.setCmpItemList(cmpItemList);
        }
        if (cmpGrant == null) {
            return;
        }
        try {
            cmpGrant.convertToGrantBill();
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    @Override
    protected Map _checkEmpAccount(Context ctx, IObjectPK id, String periodID, int time) throws BOSException, EASBizException {
        ICmpScheme iCmpScheme = CmpSchemeFactory.getLocalInstance(ctx);
        CmpSchemeInfo infoCmpScheme = iCmpScheme.getCmpSchemeInfo(" select *,cmpPeriod.* where id='" + id.toString() + "'");
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)infoCmpScheme.getBOSType(), (IObjectPK)id, (String)infoCmpScheme.getName(), (String)"cmpscheme_audit");
        boolean isGrantExist = GrantFactory.getLocalInstance(ctx).exists("where cmpScheme = '" + id.toString() + "' and cmpperiod ='" + periodID + "' and time = " + time);
        if (isGrantExist) {
            throw new CmpSchemeException(CmpSchemeException.GRANT_ALREADY_EXIST);
        }
        if (infoCmpScheme.getCalCount() <= 0) {
            throw new CmpSchemeException(CmpSchemeException.CMPSCHEME_CALCULATE_NOT);
        }
        if (infoCmpScheme.getAudit().equals((Object)SchemeAuditedEnum.NOTAUDITED) || infoCmpScheme.getAudit().equals((Object)SchemeAuditedEnum.AUDITEDNOTPASS)) {
            this._checkEndInputAuditValue(ctx, infoCmpScheme.getId().toString(), infoCmpScheme.getCmpPeriod().getId().toString(), infoCmpScheme.getTime());
        }
        int procState = 0;
        HashMap<String, Object> cmpGrantUtilMap = new HashMap<String, Object>();
        try {
            CmpGrantUtil cmpGrant = new CmpGrantUtil(ctx, infoCmpScheme);
            procState = cmpGrant.checkEmpAccountAndReturnNames(this.noAccountPersonMap);
            cmpGrantUtilMap.put("mapEmpAccount", cmpGrant.getMapEmpAccount());
            cmpGrantUtilMap.put("cmpItemList", cmpGrant.getCmpItemList());
            cmpGrantUtilMap.put("procState", procState);
            ctx.put((Object)(id.toString() + periodID), cmpGrantUtilMap);
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        return cmpGrantUtilMap;
    }

    @Override
    protected Map _checkEmpAccountAndReturnNames(Context ctx, IObjectPK id, String periodID, int time) throws BOSException, EASBizException {
        Map returnVal = this._checkEmpAccount(ctx, id, periodID, time);
        HashMap returnMap = new HashMap();
        returnMap.put("returnVal", returnVal.get("procState"));
        returnMap.put("noAccountPersonMap", this.noAccountPersonMap);
        returnMap.put("empAccAndItemList", returnVal);
        return returnMap;
    }

    @Override
    protected String _createTempTableName(Context ctx, String createSql) throws BOSException {
        String tableName = null;
        try {
            tableName = createSql == null || "".equals(createSql) ? TempTablePool.getInstance((Context)ctx).createTempTableName() : TempTablePool.getInstance((Context)ctx).createTempTable(createSql);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tableName;
    }

    private void doValueKeepForAccountClose(Context ctx, CmpSchemeInfo infoCmpScheme, ICmpScheme iCmpScheme, CmpPeriodInfo infoCmpPeriod, String tableName) throws BOSException, EASBizException {
        String sqlItem = " SELECT T_HR_CMPITEM.FID,T_HR_CMPITEM.FNUMBER,T_HR_CMPITEM.FDataType FROM T_HR_CMPSCHEMEITEM  LEFT OUTER JOIN T_HR_CMPITEM ON T_HR_CMPITEM.FID=T_HR_CMPSCHEMEITEM.FCMPITEMID WHERE FCMPSCHEMEID='" + infoCmpScheme.getId().toString() + "' AND FIsValueKeep =1 AND FIsDelete=0";
        IRowSet iRowSetItem = DbUtil.executeQuery((Context)ctx, (String)sqlItem);
        ArrayList<String> lstItem = new ArrayList<String>();
        HashMap<String, String> mapItem = new HashMap<String, String>();
        HashMap<String, Integer> mapItemDataType = new HashMap<String, Integer>();
        Connection conn = null;
        try {
            while (iRowSetItem.next()) {
                lstItem.add(iRowSetItem.getString(1));
                mapItem.put(iRowSetItem.getString(1), iRowSetItem.getString(2));
                mapItemDataType.put(iRowSetItem.getString(1), new Integer(iRowSetItem.getInt(3)));
            }
            if (lstItem.size() < 1) {
                return;
            }
            String fid = null;
            String personID = null;
            String itemID = null;
            String itemNumber = null;
            String cmpPeriodID = infoCmpScheme.getCmpPeriod().getId().toString();
            int time = infoCmpScheme.getTime();
            String cmpSchemeID = infoCmpScheme.getId().toString();
            String hrOrgUnitID = HRSchemeUtils.getServerHROrgUnitInfo(ctx).getId().toString();
            StringBuffer sqlSelect = new StringBuffer();
            sqlSelect.append(" SELECT FID,FPERSONID,FCMPITEMID ");
            sqlSelect.append(" FROM ").append(tableName).append(" WHERE FCMPSCHEMEID='");
            sqlSelect.append(cmpSchemeID);
            sqlSelect.append("' AND FCmpPeriodID='");
            sqlSelect.append(cmpPeriodID);
            sqlSelect.append("' AND FTime=");
            sqlSelect.append(time);
            sqlSelect.append(" AND FCMPITEMID IN (");
            int size = lstItem.size();
            for (int i = 0; i < size; ++i) {
                sqlSelect.append("'");
                sqlSelect.append(lstItem.get(i));
                sqlSelect.append("',");
            }
            sqlSelect.deleteCharAt(sqlSelect.length() - 1);
            sqlSelect.append(")");
            IRowSet iRowSetSelect = DbUtil.executeQuery((Context)ctx, (String)sqlSelect.toString());
            HashMap<String, HashMap> mapData = new HashMap<String, HashMap>();
            HashMap mapPerson = null;
            while (iRowSetSelect.next()) {
                fid = iRowSetSelect.getString("FID");
                personID = iRowSetSelect.getString("FPERSONID");
                mapPerson = (HashMap)mapData.get(personID);
                if (mapPerson == null) {
                    mapPerson = new HashMap();
                }
                itemID = iRowSetSelect.getString("FCMPITEMID");
                mapPerson.put(itemID, fid);
                mapData.put(personID, mapPerson);
            }
            StringBuffer querySql = new StringBuffer();
            querySql.append(" SELECT FPERSONID FROM T_HR_PEndInStatus ");
            querySql.append(" WHERE FCMPSCHEMEID ='").append(cmpSchemeID).append("'");
            querySql.append(" and ftime = ").append(time).append(" and FCMPPERIODID = '").append(cmpPeriodID).append("' ");
            querySql.append(" and fempauditflag = 1 ");
            IRowSet iAuditSet = DbUtil.executeQuery((Context)ctx, (String)querySql.toString());
            HashMap autidPerosn = new HashMap();
            while (iAuditSet.next()) {
                autidPerosn.put(iAuditSet.getString("FPERSONID"), null);
            }
            Object objValue = null;
            int preTime = 1;
            Vector vecAdd = new Vector();
            Vector vecEdit = new Vector();
            Vector<Object> vecTemp = null;
            if (time > 1) {
                preTime = time - 1;
            }
            String sqlHorTable = " SELECT * FROM " + infoCmpScheme.getHisTableName() + " where fperiod = '" + infoCmpPeriod.getId() + "' and ftime = " + preTime;
            IRowSet iRowSetHorTable = DbUtil.executeQuery((Context)ctx, (String)sqlHorTable);
            while (iRowSetHorTable.next()) {
                personID = iRowSetHorTable.getString("FPERSONID");
                if (autidPerosn.containsKey(personID)) continue;
                mapPerson = (HashMap)mapData.get(personID);
                int size2 = lstItem.size();
                for (int i = 0; i < size2; ++i) {
                    itemID = lstItem.get(i).toString();
                    itemNumber = mapItem.get(itemID).toString();
                    objValue = iRowSetHorTable.getObject(itemNumber);
                    vecTemp = new Vector<Object>();
                    if (mapPerson != null && mapPerson.get(itemID) != null) {
                        fid = mapPerson.get(itemID).toString();
                        vecTemp.add(fid);
                        vecTemp.add(objValue);
                        vecTemp.add(itemID);
                        vecEdit.add(vecTemp);
                        continue;
                    }
                    vecTemp.add(personID);
                    vecTemp.add(itemID);
                    vecTemp.add(objValue);
                    vecAdd.add(vecTemp);
                }
            }
            conn = EJBFactory.getConnection((Context)ctx);
            int count = 0;
            Vector vecTempAdd = new Vector();
            int size3 = vecAdd.size();
            for (int i = 0; i < size3; ++i) {
                vecTempAdd.add(vecAdd.get(i));
                if (++count != 5000) continue;
                this.addBatchPeriodEndInputVaule(conn, vecTempAdd, tableName, cmpSchemeID, cmpPeriodID, time, mapItemDataType);
                vecTempAdd = new Vector();
                count = 0;
            }
            if (count > 0) {
                this.addBatchPeriodEndInputVaule(conn, vecTempAdd, tableName, cmpSchemeID, cmpPeriodID, time, mapItemDataType);
            }
            count = 0;
            Vector vecTempEdit = new Vector();
            int size4 = vecEdit.size();
            for (int i = 0; i < size4; ++i) {
                vecTempEdit.add(vecEdit.get(i));
                if (++count != 5000) continue;
                this.editBatchPeriodEndInputVaule(conn, vecTempEdit, mapItemDataType, tableName);
                vecTempEdit = new Vector();
                count = 0;
            }
            if (count > 0) {
                this.editBatchPeriodEndInputVaule(conn, vecTempEdit, mapItemDataType, tableName);
            }
            SQLUtils.cleanup((Connection)conn);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup(conn);
        }
    }

    private void editBatchPeriodEndInputVaule(Connection conn, Vector vecEdit, HashMap mapItemDataType) throws BOSException, EASBizException {
        String sqlEdit = " UPDATE T_HR_PERIODENDINPUT SET FVALUE=?,FFloatValue=?,FIntValue=?,FStringValue=?,FDateValue=? WHERE FID=? ";
        PreparedStatement psEdit = null;
        try {
            psEdit = conn.prepareStatement(sqlEdit);
            Vector vecTemp = null;
            int size = vecEdit.size();
            for (int i = 0; i < size; ++i) {
                vecTemp = (Vector)vecEdit.get(i);
                int iDataType = (Integer)mapItemDataType.get(vecTemp.get(2).toString());
                psEdit.setObject(1, HRCmpItemUtils.convertCmpItemValueByDataType(60, vecTemp.get(1), iDataType), HRCmpItemUtils.getSqlTypeByCmpItemDataType(ItemDataTypeEnum.CURRENCY));
                psEdit.setObject(2, HRCmpItemUtils.convertCmpItemValueByDataType(50, vecTemp.get(1), iDataType), HRCmpItemUtils.getSqlTypeByCmpItemDataType(ItemDataTypeEnum.FLOAT));
                psEdit.setObject(3, HRCmpItemUtils.convertCmpItemValueByDataType(40, vecTemp.get(1), iDataType), HRCmpItemUtils.getSqlTypeByCmpItemDataType(ItemDataTypeEnum.INT));
                psEdit.setObject(4, HRCmpItemUtils.convertCmpItemValueByDataType(30, vecTemp.get(1), iDataType), HRCmpItemUtils.getSqlTypeByCmpItemDataType(ItemDataTypeEnum.STRING));
                psEdit.setObject(5, HRCmpItemUtils.convertCmpItemValueByDataType(20, vecTemp.get(1), iDataType), HRCmpItemUtils.getSqlTypeByCmpItemDataType(ItemDataTypeEnum.DATE));
                psEdit.setString(6, vecTemp.get(0).toString());
                psEdit.addBatch();
            }
            psEdit.executeBatch();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup((Statement)psEdit);
        }
    }

    @Override
    protected int _synData(Context ctx) throws BOSException, EASBizException {
        logger.info((Object)">>>>>>>>>>SchemeFacadeControllerBean:_synData");
        SynCompensationData80New synCmpCalResultData80 = new SynCompensationData80New();
        synCmpCalResultData80.synchronize(ctx);
        return 1;
    }

    @Override
    protected String _generatorTemp(Context ctx) throws BOSException, EASBizException {
        return null;
    }
}

