/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.formulateutil;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.sql.dom.SqlSelect;
import com.kingdee.bos.sql.dom.SqlSelectBase;
import com.kingdee.bos.sql.dom.SqlSelectItem;
import com.kingdee.bos.sql.dom.expr.SqlBinaryOpExpr;
import com.kingdee.bos.sql.formater.DrSQLFormater;
import com.kingdee.bos.sql.formater.FormaterException;
import com.kingdee.bos.sql.parser.SelectParser;
import com.kingdee.bos.sql.parser.SqlExprParser;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.compensation.CmpItemCollection;
import com.kingdee.eas.hr.compensation.CmpItemFactory;
import com.kingdee.eas.hr.compensation.CmpItemInfo;
import com.kingdee.eas.hr.compensation.CmpSchemeFactory;
import com.kingdee.eas.hr.compensation.CmpSchemeInfo;
import com.kingdee.eas.hr.compensation.CmpSchemeItemCollection;
import com.kingdee.eas.hr.compensation.CmpSchemeItemFactory;
import com.kingdee.eas.hr.compensation.ICmpScheme;
import com.kingdee.eas.hr.compensation.ICmpSchemeItem;
import com.kingdee.eas.hr.compensation.util.HRCmpItemUtils;
import com.kingdee.eas.hr.compensation.util.HRUtils;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FormulaTranslatorUtil {
    public static String getTableName(Context ctx, IObjectPK schPK) throws EASBizException, BOSException {
        if (ctx.get((Object)"CMPSCHEME_DATATABLE") != null) {
            return ctx.get((Object)"CMPSCHEME_DATATABLE").toString();
        }
        ICmpScheme scheme = CmpSchemeFactory.getLocalInstance(ctx);
        CmpSchemeInfo info = scheme.getCmpSchemeInfo(schPK);
        ctx.put((Object)"CMPSCHEME_DATATABLE", (Object)info.getHorTableName());
        return info.getHorTableName();
    }

    public static String formatScript(String kScript) {
        Pattern p = Pattern.compile("[\\d][.](\\d)*E(\\d)*");
        Matcher m = p.matcher(kScript);
        String temp = "";
        StringBuffer rst = new StringBuffer();
        int start = 0;
        int end = 0;
        int tag = 0;
        BigDecimal big = null;
        while (m.find()) {
            start = m.start();
            end = m.end();
            temp = kScript.substring(start, end);
            big = new BigDecimal(temp);
            rst.append(kScript.substring(tag, start));
            rst.append(big.toString());
            tag = end;
        }
        rst.append(kScript.substring(end));
        kScript = rst.toString();
        kScript = kScript.replaceAll("\"", "'");
        kScript = kScript.replaceAll("\\|\\|", " OR ");
        kScript = kScript.replaceAll("\\&\\&", " AND ");
        kScript = kScript.replaceAll("==", "=");
        return kScript;
    }

    public static List getSchPerItem(Context ctx, IObjectPK schPK) throws BOSException {
        if (ctx.get((Object)"HR_CMPSHEME_ITEMS") != null) {
            return (List)ctx.get((Object)"HR_CMPSHEME_ITEMS");
        }
        ArrayList<String> personList = new ArrayList<String>();
        ICmpSchemeItem item = CmpSchemeItemFactory.getLocalInstance(ctx);
        StringBuffer oql = new StringBuffer();
        oql.append("select cmpItem.number where cmpScheme.id='");
        oql.append(schPK.toString());
        oql.append("' and cmpItem.cmpItemCatalog.number='FPER'");
        CmpSchemeItemCollection cols = item.getCmpSchemeItemCollection(oql.toString());
        int size = cols.size();
        for (int i = 0; i < size; ++i) {
            personList.add(cols.get(i).getCmpItem().getNumber());
        }
        ctx.put((Object)"HR_CMPSHEME_ITEMS", personList);
        return personList;
    }

    public static Map getPerItemsDesc(Context ctx, IObjectPK schPK) throws EASBizException, ParserException, BOSException, FormaterException {
        if (ctx.get((Object)"ALL_QUERY_PERSONITEMS_DESC") != null) {
            return (Map)ctx.get((Object)"ALL_QUERY_PERSONITEMS_DESC");
        }
        HashMap<String, String> rst = new HashMap<String, String>();
        CmpItemCollection colTemp = (CmpItemCollection)((Object)ctx.get((Object)"colCmpItem"));
        StringBuffer buff = new StringBuffer();
        SqlSelect select = FormulaTranslatorUtil.getSelectStmt(ctx, schPK.toString());
        String number = null;
        CmpItemInfo infoCmpItem = null;
        int size = colTemp.size();
        for (int i = 0; i < size; ++i) {
            infoCmpItem = colTemp.get(i);
            number = infoCmpItem.getNumber();
            if (!number.startsWith("FPER") && !number.startsWith("FFPER")) continue;
            int jsize = select.selectList.size();
            for (int j = 0; j < jsize; ++j) {
                SqlSelectItem selectItem = (SqlSelectItem)select.selectList.get(j);
                if (!selectItem.alias.replaceAll("\"", "").equals(number)) continue;
                buff.delete(0, buff.length());
                DrSQLFormater formater = new DrSQLFormater(buff);
                formater.formatExpr(selectItem.expr);
                rst.put(number, buff.toString());
            }
        }
        ctx.put((Object)"ALL_QUERY_PERSONITEMS_DESC", rst);
        return rst;
    }

    public static SqlSelect getSelectStmt(Context ctx, String id) throws EASBizException, ParserException, BOSException, FormaterException {
        if (ctx.get((Object)"CMP_QUERY_SELECT") != null) {
            return (SqlSelect)ctx.get((Object)"CMP_QUERY_SELECT");
        }
        String queryPK = "com.kingdee.eas.hr.compensation.app.PersonInfoQuery";
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK(queryPK));
        try {
            EntityViewInfo evi = HRCmpItemUtils.getCmpItemDynQueryFilter(ctx, HRUtils.getSchemeQueryType(queryPK));
            exec.setObjectView(evi);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        SelectParser parser = new SelectParser(exec.getSQL());
        SqlSelect selectStmt = null;
        SqlSelectBase sb = parser.select();
        if (sb instanceof SqlSelect) {
            selectStmt = (SqlSelect)sb;
        }
        ctx.put((Object)"CMP_QUERY_SELECT", (Object)selectStmt);
        return selectStmt;
    }

    public static SqlSelect getSelectStmt(Context ctx, String hortabName, String id) throws EASBizException, ParserException, BOSException, FormaterException {
        if (ctx.get((Object)"ALL_QUERY_SUBQUERY") != null) {
            return (SqlSelect)ctx.get((Object)"ALL_QUERY_SUBQUERY");
        }
        String personSelectSql = FormulaTranslatorUtil.getPersonSelectSql(hortabName);
        SelectParser parser = new SelectParser(personSelectSql);
        SqlSelectBase sb = parser.select();
        SqlSelect selectStmt = null;
        if (sb instanceof SqlSelect) {
            selectStmt = (SqlSelect)sb;
        }
        ctx.put((Object)"ALL_QUERY_SUBQUERY", (Object)selectStmt);
        return selectStmt;
    }

    public static SqlBinaryOpExpr formatPersonItem(Context ctx, SqlBinaryOpExpr expr, String regex) throws ParserException, BOSException, FormaterException {
        if (expr == null) {
            return null;
        }
        StringBuffer buff = new StringBuffer();
        Map personItems = FormulaTranslatorUtil.getPersonSelectItems(ctx);
        if (StringUtils.isEmpty((String)regex)) {
            StringBuffer perItemList = new StringBuffer("");
            if (personItems != null && !personItems.isEmpty()) {
                Iterator itr = personItems.keySet().iterator();
                while (itr.hasNext()) {
                    perItemList.append(itr.next());
                    perItemList.append("|");
                }
                perItemList.deleteCharAt(perItemList.length() - 1);
            }
            regex = perItemList.toString();
        }
        DrSQLFormater formater = new DrSQLFormater(buff);
        formater.formatBinaryOpExpr(expr, false);
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(buff.toString());
        String key = "";
        String value = "";
        int start = 0;
        int end = 0;
        int tag = 0;
        StringBuffer sql = new StringBuffer();
        while (m.find()) {
            start = m.start();
            end = m.end();
            key = buff.substring(start, end);
            value = (String)personItems.get(key);
            sql.append(buff.substring(tag, start));
            sql.append(value);
            tag = end;
        }
        sql.append(buff.substring(tag));
        SqlExprParser parser = new SqlExprParser(sql.toString());
        return (SqlBinaryOpExpr)parser.expr();
    }

    public static Map getPersonSelectItems(Context ctx) throws ParserException, BOSException, FormaterException {
        if (ctx.get((Object)"ALL_QUERY_PERSONITEMS") != null) {
            return (Map)ctx.get((Object)"ALL_QUERY_PERSONITEMS");
        }
        HashMap<String, String> rst = new HashMap<String, String>();
        String queryPK = "com.kingdee.eas.hr.compensation.app.PersonInfoQuery";
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK(queryPK));
        try {
            EntityViewInfo evi = HRCmpItemUtils.getCmpItemDynQueryFilter(ctx, HRUtils.getSchemeQueryType(queryPK));
            exec.setObjectView(evi);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        SelectParser parser = new SelectParser(exec.getSQL());
        SqlSelectBase sb = parser.select();
        if (sb instanceof SqlSelect) {
            SqlSelect selectStmt = (SqlSelect)sb;
            SqlSelectItem selectItem = null;
            int size = selectStmt.selectList.size();
            for (int i = 0; i < size; ++i) {
                StringBuffer selectExpr = new StringBuffer();
                selectItem = (SqlSelectItem)selectStmt.selectList.get(i);
                DrSQLFormater formater = new DrSQLFormater(selectExpr);
                formater.formatExpr(selectItem.expr, false);
                rst.put(selectItem.alias.replaceAll("\"", ""), selectExpr.toString().replaceAll("\"", ""));
            }
        }
        ctx.put((Object)"ALL_QUERY_PERSONITEMS", rst);
        return rst;
    }

    public static String toTranslateKSQL(String str) {
        return str;
    }

    public static String replaceItemOfOwnItemValue(Context ctx, String oldItemNumber, Map querySelectItems) throws BOSException {
        if (oldItemNumber.trim().indexOf("FPER") == 0 || oldItemNumber.trim().indexOf("FFPER") == 0) {
            HROrgUnitInfo hrOrgInfo = null;
            hrOrgInfo = ctx == null ? SysContext.getSysContext().getCurrentHRUnit() : ContextUtil.getCurrentHRUnit((Context)ctx);
            if (hrOrgInfo == null) {
                return oldItemNumber;
            }
            String oql = "select Number,ItemValue where HrOrgUnit.Id = '" + hrOrgInfo.getId().toString() + "' and (ItemValue is not null) and number = '" + oldItemNumber + "'";
            CmpItemCollection itemCol = null;
            itemCol = ctx == null ? CmpItemFactory.getRemoteInstance().getCmpItemCollection(oql) : CmpItemFactory.getLocalInstance(ctx).getCmpItemCollection(oql);
            if (itemCol.size() > 0 && itemCol.get(0).getItemValue().split(";").length == 5 && querySelectItems.containsKey(oldItemNumber + ".ID")) {
                return oldItemNumber + ".ID";
            }
            return oldItemNumber;
        }
        return oldItemNumber;
    }

    public static Map getFunColumn(Context ctx, String tableName, String tableAlias) throws BOSException {
        HashMap<String, String> rst = new HashMap<String, String>();
        List allColumn = HRUtils.getColumnOfTable(ctx, tableName);
        String columnName = null;
        for (int i = 0; i < allColumn.size(); ++i) {
            columnName = allColumn.get(i).toString();
            if (!columnName.startsWith("FHS")) continue;
            rst.put(columnName, tableAlias + "." + columnName);
        }
        return rst;
    }

    public static Map getNeedChangPerItem(Context ctx) throws BOSException {
        if (ctx.get((Object)"NEED_CHANGE_PERSONITEMS") != null) {
            return (Map)ctx.get((Object)"NEED_CHANGE_PERSONITEMS");
        }
        String oql = "select Number,ItemValue where HrOrgUnit.Id = '" + ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString() + "' and (ItemValue > ' ') and (number like 'FPER%')";
        CmpItemCollection itemCol = CmpItemFactory.getLocalInstance(ctx).getCmpItemCollection(oql);
        HashMap<String, String> map = new HashMap<String, String>();
        String[] itemDesc = null;
        String queryName = "";
        for (int i = 0; i < itemCol.size(); ++i) {
            itemDesc = itemCol.get(i).getItemValue().split(";");
            if (itemDesc.length != 5 || !itemDesc[0].equals("10") || (queryName = itemDesc[2]) == null || queryName.length() <= 0) continue;
            map.put(itemCol.get(i).getNumber(), itemCol.get(i).getNumber() + ".ID");
        }
        ctx.put((Object)"NEED_CHANGE_PERSONITEMS", map);
        return map;
    }

    public static SqlSelect getSqlSelect(String sql) throws BOSException {
        SqlSelectBase sb;
        SqlSelect select = null;
        try {
            SelectParser parser = new SelectParser(sql);
            sb = parser.select();
        }
        catch (ParserException e) {
            throw new BOSException((Throwable)e);
        }
        if (sb != null && sb instanceof SqlSelect) {
            select = (SqlSelect)sb;
        }
        return select;
    }

    private static String getPersonSelectSql(String horTableName) {
        StringBuffer personSelectSql = new StringBuffer();
        personSelectSql.append(" select 1 from t_bd_person \"PERSON\" ").append(" inner join ").append(horTableName).append(" horTable on horTable.FPersonID =\"PERSON\".FID ").append(" where \"PERSON\".FID <>'1'");
        return personSelectSql.toString();
    }
}

