/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTCell;
import com.kingdee.bos.ctrl.kdf.table.KDTColumns;
import com.kingdee.bos.ctrl.kdf.table.KDTRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.render.CellTextRender;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.eas.framework.config.ColumnItemData;
import com.kingdee.eas.framework.config.TablePreferencesHelper;
import com.kingdee.eas.framework.config.UserCustomConfigItemData;
import com.kingdee.eas.framework.config.UserPreferenceData;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Rectangle;
import java.awt.Shape;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class CompTableStyleUtil {
    private TablePreferencesHelper tHelper;
    private KDTable tblMain;
    private String tableFullName;

    public void setTableFullName(String tableFullName) {
        this.tableFullName = tableFullName;
    }

    public void setTHelper(TablePreferencesHelper helper) {
        this.tHelper = helper;
    }

    public void setTblMain(KDTable tblMain) {
        this.tblMain = tblMain;
    }

    public void fillUserConfig() {
        Map tables;
        if (this.tHelper == null || this.tblMain == null) {
            return;
        }
        if (this.tHelper.defaultUserData != null) {
            this.setDefaultUserData();
        }
        if ((tables = this.tHelper.tables) == null || tables.size() == 0) {
            return;
        }
        UserPreferenceData userDBData = this.tHelper.getUserDataFromDB();
        Map.Entry entry2 = null;
        for (Map.Entry entry2 : tables.entrySet()) {
            String key = (String)entry2.getKey();
            KDTable table = (KDTable)entry2.getValue();
            if (this.tHelper.isCanSetTable() && userDBData != null && userDBData.getTableCurrentSetting(key) != null) {
                this.tHelper.applyConfigFromData(table, userDBData.getTableCurrentSetting(key), false);
                continue;
            }
            this.tHelper.applyConfigFromData(table, this.tHelper.getDefaultUserData(this.tblMain), false);
        }
    }

    public void setDefaultUserData() {
        UserPreferenceData defaultData = this.tHelper.getUserDataFromUI();
        UserCustomConfigItemData itemData = defaultData.getTableCurrentSetting(this.tableFullName);
        if (itemData == null) {
            return;
        }
        Map columnDataMap = itemData.getColumnData();
        List<Object> columnList = Arrays.asList(columnDataMap.keySet().toArray());
        ArrayList<String> removeKeyList = new ArrayList<String>();
        if (this.tblMain.getRowCount() > 0) {
            // empty if block
        }
        ColumnItemData columnData = null;
        Object var7_7 = null;
        for (String string : columnList) {
            columnData = (ColumnItemData)itemData.getColumnData().get(string);
            if (columnData == null) continue;
            if (this.tblMain.getColumn(string) == null) {
                removeKeyList.add(string);
                continue;
            }
            columnData.setHidden(false);
            columnData.setWidth(100);
            columnData.setLocked(false);
        }
        for (int i = 0; i < removeKeyList.size(); ++i) {
            columnDataMap.remove((String)removeKeyList.get(i));
        }
        Map genericDataMap = this.tHelper.getDefaultUserData(this.tblMain).getGenericData();
        itemData.getGenericData().putAll(genericDataMap);
        this.tHelper.setDefaultUserData(defaultData);
    }

    public static boolean autoFitRowHeight(KDTable table, int rowIndex, int extend, boolean isHead) {
        Object rows = null;
        rows = isHead ? table.getHead() : table.getBody();
        KDTColumns cols = table.getColumns();
        KDTRow row = rows.getRow(rowIndex);
        if (row == null || !row.isResizeable() || row.getStyle().isHided()) {
            return false;
        }
        int maxHeight = 0;
        int rowHeight = rows.getRowHeight(rowIndex);
        int defaultHeight = isHead ? table.getDefaultHeadRowHeight() : table.getDefaultRowHeight();
        int colCount = table.getColumnCount();
        for (int i = 0; i < colCount; ++i) {
            IBasicRender render;
            Object obj;
            KDTCell cell = row.getCell(i);
            if (cell == null) continue;
            Object object = obj = isHead ? cell.getValue() : table.getCellDisplayText(cell, rowIndex, i);
            if (obj == null) continue;
            IBasicRender iBasicRender = render = isHead ? table.getHeadCellRenderer(rowIndex, i) : table.getCellRenderer(rowIndex, i);
            if (!(render instanceof CellTextRender)) continue;
            CellTextRender textRender = (CellTextRender)render;
            Rectangle rect = new Rectangle(0, 0, cols.getColumnWidth(i) - 6, rowHeight);
            int h = (int)textRender.getPreferredHeight(table.getGraphics(), (Shape)rect, obj.toString(), cell.getStyle(), cell.getValue());
            if (h >= defaultHeight) {
                h += extend;
            }
            if (h <= maxHeight) continue;
            maxHeight = h;
        }
        if (maxHeight != 0 && maxHeight != rowHeight) {
            row.setHeight(maxHeight);
            table.reLayoutAndPaint();
            return true;
        }
        return false;
    }

    public static int getTblHeadHeight() throws BOSException {
        String sql = "select top 1 fheight from t_hr_TblHeadHeight ";
        ISQLExecutor iSql = SQLExecutorFactory.getRemoteInstance((String)sql);
        try {
            IRowSet rows = iSql.executeSQL();
            if (rows.next()) {
                return rows.getInt("fheight");
            }
        }
        catch (SQLException e) {
            return -1;
        }
        return -1;
    }
}

