/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.PropertyRefInfo;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SubEntityInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.query.util.QueryUtil;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.QueryUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.compensation.CmpItemCollection;
import com.kingdee.eas.hr.compensation.CmpItemFactory;
import com.kingdee.eas.hr.compensation.CmpItemInfo;
import com.kingdee.eas.hr.compensation.CmpItemPrecisionTypeEnum;
import com.kingdee.eas.hr.compensation.DepCmpStandradSchemeFactory;
import com.kingdee.eas.hr.compensation.DepCmpStandradSchemeInfo;
import com.kingdee.eas.hr.compensation.DeptSchemeInfo;
import com.kingdee.eas.hr.compensation.ItemDataTypeEnum;
import com.kingdee.eas.hr.compensation.ItemSubjectEnum;
import com.kingdee.eas.hr.compensation.util.HRUtils;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class HRCmpItemUtils {
    private static Logger logger = Logger.getLogger(HRCmpItemUtils.class);

    public static boolean isInitCmpItemCatalog(String id) {
        boolean isInit = false;
        if (id == null) {
            return true;
        }
        if (id.equals("FPER") || id.equals("FSAL") || id.equals("FCHK") || id.equals("FPRM") || id.equals("FWEL") || id.equals("FOTH")) {
            isInit = true;
        }
        return isInit;
    }

    public static boolean isExcludeFixedCmpItem(String number) {
        boolean isExclude = false;
        if (number == null) {
            return true;
        }
        if (number.equals("FSAL003") || number.equals("FSAL029") || number.equals("FSAL008") || number.equals("FSAL009") || number.equals("FSAL010")) {
            isExclude = true;
        }
        return isExclude;
    }

    public static BigDecimal formatBigDecimalWeiShu(DeptSchemeInfo deptSchemeInfo, BigDecimal sauData) {
        if (sauData == null) {
            return null;
        }
        return HRCmpItemUtils.convertPrecisionForBigDecimal(sauData, deptSchemeInfo.getDecDigital(), CmpItemPrecisionTypeEnum.SISHEWURU);
    }

    public static String formatBigDecimal(BigDecimal value, int precicion) {
        if (value == null) {
            return "";
        }
        String str = new BigDecimal("0.00").compareTo(value) == 0 ? "0.00000000000000000000000" : value.toString();
        if (str.lastIndexOf(".") == -1) {
            if (precicion == 0) {
                return str;
            }
            StringBuffer strBuffer = new StringBuffer();
            strBuffer.append(str);
            strBuffer.append(".");
            for (int i = 0; i < precicion; ++i) {
                strBuffer.append("0");
            }
            return strBuffer.toString();
        }
        if (str.lastIndexOf(".") == str.length() - 2) {
            return str + "0";
        }
        int len = str.lastIndexOf(".");
        if (str.length() < str.lastIndexOf(".") + 1 + precicion) {
            StringBuffer strBuffer = new StringBuffer();
            strBuffer.append(str);
            for (int i = 0; i < str.lastIndexOf(".") + 1 + precicion - str.length(); ++i) {
                strBuffer.append("0");
            }
            str = strBuffer.toString();
        }
        if (precicion > 0) {
            len = str.lastIndexOf(".") + 1 + precicion;
        }
        return str.substring(0, len);
    }

    public static BigDecimal convertPrecisionForBigDecimal(BigDecimal sauData, int precision, CmpItemPrecisionTypeEnum precisionType) {
        if (sauData == null || precisionType == null) {
            return null;
        }
        BigDecimal temBigD = null;
        if (precisionType.getValue() == 0) {
            return sauData.setScale(precision, 4);
        }
        if (precisionType.getValue() == 1) {
            return sauData.setScale(precision, 0);
        }
        if (precisionType.getValue() == 2) {
            return sauData.setScale(precision, 1);
        }
        if (precisionType.getValue() == 3) {
            temBigD = sauData.setScale(2, 1).subtract(sauData.setScale(1, 1)).equals(new BigDecimal("0.00")) ? sauData.setScale(1, 1) : sauData.setScale(1, 0);
            temBigD = temBigD.divide(new BigDecimal("1"), precision, 1);
            return temBigD;
        }
        if (precisionType.getValue() == 4) {
            temBigD = sauData.setScale(1, 1).subtract(sauData.setScale(0, 1)).equals(new BigDecimal("0.0")) ? sauData.setScale(0, 1) : sauData.setScale(0, 0);
            temBigD = temBigD.divide(new BigDecimal("1"), precision, 1);
            return temBigD;
        }
        return sauData.setScale(precision, 4);
    }

    public static String getColumnFormatStr(int precision) {
        StringBuffer sb = new StringBuffer("#,##0");
        if (precision > 0) {
            sb.append(".");
            for (int i = 0; i < precision; ++i) {
                sb.append("0");
            }
        }
        return sb.toString();
    }

    public static int getCmpItemPrecision(HashMap cmpItemsMapTem) {
        if (cmpItemsMapTem == null) {
            return 0;
        }
        Set keySet = cmpItemsMapTem.keySet();
        Iterator ite = keySet.iterator();
        CmpItemInfo cmpItemTem = null;
        int precision = 0;
        while (ite.hasNext()) {
            cmpItemTem = (CmpItemInfo)cmpItemsMapTem.get(ite.next().toString());
            if (cmpItemTem.getDecDigital() <= precision) continue;
            precision = cmpItemTem.getDecDigital();
        }
        return precision;
    }

    public static int getcmpItemPrecisionByDepCmpStand(Context ctx, DepCmpStandradSchemeInfo depCmpStandradScheme) throws EASBizException, BOSException {
        if (depCmpStandradScheme == null) {
            return 0;
        }
        HashMap cmpItemMap = DepCmpStandradSchemeFactory.getLocalInstance(ctx).getCmpItemMapIF((IObjectValue)depCmpStandradScheme);
        int prec = HRCmpItemUtils.getCmpItemPrecision(cmpItemMap);
        return prec;
    }

    public static String convertPrecisionForSql(String strFieldName, int iScale, CmpItemPrecisionTypeEnum precisionType, boolean isProcessNull) {
        String strNewFieldSql = null;
        if (isProcessNull) {
            strFieldName = "isnull(" + strFieldName + ",0)";
        }
        if (precisionType.equals((Object)CmpItemPrecisionTypeEnum.SISHEWURU)) {
            strNewFieldSql = "round(" + strFieldName + "," + iScale + ",0)";
        } else if (precisionType.equals((Object)CmpItemPrecisionTypeEnum.JINWEI)) {
            strNewFieldSql = "case when (" + strFieldName + " - round(" + strFieldName + "," + iScale + ",1)) > 0  then round(" + strFieldName + "," + iScale + ",1) + " + HRCmpItemUtils.getOneInValue(iScale) + " else round(" + strFieldName + "," + iScale + ",1) end";
        } else if (precisionType.equals((Object)CmpItemPrecisionTypeEnum.SHEWEI)) {
            strNewFieldSql = "round(" + strFieldName + "," + iScale + ",1)";
        } else if (precisionType.equals((Object)CmpItemPrecisionTypeEnum.JIANFENJINJIAO)) {
            strNewFieldSql = "case when (round(" + strFieldName + ",2,1) - round(" + strFieldName + ",1,1)) > 0  then round(" + strFieldName + ",1,1) + " + HRCmpItemUtils.getOneInValue(1) + " else round(" + strFieldName + ",1,1) end";
            if (iScale == 0) {
                strNewFieldSql = "round(" + strNewFieldSql + ",0,1)";
            }
        } else if (precisionType.equals((Object)CmpItemPrecisionTypeEnum.JIANJIAOJINYUAN)) {
            strNewFieldSql = "case when (round(" + strFieldName + ",1,1) - round(" + strFieldName + ",0,1)) > 0  then round(" + strFieldName + ",0,1) + 1 else round(" + strFieldName + ",0,1) end";
            strNewFieldSql = "CEILING(" + strNewFieldSql + ")";
        }
        return strNewFieldSql;
    }

    private static String getOneInValue(int iScale) {
        if (iScale < 0) {
            return "0";
        }
        if (iScale == 0) {
            return "1";
        }
        StringBuffer str = new StringBuffer("0.");
        for (int i = 1; i < iScale; ++i) {
            str.append("0");
        }
        str.append("1");
        return str.toString();
    }

    public static HashMap getCmpItemInfoByItemIds(Context ctx, List lstItemIds) {
        HashMap<String, CmpItemInfo> map = new HashMap<String, CmpItemInfo>();
        if (lstItemIds.size() <= 0) {
            return map;
        }
        StringBuffer strItemIds = new StringBuffer();
        int size = lstItemIds.size();
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                strItemIds.append(",");
            }
            strItemIds.append("'").append(lstItemIds.get(i).toString()).append("'");
        }
        String oql = "select id,number,name,dataType,decDigital,precisionType where id in (" + strItemIds.toString() + ")";
        CmpItemCollection col = null;
        try {
            col = ctx == null ? CmpItemFactory.getRemoteInstance().getCmpItemCollection(oql) : CmpItemFactory.getLocalInstance(ctx).getCmpItemCollection(oql);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
        }
        CmpItemInfo itemInfo = null;
        if (col != null) {
            int size2 = col.size();
            for (int i = 0; i < size2; ++i) {
                itemInfo = col.get(i);
                map.put(itemInfo.getId().toString(), itemInfo);
            }
        }
        return map;
    }

    public static HashMap getCmpItemInfoByNumber(Context ctx, String[] strItemNumbers) {
        StringBuffer strNumbers = new StringBuffer();
        int size = strItemNumbers.length;
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                strNumbers.append(",");
            }
            strNumbers.append("'").append(strItemNumbers[i]).append("'");
        }
        String strHrOrgId = null;
        strHrOrgId = ctx == null ? SysContext.getSysContext().getCurrentHRUnit().getId().toString() : ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        String oql = "select number,name,dataType,decDigital,precisionType where number in (" + strNumbers.toString() + ") and hrOrgUnit ='" + strHrOrgId + "'";
        CmpItemCollection col = new CmpItemCollection();
        try {
            col = ctx == null ? CmpItemFactory.getRemoteInstance().getCmpItemCollection(oql) : CmpItemFactory.getLocalInstance(ctx).getCmpItemCollection(oql);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
        }
        CmpItemInfo itemInfo = null;
        HashMap<String, CmpItemInfo> map = new HashMap<String, CmpItemInfo>();
        int size2 = col.size();
        for (int i = 0; i < size2; ++i) {
            itemInfo = col.get(i);
            map.put(itemInfo.getNumber(), itemInfo);
        }
        return map;
    }

    public static HashMap getCmpItemInfoByNumberNoPermission(Context ctx, String[] strItemNumbers) throws SQLException, BOSException {
        StringBuffer strNumbers = new StringBuffer();
        int size = strItemNumbers.length;
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                strNumbers.append(",");
            }
            strNumbers.append("'").append(strItemNumbers[i]).append("'");
        }
        String strHrOrgId = null;
        String fname = null;
        if (ctx == null) {
            strHrOrgId = SysContext.getSysContext().getCurrentHRUnit().getId().toString();
            fname = "fname_" + SysContext.getSysContext().getLocale().getLanguage();
        } else {
            strHrOrgId = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
            fname = "fname_" + ctx.getLocale().getLanguage();
        }
        String sql = "select fnumber," + fname + ",fdataType,fdecDigital,fprecisionType from t_hr_cmpitem where fnumber in (" + strNumbers.toString() + ") and FHROrgUnitID ='" + strHrOrgId + "'";
        ISQLExecutor exec = SQLExecutorFactory.getRemoteInstance((String)sql);
        IRowSet iRowSet = exec.executeSQL();
        CmpItemInfo itemInfo = null;
        HashMap<String, CmpItemInfo> map = new HashMap<String, CmpItemInfo>();
        while (iRowSet.next()) {
            itemInfo = new CmpItemInfo();
            itemInfo.setNumber(iRowSet.getString("fnumber"));
            itemInfo.setName(iRowSet.getString(fname));
            itemInfo.setDataType(ItemDataTypeEnum.getEnum(iRowSet.getInt("fdataType")));
            itemInfo.setDecDigital(iRowSet.getInt("fdecDigital"));
            itemInfo.setPrecisionType(CmpItemPrecisionTypeEnum.getEnum(iRowSet.getInt("fprecisionType")));
            map.put(itemInfo.getNumber(), itemInfo);
        }
        return map;
    }

    public static HashMap getCmpItemInfoByNumber(Context ctx, List lstItemNumbers) {
        if (lstItemNumbers.size() == 0 || !(lstItemNumbers.get(0) instanceof String)) {
            return null;
        }
        StringBuffer strNumbers = new StringBuffer();
        int size = lstItemNumbers.size();
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                strNumbers.append(",");
            }
            strNumbers.append("'").append((String)lstItemNumbers.get(i)).append("'");
        }
        String strHrOrgId = null;
        strHrOrgId = ctx == null ? SysContext.getSysContext().getCurrentHRUnit().getId().toString() : ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        String oql = "select number,name,dataType,decDigital,precisionType where number in (" + strNumbers.toString() + ") and hrOrgUnit ='" + strHrOrgId + "'";
        CmpItemCollection col = new CmpItemCollection();
        try {
            col = ctx == null ? CmpItemFactory.getRemoteInstance().getCmpItemCollection(oql) : CmpItemFactory.getLocalInstance(ctx).getCmpItemCollection(oql);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
        }
        CmpItemInfo itemInfo = null;
        HashMap<String, CmpItemInfo> map = new HashMap<String, CmpItemInfo>();
        int size2 = col.size();
        for (int i = 0; i < size2; ++i) {
            itemInfo = col.get(i);
            map.put(itemInfo.getNumber(), itemInfo);
        }
        return map;
    }

    public static String getValueFieldByDataType(int itemDataType) {
        String strFieldName = null;
        strFieldName = itemDataType == 60 ? "FVALUE" : (itemDataType == 50 ? "FFloatValue" : (itemDataType == 40 ? "FIntValue" : (itemDataType == 30 ? "FStringValue" : (itemDataType == 20 ? "FDateValue" : "FVALUE"))));
        return strFieldName;
    }

    public static Object convertCmpItemValueByDataType(int convertToDataType, Object itemValue, int curItemDataType) {
        if (itemValue == null) {
            return null;
        }
        Object rtnObj = null;
        if (convertToDataType == 60 && curItemDataType == 60) {
            rtnObj = new BigDecimal(itemValue.toString());
        } else if (convertToDataType == 50 && curItemDataType == 50) {
            rtnObj = new BigDecimal(itemValue.toString());
        } else if (convertToDataType == 40 && curItemDataType == 40) {
            rtnObj = Integer.valueOf(itemValue.toString());
        } else if (convertToDataType == 30 && curItemDataType == 30) {
            rtnObj = itemValue.toString();
        } else if (convertToDataType == 20 && curItemDataType == 20) {
            rtnObj = (Date)itemValue;
        }
        return rtnObj;
    }

    public static int getSqlTypeByCmpItemDataType(ItemDataTypeEnum dataType) {
        int tp = 9999;
        if (dataType.equals((Object)ItemDataTypeEnum.CURRENCY)) {
            tp = 3;
        } else if (dataType.equals((Object)ItemDataTypeEnum.FLOAT)) {
            tp = 3;
        } else if (dataType.equals((Object)ItemDataTypeEnum.INT)) {
            tp = 4;
        } else if (dataType.equals((Object)ItemDataTypeEnum.STRING)) {
            tp = 12;
        } else if (dataType.equals((Object)ItemDataTypeEnum.DATE)) {
            tp = 91;
        }
        return tp;
    }

    public static Map getPersPrecisionMap(Map perCIMap) {
        Iterator iter = perCIMap.entrySet().iterator();
        String perKey = null;
        List cmpItemList = null;
        HashMap cmpitemTempMap = null;
        HashMap<String, Integer> persPrecisionMap = new HashMap<String, Integer>();
        Map.Entry entry = null;
        while (iter.hasNext()) {
            entry = iter.next();
            perKey = (String)entry.getKey();
            cmpItemList = (List)entry.getValue();
            cmpitemTempMap = HRCmpItemUtils.getCmpItemInfoByNumber(null, cmpItemList);
            int precision = HRCmpItemUtils.getCmpItemPrecision(cmpitemTempMap);
            persPrecisionMap.put(perKey, precision);
        }
        return persPrecisionMap;
    }

    public static EntityViewInfo getCmpItemDynQueryFilter(Context ctx, int type) throws BOSException, SQLException {
        return HRCmpItemUtils.getCmpItemDynQueryFilter(ctx, type, null);
    }

    public static EntityViewInfo getCmpItemDynQueryFilter(Context ctx, int type, EntityViewInfo evi, String hroId) throws BOSException, SQLException {
        SelectorItemCollection itemColl;
        if (type == -1) {
            return null;
        }
        long t1 = System.currentTimeMillis();
        ISQLExecutor iSQLExec = null;
        if (ctx == null) {
            if (StringUtils.isEmpty((String)hroId)) {
                hroId = SysContext.getSysContext().getCurrentHRUnit().getId().toString();
            }
            iSQLExec = SQLExecutorFactory.getRemoteInstance((String)("SELECT FDynSolutionID FROM T_HR_CmpitemDynquery WHERE FHROrgUnitID='" + hroId + "' AND FType=" + type));
        } else {
            if (StringUtils.isEmpty((String)hroId)) {
                hroId = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
            }
            iSQLExec = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)("SELECT FDynSolutionID FROM T_HR_CmpitemDynquery WHERE FHROrgUnitID='" + hroId + "' AND FType=" + type));
        }
        String dynQueryId = null;
        IRowSet rows = iSQLExec.executeSQL();
        while (rows.next()) {
            dynQueryId = rows.getString(1);
        }
        if (evi == null) {
            evi = new EntityViewInfo();
        }
        if (dynQueryId == null) {
            return evi;
        }
        BOSUuid dynId = BOSUuid.read((String)dynQueryId);
        EntityViewInfo temp = null;
        temp = ctx == null ? QueryUtils.getEntityViewInfoByDynQuery(null, (BOSUuid)dynId, (EntityViewInfo)evi) : QueryUtils.getEntityViewInfoByDynQuery((Context)ctx, (BOSUuid)dynId, (EntityViewInfo)evi);
        if (temp != null) {
            evi = temp;
        }
        if ((itemColl = evi.getSelector()) != null && itemColl.size() > 0) {
            SelectorItemCollection newSelector = new SelectorItemCollection();
            SelectorItemInfo itemInfo = null;
            for (int i = 0; i < itemColl.size(); ++i) {
                itemInfo = itemColl.get(i);
                if (itemInfo.getExtendedProperties().get("isDynQueryField") == null || !"true".equalsIgnoreCase(itemInfo.getExtendedProperties().get("isDynQueryField").toString())) continue;
                newSelector.add(itemInfo);
            }
            evi.setSelector(newSelector);
        }
        logger.info((Object)("HRCmpItemUtils.getCmpItemDynQueryFilter():" + (System.currentTimeMillis() - t1)));
        return evi;
    }

    public static EntityViewInfo getCmpItemDynQueryFilter(Context ctx, int type, EntityViewInfo evi) throws BOSException, SQLException {
        return HRCmpItemUtils.getCmpItemDynQueryFilter(ctx, type, evi, null);
    }

    public static ArrayList getMappingPersonItems(Context ctx, int type) throws BOSException, SQLException {
        String hroId = null;
        hroId = ctx == null ? SysContext.getSysContext().getCurrentHRUnit().getId().toString() : ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        return HRCmpItemUtils.getMappingPersonItems(ctx, type, hroId);
    }

    public static ArrayList getMappingPersonItems(Context ctx, int type, String hroId) throws BOSException, SQLException {
        String sql = "SELECT FDynSolutionID FROM T_HR_CmpitemDynquery WHERE FType = " + type + " AND FHROrgUnitID='" + hroId + "'";
        IRowSet rows = null;
        rows = ctx == null ? SQLExecutorFactory.getRemoteInstance((String)sql).executeSQL() : SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sql).executeSQL();
        String dynQueryId = null;
        while (rows.next()) {
            dynQueryId = rows.getString(1);
        }
        if (dynQueryId == null) {
            return new ArrayList();
        }
        sql = "SELECT FALIAS FROM T_QUERY_DynQuerySelectField T1 ";
        sql = sql + "INNER JOIN t_query_dynqueryentity T2 ON T1.fentityid = T2.FID ";
        sql = sql + "WHERE FALIAS IS NOT NULL AND T2.fdynsolutionid = '" + dynQueryId + "'";
        rows = ctx == null ? SQLExecutorFactory.getRemoteInstance((String)sql).executeSQL() : SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sql).executeSQL();
        ArrayList<String> personItems = new ArrayList<String>();
        while (rows.next()) {
            personItems.add(rows.getString("FALIAS"));
        }
        return personItems;
    }

    public boolean checkIsMappingOrNot(Context ctx, CmpItemInfo cmpItemInfo, int type) throws BOSException, SQLException {
        String number = cmpItemInfo.getNumber();
        ArrayList personItems = HRCmpItemUtils.getMappingPersonItems(ctx, type);
        if (personItems == null || personItems.size() == 0) {
            return false;
        }
        String itemNumber = null;
        for (int i = 0; i < personItems.size(); ++i) {
            itemNumber = (String)personItems.get(i);
            if (!number.equals(itemNumber)) continue;
            return true;
        }
        return false;
    }

    public static Map getPerItemMap(Context ctx, int type) throws BOSException, SQLException {
        String hroId = SysContext.getSysContext().getCurrentHRUnit().getId().toString();
        HashMap<String, String> perItemMap = new HashMap<String, String>();
        StringBuffer sb = new StringBuffer();
        sb.append(" select t1.falias,t1.fname_").append(SysContext.getSysContext().getLocale().getLanguage()).append(" from T_QUERY_DynQuerySelectField t1 ").append(" inner join T_QUERY_DynQueryEntity t2 on t2.fid=t1.fentityid ").append(" inner join T_HR_CmpitemDynquery t on t.fdynsolutionid = t2.fdynsolutionid ").append(" where t1.falias IS NOT NULL and t.ftype=").append(type).append(" and t.fhrorgunitid='").append(hroId).append("'");
        IRowSet rows = null;
        rows = ctx == null ? SQLExecutorFactory.getRemoteInstance((String)sb.toString()).executeSQL() : SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sb.toString()).executeSQL();
        while (rows.next()) {
            perItemMap.put(rows.getString(1), rows.getString(2));
        }
        return perItemMap;
    }

    public static List deleteNoMappingPersonItem(Context ctx, List lstCmpItem) throws BOSException {
        String hroId = null;
        hroId = ctx == null ? SysContext.getSysContext().getCurrentHRUnit().getId().toString() : ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        return HRCmpItemUtils.deleteNoMappingPersonItem(ctx, lstCmpItem, hroId);
    }

    public static List deleteNoMappingPersonItem(Context ctx, List lstCmpItem, String hrOrgUnitID) throws BOSException {
        ArrayList personItems = null;
        try {
            personItems = HRCmpItemUtils.getMappingPersonItems(ctx, 1, hrOrgUnitID);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        ArrayList<CmpItemInfo> newItemList = new ArrayList<CmpItemInfo>();
        CmpItemInfo itemInfo = null;
        String itemNumber = null;
        int size = lstCmpItem.size();
        block2: for (int i = 0; i < size; ++i) {
            itemInfo = (CmpItemInfo)lstCmpItem.get(i);
            if (itemInfo.getNumber().indexOf("FPER") == 0 && itemInfo.getSubject() == ItemSubjectEnum.NOTSYSINIT) {
                for (int t = 0; t < personItems.size(); ++t) {
                    itemNumber = (String)personItems.get(t);
                    if (!itemInfo.getNumber().equals(itemNumber)) continue;
                    newItemList.add(itemInfo);
                    continue block2;
                }
                continue;
            }
            newItemList.add(itemInfo);
        }
        return newItemList;
    }

    public static void addF7InfoToCmpItem(CmpItemCollection itemColl) throws Exception {
        String strQueryPK = "com.kingdee.eas.hr.compensation.app.HRPersonInfoQuery";
        MetaDataPK queryPK = new MetaDataPK(strQueryPK);
        QueryInfo queryInfo = MetaDataLoaderFactory.getRemoteMetaDataLoader().getQuery((IMetaDataPK)queryPK);
        EntityViewInfo evi = HRCmpItemUtils.getCmpItemDynQueryFilter(null, HRUtils.getSchemeQueryType(strQueryPK));
        QueryInfo newQueryInfo = (QueryInfo)queryInfo.clone();
        newQueryInfo.updateQuery(evi);
        SelectorItemCollection selectorColl = evi.getSelector();
        String propertyName = null;
        String cmpItemNum = null;
        QueryFieldInfo queryFieldInfo = null;
        CmpItemInfo cmpItemInfo = null;
        int size = itemColl.size();
        for (int i = 0; i < size; ++i) {
            PropertyInfo prop;
            PropertyRefInfo ref;
            SubEntityInfo subEntity;
            cmpItemInfo = itemColl.get(i);
            cmpItemNum = cmpItemInfo.getNumber();
            propertyName = HRUtils.getPropertyNameFromSelector(cmpItemNum, selectorColl);
            queryFieldInfo = QueryUtil.getQueryFieldByName((QueryInfo)newQueryInfo, (String)propertyName);
            if (queryFieldInfo == null) {
                queryFieldInfo = QueryUtil.getQueryFieldByName((QueryInfo)newQueryInfo, (String)cmpItemNum);
            }
            if (queryFieldInfo == null || queryFieldInfo == null || queryFieldInfo.getPropertyRefs().size() != 1 || (subEntity = (ref = queryFieldInfo.getPropertyRefs().get(0)).getSubEntity()) == null || ref.getRefProperty() == null || !(ref.getRefProperty() instanceof OwnPropertyInfo)) continue;
            if (ref.getRefProperty().toString().equals("id")) {
                EntityObjectInfo entityInfo = subEntity.getEntityRef();
                if (entityInfo == null || entityInfo.getExtendedProperty("defaultF7Query") == null) continue;
                String queryName = entityInfo.getExtendedProperty("defaultF7Query");
                cmpItemInfo.setItemValue("10;;" + queryName + ";;END");
                continue;
            }
            if (!((OwnPropertyInfo)ref.getRefProperty()).getDataType().equals((Object)DataType.ENUM) || !((prop = ref.getRefProperty()) instanceof OwnPropertyInfo)) continue;
            String metadataRef = ((OwnPropertyInfo)prop).getMetaDataRef();
            cmpItemInfo.setItemValue("20;" + metadataRef + ";;;END");
        }
    }

    public static String getDynTableColumn(Context ctx, String tableName) throws BOSException {
        IRowSet iRowSet = null;
        if (ctx == null) {
            ISQLExecutor iSQLExec = SQLExecutorFactory.getRemoteInstance((String)("SELECT top 1 * FROM " + tableName));
            iRowSet = iSQLExec.executeSQL();
        } else {
            iRowSet = DbUtil.executeQuery((Context)ctx, (String)("SELECT top 1 * FROM " + tableName));
        }
        ResultSetMetaData columnMeta = null;
        try {
            columnMeta = iRowSet.getMetaData();
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            return " * ";
        }
        return HRCmpItemUtils.getDynTableColumn(columnMeta);
    }

    public static String getDynTableColumn(ResultSetMetaData columnMeta) throws BOSException {
        if (columnMeta == null) {
            return " * ";
        }
        StringBuffer columnStr = new StringBuffer();
        try {
            int size = columnMeta.getColumnCount();
            for (int i = 1; i <= size; ++i) {
                if (i != 1) {
                    columnStr.append(",");
                }
                columnStr.append(columnMeta.getColumnName(i).toUpperCase());
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            return " * ";
        }
        return columnStr.toString();
    }

    public static FilterInfo getDynF7FilterInfo(int type) {
        String hroId = SysContext.getSysContext().getCurrentHRUnit().getId().toString();
        String sql = "SELECT FDynSolutionID FROM T_HR_CmpitemDynquery WHERE FHROrgUnitID='" + hroId + "' AND FType=" + type;
        FilterInfo dynF7FilterInfo = new FilterInfo();
        dynF7FilterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)sql, CompareType.INNER));
        return dynF7FilterInfo;
    }

    public static boolean isFixCmpItemDisabled(String hroId) throws BOSException, SQLException {
        boolean isDisabled = false;
        StringBuffer sql = new StringBuffer();
        sql.append("select ci.fnumber as CmpItemNumber from t_hr_cmpitem ci inner join t_hr_cmpitemcat cic on ci.fcmpitemcatalogid=cic.fid inner join t_org_hro h on cic.fhrorgunitid=h.fid  ");
        sql.append(" where ci.Ftype=10 and cic.fnumber='FSAL' and ci.fenable=3 and h.fid='");
        sql.append(hroId);
        sql.append("'");
        ISQLExecutor executor = SQLExecutorFactory.getRemoteInstance((String)sql.toString());
        IRowSet rs = executor.executeSQL();
        String number = null;
        while (rs.next()) {
            number = rs.getString("CmpItemNumber");
            if (HRCmpItemUtils.isExcludeFixedCmpItem(number)) continue;
            isDisabled = true;
            break;
        }
        return isDisabled;
    }
}

