/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.hr.compensation.CmpItemCollection;
import com.kingdee.eas.hr.compensation.CmpItemFactory;
import com.kingdee.eas.hr.compensation.CmpItemInfo;
import com.kingdee.eas.hr.compensation.FormulaCmpItemData;
import com.kingdee.eas.hr.compensation.ICmpItem;
import com.kingdee.eas.hr.compensation.util.HRCmpItemUtils;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class HRCommonQueryUtils {
    public static final String SEPERATEOFCOMMONQUERY = "~";

    public static int getAdminOrgLevelCount(AdminOrgUnitInfo info) throws BOSException {
        return HRCommonQueryUtils.getAdminOrgLevelCount(null, info);
    }

    public static int getAdminOrgLevelCount(Context ctx, AdminOrgUnitInfo info) throws BOSException {
        if (info == null) {
            return 0;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("longNumber", (Object)info.getLongNumber()));
        fi.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(info.getLongNumber() + "!%"), CompareType.LIKE));
        fi.setMaskString("(#0 or #1)");
        viewInfo.setFilter(fi);
        SorterItemInfo sortInfo = new SorterItemInfo("level");
        sortInfo.setSortType(SortType.ASCEND);
        viewInfo.getSorter().add(sortInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("level"));
        viewInfo.setSelector(sic);
        IAdminOrgUnit iAdmin = null;
        iAdmin = ctx == null ? AdminOrgUnitFactory.getRemoteInstance() : AdminOrgUnitFactory.getLocalInstance((Context)ctx);
        AdminOrgUnitCollection coll = iAdmin.getAdminOrgUnitCollection(viewInfo);
        if (coll != null) {
            int size = coll.size();
            if (size <= 1) {
                return 0;
            }
            if (size > 1) {
                return coll.get(size - 1).getLevel() - coll.get(0).getLevel();
            }
        }
        return 0;
    }

    public static int getAdminOrgLevelCountNoHR(AdminOrgUnitInfo info) throws Exception {
        return HRCommonQueryUtils.getAdminOrgLevelCount(null, info);
    }

    public static void initComBox(KDComboBox cboLevel, int level) {
        for (int i = 1; i <= level; ++i) {
            cboLevel.addItem((Object)i);
        }
        if (level >= 1 && cboLevel.getItemCount() > 1) {
            cboLevel.setSelectedIndex(0);
        }
    }

    public static String getSelectedItemIDS(List lstSelectItemData) {
        StringBuffer ids = new StringBuffer("");
        if (lstSelectItemData.size() < 1) {
            return ids.toString();
        }
        int size = lstSelectItemData.size();
        for (int i = 0; i < size; ++i) {
            if (lstSelectItemData.get(i) instanceof CmpItemInfo) {
                ids.append(((CmpItemInfo)lstSelectItemData.get(i)).getId().toString());
            } else if (lstSelectItemData.get(i) instanceof FormulaCmpItemData) {
                ids.append(((FormulaCmpItemData)lstSelectItemData.get(i)).getUuid().toString());
            }
            ids.append(SEPERATEOFCOMMONQUERY);
        }
        if (ids.length() > 1) {
            ids.deleteCharAt(ids.length() - 1);
        }
        return ids.toString();
    }

    public static List getSelectedItemList(String ids, boolean isDisplaySalPoint) throws Exception {
        ArrayList<CmpItemInfo> lstItem = new ArrayList<CmpItemInfo>();
        if (StringUtils.isEmpty((String)ids)) {
            return lstItem;
        }
        String[] items = ids.split(SEPERATEOFCOMMONQUERY);
        HashSet<String> setItemID = new HashSet<String>();
        int size = items.length;
        for (int i = 0; i < size; ++i) {
            setItemID.add(items[i]);
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("id", setItemID, CompareType.INCLUDE));
        if (!isDisplaySalPoint) {
            fi.getFilterItems().add(new FilterItemInfo("number", (Object)"FSAL000", CompareType.NOTEQUALS));
        }
        viewInfo.setFilter(fi);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("cmpItemCatalog.number"));
        viewInfo.setSelector(sic);
        CmpItemCollection colCmpItem = CmpItemFactory.getRemoteInstance().getCmpItemCollection(viewInfo);
        if (colCmpItem != null && colCmpItem.size() > 0) {
            int length = items.length;
            for (int j = 0; j < length; ++j) {
                int size2 = colCmpItem.size();
                for (int i = 0; i < size2; ++i) {
                    if (!colCmpItem.get(i).getId().toString().equals(items[j])) continue;
                    lstItem.add(colCmpItem.get(i));
                }
            }
        }
        return lstItem;
    }

    public static List getSelectedItemList(String ids) throws Exception {
        return HRCommonQueryUtils.getSelectedItemList(ids, true);
    }

    public static List getSelectedItemList(String ids, String splitStr) throws Exception {
        ArrayList<CmpItemInfo> lstItem = new ArrayList<CmpItemInfo>();
        if (ids.length() < 1) {
            return lstItem;
        }
        String[] items = ids.split(splitStr);
        HashSet<String> setItemID = new HashSet<String>();
        int size = items.length;
        for (int i = 0; i < size; ++i) {
            setItemID.add(items[i]);
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("id", setItemID, CompareType.INCLUDE));
        viewInfo.setFilter(fi);
        CmpItemCollection colCmpItem = CmpItemFactory.getRemoteInstance().getCmpItemCollection(viewInfo);
        if (colCmpItem != null && colCmpItem.size() > 0) {
            int length = items.length;
            for (int j = 0; j < length; ++j) {
                int size2 = colCmpItem.size();
                for (int i = 0; i < size2; ++i) {
                    if (!colCmpItem.get(i).getId().toString().equals(items[j])) continue;
                    lstItem.add(colCmpItem.get(i));
                }
            }
        }
        return lstItem;
    }

    public static void fillSelectItemList(List lst, KDList lstSelectItem, KDList lstAllItem) throws Exception {
        lstSelectItem.removeAllElements();
        if (lst == null || lst.size() <= 0) {
            return;
        }
        HashMap<CmpItemInfo, Integer> mapItem = new HashMap<CmpItemInfo, Integer>();
        CmpItemInfo infoTempSelect2 = null;
        CmpItemInfo infoTempAll = null;
        int size = lst.size();
        for (int i = 0; i < size; ++i) {
            infoTempSelect2 = (CmpItemInfo)lst.get(i);
            int n = lstAllItem.getElementCount();
            for (int m = 0; m < n; ++m) {
                infoTempAll = (CmpItemInfo)lstAllItem.getElement(m);
                if (!infoTempAll.getId().toString().equals(infoTempSelect2.getId().toString())) continue;
                mapItem.put(infoTempAll, m);
            }
            lstSelectItem.addElement(lst.get(i));
        }
        for (CmpItemInfo infoTempSelect2 : mapItem.keySet()) {
            lstAllItem.removeElement((Object)infoTempSelect2);
        }
        lstAllItem.setSelectedIndex(0);
    }

    public static void fillSelectItemNumberList(List lst, KDList lstSelectItem, KDList lstAllItem) throws Exception {
        lstSelectItem.removeAllElements();
        if (lst == null || lst.size() <= 0) {
            return;
        }
        HashMap<CmpItemInfo, Integer> mapItem = new HashMap<CmpItemInfo, Integer>();
        CmpItemInfo infoTempSelect2 = null;
        CmpItemInfo infoTempAll = null;
        int size = lst.size();
        for (int i = 0; i < size; ++i) {
            infoTempSelect2 = (CmpItemInfo)lst.get(i);
            int n = lstAllItem.getElementCount();
            for (int m = 0; m < n; ++m) {
                infoTempAll = (CmpItemInfo)lstAllItem.getElement(m);
                if (!infoTempAll.getNumber().equals(infoTempSelect2.getNumber())) continue;
                mapItem.put(infoTempAll, m);
            }
            lstSelectItem.addElement(lst.get(i));
        }
        for (CmpItemInfo infoTempSelect2 : mapItem.keySet()) {
            lstAllItem.removeElement((Object)infoTempSelect2);
        }
        lstAllItem.setSelectedIndex(0);
    }

    public static String getQueryWhereSqlByFilter(Context ctx, String queryName, EntityViewInfo entityViewInfo) throws BOSException {
        MetaDataPK metaDataPK = new MetaDataPK(queryName);
        IQueryExecutor exec = null;
        exec = ctx != null ? QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)metaDataPK) : QueryExecutorFactory.getRemoteInstance((IMetaDataPK)metaDataPK);
        exec.setObjectView(entityViewInfo);
        String sqlQuery = exec.getSQL();
        int iWhereIndex = sqlQuery.toLowerCase().lastIndexOf("where");
        if (iWhereIndex < 0) {
            return null;
        }
        int iOrderIndex = sqlQuery.toLowerCase().lastIndexOf("order");
        if (iOrderIndex < 0) {
            iOrderIndex = sqlQuery.length();
        }
        String sqlWhere = " (" + sqlQuery.substring(iWhereIndex + 5, iOrderIndex) + ")";
        return sqlWhere;
    }

    public static CmpItemCollection getPersonItems() throws BOSException, SQLException {
        return HRCommonQueryUtils.getPersonItems(null);
    }

    public static CmpItemCollection getPersonItems(Context ctx) throws BOSException, SQLException {
        String hrOrgUnitID = null;
        hrOrgUnitID = ctx == null ? HRSchemeUtils.getClientHROrgUnitInfo().getId().toString() : HRSchemeUtils.getServerHROrgUnitInfo(ctx).getId().toString();
        return HRCommonQueryUtils.getPersonItems(ctx, hrOrgUnitID);
    }

    public static CmpItemCollection getPersonItems(Context ctx, String hrOrgUnitID) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("cmpItemCatalog.number"));
        viewInfo.setSelector(selector);
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("cmpItemCatalog.number", (Object)"FPER"));
        fi.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)hrOrgUnitID));
        fi.getFilterItems().add(new FilterItemInfo("subject", (Object)10));
        ArrayList perNumList = null;
        try {
            perNumList = HRCmpItemUtils.getMappingPersonItems(ctx, 1, hrOrgUnitID);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (perNumList != null && perNumList.size() > 0) {
            HashSet set = new HashSet();
            set.addAll(perNumList);
            fi.getFilterItems().add(new FilterItemInfo("subject", (Object)20));
            fi.getFilterItems().add(new FilterItemInfo("number", set, CompareType.INCLUDE));
            fi.setMaskString(" #0 and #1 and (#2 or( #3 and #4))");
        } else {
            fi.setMaskString(" #0 and #1 and #2 ");
        }
        if (viewInfo.getSorter() == null) {
            viewInfo.setSorter(new SorterItemCollection());
        }
        viewInfo.getSorter().add(new SorterItemInfo("defaultOrder"));
        viewInfo.setFilter(fi);
        ICmpItem icmpItem = null;
        icmpItem = ctx == null ? CmpItemFactory.getRemoteInstance() : CmpItemFactory.getLocalInstance(ctx);
        return icmpItem.getCmpItemCollection(viewInfo);
    }

    public static EntityViewInfo getEntityViewInfo(List schemeIDs, boolean dataTypeFilter, int displaySAL000) {
        if (schemeIDs == null || schemeIDs.size() == 0) {
            return new EntityViewInfo();
        }
        HashSet set = new HashSet();
        set.addAll(schemeIDs);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("cmpScheme.id", set, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("cmpItem.number", (Object)"FPER%", CompareType.NOTLIKE));
        if (!dataTypeFilter) {
            filterInfo.setMaskString(" #0 and #1 ");
            if (displaySAL000 == 0) {
                filterInfo.getFilterItems().add(new FilterItemInfo("cmpItem.number", (Object)"FSAL000", CompareType.NOTEQUALS));
                filterInfo.setMaskString(" #0 and #1 and #2");
            }
        } else {
            HashSet<Integer> dataType = new HashSet<Integer>();
            dataType.add(40);
            dataType.add(50);
            dataType.add(60);
            filterInfo.getFilterItems().add(new FilterItemInfo("cmpItem.dataType", dataType, CompareType.INCLUDE));
            filterInfo.setMaskString(" #0 and #1 and #2 ");
            if (displaySAL000 == 0) {
                filterInfo.getFilterItems().add(new FilterItemInfo("cmpItem.number", (Object)"FSAL000", CompareType.NOTEQUALS));
                filterInfo.setMaskString(" #0 and #1 and #2 and #3");
            }
        }
        viewInfo.setFilter(filterInfo);
        return viewInfo;
    }
}

