/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.contract.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.AttachmentCollection;
import com.kingdee.eas.base.attachment.AttachmentFactory;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.BoAttchAssoCollection;
import com.kingdee.eas.base.attachment.BoAttchAssoFactory;
import com.kingdee.eas.base.attachment.BoAttchAssoInfo;
import com.kingdee.eas.base.attachment.IBoAttchAsso;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.affair.AffairBizException;
import com.kingdee.eas.hr.base.HRBillBaseEntryInfo;
import com.kingdee.eas.hr.base.HRBillBaseInfo;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.hr.base.IHRBillBase;
import com.kingdee.eas.hr.base.app.util.MetaDataServerUtil;
import com.kingdee.eas.hr.contract.ContractBillBaseInfo;
import com.kingdee.eas.hr.contract.ContractException;
import com.kingdee.eas.hr.contract.HRContractInfoCollection;
import com.kingdee.eas.hr.contract.HRContractInfoFactory;
import com.kingdee.eas.hr.contract.HRContractInfoInfo;
import com.kingdee.eas.hr.contract.IHRContractInfo;
import com.kingdee.eas.hr.contract.app.AbstractContractBillBaseControllerBean;
import com.kingdee.eas.hr.contract.util.ContractUtils;
import com.kingdee.eas.hr.contract.util.SHRContractUploadAttachmentUtils;
import com.kingdee.eas.hr.emp.ContractTempletFactory;
import com.kingdee.eas.hr.emp.ContractTempletInfo;
import com.kingdee.eas.hr.emp.ContractTypeInfo;
import com.kingdee.eas.hr.emp.EmployeeContractInfo;
import com.kingdee.eas.hr.emp.EmployeeContractNewStateEnum;
import com.kingdee.eas.hr.emp.EmployeeContractState;
import com.kingdee.eas.hr.emp.EmployeeException;
import com.kingdee.eas.hr.emp.IContractTemplet;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.attachment.AttachmentState;
import com.kingdee.shr.attachment.AttachmentTypeEnum;
import com.kingdee.shr.attachment.ISHRAttachmentExt;
import com.kingdee.shr.attachment.SHRAttachmentExtCollection;
import com.kingdee.shr.attachment.SHRAttachmentExtFactory;
import com.kingdee.shr.attachment.SHRAttachmentExtInfo;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class ContractBillBaseControllerBean
extends AbstractContractBillBaseControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.contract.app.ContractBillBaseControllerBean");
    protected static final String CONTRACT_ENTITYNAME = "com.kingdee.eas.hr.emp.app.EmployeeContract";
    protected static final String OTHER_CONTRACT_ENTITYNAME = "com.kingdee.eas.hr.emp.app.EmployeeOtherContract";

    protected void addNewHrContractInfo(Context ctx, ContractBillBaseInfo billInfo, IObjectPK billId) throws BOSException, EASBizException {
        IObjectCollection entrys = (IObjectCollection)billInfo.get(this.getEntryField());
        IHRContractInfo iHRContractInfo = HRContractInfoFactory.getLocalInstance(ctx);
        int size = entrys.size();
        for (int i = 0; i < size; ++i) {
            HRContractInfoInfo contractInfo = new HRContractInfoInfo();
            HRBillBaseEntryInfo entryInfo = (HRBillBaseEntryInfo)entrys.getObject(i);
            ContractTempletInfo templateInfo = (ContractTempletInfo)entryInfo.get("contractTemplet");
            if (!ContractUtils.isLaborContract(ctx, templateInfo.getId().toString())) continue;
            this.setHRContractInfoInfo(ctx, billInfo, billId, (CoreBaseInfo)entryInfo, contractInfo);
            iHRContractInfo.addnew(contractInfo);
        }
    }

    protected void updateHrContractInfo(Context ctx, ContractBillBaseInfo billInfo, IObjectPK billID) throws BOSException, EASBizException {
        IObjectCollection entrys = (IObjectCollection)billInfo.get(this.getEntryField());
        IHRContractInfo iHRContractInfo = HRContractInfoFactory.getLocalInstance(ctx);
        int size = entrys.size();
        for (int i = 0; i < size; ++i) {
            HRContractInfoInfo contractInfo;
            HRBillBaseEntryInfo entryInfo = (HRBillBaseEntryInfo)entrys.getObject(i);
            ContractTempletInfo templateInfo = (ContractTempletInfo)entryInfo.get("contractTemplet");
            if (!ContractUtils.isLaborContract(ctx, templateInfo.getId().toString())) continue;
            String oql = "select * where billID='" + billID + "' and employee.id='" + ((PersonInfo)entryInfo.get("person")).getId() + "'";
            HRContractInfoCollection hrContractInfoCollection = iHRContractInfo.getHRContractInfoCollection(oql);
            if (hrContractInfoCollection != null && hrContractInfoCollection.size() > 0) {
                contractInfo = hrContractInfoCollection.get(0);
                this.setHRContractInfoInfo(ctx, billInfo, billID, (CoreBaseInfo)entryInfo, contractInfo);
                iHRContractInfo.update((IObjectPK)new ObjectUuidPK(contractInfo.getId().toString()), contractInfo);
                continue;
            }
            contractInfo = new HRContractInfoInfo();
            if (!ContractUtils.isLaborContract(ctx, templateInfo.getId().toString())) continue;
            this.setHRContractInfoInfo(ctx, billInfo, billID, (CoreBaseInfo)entryInfo, contractInfo);
            iHRContractInfo.addnew(contractInfo);
        }
    }

    protected void recoveryHrContractInfo(Context ctx, ContractBillBaseInfo billInfo, IObjectPK billID) throws BOSException, EASBizException {
        IObjectCollection entrys = (IObjectCollection)billInfo.get(this.getEntryField());
        IHRContractInfo iHRContractInfo = HRContractInfoFactory.getLocalInstance(ctx);
        int size = entrys.size();
        for (int i = 0; i < size; ++i) {
            HRContractInfoInfo contractInfo = new HRContractInfoInfo();
            HRBillBaseEntryInfo entryInfo = (HRBillBaseEntryInfo)entrys.getObject(i);
            ContractTempletInfo templateInfo = (ContractTempletInfo)entryInfo.get("contractTemplet");
            if (!ContractUtils.isLaborContract(ctx, templateInfo.getId().toString())) continue;
            String oql = "select * where billID='" + billID + "' and employee.id='" + ((PersonInfo)entryInfo.get("person")).getId() + "'";
            HRContractInfoInfo hrContractInfoInfo = iHRContractInfo.getHRContractInfoInfo(oql);
            iHRContractInfo.delete((IObjectPK)new ObjectUuidPK(hrContractInfoInfo.getId().toString()));
            this.setHRContractInfoInfo(ctx, billInfo, billID, (CoreBaseInfo)entryInfo, contractInfo);
            iHRContractInfo.addnew((IObjectPK)new ObjectUuidPK(hrContractInfoInfo.getId().toString()), contractInfo);
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        super._delete(ctx, pk);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("billID", (Object)pk.toString()));
        HRContractInfoFactory.getLocalInstance(ctx).delete(filter);
    }

    protected void _setAudited(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        super._setAudited(ctx, billID);
        ContractUtils.syncBillStateToHRContractInfo(ctx, billID, HRBillStateEnum.AUDITED);
    }

    protected void _setAuditEnd(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        super._setAuditEnd(ctx, billID);
        ContractUtils.syncBillStateToHRContractInfo(ctx, billID, HRBillStateEnum.AUDITEND);
    }

    protected void _setAuditing(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        super._setAuditing(ctx, billID);
        ContractUtils.syncBillStateToHRContractInfo(ctx, billID, HRBillStateEnum.AUDITING);
    }

    protected void _setSubmited(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        super._setSubmited(ctx, billID);
        ContractUtils.syncBillStateToHRContractInfo(ctx, billID, HRBillStateEnum.SUBMITED);
    }

    public void _setSaved(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        super._setSaved(ctx, billID);
        ContractUtils.syncBillStateToHRContractInfo(ctx, billID, HRBillStateEnum.SAVED);
    }

    protected void syncContractStateToHRContractInfo(Context ctx, BOSUuid billID, HRContractInfoInfo info) throws BOSException, EASBizException {
        IHRContractInfo iHRContractInfo = HRContractInfoFactory.getLocalInstance(ctx);
        String oql = "select * where billID='" + billID + "'";
        HRContractInfoCollection coll = iHRContractInfo.getHRContractInfoCollection(oql);
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            iHRContractInfo.update((IObjectPK)new ObjectUuidPK(info.getId().toString()), info);
        }
    }

    protected void setHRContractInfoInfo(Context ctx, ContractBillBaseInfo billInfo, IObjectPK billId, CoreBaseInfo entryInfo, HRContractInfoInfo contractInfo) throws EASBizException, BOSException {
        ContractUtils.setHRContractInfoInfo(ctx, entryInfo, contractInfo);
        if (billInfo.getApproveType().getValue() == 1) {
            contractInfo.put("isWorkflow", true);
        } else {
            contractInfo.put("isWorkflow", false);
        }
        contractInfo.put("toUnit", billInfo.get("toUnit"));
        contractInfo.put("tounit_l2", billInfo.get("toUnit"));
        contractInfo.put("delegatePerson", billInfo.get("delegatepersontext"));
        contractInfo.put("employee", entryInfo.get("person"));
        contractInfo.put("entryID", entryInfo.getId().toString());
        contractInfo.put("billID", BOSUuid.read((String)billId.toString()));
        contractInfo.put("billBOSType", billInfo.getBOSType().toString());
        contractInfo.put("billState", billInfo.getBillState());
        contractInfo.put("entryBizDate", entryInfo.get("bizDate"));
        contractInfo.put("state", EmployeeContractState.NEW);
        contractInfo.put("newState", EmployeeContractNewStateEnum.ADDED);
        contractInfo.put("recordDate", entryInfo.get("signDate"));
        contractInfo.put("effectDate", entryInfo.get("bizDate"));
        if (entryInfo.get("contractLimit") != null) {
            contractInfo.put("contractLimitAuto", entryInfo.get("contractLimit"));
        }
    }

    protected void setNumberFromCodingRule(Context ctx, HRBillBaseInfo model) throws BOSException, EASBizException {
        String orgID = null;
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        if (model.getHrOrgUnit() != null) {
            orgID = model.getHrOrgUnit().getId().toString();
        }
        String number = null;
        if (orgID != null && iCodingRuleManager.isExist((IObjectValue)model, orgID)) {
            number = iCodingRuleManager.getNumber((IObjectValue)model, orgID);
        }
        if (!StringUtils.isEmpty(number)) {
            model.setNumber(number);
        }
    }

    protected void _check(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        HRBillBaseInfo billInfo = (HRBillBaseInfo)model;
        if (billInfo == null) {
            return;
        }
        IObjectCollection entrys = (IObjectCollection)billInfo.get(this.getEntryField());
        IContractTemplet iContractTemplet = ContractTempletFactory.getLocalInstance((Context)ctx);
        int size = entrys.size();
        for (int i = 0; i < size; ++i) {
            HRBillBaseEntryInfo entryInfo = (HRBillBaseEntryInfo)entrys.getObject(0);
            ContractTypeInfo typeInfo = (ContractTypeInfo)entryInfo.get("contractType");
            ContractTempletInfo templateInfo = (ContractTempletInfo)entryInfo.get("contractTemplet");
            StringBuffer oql = new StringBuffer();
            oql.append("select id where contractType.id='");
            oql.append(typeInfo.getId()).append("' and id='").append(templateInfo.getId()).append("'");
            if (iContractTemplet.exists(oql.toString())) continue;
            throw new EmployeeException(EmployeeException.CONTRACTTYPENOTMATCHWITHTEMPLATE);
        }
        super._check(ctx, pk, model);
    }

    protected void _abortBizBill(Context ctx, String billId) throws BOSException, EASBizException {
        if (!StringUtils.isEmpty((String)billId)) {
            IHRBillBase iHRBillBase = (IHRBillBase)MetaDataServerUtil.getBizInterface((Context)ctx, (BOSObjectType)BOSUuid.read((String)billId).getType());
            HRBillBaseInfo billInfo = iHRBillBase.getHRBillBaseInfo((IObjectPK)new ObjectUuidPK(billId));
            HRBillStateEnum billState = billInfo.getBillState();
            if (HRBillStateEnum.SUBMITED.equals((Object)billState) || HRBillStateEnum.AUDITING.equals((Object)billState)) {
                iHRBillBase.setSaved(BOSUuid.read((String)billId));
                this.abortWorkFlow(ctx, billId);
                this.clearProcInstBizInfo(ctx, billInfo);
                SHRContractUploadAttachmentUtils.deleteContractAttachmentReverse(ctx, BOSUuid.read((String)billId));
            } else {
                throw new AffairBizException(AffairBizException.BILLSTATECANTSUPPORT);
            }
        }
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        IObjectCollection entries = (IObjectCollection)model.get("entrys");
        for (int i = 0; i < entries.size(); ++i) {
            this.setBillUseDefault(ctx, model, entries.getObject(i));
        }
        super._addnew(ctx, pk, model);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectCollection entries = (IObjectCollection)model.get("entrys");
        if (entries.size() == 0) {
            throw new ContractException(ContractException.NO_ENTRIES);
        }
        for (int i = 0; i < entries.size(); ++i) {
            this.setBillUseDefault(ctx, model, entries.getObject(i));
        }
        return super._addnew(ctx, model);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        IObjectCollection entries = (IObjectCollection)model.get("entrys");
        if (entries.size() == 0) {
            throw new ContractException(ContractException.NO_ENTRIES);
        }
        for (int i = 0; i < entries.size(); ++i) {
            this.setBillUseDefault(ctx, model, entries.getObject(i));
        }
        super._update(ctx, pk, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK pk = super._submit(ctx, model);
        IObjectCollection entries = (IObjectCollection)model.get(this.getEntryField());
        HRBillBaseEntryInfo entry = null;
        if (entries.size() == 1) {
            for (int i = 0; i < entries.size(); ++i) {
                entry = (HRBillBaseEntryInfo)entries.getObject(i);
                SHRContractUploadAttachmentUtils.saveContractAttachmentReverse(ctx, entry.getId().toString());
            }
        }
        return pk;
    }

    protected void _submit(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        IObjectCollection entries = (IObjectCollection)model.get(this.getEntryField());
        if (entries.size() == 0) {
            throw new ContractException(ContractException.NO_ENTRIES);
        }
        super._submit(ctx, pk, model);
    }

    protected void setBillUseDefault(Context ctx, IObjectValue model, IObjectValue entry) throws BOSException, EASBizException {
        ContractBillBaseInfo billInfo = (ContractBillBaseInfo)model;
        boolean useDefault = true;
        PersonInfo personInfo = (PersonInfo)entry.get("person");
        if (personInfo != null && personInfo.getId() != null) {
            String pId = personInfo.getId().toString();
            try {
                StringBuffer sql = new StringBuffer();
                sql.append("select FUseDefault from T_HR_PersonBURelation where FState = 1");
                sql.append(" and FBizManageTypeID in ('").append("SGuJm3nXW0GshQfKRXenomWJ1dE=").append("')");
                sql.append(" and FPersonID in ('").append(pId).append("')");
                IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                while (executeQuery.next()) {
                    if (executeQuery.getInt("FUseDefault") != 0) continue;
                    useDefault = false;
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        billInfo.setUseDefault(useDefault);
    }

    protected void addAttachmentForContract(Context ctx, EmployeeContractInfo employeeContract, String billId) throws BOSException, EASBizException {
        String strLan = ctx.getLocale().toString();
        String sql = "select FAttachmentID, FAssoType_" + strLan + " from T_BAS_BoAttchAsso where FBoID = '" + billId + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        StringBuffer attachmentIdStr = new StringBuffer();
        String attachmentId = null;
        HashMap<String, String> attachmentMap = new HashMap<String, String>();
        try {
            while (rs.next()) {
                attachmentIdStr.append("'");
                attachmentIdStr.append(rs.getString("FAttachmentID"));
                attachmentIdStr.append("',");
                attachmentMap.put(rs.getString("FAttachmentID"), rs.getString("FAssoType_" + strLan));
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        if (attachmentIdStr.length() > 0) {
            attachmentId = attachmentIdStr.toString().substring(0, attachmentIdStr.length() - 1);
        }
        AttachmentCollection aCol = AttachmentFactory.getLocalInstance((Context)ctx).getAttachmentCollection("where id in (" + attachmentId + ")");
        AttachmentInfo aInfo = null;
        BoAttchAssoInfo baaInfo = null;
        IBoAttchAsso bAAF = BoAttchAssoFactory.getLocalInstance((Context)ctx);
        int size = aCol.size();
        for (int i = 0; i < size; ++i) {
            aInfo = aCol.get(i);
            baaInfo = new BoAttchAssoInfo();
            baaInfo.setAttachment(aInfo);
            baaInfo.setAssoType(attachmentMap.get(aInfo.getId().toString()).toString());
            baaInfo.setBoID(employeeContract.getId().toString());
            baaInfo.setAssoBusObjType(employeeContract.getBOSType().toString());
            bAAF.addnew(baaInfo);
        }
    }

    protected void reverseEmployeeContractAttachment(Context ctx, EmployeeContractInfo employeeContract, HRBillBaseEntryInfo entry) throws EASBizException, BOSException {
        IBoAttchAsso boAttchAsso;
        BoAttchAssoCollection boColl;
        List<AttachmentInfo> list;
        String entryField;
        HRBillBaseInfo hRBillBaseInfo = (HRBillBaseInfo)entry.get(this.getBillField());
        String billID = hRBillBaseInfo.getId().toString();
        if (StringUtils.isEmpty((String)billID)) {
            return;
        }
        String boID = "";
        String bosType = BOSUuid.read((String)billID).getType().toString();
        String enrtryID = entry.getId().toString();
        if ((bosType.equals("A7021A44") || bosType.equals("502B7D81") || bosType.equals("2A2632A9") || bosType.equals("056FBF2E")) && !SHRContractUploadAttachmentUtils.IsContractAttachmentReverse(ctx, enrtryID).booleanValue()) {
            return;
        }
        HRBillBaseInfo model = this.getHRBillBaseInfo(ctx, (IObjectPK)new ObjectUuidPK(billID));
        IObjectCollection entries = (IObjectCollection)model.get(entryField = this.getEntryField());
        if (entries.size() > 1) {
            return;
        }
        HRBillBaseEntryInfo hRBillBaseEntryInfo = (HRBillBaseEntryInfo)entries.getObject(0);
        Date bizDate = this.getEffectDate(hRBillBaseEntryInfo);
        if (bizDate != null) {
            bizDate = DateTimeUtils.truncateDate((Date)bizDate);
        }
        ISHRAttachmentExt attachmentExt = SHRAttachmentExtFactory.getLocalInstance((Context)ctx);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("boID", (Object)billID));
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filterInfo);
        entityViewInfo.setSelector(SHRContractUploadAttachmentUtils.getSHRAttachmentExtSelectorItemCollection());
        SHRAttachmentExtCollection collection = attachmentExt.getSHRAttachmentExtCollection(entityViewInfo);
        String userId = "";
        if (collection.size() > 0) {
            for (int i = 0; i < collection.size(); ++i) {
                SHRAttachmentExtInfo shrAttachmentExtInfo = collection.get(i);
                String bunding = shrAttachmentExtInfo.getBunding();
                String[] split = bunding.split("#");
                userId = split[0];
                SHRAttachmentExtInfo reverseAttachmentExtInfo = new SHRAttachmentExtInfo();
                AttachmentInfo attachment = shrAttachmentExtInfo.getAttachment();
                reverseAttachmentExtInfo.setAttachment(attachment);
                reverseAttachmentExtInfo.setPropertyName(shrAttachmentExtInfo.getPropertyName());
                reverseAttachmentExtInfo.setType(shrAttachmentExtInfo.getType());
                reverseAttachmentExtInfo.setState(AttachmentState.UNSAVE);
                reverseAttachmentExtInfo.setBunding(userId + "#" + SHRContractUploadAttachmentUtils.getReverseUipk(ctx, bosType));
                reverseAttachmentExtInfo.setName(shrAttachmentExtInfo.getName());
                reverseAttachmentExtInfo.setNumber(shrAttachmentExtInfo.getNumber());
                reverseAttachmentExtInfo.setDescription(shrAttachmentExtInfo.getDescription());
                reverseAttachmentExtInfo.setSimpleName(shrAttachmentExtInfo.getSimpleName());
                attachmentExt.save((CoreBaseInfo)reverseAttachmentExtInfo);
                boID = employeeContract.getId().toString();
                attachmentExt.updateAffterSaveForm(boID, userId + "#" + SHRContractUploadAttachmentUtils.getReverseUipk(ctx, bosType));
            }
        }
        if (!(list = this.getNoPropertyNameAttch(collection, boColl = this.getBoAttchAssoCol(boAttchAsso = BoAttchAssoFactory.getLocalInstance((Context)ctx), billID))).isEmpty()) {
            for (AttachmentInfo ai : list) {
                SHRAttachmentExtInfo reverseAttachmentExtInfo = new SHRAttachmentExtInfo();
                reverseAttachmentExtInfo.setAttachment(ai);
                if (ai.getCreator() != null && ai.getCreator().getId() != null) {
                    userId = ai.getCreator().getId().toString();
                }
                reverseAttachmentExtInfo.setPropertyName("null0");
                reverseAttachmentExtInfo.setType(AttachmentTypeEnum.FORM);
                reverseAttachmentExtInfo.setState(AttachmentState.UNSAVE);
                reverseAttachmentExtInfo.setBunding(userId + "#" + SHRContractUploadAttachmentUtils.getReverseUipk(ctx, bosType));
                reverseAttachmentExtInfo.setName(ai.getName(LocaleUtils.locale_l1) + "." + ai.getSimpleName(), LocaleUtils.locale_l1);
                reverseAttachmentExtInfo.setName(ai.getName(LocaleUtils.locale_l2) + "." + ai.getSimpleName(), LocaleUtils.locale_l2);
                reverseAttachmentExtInfo.setName(ai.getName(LocaleUtils.locale_l3) + "." + ai.getSimpleName(), LocaleUtils.locale_l3);
                reverseAttachmentExtInfo.setDescription(ai.getDescription());
                reverseAttachmentExtInfo.setSimpleName(ai.getSimpleName());
                attachmentExt.save((CoreBaseInfo)reverseAttachmentExtInfo);
                boID = employeeContract.getId().toString();
                attachmentExt.updateAffterSaveForm(boID, userId + "#" + SHRContractUploadAttachmentUtils.getReverseUipk(ctx, bosType));
            }
        }
    }

    protected boolean isContractExcludeField(String key) {
        return key.equals("id") || key.equals("person") || key.equals("contractNo");
    }

    protected void _untiCheckBizBill(Context ctx, String billId) throws BOSException, EASBizException {
        SHRContractUploadAttachmentUtils.deleteContractAttachmentReverse(ctx, BOSUuid.read((String)billId));
        SHRContractUploadAttachmentUtils.deleteContractAttachment(ctx, BOSUuid.read((String)billId));
        super._untiCheckBizBill(ctx, billId);
    }

    public BoAttchAssoCollection getBoAttchAssoCol(IBoAttchAsso boAttchAsso, String boid) throws BOSException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("boid", (Object)boid));
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filterInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("attachment.size"));
        sic.add(new SelectorItemInfo("attachment.id"));
        sic.add(new SelectorItemInfo("attachment.name"));
        sic.add(new SelectorItemInfo("attachment.simplename"));
        sic.add(new SelectorItemInfo("attachment.description"));
        sic.add(new SelectorItemInfo("attachment.creator.name"));
        sic.add(new SelectorItemInfo("attachment.createTime"));
        entityViewInfo.setSelector(sic);
        return boAttchAsso.getBoAttchAssoCollection(entityViewInfo);
    }

    public List<AttachmentInfo> getNoPropertyNameAttch(SHRAttachmentExtCollection extColl, BoAttchAssoCollection boColl) {
        ArrayList<AttachmentInfo> list = new ArrayList<AttachmentInfo>();
        ArrayList<String> attchIds = new ArrayList<String>();
        if (extColl.size() == boColl.size()) {
            return list;
        }
        if (extColl.size() > 0) {
            for (int j = 0; j < extColl.size(); ++j) {
                AttachmentInfo attj = extColl.get(j).getAttachment();
                if (attj == null || attj.getId() == null) continue;
                attchIds.add(attj.getId().toString());
            }
        }
        if (boColl.size() > 0) {
            for (int i = 0; i < boColl.size(); ++i) {
                AttachmentInfo atti = boColl.get(i).getAttachment();
                if (atti == null || atti.getId() == null || attchIds.contains(atti.getId().toString())) continue;
                list.add(atti);
            }
        }
        return list;
    }
}

