/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.org.client.f7.AdminF7;
import com.kingdee.eas.framework.report.util.RptConditionManager;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.hr.emp.client.AbstractBIEmployeeStructureFilterUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class BIEmployeeStructureFilterUI
extends AbstractBIEmployeeStructureFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(BIEmployeeStructureFilterUI.class);

    public BIEmployeeStructureFilterUI() throws Exception {
        this.init();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initTableEditor();
    }

    private void init() throws Exception {
        this.prmtAdminUnit.setSelector((KDPromptSelector)new AdminF7((IUIObject)this));
        this.bgDimension.add((AbstractButton)this.rbAge);
        this.bgDimension.add((AbstractButton)this.rbCompanyYears);
        this.bgDimension.add((AbstractButton)this.rbEmpClassify);
        this.bgDimension.add((AbstractButton)this.rbGroupYears);
        this.bgDimension.add((AbstractButton)this.rbJobGrade);
        this.bgDimension.add((AbstractButton)this.rbPosition);
        this.bgDimension.add((AbstractButton)this.rbPositionType);
        this.bgDimension.add((AbstractButton)this.rbSex);
        this.bgDimension.add((AbstractButton)this.rbTeach);
        this.bgDimension.add((AbstractButton)this.rbTechnical);
        this.bgDimension.add((AbstractButton)this.rbTechType);
        this.bgDimension.add((AbstractButton)this.rbWed);
        this.bgDimension.add((AbstractButton)this.rbEmployType);
        this.bgDimension.add((AbstractButton)this.rbLayerType);
        this.bgChoose.add((AbstractButton)this.rbDefault);
        this.bgChoose.add((AbstractButton)this.rbDefine);
        this.btnInsertRow.setEnabled(true);
        this.btnRemoveRow.setEnabled(true);
        this.btnInsertRow.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnInsertRow.setText(null);
        this.btnRemoveRow.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnRemoveRow.setText(null);
        this.tblTime.getSelectManager().setSelectMode(1);
        TimeShowChangeAction action = new TimeShowChangeAction();
        this.rbAge.addActionListener((ActionListener)action);
        this.rbCompanyYears.addActionListener((ActionListener)action);
        this.rbGroupYears.addActionListener((ActionListener)action);
        this.rbEmpClassify.addActionListener((ActionListener)action);
        this.rbJobGrade.addActionListener((ActionListener)action);
        this.rbPosition.addActionListener((ActionListener)action);
        this.rbPositionType.addActionListener((ActionListener)action);
        this.rbSex.addActionListener((ActionListener)action);
        this.rbTeach.addActionListener((ActionListener)action);
        this.rbTechnical.addActionListener((ActionListener)action);
        this.rbTechType.addActionListener((ActionListener)action);
        this.rbWed.addActionListener((ActionListener)action);
        this.rbDefault.addActionListener((ActionListener)action);
        this.rbDefine.addActionListener((ActionListener)action);
        this.rbEmployType.addActionListener((ActionListener)action);
        this.rbLayerType.addActionListener((ActionListener)action);
    }

    private void setTimeShowState() {
        this.btnInsertRow.setEnabled(true);
        this.btnRemoveRow.setEnabled(true);
        this.tblTime.setEditable(true);
        this.tblTime.checkParsed();
        this.rbDefault.setVisible(this.rbAge.isSelected());
        this.rbDefine.setVisible(this.rbAge.isSelected());
        if (this.rbAge.isSelected()) {
            this.tblTime.getHeadRow(0).getCell(0).setValue((Object)EASResource.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"174_BIEmployeeStructureFilterUI"));
            if (this.rbDefine.isSelected()) {
                return;
            }
        }
        if (this.rbCompanyYears.isSelected()) {
            this.tblTime.getHeadRow(0).getCell(0).setValue((Object)EASResource.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"175_BIEmployeeStructureFilterUI"));
            return;
        }
        if (this.rbGroupYears.isSelected()) {
            this.tblTime.getHeadRow(0).getCell(0).setValue((Object)EASResource.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"176_BIEmployeeStructureFilterUI"));
            return;
        }
        this.tblTime.setEditable(false);
        this.btnInsertRow.setEnabled(false);
        this.btnRemoveRow.setEnabled(false);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public boolean verify() {
        if (this.prmtAdminUnit.getData() == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"177_BIEmployeeStructureFilterUI"));
            return false;
        }
        if (this.rbAge.isSelected() && this.rbDefine.isSelected() || this.rbCompanyYears.isSelected() || this.rbGroupYears.isSelected()) {
            return this.verifyTimeData();
        }
        return true;
    }

    private boolean verifyTimeData() {
        Integer from = null;
        Integer to = null;
        Integer preTo = null;
        int indexFrom = this.tblTime.getColumnIndex("from");
        int indexTo = this.tblTime.getColumnIndex("to");
        IRow row = null;
        int size = this.tblTime.getRowCount();
        if (size <= 0) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"178_BIEmployeeStructureFilterUI"));
            return false;
        }
        for (int i = 0; i < size; ++i) {
            row = this.tblTime.getRow(i);
            from = (Integer)row.getCell("from").getValue();
            to = (Integer)row.getCell("to").getValue();
            if (from == null) {
                this.tblTime.getEditManager().editCellAt(i, indexFrom);
                MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"179_BIEmployeeStructureFilterUI"));
                return false;
            }
            if (to == null) {
                this.tblTime.getEditManager().editCellAt(i, indexTo);
                MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"180_BIEmployeeStructureFilterUI"));
                return false;
            }
            if (from >= to) {
                this.tblTime.getEditManager().editCellAt(i, indexFrom);
                MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"181_BIEmployeeStructureFilterUI"));
                return false;
            }
            if (preTo != null && preTo > from) {
                this.tblTime.getEditManager().editCellAt(i, indexFrom);
                MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"182_BIEmployeeStructureFilterUI"));
                return false;
            }
            preTo = to;
        }
        return true;
    }

    private void initTableEditor() {
        this.tblTime.checkParsed();
        if (this.tblTime.getColumnCount() > 0) {
            KDFormattedTextField integerField = new KDFormattedTextField(0);
            integerField.setHorizontalAlignment(4);
            integerField.putClientProperty((Object)"OriginValue", (Object)Boolean.TRUE);
            KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor((JTextField)integerField);
            this.tblTime.getColumn("from").setEditor((ICellEditor)cellEditor);
            this.tblTime.getColumn("to").setEditor((ICellEditor)cellEditor);
        }
    }

    private String getTimeSegment() {
        StringBuffer result = new StringBuffer();
        int cRow = this.tblTime.getRowCount();
        for (int i = 0; i < cRow; ++i) {
            if (i != 0) {
                result.append(";");
            }
            int cColumn = this.tblTime.getColumnCount();
            for (int j = 0; j < cColumn; ++j) {
                if (j != 0) {
                    result.append("-");
                }
                result.append(this.tblTime.getCell(i, j).getValue().toString());
            }
        }
        return result.toString();
    }

    public void onInit(RptParams arg0) throws Exception {
    }

    public RptParams getCustomCondition() {
        RptConditionManager rcm = new RptConditionManager();
        rcm.recordAllStatus((Container)((Object)this));
        RptParams params = rcm.toRptParams();
        if (this.rbAge.isSelected()) {
            params.setString("choosed", "Age");
            if (this.rbDefault.isSelected()) {
                params.setBoolean("isUseDefaultTimeSeg", true);
            }
        }
        if (this.rbCompanyYears.isSelected()) {
            params.setString("choosed", "CompanyYears");
        }
        if (this.rbEmpClassify.isSelected()) {
            params.setString("choosed", "EmpClassify");
        }
        if (this.rbGroupYears.isSelected()) {
            params.setString("choosed", "GroupYears");
        }
        if (this.rbJobGrade.isSelected()) {
            params.setString("choosed", "JobGrade");
        }
        if (this.rbPosition.isSelected()) {
            params.setString("choosed", "Job");
        }
        if (this.rbPositionType.isSelected()) {
            params.setString("choosed", "JobCategory");
        }
        if (this.rbSex.isSelected()) {
            params.setString("choosed", "Sex");
        }
        if (this.rbTeach.isSelected()) {
            params.setString("choosed", "Teach");
        }
        if (this.rbTechnical.isSelected()) {
            params.setString("choosed", "Technical");
        }
        if (this.rbTechType.isSelected()) {
            params.setString("choosed", "TechType");
        }
        if (this.rbWed.isSelected()) {
            params.setString("choosed", "Wed");
        }
        if (this.rbAge.isSelected() && this.rbDefine.isSelected() || this.rbCompanyYears.isSelected() || this.rbGroupYears.isSelected()) {
            params.setString("time", this.getTimeSegment());
        }
        return params;
    }

    public void setCustomCondition(RptParams params) {
        RptConditionManager m = new RptConditionManager(params);
        m.restoreAllStatus((Container)((Object)this));
        this.setTimeShowState();
    }

    public void clear() {
        this.prmtAdminUnit.setData(null);
        this.rbPosition.setSelected(true);
        this.rbDefault.setSelected(true);
        this.tblTime.removeRows();
        this.setTimeShowState();
    }

    @Override
    public void actionDeleteRow_actionPerformed(ActionEvent e) throws Exception {
        int index = KDTableUtil.getSelectedRow((KDTable)this.tblTime);
        this.tblTime.removeRow(index);
    }

    @Override
    public void actionInsertRow_actionPerformed(ActionEvent e) throws Exception {
        int index = KDTableUtil.getSelectedRow((KDTable)this.tblTime);
        IRow row = null;
        IRow preRow = null;
        IRow nextRow = null;
        Object value = null;
        int currentIndex = -1;
        row = index < 0 ? this.tblTime.addRow() : this.tblTime.addRow(index + 1);
        currentIndex = row.getRowIndex();
        preRow = this.tblTime.getRow(currentIndex - 1);
        nextRow = this.tblTime.getRow(currentIndex + 1);
        if (preRow != null && (value = preRow.getCell("to").getValue()) != null && value instanceof Integer) {
            row.getCell("from").setValue((Object)((Integer)value));
        }
        if (nextRow != null) {
            value = nextRow.getCell("from").getValue();
            if (value != null && value instanceof Integer) {
                int tempTo = (Integer)value;
                if (row.getCell("from").getValue() != null && tempTo <= (Integer)row.getCell("from").getValue()) {
                    row.getCell("to").setValue((Object)((Integer)row.getCell("from").getValue() + 1));
                } else {
                    if (row.getCell("from").getValue() == null) {
                        row.getCell("from").setValue((Object)(tempTo - 1));
                    }
                    row.getCell("to").setValue((Object)tempTo);
                }
            } else if (row.getCell("from").getValue() != null) {
                row.getCell("to").setValue((Object)((Integer)row.getCell("from").getValue() + 1));
            }
        }
    }

    private String[][] getTimeFromTo(String param, String sep1, String sep2) {
        String[][] result = null;
        if (StringUtils.isEmpty((String)param)) {
            return result;
        }
        String[] parse1 = StringUtils.split((String)param, (String)sep1);
        result = new String[parse1.length][];
        for (int i = 0; i < parse1.length; ++i) {
            result[i] = StringUtils.split((String)parse1[i], (String)sep2);
        }
        return result;
    }

    private class TimeShowChangeAction
    implements ActionListener {
        private TimeShowChangeAction() {
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            BIEmployeeStructureFilterUI.this.setTimeShowState();
        }
    }
}

