/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.FilterInfoProducerFactory;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.core.hr.util.HRParamUtil;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.uiframe.client.SystemEntry;
import com.kingdee.eas.base.uiframe.client.ui.IMainUIObject;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.AdminF7;
import com.kingdee.eas.basedata.org.client.f7.OrgUnitFilterInfoProducer;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.FrameWorkUtils;
import com.kingdee.eas.framework.client.context.OrgChangeVO;
import com.kingdee.eas.hr.base.HROrgContextManagerFacadeFactory;
import com.kingdee.eas.hr.emp.ContractLimitTypeEnum;
import com.kingdee.eas.hr.emp.ContractTempletCollection;
import com.kingdee.eas.hr.emp.ContractTempletInfo;
import com.kingdee.eas.hr.emp.EmployeeContractFactory;
import com.kingdee.eas.hr.emp.EmployeeContractInfo;
import com.kingdee.eas.hr.emp.EmployeeException;
import com.kingdee.eas.hr.emp.IEmployeeContract;
import com.kingdee.eas.hr.emp.IPersonPosition;
import com.kingdee.eas.hr.emp.PersonPositionCollection;
import com.kingdee.eas.hr.emp.PersonPositionFactory;
import com.kingdee.eas.hr.emp.client.AbstractBatchWizardUI;
import com.kingdee.eas.hr.emp.client.BatchContractEditUI;
import com.kingdee.eas.hr.emp.client.ContractTempletF7;
import com.kingdee.eas.hr.emp.client.EmployeeMultiF7PromptBox;
import com.kingdee.eas.hr.org.client.AdminByOrgRangePromptBox;
import com.kingdee.eas.hr.org.client.AllAdminPromptBox;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ComponentUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class BatchWizardUI
extends AbstractBatchWizardUI {
    boolean isZTCustomer = false;
    private boolean isShowLongName = false;
    private boolean isStrideHRO = false;
    Logger logger = Logger.getLogger(BatchWizardUI.class);

    @Override
    protected void cboIsInAdmin_stateChanged(ChangeEvent e) throws Exception {
        super.cboIsInAdmin_stateChanged(e);
        if (this.cboIsInAdmin.isSelected()) {
            this.txtToUnit.setVisible(false);
            this.prmtToUnit.setVisible(true);
        } else {
            this.txtToUnit.setVisible(true);
            this.prmtToUnit.setVisible(false);
        }
    }

    public BatchWizardUI() throws Exception {
        this.isZTCustomer = EmployeeContractFactory.getRemoteInstance().isZhongTianCustomer();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionInsertEmployee_actionPerformed(ActionEvent e) throws Exception {
        EmployeeMultiF7PromptBox person = new EmployeeMultiF7PromptBox((IUIObject)this);
        HROrgUnitInfo hrOrgUnitInfo = this.getCurrentHRO();
        HashSet<String> set = null;
        if (hrOrgUnitInfo != null) {
            set = new HashSet<String>();
            set.add(hrOrgUnitInfo.getId().toString());
        }
        person.setIsSingleSelect(false);
        person.showNoPositionPerson(true);
        if (this.isZTCustomer) {
            person.setIsShowAllAdmin(true);
        } else if (this.isPersonF7ShowAllAdmin()) {
            person.setIsShowAllAdmin(true);
        } else {
            person.setHROFilter(set);
        }
        person.show();
        if (!person.isCanceled() && person.getData() != null) {
            Object[] obj = (Object[])person.getData();
            for (int i = 0; i < obj.length; ++i) {
                if (this.checkIsExistInListEmployee((PersonInfo)obj[i])) continue;
                ((DefaultListModel)this.listEmployee.getModel()).addElement((PersonInfo)obj[i]);
            }
        }
    }

    protected boolean isPersonF7ShowAllAdmin() {
        return this.isStrideHRO;
    }

    public boolean checkIsExistInListEmployee(PersonInfo pInfo) {
        DefaultListModel model = (DefaultListModel)this.listEmployee.getModel();
        for (int i = 0; i < model.size(); ++i) {
            if (!pInfo.getId().toString().equals(((PersonInfo)model.getElementAt(i)).getId().toString())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void actionDeleteEmployee_actionPerformed(ActionEvent e) throws Exception {
        Object[] objs = this.listEmployee.getSelectedValues();
        for (int i = 0; i < objs.length; ++i) {
            this.listEmployee.removeElement(objs[i]);
        }
    }

    private void setToUnitPromtRange(KDBizPromptBox prmtToUnit, KDBizPromptBox prmtDelegatePerson) {
        EmployeeMultiF7PromptBox delegatePerson = new EmployeeMultiF7PromptBox();
        delegatePerson.setIsSingleSelect(true);
        try {
            if (this.isZTCustomer) {
                prmtToUnit.setSelector((KDPromptSelector)new AdminF7());
                delegatePerson.setIsShowAllAdmin(true);
                prmtDelegatePerson.setSelector((KDPromptSelector)delegatePerson);
            } else {
                AdminByOrgRangePromptBox adminPrmt;
                String contractOrgRange = ParamManager.getParamValue(null, (IObjectPK)new ObjectUuidPK(this.getCurrentHRO().getId()), (String)"IS_CONTRACT_002");
                if ("0".equals(contractOrgRange)) {
                    AllAdminPromptBox alladmin = new AllAdminPromptBox();
                    alladmin.setIsSingleSelect(true);
                    prmtToUnit.setSelector((KDPromptSelector)alladmin);
                    delegatePerson.setIsShowAllAdmin(true);
                    prmtDelegatePerson.setSelector((KDPromptSelector)delegatePerson);
                }
                if ("1".equals(contractOrgRange)) {
                    adminPrmt = new AdminByOrgRangePromptBox("true");
                    HashSet<String> set = new HashSet<String>();
                    set.add(this.getCurrentHRO().getId().toString());
                    adminPrmt.setHROFilter(set);
                    prmtToUnit.setSelector((KDPromptSelector)adminPrmt);
                    delegatePerson.setHROFilter(set);
                    prmtDelegatePerson.setSelector((KDPromptSelector)delegatePerson);
                }
                if ("2".equals(contractOrgRange)) {
                    adminPrmt = new AdminByOrgRangePromptBox("true");
                    prmtToUnit.setSelector((KDPromptSelector)adminPrmt);
                    delegatePerson.setUserOrgRangeFilter(true);
                    prmtDelegatePerson.setSelector((KDPromptSelector)delegatePerson);
                }
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    @Override
    public void actionInsertContract_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"Owner", (Object)this);
        IUIFactory uiFactory = null;
        IUIWindow uiWindow = null;
        try {
            uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            HashSet<CtrlUnitInfo> set = new HashSet<CtrlUnitInfo>();
            set.add(this.getCurrentCU());
            uiContext.put((Object)"HRCU", set);
            uiWindow = uiFactory.create(ContractTempletF7.class.getName(), (Map)uiContext);
            uiWindow.show();
        }
        catch (UIException ex1) {
            this.handleException((Exception)((Object)ex1));
        }
        ContractTempletCollection tempInfos = ((ContractTempletF7)uiWindow.getUIObject()).getReturnContractTemplet();
        if (tempInfos != null && tempInfos.size() != 0) {
            for (int i = 0; i < tempInfos.size(); ++i) {
                if (this.checkIsExistInListContract(tempInfos.get(i))) continue;
                ((DefaultListModel)this.listContract.getModel()).addElement(tempInfos.get(i));
            }
        }
    }

    public boolean checkIsExistInListContract(ContractTempletInfo cInfo) {
        DefaultListModel model = (DefaultListModel)this.listContract.getModel();
        for (int i = 0; i < model.size(); ++i) {
            if (!cInfo.getId().toString().equals(((ContractTempletInfo)model.getElementAt(i)).getId().toString())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void actionDeleteContract_actionPerformed(ActionEvent e) throws Exception {
        super.actionDeleteContract_actionPerformed(e);
        Object[] objs = this.listContract.getSelectedValues();
        for (int i = 0; i < objs.length; ++i) {
            this.listContract.removeElement(objs[i]);
        }
    }

    @Override
    public void actionYes_actionPerformed(ActionEvent e) throws Exception {
        super.actionYes_actionPerformed(e);
        this.checkInput();
        this.checkContinuousContracts();
        UIContext uiContext = new UIContext();
        Window owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        Window ownerWindow = ComponentUtil.getOwnerWindow((Component)owner);
        uiContext.put((Object)"OwnerWindow", (Object)ownerWindow);
        IMainUIObject mainObject = SystemEntry.instance.getMainUIObject();
        uiContext.put((Object)"IMainUIObject", (Object)mainObject);
        this.prepareUIContext(uiContext, e);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(BatchContractEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        this.getUIWindow().close();
        uiWindow.show();
    }

    private void checkContinuousContracts() throws BOSException {
        ContractLimitTypeEnum limitType = null;
        ContractTempletInfo templetInfo = null;
        int size = 0;
        int index = 0;
        limitType = (ContractLimitTypeEnum)((Object)this.cboContractLimitType.getSelectedItem());
        if (!ContractLimitTypeEnum.FIXED_LIMIT.equals((Object)limitType)) {
            return;
        }
        size = this.listContract.getElementCount();
        for (index = 0; index < size && !(templetInfo = (ContractTempletInfo)this.listContract.getElement(index)).getContractType().isIsLaborContract(); ++index) {
        }
        if (index == size) {
            return;
        }
        ArrayList<String> personIdList = new ArrayList<String>();
        HashMap<String, PersonInfo> personMap = new HashMap<String, PersonInfo>();
        size = this.listEmployee.getElementCount();
        for (index = 0; index < size; ++index) {
            PersonInfo personInfo = (PersonInfo)this.listEmployee.getElement(index);
            personIdList.add(personInfo.getId().toString());
            personMap.put(personInfo.getId().toString(), personInfo);
        }
        IEmployeeContract contractBean = EmployeeContractFactory.getRemoteInstance();
        Map map = contractBean.getContinuousContracts(personIdList);
        if (map != null && map.size() > 0) {
            String info = EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.EMPLOYEE_CONTRACT_COUNT");
            info = MessageFormat.format(info, map.size());
            String info2 = EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.EMPLOYEE_CONTRACT_MORE_THAN_TWO");
            StringBuffer detailedInfo = new StringBuffer();
            Iterator iterator = map.entrySet().iterator();
            boolean first = true;
            while (iterator.hasNext()) {
                Map.Entry entry = null;
                entry = iterator.next();
                String id = (String)entry.getKey();
                List contractList = (List)entry.getValue();
                if (first) {
                    first = false;
                } else {
                    detailedInfo.append("\n\n");
                }
                detailedInfo.append(MessageFormat.format(info2, ((PersonInfo)personMap.get(id)).getNumber(), ((PersonInfo)personMap.get(id)).getName()));
                for (int i = 0; i < contractList.size(); ++i) {
                    EmployeeContractInfo contractInfo = (EmployeeContractInfo)contractList.get(i);
                    detailedInfo.append("\n");
                    detailedInfo.append(contractInfo.getContractNo() + " ");
                    detailedInfo.append(contractInfo.getEffectDate() + " ");
                    if (contractInfo.getEndDate() != null) {
                        detailedInfo.append(contractInfo.getEndDate() + " ");
                    }
                    detailedInfo.append(contractInfo.getToUnit());
                }
            }
            MsgBox.showDetailAndOK((Component)((Object)this), (String)info, (String)detailedInfo.toString(), (int)1);
        }
        StringBuffer oql = new StringBuffer();
        oql.append("SELECT id, person.number, person.name WHERE person.id IN (");
        for (int i = 0; i < personIdList.size(); ++i) {
            oql.append("'" + personIdList.get(i) + "'");
            if (i == personIdList.size() - 1) continue;
            oql.append(", ");
        }
        oql.append(") AND joinGroupYears >= 10.0");
        IPersonPosition positionBean = PersonPositionFactory.getRemoteInstance();
        PersonPositionCollection positionColl = positionBean.getPersonPositionCollection(oql.toString());
        if (positionColl.size() > 0) {
            String info = EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.EMPLOYEE_COUNT");
            info = MessageFormat.format(info, positionColl.size());
            String info2 = EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.EMPLOYEE");
            StringBuffer detailedInfo = new StringBuffer();
            for (int i = 0; i < positionColl.size(); ++i) {
                detailedInfo.append(MessageFormat.format(info2, positionColl.get(i).getPerson().getNumber(), positionColl.get(i).getPerson().getName()));
                if (i == positionColl.size() - 1) continue;
                detailedInfo.append("\n");
            }
            MsgBox.showDetailAndOK((Component)((Object)this), (String)info, (String)detailedInfo.toString(), (int)1);
        }
    }

    private void fixContractLimitAuto() {
        this.txtContractLimitAuto.setText(null);
        if (ContractLimitTypeEnum.FIXED_LIMIT.equals(this.cboContractLimitType.getSelectedItem()) && this.effectDate.getValue() != null && this.endDate.getValue() != null) {
            long diftime = ((Date)this.endDate.getValue()).getTime() - ((Date)this.effectDate.getValue()).getTime();
            String contractLimit = new BigDecimal("" + diftime).setScale(1).divide(new BigDecimal("31536000000"), 4).toString();
            this.txtContractLimitAuto.setText(contractLimit);
        }
    }

    public void checkInput() throws EmployeeException {
        if (this.prmtHRO.getData() == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.base.HRBasedataResource", (String)"HRORG_NOT_NULL"));
            this.prmtHRO.requestFocusInWindow();
            SysUtil.abort();
        }
        if (((DefaultListModel)this.listEmployee.getModel()).getSize() == 0) {
            this.btnInsertEmployee.requestFocusInWindow();
            throw new EmployeeException(EmployeeException.PLEASE_SELECT_EMPLOYEE);
        }
        if (((DefaultListModel)this.listContract.getModel()).getSize() == 0) {
            this.btnInsertContract.requestFocusInWindow();
            throw new EmployeeException(EmployeeException.PLEASE_SELECT_CONTRACTTEMPLET);
        }
        if (this.prmtToUnit.getText() == null || "".equals(this.prmtToUnit.getText())) {
            this.prmtToUnit.requestFocusInWindow();
            throw new EmployeeException(EmployeeException.EMPLOYEE_CONTRACT_TOUNIT_NOT_NULL);
        }
        if (this.recordDate.getValue() == null) {
            this.recordDate.requestFocusInWindow();
            throw new EmployeeException(EmployeeException.EMPLOYEE_CONTRACT_STARTDATE_NOT_NULL);
        }
        if (this.effectDate.getValue() == null) {
            this.effectDate.requestFocusInWindow();
            throw new EmployeeException(EmployeeException.EMPLOYEE_CONTRACT_EFFECTDATE_NOT_NULL);
        }
        if (this.freeDate.getValue() != null && DateTimeUtils.dayAfter((Date)((Date)this.recordDate.getValue()), (Date)((Date)this.freeDate.getValue()))) {
            this.freeDate.requestFocusInWindow();
            throw new EmployeeException(EmployeeException.STARTDATE_NOT_DY_INEFFECTDATE);
        }
        if (this.endDate.getValue() != null && DateTimeUtils.dayAfter((Date)((Date)this.recordDate.getValue()), (Date)((Date)this.endDate.getValue()))) {
            this.endDate.requestFocusInWindow();
            throw new EmployeeException(EmployeeException.STARTDATE_NOT_DY_ENDDATE);
        }
        if (this.endDate.getValue() != null && DateTimeUtils.dayAfter((Date)((Date)this.effectDate.getValue()), (Date)((Date)this.endDate.getValue()))) {
            this.endDate.requestFocusInWindow();
            throw new EmployeeException(EmployeeException.EFFECTDATE_NOT_DY_ENDDATE);
        }
        if (this.freeDate.getValue() != null && DateTimeUtils.dayAfter((Date)((Date)this.effectDate.getValue()), (Date)((Date)this.freeDate.getValue()))) {
            this.freeDate.requestFocusInWindow();
            throw new EmployeeException(EmployeeException.EFFECTDATE_NOT_DY_INEFFECTDATE);
        }
        if (ContractLimitTypeEnum.FIXED_LIMIT.equals(this.cboContractLimitType.getSelectedItem()) && this.endDate.getValue() == null) {
            this.endDate.requestFocusInWindow();
            throw new EmployeeException(EmployeeException.CONTRACT_LIMIT_MUST_ENDDATE);
        }
        if (ContractLimitTypeEnum.NO_FIXED_LIMIT.equals(this.cboContractLimitType.getSelectedItem()) && this.endDate.getValue() != null) {
            this.endDate.requestFocusInWindow();
            throw new EmployeeException(EmployeeException.CONTRACT_NO_LIMIT_NO_ENDDATE);
        }
    }

    public void prepareUIContext(UIContext uiContext, ActionEvent e) {
        uiContext.put((Object)"personInfos", (Object)this.getCollectionFromEmployeeList());
        uiContext.put((Object)"contractTempletInfos", (Object)this.getCollectionFromContractTempletList());
        if (this.cboIsInAdmin.isSelected()) {
            uiContext.put((Object)"toUnit", (Object)((AdminOrgUnitInfo)this.prmtToUnit.getData()));
        } else {
            uiContext.put((Object)"toUnit", (Object)this.txtToUnit.getText());
        }
        uiContext.put((Object)"delegatePerson", (Object)((PersonInfo)this.prmtDelegatePerson.getData()));
        uiContext.put((Object)"recordDate", this.recordDate.getValue());
        uiContext.put((Object)"effectDate", this.effectDate.getValue());
        uiContext.put((Object)"freeDate", this.freeDate.getValue());
        uiContext.put((Object)"endDate", this.endDate.getValue());
        uiContext.put((Object)"currentHRO", (Object)this.getCurrentHRO().getId().toString());
        uiContext.put((Object)"contractLimitType", this.cboContractLimitType.getSelectedItem());
        uiContext.put((Object)"thirdUnitAddress", (Object)this.txtThirdUnitAddress.getText());
        uiContext.put((Object)"thirdUnitName", (Object)this.txtThirdUnitName.getText());
        uiContext.put((Object)"thirdDelegatePerson", (Object)this.txtThirdDelegatePerson.getText());
        uiContext.put((Object)"contractLimitAuto", (Object)this.txtContractLimitAuto.getText());
        uiContext.put((Object)"isInAdmin", (Object)this.cboIsInAdmin.isSelected());
        uiContext.put((Object)"unitAddress", (Object)this.txtUnitAddress.getText());
    }

    public PersonCollection getCollectionFromEmployeeList() {
        PersonCollection personInfos = new PersonCollection();
        DefaultListModel model = (DefaultListModel)this.listEmployee.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            personInfos.add((PersonInfo)model.get(i));
        }
        return personInfos;
    }

    public ContractTempletCollection getCollectionFromContractTempletList() {
        ContractTempletCollection tempInfos = new ContractTempletCollection();
        DefaultListModel model = (DefaultListModel)this.listContract.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            tempInfos.add((ContractTempletInfo)model.get(i));
        }
        return tempInfos;
    }

    @Override
    public void actionExit_actionPerformed(ActionEvent e) throws Exception {
        super.actionExit_actionPerformed(e);
        this.getUIWindow().close();
    }

    public void onLoad() throws Exception {
        this.isStrideHRO = HRParamUtil.getParamOfHR(null, (String)"IS_CONTRACT_ALLHR", null);
        this.isShowLongName = HRParamUtil.getParamOfHR(null, (String)"IS_CONTRACT_003", null);
        super.onLoad();
        this.setMainBizOrgF7(this.prmtHRO);
        this.prmtHRO.setRequired(true);
        this.initPrompt();
        this.prmtHRO.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                OrgChangeVO orgChg = new OrgChangeVO(eventObj.getOldValue(), eventObj.getNewValue());
                OrgUnitInfo org = (OrgUnitInfo)orgChg.getNewOrg();
                if (orgChg.isDiffrent() && org != null) {
                    BatchWizardUI.this.switchOrg(org.getId().toString());
                }
            }
        });
        Object obj = this.getUIContext().get("getCurrentHRO");
        if (obj != null) {
            HROrgUnitInfo hrOrg = (HROrgUnitInfo)obj;
            if (hrOrg.isIsBizUnit()) {
                this.prmtHRO.setValue(this.getUIContext().get("getCurrentHRO"));
                this.prmtHRO.setValue((Object)hrOrg);
            } else {
                this.prmtHRO.setValue(null);
            }
        }
        this.initButtonState();
        this.initButtonIcon();
        if (this.getUIContext().get("PersonPositionCollection") != null) {
            PersonPositionCollection perPosCol = (PersonPositionCollection)((Object)this.getUIContext().get("PersonPositionCollection"));
            int size = perPosCol.size();
            for (int i = 0; i < size; ++i) {
                PersonInfo pInfo = perPosCol.get(i).getPerson();
                pInfo.put("primaryAdminOrg", (Object)perPosCol.get(i).getPersonDep());
                pInfo.put("primaryPosition", (Object)perPosCol.get(i).getPrimaryPosition());
                ((DefaultListModel)this.listEmployee.getModel()).addElement(pInfo);
            }
        }
        if (ContractLimitTypeEnum.FIXED_LIMIT.equals(this.cboContractLimitType.getSelectedItem())) {
            this.endDate.setRequired(true);
            this.endDate.setEnabled(true);
        } else {
            this.endDate.setRequired(false);
            this.endDate.setEnabled(false);
            this.endDate.setValue(null);
        }
        this.effectDate.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                BatchWizardUI.this.fixContractLimitAuto();
            }
        });
        this.endDate.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                BatchWizardUI.this.fixContractLimitAuto();
            }
        });
    }

    private void switchOrg(String pk) {
        this.prmtToUnit.setData(null);
        this.prmtDelegatePerson.setData(null);
        this.listEmployee.removeAllElements();
        this.listContract.removeAllElements();
        if (pk != null) {
            this.initUIMainOrgContext(pk.toString());
        }
        this.initPrompt();
    }

    public void initButtonIcon() {
        this.btnDeleteContract.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.btnDeleteEmployee.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.btnInsertContract.setIcon(EASResource.getIcon((String)"imgTbtn_find"));
        this.btnInsertEmployee.setIcon(EASResource.getIcon((String)"imgTbtn_find"));
    }

    public void initButtonState() {
        this.btnDeleteContract.setEnabled(true);
        this.btnInsertContract.setEnabled(true);
        this.btnDeleteEmployee.setEnabled(true);
        this.btnInsertEmployee.setEnabled(true);
        this.btnYes.setEnabled(true);
        this.btnExit.setEnabled(true);
        this.recordDate.setValue((Object)new Date());
        this.effectDate.setValue((Object)new Date());
        this.freeDate.setValue(null);
        this.endDate.setValue(null);
        this.txtContractLimitAuto.setEditable(false);
    }

    public void initPrompt() {
        this.setToUnitPromtRange(this.prmtToUnit, this.prmtDelegatePerson);
        if (this.isShowLongName) {
            this.prmtToUnit.setEditFormat("$displayName$");
            this.prmtToUnit.setCommitFormat("$displayName$");
            this.prmtToUnit.setDisplayFormat("$displayName$");
        } else {
            this.prmtToUnit.setEditFormat("$name$");
            this.prmtToUnit.setCommitFormat("$name$");
            this.prmtToUnit.setDisplayFormat("$name$");
        }
        this.prmtToUnit.setEditable(false);
        try {
            AdminOrgUnitInfo adminInfo = null;
            String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            HashSet<String> hrOrgIDs = new HashSet<String>();
            hrOrgIDs.add(this.getCurrentHRO().getId().toString());
            adminInfo = HROrgContextManagerFacadeFactory.getRemoteInstance().getAdminForHRandUserOrgRange(userId, hrOrgIDs);
            this.prmtToUnit.setData((Object)adminInfo);
        }
        catch (EASBizException e) {
            this.logger.info((Object)e);
        }
        catch (BOSException e) {
            this.logger.info((Object)e);
        }
        this.prmtDelegatePerson.setDisplayFormat("$name$");
        this.prmtDelegatePerson.setEditFormat("$number$");
        this.prmtDelegatePerson.setCommitFormat("$number$");
        this.prmtDelegatePerson.setEditable(false);
    }

    private HROrgUnitInfo getCurrentHRO() {
        if (this.getMainOrgContext() == null) {
            return SysContext.getSysContext().getCurrentHRUnit();
        }
        if (FrameWorkUtils.getCurrentOrgUnit((Context)this.getMainOrgContext(), (OrgType)OrgType.HRO) != null) {
            return (HROrgUnitInfo)FrameWorkUtils.getCurrentOrgUnit((Context)this.getMainOrgContext(), (OrgType)OrgType.HRO);
        }
        return SysContext.getSysContext().getCurrentHRUnit();
    }

    private CtrlUnitInfo getCurrentCU() {
        if (this.getMainOrgContext() == null) {
            return SysContext.getSysContext().getCurrentCtrlUnit();
        }
        if (FrameWorkUtils.getCurrentOrgUnit((Context)this.getMainOrgContext(), (OrgType)OrgType.ControlUnit) != null) {
            return (CtrlUnitInfo)FrameWorkUtils.getCurrentOrgUnit((Context)this.getMainOrgContext(), (OrgType)OrgType.ControlUnit);
        }
        return SysContext.getSysContext().getCurrentCtrlUnit();
    }

    private void setMainBizOrgF7(KDBizPromptBox bizOrgUnitBox) {
        if (bizOrgUnitBox != null) {
            OrgUnitFilterInfoProducer iProducer = null;
            String permissionItem = "empcontract_view";
            iProducer = (OrgUnitFilterInfoProducer)FilterInfoProducerFactory.getOrgUnitFilterInfoProducer((OrgType)OrgType.HRO);
            if (iProducer != null) {
                if (permissionItem != null) {
                    iProducer.getModel().setPermissionItem(permissionItem);
                }
                bizOrgUnitBox.setFilterInfoProducer((IFilterInfoProducer)iProducer);
                if (iProducer.getModel() != null) {
                    bizOrgUnitBox.setSelector((KDPromptSelector)iProducer.getModel());
                    iProducer.getModel().setMultiSelect(false);
                }
            }
            bizOrgUnitBox.setCommitFormat("$number$;$code$");
            bizOrgUnitBox.setEditFormat("$number$");
            bizOrgUnitBox.setDisplayFormat("$name$");
            bizOrgUnitBox.setEditable(false);
            bizOrgUnitBox.setEnabledMultiSelection(false);
        }
    }

    @Override
    protected void cboContractLimitType_itemStateChanged(ItemEvent e) throws Exception {
        if (ContractLimitTypeEnum.FIXED_LIMIT.equals(this.cboContractLimitType.getSelectedItem())) {
            this.endDate.setRequired(true);
            this.endDate.setEnabled(true);
        }
        if (ContractLimitTypeEnum.NO_FIXED_LIMIT.equals(this.cboContractLimitType.getSelectedItem())) {
            this.endDate.setRequired(false);
            this.endDate.setEnabled(false);
            this.endDate.setValue(null);
        }
        if (ContractLimitTypeEnum.COMPLETE_WORK_TYPE.equals(this.cboContractLimitType.getSelectedItem())) {
            this.endDate.setRequired(false);
            this.endDate.setEnabled(true);
        }
    }
}

