/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.appframework.databinding.BindingUtility;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.permission.FieldAccessInfo;
import com.kingdee.eas.base.permission.FieldPermission;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ep.EPException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.IUILifeCycleListener;
import com.kingdee.eas.framework.client.UILifeCycleEvent;
import com.kingdee.eas.framework.client.UILifeCycleImp;
import com.kingdee.eas.hr.base.client.EmployeePageConstraints;
import com.kingdee.eas.hr.base.client.IEmployeeUI;
import com.kingdee.eas.hr.emp.EmpDynamicPageFacadeFactory;
import com.kingdee.eas.hr.emp.EmployeePageInfo;
import com.kingdee.eas.hr.emp.client.AbstractEmpDynamicPageListUI;
import com.kingdee.eas.hr.emp.client.DynamicPageHelper;
import com.kingdee.eas.hr.emp.client.EmpDynamicPageSingleLineEditUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;

public class EmpDynamicPageListUI
extends AbstractEmpDynamicPageListUI {
    private static final Logger logger = CoreUIObject.getLogger(EmpDynamicPageListUI.class);
    EmployeePageInfo pageInfo = null;
    private IEmployeeUI treeEditUI = null;
    HashMap entityMap = new HashMap();
    HashMap entityPermissionMap = new HashMap();
    HashMap infosMap = new HashMap();

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        this.treeEditUI = (IEmployeeUI)this.getUIContext().get("GroupListEditUI");
        this.pageInfo = (EmployeePageInfo)this.getUIContext().get(EmployeePageConstraints.EMPPAGEINFO);
        this.pageListTable.checkParsed();
        this.createTableColumn(this.pageInfo);
        super.onLoad();
        this.setButtonDefaultStyl(this.btnAddNew);
        this.btnAddNew.setIcon(EASResource.getIcon((String)"imgTbtn_new"));
        this.setButtonDefaultStyl(this.btnEdit);
        this.btnEdit.setIcon(EASResource.getIcon((String)"imgTbtn_edit"));
        this.setButtonDefaultStyl(this.btnRemove);
        this.btnRemove.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.loadFields();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        for (int i = this.pageListTable.getRowCount(); i > 0; --i) {
            this.pageListTable.removeRow(i - 1);
        }
        this.loadEntityInfos();
        this.loadValueToTable();
        this.initAddNewAndDelete();
    }

    private void loadValueToTable() {
        if (this.infosMap.size() == 0) {
            return;
        }
        IRow row = this.pageListTable.addRow();
        String entityName = null;
        String propertyName = null;
        String key = null;
        Iterator iter = this.entityMap.keySet().iterator();
        ArrayList propertyList = null;
        while (iter.hasNext()) {
            entityName = iter.next().toString();
            propertyList = (ArrayList)this.entityMap.get(entityName);
            CoreBaseInfo baseInfo = (CoreBaseInfo)this.infosMap.get(entityName);
            if (baseInfo == null) continue;
            for (int i = 0; i < propertyList.size(); ++i) {
                propertyName = (String)propertyList.get(i);
                key = DynamicPageHelper.getKeyName(entityName, propertyName);
                if (row.getCell(key) == null) continue;
                row.getCell(key).setValue(BindingUtility.getBeanProperty((Object)baseInfo, (String)propertyName));
                row.getCell(key).getStyleAttributes().setLocked(true);
            }
        }
    }

    private void loadEntityInfos() {
        Object entityInfo = null;
        Object entityPK = null;
        Object baseInfo = null;
        Iterator iter = this.entityMap.keySet().iterator();
        Object entityName = null;
        try {
            if (!this.treeEditUI.isPersonEmpty()) {
                this.infosMap = EmpDynamicPageFacadeFactory.getRemoteInstance().prepareObjectInfos(this.entityMap, this.treeEditUI.getEmployeeID());
            }
        }
        catch (EASBizException e) {
            this.handleException((Exception)((Object)e));
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
    }

    private CoreBaseInfo prepareObjectInfo(MetaDataPK entityPK, String entityName) throws ClassNotFoundException, BOSException, Exception, EASBizException, InstantiationException, IllegalAccessException {
        CoreBaseInfo baseInfo = null;
        EntityObjectInfo entityInfo = MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity((IMetaDataPK)entityPK);
        Class<?> classObj = Class.forName(entityInfo.getBusinessInterface());
        ICoreBase iCoreBase = null;
        iCoreBase = !StringUtils.isEmpty((String)entityInfo.getExtendedProperty("commonControllerName")) ? (ICoreBase)BOSObjectFactory.createRemoteCommonBOSObject((IMetaDataPK)entityPK) : (ICoreBase)BOSObjectFactory.createRemoteBOSObject((BOSObjectType)entityInfo.getType(), classObj);
        ArrayList propertyList = (ArrayList)this.entityMap.get(entityName);
        if (entityPK.getName().equals("Person")) {
            String oql = DynamicPageHelper.getEntityOQL(propertyList);
            baseInfo = iCoreBase.getValue(oql + " where id = '" + this.treeEditUI.getEmployeeID() + "'");
        } else {
            CoreBaseCollection coll = iCoreBase.getCollection(DynamicPageHelper.getEntityOQL(propertyList) + " where person.id = '" + this.treeEditUI.getEmployeeID() + "'");
            if (coll.size() > 0) {
                baseInfo = coll.get(0);
            }
        }
        return baseInfo;
    }

    private void createTableColumn(EmployeePageInfo pageInfo2) {
        String xmlStr = this.pageInfo.getPageContent();
        if (StringUtils.isEmpty((String)xmlStr)) {
            return;
        }
        try {
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build((Reader)new StringReader(xmlStr));
            Element root = doc.getRootElement();
            Element fieldList = root.getChild("fieldList");
            Element field = null;
            this.entityMap = new HashMap();
            Object binder = null;
            String entityName = null;
            FieldPermission fieldPermission = null;
            FieldAccessInfo fieldAccess = null;
            IObjectPK userPK = this.getUserPk();
            String propertyName = null;
            int size = fieldList.getChildren().size();
            for (int i = 0; i < size; ++i) {
                field = (Element)fieldList.getChildren().get(i);
                entityName = field.getChild("entityName").getText();
                propertyName = field.getChild("name").getText();
                ArrayList propertyList = null;
                if (this.entityMap.containsKey(entityName)) {
                    propertyList = (ArrayList)this.entityMap.get(entityName);
                } else {
                    propertyList = new ArrayList();
                    this.entityMap.put(entityName, propertyList);
                }
                propertyList.add(propertyName);
                propertyList.add(this.getPorpertyName(field));
                if (this.entityPermissionMap.get(entityName) == null) {
                    fieldPermission = EmpDynamicPageFacadeFactory.getRemoteInstance().getFieldPermission(entityName, userPK, this.treeEditUI.getMainBizOrgInfo());
                    this.entityPermissionMap.put(entityName, fieldPermission);
                } else {
                    fieldPermission = (FieldPermission)this.entityPermissionMap.get(entityName);
                }
                fieldAccess = null;
                if (fieldPermission != null && fieldPermission.isEnableFieldPermission(propertyName) && !(fieldAccess = fieldPermission.getFieldAccessInfo(propertyName)).isViewable() && !fieldAccess.isEditable()) continue;
                IColumn iColumn = this.createColumn(field, entityName, propertyName);
            }
        }
        catch (EPException builder) {
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public String getPorpertyName(Element dataTypeElement) {
        String dataType = dataTypeElement.getChild("dataType").getChild("name").getText();
        Object comp = null;
        String propertyName = dataTypeElement.getChild("name").getText();
        if (dataType.equals("CommonF7")) {
            propertyName = propertyName + ".name";
        } else if (dataType.equals("CustomF7")) {
            propertyName = propertyName + ".name";
        }
        return propertyName;
    }

    private IColumn createColumn(Element field, String entityName, String propertyName) {
        IColumn column = this.pageListTable.addColumn();
        column.setKey(DynamicPageHelper.getKeyName(entityName, propertyName));
        IRow iRow = this.pageListTable.getHeadRow(0);
        if (iRow != null) {
            ICell iCell = iRow.getCell(column.getColumnIndex());
            iCell.setValue((Object)field.getChild("displayName").getText());
        }
        return column;
    }

    @Override
    public void addNewAction_actionPerformed(ActionEvent e) throws Exception {
        super.addNewAction_actionPerformed(e);
        IUIWindow uiWindow = this.showEditUI(OprtState.ADDNEW);
        uiWindow.show();
    }

    @Override
    public void editAction_actionPerformed(ActionEvent e) throws Exception {
        super.editAction_actionPerformed(e);
        IUIWindow uiWindow = this.showEditUI(OprtState.EDIT);
        uiWindow.show();
        if (DynamicPageHelper.getEditUIMode((CoreUIObject)this).equals("com.kingdee.eas.base.uiframe.client.UINewTabFactory")) {
            CoreUI coreUI = (CoreUI)uiWindow.getUIObject();
            UILifeCycleImp lifeCycleListener = new UILifeCycleImp(){

                public void onDestroyWindow(UILifeCycleEvent event) {
                    try {
                        if (SysContext.getSysContext().getSessionID() != null) {
                            EmpDynamicPageListUI.this.refreshCurrentPage();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            coreUI.getUILifeCycleHandler().addRuleListener((IUILifeCycleListener)lifeCycleListener);
        } else {
            Window window = SwingUtilities.getWindowAncestor((JComponent)uiWindow.getUIObject());
            IUIWindow iuw = uiWindow;
            WindowAdapter listenerForEditWindow = null;
            listenerForEditWindow = new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent event) {
                    try {
                        if (SysContext.getSysContext().getSessionID() != null) {
                            EmpDynamicPageListUI.this.refreshCurrentPage();
                        }
                    }
                    catch (Exception e) {
                        EmpDynamicPageListUI.this.handleException(e);
                    }
                }
            };
            window.addWindowListener(listenerForEditWindow);
        }
    }

    private IUIWindow showEditUI(String oprtState) throws UIException {
        UIContext uiContext = this.prepareUIContext();
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)DynamicPageHelper.getEditUIMode((CoreUIObject)this)).create(EmpDynamicPageSingleLineEditUI.class.getName(), (Map)uiContext, null, oprtState);
        return uiWindow;
    }

    private UIContext prepareUIContext() {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"GroupListEditUI", (Object)this.treeEditUI);
        uiContext.put((Object)"ID", (Object)this.treeEditUI.getEmployeeID());
        uiContext.put((Object)EmployeePageConstraints.EMPPAGEINFO, (Object)this.pageInfo);
        return uiContext;
    }

    @Override
    public void removeAction_actionPerformed(ActionEvent e) throws Exception {
        super.removeAction_actionPerformed(e);
        EmpDynamicPageFacadeFactory.getRemoteInstance().deleteEmployeeSinglePage(this.infosMap);
        this.refreshCurrentPage();
    }

    public void refreshCurrentPage() {
        this.loadFields();
    }

    private void initAddNewAndDelete() {
        if (OprtState.VIEW.equals(this.getOprtState())) {
            this.btnAddNew.setEnabled(false);
            this.btnEdit.setEnabled(false);
            this.btnRemove.setEnabled(false);
        } else if (OprtState.EDIT.equals(this.getOprtState())) {
            if (this.pageListTable.getRowCount() >= 1) {
                this.btnAddNew.setEnabled(false);
            } else {
                this.btnAddNew.setEnabled(true);
            }
            this.btnRemove.setEnabled(false);
        } else {
            this.btnAddNew.setVisible(false);
            this.btnRemove.setVisible(false);
        }
        if (this.entityMap.containsKey("com.kingdee.eas.basedata.person.app.Person") || this.entityMap.containsKey("com.kingdee.eas.hr.emp.app.PersonPosition")) {
            // empty if block
        }
        if (this.treeEditUI.getEmployeeID() == null) {
            this.btnAddNew.setEnabled(false);
        } else {
            try {
                if (!PersonFactory.getRemoteInstance().exists("where id ='" + this.treeEditUI.getEmployeeID() + "'")) {
                    this.btnAddNew.setEnabled(false);
                }
            }
            catch (EASBizException e) {
                this.handleException((Exception)((Object)e));
            }
            catch (BOSException e) {
                this.handleException((Exception)((Object)e));
            }
        }
    }

    @Override
    protected void pageListTable_tableClicked(KDTMouseEvent e) throws Exception {
        super.pageListTable_tableClicked(e);
        if (e.getType() == 1 && e.getButton() == 1 && e.getClickCount() == 2) {
            if (e.getType() == 0) {
                return;
            }
            IUIWindow uiWindow = this.showEditUI(OprtState.VIEW);
            uiWindow.show();
        }
    }
}

