/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.base.CertifiedCompetencyFactory;
import com.kingdee.eas.hr.base.CertifiedCompetencyInfo;
import com.kingdee.eas.hr.base.client.CertifiedCompetencyPromptBox;
import com.kingdee.eas.hr.emp.EmployeeException;
import com.kingdee.eas.hr.emp.IPersonCertifyCompetency;
import com.kingdee.eas.hr.emp.PersonCertifyCompetencyFactory;
import com.kingdee.eas.hr.emp.PersonCertifyCompetencyInfo;
import com.kingdee.eas.hr.emp.client.AbstractEmployeeCertifiedCompetencyEditUI;
import com.kingdee.eas.hr.emp.client.EmployeeClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.text.SimpleDateFormat;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class EmployeeCertifiedCompetencyEditUI
extends AbstractEmployeeCertifiedCompetencyEditUI {
    private static final Logger logger = CoreUIObject.getLogger(EmployeeCertifiedCompetencyEditUI.class);
    private static SimpleDateFormat dateFormat = null;
    public static final String RES = "com.kingdee.eas.hr.state.ProfTechResource";
    private HROrgUnitInfo hroInfo = null;

    public static boolean isValidDate(String s) {
        try {
            dateFormat.parse(s);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public IObjectPK runSubmit() throws Exception {
        this.editData.setHrOrgUnit(this.getCurrentHRO());
        this.editData.setCU(this.getCurrentCU());
        return super.runSubmit();
    }

    private CtrlUnitInfo getCurrentCU() {
        if (this.hroInfo != null) {
            return this.hroInfo.getCU();
        }
        return SysContext.getSysContext().getCurrentCtrlUnit();
    }

    private HROrgUnitInfo getCurrentHRO() {
        if (this.hroInfo != null) {
            return this.hroInfo;
        }
        return SysContext.getSysContext().getCurrentHRUnit();
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        return new ObjectUuidPK(this.getCurrentHRO().getId());
    }

    @Override
    public void storeFields() {
        super.storeFields();
        if (!(this.editData.getAppointDate() == null || EmployeeCertifiedCompetencyEditUI.isValidDate(this.TextAppointDate.getText().trim()) && this.TextAppointDate.getText().trim().charAt(0) != '0' && this.TextAppointDate.getText().trim().charAt(4) == '-')) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"TheDateTypeisn'twright"));
            this.TextAppointDate.requestFocusInWindow();
            SysUtil.abort();
        }
    }

    @Override
    protected IObjectValue createNewData() {
        PersonCertifyCompetencyInfo info = new PersonCertifyCompetencyInfo();
        PersonInfo pInfo = new PersonInfo();
        pInfo.setId(BOSUuid.read((String)this.getUIContext().get("PersonID").toString()));
        info.setPerson(pInfo);
        this.txtType.setText(null);
        this.txtLevel.setText(null);
        return info;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return PersonCertifyCompetencyFactory.getRemoteInstance();
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        if (this.prmtCertifiedCompetency.getData() == null) {
            throw new EmployeeException(EmployeeException.CERTIFYCOMPETENCY_NOT_NULL);
        }
    }

    protected void afterOnLoad() throws Exception {
        super.afterOnLoad();
        if (this.editData.getId() != null) {
            this.setTypeAndLevelName(this.editData.getCertifiedCompetency().getId().toString());
            if (this.getOprtState().equals("EDIT")) {
                this.checkReference(this.editData.getId().toString());
            }
        }
        this.initprompt();
    }

    protected void beforeOnLoad() throws Exception {
        super.beforeOnLoad();
        this.hroInfo = (HROrgUnitInfo)this.getUIContext().get("currentHRO");
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        if (this.editData != null && this.editData.getId() != null) {
            this.checkReference(this.editData.getId().toString());
        }
    }

    public boolean isModify() {
        return false;
    }

    private void checkReference(String perCertifyId) {
        try {
            if (((IPersonCertifyCompetency)this.getBizInterface()).refrencedByCheckOUt(perCertifyId)) {
                this.prmtCertifiedCompetency.setEnabled(false);
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.base.CertifiedCompetencyResource.PERSONCERTIFY_REFRENCEDBYCHECKOUT"));
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        if (OprtState.VIEW.equals(this.getOprtState())) {
            this.actionAddNew.setVisible(false);
            this.actionEdit.setVisible(false);
            this.actionCopy.setVisible(false);
            this.actionSubmit.setVisible(false);
            this.actionRemove.setVisible(false);
        } else {
            this.actionAddNew.setVisible(true);
            this.actionEdit.setVisible(true);
            this.actionCopy.setVisible(true);
            this.actionSubmit.setVisible(true);
            this.actionRemove.setVisible(true);
        }
        this.prmtCertifiedCompetency.setEditable(false);
        this.prmtCertifiedCompetency.addPreChangeListener(new PreChangeListener(){

            public void preChange(PreChangeEvent arg0) {
                CertifiedCompetencyInfo info = (CertifiedCompetencyInfo)arg0.getData();
                if (info == null) {
                    return;
                }
                EmployeeCertifiedCompetencyEditUI.this.setTypeAndLevelName(info.getId().toString());
            }
        });
    }

    private void initprompt() {
        CertifiedCompetencyPromptBox tpBox = new CertifiedCompetencyPromptBox((IUIObject)this);
        HashSet<CtrlUnitInfo> cuSet = new HashSet<CtrlUnitInfo>();
        cuSet.add(EmployeeClientUtils.getCurrentCU(this.getUIContext()));
        tpBox.changeContextByCUSet(cuSet);
        this.prmtCertifiedCompetency.setSelector((KDPromptSelector)tpBox);
    }

    private void setTypeAndLevelName(String strCertifiedId) {
        try {
            String sql = "select category.id,category.name,level.id,level.name where id = '" + strCertifiedId + "'";
            CertifiedCompetencyInfo newInfo = CertifiedCompetencyFactory.getRemoteInstance().getCertifiedCompetencyInfo(sql);
            this.txtType.setText(newInfo.getCategory().getName());
            if (newInfo.getLevel() != null) {
                this.txtLevel.setText(newInfo.getLevel().getName());
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage());
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection selector = super.getSelectors();
        selector.add(new SelectorItemInfo("person.id"));
        selector.add(new SelectorItemInfo("person.name"));
        selector.add(new SelectorItemInfo("person.number"));
        return selector;
    }

    static {
        dateFormat = new SimpleDateFormat("yyyy-MM");
        dateFormat.setLenient(false);
    }
}

