/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.client;

import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.base.client.CertifiedCompetencyPromptBox;
import com.kingdee.eas.hr.base.util.GroupBaseDataControlUtil;
import com.kingdee.eas.hr.emp.EmployeeException;
import com.kingdee.eas.hr.emp.PersonCertificationFactory;
import com.kingdee.eas.hr.emp.PersonCertificationInfo;
import com.kingdee.eas.hr.emp.client.AbstractEmployeeCertifyEditUI;
import com.kingdee.eas.hr.emp.client.EmployeeClientUtils;
import com.kingdee.eas.hr.org.client.PosiQualPromptBox;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.HashSet;

public class EmployeeCertifyEditUI
extends AbstractEmployeeCertifyEditUI {
    private HROrgUnitInfo hroInfo = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void afterOnLoad() throws Exception {
        super.afterOnLoad();
        this.initPrompt();
        this.txtPeriodValidity.setNegatived(false);
        this.txtPeriodValidity.setValue((Object)this.editData.getPeriodValidity());
    }

    public void initLayout() {
        super.initLayout();
    }

    protected void beforeOnLoad() throws Exception {
        super.beforeOnLoad();
        this.hroInfo = (HROrgUnitInfo)this.getUIContext().get("currentHRO");
    }

    public IObjectPK runSubmit() throws Exception {
        this.editData.setHrOrgUnit(this.getCurrentHRO());
        this.editData.setCU(this.getCurrentCU());
        return super.runSubmit();
    }

    private CtrlUnitInfo getCurrentCU() {
        if (this.hroInfo != null) {
            return this.hroInfo.getCU();
        }
        return SysContext.getSysContext().getCurrentCtrlUnit();
    }

    private HROrgUnitInfo getCurrentHRO() {
        if (this.hroInfo != null) {
            return this.hroInfo;
        }
        return SysContext.getSysContext().getCurrentHRUnit();
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        return new ObjectUuidPK(this.getCurrentHRO().getId());
    }

    @Override
    protected IObjectValue createNewData() {
        PersonCertificationInfo info = new PersonCertificationInfo();
        PersonInfo pInfo = new PersonInfo();
        pInfo.setId(BOSUuid.read((String)this.getUIContext().get("PersonID").toString()));
        info.setPerson(pInfo);
        return info;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return PersonCertificationFactory.getRemoteInstance();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.prmtCertifiedCompetency.setDisplayFormat("$name$");
        this.prmtCertifiedCompetency.setCommitFormat("$number$");
        this.prmtCertifiedCompetency.setEditable(false);
        if (OprtState.VIEW.equals(this.getOprtState())) {
            this.actionAddNew.setVisible(false);
            this.actionEdit.setVisible(false);
            this.actionCopy.setVisible(false);
            this.actionSubmit.setVisible(false);
            this.actionRemove.setVisible(false);
        } else {
            this.actionAddNew.setVisible(true);
            this.actionEdit.setVisible(true);
            this.actionCopy.setVisible(true);
            this.actionSubmit.setVisible(true);
            this.actionRemove.setVisible(true);
        }
    }

    private void initPrompt() {
        CertifiedCompetencyPromptBox certifiedCompetencyPromptBox = new CertifiedCompetencyPromptBox();
        HashSet<CtrlUnitInfo> cuSet = new HashSet<CtrlUnitInfo>();
        cuSet.add(EmployeeClientUtils.getCurrentCU(this.getUIContext()));
        certifiedCompetencyPromptBox.changeContextByCUSet(cuSet);
        this.prmtCertifiedCompetency.setSelector((KDPromptSelector)certifiedCompetencyPromptBox);
        PosiQualPromptBox tpBox = new PosiQualPromptBox((IUIObject)this);
        HashSet<CtrlUnitInfo> set = new HashSet<CtrlUnitInfo>();
        set.add(this.getCurrentCU());
        tpBox.changeContextByCUSet(set);
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(GroupBaseDataControlUtil.getFilterForControlTypeS4((CtrlUnitInfo)this.getCurrentCU(), (String)"CU.id", (String)"CU.longNumber"));
        this.prmtcertifyType.setEntityViewInfo(viewInfo);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        Date retainEndDate;
        Date retainDate;
        Date pkcertifyUpToDate;
        Date pkCertifyDate;
        boolean flagOfDate;
        if (StringUtils.isEmpty((String)this.txtCertificateNumber.getText())) {
            this.txtCertificateNumber.requestFocusInWindow();
            throw new EmployeeException(EmployeeException.EMP_CERTIFY_NUMBER_NOT_NULL);
        }
        if (StringUtils.isEmpty((String)this.txtCertificateName.getText())) {
            this.txtCertificateName.requestFocusInWindow();
            throw new EmployeeException(EmployeeException.EMP_CERTIFY_NAME_NOT_NULL);
        }
        if (this.pkCertifyDate.getValue() != null && this.pkcertifyUpToDate.getValue() != null && (flagOfDate = DateTimeUtils.dayAfter((Date)(pkCertifyDate = (Date)this.pkCertifyDate.getValue()), (Date)(pkcertifyUpToDate = (Date)this.pkcertifyUpToDate.getValue())))) {
            throw new EmployeeException(EmployeeException.ENROLLDATE_AFTER_GRADUATEDATE);
        }
        if (this.pkretainDate.getValue() != null && this.pkRetainEndDate.getValue() != null && (retainDate = (Date)this.pkretainDate.getValue()).after(retainEndDate = (Date)this.pkRetainEndDate.getValue())) {
            throw new EmployeeException(EmployeeException.RETAINDATE_AFTER_RETAINENDDATE);
        }
        if (this.txtretainTerm.getNumberValue().floatValue() < 0.0f) {
            this.txtretainTerm.requestFocusInWindow();
            throw new EmployeeException(EmployeeException.NOTLESSZERO);
        }
    }

    @Override
    protected void pkCertifyDate_dataChanged(DataChangeEvent e) throws Exception {
        if (e.getNewValue() != null && this.pkcertifyUpToDate.getValue() != null) {
            this.txtPeriodValidity.setValue((Object)this.getDateDiff((Date)e.getNewValue(), (Date)this.pkcertifyUpToDate.getValue()));
        }
    }

    @Override
    protected void pkcertifyUpToDate_dataChanged(DataChangeEvent e) throws Exception {
        if (e.getNewValue() != null && this.pkCertifyDate.getValue() != null) {
            this.txtPeriodValidity.setValue((Object)this.getDateDiff((Date)this.pkCertifyDate.getValue(), (Date)e.getNewValue()));
        }
    }

    public Long getDateDiff(Date from, Date to) {
        return DateTimeUtils.dateDiff((Date)from, (Date)to) / 86400000L;
    }

    protected void handlePermissionForItemAction(ItemAction action) {
        if (this.getUIContext().get("NO_PERMISSION") == null) {
            super.handlePermissionForItemAction(action);
        }
    }
}

