/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.client;

import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.PositionHierarchyCollection;
import com.kingdee.eas.basedata.org.PositionHierarchyFactory;
import com.kingdee.eas.hr.emp.EmployeeCollectException;
import com.kingdee.eas.hr.emp.client.AbstractEmployeeCollectFilterNewUI;
import com.kingdee.eas.hr.emp.client.EmpCollNewFilterInfo;
import com.kingdee.eas.hr.emp.client.EmployeeClientUtils;
import com.kingdee.eas.hr.org.PersonFixedTimeFactory;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import org.apache.log4j.Logger;

public class EmployeeCollectFilterNewUI
extends AbstractEmployeeCollectFilterNewUI {
    private static final Logger logger = CoreUIObject.getLogger(EmployeeCollectFilterNewUI.class);
    public static final int PERIOD_TYPE_MONTH = 0;
    public static final int PERIOD_TYPE_QUARTER = 1;
    public static final int PERIOD_TYPE_YEAR = 2;
    public static final int PERIOD_TYPE_PERIOD = 3;
    public static final int ANALYSE_TYPE_LSTPERIOD = 0;
    public static final int ANALYSE_TYPE_LSTYEAR = 1;
    public static final int ANALYSE_TYPE_SPECYEAR = 2;
    private static final int MONTHS_OF_YEAR = 12;
    private static final int MONTHS_OF_HALFYEAR = 6;
    private static final int MONTHS_OF_QUARTER = 3;
    private boolean hasInit = false;
    private int objType = -1;

    public EmployeeCollectFilterNewUI() throws Exception {
        Color color = this.getBackground();
        this.pnlAnalyse.setBackground(color);
        this.pnlRange.setBackground(color);
        this.txtNumber.setDataType(0);
        this.txtNumber.setDataVerifierType(12);
        this.txtNumber.setMaximumValue((Comparable)new BigDecimal("99.99"));
        this.initDefaultSchema();
        this.comboRange.setEnabled(true);
        this.lblPeriod.setEnabled(true);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    private int[] getLevelByLongNumber(String longNumber, boolean isOrg) throws Exception {
        int[] datas = new int[2];
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT MAX(FLevel) AS MAX0, MIN(FLevel) AS MIN0 From ");
        if (isOrg) {
            sb.append("T_ORG_Admin");
        } else {
            sb.append("T_ORG_PositionHierarchy");
        }
        sb.append(" Where FLongNumber || '!' like '");
        sb.append(longNumber);
        sb.append("!%'");
        if (isOrg) {
            sb.append(" AND FControlUnitID in (SELECT FControlUnitID From T_Org_Admin where FLongNumber = '");
            sb.append(longNumber);
            sb.append("')");
        } else {
            sb.append(" AND FChildID IN (SELECT FID From T_Org_Position ");
            sb.append("WHERE FControlUnitID in (SELECT B.FControlUnitID FROM ");
            sb.append(" T_Org_PositionHierarchy A INNER JOIN T_Org_Position B ");
            sb.append(" ON A.FChildID = B.FID AND A.FLongNumber = '");
            sb.append(longNumber);
            sb.append("'))");
        }
        ISQLExecutor isql = SQLExecutorFactory.getRemoteInstance((String)sb.toString());
        IRowSet rows = isql.executeSQL();
        if (rows.next()) {
            datas[0] = rows.getInt("MAX0");
            datas[1] = rows.getInt("MIN0");
        }
        return datas;
    }

    private void queryRange_radioButtonClick() {
        if (!this.comboRange.isEnabled()) {
            this.comboRange.setEnabled(true);
            this.lblPeriod.setEnabled(true);
        }
        boolean enabled = false;
        if (this.btnMonth.isSelected()) {
            this.pkBeginDate.setEnabled(false);
            this.pkEndDate.setEnabled(false);
            this.lblTo.setEnabled(false);
            this.initInterval("MONTH");
        } else if (this.btnQuarter.isSelected()) {
            this.pkBeginDate.setEnabled(false);
            this.pkEndDate.setEnabled(false);
            this.lblTo.setEnabled(false);
            this.initInterval("QUARTER");
        } else if (this.btnYear.isSelected()) {
            this.pkBeginDate.setEnabled(false);
            this.pkEndDate.setEnabled(false);
            this.lblTo.setEnabled(false);
            this.initInterval("YEAR");
        } else if (this.btnPeriod.isSelected()) {
            this.pkBeginDate.setEnabled(true);
            this.pkEndDate.setEnabled(true);
            this.lblTo.setEnabled(true);
            this.initInterval("YEAR");
            enabled = true;
        }
        this.comboBeginYear.setEnabled(enabled);
        this.comboBeginMonth.setEnabled(enabled);
        this.comboEndYear.setEnabled(enabled);
        this.comboEndMonth.setEnabled(enabled);
        this.lblBeginYear.setEnabled(enabled);
        this.lblBeginMonth.setEnabled(enabled);
        this.lblEndYear.setEnabled(enabled);
        this.lblEndMonth.setEnabled(enabled);
    }

    private String getIntervalTypeByDate(Date beginDate, Date endDate) {
        int beginYear = DateTimeUtils.getYear((Date)beginDate);
        int endYear = DateTimeUtils.getYear((Date)endDate);
        int beginMonth = DateTimeUtils.getMonth((Date)beginDate);
        int endMonth = DateTimeUtils.getMonth((Date)endDate);
        int interval = (endYear - beginYear) * 12 + (endMonth - beginMonth);
        if (interval >= 11) {
            return "YEAR";
        }
        if (interval >= 5) {
            return "HALFYEAR";
        }
        if (interval >= 2) {
            return "QUARTER";
        }
        return "MONTH";
    }

    private void queryAnalyse_radioButtonClick() {
        if (this.btnLastPeriod.isSelected()) {
            this.txtNumber.setEnabled(false);
        } else if (this.btnLastYear.isSelected()) {
            this.txtNumber.setEnabled(false);
        } else if (this.btnSpecYear.isSelected()) {
            this.txtNumber.setEnabled(true);
        }
    }

    private void initInterval(String type) {
        DefaultComboBoxModel<IntvlType> model = new DefaultComboBoxModel<IntvlType>();
        if (type.endsWith("MONTH")) {
            model.addElement(new IntvlType("MONTH", EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.MONTH")));
        } else if (type.endsWith("QUARTER")) {
            model.addElement(new IntvlType("MONTH", EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.MONTH")));
            model.addElement(new IntvlType("QUARTER", EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.QUARTER")));
        } else if (type.endsWith("HALFYEAR")) {
            model.addElement(new IntvlType("MONTH", EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.MONTH")));
            model.addElement(new IntvlType("QUARTER", EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.QUARTER")));
            model.addElement(new IntvlType("HALFYEAR", EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.HALFYEAR")));
        } else if (type.endsWith("YEAR")) {
            model.addElement(new IntvlType("MONTH", EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.MONTH")));
            model.addElement(new IntvlType("QUARTER", EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.QUARTER")));
            model.addElement(new IntvlType("HALFYEAR", EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.HALFYEAR")));
            model.addElement(new IntvlType("YEAR", EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.YEAR")));
        }
        this.comboRange.setModel(model);
    }

    private boolean checkInput2() {
        if (!(this.btnMonth.isSelected() || this.btnQuarter.isSelected() || this.btnYear.isSelected() || this.btnPeriod.isSelected())) {
            MsgBox.showInfo((Component)((Object)this), (String)new EmployeeCollectException(EmployeeCollectException.RPT_NO_TIME_RANGE).getMessage());
            return false;
        }
        if (this.btnPeriod.isSelected()) {
            if (this.pkBeginDate.getValue() == null) {
                MsgBox.showInfo((Component)((Object)this), (String)new EmployeeCollectException(EmployeeCollectException.RPT_BEGNIDATE_NULL).getMessage());
                this.pkBeginDate.requestFocusInWindow();
                return false;
            }
            if ((Date)this.pkEndDate.getValue() == null) {
                MsgBox.showInfo((Component)((Object)this), (String)new EmployeeCollectException(EmployeeCollectException.RPT_ENDDATE_NULL).getMessage());
                this.pkEndDate.requestFocusInWindow();
                return false;
            }
            Date beginDate = (Date)this.pkBeginDate.getValue();
            Date endDate = (Date)this.pkEndDate.getValue();
            if (DateTimeUtils.dayBefore((Date)endDate, (Date)beginDate)) {
                MsgBox.showInfo((Component)((Object)this), (String)new EmployeeCollectException(EmployeeCollectException.RPT_BEGINDATE_GRATE_ENDDATE).getMessage());
                this.pkBeginDate.requestFocusInWindow();
                return false;
            }
        }
        if (this.comboRange.getSelectedItem() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)new EmployeeCollectException(EmployeeCollectException.RPT_NO_INTERVAL).getMessage());
            this.comboRange.requestFocusInWindow();
            return false;
        }
        if (this.chkAnalyse.isSelected() && !this.btnLastPeriod.isSelected() && !this.btnLastYear.isSelected() && !this.btnSpecYear.isSelected()) {
            MsgBox.showInfo((Component)((Object)this), (String)new EmployeeCollectException(EmployeeCollectException.RPT_NO_ANALYSETYPE).getMessage());
            this.btnLastPeriod.requestFocusInWindow();
            return false;
        }
        if (this.chkAnalyse.isSelected() && this.btnSpecYear.isSelected()) {
            String value = this.txtNumber.getText();
            if (value == null || value.equals("")) {
                MsgBox.showInfo((Component)((Object)this), (String)new EmployeeCollectException(EmployeeCollectException.RPT_INVALID_YEAR_NUM).getMessage());
                this.txtNumber.requestFocusInWindow();
                return false;
            }
            if (Integer.parseInt(value) <= 0) {
                MsgBox.showInfo((Component)((Object)this), (String)new EmployeeCollectException(EmployeeCollectException.RPT_INVALID_YEAR_NUM).getMessage());
                this.txtNumber.requestFocusInWindow();
                return false;
            }
        }
        return true;
    }

    private void checkInput() throws Exception {
        Integer value;
        if (!(this.btnMonth.isSelected() || this.btnQuarter.isSelected() || this.btnYear.isSelected() || this.btnPeriod.isSelected())) {
            throw new EmployeeCollectException(EmployeeCollectException.RPT_NO_TIME_RANGE);
        }
        if (this.btnPeriod.isSelected()) {
            Date beginDate = (Date)this.pkBeginDate.getValue();
            Date endDate = (Date)this.pkEndDate.getValue();
            if (DateTimeUtils.dayBefore((Date)endDate, (Date)beginDate)) {
                throw new EmployeeCollectException(EmployeeCollectException.RPT_BEGINDATE_GRATE_ENDDATE);
            }
        }
        if (this.comboRange.getSelectedItem() == null) {
            throw new EmployeeCollectException(EmployeeCollectException.RPT_NO_INTERVAL);
        }
        if (this.btnSpecYear.isSelected() && ((value = this.txtNumber.getIntegerValue()) == null || value <= 0)) {
            throw new EmployeeCollectException(EmployeeCollectException.RPT_INVALID_YEAR_NUM);
        }
    }

    @Override
    protected void btnMonth_actionPerformed(ActionEvent e) throws Exception {
        super.btnMonth_actionPerformed(e);
        this.queryRange_radioButtonClick();
    }

    @Override
    protected void btnPeriod_actionPerformed(ActionEvent e) throws Exception {
        super.btnPeriod_actionPerformed(e);
        this.queryRange_radioButtonClick();
    }

    @Override
    protected void btnQuarter_actionPerformed(ActionEvent e) throws Exception {
        super.btnQuarter_actionPerformed(e);
        this.queryRange_radioButtonClick();
    }

    @Override
    protected void btnYear_actionPerformed(ActionEvent e) throws Exception {
        super.btnYear_actionPerformed(e);
        this.queryRange_radioButtonClick();
    }

    @Override
    protected void btnLastPeriod_actionPerformed(ActionEvent e) throws Exception {
        super.btnLastPeriod_actionPerformed(e);
        this.queryAnalyse_radioButtonClick();
    }

    @Override
    protected void btnLastYear_actionPerformed(ActionEvent e) throws Exception {
        super.btnLastYear_actionPerformed(e);
        this.queryAnalyse_radioButtonClick();
    }

    @Override
    protected void btnSpecYear_actionPerformed(ActionEvent e) throws Exception {
        super.btnSpecYear_actionPerformed(e);
        this.queryAnalyse_radioButtonClick();
    }

    private void query_btnSpecYearClick() {
        if (this.btnSpecYear.isSelected()) {
            this.txtNumber.setEnabled(true);
        }
    }

    private void query_chkAnalyseClick() {
        if (this.chkAnalyse.isSelected()) {
            this.btnLastPeriod.setEnabled(true);
            this.btnLastYear.setEnabled(true);
            this.btnSpecYear.setEnabled(true);
            this.lblSpecYear.setEnabled(true);
            this.txtNumber.setEnabled(true);
        } else {
            this.btnLastPeriod.setEnabled(false);
            this.btnLastYear.setEnabled(false);
            this.btnSpecYear.setEnabled(false);
            this.lblSpecYear.setEnabled(false);
            this.txtNumber.setText(null);
            this.txtNumber.setEnabled(false);
        }
    }

    @Override
    protected void chkAnalyse_actionPerformed(ActionEvent e) throws Exception {
        super.chkAnalyse_actionPerformed(e);
        this.query_chkAnalyseClick();
    }

    public void onShow() throws Exception {
        super.onShow();
    }

    public void initDefaultSchema() throws Exception {
        if (!this.hasInit) {
            this.btnYear.setSelected(true);
            this.queryRange_radioButtonClick();
            int size = this.comboRange.getItemCount();
            for (int i = 0; i < size; ++i) {
                if (!((IntvlType)this.comboRange.getItemAt(i)).getValue().equals("QUARTER")) continue;
                this.comboRange.setSelectedIndex(i);
                break;
            }
            this.hasInit = true;
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        DefaultComboBoxModel modelA = new DefaultComboBoxModel();
        DefaultComboBoxModel modelB = new DefaultComboBoxModel();
        Set years = PersonFixedTimeFactory.getRemoteInstance().getYears();
        for (Object year : years) {
            modelA.addElement(year);
            modelB.addElement(year);
        }
        this.comboBeginYear.setModel(modelA);
        this.comboEndYear.setModel(modelB);
        modelA = new DefaultComboBoxModel();
        modelB = new DefaultComboBoxModel();
        for (int i = 1; i < 13; ++i) {
            Integer month = i;
            modelA.addElement(month);
            modelB.addElement(month);
        }
        this.comboBeginMonth.setModel(modelA);
        this.comboEndMonth.setModel(modelB);
    }

    protected void initListener() {
        super.initListener();
        ItemListener aListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                try {
                    EmployeeCollectFilterNewUI.this.combo_itemStateChanged(event, this);
                }
                catch (Exception ex) {
                    EmployeeCollectFilterNewUI.this.handUIException(ex);
                }
            }
        };
        this.comboBeginYear.addItemListener(aListener);
        this.comboBeginMonth.addItemListener(aListener);
        this.comboEndYear.addItemListener(aListener);
        this.comboEndMonth.addItemListener(aListener);
    }

    private void combo_itemStateChanged(ItemEvent event, ItemListener aListener) throws Exception {
        this.comboBeginYear.removeItemListener(aListener);
        this.comboBeginMonth.removeItemListener(aListener);
        this.comboEndYear.removeItemListener(aListener);
        this.comboEndMonth.removeItemListener(aListener);
        int beginYear = (Integer)this.comboBeginYear.getSelectedItem();
        int beginMonth = (Integer)this.comboBeginMonth.getSelectedItem();
        int endYear = (Integer)this.comboEndYear.getSelectedItem();
        int endMonth = (Integer)this.comboEndMonth.getSelectedItem();
        Object source = event.getSource();
        if (source == this.comboBeginYear || source == this.comboBeginMonth) {
            if (beginYear > endYear) {
                this.comboEndYear.setSelectedItem((Object)beginYear);
                if (beginMonth > endMonth) {
                    this.comboEndMonth.setSelectedItem((Object)beginMonth);
                }
            } else if (beginYear == endYear && beginMonth > endMonth) {
                this.comboEndMonth.setSelectedItem((Object)beginMonth);
            }
        } else if (source == this.comboEndYear || source == this.comboEndMonth) {
            if (beginYear > endYear) {
                this.comboBeginYear.setSelectedItem((Object)endYear);
                if (beginMonth > endMonth) {
                    this.comboBeginMonth.setSelectedItem((Object)endMonth);
                }
            } else if (beginYear == endYear && beginMonth > endMonth) {
                this.comboBeginMonth.setSelectedItem((Object)endMonth);
            }
        }
        this.comboBeginYear.addItemListener(aListener);
        this.comboBeginMonth.addItemListener(aListener);
        this.comboEndYear.addItemListener(aListener);
        this.comboEndMonth.addItemListener(aListener);
    }

    public void clear() {
        this.btnMonth.setSelected(false);
        this.btnQuarter.setSelected(false);
        this.btnYear.setSelected(false);
        this.btnPeriod.setSelected(false);
        this.pkBeginDate.setEnabled(false);
        this.pkEndDate.setEnabled(false);
        this.lblTo.setEnabled(false);
        this.lblPeriod.setEnabled(true);
        this.comboRange.setEnabled(true);
        this.chkAnalyse.setSelected(false);
        this.btnLastPeriod.setEnabled(false);
        this.btnLastPeriod.setSelected(false);
        this.btnLastYear.setEnabled(false);
        this.btnLastYear.setSelected(false);
        this.btnSpecYear.setEnabled(false);
        this.btnSpecYear.setSelected(false);
        this.txtNumber.setText(null);
        this.txtNumber.setEnabled(false);
    }

    public FilterInfo getFilterInfo() {
        return super.getFilterInfo();
    }

    public boolean verify() {
        return this.checkInput2();
    }

    public Object getParam() {
        HashMap<String, EmpCollNewFilterInfo> map = new HashMap<String, EmpCollNewFilterInfo>();
        map.put("qryFilter", this.getQryFilter());
        this.getUIContext().put("filterInfo", map.get("qryFilter"));
        return map;
    }

    public SorterItemCollection getSorterItems() {
        return super.getSorterItems();
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
    }

    private void setDatas(EmpCollNewFilterInfo qryFilter) throws Exception {
        switch (qryFilter.periodType) {
            case -1: {
                this.btnMonth.setSelected(false);
                this.btnQuarter.setSelected(false);
                this.btnYear.setSelected(false);
                this.btnPeriod.setSelected(false);
                break;
            }
            case 0: {
                this.btnMonth.setSelected(true);
                this.btnQuarter.setSelected(false);
                this.btnYear.setSelected(false);
                this.btnPeriod.setSelected(false);
                break;
            }
            case 1: {
                this.btnMonth.setSelected(false);
                this.btnQuarter.setSelected(true);
                this.btnYear.setSelected(false);
                this.btnPeriod.setSelected(false);
                break;
            }
            case 2: {
                this.btnMonth.setSelected(false);
                this.btnQuarter.setSelected(false);
                this.btnYear.setSelected(true);
                this.btnPeriod.setSelected(false);
                break;
            }
            case 3: {
                this.btnMonth.setSelected(false);
                this.btnQuarter.setSelected(false);
                this.btnYear.setSelected(false);
                this.btnPeriod.setSelected(true);
            }
        }
        this.pkBeginDate.setValue((Object)qryFilter.ctrlBeginDate);
        this.pkEndDate.setValue((Object)qryFilter.ctrlEndDate);
        this.setYearAndMonth(qryFilter);
        this.queryRange_radioButtonClick();
        if (qryFilter.intervalType != null) {
            int size = this.comboRange.getItemCount();
            for (int i = 0; i < size; ++i) {
                if (!((IntvlType)this.comboRange.getItemAt(i)).getValue().equals(qryFilter.intervalType)) continue;
                this.comboRange.setSelectedIndex(i);
                break;
            }
        } else {
            this.comboRange.setSelectedItem(null);
        }
        if (qryFilter.isAnalyse) {
            this.chkAnalyse.setSelected(true);
        } else {
            this.chkAnalyse.setSelected(false);
        }
        this.query_chkAnalyseClick();
        if (this.chkAnalyse.isSelected()) {
            switch (qryFilter.analyseType) {
                case 0: {
                    this.btnLastPeriod.setSelected(true);
                    this.btnLastYear.setSelected(false);
                    this.btnSpecYear.setSelected(false);
                    break;
                }
                case 1: {
                    this.btnLastPeriod.setSelected(false);
                    this.btnLastYear.setSelected(true);
                    this.btnSpecYear.setSelected(false);
                    break;
                }
                case 2: {
                    this.btnLastPeriod.setSelected(false);
                    this.btnLastYear.setSelected(false);
                    this.btnSpecYear.setSelected(true);
                    this.query_btnSpecYearClick();
                    this.txtNumber.setText(String.valueOf(qryFilter.numberOfYears));
                }
            }
        }
    }

    private void setYearAndMonth(EmpCollNewFilterInfo qryFilter) {
        Date beginDate = qryFilter.beginDate;
        Date endDate = qryFilter.endDate;
        int beginYear = DateTimeUtils.getYear((Date)beginDate);
        int endYear = DateTimeUtils.getYear((Date)endDate);
        int beginMonth = DateTimeUtils.getMonth((Date)beginDate);
        int endMonth = DateTimeUtils.getMonth((Date)endDate);
        this.comboBeginYear.setSelectedItem((Object)beginYear);
        this.comboBeginMonth.setSelectedItem((Object)beginMonth);
        this.comboEndYear.setSelectedItem((Object)endYear);
        this.comboEndMonth.setSelectedItem((Object)endMonth);
    }

    public void setParam(Object param) {
        if (param == null) {
            try {
                this.initDefaultSchema();
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        } else {
            HashMap map = (HashMap)param;
            EmpCollNewFilterInfo qryFilter = (EmpCollNewFilterInfo)map.get("qryFilter");
            try {
                this.setDatas(qryFilter);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    private Date[] getDates(EmpCollNewFilterInfo qryFilter) {
        int periodType = qryFilter.periodType;
        Date[] dates = new Date[2];
        if (periodType != -1) {
            Date today = new Date();
            String intvlType = null;
            if (this.comboRange.getSelectedItem() != null) {
                intvlType = ((IntvlType)this.comboRange.getSelectedItem()).getValue();
            }
            if (periodType != 3) {
                if (periodType == 2) {
                    dates[0] = new Date(today.getYear(), 0, 1);
                    dates[1] = new Date(today.getYear(), 11, 31);
                } else if (periodType == 1) {
                    int quarter = DateTimeUtils.getQuarter((Date)today);
                    dates[0] = new Date(today.getYear(), 3 * (quarter - 1), 1);
                    dates[1] = quarter == 4 ? DateTimeUtils.addDay((Date)new Date(today.getYear() + 1, 0, 1), (long)-1L) : DateTimeUtils.addDay((Date)new Date(today.getYear(), dates[0].getMonth() + 3, 1), (long)-1L);
                } else if (periodType == 0) {
                    dates[0] = new Date(today.getYear(), today.getMonth(), 1);
                    int month = today.getMonth();
                    dates[1] = month == 11 ? DateTimeUtils.addDay((Date)new Date(today.getYear() + 1, 0, 1), (long)-1L) : DateTimeUtils.addDay((Date)new Date(today.getYear(), month + 1, 1), (long)-1L);
                }
            } else {
                Calendar calendar = Calendar.getInstance();
                calendar.set(5, 1);
                if (this.comboBeginYear.getSelectedItem() != null) {
                    calendar.set(1, (Integer)this.comboBeginYear.getSelectedItem());
                } else {
                    calendar.set(1, qryFilter.ctrlBeginDate.getYear() + 1900);
                }
                if (this.comboBeginMonth.getSelectedItem() != null) {
                    calendar.set(2, (Integer)this.comboBeginMonth.getSelectedItem() - 1);
                } else {
                    calendar.set(2, qryFilter.ctrlBeginDate.getMonth());
                }
                Date beginDate = calendar.getTime();
                if (this.comboEndYear.getSelectedItem() != null) {
                    calendar.set(1, (Integer)this.comboEndYear.getSelectedItem());
                } else {
                    calendar.set(1, qryFilter.ctrlEndDate.getYear() + 1900);
                }
                if (this.comboEndMonth.getSelectedItem() != null) {
                    calendar.set(2, (Integer)this.comboEndMonth.getSelectedItem() - 1);
                } else {
                    calendar.set(2, qryFilter.ctrlEndDate.getMonth());
                }
                Date endDate = calendar.getTime();
                if (intvlType.equals("YEAR")) {
                    dates[0] = new Date(beginDate.getYear(), 0, 1);
                    dates[1] = new Date(endDate.getYear(), 11, 31);
                } else if (intvlType.equals("QUARTER")) {
                    int qrtrBegin = DateTimeUtils.getQuarter((Date)beginDate);
                    int qrtrEnd = DateTimeUtils.getQuarter((Date)endDate);
                    dates[0] = new Date(beginDate.getYear(), 3 * (qrtrBegin - 1), 1);
                    dates[1] = qrtrEnd == 4 ? DateTimeUtils.addDay((Date)new Date(endDate.getYear() + 1, 0, 1), (long)-1L) : DateTimeUtils.addDay((Date)new Date(endDate.getYear(), 3 * qrtrEnd, 1), (long)-1L);
                } else if (intvlType.equals("MONTH")) {
                    dates[0] = new Date(beginDate.getYear(), beginDate.getMonth(), 1);
                    int month = endDate.getMonth();
                    dates[1] = month == 11 ? DateTimeUtils.addDay((Date)new Date(endDate.getYear() + 1, 0, 1), (long)-1L) : DateTimeUtils.addDay((Date)new Date(endDate.getYear(), month + 1, 1), (long)-1L);
                } else if (intvlType.equals("HALFYEAR")) {
                    int hlfYrBegin = EmployeeClientUtils.getHalfYear(DateTimeUtils.getQuarter((Date)beginDate));
                    int hlfYrEnd = EmployeeClientUtils.getHalfYear(DateTimeUtils.getQuarter((Date)endDate));
                    dates[0] = new Date(beginDate.getYear(), 6 * (hlfYrBegin - 1), 1);
                    dates[1] = hlfYrEnd == 2 ? DateTimeUtils.addDay((Date)new Date(endDate.getYear() + 1, 0, 1), (long)-1L) : DateTimeUtils.addDay((Date)new Date(endDate.getYear(), 6 * hlfYrEnd, 1), (long)-1L);
                }
            }
        } else {
            dates[0] = (Date)this.pkBeginDate.getValue();
            dates[1] = (Date)this.pkEndDate.getValue();
        }
        dates[1] = DateTimeUtils.addSecond((Date)DateTimeUtils.addDay((Date)dates[1], (long)1L), (long)-1L);
        return dates;
    }

    public EmpCollNewFilterInfo getQryFilter() {
        EmpCollNewFilterInfo qryFilter = new EmpCollNewFilterInfo();
        qryFilter.ctrlBeginDate = (Date)this.pkBeginDate.getValue();
        qryFilter.ctrlEndDate = (Date)this.pkEndDate.getValue();
        qryFilter.periodType = this.btnMonth.isSelected() ? 0 : (this.btnYear.isSelected() ? 2 : (this.btnQuarter.isSelected() ? 1 : (this.btnPeriod.isSelected() ? 3 : -1)));
        Date[] dates = this.getDates(qryFilter);
        qryFilter.beginDate = dates[0];
        qryFilter.endDate = dates[1];
        qryFilter.ctrlBeginDate = dates[0];
        qryFilter.ctrlEndDate = dates[1];
        IntvlType intervalType = (IntvlType)this.comboRange.getSelectedItem();
        qryFilter.intervalType = intervalType == null ? "QUARTER" : intervalType.getValue();
        qryFilter.isAnalyse = this.chkAnalyse.isSelected();
        if (this.chkAnalyse.isSelected()) {
            if (this.btnLastPeriod.isSelected()) {
                qryFilter.analyseType = 0;
            } else if (this.btnLastYear.isSelected()) {
                qryFilter.analyseType = 1;
            } else if (this.btnSpecYear.isSelected()) {
                qryFilter.analyseType = 2;
                qryFilter.numberOfYears = Integer.parseInt(this.txtNumber.getText());
            } else {
                qryFilter.analyseType = -1;
            }
        }
        return qryFilter;
    }

    @Override
    protected void pkBeginDate_dataChanged(DataChangeEvent e) throws Exception {
        super.pkBeginDate_dataChanged(e);
        if (this.pkBeginDate.getValue() == null) {
            return;
        }
        this.initInterval(this.getIntervalTypeByDate((Date)this.pkBeginDate.getValue(), (Date)this.pkEndDate.getValue()));
    }

    @Override
    protected void pkEndDate_dataChanged(DataChangeEvent e) throws Exception {
        super.pkEndDate_dataChanged(e);
        if (this.pkEndDate.getValue() == null) {
            return;
        }
        this.initInterval(this.getIntervalTypeByDate((Date)this.pkBeginDate.getValue(), (Date)this.pkEndDate.getValue()));
    }

    private String getLNumById(String id) throws Exception {
        PositionHierarchyCollection c = PositionHierarchyFactory.getRemoteInstance().getPositionHierarchyCollection("select longNumber where child.id = '" + id + "'");
        if (c.size() > 0) {
            return c.get(0).getLongNumber();
        }
        return null;
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        if (cp == null) {
            try {
                this.initDefaultSchema();
            }
            catch (Exception e) {
                this.handUIException(e);
            }
            return;
        }
        EmpCollNewFilterInfo filterInfo = new EmpCollNewFilterInfo();
        filterInfo.periodType = cp.getInt("periodType");
        filterInfo.analyseType = cp.getInt("analyseType");
        filterInfo.numberOfYears = cp.getInt("numberOfYears");
        filterInfo.beginDate = cp.getDate("beginDate");
        filterInfo.endDate = cp.getDate("endDate");
        filterInfo.ctrlBeginDate = cp.getDate("ctrlBeginDate");
        filterInfo.ctrlEndDate = cp.getDate("ctrlEndDate");
        filterInfo.isAnalyse = cp.getBoolean("isAnalyse");
        filterInfo.isCaculatePercent = cp.getBoolean("isCaculatePercent");
        filterInfo.isIncludeSubCUs = cp.getBoolean("isIncludeSubCUs");
        filterInfo.intervalType = cp.getCustomerParam("intervalType");
        try {
            this.setDatas(filterInfo);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    public CustomerParams getCustomerParams() {
        CustomerParams params = new CustomerParams();
        EmpCollNewFilterInfo filterInfo = this.getQryFilter();
        params.putInt("periodType", filterInfo.periodType);
        params.addCustomerParam("intervalType", filterInfo.intervalType);
        params.putDate("beginDate", filterInfo.beginDate);
        params.putDate("endDate", filterInfo.endDate);
        params.putDate("ctrlBeginDate", filterInfo.ctrlBeginDate);
        params.putDate("ctrlEndDate", filterInfo.ctrlEndDate);
        params.putBoolean("isAnalyse", filterInfo.isAnalyse);
        params.putInt("analyseType", filterInfo.analyseType);
        params.putInt("numberOfYears", filterInfo.numberOfYears);
        params.putBoolean("isCaculatePercent", filterInfo.isCaculatePercent);
        params.putBoolean("isIncludeSubCUs", filterInfo.isIncludeSubCUs);
        return params;
    }

    private static class IntvlType {
        String _value;
        String _alias;

        public IntvlType(String value, String alias) {
            this._value = value;
            this._alias = alias;
        }

        public String getValue() {
            return this._value;
        }

        public String getAlias() {
            return this._alias;
        }

        public String toString() {
            return this._alias;
        }
    }
}

