/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.base.client.ListEditUI;
import com.kingdee.eas.hr.competmodel.CompetIndexGradeCollection;
import com.kingdee.eas.hr.competmodel.CompetIndexGradeFactory;
import com.kingdee.eas.hr.competmodel.CompetIndexGradeInfo2;
import com.kingdee.eas.hr.competmodel.CompetenceIndexInfo;
import com.kingdee.eas.hr.competmodel.CompetenceIndexTypeFactory;
import com.kingdee.eas.hr.competmodel.CompetenceIndexTypeInfo;
import com.kingdee.eas.hr.competmodel.ICompetIndexGrade;
import com.kingdee.eas.hr.competmodel.client.CompetModelF7PromptBox;
import com.kingdee.eas.hr.emp.EmployeeCompetIndexCollection;
import com.kingdee.eas.hr.emp.EmployeeCompetIndexFactory;
import com.kingdee.eas.hr.emp.IEmployeeCompetIndex;
import com.kingdee.eas.hr.emp.client.AbstractEmployeeCompetIndexUI;
import com.kingdee.eas.hr.emp.client.EmployeeClientUtils;
import com.kingdee.eas.hr.emp.client.IEmpInfoUI;
import com.kingdee.eas.hr.org.JobException;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;

public class EmployeeCompetIndexUI
extends AbstractEmployeeCompetIndexUI
implements IEmpInfoUI {
    private String empId = null;
    private PersonInfo pInfo = null;
    private ArrayList delList = new ArrayList();
    KDComboBox cboCIG = null;
    int rowID = 0;

    private void checkInput() throws Exception {
        int length = this.tblMain.getRowCount();
        Object competIndexGradeInfo = null;
        EmployeeClientUtils.checkTableCellIsNull(this.tblMain, "competIndex");
        for (int j = 0; j < length; ++j) {
            competIndexGradeInfo = this.tblMain.getRow(j).getCell("competLevel").getValue();
            if (competIndexGradeInfo != null) continue;
            throw new JobException(JobException.NO_SET_INDEXGRADE);
        }
    }

    @Override
    public void submit() throws Exception {
        this.checkInput();
        IObjectPK[] delArray = new IObjectPK[this.delList.size()];
        for (int i = 0; i < this.delList.size(); ++i) {
            delArray[i] = new ObjectUuidPK((BOSUuid)this.delList.get(i));
        }
        IEmployeeCompetIndex ipd = EmployeeCompetIndexFactory.getRemoteInstance();
        ipd.saveAll(EmployeeClientUtils.getDCompetIndexCollectionByKDTable(this.tblMain, EmployeeClientUtils.getPersonInfo(this.empId)), delArray);
        ListEditUI listEditUI = (ListEditUI)this.getUIContext().get("ListEditUI");
        listEditUI.setStatusBarMessage();
        this.refresh();
    }

    public void firstOnLoad() throws Exception {
        this.refresh();
    }

    @Override
    public void secondLoad() throws Exception {
        this.firstOnLoad();
    }

    public void onLoad() throws Exception {
        this.empId = (String)this.getUIContext().get("ID");
        super.onLoad();
        EmployeeClientUtils.initTableBtn((JButton)this.btnInsert, (JButton)this.btnDelete);
        this.tblMain.checkParsed();
        this.setTableCellEditor();
        this.btnDelete.setEnabled(true);
        if (this.getOprtState().equals(OprtState.VIEW)) {
            EmployeeClientUtils.setKDTableViewState(this.tblMain);
            this.btnInsert.setEnabled(false);
            this.btnDelete.setEnabled(false);
        }
        EmployeeClientUtils.setColumnBackColor(this.tblMain, "competIndex");
        this.firstOnLoad();
        this.tblMain.getColumn("competType").getStyleAttributes().setLocked(true);
        this.tblMain.getStyleAttributes().setWrapText(true);
        this.tblMain.getStyleAttributes().setVerticalAlign(Styles.VerticalAlignment.TOP);
        EmployeeClientUtils.setCellEditor(this.tblMain, "describle");
        if (this.getUIContext().get("ListEditUI") == null) {
            this.btnFirst.setVisible(false);
            this.btnPre.setVisible(false);
            this.btnNext.setVisible(false);
            this.btnLast.setVisible(false);
        }
    }

    private void setTableCellEditor() throws BOSException {
        this.initCompetIndexTable();
    }

    private void initCompetIndexTable() {
        this.cboCIG = new KDComboBox();
        this.cboCIG.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    CompetIndexGradeInfo2 info = (CompetIndexGradeInfo2)e.getItem();
                    EmployeeCompetIndexUI.this.tblMain.getRow(EmployeeCompetIndexUI.this.rowID).getCell("describle").setValue((Object)info.cigInfo.getDescription());
                }
            }
        });
        this.tblMain.getColumn("competLevel").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)this.cboCIG));
        KDBizPromptBox box = new KDBizPromptBox();
        box.setSelector((KDPromptSelector)new CompetModelF7PromptBox((IUIObject)this));
        box.addPreChangeListener(new PreChangeListener(){

            public void preChange(PreChangeEvent e) {
                try {
                    EmployeeCompetIndexUI.this.initComboBox(e);
                }
                catch (Exception e1) {
                    ExceptionHandler.handle((Throwable)e1);
                }
            }
        });
        this.tblMain.getColumn("competIndex").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)box));
        this.tblMain.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStarting(KDTEditEvent e) {
                EmployeeCompetIndexUI.this.rowID = e.getRowIndex();
                try {
                    if (e.getColIndex() == 3) {
                        Object obj = EmployeeCompetIndexUI.this.tblMain.getRow(EmployeeCompetIndexUI.this.rowID).getCell("competIndex").getValue();
                        if (obj != null) {
                            EmployeeCompetIndexUI.this.loadComboBoxData((CompetenceIndexInfo)obj);
                        } else {
                            EmployeeCompetIndexUI.this.cboCIG.removeAllItems();
                        }
                    }
                }
                catch (Exception e1) {
                    ExceptionHandler.handle((Throwable)e1);
                }
            }
        });
    }

    protected void initComboBox(PreChangeEvent e) throws Exception {
        if (e.getData() != null) {
            CompetenceIndexInfo ciInfo = (CompetenceIndexInfo)e.getData();
            CompetenceIndexTypeInfo citInfo = CompetenceIndexTypeFactory.getRemoteInstance().getCompetenceIndexTypeInfo((IObjectPK)new ObjectUuidPK(ciInfo.getType().getId()));
            this.tblMain.getRow(this.rowID).getCell("competType").setValue((Object)citInfo);
            CompetenceIndexInfo oldValue = (CompetenceIndexInfo)e.getOldData();
            if (oldValue != null && ciInfo.getId().toString().equals(oldValue.getId().toString())) {
                return;
            }
            this.loadComboBoxData(ciInfo);
        } else {
            this.cboCIG.removeAllItems();
            this.tblMain.getRow(this.rowID).getCell("competType").setValue(null);
            this.tblMain.getRow(this.rowID).getCell("competLevel").setValue(null);
            this.tblMain.getRow(this.rowID).getCell("describle").setValue(null);
        }
    }

    private void loadComboBoxData(CompetenceIndexInfo ciInfo) throws Exception {
        this.cboCIG.removeAllItems();
        ICompetIndexGrade iCIP = CompetIndexGradeFactory.getRemoteInstance();
        CompetIndexGradeCollection cigColl = iCIP.getCompetIndexGradeCollection("select id,description,competIndex.id,competIndex.name,competIndex.number,competIndex.descriptioncompetIndex.type.id,competIndex.hrOrgUnit.id,indexGrade.id,indexGrade.name,indexGrade.number,indexGrade.index,indexGrade.description,indexGrade.hrOrgUnit.id where competIndex='" + ciInfo.getId() + "'");
        int size = cigColl.size();
        for (int i = 0; i < size; ++i) {
            this.cboCIG.addItem((Object)new CompetIndexGradeInfo2(cigColl.get(i)));
        }
        if (this.cboCIG.getItemCount() > 0) {
            this.cboCIG.setSelectedIndex(0);
            CompetIndexGradeInfo2 info = (CompetIndexGradeInfo2)this.cboCIG.getSelectedItem();
            this.tblMain.getRow(this.rowID).getCell("competLevel").setValue((Object)info);
            this.tblMain.getRow(this.rowID).getCell("describle").setValue((Object)info.cigInfo.getDescription());
        }
    }

    private EmployeeCompetIndexCollection getPDColl(String empId) throws BOSException {
        IEmployeeCompetIndex ipd = EmployeeCompetIndexFactory.getRemoteInstance();
        String strQl = "select *,empCompetIndex.*,empCompetIndex.type.*,indexGrade.*,indexGrade.indexGrade.* where person.id='" + empId + "'";
        return ipd.getEmployeeCompetIndexCollection(strQl);
    }

    private void loadEmployeeCompetIndex() throws Exception {
        if (this.getUIContext().get("ID") != null) {
            this.empId = this.getUIContext().get("ID").toString();
        }
        EmployeeCompetIndexCollection c = this.getPDColl(this.empId);
        IRow row = null;
        for (int i = 0; i < c.size(); ++i) {
            row = this.tblMain.addRow();
            row.setHeight(50);
            EmployeeClientUtils.setTableCellValueByInfo(row, c.get(i));
        }
    }

    private void refresh() throws Exception {
        this.tblMain.removeRows();
        this.loadEmployeeCompetIndex();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        try {
            this.refresh();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionDelete_actionPerformed(ActionEvent e) throws Exception {
        super.actionDelete_actionPerformed(e);
        EmployeeClientUtils.deleteKDTableRow(this.tblMain, this.delList);
    }

    @Override
    public void actionInsert_actionPerformed(ActionEvent e) throws Exception {
        super.actionInsert_actionPerformed(e);
        int rowCount = this.tblMain.getRowCount();
        IRow row = this.tblMain.addRow();
        row.setHeight(50);
        this.tblMain.getEditManager().editCellAt(rowCount, 0, true);
    }

    @Override
    public void setAddNewState() throws Exception {
        EmployeeClientUtils.setAddNewState((CoreUI)this);
        this.refresh();
    }

    @Override
    public void setEmpID(String empId) {
        this.empId = empId;
    }

    @Override
    public void setEnabled(boolean isArchives) {
        if (!isArchives) {
            this.tblMain.setEnabled(false);
            this.btnInsert.setEnabled(false);
            this.btnDelete.setEnabled(false);
        }
    }

    protected IObjectValue createNewData() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.submit();
    }

    protected void inOnload() throws Exception {
    }
}

