/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMenuManager;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.ResourceBundleHelper;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.monitor.client.BasicWorkFlowMonitorPanel;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.attachment.common.AttachmentClientManager;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.commonquery.DynQuerySelectFieldCollection;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.commonquery.client.IPromptBoxFactory;
import com.kingdee.eas.base.commonquery.client.Util;
import com.kingdee.eas.base.core.client.GetDataDialog;
import com.kingdee.eas.base.core.client.GetDataTaskAdapter;
import com.kingdee.eas.base.core.hr.util.HRParamUtil;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.HROrgUnitFactory;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.AbstractListUI;
import com.kingdee.eas.framework.client.commonquery.DynamicQueryUtil;
import com.kingdee.eas.framework.client.context.IDelegationSupport;
import com.kingdee.eas.framework.client.context.IMultiOrgSupport;
import com.kingdee.eas.framework.client.workflow.IWorkflowUIEnhancement;
import com.kingdee.eas.framework.client.workflow.IWorkflowUISupport;
import com.kingdee.eas.hr.base.HRCommonException;
import com.kingdee.eas.hr.base.HROrgContextManagerFacadeFactory;
import com.kingdee.eas.hr.base.OutputExcelUtil;
import com.kingdee.eas.hr.base.client.ContractHROrgContextPromptBoxFactory;
import com.kingdee.eas.hr.base.util.HRUtil;
import com.kingdee.eas.hr.compensation.util.HRUtils;
import com.kingdee.eas.hr.emp.ContractWFStateEnum;
import com.kingdee.eas.hr.emp.EmployeeContractFactory;
import com.kingdee.eas.hr.emp.EmployeeContractInfo;
import com.kingdee.eas.hr.emp.EmployeeException;
import com.kingdee.eas.hr.emp.IEmployeeContract;
import com.kingdee.eas.hr.emp.client.AbstractEmployeeContractListUI;
import com.kingdee.eas.hr.emp.client.BatchContractEditUI;
import com.kingdee.eas.hr.emp.client.BatchWizardUI;
import com.kingdee.eas.hr.emp.client.ContractLimitTypeUpdateUI;
import com.kingdee.eas.hr.emp.client.ContractState;
import com.kingdee.eas.hr.emp.client.EmployeeClientUtils;
import com.kingdee.eas.hr.emp.client.EmployeeContractCustFilterPanel;
import com.kingdee.eas.hr.emp.client.EmployeeContractEditUI;
import com.kingdee.eas.hr.emp.client.EmployeeContractNoRecordUI;
import com.kingdee.eas.hr.emp.client.EmployeeContractQueryFilterPanelUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ComponentUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class EmployeeContractListUI
extends AbstractEmployeeContractListUI
implements IDelegationSupport {
    private static Logger logger = Logger.getLogger(EmployeeContractListUI.class);
    private String state = null;
    private boolean isReport = false;
    private boolean isFirstDefaultQuery = true;
    private CommonQueryDialog commonQueryDialog = null;
    boolean isZTCustomer = EmployeeContractFactory.getRemoteInstance().isZhongTianCustomer();
    private ActionEvent actionEvent = null;
    private boolean blHasHisBatchProcess = false;
    private boolean isContractAllHR = false;
    private boolean includeSealUp = false;

    public EmployeeContractListUI() throws Exception {
        this.tblMain.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (512 == e.getModifiersEx() && e.getKeyCode() == 85) {
                    try {
                        UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ContractLimitTypeUpdateUI.class.getName(), (Map)new UIContext((Object)this), null, OprtState.VIEW).show();
                        EmployeeContractListUI.this.actionRefresh_actionPerformed(null);
                    }
                    catch (Exception e1) {
                        EmployeeContractListUI.this.handleException(e1);
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
    }

    public void onLoad() throws Exception {
        this.isContractAllHR = HRParamUtil.getParamOfHR(null, (String)"IS_CONTRACT_ALLHR", null);
        super.onLoad();
        this.tblMain.setColumnMoveable(true);
        HRUtils.removeLintMenu((KDTable)this.tblMain, (KDTMenuManager)this.getMenuManager(this.tblMain));
        HashMap map = (HashMap)this.getUIContext();
        if (map.get("UIClassParam") != null && map.get("UIClassParam").equals("report")) {
            this.isReport = true;
            this.menuItemEdit.setVisible(false);
            this.menuItemAddNew.setVisible(false);
            this.menuItemRemove.setVisible(false);
            this.menuItemView.setVisible(false);
            this.menuEdit.setVisible(false);
            this.actionEdit.setEnabled(false);
            this.actionAddNew.setEnabled(false);
            this.actionRemove.setEnabled(false);
            this.actionView.setEnabled(false);
            this.initReportToolBarButtonProperty();
            this.setUITitle(EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.EMPLOYEECONTRACTREPORT"));
        } else {
            this.actionOutputExcel.setVisible(false);
        }
        if (this.tblMain.getColumn("createTime") != null) {
            this.tblMain.getColumn("createTime").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
        }
        this.btnAttachment.setVisible(true);
        this.btnAttachment.setEnabled(true);
    }

    protected String[] getLocateNames() {
        String[] locateNames = new String[]{"empName", "empNumber"};
        return locateNames;
    }

    private void showAttachmentIcon() {
        long st = System.currentTimeMillis();
        logger.info((Object)("***** Begin ShowAttachmentIcon: " + (System.currentTimeMillis() - st) + " ms"));
        int count = this.tblMain.getRowCount();
        for (int i = 0; i < count; ++i) {
            IRow row = this.tblMain.getRow(i);
            if (row.getCell("attachmentId").getValue() == null) continue;
            row.getCell("attachmentIcon").setValue((Object)EASResource.getIcon((String)"imgTbtn_affixmanage"));
        }
        logger.info((Object)("***** End ShowAttachmentIcon: " + (System.currentTimeMillis() - st) + " ms"));
    }

    protected void checkQueryPK() {
        this.setHasQyeryPK(true);
    }

    void initReportToolBarButtonProperty() {
        this.actionAddNew.setVisible(false);
        this.actionEdit.setVisible(false);
        this.actionRemove.setVisible(false);
        this.actionEnd.setVisible(false);
        this.actionBlockAddNew.setVisible(false);
        this.actionFree.setVisible(false);
        this.actionLocate.setVisible(false);
        this.actionChange.setVisible(false);
        this.actionResume.setVisible(false);
        this.actionRecord.setVisible(false);
        this.actionNoRecord.setVisible(false);
        this.actionBatchProcess.setVisible(false);
        this.menuBiz.setVisible(false);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.menuItemImportData.setVisible(false);
        this.btnBlockAddNew.setIcon(EASResource.getIcon((String)"imgTbtn_newbatch"));
        this.btnRecord.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.btnResume.setIcon(EASResource.getIcon((String)"imgTbtn_pagesetting"));
        this.btnChange.setIcon(EASResource.getIcon((String)"imgTbtn_assetchange"));
        this.btnEnd.setIcon(EASResource.getIcon((String)"imgTbtn_forbid"));
        this.btnFree.setIcon(EASResource.getIcon((String)"imgTbtn_ffreeze"));
        this.btnDownload.setIcon(EASResource.getIcon((String)"imgTbtn_affixmanage"));
        this.btnOutputExcel.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.menuItemBlackAddNew.setIcon(EASResource.getIcon((String)"imgTbtn_newbatch"));
        this.menuItemRecord.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.menuItemResume.setIcon(EASResource.getIcon((String)"imgTbtn_pagesetting"));
        this.menuItemChange.setIcon(EASResource.getIcon((String)"imgTbtn_assetchange"));
        this.menuItemEnd.setIcon(EASResource.getIcon((String)"imgTbtn_forbid"));
        this.menuItemFree.setIcon(EASResource.getIcon((String)"imgTbtn_ffreeze"));
        this.menuItemDownload.setIcon(EASResource.getIcon((String)"imgTbtn_affixmanage"));
        this.menuItemNoRecord.setIcon(EASResource.getIcon((String)"imgTbtn_nocollate"));
        this.menuItemBatchProcess.setIcon(EASResource.getIcon((String)"imgTbtn_approvebatch"));
        this.btnNotRecord.setIcon(EASResource.getIcon((String)"imgTbtn_nocollate"));
        this.btnBatchProcess.setIcon(EASResource.getIcon((String)"imgTbtn_approvebatch"));
        this.resHelper = new ResourceBundleHelper(AbstractListUI.class.getName());
        this.menuItemExportData.setText(this.resHelper.getString("menuItemExportData.text"));
        this.menuItemExportData.setToolTipText(this.resHelper.getString("menuItemExportData.toolTipText"));
        this.menuItemExportData.setVisible(true);
        this.menuItemExportData.setMnemonic(69);
        this.menuItemCancel.setMnemonic('A');
        this.menuItemEnd.setMnemonic(67);
        this.btnWorkFlowG.setIcon(EASResource.getIcon((String)"imgTbtn_flowchart"));
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected String getEditUIName() {
        return EmployeeContractEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return EmployeeContractFactory.getRemoteInstance();
    }

    public CommonQueryDialog getDialog() {
        return this.commonQueryDialog;
    }

    @Override
    public void actionBlockAddNew_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiCtx = new UIContext((Object)this);
        if (this.getUIContext().get(this.getMainBizOrgType()) != null) {
            uiCtx.put((Object)"getCurrentHRO", this.getUIContext().get(this.getMainBizOrgType()));
        }
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BatchWizardUI.class.getName(), (Map)uiCtx, null, OprtState.ADDNEW);
        uiWindow.show();
        GetDataDialog dlg = null;
        Window owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        Window ownerWindow = ComponentUtil.getOwnerWindow((Component)owner);
        dlg = ownerWindow instanceof Frame ? new GetDataDialog((Frame)ownerWindow) : (ownerWindow instanceof Dialog ? new GetDataDialog((Dialog)ownerWindow) : new GetDataDialog((Frame)null));
        dlg.setGetDataTask(new GetDataTaskAdapter(){

            public Object exec() throws Exception {
                EmployeeContractListUI.this.tblMain.removeRows();
                return null;
            }
        });
        dlg.show();
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        this.performCommonQuery();
    }

    public void actionEdit_actionPerformed(ActionEvent arg0) throws Exception {
        int selectState = this.getSelectedContractState();
        if (selectState != 0 && selectState != -1 && selectState != 10) {
            throw new EmployeeException(EmployeeException.EMPLOYEECONTRACT_CANNOT_EDIT_ATRECORDED);
        }
        super.actionEdit_actionPerformed(arg0);
    }

    private int getSelectedContractState() {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (selectRows.length > 0) {
            Integer state = (Integer)this.tblMain.getRow(selectRows[0]).getCell("state").getValue();
            if (state == null) {
                state = -1;
            }
            return state;
        }
        return -1;
    }

    private void setToolButtonProperties() throws BOSException, EASBizException {
        String empContractID = this.getSelectedKeyValue();
        IEmployeeContract iEmp = EmployeeContractFactory.getRemoteInstance();
        int selectState = iEmp.getEmpContractStateValue(empContractID);
        if (selectState == 0) {
            this.btnEdit.setEnabled(true);
            this.btnRecord.setEnabled(true);
            this.btnChange.setEnabled(false);
            this.btnResume.setEnabled(false);
            this.btnFree.setEnabled(false);
            this.btnEnd.setEnabled(false);
        } else if (selectState == 1) {
            this.btnEdit.setEnabled(false);
            this.btnRecord.setEnabled(false);
            this.btnChange.setEnabled(true);
            this.btnResume.setEnabled(true);
            this.btnFree.setEnabled(true);
            this.btnEnd.setEnabled(true);
        } else if (selectState == 2) {
            this.btnEdit.setEnabled(false);
            this.btnRecord.setEnabled(false);
            this.btnChange.setEnabled(true);
            this.btnResume.setEnabled(true);
            this.btnFree.setEnabled(true);
            this.btnEnd.setEnabled(true);
        } else if (selectState == 3) {
            this.btnEdit.setEnabled(false);
            this.btnRecord.setEnabled(false);
            this.btnChange.setEnabled(true);
            this.btnResume.setEnabled(true);
            this.btnFree.setEnabled(true);
            this.btnEnd.setEnabled(true);
        } else if (selectState == 4) {
            this.btnEdit.setEnabled(false);
            this.btnRecord.setEnabled(false);
            this.btnChange.setEnabled(false);
            this.btnResume.setEnabled(false);
            this.btnFree.setEnabled(false);
            this.btnEnd.setEnabled(false);
        } else if (selectState == 5) {
            this.btnEdit.setEnabled(false);
            this.btnRecord.setEnabled(false);
            this.btnChange.setEnabled(false);
            this.btnResume.setEnabled(false);
            this.btnEnd.setEnabled(false);
            this.btnFree.setEnabled(false);
        }
    }

    @Override
    public void actionRecord_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        IEmployeeContract iEmp = EmployeeContractFactory.getRemoteInstance();
        KDTSelectBlock sb = null;
        String empContractID = null;
        StringBuffer recordEmpContractIds = new StringBuffer();
        StringBuffer notRecordEmpContractsMsg = new StringBuffer();
        int size = this.tblMain.getSelectManager().size();
        for (int i = 0; i < size; ++i) {
            sb = this.tblMain.getSelectManager().get(i);
            int j = 0;
            int bottom = 0;
            if (sb.getMode() == 8) {
                j = 0;
                bottom = this.tblMain.getRowCount();
            } else {
                j = sb.getTop();
                bottom = sb.getBottom() + 1;
            }
            while (j < bottom) {
                IRow row = this.tblMain.getRow(j);
                empContractID = row.getCell("id").getValue().toString();
                if (iEmp.getEmpContractStateValue(empContractID) == 0) {
                    if (!"".equals(recordEmpContractIds.toString())) {
                        recordEmpContractIds.append(",");
                    }
                    recordEmpContractIds.append("'").append(empContractID).append("'");
                } else {
                    notRecordEmpContractsMsg.append(EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.EMPLOYEECONTRACT_NUM")).append(row.getRowIndex() + 1).append(EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.EMPLOYEECONTRACT_ROW_EMP")).append(this.tblMain.getRow(j).getCell("empName").getValue().toString()).append(EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.EMPLOYEECONTRACT_CONTRACTNO")).append(this.tblMain.getRow(j).getCell("contractNo").getValue().toString()).append("\n");
                }
                ++j;
            }
        }
        if ("".equals(notRecordEmpContractsMsg.toString())) {
            if (MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.EMPLOYEECONTRACT_RECORD_CONFIRM")) == 0) {
                iEmp.recordEmpContract(recordEmpContractIds.toString());
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.EMPLOYEECONTRACT_RECORD_SUCCESS"));
                this.refreshList();
            }
        } else if ("".equals(recordEmpContractIds.toString())) {
            MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.EMPLOYEECONTRACT_RECORD_CONFIRM2"));
        } else if (MsgBox.showConfirm3a((String)EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.EMPLOYEECONTRACT_RECORD_CONFIRM1"), (String)(EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.EMPLOYEECONTRACT_CANNOT_RECORD_LIST") + "\n" + notRecordEmpContractsMsg.toString())) == 0 && !"".equals(recordEmpContractIds.toString())) {
            iEmp.recordEmpContract(recordEmpContractIds.toString());
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.EMPLOYEECONTRACT_RECORD_SUCCESS"));
            this.refreshList();
        }
    }

    @Override
    public void actionResume_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.verifyChangedContrace(false);
        int[] rows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        ContractState contractState = this.getContractState(rows[0]);
        if (contractState == ContractState.ACTIVE) {
            this.state = "RESUME";
            super.actionEdit_actionPerformed(e);
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.EMPLOYEECONTRACT_CANNOT_RESUME"));
        }
        this.state = null;
    }

    @Override
    public void actionChange_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (this.isHistory("EMPLOYEECONTRACT_CANNOT_CHANGE")) {
            return;
        }
        this.verifyChangedContrace(false);
        int[] rows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        ContractState contractState = this.getContractState(rows[0]);
        if (contractState == ContractState.ACTIVE) {
            this.state = "CHANGE";
            super.actionEdit_actionPerformed(e);
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.EMPLOYEECONTRACT_CANNOT_CHANGE"));
        }
        this.state = null;
    }

    private void verifyChangedContrace(boolean isBatch) throws Exception {
        boolean isChanged = false;
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        for (int i = 0; i < selectRows.length; ++i) {
            Boolean isChangedObj = (Boolean)this.tblMain.getRow(selectRows[i]).getCell("isChanged").getValue();
            if (!EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.EMPLOYEE_CONTRACT_HISTORYSTATE").equals(this.tblMain.getRow(selectRows[i]).getCell("contractState").getValue()) && isChangedObj != null) {
                isChanged = isChangedObj;
            }
            if (isChanged || !isBatch) break;
        }
        if (isChanged) {
            throw new HRCommonException(HRCommonException.EXCEPTION_MSG, (Object[])new String[]{EASResource.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"200_EmployeeContractListUI")});
        }
    }

    @Override
    public void actionEnd_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (this.isHistory("EMPLOYEECONTRACT_CANNOT_END")) {
            return;
        }
        this.verifyChangedContrace(false);
        int[] rows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        ContractState contractState = this.getContractState(rows[0]);
        if (contractState == ContractState.ACTIVE) {
            this.state = "END";
            super.actionEdit_actionPerformed(e);
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.EMPLOYEECONTRACT_CANNOT_END"));
        }
        this.state = null;
    }

    @Override
    public void actionFree_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (this.isHistory("EMPLOYEECONTRACT_CANNOT_FREE")) {
            return;
        }
        this.verifyChangedContrace(false);
        int[] rows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        ContractState contractState = this.getContractState(rows[0]);
        if (contractState == ContractState.ACTIVE) {
            this.state = "FREE";
            super.actionEdit_actionPerformed(e);
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.EMPLOYEECONTRACT_CANNOT_FREE"));
        }
        this.state = null;
    }

    private boolean isHistory(String resourceStr) {
        try {
            IEmployeeContract iEmp = EmployeeContractFactory.getRemoteInstance();
            EmployeeContractInfo empContractInfo = iEmp.getEmployeeContractInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.getSelectedKeyValue())));
            Date today = new Date();
            if (empContractInfo.getEndDate() == null) {
                return false;
            }
            if (DateTimeUtils.dayAfter((Date)today, (Date)empContractInfo.getEndDate()) || DateTimeUtils.dayEquals((Date)today, (Date)empContractInfo.getEndDate())) {
                MsgBox.showInfo((String)EASResource.getString((String)("com.kingdee.eas.hr.emp.EmployeeResource." + resourceStr)));
                return true;
            }
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return false;
    }

    @Override
    public void actionDownload_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        AttachmentClientManager acm = AttachmentManagerFactory.getClientManager();
        String[] attchIds = acm.getAttachmentIDsByBoID(this.getSelectedKeyValue());
        if (attchIds.length <= 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.EMPLOYEECONTRACT_NO_ATTACH"));
        } else {
            acm.downloadAttachment(attchIds[0], (Component)((Object)this));
        }
    }

    public void actionRemove_actionPerformed(ActionEvent arg0) throws Exception {
        super.actionRemove_actionPerformed(arg0);
        AttachmentClientManager asm = AttachmentManagerFactory.getClientManager();
        asm.deleteAttachemtsByBoID(this.getSelectedKeyValue());
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor exec = super.getQueryExecutor(queryPK, viewInfo);
        exec.option().isAutoIgnoreZero = true;
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = true;
        return exec;
    }

    protected void setThelper() {
        this.setQueryPreference(true);
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        uiContext.put((Object)"state", (Object)this.state);
        uiContext.put((Object)"isReport", (Object)this.isReport);
    }

    protected void performCommonQuery() throws Exception {
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        String queryName = EmployeeContractListUI.getQueryInfo((IMetaDataPK)this.mainQueryPK).getFullName();
        EmployeeContractCustFilterPanel customerPanelExample = new EmployeeContractCustFilterPanel();
        customerPanelExample.setContractAllHR(this.isContractAllHR);
        customerPanelExample.setIsZTCustomer(this.isZTCustomer);
        int iMaxNumView = iQuery.getMaxNumView(this.getMetaDataPK().getFullName(), queryName);
        if (this.isFirstDefaultQuery && iQuery.hasDefaultSolution(this.getMetaDataPK().getFullName(), queryName)) {
            QuerySolutionInfo defaultSolution = iQuery.getDefaultSolution(this.getMetaDataPK().getFullName(), queryName);
            if (defaultSolution.getSolutionType().getValue().equals("10")) {
                this.showFilterUI(customerPanelExample, iMaxNumView);
            } else {
                if (this.orgContextManager != null) {
                    QuerySolutionInfo querySolution = defaultSolution;
                    this.orgContextManager.changeQueryContext(querySolution, this.getUIContext());
                }
                if (!this.isHasPermission()) {
                    this.showFilterUI(customerPanelExample, iMaxNumView);
                } else {
                    EntityViewInfo defaultView = (EntityViewInfo)iQuery.getDefaultFilterInfo(this.getMetaDataPK().getFullName(), queryName);
                    FilterInfo defaultFilter = null;
                    if (defaultView != null) {
                        defaultFilter = defaultView.getFilter();
                    }
                    if (defaultView != null) {
                        if (defaultView.getFilter() != null) {
                            defaultView.getFilter().mergeFilter(this.getDefaultFilter(), "AND");
                        } else {
                            defaultView.setFilter(this.getDefaultFilter());
                        }
                        this.mainQuery = defaultView;
                    } else {
                        FilterInfo filter = HRUtil.customMergeFilter((FilterInfo)defaultFilter, (FilterInfo)this.getDefaultFilter(), (String)"AND");
                        this.mainQuery.setFilter(filter);
                    }
                    if (this.isSupportDynQuery() && defaultView != null) {
                        this.handleDynamicQuery(defaultView.getSelector());
                    }
                    this.doDefaultSolution(iQuery, queryName);
                    this.applyPreference();
                    GetDataDialog dlg = null;
                    Window owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
                    Window ownerWindow = ComponentUtil.getOwnerWindow((Component)owner);
                    dlg = ownerWindow instanceof Frame ? new GetDataDialog((Frame)ownerWindow) : (ownerWindow instanceof Dialog ? new GetDataDialog((Dialog)ownerWindow) : new GetDataDialog((Frame)null));
                    dlg.setGetDataTask(new GetDataTaskAdapter(){

                        public Object exec() throws Exception {
                            EmployeeContractListUI.this.tblMain.removeRows();
                            return null;
                        }
                    });
                    dlg.show();
                }
            }
        } else {
            this.showFilterUI(customerPanelExample, iMaxNumView);
        }
        this.isFirstDefaultQuery = false;
    }

    protected boolean isHasPermission() {
        if (this.getUIContext().get(OrgType.HRO) != null) {
            HROrgUnitInfo hrOrgUnitInfo = (HROrgUnitInfo)this.getUIContext().get(OrgType.HRO);
            UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
            try {
                if (hrOrgUnitInfo.isIsBizUnit() && PermissionFactory.getRemoteInstance().hasFunctionPermission((IObjectPK)new ObjectUuidPK(user.getId()), (IObjectPK)new ObjectUuidPK(hrOrgUnitInfo.getId()), HROrgContextManagerFacadeFactory.getRemoteInstance().getPermissionItem(MetaDataTypeList.BASEQUERY, this.getMainQueryPK()))) {
                    return true;
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        return false;
    }

    private void showFilterUI(EmployeeContractCustFilterPanel customerPanelExample, int iMaxNumView) throws BOSException, Exception {
        if (this.commonQueryDialog == null) {
            this.commonQueryDialog = new CommonQueryDialog();
            this.commonQueryDialog.setHeight(370);
            this.commonQueryDialog.setWidth(430);
            if (this.getUIWindow() == null) {
                this.commonQueryDialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
            } else {
                this.commonQueryDialog.setOwner((Component)((Object)this));
            }
            this.commonQueryDialog.setParentUIClassName(this.getMetaDataPK().getFullName());
            this.commonQueryDialog.setQueryObjectPK(this.mainQueryPK);
            this.commonQueryDialog.setShowFilter(true);
            this.commonQueryDialog.setShowSorter(true);
            this.commonQueryDialog.setShowToolbar(true);
            this.commonQueryDialog.setDynQueryVisible(true);
            this.commonQueryDialog.setUiObject((IUIObject)this);
            this.commonQueryDialog.setVisibleTableCols(this.getQueryShowField());
            customerPanelExample.setPanelName(EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.CONTRACT_CONDITION_FILTER"));
            if (this.orgContextManager != null) {
                if (this.orgContextManager.getOwner() != null && this.orgContextManager.getOwner() instanceof CustomerQueryPanel) {
                    EmployeeContractQueryFilterPanelUI queryPanel = (EmployeeContractQueryFilterPanelUI)this.orgContextManager.getOwner();
                    this.commonQueryDialog.addUserPanel((KDPanel)queryPanel);
                    queryPanel.addListenerPanel(customerPanelExample);
                }
                this.orgContextManager.init(this.getUIContext());
                ContractHROrgContextPromptBoxFactory promptBoxFactory = new ContractHROrgContextPromptBoxFactory(this.orgContextManager, this.getUIContext(), this.isContractAllHR);
                this.commonQueryDialog.setPromptBoxFactory((IPromptBoxFactory)promptBoxFactory);
            }
            this.commonQueryDialog.addUserPanel((KDPanel)customerPanelExample);
            this.commonQueryDialog.setTitle(EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.CONTRACT_FILTER"));
            this.commonQueryDialog.setMaxReturnCountVisible(true);
        }
        if (this.commonQueryDialog.show()) {
            this.tHelper.setDialog(this.commonQueryDialog);
            EmployeeContractQueryFilterPanelUI myPanel = (EmployeeContractQueryFilterPanelUI)this.commonQueryDialog.getUserPanel(0);
            this.includeSealUp = myPanel.chkShowSealUp.isSelected();
            EntityViewInfo entityView = this.commonQueryDialog.getEntityViewInfoResult();
            FilterInfo commonfilter = entityView.getFilter();
            if (commonfilter != null) {
                FilterInfo filter = HRUtil.customMergeFilter((FilterInfo)commonfilter, (FilterInfo)this.getDefaultFilter(), (String)"AND");
                entityView.setFilter(filter);
            } else {
                entityView.setFilter(this.getDefaultFilter());
            }
            this.mainQuery = entityView;
            if (this.isSupportDynQuery()) {
                if (this.isEnableSimpleSQL()) {
                    SelectorItemCollection dynSelectors = DynamicQueryUtil.getDynSelectors((DynQuerySelectFieldCollection)this.commonQueryDialog.getQueryFieldsInDB());
                    this.handleVisibleAndNotBindedQuery(dynSelectors);
                    this.handleDynamicQuerySelector(this.mainQuery, dynSelectors);
                    this.RemoveHideFieldInSelector(this.mainQuery, this.commonQueryDialog.getCommonTableParams().getTableCurrentSetting());
                }
                this.handleDynamicQuery(Util.getDynSelector((EntityViewInfo)this.mainQuery));
            }
            this.tblMain.removeRows(false);
            this.doQuery(this.commonQueryDialog);
            this.refreshList();
        } else {
            this.tHelper.setDialog(this.commonQueryDialog);
            SysUtil.abort();
        }
    }

    private FilterInfo getDefaultFilter() throws BOSException, EASBizException {
        OrgUnitCollection orgUnitCollection = null;
        Collection hrIds = null;
        orgUnitCollection = (OrgUnitCollection)this.getUIContext().get("multi_org_context");
        OrgUnitInfo orgInfo = null;
        if (orgUnitCollection != null && orgUnitCollection.size() == 1) {
            String oql = "select id, longNumber, isLeaf where id = '" + orgUnitCollection.get(0).getId().toString() + "'";
            orgInfo = HROrgUnitFactory.getRemoteInstance().getOrgUnitCollection(oql).get(0);
        }
        if (orgInfo != null && !orgInfo.isIsLeaf()) {
            FilterInfo filter = new FilterInfo();
            StringBuffer sql = new StringBuffer("SELECT FOrgID FROM T_PM_OrgRange WHERE FType = ");
            sql.append(10);
            sql.append(" AND FUserID = '");
            sql.append(SysContext.getSysContext().getCurrentUserInfo().getId().toString());
            sql.append("'");
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)sql.toString(), CompareType.INNER));
            filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(orgInfo.getLongNumber() + "%"), CompareType.LIKE));
            filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)1, CompareType.EQUALS));
            EntityViewInfo entityView = new EntityViewInfo();
            entityView.setFilter(filter);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            entityView.setSelector(selector);
            orgUnitCollection = HROrgUnitFactory.getRemoteInstance().getOrgUnitCollection(entityView);
        }
        hrIds = EmployeeClientUtils.transInfoCollectionToIdCollection((IObjectCollection)orgUnitCollection);
        FilterInfo filterInfo = new FilterInfo();
        if (hrIds == null || hrIds.size() == 0) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)"-1"));
        } else {
            filterInfo = HRUtil.customMergeFilter((FilterInfo)filterInfo, (FilterInfo)EmployeeClientUtils.getAdminRangeFilterInfo(hrIds, "empAdminUnit.id"), (String)"AND");
        }
        if (!this.includeSealUp) {
            try {
                FilterInfo filterSealUp = new FilterInfo("AdminOrgUnit.isSealUp = 0");
                filterInfo.mergeFilter(filterSealUp, "and");
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        return filterInfo;
    }

    @Override
    public void actionOutputExcel_actionPerformed(ActionEvent e) throws Exception {
        super.actionOutputExcel_actionPerformed(e);
        OutputExcelUtil excelUtil = new OutputExcelUtil();
        excelUtil.appendToExcel(this.tblMain, true, true, this.getUITitle());
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.PEOPLE_ORGANIZATION;
    }

    @Override
    public void actionNoRecord_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiCtx = new UIContext((Object)this);
        if (this.getUIContext().get(this.getMainBizOrgType()) != null) {
            uiCtx.put((Object)"currentHRO", this.getUIContext().get(this.getMainBizOrgType()));
        }
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(EmployeeContractNoRecordUI.class.getName(), (Map)uiCtx, null, OprtState.ADDNEW);
        uiWindow.show();
    }

    @Override
    public void actionBatchProcess_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.verifyChangedContrace(false);
        StringBuffer selIds = this.getSelectedContractIds();
        if (selIds.toString().equals("")) {
            return;
        }
        if (this.blHasHisBatchProcess && MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.EMPLOYEECONTRACT_HISTORYBATCHPROCESS")) == 2) {
            return;
        }
        UIContext uiCtx = new UIContext((Object)this);
        if (this.getUIContext().get(this.getMainBizOrgType()) != null) {
            String hrOrgUnitId = ((OrgUnitInfo)this.getUIContext().get(this.getMainBizOrgType())).getId().toString();
            uiCtx.put((Object)"currentHRO", (Object)hrOrgUnitId);
        }
        uiCtx.put((Object)"isBatchProcess", (Object)"1");
        uiCtx.put((Object)"hasHisBatchProcess", (Object)this.blHasHisBatchProcess);
        uiCtx.put((Object)"selectedContractIds", (Object)selIds);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(BatchContractEditUI.class.getName(), (Map)uiCtx, null, OprtState.ADDNEW);
        uiWindow.show();
        this.doRefreshForCoreUI(uiWindow);
    }

    private void doRefreshForCoreUI(IUIWindow uiWindow) {
        Window window = SwingUtilities.getWindowAncestor((JComponent)uiWindow.getUIObject());
        final IUIWindow iuw = uiWindow;
        WindowAdapter listenerForEditWindow = null;
        listenerForEditWindow = new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent event) {
                try {
                    boolean isSaved = ((BatchContractEditUI)iuw.getUIObject()).isSaved;
                    if (SysContext.getSysContext().getSessionID() != null && isSaved && EmployeeContractListUI.this.btnRefresh != null) {
                        if (EmployeeContractListUI.this.actionEvent == null) {
                            EmployeeContractListUI.this.actionEvent = new ActionEvent(EmployeeContractListUI.this.btnRefresh, 1001, EmployeeContractListUI.this.btnRefresh.getActionCommand());
                        }
                        EmployeeContractListUI.this.setLocatePre(false);
                        EmployeeContractListUI.this.refresh(EmployeeContractListUI.this.actionEvent);
                        EmployeeContractListUI.this.setLocatePre(true);
                    }
                }
                catch (Exception e) {
                    EmployeeContractListUI.this.handleException(e);
                }
            }
        };
        window.addWindowListener(listenerForEditWindow);
    }

    private StringBuffer getSelectedContractIds() {
        StringBuffer sb = new StringBuffer();
        int[] rowIndexs = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        int cannotBatch = 0;
        this.blHasHisBatchProcess = false;
        int size = rowIndexs.length;
        for (int i = 0; i < size; ++i) {
            ContractState contractState = this.getContractState(rowIndexs[i]);
            if (contractState == ContractState.NONE) {
                ++cannotBatch;
                continue;
            }
            if (contractState == ContractState.HISTORY) {
                this.blHasHisBatchProcess = true;
            }
            if (!"".equals(sb.toString())) {
                sb.append(",");
            }
            sb.append("'" + this.tblMain.getRow(rowIndexs[i]).getCell("id").getValue().toString() + "'");
        }
        if (cannotBatch > 0) {
            String msg = EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.EMPLOYEECONTRACT_BATCHPROCESS");
            Object[] objs = new Object[]{rowIndexs.length, cannotBatch, rowIndexs.length - cannotBatch};
            msg = MessageFormat.format(msg, objs);
            MsgBox.showInfo((Component)((Object)this), (String)msg);
        }
        return sb;
    }

    protected void refresh(ActionEvent e) throws Exception {
        GetDataDialog dlg = null;
        Window owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        Window ownerWindow = ComponentUtil.getOwnerWindow((Component)owner);
        dlg = ownerWindow instanceof Frame ? new GetDataDialog((Frame)ownerWindow) : (ownerWindow instanceof Dialog ? new GetDataDialog((Dialog)ownerWindow) : new GetDataDialog((Frame)null));
        final ActionEvent evt = e;
        dlg.setGetDataTask(new GetDataTaskAdapter(){

            public Object exec() throws Exception {
                EmployeeContractListUI.this.refresh_new(evt);
                return null;
            }
        });
        dlg.show();
    }

    private void refresh_new(ActionEvent e) throws Exception {
        super.refresh(e);
    }

    protected IMultiOrgSupport getMainCustomerQueryPanel() {
        try {
            EmployeeContractQueryFilterPanelUI filterUI = new EmployeeContractQueryFilterPanelUI(this);
            filterUI.setPanelName(EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.QUERY_RANG"));
            filterUI.setMetaDataPKForPemmission(this.mainQueryPK);
            filterUI.setContractAllHR(this.isContractAllHR);
            return filterUI;
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    public String getPropertyOfBizOrg(OrgType orgType) {
        return null;
    }

    public String[] getPropertyOfCopOrg() {
        return null;
    }

    protected boolean isSupportDynQuery() {
        return true;
    }

    protected void getRowSetBeforeFillTable(IRowSet rowSet) {
        try {
            String hasAttachment = "hasAttachment";
            ResultSetMetaData rsMd = rowSet.getMetaData();
            HashSet<String> colSet = new HashSet<String>();
            for (int i = 1; i <= rsMd.getColumnCount(); ++i) {
                colSet.add(rsMd.getColumnName(i));
            }
            try {
                Set contractIDs = EmployeeContractFactory.getRemoteInstance().getContractIDsFromAttachment();
                if (colSet.contains(hasAttachment)) {
                    while (rowSet.next()) {
                        if (contractIDs.contains(rowSet.getString("id"))) {
                            rowSet.updateString(hasAttachment, EASResource.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"330_EmployeeContractListUI"));
                            continue;
                        }
                        rowSet.updateString(hasAttachment, EASResource.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"331_EmployeeContractListUI"));
                    }
                }
            }
            catch (SQLException e) {
                this.handUIException(e);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void actionAttachment_actionPerformed(ActionEvent e) throws Exception {
        AttachmentClientManager acm = AttachmentManagerFactory.getClientManager();
        String boID = this.getSelectedKeyValue();
        this.checkSelected();
        if (boID == null) {
            return;
        }
        boolean hasPermission = true;
        hasPermission = HRUtil.hasFunctionPermission((IObjectPK)this.getOrgPK((ItemAction)this.actionEdit), (String)this.getMetaDataPK().getFullName(), (ItemAction)this.actionEdit);
        acm.showAttachmentListUIByBoID(boID, (Object)this, hasPermission);
    }

    @Override
    public void actionWorkflowG_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String fieldName = this.getQueryFieldNameBindingWf();
        String id = (String)this.getSelectedFieldValues(fieldName).get(0);
        IEnactmentService service = EnactmentServiceFactory.createRemoteEnactService();
        ProcessInstInfo processInstInfo = null;
        ProcessInstInfo[] procInsts = service.getProcessInstanceByHoldedObjectId(id);
        int n = procInsts.length;
        for (int i = 0; i < n; ++i) {
            if (!procInsts[i].getState().startsWith("open")) continue;
            processInstInfo = procInsts[i];
        }
        if (processInstInfo == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_WFHasNotInstance"));
        } else {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"id", (Object)processInstInfo.getProcInstId());
            String className = BasicWorkFlowMonitorPanel.class.getName();
            IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(className, (Map)uiContext);
            uiWindow.show();
        }
    }

    public final String getQueryFieldNameBindingWf() {
        if (this instanceof IWorkflowUISupport) {
            IWorkflowUIEnhancement enhancement = ((IWorkflowUISupport)this).getWorkflowUIEnhancement();
            return enhancement.getQueryFieldNameBindingWf((CoreUIObject)this);
        }
        return this.getKeyFieldNameForWF();
    }

    public final ArrayList getSelectedFieldValues(String fieldName) {
        ArrayList<String> list = new ArrayList<String>();
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        for (int i = 0; i < selectRows.length; ++i) {
            String id;
            ICell cell = this.tblMain.getRow(selectRows[i]).getCell(fieldName);
            if (cell == null) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
                SysUtil.abort();
            }
            if (list.contains(id = cell.getValue().toString())) continue;
            list.add(id);
        }
        return list;
    }

    @Override
    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        if (this.isInvalid()) {
            this.btnRecord.setEnabled(true);
            this.menuItemRecord.setEnabled(true);
        } else {
            this.btnRecord.setEnabled(false);
            this.menuItemRecord.setEnabled(false);
        }
    }

    private boolean isInvalid() throws Exception {
        IEmployeeContract iemp = EmployeeContractFactory.getRemoteInstance();
        EmployeeContractInfo empInfo = null;
        String empContractID = null;
        int[] rowID = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (rowID.length > 0) {
            for (int i = 0; i < rowID.length; ++i) {
                int row = rowID[i];
                if (row == -1) {
                    return false;
                }
                empContractID = this.tblMain.getCell(row, "id").getValue().toString();
                empInfo = iemp.getEmployeeContractInfo((IObjectPK)new ObjectStringPK(empContractID));
                if (empInfo.isIsWorkflow()) {
                    return false;
                }
                String value = this.tblMain.getCell(row, "auditState").getValue().toString();
                if (!value.equals(ContractWFStateEnum.TEMP.getAlias()) && !value.equals(ContractWFStateEnum.EDIT.getAlias()) && !value.equals(ContractWFStateEnum.APPROVE.getAlias()) && !value.equals(ContractWFStateEnum.PASS.getAlias()) && !value.equals(ContractWFStateEnum.UNPASS.getAlias())) continue;
                return false;
            }
        }
        return true;
    }

    private ContractState getContractState(int rowIndex) {
        ContractState contractState = ContractState.NONE;
        Date now = DateTimeUtils.truncateDate((Date)new Date());
        IRow row = this.tblMain.getRow(rowIndex);
        int state = (Integer)row.getCell("state").getValue();
        Date effectDate = (Date)row.getCell("effectDate").getValue();
        Date endDate = (Date)row.getCell("endDate").getValue();
        switch (state) {
            case -1: 
            case 0: 
            case 10: 
            case 20: 
            case 40: {
                contractState = ContractState.NONE;
                break;
            }
            case 4: 
            case 5: {
                contractState = ContractState.HISTORY;
                break;
            }
            default: {
                contractState = DateTimeUtils.dayAfter((Date)effectDate, (Date)now) ? ContractState.NONE : (endDate == null ? ContractState.ACTIVE : (DateTimeUtils.dayAfter((Date)endDate, (Date)now) ? ContractState.ACTIVE : ContractState.HISTORY));
            }
        }
        return contractState;
    }
}

