/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.client;

import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.hraux.DiplomaInfo;
import com.kingdee.eas.basedata.hraux.DiplomaTypeFactory;
import com.kingdee.eas.basedata.hraux.DiplomaTypeInfo;
import com.kingdee.eas.basedata.hraux.client.DiplomaPromptBox;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.emp.EmployeeException;
import com.kingdee.eas.hr.emp.IPersonDegree;
import com.kingdee.eas.hr.emp.PersonDegreeFactory;
import com.kingdee.eas.hr.emp.PersonDegreeInfo;
import com.kingdee.eas.hr.emp.client.AbstractEmployeeDegreeEditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Date;

public class EmployeeDegreeEditUI
extends AbstractEmployeeDegreeEditUI {
    private HROrgUnitInfo hroInfo = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void beforeOnLoad() throws Exception {
        super.beforeOnLoad();
        this.hroInfo = (HROrgUnitInfo)this.getUIContext().get("currentHRO");
        this.contHROrg.setVisible(false);
    }

    protected void afterOnLoad() throws Exception {
        super.afterOnLoad();
        this.chkIsHighestDegree_actionPerformed(null);
        this.chkIsHighest_actionPerformed(null);
        this.prmtDiploma.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    EmployeeDegreeEditUI.this.prmtDiploma_dataChanged(e);
                }
                catch (Exception exc) {
                    EmployeeDegreeEditUI.this.handUIException(exc);
                }
            }
        });
        this.prmtDiploma.setSelector((KDPromptSelector)new DiplomaPromptBox());
    }

    protected void prmtDiploma_dataChanged(DataChangeEvent e) throws Exception {
        DiplomaInfo diplomaInfo = (DiplomaInfo)e.getNewValue();
        if (diplomaInfo == null) {
            this.txtdiplomaType.setText(null);
            return;
        }
        DiplomaTypeInfo dipType = diplomaInfo.getDiplomaType();
        if (dipType == null) {
            this.txtdiplomaType.setText(null);
            return;
        }
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)dipType.getId().toString()));
        dipType = DiplomaTypeFactory.getRemoteInstance().getDiplomaTypeInfo((IObjectPK)pk);
        this.txtdiplomaType.setText(dipType.getName());
    }

    public IObjectPK runSubmit() throws Exception {
        this.editData.setHrOrgUnit(this.getCurrentHRO());
        this.editData.setCU(this.getCurrentCU());
        return super.runSubmit();
    }

    private CtrlUnitInfo getCurrentCU() {
        if (this.hroInfo != null) {
            return this.hroInfo.getCU();
        }
        return SysContext.getSysContext().getCurrentCtrlUnit();
    }

    private HROrgUnitInfo getCurrentHRO() {
        if (this.hroInfo != null) {
            return this.hroInfo;
        }
        return SysContext.getSysContext().getCurrentHRUnit();
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        return new ObjectUuidPK(this.getCurrentHRO().getId());
    }

    @Override
    protected IObjectValue createNewData() {
        PersonDegreeInfo info = new PersonDegreeInfo();
        PersonInfo pInfo = new PersonInfo();
        pInfo.setId(BOSUuid.read((String)this.getUIContext().get("PersonID").toString()));
        info.setPerson(pInfo);
        return info;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return PersonDegreeFactory.getRemoteInstance();
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        int result;
        boolean flagOfDate;
        if (this.prmtDegree.getData() == null && this.prmtDiploma.getData() == null) {
            throw new EmployeeException(EmployeeException.BOTH_DISPLO_DEGREE_CAN_NOT_NULL);
        }
        if (this.chkIsHighest.isSelected() && this.prmtDiploma.getData() == null) {
            throw new EmployeeException(EmployeeException.DISPLO_CAN_NOT_NULL);
        }
        if (this.chkIsHighestDegree.isSelected() && this.prmtDegree.getData() == null) {
            throw new EmployeeException(EmployeeException.DEGREE_CAN_NOT_NULL);
        }
        Date enrollDate = (Date)this.pkEnrollDate.getValue();
        Date graduateDate = (Date)this.pkGraduateDate.getValue();
        if (enrollDate != null && graduateDate != null && (flagOfDate = DateTimeUtils.dayAfter((Date)enrollDate, (Date)graduateDate))) {
            throw new EmployeeException(EmployeeException.ENROLLDATE_AFTER_GRADUATEDATE);
        }
        IPersonDegree ipd = PersonDegreeFactory.getRemoteInstance();
        boolean isRepeat = ipd.isDegreeRepeat(this.editData);
        if (!isRepeat && !MsgBox.isYes((int)(result = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.EMPLOYEE_DEGREE_REPEAT"))))) {
            SysUtil.abort();
        }
    }

    public void initWorkButton() {
        super.initWorkButton();
        this.txtStudyLength.setSupportedEmpty(true);
        this.txtStudyLength.setMaximumValue((Comparable)new Double(50.0));
        this.txtStudyLength.setMinimumValue((Comparable)new Double(0.0));
        this.txtStudyLength.setPrecision(2);
        if (OprtState.VIEW.equals(this.getOprtState())) {
            this.actionAddNew.setVisible(false);
            this.actionEdit.setVisible(false);
            this.actionCopy.setVisible(false);
            this.actionSubmit.setVisible(false);
            this.actionRemove.setVisible(false);
        } else {
            this.actionAddNew.setVisible(true);
            this.actionEdit.setVisible(true);
            this.actionCopy.setVisible(true);
            this.actionSubmit.setVisible(true);
            this.actionRemove.setVisible(true);
        }
    }

    protected void handlePermissionForItemAction(ItemAction action) {
        if (this.getUIContext().get("NO_PERMISSION") == null) {
            super.handlePermissionForItemAction(action);
        }
    }

    @Override
    protected void chkIsHighestDegree_actionPerformed(ActionEvent e) throws Exception {
        if (this.chkIsHighestDegree.isSelected()) {
            this.prmtDegree.setRequired(true);
        } else {
            this.prmtDegree.setRequired(false);
        }
    }

    @Override
    public void chkIsHighest_actionPerformed(ActionEvent e) {
        if (this.chkIsHighest.isSelected()) {
            this.prmtDiploma.setRequired(true);
        } else {
            this.prmtDiploma.setRequired(false);
        }
    }
}

