/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CountryCollection;
import com.kingdee.eas.basedata.assistant.CountryInfo;
import com.kingdee.eas.basedata.hraux.DegreeFactory;
import com.kingdee.eas.basedata.hraux.IBasicItem;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.base.SpecialtyTypeFactory;
import com.kingdee.eas.hr.base.client.ListEditUI;
import com.kingdee.eas.hr.emp.EmployeeException;
import com.kingdee.eas.hr.emp.IPersonDegree;
import com.kingdee.eas.hr.emp.PersonDegreeCollection;
import com.kingdee.eas.hr.emp.PersonDegreeFactory;
import com.kingdee.eas.hr.emp.client.AbstractEmployeeDegreeUI;
import com.kingdee.eas.hr.emp.client.EmployeeClientUtils;
import com.kingdee.eas.hr.emp.client.IEmpInfoUI;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JTextField;

public class EmployeeDegreeUI
extends AbstractEmployeeDegreeUI
implements IEmpInfoUI {
    private String empId = null;
    private PersonInfo pInfo = null;
    private ArrayList delList = new ArrayList();

    private void checkInput() throws Exception {
        EmployeeClientUtils.checkTableCellIsNull(this.kdtDegree, "diploma");
        EmployeeClientUtils.checkHasInputRows(this.kdtDegree, this.delList);
        EmployeeClientUtils.checkTableCellDup(this.kdtDegree, "degree");
        for (int i = 0; i < this.kdtDegree.getRowCount(); ++i) {
            Date startDate = (Date)this.kdtDegree.getRow(i).getCell("enrollDate").getValue();
            Date endDate = (Date)this.kdtDegree.getRow(i).getCell("graduateDate").getValue();
            if (startDate == null || endDate == null || !DateTimeUtils.dayAfter((Date)startDate, (Date)endDate)) continue;
            throw new EmployeeException(EmployeeException.ENROLLDATE_NOT_DY_GRADUATEDATE);
        }
    }

    @Override
    public void submit() throws Exception {
        this.checkInput();
        IObjectPK[] delArray = new IObjectPK[this.delList.size()];
        for (int i = 0; i < this.delList.size(); ++i) {
            delArray[i] = new ObjectUuidPK((BOSUuid)this.delList.get(i));
        }
        IPersonDegree ipd = PersonDegreeFactory.getRemoteInstance();
        PersonDegreeCollection degreeInfos = EmployeeClientUtils.getDegreeCollectionByKDTable(this.kdtDegree, EmployeeClientUtils.getPersonInfo(this.empId));
        this.checkIsHighestDup(degreeInfos);
        ipd.saveAll(degreeInfos, delArray);
        ListEditUI listEditUI = (ListEditUI)this.getUIContext().get("ListEditUI");
        listEditUI.setStatusBarMessage();
        this.refresh();
    }

    private void checkIsHighestDup(PersonDegreeCollection degreeInfos) throws EmployeeException {
        int iCounts = 0;
        for (int i = 0; i < degreeInfos.size(); ++i) {
            if (!degreeInfos.get(i).isIsHighest()) continue;
            ++iCounts;
        }
        if (iCounts == 0) {
            throw new EmployeeException(EmployeeException.MUST_EXIST_ONE_LESS_DEGREE);
        }
        if (iCounts > 1) {
            throw new EmployeeException(EmployeeException.MUST_EXIST_ONE_DEGREE);
        }
    }

    public void firstOnLoad() throws Exception {
        this.refresh();
    }

    @Override
    public void secondLoad() throws Exception {
        this.firstOnLoad();
    }

    public void onLoad() throws Exception {
        this.empId = (String)this.getUIContext().get("ID");
        super.onLoad();
        this.kdtDegree.checkParsed();
        EmployeeClientUtils.initTableBtn((JButton)this.btnDegreeAddNew, (JButton)this.btnDegreeDelete);
        this.setTableCellEditor();
        this.actionDegreeDelete.setEnabled(true);
        if (this.getOprtState().equals(OprtState.VIEW)) {
            EmployeeClientUtils.setKDTableViewState(this.kdtDegree);
            this.btnDegreeAddNew.setEnabled(false);
            this.btnDegreeDelete.setEnabled(false);
        }
        EmployeeClientUtils.setColumnBackColor(this.kdtDegree, "diploma");
        this.kdtDegree.getStyleAttributes().setWrapText(true);
        this.initCellEditLength();
        this.loadFields();
    }

    void initCellEditLength() {
        EmployeeClientUtils.setCellEditor(this.kdtDegree, "graduateSchool");
        EmployeeClientUtils.setCellEditor(this.kdtDegree, "specialty");
        EmployeeClientUtils.setCellEditor(this.kdtDegree, "studyPattern");
        EmployeeClientUtils.setCellEditor(this.kdtDegree, "degreeUnit");
        EmployeeClientUtils.setCellEditor(this.kdtDegree, "degreeNumber");
    }

    private void setDegreeEditor() throws BOSException {
        this.kdtDegree.getColumn("degree").setEditor(EmployeeClientUtils.getComboBoxCellEditor((IBasicItem)DegreeFactory.getRemoteInstance()));
    }

    private void setIsHighestEditor() {
        this.kdtDegree.getColumn("isHighest").setEditor(EmployeeClientUtils.getBoolCellEditor());
    }

    @Override
    protected void kdtDegree_editStopped(KDTEditEvent e) throws Exception {
        super.kdtDegree_editStopped(e);
    }

    @Override
    protected void kdtDegree_editStarted(KDTEditEvent e) throws Exception {
        super.kdtDegree_editStarted(e);
        if (e.getColIndex() == 1 && ((Boolean)e.getValue()).booleanValue()) {
            for (int i = 0; i < this.kdtDegree.getRowCount(); ++i) {
                if (e.getRowIndex() == i) continue;
                this.kdtDegree.getRow(i).getCell("isHighest").setValue((Object)Boolean.FALSE);
            }
        }
    }

    @Override
    protected void kdtDegree_editStopping(KDTEditEvent e) throws Exception {
        super.kdtDegree_editStopping(e);
    }

    private void setDiplomaEditor() throws BOSException {
    }

    private void setEnrollDateEditor() {
        this.kdtDegree.getColumn("enrollDate").setEditor(EmployeeClientUtils.getStartDateCellEditor());
        this.kdtDegree.getColumn("enrollDate").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
    }

    private void setGraduateDateEditor() {
        this.kdtDegree.getColumn("graduateDate").setEditor(EmployeeClientUtils.getStartDateCellEditor());
        this.kdtDegree.getColumn("graduateDate").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
    }

    private void setSpecialtyTypeEditor() throws BOSException {
        this.kdtDegree.getColumn("specialtyType").setEditor(EmployeeClientUtils.getComboBoxCellEditor((IBasicItem)SpecialtyTypeFactory.getRemoteInstance()));
    }

    private void setStudyLengthEditor() {
        KDFormattedTextField kft2 = new KDFormattedTextField();
        kft2.setDataVerifierType(12);
        kft2.setDataType(5);
        kft2.setMaximumValue((Comparable)new Float("50"));
        kft2.setMinimumValue((Comparable)new Float("0"));
        kft2.setPrecision(1);
        this.kdtDegree.getColumn("studyLength").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)kft2));
    }

    private void setDegreeCountryEditor() throws Exception {
        DefaultComboBoxModel<CountryInfo> model = new DefaultComboBoxModel<CountryInfo>();
        CountryCollection c = new CountryCollection();
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.base.app.CountryQuery");
        IQueryExecutor queryExcu = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        IRowSet rows = queryExcu.executeQuery();
        CountryInfo info = null;
        while (rows.next()) {
            info = new CountryInfo();
            info.setId(BOSUuid.read((String)rows.getString("id")));
            info.setName(rows.getString("name"));
            c.add(info);
        }
        for (int i = 0; i < c.size(); ++i) {
            model.addElement(c.get(i));
        }
        KDComboBox combo = new KDComboBox(model);
        this.kdtDegree.getColumn("degreeCountry").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)combo));
    }

    private void setDegreeDateEditor() {
        this.kdtDegree.getColumn("degreeDate").setEditor(EmployeeClientUtils.getStartDateCellEditor());
    }

    private void setTableCellEditor() throws Exception {
        this.setDegreeEditor();
        this.setIsHighestEditor();
        this.setDiplomaEditor();
        this.setEnrollDateEditor();
        this.setGraduateDateEditor();
        this.setSpecialtyTypeEditor();
        this.setStudyLengthEditor();
        this.setDegreeCountryEditor();
        this.setDegreeDateEditor();
    }

    private PersonDegreeCollection getPDColl(String empId) throws BOSException {
        IPersonDegree ipd = PersonDegreeFactory.getRemoteInstance();
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("select id, degree.id, degree.number, degree.name, isHighest, ");
        strBuf.append("diploma.id, diploma.number, diploma.name, graduateSchool, ");
        strBuf.append("enrollDate, graduateDate, specialty, specialtyType.id, specialtyType.name, ");
        strBuf.append("specialtyType.number, studyPattern, studyLength, degreeCountry.id, ");
        strBuf.append("degreeCountry.name, degreeCountry.number, ");
        strBuf.append("degreeUnit, degreeDate,degreeNumber where person.id = '");
        strBuf.append(empId);
        strBuf.append("' order by isHighest DESC");
        return ipd.getPersonDegreeCollection(strBuf.toString());
    }

    private void loadDegrees() throws Exception {
        if (this.getUIContext().get("ID") != null) {
            this.empId = this.getUIContext().get("ID").toString();
        }
        PersonDegreeCollection c = this.getPDColl(this.empId);
        IRow row = null;
        for (int i = 0; i < c.size(); ++i) {
            row = this.kdtDegree.addRow();
            EmployeeClientUtils.setTableCellValueByInfo(row, c.get(i));
        }
    }

    private void refresh() throws Exception {
        this.kdtDegree.removeRows();
        this.loadDegrees();
    }

    protected void kdtQueryPersonLangQuery_editStopped(KDTEditEvent e) throws Exception {
        int index = e.getRowIndex();
        for (int i = 0; i < this.kdtDegree.getRowCount(); ++i) {
            if (i != index) continue;
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.kdtDegree.removeRows();
        try {
            this.loadDegrees();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionDegreeAddNew_actionPerformed(ActionEvent e) throws Exception {
        EmployeeClientUtils.addNewKDTableRow(this.kdtDegree);
    }

    @Override
    public void actionDegreeDelete_actionPerformed(ActionEvent e) throws Exception {
        EmployeeClientUtils.deleteKDTableRow(this.kdtDegree, this.delList);
    }

    @Override
    public void actionDegreeSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionDegreeSave_actionPerformed(e);
    }

    @Override
    public void setAddNewState() throws Exception {
        EmployeeClientUtils.setAddNewState((CoreUI)this);
        this.refresh();
    }

    @Override
    public void setEmpID(String empId) {
        this.empId = empId;
    }

    @Override
    public void setEnabled(boolean isArchives) {
        if (!isArchives) {
            this.btnDegreeAddNew.setEnabled(false);
            this.btnDegreeDelete.setEnabled(false);
            this.kdtDegree.setEnabled(false);
        }
    }

    protected IObjectValue createNewData() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.submit();
    }

    protected void inOnload() throws Exception {
    }
}

