/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.hraux.IBasicItem;
import com.kingdee.eas.basedata.hraux.StandingFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.base.FlowAspectFactory;
import com.kingdee.eas.hr.base.FlowReasonFactory;
import com.kingdee.eas.hr.base.FlowTypeFactory;
import com.kingdee.eas.hr.base.OutInStateFactory;
import com.kingdee.eas.hr.base.client.ListEditUI;
import com.kingdee.eas.hr.emp.IPersonFlow;
import com.kingdee.eas.hr.emp.PersonFlowCollection;
import com.kingdee.eas.hr.emp.PersonFlowFactory;
import com.kingdee.eas.hr.emp.client.AbstractEmployeeFlowUI;
import com.kingdee.eas.hr.emp.client.EmployeeClientUtils;
import com.kingdee.eas.hr.emp.client.IEmpInfoUI;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.JButton;

public class EmployeeFlowUI
extends AbstractEmployeeFlowUI
implements IEmpInfoUI {
    private String empId = null;
    private PersonInfo pInfo = null;
    private ArrayList delList = new ArrayList();

    private void checkInput() throws Exception {
        EmployeeClientUtils.checkTableCellIsNull(this.kdtFlow, "type");
        EmployeeClientUtils.checkTableCellIsNull(this.kdtFlow, "date");
        EmployeeClientUtils.checkHasInputRows(this.kdtFlow, this.delList);
    }

    @Override
    public void submit() throws Exception {
        this.checkInput();
        IObjectPK[] delArray = new IObjectPK[this.delList.size()];
        for (int i = 0; i < this.delList.size(); ++i) {
            delArray[i] = new ObjectUuidPK((BOSUuid)this.delList.get(i));
        }
        IPersonFlow ipf = PersonFlowFactory.getRemoteInstance();
        ipf.saveAll(EmployeeClientUtils.getFlowCollectionByKDTable(this.kdtFlow, EmployeeClientUtils.getPersonInfo(this.empId)), delArray);
        ListEditUI listEditUI = (ListEditUI)this.getUIContext().get("ListEditUI");
        listEditUI.setStatusBarMessage();
        this.refresh();
    }

    private void setTableCellEditor() throws Exception {
        this.kdtFlow.getColumn("type").setEditor(EmployeeClientUtils.getComboBoxCellEditor((IBasicItem)FlowTypeFactory.getRemoteInstance()));
        this.kdtFlow.getColumn("standing").setEditor(EmployeeClientUtils.getComboBoxCellEditor((IBasicItem)StandingFactory.getRemoteInstance()));
        this.kdtFlow.getColumn("inOutState").setEditor(EmployeeClientUtils.getComboBoxCellEditor((IBasicItem)OutInStateFactory.getRemoteInstance()));
        this.kdtFlow.getColumn("aspect").setEditor(EmployeeClientUtils.getComboBoxCellEditor((IBasicItem)FlowAspectFactory.getRemoteInstance()));
        this.kdtFlow.getColumn("reason").setEditor(EmployeeClientUtils.getComboBoxCellEditor((IBasicItem)FlowReasonFactory.getRemoteInstance()));
        this.kdtFlow.getColumn("date").setEditor(EmployeeClientUtils.getStartDateCellEditor());
        this.kdtFlow.getColumn("date").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
    }

    public void firstOnLoad() throws Exception {
        this.refresh();
    }

    private PersonFlowCollection getPFColl(String empId) throws BOSException {
        String oql = "select type.id, type.name, type.number, standing.id, standing.name, standing.number, ";
        oql = oql + "inOutState.id, inOutState.name, inOutState.number, unit, date, flowAspect.id, flowAspect.name, ";
        oql = oql + "flowAspect.number, reason.id, reason.name, reason.number where person.id = '" + empId + "'";
        return PersonFlowFactory.getRemoteInstance().getPersonFlowCollection(oql);
    }

    private void refresh() throws Exception {
        this.kdtFlow.removeRows();
        this.loadRecords();
    }

    @Override
    public void secondLoad() throws Exception {
        this.firstOnLoad();
    }

    public void onLoad() throws Exception {
        this.empId = (String)this.getUIContext().get("ID");
        super.onLoad();
        EmployeeClientUtils.initTableBtn((JButton)this.btnFlowAddNew, (JButton)this.btnFlowDelete);
        this.kdtFlow.checkParsed();
        this.setTableCellEditor();
        if (this.getOprtState().equals(OprtState.VIEW)) {
            EmployeeClientUtils.setKDTableViewState(this.kdtFlow);
            this.btnFlowAddNew.setEnabled(false);
            this.btnFlowDelete.setEnabled(false);
        }
        EmployeeClientUtils.setColumnBackColor(this.kdtFlow, "type");
        EmployeeClientUtils.setColumnBackColor(this.kdtFlow, "date");
        this.kdtFlow.getStyleAttributes().setWrapText(true);
        this.firstOnLoad();
        EmployeeClientUtils.setCellEditor(this.kdtFlow, "unit");
    }

    private void loadRecords() throws Exception {
        if (this.getUIContext().get("ID") != null) {
            this.empId = this.getUIContext().get("ID").toString();
        }
        PersonFlowCollection c = this.getPFColl(this.empId);
        Object row = null;
        for (int i = 0; i < c.size(); ++i) {
            EmployeeClientUtils.setTableCellValueByInfo(this.kdtFlow.addRow(), c.get(i));
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
        try {
            this.refresh();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionFlowAddNew_actionPerformed(ActionEvent e) throws Exception {
        EmployeeClientUtils.addNewKDTableRow(this.kdtFlow);
    }

    @Override
    public void actionFlowDelete_actionPerformed(ActionEvent e) throws Exception {
        EmployeeClientUtils.deleteKDTableRow(this.kdtFlow, this.delList);
    }

    @Override
    public void setAddNewState() throws Exception {
        EmployeeClientUtils.setAddNewState((CoreUI)this);
        this.refresh();
    }

    @Override
    public void setEmpID(String empId) {
        this.empId = empId;
    }

    @Override
    public void setEnabled(boolean isArchives) {
        if (!isArchives) {
            this.btnFlowAddNew.setEnabled(false);
            this.btnFlowDelete.setEnabled(false);
            this.kdtFlow.setEnabled(false);
        }
    }

    protected IObjectValue createNewData() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.submit();
    }

    protected void inOnload() throws Exception {
    }
}

