/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.client;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.person.BloodType;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.emp.EmployeeException;
import com.kingdee.eas.hr.emp.PersonLinkmanFactory;
import com.kingdee.eas.hr.emp.PersonLinkmanInfo;
import com.kingdee.eas.hr.emp.client.AbstractEmployeeLinkmanEditUI;
import com.kingdee.eas.hr.emp.client.EmployeeClientUtils;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;

public class EmployeeLinkmanEditUI
extends AbstractEmployeeLinkmanEditUI {
    private HROrgUnitInfo hroInfo = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected IObjectValue createNewData() {
        PersonLinkmanInfo info = new PersonLinkmanInfo();
        PersonInfo pInfo = new PersonInfo();
        pInfo.setId(BOSUuid.read((String)this.getUIContext().get("PersonID").toString()));
        info.setPerson(pInfo);
        info.setBloodType(BloodType.Unknown);
        return info;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return PersonLinkmanFactory.getRemoteInstance();
    }

    protected void afterOnLoad() throws Exception {
        super.afterOnLoad();
    }

    protected void beforeOnLoad() throws Exception {
        super.beforeOnLoad();
        this.hroInfo = (HROrgUnitInfo)this.getUIContext().get("currentHRO");
    }

    public IObjectPK runSubmit() throws Exception {
        this.editData.setHrOrgUnit(EmployeeClientUtils.getCurrentHRO(this.getUIContext()));
        this.editData.setCU(EmployeeClientUtils.getCurrentCU(this.getUIContext()));
        return super.runSubmit();
    }

    private HROrgUnitInfo getCurrentHRO() {
        if (this.hroInfo != null) {
            return this.hroInfo;
        }
        return SysContext.getSysContext().getCurrentHRUnit();
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        return new ObjectUuidPK(this.getCurrentHRO().getId());
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        if (StringUtils.isEmpty((String)this.editData.getName())) {
            this.txtName.requestFocusInWindow();
            throw new EmployeeException(EmployeeException.EMP_LINKMAN_NAME_NOT_NULL);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        if (OprtState.VIEW.equals(this.getOprtState())) {
            this.actionAddNew.setVisible(false);
            this.actionEdit.setVisible(false);
            this.actionCopy.setVisible(false);
            this.actionSubmit.setVisible(false);
            this.actionRemove.setVisible(false);
        } else {
            this.actionAddNew.setVisible(true);
            this.actionEdit.setVisible(true);
            this.actionCopy.setVisible(true);
            this.actionSubmit.setVisible(true);
            this.actionRemove.setVisible(true);
        }
    }

    protected void handlePermissionForItemAction(ItemAction action) {
        if (this.getUIContext().get("NO_PERMISSION") == null) {
            super.handlePermissionForItemAction(action);
        }
    }

    @Override
    protected OrgType getMainBizOrgType() {
        return OrgType.HRO;
    }
}

