/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.core.hr.util.HRParamUtil;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.base.TechPostLevelFactory;
import com.kingdee.eas.hr.base.TechPostLevelInfo;
import com.kingdee.eas.hr.emp.client.AbstractEmployeeMainListFilterUI;
import com.kingdee.eas.hr.org.client.AdminByOrgRangePromptBox;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class EmployeeMainListFilterUI
extends AbstractEmployeeMainListFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(EmployeeMainListFilterUI.class);

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public FilterInfo getFilterInfo() {
        return this.getCustomerFilter();
    }

    public FilterInfo getCustomerFilter() {
        FilterInfo filterInfo = null;
        if (this.prmtAdminF7.getData() != null) {
            filterInfo = new FilterInfo();
            String pk = ((AdminOrgUnitInfo)this.prmtAdminF7.getData()).getId().toString();
            filterInfo.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.id", (Object)pk));
            if (this.chkInclude.isSelected()) {
                AdminOrgUnitInfo adminInfo = null;
                try {
                    adminInfo = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(pk));
                }
                catch (Exception e) {
                    ExceptionHandler.handle((Throwable)e);
                }
                filterInfo.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.longNumber", (Object)(adminInfo.getLongNumber() + "!%"), CompareType.LIKE));
                filterInfo.setMaskString("(#0 or #1)");
            }
        }
        if (this.prmtTechPostLevel.getData() != null) {
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT DISTINCT FPersonID FROM T_HR_PersonTechPost ");
            sql.append("INNER JOIN T_HR_BDTechnicalPost ");
            sql.append("ON T_HR_BDTechnicalPost.FID = T_HR_PersonTechPost.FTechnicalPostID ");
            sql.append("WHERE FLevelID = '");
            sql.append(((TechPostLevelInfo)this.prmtTechPostLevel.getData()).getId().toString());
            sql.append("' ");
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("id", (Object)sql.toString(), CompareType.INNER));
            try {
                if (this.prmtAdminF7.getData() != null) {
                    filterInfo.mergeFilter(fi, "and");
                } else {
                    filterInfo = fi;
                }
                return filterInfo;
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        return filterInfo;
    }

    public void clear() {
        super.clear();
        this.prmtAdminF7.setData(null);
        this.chkInclude.setSelected(false);
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.prmtAdminF7.setQueryInfo("com.kingdee.eas.basedata.org.app.AdminOrgUnitQuery");
        this.prmtAdminF7.setCommitFormat("$number$");
        this.prmtAdminF7.setEditFormat("$number$");
        this.prmtAdminF7.setDisplayFormat("$name$");
        this.prmtAdminF7.setEditable(false);
        AdminByOrgRangePromptBox adminPromptBox = new AdminByOrgRangePromptBox("true");
        String hrOrgId = null;
        boolean value = false;
        HROrgUnitInfo hrOrgInfo = SysContext.getSysContext().getCurrentHRUnit();
        if (hrOrgInfo != null) {
            hrOrgId = hrOrgInfo.getId().toString();
        }
        try {
            value = HRParamUtil.getParamOfHR(null, (String)"IS_AdminOrgOrHROrg_ShowPerson", (String)hrOrgId);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        HashSet<String> hroSet = new HashSet<String>();
        hroSet.add(hrOrgId);
        if (value) {
            adminPromptBox.setHROFilter(hroSet);
        }
        this.prmtAdminF7.setSelector((KDPromptSelector)adminPromptBox);
        this.prmtTechPostLevel.setCommitFormat("$name$");
        this.prmtTechPostLevel.setDisplayFormat("$name$");
        this.prmtTechPostLevel.setEditFormat("$name$");
    }

    public void setCustomerParams(CustomerParams param) {
        super.setCustomerParams(param);
        if (param == null) {
            return;
        }
        ObjectUuidPK pk = null;
        if (param.getCustomerParam("ADMIN_ID") != null) {
            pk = new ObjectUuidPK(BOSUuid.read((String)param.getCustomerParam("ADMIN_ID")));
            AdminOrgUnitInfo adminInfo = null;
            try {
                adminInfo = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitInfo((IObjectPK)pk);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
            this.prmtAdminF7.setData((Object)adminInfo);
        } else {
            this.prmtAdminF7.setData(null);
        }
        this.chkInclude.setSelected(param.getBoolean("IS_INCLUDE"));
        if (param.getCustomerParam("TPL_ID") != null) {
            pk = new ObjectUuidPK(BOSUuid.read((String)param.getCustomerParam("TPL_ID")));
            TechPostLevelInfo tplInfo = null;
            try {
                tplInfo = TechPostLevelFactory.getRemoteInstance().getTechPostLevelInfo((IObjectPK)pk);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
            this.prmtTechPostLevel.setData((Object)tplInfo);
        } else {
            this.prmtTechPostLevel.setData(null);
        }
    }

    public CustomerParams getCustomerParams() {
        CustomerParams params = new CustomerParams();
        if (this.prmtAdminF7.getData() != null) {
            params.addCustomerParam("ADMIN_ID", ((AdminOrgUnitInfo)this.prmtAdminF7.getData()).getId().toString());
        }
        params.putBoolean("IS_INCLUDE", this.chkInclude.isSelected());
        if (this.prmtTechPostLevel.getData() != null) {
            params.addCustomerParam("TPL_ID", ((TechPostLevelInfo)this.prmtTechPostLevel.getData()).getId().toString());
        }
        return params;
    }
}

