/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.hr.util.AdminTreeBuilder;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.hraux.util.HRTreeUtil;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.hr.base.EmployeeFenLeiInfo;
import com.kingdee.eas.hr.base.EmployeeTypeInfo;
import com.kingdee.eas.hr.base.util.HRUtil;
import com.kingdee.eas.hr.base.util.PerHRAndCUUtil;
import com.kingdee.eas.hr.emp.EmpInnerFacadeFactory;
import com.kingdee.eas.hr.emp.EmployeeException;
import com.kingdee.eas.hr.emp.IEmpInnerFacade;
import com.kingdee.eas.hr.emp.client.AbstractEmployeeMainListUI2;
import com.kingdee.eas.hr.emp.client.EmpInServiceType;
import com.kingdee.eas.hr.emp.client.EmpTypeConvertBatchEditUI;
import com.kingdee.eas.hr.emp.client.EmpTypeConvertHisListUI;
import com.kingdee.eas.hr.emp.client.EmployeeBatchEditUI;
import com.kingdee.eas.hr.emp.client.EmployeeTreeEditUI;
import com.kingdee.eas.hr.emp.client.util.EMPTableUtil;
import com.kingdee.eas.hr.org.OrgHRCommonFactory;
import com.kingdee.eas.tools.datatask.client.DatataskCaller;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class EmployeeMainListUI2
extends AbstractEmployeeMainListUI2 {
    private static Logger logger = Logger.getLogger(EmployeeMainListUI2.class);
    private DefaultKingdeeTreeNode selectNode = null;
    private DefaultKingdeeTreeNode selectNode2 = null;
    private Set cuSet = null;
    private Set hrSet = null;
    private HashSet permissionHROrg = null;
    private static Map positionHROCache = new HashMap();
    private boolean isRefresh = false;
    protected String resClass = "com.kingdee.eas.basedata.person.client.PersonResource.";
    private String quickSearchStr = null;

    protected boolean isSupportDynQuery() {
        return true;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnBatch.setIcon(EASResource.getIcon((String)"imgTbtn_stafferbatch"));
        this.btnEmpTypeConvert.setIcon(EASResource.getIcon((String)"imgTbtn_switchorganise"));
        this.btnEmpTypeConvertAudit.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.btnEmpTypeConvertHis.setIcon(EASResource.getIcon((String)"imgTbtn_showlist"));
        this.menuItemBatch.setIcon(EASResource.getIcon((String)"imgTbtn_stafferbatch"));
        this.menuItemEmpTypeConvert.setIcon(EASResource.getIcon((String)"imgTbtn_switchorganise"));
        this.menuItemEmpTypeConvertAudit.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.menuItemEmpTypeConvertHis.setIcon(EASResource.getIcon((String)"imgTbtn_showlist"));
        this.chkIncludeChild.setEnabled(true);
        this.chkShowSealUp.setEnabled(true);
        this.chkShowVirtualOrg.setVisible(true);
        this.chkShowVirtualOrg.setEnabled(true);
        this.treeView.setMinimumSize(new Dimension(10, 10));
        this.treeView2.setMinimumSize(new Dimension(10, 10));
        this.actionNoPositionEmpExport.setVisible(false);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.getUIContext().put("EmployeeMainListUI2", "EmployeeMainListUI2");
        this.checkEmployeeType();
        super.actionAddNew_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (!this.checkPermission("noposition_update")) {
            return;
        }
        super.actionEdit_actionPerformed(e);
    }

    private boolean checkPermission(String permissionItem) throws Exception {
        IPermission permission = PermissionFactory.getRemoteInstance();
        ObjectUuidPK userPk = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
        ObjectUuidPK orgPk = new ObjectUuidPK(SysContext.getSysContext().getCurrentHRUnit().getId());
        PersonInfo pInfo = new PersonInfo();
        int[] rows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        IRow row = this.tblMain.getRow(rows[0]);
        pInfo = PersonFactory.getRemoteInstance().getPersonInfo((IObjectPK)new ObjectUuidPK(row.getCell("id").getValue().toString()));
        boolean haspermission = permission.hasDataPermission((IObjectPK)userPk, (IObjectPK)orgPk, permissionItem, (IObjectValue)pInfo);
        if (!haspermission) {
            if ("noposition_update".equals(permissionItem)) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource.235_lbl"));
                return false;
            }
            if ("noposition_delete".equals(permissionItem)) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource.236_lbl"));
                return false;
            }
            if ("noposition_view".equals(permissionItem)) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource.237_lbl"));
                return false;
            }
        }
        return true;
    }

    protected void getRowSetBeforeFillTable(IRowSet rowSet) {
        super.getRowSetBeforeFillTable(rowSet);
        try {
            HashSet<String> personIdSet = new HashSet<String>();
            while (rowSet.next()) {
                personIdSet.add(rowSet.getString("id"));
            }
            if (personIdSet.size() > 0) {
                Map personHroMap = OrgHRCommonFactory.getRemoteInstance().getPersonHROBatch(personIdSet);
                for (Map.Entry entry : personHroMap.entrySet()) {
                    Object[] obj = (Object[])entry.getValue();
                    Set set = (Set)obj[1];
                    Iterator setIt = set.iterator();
                    while (setIt.hasNext()) {
                        positionHROCache.put(setIt.next(), obj[0]);
                    }
                }
            }
            rowSet.beforeFirst();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void checkEmployeeType() throws EmployeeException {
        TreePath path = this.treeMain.getSelectionPath();
        if (path != null) {
            DefaultKingdeeTreeNode selectNode = (DefaultKingdeeTreeNode)path.getLastPathComponent();
            if (selectNode.getUserObject() instanceof EmpInServiceType) {
                throw new EmployeeException(EmployeeException.MUST_SELECT_EMPTYPESTATE);
            }
            this.getUIContext().put("EMP_STATE", selectNode.getUserObject());
            this.getUIContext().put("FROM_TYPE", "EMP_STATE");
        } else {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Leaf_MustSelected"));
            SysUtil.abort();
        }
    }

    protected String getEditUIName() {
        return EmployeeTreeEditUI.class.getName();
    }

    public void onLoad() throws Exception {
        this.mainQueryPK = new MetaDataPK("com.kingdee.eas.hr.emp.app", "EmployeeNoPosition2Query");
        this.permissionHROrg = this.getHROrgUnitIds();
        if (this.permissionHROrg == null || this.permissionHROrg.size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)(this.resClass + "HR_EMPLOYEESTATE_VIEW")));
            SysUtil.abort();
        }
        super.onLoad();
        EMPTableUtil.setColumnDateFormat(this.tblMain, "birthday");
        this.quickSearchStr = this.txtSearch.getText();
        CtrlSwingUtilities.removeManagingFocusForwardTraversalKeys((JComponent)this.txtSearch, (KeyStroke)KeyStroke.getKeyStroke(10, 0));
        this.btnQuickSearch.setIcon(EASResource.getIcon((String)"imgTbtn_find"));
        this.menuBiz.setVisible(true);
        this.btnAssignPosition.setVisible(false);
        this.menuItemImportData.setVisible(false);
        this.buildEmployeeFenLeiTree();
        this.btnLocate.setVisible(true);
        this.kDSplitPane2.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                EmployeeMainListUI2.this.kDSplitPane2.setDividerLocation(0.3333333333333333);
            }
        });
        this.btnNoPositionEmpImport.setEnabled(true);
        this.menuItemNoPositionEmpImport.setEnabled(true);
        this.actionBatch.setEnabled(true);
        this.mainQuery.setIngorePreOrders(true);
        this.buildAdminOrgUnitTree(false);
    }

    private void buildEmployeeFenLeiTree() throws Exception {
        DefaultKingdeeTreeNode rootNode = HRTreeUtil.createEmployeeFenLeiTreeNode((boolean)true);
        DefaultTreeModel model = new DefaultTreeModel((TreeNode)rootNode);
        this.treeMain.setModel((TreeModel)model);
        this.treeMain.expandAllNodes(true, (TreeNode)rootNode);
        if (this.getDefaultEntityViewInfo() == null) {
            if (rootNode.getChildCount() > 0) {
                this.treeMain.setSelectionNode((DefaultKingdeeTreeNode)rootNode.getChildAt(0));
            } else {
                this.treeMain.setSelectionNode(rootNode);
            }
        } else {
            this.actionEmpTypeConvert.setEnabled(false);
        }
        this.treeMain.setShowsRootHandles(true);
    }

    private void buildAdminOrgUnitTree(boolean isShowSealUp) throws Exception {
        AdminTreeBuilder treeBuilder = null;
        treeBuilder = new AdminTreeBuilder(false, null);
        treeBuilder.setShowVirtualOrg(this.chkShowVirtualOrg.isSelected());
        treeBuilder.buildTree((JTree)this.treeMain2, isShowSealUp);
    }

    protected void refresh(ActionEvent e) throws Exception {
        if (e != null && "com.kingdee.eas.framework.client.AbstractListUI$ActionEdit".equals(e.getActionCommand())) {
            return;
        }
        super.refresh(e);
        this.tblMain.removeRows();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    protected String[] getLocateNames() {
        String[] locateNames = new String[]{"name", "number"};
        return locateNames;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void treeMain_valueChanged(TreeSelectionEvent e) throws Exception {
        TreePath path = this.treeMain.getSelectionPath();
        if (path == null) {
            return;
        }
        this.actionBatch.setEnabled(false);
        this.actionEmpTypeConvert.setEnabled(false);
        this.actionAddNew.setEnabled(false);
        this.selectNode = (DefaultKingdeeTreeNode)path.getLastPathComponent();
        this.mainQueryPK = new MetaDataPK("com.kingdee.eas.hr.emp.app", "EmployeeNoPosition2Query");
        if (this.mainQuery == null) {
            this.mainQuery = new EntityViewInfo();
        } else if (this.mainQuery.getFilter() != null) {
            this.mainQuery.setFilter(new FilterInfo());
        }
        if (!(this.selectNode.getUserObject() instanceof EmployeeFenLeiInfo) && this.selectNode.getUserObject() instanceof EmployeeTypeInfo) {
            this.actionBatch.setEnabled(true);
            this.actionEmpTypeConvert.setEnabled(true);
            EmployeeTypeInfo typeInfo = (EmployeeTypeInfo)this.selectNode.getUserObject();
            if (typeInfo.getInService().getValue() == 1 || typeInfo.getInService().getValue() == 4) {
                this.actionAddNew.setEnabled(false);
            } else {
                this.actionAddNew.setEnabled(true);
            }
        }
        this.mainQuery.setFilter(this.getDefaultFilterForQuery());
        SorterItemInfo stInfo = new SorterItemInfo();
        stInfo.setPropertyName("indexOf");
        stInfo.setSortType(SortType.ASCEND);
        SorterItemCollection stCol = new SorterItemCollection();
        stCol.add(stInfo);
        this.mainQuery.setSorter(stCol);
        this.tblMain.removeRows();
    }

    @Override
    protected void treeMain2_valueChanged(TreeSelectionEvent e) throws Exception {
        this.treeMain_valueChanged(null);
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        if (this.selectNode.getUserObject() instanceof EmployeeTypeInfo) {
            EmployeeTypeInfo typeInfo = (EmployeeTypeInfo)this.selectNode.getUserObject();
            uiContext.put((Object)"employeeType", (Object)typeInfo);
            if (typeInfo != null && !typeInfo.getId().toString().equals("00000000-0000-0000-0000-000000000001A29E85B3")) {
                if (typeInfo.getInService().getValue() != 1 && typeInfo.getInService().getValue() != 4) {
                    uiContext.put((Object)"NO_Position", (Object)Boolean.TRUE);
                } else {
                    uiContext.put((Object)"NO_Position", (Object)Boolean.FALSE);
                }
            }
        }
        int[] rowID = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        HashMap<Object, String> personDepMap = new HashMap<Object, String>();
        HashMap<Object, PositionInfo> personPositionMap = new HashMap<Object, PositionInfo>();
        HashMap<Object, PersonInfo> personInfoMap = new HashMap<Object, PersonInfo>();
        for (int i = 0; i < rowID.length; ++i) {
            IRow row = this.tblMain.getRow(rowID[i]);
            if (row == null) continue;
            String adminOrgUnitId = "";
            if (row.getCell("AdminOrgUnit.id") != null && row.getCell("AdminOrgUnit.id").getValue() != null) {
                adminOrgUnitId = row.getCell("AdminOrgUnit.id").getValue().toString();
                personDepMap.put(row.getCell("id").getValue(), adminOrgUnitId);
            }
            if (row.getCell("Position.id") != null && !StringUtils.isEmpty((String)((String)row.getCell("Position.id").getValue()))) {
                PositionInfo position = new PositionInfo();
                position.setId(BOSUuid.read((String)((String)row.getCell("Position.id").getValue())));
                position.setName((String)row.getCell("Position.name").getValue());
                personPositionMap.put(row.getCell("id").getValue(), position);
            }
            PersonInfo person = new PersonInfo();
            person.setId(BOSUuid.read((String)((String)row.getCell("id").getValue())));
            person.setNumber((String)row.getCell("person.number").getValue());
            person.setName((String)row.getCell("person.name").getValue());
            personInfoMap.put(row.getCell("id").getValue(), person);
        }
        uiContext.put((Object)"personInfoMap", personInfoMap);
        uiContext.put((Object)"personPositionMap", personPositionMap);
        uiContext.put((Object)"personDepMap", personDepMap);
        uiContext.put((Object)"positionHROCache", (Object)positionHROCache);
        uiContext.put((Object)"FROM_EmployeeType", (Object)"OK");
        uiContext.put((Object)"EMP_STATE", this.selectNode.getUserObject());
        uiContext.put((Object)"FROM_TYPE", (Object)"EMP_STATE");
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (!this.checkPermission("noposition_delete")) {
            return;
        }
        if (this.confirmRemove()) {
            try {
                IEmpInnerFacade iEmp = EmpInnerFacadeFactory.getRemoteInstance();
                iEmp.personDelete((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.getSelectedKeyValue())));
            }
            catch (ObjectNotFoundException onfe) {
                logger.error((Object)onfe.getMessage());
                this.refreshList();
                throw new EASBizException(EASBizException.CHECKEXIST);
            }
            this.refresh(e);
        }
    }

    private PersonCollection getSelectedPersons() {
        PersonCollection pInfos = new PersonCollection();
        PersonInfo pInfo = null;
        super.checkSelected();
        if (this.tblMain.getSelectManager().get().getMode() == 8) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resClass, (String)"SELECT_NOT_SUPPORT_VIRTUAL"));
            SysUtil.abort();
        }
        int[] indexs = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        for (int i = 0; i < indexs.length; ++i) {
            pInfo = new PersonInfo();
            pInfo.setId(BOSUuid.read((String)this.tblMain.getRow(indexs[i]).getCell("id").getValue().toString()));
            if (this.tblMain.getRow(indexs[i]).getCell("name").getValue() == null) {
                pInfo.setName(null);
            } else {
                pInfo.setName(this.tblMain.getRow(indexs[i]).getCell("name").getValue().toString());
            }
            pInfo.setNumber(this.tblMain.getRow(indexs[i]).getCell("number").getValue().toString());
            pInfos.add(pInfo);
        }
        return pInfos;
    }

    private Set getSelectedPersonSet() {
        HashSet<String> perSet = new HashSet<String>();
        super.checkSelected();
        if (this.tblMain.getSelectManager().get().getMode() == 8) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"214_EmployeeMainListUI2"));
            SysUtil.abort();
        }
        int[] indexs = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        for (int i = 0; i < indexs.length; ++i) {
            perSet.add(this.tblMain.getRow(indexs[i]).getCell("id").getValue().toString());
        }
        return perSet;
    }

    @Override
    public void actionBatch_actionPerformed(ActionEvent e) throws Exception {
        EmployeeTypeInfo typeInfo;
        this.checkManyHR();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"Owner", (Object)this);
        uiContext.put((Object)"personInfos", (Object)this.getSelectedPersons());
        uiContext.put((Object)"editType", (Object)Boolean.FALSE);
        uiContext.put((Object)"cuSet", (Object)this.cuSet);
        uiContext.put((Object)"hrSet", (Object)this.hrSet);
        if (this.selectNode != null && this.selectNode.getUserObject() instanceof EmployeeTypeInfo && (typeInfo = (EmployeeTypeInfo)this.selectNode.getUserObject()) != null && !typeInfo.getId().toString().equals("00000000-0000-0000-0000-000000000001A29E85B3")) {
            uiContext.put((Object)"employeeType", (Object)typeInfo);
            if (typeInfo.getInService().getValue() != 1 && typeInfo.getInService().getValue() != 4) {
                uiContext.put((Object)"NO_POSITION", (Object)Boolean.TRUE);
            } else {
                uiContext.put((Object)"NO_POSITION", (Object)Boolean.FALSE);
            }
        }
        IUIFactory uiFactory = null;
        try {
            uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory");
            IUIWindow curDialog = uiFactory.create(EmployeeBatchEditUI.class.getName(), (Map)uiContext);
            curDialog.show();
        }
        catch (UIException ex1) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)ex1);
        }
    }

    @Override
    public void actionEmpTypeConvert_actionPerformed(ActionEvent e) throws Exception {
        this.checkManyHR();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"Owner", (Object)this);
        uiContext.put((Object)"personInfos", (Object)this.getSelectedPersons());
        uiContext.put((Object)"cuSet", (Object)this.cuSet);
        uiContext.put((Object)"hrSet", (Object)this.hrSet);
        uiContext.put((Object)"isAudit", (Object)Boolean.FALSE);
        if (this.selectNode != null && this.selectNode.getUserObject() instanceof EmployeeTypeInfo) {
            EmployeeTypeInfo typeInfo = (EmployeeTypeInfo)this.selectNode.getUserObject();
            uiContext.put((Object)"employeeType", (Object)typeInfo);
        }
        IUIWindow curDialog = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(EmpTypeConvertBatchEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        curDialog.show();
    }

    private void checkManyHR() throws BOSException, EmployeeException {
        Set hrNowSet;
        HashSet perSet = new HashSet();
        ArrayList perIdList = this.getSelectedIdValues();
        int size = perIdList.size();
        for (int i = 0; i < size; ++i) {
            perSet.add(perIdList.get(i));
        }
        this.hrSet = hrNowSet = PerHRAndCUUtil.getHRsFromPerSet(null, perSet);
        this.cuSet = PerHRAndCUUtil.getCUsFromPerSet(null, perSet);
        if (hrNowSet.size() > 1) {
            throw new EmployeeException(EmployeeException.MANYHR_NOT_SUPPORT, new Object[]{PerHRAndCUUtil.getHRsName(null, (Set)hrNowSet)});
        }
        if (this.hrSet.size() == 0) {
            throw new EmployeeException(EmployeeException.PERSON_NOT_HAVE_HRORG);
        }
    }

    protected HashSet getHROrgUnitIds() throws BOSException, EASBizException {
        FullOrgUnitCollection orgCollection = PermissionFactory.getRemoteInstance().getAuthorizedOrg((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId()), OrgType.HRO, null, "noposition_view");
        HashSet<String> ids = new HashSet<String>();
        if (orgCollection != null) {
            int n = orgCollection.size();
            for (int i = 0; i < n; ++i) {
                ids.add(orgCollection.get(i).getId().toString());
            }
        }
        return ids;
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        if (action == null) {
            return null;
        }
        String actionName = action.getClass().getName();
        if (actionName.indexOf("$") >= 0) {
            actionName = actionName.substring(actionName.indexOf("$") + 1);
        }
        if ("ActionBatch".equalsIgnoreCase(actionName) || "ActionEmpTypeConvert".equalsIgnoreCase(actionName) || "ActionEdit".equalsIgnoreCase(actionName)) {
            this.checkSelected();
            String selectedId = null;
            selectedId = this.getCurRowAdminOrgUnitId();
            if (selectedId != null) {
                ObjectUuidPK pk = null;
                HROrgUnitInfo hrOrgUnitInfo = this.getMyOrgPK(selectedId);
                if (hrOrgUnitInfo != null) {
                    pk = new ObjectUuidPK(hrOrgUnitInfo.getId());
                }
                return pk;
            }
            return super.getOrgPK(action);
        }
        return super.getOrgPK(action);
    }

    protected HROrgUnitInfo getMyOrgPK(String selectedId) {
        if (selectedId == null) {
            return null;
        }
        HROrgUnitInfo info = null;
        if (positionHROCache.containsKey(selectedId)) {
            info = (HROrgUnitInfo)positionHROCache.get(selectedId);
        } else {
            try {
                info = BOSUuid.read((String)selectedId).getType().toString().equals("74AE612E") ? OrgHRCommonFactory.getRemoteInstance().getPositionOrgHRO(selectedId) : OrgHRCommonFactory.getRemoteInstance().getAdminOrgHRO(selectedId);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        positionHROCache.put(selectedId, info);
        return info;
    }

    @Override
    public void actionEmpTypeConvertAudit_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow curDialog = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(EmpTypeConvertHisListUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        curDialog.show();
        this.isRefresh = ((EmpTypeConvertHisListUI)curDialog.getUIObject()).isRefreshParent();
        if (this.isRefresh) {
            this.tblMain.removeRows();
        }
    }

    @Override
    public void actionEmpTypeConvertHis_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"PersonID", (Object)this.getSelectedPersonSet());
        uiContext.put((Object)"isOnePerson", (Object)"1");
        IUIWindow curDialog = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(EmpTypeConvertHisListUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        curDialog.show();
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.PEOPLE_ORGANIZATION;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.id", (Object)HRUtil.getAdminOrgRangeAndHRSql((Set)this.permissionHROrg), CompareType.INNER));
        TreePath path = this.treeMain.getSelectionPath();
        TreePath path2 = this.treeMain2.getSelectionPath();
        if (path != null) {
            this.selectNode = (DefaultKingdeeTreeNode)path.getLastPathComponent();
        }
        if (path2 != null) {
            this.selectNode2 = (DefaultKingdeeTreeNode)path2.getLastPathComponent();
        }
        if (this.selectNode != null && this.selectNode.getUserObject() instanceof EmployeeFenLeiInfo) {
            EmployeeFenLeiInfo fenLeiInfo = (EmployeeFenLeiInfo)this.selectNode.getUserObject();
            filter.getFilterItems().add(new FilterItemInfo("EmpFenLei.longNumber", (Object)fenLeiInfo.getLongNumber()));
            filter.getFilterItems().add(new FilterItemInfo("EmpFenLei.longNumber", (Object)(fenLeiInfo.getLongNumber() + "!%"), CompareType.LIKE));
            filter.setMaskString("#0 and (#1 or #2)");
        } else if (this.selectNode != null && this.selectNode.getUserObject() instanceof EmployeeTypeInfo) {
            EmployeeTypeInfo typeInfo = (EmployeeTypeInfo)this.selectNode.getUserObject();
            filter.getFilterItems().add(new FilterItemInfo("employeeType.id", (Object)typeInfo.getId().toString()));
            filter.setMaskString("#0 and #1 ");
        }
        if (this.selectNode2 != null && this.selectNode2.getUserObject() instanceof AdminOrgUnitInfo) {
            AdminOrgUnitInfo adminInfo = (AdminOrgUnitInfo)this.selectNode2.getUserObject();
            FilterInfo filterInfo = new FilterInfo();
            if (this.chkIncludeChild.isSelected()) {
                filterInfo.getFilterItems().add(new FilterItemInfo("admin.longNumber", (Object)(adminInfo.getLongNumber() + "!%"), CompareType.LIKE));
                filterInfo.getFilterItems().add(new FilterItemInfo("admin.longNumber", (Object)adminInfo.getLongNumber()));
                filterInfo.setMaskString("(#0 or #1)");
            } else {
                filterInfo.getFilterItems().add(new FilterItemInfo("admin.id", (Object)adminInfo.getId()));
            }
            try {
                filter.mergeFilter(filterInfo, "and");
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage());
            }
        }
        try {
            if (!this.chkShowSealUp.isSelected()) {
                FilterInfo filterSealUp = new FilterInfo("admin.isSealUp = 0");
                filter.mergeFilter(filterSealUp, "and");
            }
            if (!this.chkShowVirtualOrg.isSelected()) {
                FilterInfo virtualFilter = new FilterInfo("admin.isVirtual = 0");
                filter.mergeFilter(virtualFilter, "and");
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return filter;
    }

    protected void handlePermissionForItemAction(ItemAction action) {
        super.handlePermissionForItemAction(action);
    }

    private void displayAllName() {
        this.applyPreference();
        boolean isSelected = this.chkDisplayName.isSelected();
        if (!this.tblMain.getColumn("oldPersonDep.name").getStyleAttributes().isHided() || !this.tblMain.getColumn("oldPersonDep.displayName").getStyleAttributes().isHided()) {
            this.tblMain.getColumn("oldPersonDep.name").getStyleAttributes().setHided(isSelected);
            this.tblMain.getColumn("oldPersonDep.displayName").getStyleAttributes().setHided(!isSelected);
            if (isSelected) {
                this.tblMain.getColumn("oldPersonDep.name").setWidth(-1);
            } else {
                this.tblMain.getColumn("oldPersonDep.displayName").setWidth(-1);
            }
        }
        if (!this.tblMain.getColumn("admin").getStyleAttributes().isHided() || !this.tblMain.getColumn("admin.displayName").getStyleAttributes().isHided()) {
            this.tblMain.getColumn("admin").getStyleAttributes().setHided(isSelected);
            this.tblMain.getColumn("admin.displayName").getStyleAttributes().setHided(!isSelected);
            if (isSelected) {
                this.tblMain.getColumn("admin").setWidth(-1);
            } else {
                this.tblMain.getColumn("admin.displayName").setWidth(-1);
            }
        }
    }

    @Override
    public void actionDisplayName_actionPerformed(ActionEvent e) throws Exception {
        this.displayAllName();
    }

    protected void applyPreference() {
        super.applyPreference();
        int oldDisplayNameIndex = this.tblMain.getColumn("oldPersonDep.displayName").getColumnIndex();
        int oldNameIndex = this.tblMain.getColumn("oldPersonDep.name").getColumnIndex();
        int newDisplayNameIndex = this.tblMain.getColumn("admin.displayName").getColumnIndex();
        int newNameIndex = this.tblMain.getColumn("admin").getColumnIndex();
        boolean movable = this.tblMain.isColumnMoveable();
        this.tblMain.setColumnMoveable(true);
        this.tblMain.moveColumn(oldDisplayNameIndex, oldNameIndex);
        this.tblMain.moveColumn(newDisplayNameIndex, newNameIndex);
        this.tblMain.setColumnMoveable(movable);
    }

    @Override
    public void actionIncludeChild_actionPerformed(ActionEvent e) throws Exception {
        this.treeMain_valueChanged(null);
    }

    @Override
    public void actionShowSealUp_actionPerformed(ActionEvent e) throws Exception {
        this.buildAdminOrgUnitTree(this.chkShowSealUp.isSelected());
        this.treeMain_valueChanged(null);
    }

    protected void tblMain_doRequestRowSet(RequestRowSetEvent e) {
        super.tblMain_doRequestRowSet(e);
    }

    protected void doFieldPermission() {
    }

    @Override
    protected void chkShowVirtualOrg_itemStateChanged(ItemEvent e) throws Exception {
        this.buildAdminOrgUnitTree(this.chkShowSealUp.isSelected());
        this.treeMain_valueChanged(null);
    }

    @Override
    protected void txtSearch_focusGained(FocusEvent e) throws Exception {
        if (!StringUtils.isEmpty((String)this.txtSearch.getText())) {
            if (this.txtSearch.getText().equals(this.quickSearchStr)) {
                this.txtSearch.setText(null);
            }
        } else {
            this.txtSearch.setText(null);
        }
    }

    @Override
    protected void txtSearch_focusLost(FocusEvent e) throws Exception {
        if (StringUtils.isEmpty((String)this.txtSearch.getText())) {
            this.txtSearch.setText(this.quickSearchStr);
        }
    }

    @Override
    protected void txtSearch_keyReleased(KeyEvent e) throws Exception {
        if (e.getKeyCode() == 10) {
            if (this.mainQuery == null) {
                this.mainQuery = new EntityViewInfo();
            }
            this.employeeFastQuery();
        }
    }

    @Override
    public void actionQuickSearch_actionPerformed(ActionEvent e) throws Exception {
        this.employeeFastQuery();
    }

    private void employeeFastQuery() throws Exception {
        if (this.mainQuery == null) {
            this.mainQuery = new EntityViewInfo();
        }
        if (StringUtils.isEmpty((String)this.txtSearch.getText())) {
            return;
        }
        String param = this.txtSearch.getText();
        FilterInfo filterInfo = new FilterInfo();
        if (!this.txtSearch.getText().equals(this.quickSearchStr)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("NUMBER", (Object)("%" + param + "%"), CompareType.LIKE));
            filterInfo.getFilterItems().add(new FilterItemInfo("NAME", (Object)("%" + param + "%"), CompareType.LIKE));
            filterInfo.getFilterItems().add(new FilterItemInfo("SIMPLENAMEPINGYIN", (Object)(param.toLowerCase() + "%"), CompareType.LIKE));
            filterInfo.getFilterItems().add(new FilterItemInfo("POSITION.NAME", (Object)("%" + param + "%"), CompareType.LIKE));
            filterInfo.getFilterItems().add(new FilterItemInfo("admin.NAME", (Object)("%" + param + "%"), CompareType.LIKE));
            filterInfo.getFilterItems().add(new FilterItemInfo("idCardNO", (Object)("%" + param + "%"), CompareType.LIKE));
            filterInfo.setMaskString("#0 or #1 or #2 or #3 or #4 or #5");
        }
        filterInfo.mergeFilter(this.getDefaultFilterForQuery(), "and");
        this.mainQuery.setFilter(filterInfo);
        this.tblMain.removeRows();
        this.tblMain.requestFocusInWindow();
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        if (!this.checkPermission("noposition_view")) {
            return;
        }
        super.actionView_actionPerformed(e);
    }

    protected String[] getCountQueryFields() {
        return new String[]{"id"};
    }

    @Override
    public void actionNoPositionEmpImport_actionPerformed(ActionEvent e) throws Exception {
        String strSolutionName = "eas.hr.emp.noPositionEmpInfo";
        this.importData(strSolutionName);
        this.tblMain.removeRows();
    }

    private void importData(String strSolutionName) throws Exception {
        DatataskCaller task = new DatataskCaller();
        task.setParentComponent((Component)((Object)this));
        if (this.getImportParam(strSolutionName) != null) {
            task.invoke(this.getImportParam(strSolutionName), 0, true);
        }
    }
}

