/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.base.client.ListEditUI;
import com.kingdee.eas.hr.emp.IPersonResource;
import com.kingdee.eas.hr.emp.PersonResourceCollection;
import com.kingdee.eas.hr.emp.PersonResourceFactory;
import com.kingdee.eas.hr.emp.client.AbstractEmployeeResourceUI;
import com.kingdee.eas.hr.emp.client.EmployeeClientUtils;
import com.kingdee.eas.hr.emp.client.IEmpInfoUI;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.JButton;

public class EmployeeResourceUI
extends AbstractEmployeeResourceUI
implements IEmpInfoUI {
    private String empId = null;
    private PersonInfo pInfo = null;
    private ArrayList delList = new ArrayList();

    private void checkInput() throws Exception {
        EmployeeClientUtils.checkTableCellIsNull(this.kdtResource, "name");
        EmployeeClientUtils.checkTableCellIsNull(this.kdtResource, "number");
        EmployeeClientUtils.checkHasInputRows(this.kdtResource, this.delList);
    }

    @Override
    public void submit() throws Exception {
        this.checkInput();
        IObjectPK[] delArray = new IObjectPK[this.delList.size()];
        for (int i = 0; i < this.delList.size(); ++i) {
            delArray[i] = new ObjectUuidPK((BOSUuid)this.delList.get(i));
        }
        IPersonResource iprs = PersonResourceFactory.getRemoteInstance();
        iprs.saveAll(EmployeeClientUtils.getResourceCollectionByKDTable(this.kdtResource, EmployeeClientUtils.getPersonInfo(this.empId)), delArray);
        ListEditUI listEditUI = (ListEditUI)this.getUIContext().get("ListEditUI");
        listEditUI.setStatusBarMessage();
        this.refresh();
    }

    public void firstOnLoad() throws Exception {
        this.refresh();
    }

    private PersonResourceCollection getResourceColl(String empId) throws BOSException {
        IPersonResource iprs = PersonResourceFactory.getRemoteInstance();
        String oql = "select * where person.id = '" + empId + "'";
        return iprs.getPersonResourceCollection(oql);
    }

    private void refresh() throws Exception {
        this.kdtResource.removeRows();
        this.loadRecords();
    }

    @Override
    public void secondLoad() throws Exception {
        this.firstOnLoad();
    }

    public void onLoad() throws Exception {
        this.empId = (String)this.getUIContext().get("ID");
        super.onLoad();
        EmployeeClientUtils.initTableBtn((JButton)this.btnResourceAddNew, (JButton)this.btnResourceDelete);
        this.kdtResource.checkParsed();
        if (this.getOprtState().equals(OprtState.VIEW)) {
            EmployeeClientUtils.setKDTableViewState(this.kdtResource);
            this.btnResourceAddNew.setEnabled(false);
            this.btnResourceDelete.setEnabled(false);
        }
        EmployeeClientUtils.setColumnBackColor(this.kdtResource, "name");
        EmployeeClientUtils.setColumnBackColor(this.kdtResource, "number");
        this.kdtResource.getStyleAttributes().setWrapText(true);
        this.firstOnLoad();
        this.initCellEditLength();
    }

    void initCellEditLength() {
        EmployeeClientUtils.setCellEditor(this.kdtResource, "name");
        EmployeeClientUtils.setCellEditor(this.kdtResource, "number");
        EmployeeClientUtils.setCellEditor(this.kdtResource, "amount");
        EmployeeClientUtils.setCellEditor(this.kdtResource, "description");
    }

    private void loadRecords() throws Exception {
        if (this.getUIContext().get("ID") != null) {
            this.empId = this.getUIContext().get("ID").toString();
        }
        PersonResourceCollection c = this.getResourceColl(this.empId);
        Object row = null;
        int size = c.size();
        for (int i = 0; i < size; ++i) {
            EmployeeClientUtils.setTableCellValueByInfo(this.kdtResource.addRow(), c.get(i));
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
        try {
            this.refresh();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionResourceAddNew_actionPerformed(ActionEvent e) throws Exception {
        EmployeeClientUtils.addNewKDTableRow(this.kdtResource);
    }

    @Override
    public void actionResourceDelete_actionPerformed(ActionEvent e) throws Exception {
        EmployeeClientUtils.deleteKDTableRow(this.kdtResource, this.delList);
    }

    @Override
    public void setAddNewState() throws Exception {
        EmployeeClientUtils.setAddNewState((CoreUI)this);
        this.refresh();
    }

    @Override
    public void setEmpID(String empId) {
        this.empId = empId;
    }

    @Override
    public void setEnabled(boolean isArchives) {
        if (!isArchives) {
            this.kdtResource.setEnabled(false);
            this.btnResourceAddNew.setEnabled(false);
            this.btnResourceDelete.setEnabled(false);
        }
    }

    protected IObjectValue createNewData() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.submit();
    }

    protected void inOnload() throws Exception {
    }
}

