/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.hraux.PersonRZTypeInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.JobInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.client.JobPromptBox;
import com.kingdee.eas.basedata.org.client.PositionPromptBox2;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.base.CheckStateEnum;
import com.kingdee.eas.hr.base.client.CustomerSettingsSwitch;
import com.kingdee.eas.hr.base.client.IHRF7CommonRegister;
import com.kingdee.eas.hr.emp.EmployeeException;
import com.kingdee.eas.hr.emp.PersonWorkExpCurFactory;
import com.kingdee.eas.hr.emp.PersonWorkExpCurInfo;
import com.kingdee.eas.hr.emp.client.AbstractEmployeeWorkExpCurEditUI;
import com.kingdee.eas.hr.org.JobLevelInfo;
import com.kingdee.eas.hr.org.client.JobGradePromptBox;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.HashSet;

public class EmployeeWorkExpCurEditUI
extends AbstractEmployeeWorkExpCurEditUI {
    private boolean isLoaded = false;
    private boolean isChange = false;
    private HROrgUnitInfo hroInfo = null;

    @Override
    public void loadFields() {
        this.isLoaded = false;
        this.KDlabelReinvite.setVisible(false);
        try {
            this.setJobLevelFilter();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        super.loadFields();
        if (this.editData != null) {
            this.prmtJobGrade.setData((Object)this.editData.getJobGrade());
        } else {
            this.prmtJobGrade.setData(null);
        }
        if (!this.getOprtState().equals(OprtState.ADDNEW)) {
            if (this.editData.getCheckOverTime() != null) {
                this.chkIsCheck.setEnabled(true);
            } else {
                this.chkIsCheck.setEnabled(false);
            }
            if (this.editData.isIsReinvite()) {
                this.KDlabelReinvite.setVisible(true);
            }
        }
        this.isLoaded = true;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected IObjectValue createNewData() {
        PersonWorkExpCurInfo info = new PersonWorkExpCurInfo();
        PersonInfo pInfo = new PersonInfo();
        pInfo.setId(BOSUuid.read((String)this.getUIContext().get("PersonID").toString()));
        info.setPerson(pInfo);
        return info;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return PersonWorkExpCurFactory.getRemoteInstance();
    }

    protected void afterOnLoad() throws Exception {
        super.afterOnLoad();
        if (this.chekState.getSelectedItem() == null) {
            this.chekState.setSelectedItem((Object)CheckStateEnum.NO_CHECK);
        }
        this.initPrompt();
    }

    protected void beforeOnLoad() throws Exception {
        super.beforeOnLoad();
        this.hroInfo = (HROrgUnitInfo)this.getUIContext().get("currentHRO");
        this.prmtJob.setEditFormat("$number$");
        this.prmtJob.setCommitFormat("$number$");
        this.prmtJob.setDisplayFormat("$name$");
        this.prmtDept.setCommitFormat("$number$");
        this.prmtDept.setEditFormat("$number$");
        this.prmtDept.setDisplayFormat("$name$");
        this.prmtJobLevel.setDisplayFormat("$name$");
        this.prmtJobLevel.setEditFormat("$name$");
        this.prmtJobLevel.setCommitFormat("$name$");
    }

    public IObjectPK runSubmit() throws Exception {
        this.editData.setHrOrgUnit(this.getCurrentHRO());
        this.editData.setCU(this.getCurrentCU());
        return super.runSubmit();
    }

    private CtrlUnitInfo getCurrentCU() {
        if (this.hroInfo != null) {
            return this.hroInfo.getCU();
        }
        return SysContext.getSysContext().getCurrentCtrlUnit();
    }

    private HROrgUnitInfo getCurrentHRO() {
        if (this.hroInfo != null) {
            return this.hroInfo;
        }
        return SysContext.getSysContext().getCurrentHRUnit();
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        return new ObjectUuidPK(this.getCurrentHRO().getId());
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        if (this.prmtPosition.getData() == null && StringUtils.isEmpty((String)this.txtPostPosition.getText())) {
            throw new EmployeeException(EmployeeException.POSITION_OR_HISP_NOTNULL);
        }
        if (this.pkEndDate.getValue() != null && this.pkBeginDate.getValue() != null && DateTimeUtils.dayBefore((Date)((Date)this.pkEndDate.getValue()), (Date)((Date)this.pkBeginDate.getValue()))) {
            throw new EmployeeException(EmployeeException.EMP_POSI_ENDDATE_STARTDATE_ERROR);
        }
    }

    private void setJobLevelFilter() throws EASBizException, BOSException {
        JobInfo jobInfo = null;
        if (this.prmtJob.getData() != null) {
            jobInfo = (JobInfo)this.prmtJob.getData();
            this.txtpastJob.setText(jobInfo.getName());
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        if (jobInfo == null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("Job.id", (Object)"nodata"));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("Job.id", (Object)jobInfo.getId()));
        }
        evi.setFilter(filterInfo);
        PositionInfo posInfo = null;
        if ("EDIT".equals(this.getOprtState()) || this.isChange) {
            posInfo = "EDIT".equals(this.getOprtState()) ? this.editData.getPosition() : (PositionInfo)this.prmtPosition.getData();
            if (posInfo != null && posInfo.getJob() != null) {
                jobInfo = posInfo.getJob();
            }
            evi = new EntityViewInfo();
            filterInfo = new FilterInfo();
            if (jobInfo == null) {
                filterInfo.getFilterItems().add(new FilterItemInfo("Job.id", (Object)"nodata"));
            } else {
                filterInfo.getFilterItems().add(new FilterItemInfo("Job.id", (Object)jobInfo.getId()));
            }
            evi.setFilter(filterInfo);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        if (OprtState.VIEW.equals(this.getOprtState())) {
            this.actionAddNew.setVisible(false);
            this.actionEdit.setVisible(false);
            this.actionCopy.setVisible(false);
            this.actionSubmit.setVisible(false);
            this.actionRemove.setVisible(false);
        } else {
            this.actionAddNew.setVisible(true);
            this.actionEdit.setVisible(true);
            this.actionCopy.setVisible(true);
            this.actionSubmit.setVisible(true);
            this.actionRemove.setVisible(true);
        }
        this.prmtPosition.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent arg0) {
                PositionInfo pInfo = (PositionInfo)arg0.getNewValue();
                if (EmployeeWorkExpCurEditUI.this.isLoaded) {
                    if (pInfo == null) {
                        return;
                    }
                    EmployeeWorkExpCurEditUI.this.prmtDept.setData((Object)pInfo.getAdminOrgUnit());
                    EmployeeWorkExpCurEditUI.this.prmtJob.setData((Object)pInfo.getJob());
                    EmployeeWorkExpCurEditUI.this.txtPostPosition.setText(pInfo.getName());
                    EmployeeWorkExpCurEditUI.this.txtpastDept.setText(pInfo.getAdminOrgUnit().getDisplayName());
                    if (pInfo.getJob() != null && pInfo.getJob() != null) {
                        EmployeeWorkExpCurEditUI.this.txtpastJob.setText(pInfo.getJob().getName());
                    } else {
                        EmployeeWorkExpCurEditUI.this.txtpastJob.setText(null);
                    }
                    EmployeeWorkExpCurEditUI.this.isChange = true;
                    try {
                        EmployeeWorkExpCurEditUI.this.setJobLevelFilter();
                    }
                    catch (Exception e) {
                        ExceptionHandler.handle((Throwable)e);
                    }
                }
            }
        });
        this.prmtJob.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent arg0) {
                try {
                    EmployeeWorkExpCurEditUI.this.setJobLevelFilter();
                }
                catch (Exception e) {
                    ExceptionHandler.handle((Throwable)e);
                }
            }
        });
        this.prmtJobLevel.addDataChangeListener(new DataChangeListener(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void dataChanged(DataChangeEvent arg0) {
                try {
                    JobLevelInfo jobLevelInfo = (JobLevelInfo)arg0.getNewValue();
                    if (jobLevelInfo != null && jobLevelInfo.getName() != null) {
                        EmployeeWorkExpCurEditUI.this.txtpastJobLevel.setText(jobLevelInfo.getName());
                    }
                    if (jobLevelInfo == null) {
                        EmployeeWorkExpCurEditUI.this.prmtJobGrade.setData(null);
                        return;
                    }
                    if (!"EDIT".equals(EmployeeWorkExpCurEditUI.this.getOprtState())) return;
                }
                catch (Exception e) {
                    ExceptionHandler.handle((Throwable)e);
                }
            }
        });
        this.prmtPersonRZType.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent arg0) {
                try {
                    PersonRZTypeInfo rzTypeInfo = (PersonRZTypeInfo)arg0.getNewValue();
                    if (rzTypeInfo != null && rzTypeInfo.getName() != null) {
                        EmployeeWorkExpCurEditUI.this.txtpastRZType.setText(rzTypeInfo.getName());
                    }
                }
                catch (Exception e) {
                    ExceptionHandler.handle((Throwable)e);
                }
            }
        });
    }

    protected void registerContextChangeF7(IHRF7CommonRegister register) {
        register.registerPositionPromptBox2(this.prmtPosition);
        try {
            PositionPromptBox2 pmtPosition = (PositionPromptBox2)this.prmtPosition.getSelector();
            int param = CustomerSettingsSwitch.getInstance().getFunctionParamValue("POST_HOLDED");
            if (0 != param) {
                pmtPosition.setAllAdminFilter();
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        register.registerAdminByOrgRangePromptBox(this.prmtDept);
    }

    private void initPrompt() {
        HashSet<CtrlUnitInfo> cuSet = new HashSet<CtrlUnitInfo>();
        cuSet.add(this.getCurrentCU());
        JobPromptBox job = new JobPromptBox((IUIObject)this);
        job.changeContextByCUSet(cuSet);
        this.prmtJob.setSelector((KDPromptSelector)job);
        this.prmtJob.setQueryInfo("com.kingdee.eas.basedata.org.app.JobQuery");
        JobGradePromptBox jobBox = new JobGradePromptBox((IUIObject)this);
        jobBox.changeContextByCUSet(cuSet);
        this.prmtJobGrade.setSelector((KDPromptSelector)jobBox);
    }

    protected void handlePermissionForItemAction(ItemAction action) {
        if (this.getUIContext().get("NO_PERMISSION") == null) {
            super.handlePermissionForItemAction(action);
        }
    }

    protected void initOrgContextManager() {
        super.initOrgContextManager();
        this.initUIMainOrgContext(this.getCurrentHRO().getId().toString());
    }

    @Override
    protected OrgType getMainBizOrgType() {
        return OrgType.HRO;
    }
}

