/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.client;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.emp.EmployeeException;
import com.kingdee.eas.hr.emp.IPersonPosition;
import com.kingdee.eas.hr.emp.PersonPositionFactory;
import com.kingdee.eas.hr.emp.PersonWorkExpFactory;
import com.kingdee.eas.hr.emp.PersonWorkExpInfo;
import com.kingdee.eas.hr.emp.client.AbstractEmployeeWorkExpEditUI;
import com.kingdee.util.DateTimeUtils;
import java.awt.event.ActionEvent;
import java.util.Date;

public class EmployeeWorkExpEditUI
extends AbstractEmployeeWorkExpEditUI {
    private HROrgUnitInfo hroInfo = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected IObjectValue createNewData() {
        PersonWorkExpInfo info = new PersonWorkExpInfo();
        PersonInfo pInfo = new PersonInfo();
        pInfo.setId(BOSUuid.read((String)this.getUIContext().get("PersonID").toString()));
        info.setPerson(pInfo);
        return info;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return PersonWorkExpFactory.getRemoteInstance();
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        Integer persons;
        Integer personQuantity;
        boolean flagOfDate;
        Date beginDate = (Date)this.pkBeginDate.getValue();
        Date endDate = (Date)this.pkEndDate.getValue();
        if (beginDate != null && endDate != null && (flagOfDate = DateTimeUtils.dayAfter((Date)beginDate, (Date)endDate))) {
            throw new EmployeeException(EmployeeException.BEGINDATE_AFTER_ENDDATE);
        }
        if (this.txtPersonQuantity.getText() != null && this.txtPersonQuantity.getText().length() > 0 && (personQuantity = (Integer)this.txtPersonQuantity.getValue(Integer.class)) < 0) {
            throw new EmployeeException(EmployeeException.PERSONQ_ISMINUS);
        }
        if (this.txtSubordinateQuantity.getText() != null && this.txtSubordinateQuantity.getText().length() > 0 && (persons = (Integer)this.txtSubordinateQuantity.getValue(Integer.class)) < 0) {
            throw new EmployeeException(EmployeeException.PERSONS_ISMINUS);
        }
    }

    public void initWorkButton() {
        super.initWorkButton();
        this.txtSalary.setMinimumValue((Comparable)new Double(0.0));
        this.txtSalary.setPrecision(2);
        if (OprtState.VIEW.equals(this.getOprtState())) {
            this.actionAddNew.setVisible(false);
            this.actionEdit.setVisible(false);
            this.actionCopy.setVisible(false);
            this.actionSubmit.setVisible(false);
            this.actionRemove.setVisible(false);
        } else {
            this.actionAddNew.setVisible(true);
            this.actionEdit.setVisible(true);
            this.actionCopy.setVisible(true);
            this.actionSubmit.setVisible(true);
            this.actionRemove.setVisible(true);
        }
    }

    protected void handlePermissionForItemAction(ItemAction action) {
        if (this.getUIContext().get("NO_PERMISSION") == null) {
            super.handlePermissionForItemAction(action);
        }
    }

    protected void afterOnLoad() throws Exception {
        super.afterOnLoad();
    }

    protected void beforeOnLoad() throws Exception {
        super.beforeOnLoad();
        this.hroInfo = (HROrgUnitInfo)this.getUIContext().get("currentHRO");
    }

    private CtrlUnitInfo getCurrentCU() {
        if (this.hroInfo != null) {
            return this.hroInfo.getCU();
        }
        return SysContext.getSysContext().getCurrentCtrlUnit();
    }

    private HROrgUnitInfo getCurrentHRO() {
        if (this.hroInfo != null) {
            return this.hroInfo;
        }
        return SysContext.getSysContext().getCurrentHRUnit();
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        return new ObjectUuidPK(this.getCurrentHRO().getId());
    }

    public IObjectPK runSubmit() throws Exception {
        this.editData.setHrOrgUnit(this.getCurrentHRO());
        return super.runSubmit();
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        String personId = this.getPersonId();
        this.updateJobStartDate(personId);
    }

    public void updateJobStartDate(String personId) throws Exception {
        if (this.isJobFirstDate()) {
            IPersonPosition ipersonPosition = PersonPositionFactory.getRemoteInstance();
            ipersonPosition.updateJobFirstDate(personId);
        }
    }

    private String getPersonId() {
        String personId = null;
        PersonWorkExpInfo info = (PersonWorkExpInfo)this.createNewData();
        personId = info.getPerson().getId().toString();
        return personId;
    }

    private boolean isJobFirstDate() throws Exception {
        boolean isFirst = false;
        String paramName = "IS_JOBDATE_FIRST";
        BOSUuid orgId = this.getCurrentHRO().getId();
        IParamControl iParam = ParamControlFactory.getRemoteInstance();
        String val = iParam.getParamValue((IObjectPK)new ObjectUuidPK(orgId), paramName);
        if (val != null && Boolean.TRUE.toString().equals(val)) {
            isFirst = true;
        }
        return isFirst;
    }
}

