/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.client.IEmployeeUI;
import com.kingdee.eas.hr.benefit.AccountDetailCollection;
import com.kingdee.eas.hr.benefit.AccountDetailFactory;
import com.kingdee.eas.hr.benefit.AccountDetailInfo;
import com.kingdee.eas.hr.benefit.AccountTypeInfo;
import com.kingdee.eas.hr.benefit.EmpManagerFacadeFactory;
import com.kingdee.eas.hr.benefit.IAccountDetail;
import com.kingdee.eas.hr.benefit.IEmpManagerFacade;
import com.kingdee.eas.hr.benefit.PayTypeEnum;
import com.kingdee.eas.hr.emp.SocialInsuranceCollection;
import com.kingdee.eas.hr.emp.SocialInsuranceFactory;
import com.kingdee.eas.hr.emp.SocialInsuranceInfo;
import com.kingdee.eas.hr.emp.client.AbstractSocialInsuranceEditUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public class SocialInsuranceEditUI
extends AbstractSocialInsuranceEditUI {
    private static Logger logger = Logger.getLogger(SocialInsuranceEditUI.class);
    private static final long serialVersionUID = 1L;
    private boolean isLoad = false;
    private IEmployeeUI treeEditUI = null;

    protected void afterOnLoad() throws Exception {
        super.afterOnLoad();
    }

    public void initLayout() {
        super.initLayout();
        if (OprtState.VIEW.equals(this.oprtState)) {
            this.kdcAccountType.setAccessAuthority(0);
            this.kdtAccounts.setAccessAuthority(1);
        }
    }

    protected void beforeOnLoad() throws Exception {
        super.beforeOnLoad();
        this.treeEditUI = (IEmployeeUI)this.getUIContext().get("GroupListEditUI");
    }

    protected boolean isShowAttachmentAction() {
        return true;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.kdcAccountType.setEnabled(true);
        this.kdcAccountType.setVisible(true);
        this.kdtAccounts.setVisible(true);
    }

    private CtrlUnitInfo getCurrentCU() {
        if (this.treeEditUI != null && this.treeEditUI.getMainBizOrgInfo() != null) {
            return this.treeEditUI.getMainBizOrgInfo().getCU();
        }
        return SysContext.getSysContext().getCurrentCtrlUnit();
    }

    private HROrgUnitInfo getCurrentHRO() {
        if (this.treeEditUI != null && this.treeEditUI.getMainBizOrgInfo() != null) {
            return this.treeEditUI.getMainBizOrgInfo();
        }
        return SysContext.getSysContext().getCurrentHRUnit();
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        if (this.getCurrentHRO() == null) {
            return super.getOrgPK(action);
        }
        return new ObjectUuidPK(this.getCurrentHRO().getId());
    }

    protected IObjectValue getValue(IObjectPK pk) throws Exception {
        String recordId = null;
        if (this.getUIContext().get("CUR_OBJ_ID") != null) {
            recordId = this.getUIContext().get("CUR_OBJ_ID").toString();
        }
        if (recordId != null) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)recordId));
            view.setFilter(filter);
            SocialInsuranceCollection subCol = SocialInsuranceFactory.getRemoteInstance().getSocialInsuranceCollection(view);
            if (subCol.size() <= 0) {
                this.setOprtState(OprtState.ADDNEW);
                this.editData = (SocialInsuranceInfo)this.createNewData();
                PersonInfo recordInfo = new PersonInfo();
                recordInfo.setId(BOSUuid.read((String)recordId));
                this.editData.setPerson(recordInfo);
            } else {
                this.editData = subCol.get(0);
                this.showMessageForStatus();
            }
            this.setDataObject((IObjectValue)this.editData);
            if (this.editData.isIsSocialInsu()) {
                this.chkisSocialInsu.setSelected(true);
            } else {
                this.chkisSocialInsu.setSelected(false);
            }
            if (this.editData.getShiftToTime() != null) {
                this.pkshiftToTime.setValue((Object)this.editData.getShiftToTime());
            } else {
                this.pkshiftToTime.setValue(null);
            }
            if (this.editData.getShiftOutTime() != null) {
                this.pkshiftOutTime.setValue((Object)this.editData.getShiftOutTime());
            } else {
                this.pkshiftOutTime.setValue(null);
            }
            if (this.editData.getInvoteJobTime() != null) {
                this.pkinvoteJobTime.setValue((Object)this.editData.getInvoteJobTime());
            } else {
                this.pkinvoteJobTime.setValue(null);
            }
            if (this.editData.getTranInJobTime() != null) {
                this.pktranInJobTime.setValue((Object)this.editData.getTranInJobTime());
            } else {
                this.pktranInJobTime.setValue(null);
            }
            if (this.editData.getTranShToTime() != null) {
                this.pktranShToTime.setValue((Object)this.editData.getTranShToTime());
            } else {
                this.pktranShToTime.setValue(null);
            }
            if (this.editData.getTranSInsuTime() != null) {
                this.pktranSInsuTime.setValue((Object)this.editData.getTranSInsuTime());
            } else {
                this.pktranSInsuTime.setValue(null);
            }
            if (this.editData.getInspectDate() != null) {
                this.pkinspectDate.setValue((Object)this.editData.getInspectDate());
            } else {
                this.pkinspectDate.setValue(null);
            }
            if (this.editData.getInspectResult() != null) {
                this.txtinspectResult.setText(this.editData.getInspectResult());
            } else {
                this.txtinspectResult.setText(null);
            }
            if (this.editData.getRemark() != null) {
                this.txtremark.setText(this.editData.getRemark());
            } else {
                this.txtremark.setText(null);
            }
            this.editData.copyNewToOld();
        }
        return this.editData;
    }

    @Override
    public void loadFields() {
        if (this.getOprtState().equals(OprtState.VIEW)) {
            this.chkisSocialInsu.setEnabled(false);
        }
        try {
            this.getValue(null);
            this.clearAccountTypeAndAccounts();
            this.loadAccountTypeAndAccounts();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        super.loadFields();
    }

    @Override
    protected IObjectValue createNewData() {
        SocialInsuranceInfo info = new SocialInsuranceInfo();
        PersonInfo pInfo = new PersonInfo();
        pInfo.setId(BOSUuid.read((String)this.getUIContext().get("CUR_OBJ_ID").toString()));
        info.setPerson(pInfo);
        return info;
    }

    @Override
    protected void kdcAccountType_itemStateChanged(ItemEvent e) throws Exception {
        if (this.kdcAccountType.getSelectedItem() != null) {
            String recordId = this.getUIContext().get("CUR_OBJ_ID").toString();
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            entityViewInfo.getSelector().add(new SelectorItemInfo("accounts"));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("account.person.id", (Object)recordId));
            filter.getFilterItems().add(new FilterItemInfo("accountType.id", (Object)((AccountTypeInfo)this.kdcAccountType.getSelectedItem()).getId()));
            filter.getFilterItems().add(new FilterItemInfo("account.hrorgunit.id", (Object)this.getCurrentHRO().getId().toString()));
            entityViewInfo.setFilter(filter);
            AccountDetailCollection ac = AccountDetailFactory.getRemoteInstance().getAccountDetailCollection(entityViewInfo);
            if (ac != null && ac.size() == 1) {
                this.kdtAccounts.setText(ac.get(0).getAccounts());
                this.kdtAccountDetailID.setText(ac.get(0).getId().toString());
            }
            if (this.kdcAccountType.getSelectedItem() == null) {
                this.kdtAccounts.setEnabled(false);
            } else {
                this.kdtAccounts.setEnabled(true);
            }
        } else {
            this.kdtAccounts.setEnabled(false);
            this.kdtAccounts.setText(null);
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (this.chkisSocialInsu.isSelected()) {
            this.editData.setIsSocialInsu(true);
        } else {
            this.editData.setIsSocialInsu(false);
        }
        if (this.pkshiftToTime.getValue() != null && this.pkshiftOutTime.getText() != null && !this.pkshiftToTime.getText().equals("") && !this.pkshiftOutTime.getText().equals("")) {
            Date pkshiftToTime = (Date)this.pkshiftToTime.getValue();
            Date pkshiftOutTime = (Date)this.pkshiftOutTime.getValue();
            if (pkshiftOutTime.before(pkshiftToTime)) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"269_SocialInsuranceEditUI"));
                return;
            }
        }
        if (this.kdcAccountType.getSelectedItem() != null && !StringUtils.isEmpty((String)this.kdtAccounts.getText()) && !StringUtils.isEmpty((String)this.kdtAccountDetailID.getText())) {
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("accountType.id", (Object)((AccountTypeInfo)this.kdcAccountType.getSelectedItem()).getId()));
            filter.getFilterItems().add(new FilterItemInfo("accounts", (Object)this.kdtAccounts.getText()));
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)BOSUuid.read((String)this.kdtAccountDetailID.getText()), CompareType.NOTEQUALS));
            entityViewInfo.setFilter(filter);
            AccountDetailCollection ac = AccountDetailFactory.getRemoteInstance().getAccountDetailCollection(entityViewInfo);
            if (ac.size() >= 1) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"270_SocialInsuranceEditUI"));
                return;
            }
            AccountDetailInfo aci = AccountDetailFactory.getRemoteInstance().getAccountDetailInfo((IObjectPK)new ObjectStringPK(this.kdtAccountDetailID.getText()));
            aci.setAccounts(this.kdtAccounts.getText());
            AccountDetailFactory.getRemoteInstance().update((IObjectPK)new ObjectStringPK(this.kdtAccountDetailID.getText()), (CoreBaseInfo)aci);
        }
        if (!this.chkisSocialInsu.isSelected()) {
            PersonInfo pInfo = new PersonInfo();
            pInfo.setId(BOSUuid.read((String)this.getUIContext().get("CUR_OBJ_ID").toString()));
            AccountDetailCollection adc = this.getAccountDetailCollection(pInfo);
            if (adc != null && adc.size() > 0) {
                IEmpManagerFacade emf = EmpManagerFacadeFactory.getRemoteInstance();
                IAccountDetail iad = AccountDetailFactory.getRemoteInstance();
                AccountDetailInfo adInfo = null;
                int size = adc.size();
                for (int i = 0; i < size; ++i) {
                    adInfo = adc.get(i);
                    adInfo.setPayState(PayTypeEnum.STOPPAY);
                    iad.update((IObjectPK)new ObjectUuidPK(adInfo.getId().toString()), (CoreBaseInfo)adInfo);
                    emf.cleanBenefitData(adInfo.getId().toString());
                }
            }
            Object var3_3 = null;
        }
        super.actionSubmit_actionPerformed(e);
    }

    private AccountDetailCollection getAccountDetailCollection(PersonInfo personInfo) throws BOSException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.getSelector().add(new SelectorItemInfo("id"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("accounts"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("accountType.id"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("accountType.number"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("accountType.name"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("account.person.id", personInfo.get("id")));
        filter.getFilterItems().add(new FilterItemInfo("account.hrorgunit.id", (Object)this.getCurrentHRO().getId().toString()));
        entityViewInfo.setFilter(filter);
        AccountDetailCollection ac = AccountDetailFactory.getRemoteInstance().getAccountDetailCollection(entityViewInfo);
        return ac;
    }

    private List getAccountDetailInfoList(PersonInfo personInfo) throws BOSException {
        ArrayList<AccountDetailInfo> list = new ArrayList<AccountDetailInfo>();
        AccountDetailCollection ac = this.getAccountDetailCollection(personInfo);
        AccountDetailInfo accountDetailInfo = null;
        for (int i = 0; i < ac.size(); ++i) {
            accountDetailInfo = ac.get(i);
            list.add(accountDetailInfo);
        }
        return list;
    }

    private void loadAccountTypeAndAccounts() throws Exception {
        String recordId = this.getUIContext().get("CUR_OBJ_ID").toString();
        IPerson iPerson = PersonFactory.getRemoteInstance();
        List list = this.getAccountDetailInfoList(iPerson.getPersonInfo((IObjectPK)new ObjectUuidPK(recordId)));
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                if (((AccountDetailInfo)list.get(i)).getAccountType() == null || ((AccountDetailInfo)list.get(i)).getAccounts() == null) continue;
                this.kdcAccountType.addItem((Object)((AccountDetailInfo)list.get(i)).getAccountType());
                this.kdtAccounts.setEnabled(true);
                this.kdcAccountType.setSelectedIndex(0);
                this.kdtAccounts.setText(((AccountDetailInfo)list.get(0)).getAccounts());
                this.kdtAccountDetailID.setText(((AccountDetailInfo)list.get(0)).getId().toString());
            }
            list.clear();
        }
        if (this.kdcAccountType.getSelectedItem() == null) {
            this.kdtAccounts.setEnabled(false);
        }
    }

    private HROrgUnitInfo getHROrgUnit() {
        HROrgUnitInfo hrOrgUnitInfo = null;
        if (hrOrgUnitInfo == null) {
            hrOrgUnitInfo = this.getCurrentHRO();
        }
        return hrOrgUnitInfo;
    }

    private void clearAccountTypeAndAccounts() {
        this.kdtAccountDetailID.setText(null);
        this.kdtAccounts.setText(null);
        this.kdcAccountType.removeAllItems();
    }

    protected void handlePermissionForItemAction(ItemAction action) {
        if (this.treeEditUI == null || this.treeEditUI.getUIContext() == null || this.treeEditUI.getUIContext().get("NO_PERMISSION") == null) {
            super.handlePermissionForItemAction(action);
        }
    }
}

