/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionHierarchyCollection;
import com.kingdee.eas.basedata.org.PositionHierarchyFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.ResponseContext;
import com.kingdee.eas.hr.emp.app.AbstractEmployeeCollectFilterQueryUIHandler;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;

public class EmployeeCollectFilterQueryUIHandler
extends AbstractEmployeeCollectFilterQueryUIHandler {
    protected void _handleInit(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleInit(request, response, context);
    }

    public void _handlerChooseAdmin(RequestContext request, ResponseContext response, Context context) throws Exception {
        String prmtOrgName = null;
        String prmtPositionName = null;
        prmtOrgName = (String)request.get("prmtOrgName");
        prmtPositionName = (String)request.get("prmtPositionName");
        ObjectUuidPK pk = null;
        if (null != prmtOrgName) {
            pk = new ObjectUuidPK(BOSUuid.read((String)prmtOrgName));
            AdminOrgUnitFactory.getLocalInstance((Context)context).getAdminOrgUnitInfo((IObjectPK)pk);
        }
        if (null != prmtPositionName) {
            pk = new ObjectUuidPK(BOSUuid.read((String)prmtPositionName));
            PositionFactory.getLocalInstance((Context)context).getPositionInfo((IObjectPK)pk);
        }
    }

    public void _handlerPrmtPositionChange(RequestContext request, ResponseContext response, Context context) throws Exception {
        this.getLongNumberByPositionAndGetLevelByLongNumber(request, context);
    }

    private void getLongNumberByPositionAndGetLevelByLongNumber(RequestContext request, Context context) throws Exception {
        CoreBaseInfo newInfo = (CoreBaseInfo)request.get("newInfo");
        CoreBaseInfo oldInfo = (CoreBaseInfo)request.get("oldInfo");
        if (newInfo == null || oldInfo == null || !newInfo.getId().equals((Object)oldInfo.getId())) {
            String longNumber = null;
            boolean isOrg = false;
            if (newInfo instanceof AdminOrgUnitInfo) {
                longNumber = ((AdminOrgUnitInfo)newInfo).getLongNumber();
                isOrg = true;
            } else if (newInfo instanceof PositionInfo) {
                longNumber = EmployeeCollectFilterQueryUIHandler.getLongNumberByPosition(context, newInfo.getId().toString());
                isOrg = false;
            }
            if (longNumber != null) {
                EmployeeCollectFilterQueryUIHandler.getLevelByLongNumber(context, longNumber, isOrg);
            }
        }
    }

    public void _handlerPrmtOrgChange(RequestContext request, ResponseContext response, Context context) throws Exception {
        this.getLongNumberByPositionAndGetLevelByLongNumber(request, context);
    }

    public static String getLongNumberByPosition(Context context, String id) throws Exception {
        PositionHierarchyCollection c = PositionHierarchyFactory.getLocalInstance((Context)context).getPositionHierarchyCollection("select longNumber where child.id = '" + id + "'");
        if (c.size() > 0) {
            return c.get(0).getLongNumber();
        }
        return null;
    }

    public static int[] getLevelByLongNumber(Context context, String longNumber, boolean isOrg) throws Exception {
        int[] datas = new int[2];
        StringBuffer sb = new StringBuffer();
        if (isOrg && null != ContextUtil.getCurrentUserInfo((Context)context)) {
            String userID = ContextUtil.getCurrentUserInfo((Context)context).getId().toString();
            sb.append("SELECT MAX(admin.FLevel) AS MAX0, MIN(admin.FLevel) AS MIN0 FROM T_ORG_ADMIN admin");
            sb.append(" inner join T_ORG_UnitRelation rel on rel.FFromUnitID = admin.FID");
            sb.append(" inner join T_PM_OrgRange rang on rang.FOrgID = rel.FFromUnitID");
            sb.append(" where ");
            sb.append(" rel.FTypeRelationID = '00000000-0000-0000-0000-0000000000100FE9F8B5' ");
            sb.append(" and rang.FUserID = ");
            sb.append("'");
            sb.append(userID);
            sb.append("'");
            sb.append(" and rang.FType = ");
            sb.append(20);
            sb.append(" and ");
            sb.append(" FLongNumber || '!' like '");
            sb.append(longNumber);
            sb.append("!%'");
        } else {
            sb.append("SELECT MAX(FLevel) AS MAX0, MIN(FLevel) AS MIN0 From ");
            sb.append("T_ORG_PositionHierarchy");
            sb.append(" Where FLongNumber || '!' like '");
            sb.append(longNumber);
            sb.append("!%'");
            sb.append(" AND FChildID IN (SELECT FID From T_Org_Position ");
            sb.append("WHERE FControlUnitID in (SELECT B.FControlUnitID FROM ");
            sb.append(" T_Org_PositionHierarchy A INNER JOIN T_Org_Position B ");
            sb.append(" ON A.FChildID = B.FID AND A.FLongNumber = '");
            sb.append(longNumber);
            sb.append("'))");
        }
        ISQLExecutor isql = SQLExecutorFactory.getLocalInstance((Context)context, (String)sb.toString());
        IRowSet rows = isql.executeSQL();
        if (rows.next()) {
            datas[0] = rows.getInt("MAX0");
            datas[1] = rows.getInt("MIN0");
        }
        return datas;
    }
}

