/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.KDTDataRequestManager;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.ResponseContext;
import com.kingdee.eas.framework.util.UIConfigUtility;
import com.kingdee.eas.hr.base.HROrgContextManagerFacadeFactory;
import com.kingdee.eas.hr.emp.app.AbstractEmployeeRosterListUIHandler;
import com.kingdee.eas.util.app.ContextUtil;

public class EmployeeRosterListUIHandler
extends AbstractEmployeeRosterListUIHandler {
    protected void _handleInit(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleInit(request, response, context);
        this.getPermissionItem(request, context);
        this.getLegalityHROrg(request, context);
    }

    @Override
    protected void _handleActionKdfSelect(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleActionKdfAll(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    private void getPermissionItem(RequestContext request, Context context) throws BOSException, EASBizException {
        if (request.getQueryPK() != null) {
            HROrgContextManagerFacadeFactory.getLocalInstance((Context)context).getPermissionItem(MetaDataTypeList.BASEQUERY, request.getQueryPK());
        }
    }

    private void getLegalityHROrg(RequestContext request, Context context) throws BOSException, EASBizException {
        HROrgUnitInfo hrOrgUnitInfo = ContextUtil.getCurrentHRUnit((Context)context);
        HROrgContextManagerFacadeFactory.getLocalInstance((Context)context).getLegalityHROrg(hrOrgUnitInfo, MetaDataTypeList.BASEQUERY, request.getQueryPK());
    }

    public void _handleDoRealModeQuery(RequestContext request, ResponseContext response, Context context) throws Exception {
        int start = (Integer)request.get("start");
        int length = (Integer)request.get("length");
        IQueryExecutor exec = this.getQueryExecutor(request, context);
        exec.executeQuery(start, length);
    }

    protected IQueryExecutor getQueryExecutor(RequestContext request, Context context) {
        IQueryExecutor exec = null;
        boolean isOrderBy = false;
        IMetaDataPK mainQueryPK = (IMetaDataPK)request.get("mainQueryPK");
        EntityViewInfo mainQuery = (EntityViewInfo)request.get("mainQuery");
        exec = QueryExecutorFactory.getLocalInstance((Context)context, (IMetaDataPK)mainQueryPK);
        exec.setObjectView(request.getQuery());
        isOrderBy = mainQuery != null && mainQuery.getSorter() != null && mainQuery.getSorter().size() > 0;
        exec.option().isIgnoreOrder = isOrderBy;
        exec.option().isAutoIgnoreZero = true;
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = true;
        exec.option().topCount = 10000;
        exec.option().pageCount = KDTDataRequestManager.defaultPageRow;
        if (UIConfigUtility.getCofigValue((String)"QueryTransactionType", (String)"isReadUnCommited", (String)"false").equalsIgnoreCase("true")) {
            exec.option().transactionIsolation = 1;
        }
        if (context.get((Object)"IGNORE_DATAPERMISSION_CHECK") != null) {
            try {
                if (Boolean.TRUE.equals(context.get((Object)"IGNORE_DATAPERMISSION_CHECK"))) {
                    exec.option().isIgnorePermissionCheck = true;
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return exec;
    }
}

