/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.HistoryConstant;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.emp.EmployeeException;
import com.kingdee.eas.hr.emp.IPersonPosition;
import com.kingdee.eas.hr.emp.PersonCertifyCompetencyCollection;
import com.kingdee.eas.hr.emp.PersonCertifyCompetencyFactory;
import com.kingdee.eas.hr.emp.PersonCertifyCompetencyInfo;
import com.kingdee.eas.hr.emp.PersonPositionCollection;
import com.kingdee.eas.hr.emp.PersonPositionFactory;
import com.kingdee.eas.hr.emp.app.AbstractPersonCertifyCompetencyControllerBean;
import com.kingdee.eas.hr.train.PersonCheckUpFactory;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.DateTimeUtils;
import java.util.ArrayList;
import java.util.Date;
import org.apache.log4j.Logger;

public class PersonCertifyCompetencyControllerBean
extends AbstractPersonCertifyCompetencyControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.emp.app.PersonCertifyCompetencyControllerBean");

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        PersonCertifyCompetencyInfo info = this.getPersonCertifyCompetencyInfo(ctx, pk);
        if (this._refrencedByCheckOUt(ctx, info.getId().toString())) {
            throw new EmployeeException(EmployeeException.PERSONCERTIFY_REFERENCEDBY_CHECKOUT);
        }
        if (info.isIsHighest()) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)info.getPerson().getId(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId(), CompareType.NOTEQUALS));
            if (this._exists(ctx, filter)) {
                throw new EmployeeException(EmployeeException.MUST_EXIST_LESS_ONE_COMPENCY);
            }
            StringBuffer oql = new StringBuffer("select id where person.id ='");
            oql.append(info.getPerson().getId());
            oql.append("'");
            PersonCertifyCompetencyCollection col = PersonCertifyCompetencyFactory.getLocalInstance(ctx).getPersonCertifyCompetencyCollection(oql.toString());
            int size = col.size();
            if (size == 1) {
                Date effectDate = DateTimeUtils.truncateDate((Date)new Date());
                this.updatePersonPositionIsHasWork(ctx, info.getPerson().getId().toString(), false);
                IPerson ip = PersonFactory.getLocalInstance((Context)ctx);
                PersonInfo personInfo = ip.getPersonInfo((IObjectPK)new ObjectUuidPK(info.getPerson().getId().toString()));
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("highestCompetency"));
                selector.add(new SelectorItemInfo(HistoryConstant.EFFDT));
                personInfo.setHighestCompetency(null);
                personInfo.setEFFDT(effectDate);
                ip.updatePartial((CoreBaseInfo)personInfo, selector);
            }
        }
        super._delete(ctx, pk);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        PersonCertifyCompetencyInfo info = (PersonCertifyCompetencyInfo)model;
        PersonCertifyCompetencyInfo oldInfo = this.getPersonCertifyCompetencyInfo(ctx, (IObjectPK)new ObjectUuidPK(info.getId()));
        info.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
        if (oldInfo.isIsHighest() && !info.isIsHighest()) {
            throw new EmployeeException(EmployeeException.MUST_HAVE_MAIN_COMPENCY);
        }
        if (info.isIsHighest()) {
            DbUtil.execute((Context)ctx, (String)("UPDATE T_HR_PersonCertifyCompetency SET FIsHighest = 0 WHERE FPersonId='" + info.getPerson().getId() + "'"));
            info.setIsHighest(true);
            Date effectDate = (Date)info.getPerson().get(HistoryConstant.EFFDT);
            if (effectDate == null) {
                PersonInfo personInfo = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(info.getPerson().getId()));
                effectDate = personInfo.getEFFDT();
            }
            IPerson iP = PersonFactory.getLocalInstance((Context)ctx);
            PersonInfo pInfo = iP.getPersonInfo((IObjectPK)new ObjectUuidPK(info.getPerson().getId()));
            pInfo.setHighestCompetency(info.getCertifiedCompetency());
            pInfo.setEFFDT(effectDate);
            iP.update((IObjectPK)new ObjectUuidPK(pInfo.getId()), (CoreBaseInfo)pInfo);
        }
        super._update(ctx, pk, (IObjectValue)info);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PersonCertifyCompetencyInfo info = (PersonCertifyCompetencyInfo)model;
        if (info.getHrOrgUnit() == null) {
            info.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
        }
        if (!this._exists(ctx, "where person.id='" + info.getPerson().getId() + "'") && !info.isIsHighest() && info.getCertifiedCompetency() != null) {
            throw new EmployeeException(EmployeeException.MUST_HAVE_MAIN_COMPENCY);
        }
        if (info.isIsHighest()) {
            DbUtil.execute((Context)ctx, (String)("UPDATE T_HR_PersonCertifyCompetency SET FIsHighest = 0 WHERE FPersonId='" + info.getPerson().getId() + "'"));
            Date effectDate = (Date)info.getPerson().get(HistoryConstant.EFFDT);
            if (effectDate == null) {
                PersonInfo personInfo = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(info.getPerson().getId()));
                effectDate = personInfo.getEFFDT();
            }
            this.updatePersonPositionIsHasWork(ctx, info.getPerson().getId().toString(), true);
            IPerson iP = PersonFactory.getLocalInstance((Context)ctx);
            PersonInfo pInfo = iP.getPersonInfo((IObjectPK)new ObjectUuidPK(info.getPerson().getId()));
            pInfo.setHighestCompetency(info.getCertifiedCompetency());
            pInfo.setEFFDT(effectDate);
            iP.update((IObjectPK)new ObjectUuidPK(pInfo.getId()), (CoreBaseInfo)pInfo);
        }
        return super._addnew(ctx, (IObjectValue)info);
    }

    @Override
    protected boolean _refrencedByCheckOUt(Context ctx, String strPersonCertifyID) throws BOSException, EASBizException {
        String sql = "where personCertifyCmp.id = '" + strPersonCertifyID + "' ";
        return PersonCheckUpFactory.getLocalInstance((Context)ctx).exists(sql);
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("person.number"));
        selector.add(new SelectorItemInfo("person.name"));
        PersonCertifyCompetencyInfo info = (PersonCertifyCompetencyInfo)this.getValue(ctx, pk, selector);
        return info.getPerson().getNumber() + info.getPerson().getName();
    }

    private void updatePersonPositionIsHasWork(Context ctx, String personId, boolean isHaveWork) throws BOSException, EASBizException {
        IPersonPosition ipp = PersonPositionFactory.getLocalInstance(ctx);
        PersonPositionCollection ppColl = ipp.getPersonPositionCollection("select id,effdt where person.id='" + personId + "'");
        int num = ppColl.size();
        for (int i = 0; i < num; ++i) {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("isHaveWork"));
            selector.add(new SelectorItemInfo("effdt"));
            ppColl.get(i).setIsHaveWork(isHaveWork);
            ipp.updatePartial(ppColl.get(i), selector);
        }
    }

    private IObjectPK[] addAndUpdate(Context ctx, PersonCertifyCompetencyCollection Coll) throws EASBizException, BOSException {
        ArrayList<IObjectPK> idList = new ArrayList<IObjectPK>();
        for (int i = 0; i < Coll.size(); ++i) {
            if (Coll.get(i).getId() == null) {
                idList.add(this._addnew(ctx, (IObjectValue)Coll.get(i)));
                continue;
            }
            this._update(ctx, (IObjectPK)new ObjectUuidPK(Coll.get(i).getId()), (IObjectValue)Coll.get(i));
        }
        ObjectUuidPK[] newList = new ObjectUuidPK[idList.size()];
        for (int i = 0; i < idList.size(); ++i) {
            newList[i] = (IObjectPK)idList.get(i);
        }
        return newList;
    }
}

