/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.affair.HRAffairBizBillEntryInfo;
import com.kingdee.eas.hr.affair.HRAffairBizBillInfo;
import com.kingdee.eas.hr.base.HRBizDefineFactory;
import com.kingdee.eas.hr.base.HRBizDefineInfo;
import com.kingdee.eas.hr.emp.EmployeeBizException;
import com.kingdee.eas.hr.emp.PersonLoanCollection;
import com.kingdee.eas.hr.emp.PersonLoanFactory;
import com.kingdee.eas.hr.emp.PersonLoanInfo;
import com.kingdee.eas.hr.emp.PersonLoanOutBackState;
import com.kingdee.eas.hr.emp.app.AbstractPersonLoanFacadeControllerBean;
import com.kingdee.eas.hr.org.app.HRVerifyModelFacadeControllerBean;
import org.apache.log4j.Logger;

public class PersonLoanFacadeControllerBean
extends AbstractPersonLoanFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.emp.app.PersonLoanFacadeControllerBean");

    @Override
    protected IObjectValue _cancelLoanFluctuation(Context ctx, String affairEntryId, String personID) throws BOSException, EASBizException {
        HRAffairBizBillEntryInfo entryEntry = (HRAffairBizBillEntryInfo)this.getInfoById(ctx, affairEntryId);
        HRAffairBizBillInfo billInfo = (HRAffairBizBillInfo)entryEntry.get("bill");
        try {
            String id = billInfo.getId().toString();
            billInfo = (HRAffairBizBillInfo)this.getInfoById(ctx, id);
            HRBizDefineInfo hrBizDefineInfo = entryEntry.getHrBizDefine();
            hrBizDefineInfo = this.getHRBizDefineInfo(ctx, hrBizDefineInfo);
            PersonInfo personInfo = entryEntry.getPerson();
            PersonLoanCollection personLoanCollection = this.getPersonLoanCollection(ctx, personInfo);
            PersonLoanInfo personLoanInfo = this.getPersonLoanInfo(ctx, personInfo, billInfo.getNumber());
            if ("SHR31".equals(hrBizDefineInfo.getNumber())) {
                if (personLoanCollection.isEmpty()) {
                    PersonInfo person = this.getPerson(ctx, entryEntry.getPerson());
                    String personStr = person.getName();
                    throw new EmployeeBizException(EmployeeBizException.NOLOAN, new String[]{personStr});
                }
                PersonLoanFactory.getLocalInstance(ctx).delete((IObjectPK)new ObjectUuidPK(personLoanInfo.getId()));
            } else {
                if (personLoanInfo.isEmpty()) {
                    PersonInfo person = this.getPerson(ctx, entryEntry.getPerson());
                    String personStr = person.getName();
                    throw new EmployeeBizException(EmployeeBizException.NOLOAN, new String[]{personStr});
                }
                if ("SHR33".equals(hrBizDefineInfo.getNumber())) {
                    personLoanInfo.setBackAdmin(null);
                    personLoanInfo.setBackPosition(null);
                    personLoanInfo.setBackJob(null);
                }
                personLoanInfo.setBackEffectDate(null);
                personLoanInfo.setPersonLoanState(PersonLoanOutBackState.loaning);
                personLoanInfo.setBackBillNumber(null);
                personLoanInfo.setBackBillDesc(null);
                personLoanInfo.setBackRemark(null);
                String personLoanInfoId = personLoanInfo.getId().toString();
                PersonLoanFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(personLoanInfoId), personLoanInfo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    private CoreBaseInfo getInfoById(Context ctx, String id) throws BOSException, EASBizException {
        CoreBaseInfo info = null;
        String entityName = HRVerifyModelFacadeControllerBean.getEntityObject((Context)ctx, (String)id).getFullName();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("bill.id"));
        info = HRVerifyModelFacadeControllerBean.getBizInterface((Context)ctx, (String)entityName).getValue((IObjectPK)new ObjectUuidPK(id), selector);
        return info;
    }

    public HRBizDefineInfo getHRBizDefineInfo(Context ctx, HRBizDefineInfo hrBizDefineInfo) {
        String id = hrBizDefineInfo.getId().toString();
        try {
            hrBizDefineInfo = HRBizDefineFactory.getLocalInstance((Context)ctx).getHRBizDefineInfo((IObjectPK)new ObjectUuidPK(id));
        }
        catch (EASBizException e) {
            e.printStackTrace();
            return null;
        }
        catch (BOSException e) {
            e.printStackTrace();
            return null;
        }
        return hrBizDefineInfo;
    }

    public PersonInfo getPerson(Context ctx, PersonInfo person) throws BOSException {
        PersonInfo personInfo = null;
        String id = person.getId().toString();
        try {
            personInfo = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(id));
        }
        catch (EASBizException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return personInfo;
    }

    public AdminOrgUnitInfo getAdmin(Context ctx, AdminOrgUnitInfo admin) throws BOSException {
        AdminOrgUnitInfo adminOrg = null;
        String id = admin.getId().toString();
        try {
            adminOrg = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(id));
        }
        catch (EASBizException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return adminOrg;
    }

    public PositionInfo getPosition(Context ctx, PositionInfo pos) throws BOSException {
        PositionInfo position = null;
        String id = pos.getId().toString();
        try {
            position = PositionFactory.getLocalInstance((Context)ctx).getPositionInfo((IObjectPK)new ObjectUuidPK(id));
        }
        catch (EASBizException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return position;
    }

    public PersonLoanCollection getPersonLoanCollection(Context ctx, PersonInfo personInfo) throws BOSException {
        String personId = personInfo.getId().toString();
        String oql = "where person = '" + personId + "' ";
        PersonLoanCollection personLoanColl = PersonLoanFactory.getLocalInstance(ctx).getPersonLoanCollection(oql);
        return personLoanColl;
    }

    public PersonLoanInfo getPersonLoanInfo(Context ctx, PersonInfo personInfo, String billNumber) throws BOSException {
        PersonLoanInfo personLoanInfo = null;
        PersonLoanCollection personLoanColl = this.getPersonLoanCollection(ctx, personInfo);
        if (personLoanColl.isEmpty()) {
            return null;
        }
        for (int i = 0; i < personLoanColl.size(); ++i) {
            personLoanInfo = personLoanColl.get(i);
            if (!personLoanInfo.getOutBillNumber().equals(billNumber) && !personLoanInfo.getBackBillNumber().equals(billNumber)) continue;
            return personLoanInfo;
        }
        return null;
    }
}

