/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.app;

import com.google.common.collect.Sets;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.event.util.DBUtils;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.AuditPersonPhotoCollection;
import com.kingdee.eas.hr.base.AuditPersonPhotoFactory;
import com.kingdee.eas.hr.base.AuditPersonPhotoInfo;
import com.kingdee.eas.hr.base.HROrgContextManagerFacadeFactory;
import com.kingdee.eas.hr.base.app.HRDbUtil;
import com.kingdee.eas.hr.base.util.File2ObsUtils;
import com.kingdee.eas.hr.base.util.personphoto.PersonPhotoAuditUtil;
import com.kingdee.eas.hr.emp.EmpBatchException;
import com.kingdee.eas.hr.emp.EmployeeAuditCollection;
import com.kingdee.eas.hr.emp.EmployeeAuditFactory;
import com.kingdee.eas.hr.emp.EmployeeAuditInfo;
import com.kingdee.eas.hr.emp.EmployeeAuditStateEnum;
import com.kingdee.eas.hr.emp.EmployeePageDataSetInfo;
import com.kingdee.eas.hr.emp.IEmployeeAudit;
import com.kingdee.eas.hr.emp.OperateTypeEnum;
import com.kingdee.eas.hr.emp.PersonPhotoFactory;
import com.kingdee.eas.hr.emp.PersonPhotoInfo;
import com.kingdee.eas.hr.emp.app.AbstractPersonPhotoControllerBean;
import com.kingdee.eas.hr.emp.app.util.EmployeePageAuditServerUtil;
import com.kingdee.eas.hr.emp.app.util.PersonPhotoUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class PersonPhotoControllerBean
extends AbstractPersonPhotoControllerBean {
    protected IObjectPK _addnew(Context arg0, IObjectValue arg1) throws BOSException, EASBizException {
        PersonPhotoInfo pPhotoInfo = (PersonPhotoInfo)arg1;
        if (pPhotoInfo.getPerson() != null) {
            String strSQL = "delete from T_HR_PersonPhoto where FPersonID='" + pPhotoInfo.getPerson().getId().toString() + "'";
            DbUtil.execute((Context)arg0, (String)strSQL);
        }
        if (pPhotoInfo.get("photofile") != null) {
            pPhotoInfo.setImageData((byte[])pPhotoInfo.get("photofile"));
            pPhotoInfo.setImageDataSource((byte[])pPhotoInfo.get("photofile"));
            pPhotoInfo.setIsInFile(false);
        }
        Date nowDate = new Date();
        pPhotoInfo.setCreateTime(nowDate);
        pPhotoInfo.setLastUpdateTime(nowDate);
        IObjectPK pk = super._addnew(arg0, (IObjectValue)pPhotoInfo);
        if (pPhotoInfo.get("imagedata") != null) {
            boolean isUseOSB = File2ObsUtils.isUseOBS((Context)arg0);
            if (isUseOSB) {
                File2ObsUtils.uploadPersonPhoto2OBS((Context)arg0, (String)pPhotoInfo.getPerson().getId().toString(), (byte[])((byte[])pPhotoInfo.get("imagedata")));
            } else {
                PersonPhotoUtil.personPhoto2File(arg0, pPhotoInfo.getPerson().getId().toString(), (byte[])pPhotoInfo.get("imagedata"));
            }
        }
        return pk;
    }

    protected void _update(Context arg0, IObjectPK arg1, IObjectValue arg2) throws BOSException, EASBizException {
        PersonPhotoInfo pInfo = (PersonPhotoInfo)arg2;
        if (pInfo.getPerson() != null) {
            String strSQL = "delete from T_HR_PersonPhoto where FPersonID='" + pInfo.getPerson().getId().toString() + "'";
            DbUtil.execute((Context)arg0, (String)strSQL);
            this._addnew(arg0, arg2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected HashMap _getPersonPhotoData(Context ctx, IObjectValue personInfo) throws BOSException, EASBizException {
        HashMap<String, byte[]> map = new HashMap<String, byte[]>();
        PersonInfo pInfo = (PersonInfo)personInfo;
        String strSQL = "select FImageData from T_HR_PersonPhoto where FPersonID='" + pInfo.getId().toString() + "'";
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            statement = conn.prepareStatement(strSQL);
            rs = statement.executeQuery(strSQL);
            while (rs.next()) {
                InputStream in = null;
                try {
                    in = rs.getBinaryStream(1);
                    int blockSize = 1024;
                    byte[] block = new byte[1024];
                    ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
                    int len = -1;
                    do {
                        try {
                            len = in.read(block);
                        }
                        catch (IOException e1) {
                            throw new SQLException(e1.getMessage());
                        }
                        if (len <= 0) continue;
                        byteOut.write(block, 0, len);
                    } while (len == 1024);
                    byte[] data = byteOut.toByteArray();
                    map.put("photofile", data);
                }
                finally {
                    try {
                        if (in == null) continue;
                        in.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (SQLException exc) {
            try {
                throw new BOSException("Sql execute exception : " + strSQL, (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, statement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)conn);
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected HashMap _getPersonPhotoDataByAdmin(Context ctx, IObjectValue paramAdmin, int start, int end) throws BOSException, EASBizException {
        int pageSize = end - start;
        HashMap<PersonInfo, byte[]> map = new HashMap<PersonInfo, byte[]>();
        AdminOrgUnitInfo adminOrgUnit = (AdminOrgUnitInfo)paramAdmin;
        String strSQL = "select top " + pageSize + " FImageData, FPersonID, FNumber, FName_" + ctx.getLocale() + " from (select top " + end + " pp.FImageData, pp.FPersonID, p.FNumber, p.FName_" + ctx.getLocale() + ", pp.fid from T_HR_PersonPhoto pp inner join T_BD_Person p on pp.FPersonID = p.FID where pp.FImageData is not null and pp.FPersonID in (select FPersonID from T_HR_PersonPosition where FPersonDep in (select FID from T_ORG_Admin where FLongNumber like '" + adminOrgUnit.getLongNumber().toString() + "%')) order by pp.fid) t order by fid desc";
        Connection conn = null;
        Statement statement = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            statement = conn.createStatement();
            rs = statement.executeQuery(strSQL);
            while (rs.next()) {
                InputStream in = null;
                try {
                    in = rs.getBinaryStream(1);
                    if (in == null) continue;
                    int blockSize = 1024;
                    byte[] block = new byte[1024];
                    ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
                    int len = -1;
                    do {
                        try {
                            len = in.read(block);
                        }
                        catch (IOException e1) {
                            throw new SQLException(e1.getMessage());
                        }
                        if (len <= 0) continue;
                        byteOut.write(block, 0, len);
                    } while (len == 1024);
                    byte[] data = byteOut.toByteArray();
                    PersonInfo person = new PersonInfo();
                    person.setId(BOSUuid.read((String)rs.getString(2)));
                    person.setNumber(rs.getString(3));
                    person.setName(rs.getString(4));
                    map.put(person, data);
                }
                finally {
                    try {
                        if (in == null) continue;
                        in.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (SQLException exc) {
            try {
                throw new BOSException("Sql execute exception : " + strSQL, (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)statement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)conn);
        return map;
    }

    @Override
    protected int _getPersonPhotoDataNumByAdmin(Context ctx, IObjectValue paramAdmin) throws BOSException, EASBizException {
        AdminOrgUnitInfo adminOrgUnit = (AdminOrgUnitInfo)paramAdmin;
        String sql = "select count(1) from T_HR_PersonPhoto pp inner join T_BD_Person p on pp.FPersonID = p.FID where pp.FImageData is not null and pp.FPersonID in (select FPersonID from T_HR_PersonPosition where FPersonDep in (select FID from T_ORG_Admin where FLongNumber like '" + adminOrgUnit.getLongNumber().toString() + "%'))";
        IRowSet rowset = HRDbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[0]);
        try {
            if (rowset.next()) {
                return rowset.getInt(1);
            }
        }
        catch (SQLException e) {
            throw new BOSException("Sql execute exception : " + sql, (Throwable)e);
        }
        return 0;
    }

    @Override
    protected HashMap _getPersonPhotoDataByAdmin(Context ctx, IObjectValue paramAdmin, boolean includeChild) throws BOSException, EASBizException {
        AdminOrgUnitInfo adminOrgUnit = (AdminOrgUnitInfo)paramAdmin;
        String strSQL = "";
        strSQL = includeChild ? "select FImageDataSource, pp.FPersonID, p.FNumber, p.FName_" + ctx.getLocale() + " from T_HR_PersonPhoto pp inner join T_BD_Person p on pp.FPersonID = p.FID where pp.FImageData is not null and pp.FPersonID in (select FPersonID from T_HR_PersonPosition where FPersonDep in (select FID from T_ORG_Admin where FLongNumber like '" + adminOrgUnit.getLongNumber().toString() + "%'))" : "select FImageDataSource, pp.FPersonID, p.FNumber, p.FName_" + ctx.getLocale() + " from T_HR_PersonPhoto pp inner join T_BD_Person p on pp.FPersonID = p.FID where pp.FImageData is not null and pp.FPersonID in (select FPersonID from T_HR_PersonPosition where FPersonDep = '" + adminOrgUnit.getId().toString() + "')";
        HashMap map = this.getPersonPhotoMap(ctx, strSQL);
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap getPersonPhotoMap(Context ctx, String strSQL) throws BOSException {
        HashMap<PersonInfo, byte[]> map = new HashMap<PersonInfo, byte[]>();
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            statement = conn.prepareStatement(strSQL);
            rs = statement.executeQuery();
            while (rs.next()) {
                InputStream in = null;
                try {
                    in = rs.getBinaryStream(1);
                    if (in == null) continue;
                    int blockSize = 1024;
                    byte[] block = new byte[1024];
                    ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
                    int len = -1;
                    do {
                        try {
                            len = in.read(block);
                        }
                        catch (IOException e1) {
                            throw new SQLException(e1.getMessage());
                        }
                        if (len <= 0) continue;
                        byteOut.write(block, 0, len);
                    } while (len == 1024);
                    byte[] data = byteOut.toByteArray();
                    PersonInfo person = new PersonInfo();
                    person.setId(BOSUuid.read((String)rs.getString(2)));
                    person.setNumber(rs.getString(3));
                    person.setName(rs.getString(4));
                    map.put(person, data);
                }
                finally {
                    try {
                        if (in == null) continue;
                        in.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (SQLException exc) {
            try {
                throw new BOSException("Sql execute exception : " + strSQL, (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, statement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)conn);
        return map;
    }

    @Override
    protected HashMap _getPersonDetailInfo(Context ctx) throws BOSException, EASBizException {
        HashMap<String, List> reMap = new HashMap<String, List>();
        try {
            List sameNameList = this.isPersonNameRepeat(ctx);
            List personList = HROrgContextManagerFacadeFactory.getLocalInstance((Context)ctx).getUserOrgRangePerson(null);
            reMap.put("sameNameList", sameNameList);
            reMap.put("personList", personList);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return reMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List isPersonNameRepeat(Context ctx) throws SQLException {
        ArrayList<String> sameNameList = new ArrayList<String>();
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        String sql = "select fid, fname_" + ctx.getLocale() + " from T_BD_Person where Fid in (select FPersonID from T_HR_PersonPosition where FPersonDep in (select ADMINORG.FID FROM T_ORG_ADMIN ADMINORG LEFT JOIN T_PM_OrgRange ORGR ON ADMINORG.FID = ORGR.FORGID LEFT JOIN T_PM_USER PUSER ON PUSER.FID = ORGR.FUSERID WHERE ORGR.FType = " + 20 + " AND PUSER.FNUMBER = '" + user.getNumber() + "'))";
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        try {
            con = DBUtils.getConnection((Context)ctx);
            stm = con.prepareStatement(sql);
            rs = stm.executeQuery();
            HashSet<String> nameSet = new HashSet<String>();
            while (rs.next()) {
                if (nameSet.contains(rs.getString(2))) {
                    sameNameList.add(rs.getString(2));
                    continue;
                }
                nameSet.add(rs.getString(2));
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, stm, (Connection)con);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stm, (Connection)con);
        return sameNameList;
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("person.number"));
        selector.add(new SelectorItemInfo("person.name"));
        PersonPhotoInfo info = (PersonPhotoInfo)this.getValue(ctx, pk, selector);
        return info.getPerson().getNumber() + info.getPerson().getName();
    }

    @Override
    protected HashMap _getPersonPhotoDataByPersonFilter(Context ctx, String personIdFilterSql) throws BOSException, EASBizException {
        String countSQL = "select count(fid) from T_HR_PersonPhoto where fpersonid in (" + personIdFilterSql + ")";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)countSQL);
        try {
            if (rs.next() && rs.getInt(1) > 2000) {
                Object[] info = new String[]{"2000"};
                throw new EmpBatchException(EmpBatchException.EXPORTPHOTOMUCHEXCEPTION, info);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        String strSQL = "select FImageDataSource, pp.FPersonID, p.FNumber, p.FName_" + ctx.getLocale() + " from T_HR_PersonPhoto pp inner join t_bd_person p on p.fid=pp.fpersonid where fpersonid in (" + personIdFilterSql + ")";
        HashMap dataMap = this.getPersonPhotoMap(ctx, strSQL);
        return dataMap;
    }

    protected CoreBaseCollection _getAuditPersonPhoto(Context ctx, String personId) throws BOSException {
        EmployeeAuditCollection coll = PersonPhotoAuditUtil.getEmployeeAuditPersonPhoto((Context)ctx, (String)personId);
        CoreBaseCollection personPhotoCollection = new CoreBaseCollection();
        if (coll.isEmpty()) {
            personPhotoCollection = PersonPhotoFactory.getLocalInstance(ctx).getCollection("where person = '" + personId + "'");
        } else {
            EmployeeAuditInfo employeeAuditInfo = coll.get(0);
            AuditPersonPhotoCollection collection = AuditPersonPhotoFactory.getLocalInstance((Context)ctx).getAuditPersonPhotoCollection("where parent = '" + coll.get(0).getId().toString() + "'");
            if (collection != null && collection.size() > 0) {
                AuditPersonPhotoInfo auditPersonPhotoInfo = collection.get(0);
                PersonPhotoInfo personPhotoInfo = this.assemblePersonPhotoByAuditPhoto(ctx, auditPersonPhotoInfo);
                PersonPhotoAuditUtil.assembleAuditPhoto((Context)ctx, (EmployeeAuditInfo)employeeAuditInfo, (PersonPhotoInfo)personPhotoInfo);
                personPhotoInfo.setPerson(coll.get(0).getPerson());
                personPhotoCollection.add((CoreBaseInfo)personPhotoInfo);
            }
        }
        return personPhotoCollection;
    }

    protected PersonPhotoInfo assemblePersonPhotoByAuditPhoto(Context ctx, AuditPersonPhotoInfo auditPersonPhotoInfo) {
        PersonPhotoInfo personPhotoInfo = new PersonPhotoInfo();
        personPhotoInfo.setImageData(auditPersonPhotoInfo.getImageData());
        personPhotoInfo.setImageDataSource(auditPersonPhotoInfo.getImageDataSource());
        personPhotoInfo.setImageContentType(auditPersonPhotoInfo.getImageContentType());
        personPhotoInfo.setSourceImageHeight(auditPersonPhotoInfo.getSourceImageHeight());
        personPhotoInfo.setSourceImageWidth(auditPersonPhotoInfo.getSourceImageWidth());
        personPhotoInfo.setIsInFile(auditPersonPhotoInfo.isIsInFile());
        return personPhotoInfo;
    }

    @Override
    protected IObjectPK _saveAuditPersonPhoto(Context ctx, IObjectValue photo) throws BOSException, EASBizException {
        PersonPhotoInfo personPhotoInfo = (PersonPhotoInfo)photo;
        String personId = "";
        if (personPhotoInfo.getPerson() == null || personPhotoInfo.getPerson().getId() == null) {
            return null;
        }
        personId = personPhotoInfo.getPerson().getId().toString();
        this.deleteExistAuditData(ctx, personId);
        this.doWithConfirmData(ctx, personId);
        IEmployeeAudit iEmployeeAudit = EmployeeAuditFactory.getLocalInstance(ctx);
        EmployeeAuditInfo auditInfo = this.assembleBaseAuditInfo(ctx);
        auditInfo.setPerson(personPhotoInfo.getPerson());
        if (personPhotoInfo.getId() != null) {
            auditInfo.setPk(personPhotoInfo.getId());
        } else {
            auditInfo.setPk(BOSUuid.create((BOSObjectType)personPhotoInfo.getBOSType()));
        }
        IObjectPK pk = iEmployeeAudit.addnew((CoreBaseInfo)auditInfo);
        AuditPersonPhotoInfo auditPersonPhotoInfo = new AuditPersonPhotoInfo();
        auditPersonPhotoInfo.setParent(auditInfo);
        auditPersonPhotoInfo.setPreImageData(PersonPhotoAuditUtil.getPersonPhoto((Context)ctx, (String)personId));
        auditPersonPhotoInfo.setImageData(personPhotoInfo.getImageData());
        auditPersonPhotoInfo.setImageDataSource(personPhotoInfo.getImageDataSource());
        auditPersonPhotoInfo.setImageContentType(personPhotoInfo.getImageContentType());
        auditPersonPhotoInfo.setSourceImageHeight(personPhotoInfo.getSourceImageHeight());
        auditPersonPhotoInfo.setSourceImageWidth(personPhotoInfo.getSourceImageWidth());
        auditPersonPhotoInfo.setIsInFile(personPhotoInfo.isIsInFile());
        IObjectPK auditPk = AuditPersonPhotoFactory.getLocalInstance((Context)ctx).addnew(auditPersonPhotoInfo);
        return auditPk;
    }

    protected void doWithConfirmData(Context ctx, String personId) throws BOSException {
        EntityViewInfo auditViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection auditSelector = new SelectorItemCollection();
        auditSelector.add(new SelectorItemInfo("id"));
        FilterItemCollection filterItemColl = filter.getFilterItems();
        filterItemColl.add(new FilterItemInfo("status", (Object)3));
        filterItemColl.add(new FilterItemInfo("confirmStatus", (Object)false));
        filterItemColl.add(new FilterItemInfo("person.id", (Object)personId));
        filterItemColl.add(new FilterItemInfo("category", (Object)PersonPhotoAuditUtil.personCategoryId));
        auditViewInfo.setFilter(filter);
        auditViewInfo.setSelector(auditSelector);
        EmployeeAuditCollection collection = EmployeeAuditFactory.getLocalInstance(ctx).getEmployeeAuditCollection(auditViewInfo);
        if (collection.size() > 0) {
            for (int i = 0; i < collection.size(); ++i) {
                EmployeePageAuditServerUtil.confirmEmployeeAudit(ctx, (IObjectPK)new ObjectUuidPK(collection.get(i).getId()));
            }
        }
    }

    private void deleteExistAuditData(Context ctx, String personId) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        FilterItemCollection filterItemColl = filter.getFilterItems();
        filterItemColl.add(new FilterItemInfo("status", (Object)1));
        filterItemColl.add(new FilterItemInfo("person.id", (Object)personId));
        filterItemColl.add(new FilterItemInfo("category", (Object)PersonPhotoAuditUtil.personCategoryId));
        Object[] pks = EmployeeAuditFactory.getLocalInstance(ctx).delete(filter);
        if (pks.length > 0) {
            FilterInfo deleteFilter = new FilterInfo();
            deleteFilter.getFilterItems().add(new FilterItemInfo("parent", (Object)Sets.newHashSet((Object[])pks), CompareType.INCLUDE));
            AuditPersonPhotoFactory.getLocalInstance((Context)ctx).delete(deleteFilter);
        }
    }

    private EmployeeAuditInfo assembleBaseAuditInfo(Context ctx) {
        EmployeeAuditInfo auditInfo = new EmployeeAuditInfo();
        auditInfo.setId(BOSUuid.create((BOSObjectType)auditInfo.getBOSType()));
        EmployeePageDataSetInfo pageDataSetInfo = new EmployeePageDataSetInfo();
        pageDataSetInfo.setId(BOSUuid.read((String)PersonPhotoAuditUtil.personCategoryId));
        auditInfo.setCategory(pageDataSetInfo);
        auditInfo.setOperateType(OperateTypeEnum.UPDATE);
        auditInfo.setSaveTime(DateTimeUtils.truncateDate((Date)new Date()));
        auditInfo.setEntity("com.kingdee.eas.hr.emp.app.PersonPhoto");
        auditInfo.setStatus(EmployeeAuditStateEnum.SUBMITED);
        auditInfo.setConfirmStatus(false);
        return auditInfo;
    }
}

