/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.basedata.org.HROrgUnitFactory;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.affair.HRAffairBizBillEntryInfo;
import com.kingdee.eas.hr.affair.HRAffairBizFactory;
import com.kingdee.eas.hr.affair.HRAffairBizInfo;
import com.kingdee.eas.hr.affair.HRAffairException;
import com.kingdee.eas.hr.affair.IHRAffairBizBillEntry;
import com.kingdee.eas.hr.affair.RiseBizBillFactory;
import com.kingdee.eas.hr.affair.RiseBizBillInfo;
import com.kingdee.eas.hr.base.EmpPosOrgRelationInfo;
import com.kingdee.eas.hr.base.HRAffairActionTransactionLogCollection;
import com.kingdee.eas.hr.base.HRAffairActionTransactionLogFactory;
import com.kingdee.eas.hr.base.util.HRUtilExtend;
import com.kingdee.eas.hr.emp.EmpPostRankCollection;
import com.kingdee.eas.hr.emp.EmpPostRankFactory;
import com.kingdee.eas.hr.emp.EmpPostRankInfo;
import com.kingdee.eas.hr.emp.EmployeeBosBizException;
import com.kingdee.eas.hr.emp.PersonOtherInfoFactory;
import com.kingdee.eas.hr.emp.PersonOtherInfoInfo;
import com.kingdee.eas.hr.org.JobGradeFactory;
import com.kingdee.eas.hr.org.JobGradeInfo;
import com.kingdee.eas.hr.org.JobLevelFactory;
import com.kingdee.eas.hr.org.JobLevelInfo;
import com.kingdee.eas.hr.org.JobLevelProjectFactory;
import com.kingdee.eas.hr.org.JobLevelProjectInfo;
import com.kingdee.eas.hr.org.PositionExtendFactory;
import com.kingdee.eas.hr.org.PositionExtendInfo;
import com.kingdee.eas.hr.org.util.JobSystemUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class EmpPostRankUtil {
    public static void updateEmpPosRankByEmpOrgRela(Context ctx, EmpPosOrgRelationInfo info, EmpPosOrgRelationInfo oldInfo) throws BOSException, EASBizException {
        EmpPostRankCollection coll = EmpPostRankFactory.getLocalInstance(ctx).getEmpPostRankCollection("where person.id='" + info.getPerson().getId().toString() + "' and source=" + 2 + " order by EFFDT ASC");
        if (coll.size() > 0) {
            EmpPostRankInfo empRankInfo = coll.get(0);
            empRankInfo.setEFFDT(info.getEFFDT());
            empRankInfo.setHrOrgUnit(info.getHrOrgUnit());
            empRankInfo.setCompany(info.getCompany());
            empRankInfo.setLastUpdateUser(info.getLastUpdateUser());
            empRankInfo.setLastUpdateTime(info.getLastUpdateTime());
            EmpPostRankFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(empRankInfo.getId()), empRankInfo);
        }
    }

    public static EmpPostRankInfo getPersonAppointDateEmpPostRankInfo(Context ctx, String personId, Date date) throws BOSException {
        EmpPostRankInfo eprInfo = null;
        if (date == null) {
            date = new Date();
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person", (Object)personId));
        filter.getFilterItems().add(new FilterItemInfo("EFFDT", (Object)date, CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("LEFFDT", (Object)date, CompareType.GREATER));
        SelectorItemCollection sic = EmpPostRankUtil.getEmpPostRankSelector();
        view.setSelector(sic);
        view.setFilter(filter);
        EmpPostRankCollection eprColl = EmpPostRankFactory.getLocalInstance(ctx).getEmpPostRankCollection(view);
        if (eprColl.size() > 0) {
            eprInfo = eprColl.get(0);
        }
        return eprInfo;
    }

    public static EmpPostRankInfo getPersonBeforeAppointDateEmpPostRankInfo(Context ctx, String personId, Date date) throws BOSException {
        EmpPostRankInfo eprInfo = null;
        if (date == null) {
            date = new Date();
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person", (Object)personId));
        filter.getFilterItems().add(new FilterItemInfo("isLatest", (Object)false, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("LEFFDT", (Object)date, CompareType.LESS_EQUALS));
        SelectorItemCollection sic = EmpPostRankUtil.getEmpPostRankSelector();
        SorterItemCollection sorter = new SorterItemCollection();
        SorterItemInfo sortInfo = new SorterItemInfo("LEFFDT");
        sortInfo.setSortType(SortType.DESCEND);
        sorter.add(sortInfo);
        view.setSelector(sic);
        view.setFilter(filter);
        view.setSorter(sorter);
        EmpPostRankCollection eprColl = EmpPostRankFactory.getLocalInstance(ctx).getEmpPostRankCollection(view);
        if (eprColl.size() > 0) {
            eprInfo = eprColl.get(0);
        }
        return eprInfo;
    }

    public static EmpPostRankInfo getPersonFirstNotInitEmpPostRankInfo(Context ctx, String personId) throws BOSException {
        EmpPostRankInfo eprInfo = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person", (Object)personId));
        filter.getFilterItems().add(new FilterItemInfo("source", (Object)1, CompareType.NOTEQUALS));
        SelectorItemCollection sic = EmpPostRankUtil.getEmpPostRankSelector();
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("EFFDT"));
        view.setSelector(sic);
        view.setFilter(filter);
        view.setSorter(sorter);
        EmpPostRankCollection eprColl = EmpPostRankFactory.getLocalInstance(ctx).getEmpPostRankCollection(view);
        if (eprColl.size() > 0) {
            eprInfo = eprColl.get(0);
        }
        return eprInfo;
    }

    public static EmpPostRankInfo getPersonFirstByChangeEmpPostRankInfo(Context ctx, String personId) throws BOSException {
        EmpPostRankInfo eprInfo = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person", (Object)personId));
        filter.getFilterItems().add(new FilterItemInfo("source", (Object)2, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("source", (Object)3, CompareType.EQUALS));
        filter.setMaskString("(#0 and (#1 or #2))");
        SelectorItemCollection sic = EmpPostRankUtil.getEmpPostRankSelector();
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("EFFDT"));
        view.setSelector(sic);
        view.setFilter(filter);
        view.setSorter(sorter);
        EmpPostRankCollection eprColl = EmpPostRankFactory.getLocalInstance(ctx).getEmpPostRankCollection(view);
        if (eprColl.size() > 0) {
            eprInfo = eprColl.get(0);
        }
        return eprInfo;
    }

    private static SelectorItemCollection getEmpPostRankSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("jobLevel.id"));
        sic.add(new SelectorItemInfo("jobLevel.name"));
        sic.add(new SelectorItemInfo("jobLevel.number"));
        sic.add(new SelectorItemInfo("jobLevel.index"));
        sic.add(new SelectorItemInfo("jobGrade.id"));
        sic.add(new SelectorItemInfo("jobGrade.name"));
        sic.add(new SelectorItemInfo("jobGrade.number"));
        sic.add(new SelectorItemInfo("jobGrade.index"));
        return sic;
    }

    public static void checkJobLevelGradeRangeInPosition(Context ctx, JobLevelInfo jobLevel, JobGradeInfo jobGrade, String posId) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((CharSequence)posId)) {
            return;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("highJobGrade.*"));
        sic.add(new SelectorItemInfo("lowJobGrade.*"));
        sic.add(new SelectorItemInfo("highJobGrade.jobGradeModule.id"));
        sic.add(new SelectorItemInfo("lowJobGrade.jobGradeModule.id"));
        PositionInfo posInfo = PositionFactory.getLocalInstance((Context)ctx).getPositionInfo((IObjectPK)new ObjectUuidPK(posId), sic);
        if (jobLevel != null && jobLevel.getId() != null) {
            String sql = "select *,highJobLevel.*,lowJobLevel.*,highJobLevel.jobLevelProject.id,lowJobLevel.jobLevelProject.id  where position = '" + posInfo.getId() + "'";
            PositionExtendInfo posExtendInfo = PositionExtendFactory.getLocalInstance((Context)ctx).getPositionExtendInfo(sql);
            JobLevelInfo lowJobLevel = posExtendInfo.getLowJobLevel();
            JobLevelInfo highJobLevel = posExtendInfo.getHighJobLevel();
            if (lowJobLevel == null || highJobLevel == null) {
                Object[] params = new String[]{jobLevel.getName(), posInfo.getName()};
                throw new HRAffairException(HRAffairException.JOBLEVEL_NOT_IN_POS_RANGE, params);
            }
            jobLevel = JobLevelFactory.getLocalInstance((Context)ctx).getJobLevelInfo((IObjectPK)new ObjectUuidPK(jobLevel.getId()));
            if (!(HRUtilExtend.isObjectEquelsByPkValue((CoreBaseInfo)jobLevel.getJobLevelProject(), (CoreBaseInfo)lowJobLevel.getJobLevelProject()) && jobLevel.getIndex() >= lowJobLevel.getIndex() && jobLevel.getIndex() <= highJobLevel.getIndex())) {
                Object[] params = new String[]{jobLevel.getName(), posInfo.getName()};
                throw new HRAffairException(HRAffairException.JOBLEVEL_NOT_IN_POS_RANGE, params);
            }
        }
        if (jobGrade != null && jobGrade.getId() != null) {
            Object[] params;
            JobGradeInfo lowJobGrade = posInfo.getLowJobGrade();
            JobGradeInfo highJobGrade = posInfo.getHighJobGrade();
            if (posInfo.getLowJobGrade() == null || posInfo.getHighJobGrade() == null) {
                params = new String[]{jobGrade.getName(), posInfo.getName()};
                throw new HRAffairException(HRAffairException.JOBGRADE_NOT_IN_POS_RANGE, params);
            }
            jobGrade = JobGradeFactory.getLocalInstance((Context)ctx).getJobGradeInfo((IObjectPK)new ObjectUuidPK(jobGrade.getId()));
            if (!(HRUtilExtend.isObjectEquelsByPkValue((CoreBaseInfo)jobGrade.getJobGradeModule(), (CoreBaseInfo)lowJobGrade.getJobGradeModule()) && jobGrade.getIndex() >= lowJobGrade.getIndex() && jobGrade.getIndex() <= highJobGrade.getIndex())) {
                params = new String[]{jobGrade.getName(), posInfo.getName()};
                throw new HRAffairException(HRAffairException.JOBGRADE_NOT_IN_POS_RANGE, params);
            }
        }
        EmpPostRankUtil.checkJobLevelInJobGrade(ctx, jobLevel, jobGrade);
    }

    public static void checkJobLevelGradeRangeInHrOrg(Context ctx, JobLevelInfo jobLevel, JobGradeInfo jobGrade, String hrOrgId) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((CharSequence)hrOrgId)) {
            return;
        }
        Set jlpIdSet = new HashSet();
        Set jpmIdSet = new HashSet();
        HROrgUnitInfo hrOrgInfo = HROrgUnitFactory.getLocalInstance((Context)ctx).getHROrgUnitInfo((IObjectPK)new ObjectUuidPK(hrOrgId));
        jlpIdSet = JobSystemUtil.getJobLevelProjectAvailableIdSet((Context)ctx, (String)hrOrgInfo.getId().toString());
        jpmIdSet = JobSystemUtil.getJobGradeModuleAvailableIdSet((Context)ctx, (String)hrOrgInfo.getId().toString());
        if (jobLevel != null && jobLevel.getId() != null && !jlpIdSet.contains((jobLevel = JobLevelFactory.getLocalInstance((Context)ctx).getJobLevelInfo((IObjectPK)new ObjectUuidPK(jobLevel.getId()))).getJobLevelProject().getId().toString())) {
            Object[] params = new String[]{jobLevel.getName(), hrOrgInfo.getName()};
            throw new HRAffairException(HRAffairException.JOBLEVEL_NOT_IN_HRORG_RANGE, params);
        }
        if (jobGrade != null && jobGrade.getId() != null && !jpmIdSet.contains((jobGrade = JobGradeFactory.getLocalInstance((Context)ctx).getJobGradeInfo((IObjectPK)new ObjectUuidPK(jobGrade.getId()))).getJobGradeModule().getId().toString())) {
            Object[] params = new String[]{jobGrade.getName(), hrOrgInfo.getName()};
            throw new HRAffairException(HRAffairException.JOBGRADE_NOT_IN_HRORG_RANGE, params);
        }
        EmpPostRankUtil.checkJobLevelInJobGrade(ctx, jobLevel, jobGrade);
    }

    public static void checkJobLevelInJobGrade(Context ctx, JobLevelInfo jobLevel, JobGradeInfo jobGrade) throws EASBizException, BOSException {
        if (jobGrade != null && jobLevel != null && jobGrade.getId() != null && jobLevel.getId() != null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("jobLevelProject.*"));
            sic.add(new SelectorItemInfo("lowestJobGrade.*"));
            sic.add(new SelectorItemInfo("jobGrade.*"));
            jobLevel = JobLevelFactory.getLocalInstance((Context)ctx).getJobLevelInfo((IObjectPK)new ObjectUuidPK(jobLevel.getId()), sic);
            jobGrade = JobGradeFactory.getLocalInstance((Context)ctx).getJobGradeInfo((IObjectPK)new ObjectUuidPK(jobGrade.getId()));
            JobLevelProjectInfo jobLevelProjectInfo = null;
            String jobLevelProjectId = "";
            if (jobLevel.getJobLevelProject() != null) {
                jobLevelProjectId = jobLevel.getJobLevelProject().getId().toString();
            }
            jobLevelProjectInfo = JobLevelProjectFactory.getLocalInstance((Context)ctx).getJobLevelProjectInfo((IObjectPK)new ObjectUuidPK(jobLevelProjectId));
            if (!StringUtils.isEmpty((CharSequence)jobLevelProjectId) && jobLevel != null && jobLevelProjectInfo.getJobGradeModule() != null && jobLevelProjectInfo.getJobGradeModule().getId() != null) {
                String jobGradeMoudleId = jobGrade.getJobGradeModule().getId().toString();
                if (!jobGradeMoudleId.equals(jobLevelProjectInfo.getJobGradeModule().getId().toString())) {
                    Object[] params = new String[]{jobGrade.getName(), jobLevel.getName()};
                    throw new HRAffairException(HRAffairException.JOBLEVEL_NOT_IN_LEVEL_RANGE, params);
                }
                if (null != jobLevel.getLowestJobGrade() && null != jobLevel.getJobGrade()) {
                    int lowjobGradeindex = -999;
                    int highjobGradeindex = -999;
                    lowjobGradeindex = jobLevel.getLowestJobGrade().getIndex();
                    highjobGradeindex = jobLevel.getJobGrade().getIndex();
                    if (lowjobGradeindex == -999 || jobGrade != null && jobGrade.getIndex() < lowjobGradeindex || jobGrade != null && jobGrade.getIndex() > highjobGradeindex) {
                        Object[] params = new String[]{jobGrade.getName(), jobLevel.getName()};
                        throw new HRAffairException(HRAffairException.JOBLEVEL_NOT_IN_LEVEL_RANGE, params);
                    }
                }
            }
        }
    }

    public static EmpPostRankInfo getPersonPreviousAppointDateEmpPostRankInfo(Context ctx, String personId, Date date) throws BOSException {
        EmpPostRankInfo eprInfo = null;
        if (date == null) {
            date = new Date();
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person", (Object)personId));
        filter.getFilterItems().add(new FilterItemInfo("isLatest", (Object)false, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("EFFDT", (Object)date, CompareType.LESS_EQUALS));
        SelectorItemCollection sic = EmpPostRankUtil.getEmpPostRankSelector();
        SorterItemCollection sorter = new SorterItemCollection();
        SorterItemInfo sortInfo = new SorterItemInfo("EFFDT");
        sortInfo.setSortType(SortType.DESCEND);
        sorter.add(sortInfo);
        view.setSelector(sic);
        view.setFilter(filter);
        view.setSorter(sorter);
        EmpPostRankCollection eprColl = EmpPostRankFactory.getLocalInstance(ctx).getEmpPostRankCollection(view);
        if (eprColl.size() > 0) {
            eprInfo = eprColl.get(0);
        }
        return eprInfo;
    }

    public static EmpPostRankCollection getPersonAppointDateEmpPostRankCollection(Context ctx, String personId, Date date) throws BOSException {
        if (date == null) {
            date = new Date();
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person", (Object)personId));
        filter.getFilterItems().add(new FilterItemInfo("EFFDT", (Object)date, CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("LEFFDT", (Object)date, CompareType.GREATER_EQUALS));
        SelectorItemCollection sic = EmpPostRankUtil.getEmpPostRankSelector();
        view.setSelector(sic);
        view.setFilter(filter);
        EmpPostRankCollection eprColl = EmpPostRankFactory.getLocalInstance(ctx).getEmpPostRankCollection(view);
        return eprColl;
    }

    public static EmpPostRankCollection getPostRankCollectionAfterRecord(Context ctx, String postRankId) throws BOSException, EASBizException {
        EmpPostRankInfo currentPostRankInfo = EmpPostRankFactory.getLocalInstance(ctx).getEmpPostRankInfo((IObjectPK)new ObjectUuidPK(postRankId));
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person", (Object)currentPostRankInfo.getPerson().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("EFFDT", (Object)currentPostRankInfo.getEFFDT(), CompareType.GREATER));
        filter.getFilterItems().add(new FilterItemInfo("rankEndDate", (Object)currentPostRankInfo.getRankEndDate(), CompareType.GREATER));
        filter.getFilterItems().add(new FilterItemInfo("source", (Object)currentPostRankInfo.getSource().getValue()));
        SelectorItemCollection sic = EmpPostRankUtil.getEmpPostRankSelector();
        view.setSelector(sic);
        view.setFilter(filter);
        EmpPostRankCollection eprColl = EmpPostRankFactory.getLocalInstance(ctx).getEmpPostRankCollection(view);
        return eprColl;
    }

    public static RiseBizBillInfo getRiseBizBillInfoByPostRankInfo(Context ctx, EmpPostRankInfo postRankInfo) throws BOSException, SQLException, EASBizException {
        RiseBizBillInfo result = new RiseBizBillInfo();
        String postRankInfoId = postRankInfo.getId().toString();
        String sql = "select fid as billId from T_HR_RiseBizBill where fid =( SELECT FBillID FROM T_HR_RISEBIZBILLENTRY where fid = ( select FAffairEntryID from T_HR_HRAATL where fid =(select FlowInAffairID from T_HR_EmpPostRank where fid = '" + postRankInfoId + "')))";
        IRowSet queryResult = DbUtil.executeQuery((Context)ctx, (String)sql);
        String riseBizBillId = null;
        while (queryResult.next()) {
            riseBizBillId = queryResult.getString("billId");
        }
        result = RiseBizBillFactory.getLocalInstance((Context)ctx).getRiseBizBillInfo((IObjectPK)new ObjectUuidPK(riseBizBillId));
        return result;
    }

    public static boolean isPostRankChange(Context ctx, String billId, String personId) throws EASBizException, BOSException {
        Object[] bosTypeStrings = new String[]{"B41CAA3F", "B65CCEF1", "C0DAD00D", "E41B9A4E", "E8FE38CB", "C4D946DE"};
        String billBosTypeString = BOSUuid.read((String)billId).getType().toString();
        if (!Arrays.asList((Object[])bosTypeStrings).contains(billBosTypeString)) {
            return false;
        }
        String getInfoSql = "where person = '" + personId + "' and billid = '" + billId + "'";
        HRAffairBizInfo affairBizInfo = HRAffairBizFactory.getLocalInstance((Context)ctx).getHRAffairBizInfo(getInfoSql);
        String entryId = affairBizInfo.getEntryID().toString();
        String entryBosTypeString = BOSUuid.read((String)entryId).getType().toString();
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        String entityName = loader.getEntity(BOSObjectType.create((String)entryBosTypeString)).getFullName();
        IHRAffairBizBillEntry IHRAffairBizBillEntry2 = (IHRAffairBizBillEntry)BOSObjectFactory.createCommonBOSObject((Context)ctx, (IMetaDataPK)MetaDataPK.create((String)entityName));
        HRAffairBizBillEntryInfo entryInfo = IHRAffairBizBillEntry2.getHRAffairBizBillEntryInfo((IObjectPK)new ObjectUuidPK(entryId));
        return entryInfo.getJobGrade() != null && !HRUtilExtend.isObjectEquelsByPkValue((CoreBaseInfo)entryInfo.getOldJobGrade(), (CoreBaseInfo)entryInfo.getJobGrade()) || entryInfo.getJobLevel() != null && !HRUtilExtend.isObjectEquelsByPkValue((CoreBaseInfo)entryInfo.getOldJobLevel(), (CoreBaseInfo)entryInfo.getJobLevel());
    }

    public static PersonOtherInfoInfo getPersonOtherInfo(Context ctx, String personId) throws BOSException {
        PersonOtherInfoInfo personOtherInfo = null;
        try {
            if (!PersonOtherInfoFactory.getLocalInstance(ctx).exists("where person = '" + personId + "'")) {
                throw new BOSException((Throwable)((Object)new EmployeeBosBizException(EmployeeBosBizException.THIS_EMP_NO_OTHER_INFO_TABLE)));
            }
            personOtherInfo = PersonOtherInfoFactory.getLocalInstance(ctx).getPersonOtherInfoInfo("where person = '" + personId + "'");
        }
        catch (EASBizException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return personOtherInfo;
    }

    public static void setLatestPostRankInfoByPersonId(Context ctx, String personId) throws BOSException {
        String updateSql;
        EmpPostRankInfo eprInfo = null;
        String eprInfoId = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person", (Object)personId));
        SelectorItemCollection sic = EmpPostRankUtil.getEmpPostRankSelector();
        SorterItemCollection sorter = new SorterItemCollection();
        SorterItemInfo sortInfo = new SorterItemInfo("EFFDT");
        sortInfo.setSortType(SortType.DESCEND);
        sorter.add(sortInfo);
        view.setSelector(sic);
        view.setFilter(filter);
        view.setSorter(sorter);
        EmpPostRankCollection eprColl = EmpPostRankFactory.getLocalInstance(ctx).getEmpPostRankCollection(view);
        if (eprColl.size() > 0) {
            eprInfo = eprColl.get(0);
            eprInfoId = eprInfo.getId().toString();
            updateSql = "UPDATE T_hr_emppostrank SET FISLATEST = 1  WHERE  FPERSONID ='" + personId + "' and fid = '" + eprInfoId + "'";
            DbUtil.execute((Context)ctx, (String)updateSql);
        }
        if (eprColl.size() > 1) {
            updateSql = "UPDATE T_hr_emppostrank SET FISLATEST = 0  WHERE  FPERSONID ='" + personId + "' and fid <> '" + eprInfoId + "'";
            DbUtil.execute((Context)ctx, (String)updateSql);
        }
    }

    public static EmpPostRankInfo getLastedEmpPostRank(Context ctx, String personId) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person", (Object)personId));
        filter.getFilterItems().add(new FilterItemInfo("isLatest", (Object)true, CompareType.EQUALS));
        SelectorItemCollection sic = EmpPostRankUtil.getEmpPostRankSelector();
        view.setSelector(sic);
        view.setFilter(filter);
        EmpPostRankCollection eprColl = EmpPostRankFactory.getLocalInstance(ctx).getEmpPostRankCollection(view);
        return eprColl.get(0);
    }

    public static JobLevelInfo getLastedJobLevelInfo(Context ctx, String personId) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person", (Object)personId));
        filter.getFilterItems().add(new FilterItemInfo("isLatest", (Object)true, CompareType.EQUALS));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("jobLevel.*"));
        view.setSelector(sic);
        view.setFilter(filter);
        JobLevelInfo jobLevelInfo = null;
        EmpPostRankCollection eprColl = EmpPostRankFactory.getLocalInstance(ctx).getEmpPostRankCollection(view);
        if (eprColl.size() > 0) {
            jobLevelInfo = eprColl.get(0).getJobLevel();
        }
        return jobLevelInfo;
    }

    public static JobGradeInfo getLastedJobGradeInfo(Context ctx, String personId) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person", (Object)personId));
        filter.getFilterItems().add(new FilterItemInfo("isLatest", (Object)true, CompareType.EQUALS));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("jobGrade.*"));
        view.setSelector(sic);
        view.setFilter(filter);
        JobGradeInfo jobGradeInfo = null;
        EmpPostRankCollection eprColl = EmpPostRankFactory.getLocalInstance(ctx).getEmpPostRankCollection(view);
        if (eprColl.size() > 0) {
            jobGradeInfo = eprColl.get(0).getJobGrade();
        }
        return jobGradeInfo;
    }

    public static EmpPostRankInfo getEmpPostRankByBillId(Context ctx, String personId, String billId) throws BOSException {
        if (StringUtils.isEmpty((CharSequence)personId) || StringUtils.isEmpty((CharSequence)billId)) {
            return null;
        }
        HRAffairActionTransactionLogCollection hraatlCol = HRAffairActionTransactionLogFactory.getLocalInstance((Context)ctx).getHRAffairActionTransactionLogCollection("where affairEntryID ='" + billId + "'");
        if (hraatlCol.size() == 0) {
            return null;
        }
        String logId = hraatlCol.get(0).getId().toString();
        hraatlCol.get(0).getId().toString();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person", (Object)personId));
        filter.getFilterItems().add(new FilterItemInfo("flowInAffairID", (Object)logId));
        SelectorItemCollection sic = EmpPostRankUtil.getEmpPostRankSelector();
        view.setSelector(sic);
        view.setFilter(filter);
        EmpPostRankCollection eprColl = EmpPostRankFactory.getLocalInstance(ctx).getEmpPostRankCollection(view);
        return eprColl.get(0);
    }
}

