/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.HistoryConstant;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.AssignTypeEnum;
import com.kingdee.eas.hr.base.EmpPosOrgRelationCollection;
import com.kingdee.eas.hr.base.EmpPosOrgRelationFactory;
import com.kingdee.eas.hr.base.EmpPosOrgRelationInfo;
import com.kingdee.eas.hr.base.app.EmpPosOrgRelationQueryHelper;
import com.kingdee.eas.hr.base.app.his.HistoryVersionUtil;
import com.kingdee.eas.hr.base.util.HRUtilExtend;
import com.kingdee.eas.hr.emp.EmployeeBosBizException;
import com.kingdee.eas.hr.emp.EmployeeException;
import com.kingdee.util.DateTimeUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class SHREmpOptEmpOrgRelationTool {
    public static EmpPosOrgRelationInfo getCurrntMainEmpOrgRelationInfo(Context ctx, String personId) throws BOSException, EASBizException {
        Date pDate = DateTimeUtils.truncateDate((Date)new Date());
        EmpPosOrgRelationInfo info = SHREmpOptEmpOrgRelationTool.getAppoinDateEmpOrgRelationInfo(ctx, personId, pDate);
        return info;
    }

    public static EmpPosOrgRelationInfo getAppoinDateEmpOrgRelationInfo(Context ctx, String personId, Date date) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isInner", (Object)true));
        filter.getFilterItems().add(new FilterItemInfo("assignType", (Object)1));
        FilterInfo filterDate = HistoryVersionUtil.getPointDateLatestFilterInfo((Date)date);
        filter.mergeFilter(filterDate, "and");
        view.setFilter(filter);
        EmpPosOrgRelationQueryHelper queryHelper = new EmpPosOrgRelationQueryHelper();
        view.setSelector(queryHelper.getSelector());
        EmpPosOrgRelationCollection collection = EmpPosOrgRelationFactory.getLocalInstance((Context)ctx).getEmpPosOrgRelationCollection(view);
        if (collection.size() == 1) {
            return collection.get(0);
        }
        Object[] params = new Object[2];
        PersonInfo personInfo = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(personId));
        params[0] = personInfo.getName();
        params[1] = HRUtilExtend.getDateStringWithoutMininute((Date)date);
        if (collection.size() > 1) {
            throw new EmployeeException(EmployeeException.EMP_RELATIONS_DUP, params);
        }
        return null;
    }

    public static Map<String, EmpPosOrgRelationInfo> getCurrntMainEmpOrgRelationInfoMap(Context ctx, Set personSet) throws BOSException, EASBizException {
        HashMap<String, EmpPosOrgRelationInfo> resultMap = new HashMap();
        Date pDate = DateTimeUtils.truncateDate((Date)new Date());
        resultMap = SHREmpOptEmpOrgRelationTool.getAppoinDateEmpOrgRelationInfoMap(ctx, personSet, pDate);
        return resultMap;
    }

    public static Map<String, EmpPosOrgRelationInfo> getAppoinDateEmpOrgRelationInfoMap(Context ctx, Set personSet, Date date) throws BOSException, EASBizException {
        HashMap<String, EmpPosOrgRelationInfo> resultMap = new HashMap<String, EmpPosOrgRelationInfo>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)personSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("isInner", (Object)true));
        filter.getFilterItems().add(new FilterItemInfo("assignType", (Object)1));
        FilterInfo filterDate = HistoryVersionUtil.getPointDateLatestFilterInfo((Date)date);
        filter.mergeFilter(filterDate, "and");
        view.setFilter(filter);
        EmpPosOrgRelationQueryHelper queryHelper = new EmpPosOrgRelationQueryHelper();
        view.setSelector(queryHelper.getSelector());
        EmpPosOrgRelationCollection coll = EmpPosOrgRelationFactory.getLocalInstance((Context)ctx).getEmpPosOrgRelationCollection(view);
        ArrayList<String> tooManyRecord = new ArrayList<String>();
        for (int i = 0; i < coll.size(); ++i) {
            EmpPosOrgRelationInfo info = coll.get(i);
            PersonInfo personInfo = info.getPerson();
            if (resultMap.get(personInfo.getId().toString()) == null && !tooManyRecord.contains(personInfo.getId().toString())) {
                resultMap.put(personInfo.getId().toString(), info);
                continue;
            }
            resultMap.remove(personInfo.getId().toString());
            tooManyRecord.add(personInfo.getId().toString());
        }
        return resultMap;
    }

    public static EmpPosOrgRelationInfo getAppoinDateEqualsEffdtEmpOrgRelationInfo(Context ctx, String personId, Date date, int assignType) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isInner", (Object)true));
        Date pDate = DateTimeUtils.truncateDate((Date)date);
        filter.getFilterItems().add(new FilterItemInfo(HistoryConstant.EFFDT, (Object)pDate, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("assignType", (Object)assignType));
        view.setFilter(filter);
        EmpPosOrgRelationQueryHelper queryHelper = new EmpPosOrgRelationQueryHelper();
        view.setSelector(queryHelper.getSelector());
        EmpPosOrgRelationCollection collection = EmpPosOrgRelationFactory.getLocalInstance((Context)ctx).getEmpPosOrgRelationCollection(view);
        if (collection.size() > 1) {
            throw new BOSException((Throwable)((Object)new EmployeeBosBizException(EmployeeBosBizException.EMP_THIS_DATE_HAS_SAME)));
        }
        return collection.get(0);
    }

    public static EmpPosOrgRelationCollection getPersonMainIsInnerEmpOrgRelationColl(Context ctx, String personId, boolean isInner) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isInner", (Object)isInner));
        filter.getFilterItems().add(new FilterItemInfo("assignType", (Object)1));
        view.setFilter(filter);
        EmpPosOrgRelationQueryHelper queryHelper = new EmpPosOrgRelationQueryHelper();
        view.setSelector(queryHelper.getSelector());
        SorterItemCollection sorters = new SorterItemCollection();
        SorterItemInfo sorterItemInfo = new SorterItemInfo("endDateTime");
        sorterItemInfo.setSortType(SortType.DESCEND);
        sorters.add(sorterItemInfo);
        view.setSorter(sorters);
        EmpPosOrgRelationCollection collection = EmpPosOrgRelationFactory.getLocalInstance((Context)ctx).getEmpPosOrgRelationCollection(view);
        return collection;
    }

    public static EmpPosOrgRelationCollection getAppointDateEmpOrgRelationColl(Context ctx, String personId, Date effdt, AssignTypeEnum assginType) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isInner", (Object)1));
        if (assginType != null) {
            filter.getFilterItems().add(new FilterItemInfo("assignType", (Object)assginType.getValue()));
        }
        FilterInfo filterDate = HistoryVersionUtil.getPointDateFilterInfo((Date)effdt);
        filter.mergeFilter(filterDate, "and");
        view.setFilter(filter);
        EmpPosOrgRelationQueryHelper queryHelper = new EmpPosOrgRelationQueryHelper();
        view.setSelector(queryHelper.getSelector());
        EmpPosOrgRelationCollection collection = EmpPosOrgRelationFactory.getLocalInstance((Context)ctx).getEmpPosOrgRelationCollection(view);
        return collection;
    }
}

