/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.probation.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.emp.probation.PersonProbationTrainPlanCollection;
import com.kingdee.eas.hr.emp.probation.PersonProbationTrainPlanFactory;
import com.kingdee.eas.hr.emp.probation.PersonProbationTrainPlanInfo;
import com.kingdee.eas.hr.emp.probation.ProbationSetInfo;
import com.kingdee.eas.hr.emp.probation.app.AbstractTrainPlanGenerateActivityFacadeControllerBean;
import com.kingdee.eas.hr.emp.probation.app.GenerateTrainResult;
import com.kingdee.eas.hr.emp.probation.app.ProbationTrainStateEnum;
import com.kingdee.eas.hr.emp.probation.util.ProbationAppraiseUtil;
import com.kingdee.eas.hr.emp.probation.util.ProbationTrainPlanUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import java.sql.Date;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrainPlanGenerateActivityFacadeControllerBean
extends AbstractTrainPlanGenerateActivityFacadeControllerBean {
    private static final Logger logger = LoggerFactory.getLogger(TrainPlanGenerateActivityFacadeControllerBean.class);

    @Override
    public void _generateActivityByAheadDays(Context ctx) throws BOSException, EASBizException {
        logger.error("TrainPlanGenerateActivityFacadeControllerBean start");
        ProbationSetInfo setInfo = ProbationTrainPlanUtil.getPeriodSetItem(ctx);
        boolean isAutoTrainPeriod = setInfo != null ? setInfo.isIsAutoTrainPeriod() : false;
        boolean isAutoProbationTrain = setInfo != null ? setInfo.isIsAutoProbationTrain() : false;
        int aheadDays = setInfo != null ? setInfo.getAheadDays() : 0;
        int enrollTrainDays = setInfo != null ? setInfo.getEnrollTrainDays() : 0;
        logger.error("TrainPlanGenerateActivityFacadeControllerBean isAutoTrainPeriod: " + isAutoTrainPeriod + ",isAutoProbationTrain" + isAutoProbationTrain);
        if (isAutoProbationTrain) {
            this.generateProbationTrain(ctx, enrollTrainDays);
        }
        if (isAutoTrainPeriod) {
            this.generateProbationActivity(ctx, aheadDays, isAutoTrainPeriod);
        }
    }

    public void generateProbationTrain(Context ctx, int enrollTrainDays) throws BOSException, EASBizException {
        String l = LocaleUtils.getShortCode((Context)ctx);
        StringBuilder probationSql = new StringBuilder();
        probationSql.append("SELECT distinct PERSON.FID personId,PERSON.FName_" + l + " personName, LABORRELA.FEnterDate enrollDate,EMPTYPE.fid empTypeId, LABORRELA.FCAREERID careerId FROM T_BD_PERSON PERSON ").append(" LEFT OUTER JOIN T_HR_EMPORGRELATION EMPORGRELATION ON ((EMPORGRELATION.FPersonID = PERSON.FID AND EMPORGRELATION.FIsSystem = 1) AND EMPORGRELATION.FAssignType = 1)").append(" LEFT OUTER JOIN T_HR_EMPHRORELATIONHIS EMPHRORELATIONHIS ON EMPHRORELATIONHIS.FEmpOrgRelationID = EMPORGRELATION.FID").append(" LEFT OUTER JOIN T_HR_EMPLABORRELATION LABORRELA ON (LABORRELA.FPersonID = EMPORGRELATION.FPERSONID AND LABORRELA.FIsSystem = 1)").append(" LEFT OUTER JOIN T_HR_BDEMPLOYEETYPE EMPTYPE ON EMPTYPE.FID = LABORRELA.FLABORRELATIONSTATEID ").append(" where EMPORGRELATION.FIsLatestInAday = 1 ").append(" AND EMPHRORELATIONHIS.FState = 1 ").append(" AND EMPORGRELATION.FLEFFDT = { ts '2199-12-31'}").append(" AND EMPTYPE.fid in (").append(this.getProbationInEmpTypeSql(ctx)).append(")");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)probationSql.toString());
        block5: while (true) {
            try {
                while (rowSet.next()) {
                    String personId = rowSet.getString("personId");
                    String personName = rowSet.getString("personName");
                    String careerId = rowSet.getString("careerId");
                    Date enrollDate = rowSet.getDate("enrollDate");
                    try {
                        boolean personPlanAlready;
                        if (logger.isInfoEnabled()) {
                            logger.info("Current person [" + personName + "] start train plan.");
                        }
                        if (personPlanAlready = ProbationTrainPlanUtil.checkPersonProbationTrainState(ctx, personId, careerId)) {
                            if (!logger.isInfoEnabled()) continue block5;
                            logger.info("Current person [" + personName + "] have person train plan.");
                            continue block5;
                        }
                        java.util.Date nowDate = new java.util.Date();
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTime(enrollDate);
                        calendar.add(5, enrollTrainDays);
                        java.util.Date futureDate = calendar.getTime();
                        if (futureDate.before(nowDate)) {
                            String trainPlanIds = PersonProbationTrainPlanFactory.getLocalInstance(ctx).createTrainPlan(personId);
                            ProbationTrainPlanUtil.recordGenerateTrainLog(ctx, personId, trainPlanIds, true, GenerateTrainResult.SUCCESS, null);
                            continue block5;
                        }
                        if (!logger.isInfoEnabled()) continue block5;
                        logger.info("Current person [" + personName + "] do not need generate train period at + " + nowDate);
                        continue block5;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        String msg = e.getMessage();
                        ProbationTrainPlanUtil.recordGenerateTrainLog(ctx, personId, null, true, GenerateTrainResult.FAILED, msg);
                    }
                }
                break;
            }
            catch (EASBizException e) {
                e.printStackTrace();
                logger.error("Record generate tain plan failed");
                break;
            }
            catch (SQLException e) {
                e.printStackTrace();
                logger.error("Record generate tain plan sql failed");
                break;
            }
        }
    }

    public void generateProbationActivity(Context ctx, int aheadDays, boolean isAutoTrainPeriod) throws BOSException, EASBizException {
        String oql = " where planState = '" + ProbationTrainStateEnum.PLANSTATE_UNSTART.getAlias() + "'";
        PersonProbationTrainPlanCollection coll = PersonProbationTrainPlanFactory.getLocalInstance(ctx).getPersonProbationTrainPlanCollection(oql);
        if (coll.size() == 0) {
            return;
        }
        for (int i = 0; i < coll.size(); ++i) {
            PersonProbationTrainPlanInfo trainPlanInfo = coll.get(i);
            ProbationTrainPlanUtil.generateActivity(ctx, trainPlanInfo, aheadDays, isAutoTrainPeriod);
        }
    }

    public String getProbationInEmpTypeSql(Context ctx) throws EASBizException, BOSException {
        Set<String> inEmpTypeSet = ProbationAppraiseUtil.getHrBizDefineInEmpTypeSet(ctx, "com.kingdee.eas.hr.affair.app.EmpHireBizBill.form");
        String empTypeIdStr = ProbationTrainPlanUtil.convertSetToString(inEmpTypeSet);
        return empTypeIdStr;
    }
}

