/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.org.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.hr.org.AdminOrgUnitVerFactory;
import com.kingdee.eas.hr.org.AdminOrgUnitVerInfo;
import com.kingdee.eas.hr.org.HROrgAdjSchmInfo;
import com.kingdee.eas.hr.org.client.AbstractHROrgVerSortSettingUI;
import com.kingdee.eas.hr.org.util.SortCodeInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class HROrgVerSortSettingUI
extends AbstractHROrgVerSortSettingUI {
    private static final long serialVersionUID = 7705935313880002976L;
    private static final Logger logger = CoreUIObject.getLogger(HROrgVerSortSettingUI.class);
    boolean isModify = false;
    String orgAdjSchm = null;
    private String strResource = "com.kingdee.eas.basedata.org.client.OUResource";
    boolean isUpdate = false;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initTblSort();
        this.initBtnStatus();
    }

    private void initTblSort() throws Exception {
        AdminOrgUnitVerInfo adminInfo = (AdminOrgUnitVerInfo)this.getUIContext().get("Current_SelectNode");
        HROrgAdjSchmInfo hrOrgAdjSchm = (HROrgAdjSchmInfo)this.getUIContext().get("Current_OrgAdjSchm");
        if (adminInfo != null && hrOrgAdjSchm != null) {
            String longNumber = adminInfo.getLongNumber();
            String treeId = adminInfo.getId().toString();
            this.orgAdjSchm = hrOrgAdjSchm.getId().toString();
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("Current_SelectNode", treeId);
            paramMap.put("Current_OrgAdjSchm", this.orgAdjSchm);
            paramMap.put("longnumber", longNumber);
            List valList = AdminOrgUnitVerFactory.getRemoteInstance().getSubNodes(paramMap);
            if (valList.size() > 0) {
                this.tblSort.checkParsed();
                this.tblSort.getSelectManager().setSelectMode(2);
                Map valMap = null;
                IRow row = null;
                for (int i = 0; i < valList.size(); ++i) {
                    valMap = (Map)valList.get(i);
                    row = this.tblSort.addRow();
                    row.getCell("id").setValue(valMap.get("id"));
                    row.getCell("sortCode").setValue(valMap.get("sortCode"));
                    row.getCell("longNumber").setValue(valMap.get("longNumber"));
                    row.getCell("index").setValue((Object)new Integer(i));
                    row.getCell("name").setValue(valMap.get("name"));
                }
            }
        }
        if (this.tblSort.getRowCount() > 0) {
            this.tblSort.getSelectManager().select(0, 0);
        }
    }

    private void initBtnStatus() {
        this.handTableEvent();
    }

    @Override
    protected void tblSort_tableClicked(KDTMouseEvent e) throws Exception {
        this.handTableEvent();
    }

    @Override
    protected void tblSort_tableSelectChanged(KDTSelectEvent e) throws Exception {
        this.handTableEvent();
    }

    private void handTableEvent() {
        int rowNum = this.tblSort.getRowCount();
        KDTSelectBlock block = this.tblSort.getSelectManager().get();
        if (rowNum != 0 && block != null) {
            int rowIndex = block.getBeginRow();
            if (rowIndex == 0 && rowNum == 1) {
                this.btnTop.setEnabled(false);
                this.btnUp.setEnabled(false);
                this.btnDown.setEnabled(false);
                this.btnBottom.setEnabled(false);
            } else if (rowIndex == 0) {
                this.btnTop.setEnabled(false);
                this.btnUp.setEnabled(false);
                this.btnDown.setEnabled(true);
                this.btnBottom.setEnabled(true);
            } else if (rowIndex == rowNum - 1) {
                this.btnTop.setEnabled(true);
                this.btnUp.setEnabled(true);
                this.btnDown.setEnabled(false);
                this.btnBottom.setEnabled(false);
            } else {
                this.btnTop.setEnabled(true);
                this.btnUp.setEnabled(true);
                this.btnDown.setEnabled(true);
                this.btnBottom.setEnabled(true);
            }
        } else {
            this.btnTop.setEnabled(false);
            this.btnUp.setEnabled(false);
            this.btnDown.setEnabled(false);
            this.btnBottom.setEnabled(false);
        }
    }

    @Override
    public void actionTop_actionPerformed(ActionEvent e) throws Exception {
        KDTSelectBlock block = this.tblSort.getSelectManager().get();
        if (block != null) {
            int rowIndex = block.getBeginRow();
            IRow topRow = this.tblSort.getRow(rowIndex);
            this.tblSort.removeRow(rowIndex);
            this.tblSort.addRow(0, topRow);
            this.tblSort.getSelectManager().select(0, 0);
            this.handTableEvent();
            this.isModify = true;
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.strResource, (String)"PLEASE_SELECT_ROW"));
        }
    }

    @Override
    public void actionUp_actionPerformed(ActionEvent e) throws Exception {
        KDTSelectBlock block = this.tblSort.getSelectManager().get();
        if (block != null) {
            int rowIndex = block.getBeginRow();
            IRow upRow = this.tblSort.getRow(rowIndex);
            this.tblSort.removeRow(rowIndex);
            this.tblSort.addRow(rowIndex - 1, upRow);
            this.tblSort.getSelectManager().select(rowIndex - 1, 0);
            this.handTableEvent();
            this.isModify = true;
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.strResource, (String)"PLEASE_SELECT_ROW"));
        }
    }

    @Override
    public void actionDown_actionPerformed(ActionEvent e) throws Exception {
        KDTSelectBlock block = this.tblSort.getSelectManager().get();
        if (block != null) {
            int rowIndex = block.getBeginRow();
            IRow downRow = this.tblSort.getRow(rowIndex);
            this.tblSort.removeRow(rowIndex);
            this.tblSort.addRow(rowIndex + 1, downRow);
            this.tblSort.getSelectManager().select(rowIndex + 1, 0);
            this.handTableEvent();
            this.isModify = true;
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.strResource, (String)"PLEASE_SELECT_ROW"));
        }
    }

    @Override
    public void actionBottom_actionPerformed(ActionEvent e) throws Exception {
        KDTSelectBlock block = this.tblSort.getSelectManager().get();
        if (block != null) {
            int rowIndex = block.getBeginRow();
            IRow bottomRow = this.tblSort.getRow(rowIndex);
            int rowCount = this.tblSort.getRowCount();
            this.tblSort.removeRow(rowIndex);
            this.tblSort.addRow(rowCount - 1, bottomRow);
            this.tblSort.getSelectManager().select(rowCount - 1, 0);
            this.handTableEvent();
            this.isModify = true;
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.strResource, (String)"PLEASE_SELECT_ROW"));
        }
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblSort.getRowCount() == 0) {
            this.getUIWindow().close();
            return;
        }
        ArrayList<SortCodeInfo> sortCodeInfoList = new ArrayList<SortCodeInfo>();
        IRow row = null;
        SortCodeInfo sortInfo = new SortCodeInfo();
        String newSortCode = null;
        if (this.isModify) {
            for (int i = 0; i < this.tblSort.getRowCount(); ++i) {
                sortInfo = new SortCodeInfo();
                row = this.tblSort.getRow(i);
                String id = row.getCell("id").getValue().toString();
                String sortCode = row.getCell("sortCode").getValue().toString();
                String longNumber = row.getCell("longNumber").getValue().toString();
                sortInfo.setOldSortCode(sortCode);
                newSortCode = sortCode.substring(0, sortCode.lastIndexOf(33)) + "!" + this.getSortCodeSuffix(i + 1);
                sortInfo.setNewSortCode(newSortCode);
                sortInfo.setId(id);
                sortInfo.setLongNumber(longNumber);
                sortInfo.setOrgAdjSchm(this.orgAdjSchm);
                sortCodeInfoList.add(sortInfo);
            }
            if (sortCodeInfoList.size() > 0) {
                AdminOrgUnitVerFactory.getRemoteInstance().updateSortCode(sortCodeInfoList, true, null);
                this.isUpdate = true;
            }
        }
        this.getUIWindow().close();
    }

    private String getSortCodeSuffix(int index) {
        StringBuffer sortCodeSuffix = new StringBuffer();
        int digit = new Integer(index).toString().length();
        int zeroNum = 6 - digit;
        for (int i = 0; i < zeroNum; ++i) {
            sortCodeSuffix.append("0");
        }
        sortCodeSuffix.append(index);
        return sortCodeSuffix.toString();
    }
}

