/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.org.client;

import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.JobInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.hr.base.util.HRResourceUtils;
import com.kingdee.eas.hr.org.IPersonPlan;
import com.kingdee.eas.hr.org.Period;
import com.kingdee.eas.hr.org.PersonPlanAdjustException;
import com.kingdee.eas.hr.org.PersonPlanCollection;
import com.kingdee.eas.hr.org.PersonPlanException;
import com.kingdee.eas.hr.org.PersonPlanFactory;
import com.kingdee.eas.hr.org.PersonPlanInfo;
import com.kingdee.eas.hr.org.PersonPlanSchemeInfo;
import com.kingdee.eas.hr.org.PersonPlanType;
import com.kingdee.eas.hr.org.client.AbstractImportDataPersonPlanUI;
import com.kingdee.eas.tools.datatask.FilesPathInfo;
import com.kingdee.eas.tools.datatask.client.FileSelector;
import com.kingdee.eas.tools.datatask.runtime.ExcelUtil;
import com.kingdee.eas.tools.datatask.runtime.ExternalExcelDataReader;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.VerticalAlignment;

public class ImportDataPersonPlanUI
extends AbstractImportDataPersonPlanUI {
    private static final Logger logger = CoreUIObject.getLogger(ImportDataPersonPlanUI.class);
    private static final String RES = "com.kingdee.eas.hr.org.ImportDataPersonPlanResource";
    private String resClass = "com.kingdee.eas.hr.org.client.PersonPlanResource.";
    private HSSFWorkbook wb = new HSSFWorkbook();
    private PersonPlanSchemeInfo schemeInfo;
    private AdminOrgUnitCollection adminCol;
    private Period period = null;
    private PersonPlanType ppType = null;
    private int nextYearPoint = 0;
    private List lstHeadRow;
    private List lstPersonPlanItem;
    private int startYear = 0;
    private int endYear = 0;
    private int startMonth = 0;
    private int endMonth = 0;
    private int colmnLength = 0;
    private IRowSet rows = null;
    private int sheetNum;
    private HSSFSheet sheet = null;
    private HSSFRow headRow = null;
    private HSSFCellStyle titleStyle = null;
    private HSSFCellStyle cellStyle = null;
    private int rowNum = 0;
    private final String positionStr = EASResource.getString((String)(this.resClass + "POSITION_NAME"));
    private final String jobStr = EASResource.getString((String)(this.resClass + "JOB_NAME"));
    private final String firstHalfYearStr = EASResource.getString((String)(this.resClass + "FIRST_HALFYEAR"));
    private final String secondHalfYearStr = EASResource.getString((String)(this.resClass + "SECOND_HALF_YEAR"));
    private final String yearStr = EASResource.getString((String)(this.resClass + "YEAR"));
    private final String monthStr = EASResource.getString((String)(this.resClass + "MONTH"));
    private final String quarterStr = EASResource.getString((String)(this.resClass + "QUARTER"));
    private final String sumStr = EASResource.getString((String)(this.resClass + "SUM"));
    private boolean isSumOverFlow = false;
    String path = "";

    public void actionOpen_actionPerformed(ActionEvent arg0) throws Exception {
        super.actionOpen_actionPerformed(arg0);
        String filePath = this.txtFile.getText();
        if (filePath == null || filePath.trim().length() <= 0) {
            MsgBox.showWarning((String)EASResource.getString((String)RES, (String)"please_select_file"));
            return;
        }
        String str = filePath.substring(filePath.lastIndexOf("."));
        if (".xls".equals(str)) {
            this.initSheet();
        } else {
            MsgBox.showWarning((String)EASResource.getString((String)RES, (String)"template_error"));
            SysUtil.abort();
        }
    }

    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        HSSFRow row;
        int endMonthCount;
        int startMonthCount;
        String filePath = this.txtFile.getText();
        if (filePath == null || filePath.trim().length() <= 0) {
            MsgBox.showWarning((String)EASResource.getString((String)RES, (String)"please_select_file"));
            return;
        }
        if (this.wb == null) {
            return;
        }
        this.sheetNum = this.comboLabel.getSelectedIndex();
        HSSFSheet sheet = this.wb.getSheetAt(this.sheetNum);
        int rowNum = sheet.getPhysicalNumberOfRows();
        if (rowNum < 1) {
            MsgBox.showWarning((String)EASResource.getString((String)RES, (String)"template_file_is_null"));
            SysUtil.abort();
        }
        if (!this.checkFileItem()) {
            MsgBox.showWarning((String)EASResource.getString((String)RES, (String)"template_error"));
            SysUtil.abort();
        }
        if (!this.checkFileData()) {
            MsgBox.showWarning((String)EASResource.getString((String)RES, (String)"data_error"));
            SysUtil.abort();
        }
        if (this.isSumOverFlow) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.hr.org.ORGAutoGenerateResource", (String)"43_PersonPlanMainListUI"));
            SysUtil.abort();
        }
        if (this.period == Period.HALF_YEAR) {
            startMonthCount = 0;
            endMonthCount = 0;
            startMonthCount = this.startMonth == 0 ? this.startYear * 2 + 1 : this.startYear * 2 + 2;
            endMonthCount = this.endMonth == 0 ? this.endYear * 2 + 1 : this.endYear * 2 + 2;
            this.colmnLength = endMonthCount - startMonthCount + 1;
        } else if (this.period == Period.MONTH) {
            startMonthCount = this.startYear * 12 + this.startMonth + 1;
            endMonthCount = this.endYear * 12 + this.endMonth + 1;
            this.colmnLength = endMonthCount - startMonthCount + 1;
        } else if (this.period == Period.QUARTER) {
            startMonthCount = 0;
            endMonthCount = 0;
            startMonthCount = this.startMonth == 0 ? this.startYear * 4 + 1 : (this.startMonth == 1 ? this.startYear * 4 + 2 : (this.startMonth == 2 ? this.startYear * 4 + 3 : this.startYear * 4 + 4));
            endMonthCount = this.endMonth == 0 ? this.endYear * 4 + 1 : (this.endMonth == 1 ? this.endYear * 4 + 2 : (this.endMonth == 2 ? this.endYear * 4 + 3 : this.endYear * 4 + 4));
            this.colmnLength = endMonthCount - startMonthCount + 1;
        } else if (this.period == Period.YEAR) {
            this.colmnLength = this.endYear - this.startYear + 1;
        }
        boolean isOver = this.chkUpdate.isSelected();
        sheet = this.wb.getSheetAt(this.sheetNum);
        int rowCount = sheet.getPhysicalNumberOfRows();
        int count = 0;
        IPersonPlan iPPlan = PersonPlanFactory.getRemoteInstance();
        PersonPlanCollection ppColl = new PersonPlanCollection();
        for (int r = 1; r < rowCount && (row = sheet.getRow(r)) != null; ++r) {
            if (this.ppType == PersonPlanType.POSITION && StringUtils.isEmpty((String)row.getCell(3).getStringCellValue())) continue;
            PersonPlanInfo ppInfo = new PersonPlanInfo();
            String adminNumber = ExcelUtil.getCellValue((HSSFCell)row.getCell(0));
            if (adminNumber == null || "".equals(adminNumber)) break;
            AdminOrgUnitInfo adminInfo = new AdminOrgUnitInfo();
            adminInfo.setNumber(adminNumber);
            ppInfo.setAdminOrg(adminInfo);
            ppInfo.setType(this.ppType);
            ppInfo.setPeriod(this.period);
            ppInfo.setScheme(this.schemeInfo);
            String cellValue = null;
            int tempYear = this.startYear;
            PositionInfo positionInfo = null;
            if (this.ppType == PersonPlanType.POSITION) {
                positionInfo = new PositionInfo();
                positionInfo.setNumber(ExcelUtil.getCellValue((HSSFCell)row.getCell(3)));
                ppInfo.setPosition(positionInfo);
                count = 5;
            } else if (this.ppType == PersonPlanType.JOB) {
                JobInfo jobInfo = new JobInfo();
                jobInfo.setNumber(ExcelUtil.getCellValue((HSSFCell)row.getCell(3)));
                ppInfo.setJob(jobInfo);
                count = 5;
            } else {
                ppInfo.setAdminOrg(adminInfo);
                count = 3;
            }
            tempYear = this.startYear;
            int j = this.startMonth;
            for (int i = 1; i < this.colmnLength + 1; ++i) {
                cellValue = ExcelUtil.getCellValue((HSSFCell)row.getCell((int)((short)(i + count - 1))));
                if ("--".equals(cellValue)) continue;
                try {
                    int number = Integer.parseInt(cellValue);
                    this.setPlanData(ppInfo, j + 1, number);
                    if (j == this.nextYearPoint) {
                        j = 0;
                        if (i + 1 >= this.colmnLength + 1) continue;
                        PersonPlanInfo ppInfoReal = (PersonPlanInfo)ppInfo.clone();
                        ppInfoReal.setYear(tempYear);
                        ppColl.add(ppInfoReal);
                        ++tempYear;
                        continue;
                    }
                    ++j;
                    continue;
                }
                catch (Exception es) {
                    throw new PersonPlanAdjustException(PersonPlanAdjustException.NUMBERTOOLONG, new Object[]{cellValue});
                }
            }
            PersonPlanInfo ppInfoReal = (PersonPlanInfo)ppInfo.clone();
            ppInfoReal.setYear(tempYear);
            ppColl.add(ppInfoReal);
        }
        iPPlan.addPersonPlanCollForImport(ppColl, isOver);
        String res = EASResource.getString((String)"com.kingdee.eas.hr.org.ORGAutoGenerateResource", (String)"Msg_Save_OK_New");
        MsgBox.showInfo((String)res);
        this.getUIWindow().close();
    }

    @Override
    public void actionRefreshSheet_actionPerformed(ActionEvent e) throws Exception {
        this.initSheet();
    }

    private void setPlanData(PersonPlanInfo ppInfo, int month, int count) {
        if (count >= 0) {
            if (this.period == Period.QUARTER) {
                this.nextYearPoint = 3;
                if (month == 1) {
                    ppInfo.setPlan1(count);
                    ppInfo.setPlan2(count);
                    ppInfo.setPlan3(count);
                } else if (month == 2) {
                    ppInfo.setPlan4(count);
                    ppInfo.setPlan5(count);
                    ppInfo.setPlan6(count);
                } else if (month == 3) {
                    ppInfo.setPlan7(count);
                    ppInfo.setPlan8(count);
                    ppInfo.setPlan9(count);
                } else if (month == 4) {
                    ppInfo.setPlan10(count);
                    ppInfo.setPlan11(count);
                    ppInfo.setPlan12(count);
                }
            } else if (this.period == Period.HALF_YEAR) {
                this.nextYearPoint = 1;
                if (month == 1) {
                    ppInfo.setPlan1(count);
                    ppInfo.setPlan2(count);
                    ppInfo.setPlan3(count);
                    ppInfo.setPlan4(count);
                    ppInfo.setPlan5(count);
                    ppInfo.setPlan6(count);
                } else {
                    ppInfo.setPlan7(count);
                    ppInfo.setPlan8(count);
                    ppInfo.setPlan9(count);
                    ppInfo.setPlan10(count);
                    ppInfo.setPlan11(count);
                    ppInfo.setPlan12(count);
                }
            } else if (this.period == Period.YEAR) {
                this.nextYearPoint = 0;
                ppInfo.setPlan1(count);
                ppInfo.setPlan2(count);
                ppInfo.setPlan3(count);
                ppInfo.setPlan4(count);
                ppInfo.setPlan5(count);
                ppInfo.setPlan6(count);
                ppInfo.setPlan7(count);
                ppInfo.setPlan8(count);
                ppInfo.setPlan9(count);
                ppInfo.setPlan10(count);
                ppInfo.setPlan11(count);
                ppInfo.setPlan12(count);
            } else {
                this.nextYearPoint = 11;
                if (month == 1) {
                    ppInfo.setPlan1(count);
                } else if (month == 2) {
                    ppInfo.setPlan2(count);
                } else if (month == 3) {
                    ppInfo.setPlan3(count);
                } else if (month == 4) {
                    ppInfo.setPlan4(count);
                } else if (month == 5) {
                    ppInfo.setPlan5(count);
                } else if (month == 6) {
                    ppInfo.setPlan6(count);
                } else if (month == 7) {
                    ppInfo.setPlan7(count);
                } else if (month == 8) {
                    ppInfo.setPlan8(count);
                } else if (month == 9) {
                    ppInfo.setPlan9(count);
                } else if (month == 10) {
                    ppInfo.setPlan10(count);
                } else if (month == 11) {
                    ppInfo.setPlan11(count);
                } else if (month == 12) {
                    ppInfo.setPlan12(count);
                }
            }
        } else if (this.period == Period.QUARTER) {
            if (month == 1) {
                ppInfo.put("plan1", null);
                ppInfo.put("plan2", null);
                ppInfo.put("plan3", null);
            } else if (month == 2) {
                ppInfo.put("plan4", null);
                ppInfo.put("plan5", null);
                ppInfo.put("plan6", null);
            } else if (month == 3) {
                ppInfo.put("plan7", null);
                ppInfo.put("plan8", null);
                ppInfo.put("plan9", null);
            } else if (month == 4) {
                ppInfo.put("plan10", null);
                ppInfo.put("plan11", null);
                ppInfo.put("plan12", null);
            }
        } else if (this.period == Period.HALF_YEAR) {
            if (month == 1) {
                ppInfo.put("plan1", null);
                ppInfo.put("plan2", null);
                ppInfo.put("plan3", null);
                ppInfo.put("plan4", null);
                ppInfo.put("plan5", null);
                ppInfo.put("plan6", null);
            } else {
                ppInfo.put("plan7", null);
                ppInfo.put("plan8", null);
                ppInfo.put("plan9", null);
                ppInfo.put("plan10", null);
                ppInfo.put("plan11", null);
                ppInfo.put("plan12", null);
            }
        } else if (this.period == Period.YEAR) {
            ppInfo.put("plan1", null);
            ppInfo.put("plan2", null);
            ppInfo.put("plan3", null);
            ppInfo.put("plan4", null);
            ppInfo.put("plan5", null);
            ppInfo.put("plan6", null);
            ppInfo.put("plan7", null);
            ppInfo.put("plan8", null);
            ppInfo.put("plan9", null);
            ppInfo.put("plan10", null);
            ppInfo.put("plan11", null);
            ppInfo.put("plan12", null);
        } else if (month == 1) {
            ppInfo.put("plan1", null);
        } else if (month == 2) {
            ppInfo.put("plan2", null);
        } else if (month == 3) {
            ppInfo.put("plan3", null);
        } else if (month == 4) {
            ppInfo.put("plan4", null);
        } else if (month == 5) {
            ppInfo.put("plan5", null);
        } else if (month == 6) {
            ppInfo.put("plan6", null);
        } else if (month == 7) {
            ppInfo.put("plan7", null);
        } else if (month == 8) {
            ppInfo.put("plan8", null);
        } else if (month == 9) {
            ppInfo.put("plan9", null);
        } else if (month == 10) {
            ppInfo.put("plan10", null);
        } else if (month == 11) {
            ppInfo.put("plan11", null);
        } else if (month == 12) {
            ppInfo.put("plan12", null);
        }
    }

    private void initSheet() throws Exception {
        this.comboLabel.removeAllItems();
        FilesPathInfo paths = (FilesPathInfo)this.txtFile.getUserObject();
        if (paths == null || paths.getFilePath() == null || paths.getFilePath().length <= 0) {
            return;
        }
        this.path = paths.getFilePath()[0];
        ExternalExcelDataReader reader = new ExternalExcelDataReader();
        ArrayList sheetNames = null;
        sheetNames = reader.getSheetNameCollection(this.path);
        KDComboBox comSheetNames = new KDComboBox();
        if (sheetNames != null) {
            int sheetCount = sheetNames.size();
            for (int i = 0; i < sheetCount; ++i) {
                comSheetNames.addItem(sheetNames.get(i));
                this.comboLabel.addItem(sheetNames.get(i));
            }
        }
        POIFSFileSystem pfs = new POIFSFileSystem((InputStream)new FileInputStream(this.path));
        this.wb = new HSSFWorkbook(pfs);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void btnExportTemplate_actionPerformed(ActionEvent e) throws Exception {
        FileSelector fselector = new FileSelector((Component)((Object)this), "SAVE");
        fselector.setDefFileName(EASResource.getString((String)RES, (String)"date_end_input") + ".xls");
        fselector.show();
        if (fselector.isCanceled()) {
            return;
        }
        String expFilePath = fselector.getData().toString();
        try (FileOutputStream out = null;){
            out = new FileOutputStream(expFilePath);
            HashMap map = this.createTable();
            this.nextYearPoint = map.get("nextYearPoint") != null ? (Integer)map.get("nextYearPoint") : this.nextYearPoint;
            byte[] data = (byte[])map.get("data");
            out.write(data);
            out.flush();
        }
        MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"export_template_success"));
    }

    private HashMap createTable() throws Exception {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("period", (Object)this.period);
        paramMap.put("startYear", this.startYear);
        paramMap.put("startMonth", this.startMonth);
        paramMap.put("endYear", this.endYear);
        paramMap.put("endMonth", this.endMonth);
        paramMap.put("ppType", (Object)this.ppType);
        paramMap.put("positionStr", this.positionStr);
        paramMap.put("jobStr", this.jobStr);
        paramMap.put("yearStr", this.yearStr);
        paramMap.put("monthStr", this.monthStr);
        paramMap.put("rows", this.rows);
        paramMap.put("schemeInfo", this.schemeInfo);
        paramMap.put("nextYearPoint", this.nextYearPoint);
        paramMap.put("quarterStr", this.quarterStr);
        paramMap.put("firstHalfYearStr", this.firstHalfYearStr);
        paramMap.put("secondHalfYearStr", this.secondHalfYearStr);
        if (this.getUIContext().get("isShowVirtualOrg") != null) {
            paramMap.put("isShowVirtualOrg", (Boolean)this.getUIContext().get("isShowVirtualOrg"));
        }
        HashMap mapValue = PersonPlanFactory.getRemoteInstance().importTemplate(paramMap);
        return mapValue;
    }

    private HSSFCellStyle createTitleCellStyle(HSSFWorkbook workbook) {
        HSSFCellStyle titleStyle = workbook.createCellStyle();
        titleStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        titleStyle.setFillForegroundColor(IndexedColors.LEMON_CHIFFON.index);
        titleStyle.setAlignment(HorizontalAlignment.CENTER);
        titleStyle.setHidden(false);
        titleStyle.setLocked(false);
        titleStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        HSSFFont defaultFont = workbook.createFont();
        defaultFont.setFontName(EASResource.getString((String)"com.kingdee.eas.hr.org.ORGAutoGenerateResource", (String)"12_PersonPlanControllerBean"));
        defaultFont.setColor(IndexedColors.GREEN.index);
        short size = 13;
        defaultFont.setFontHeight(size);
        defaultFont.setFontHeightInPoints(size);
        titleStyle.setFont(defaultFont);
        titleStyle.setDataFormat(HSSFDataFormat.getBuiltinFormat((String)"@"));
        return titleStyle;
    }

    private HSSFCellStyle createValueCellStyle(HSSFWorkbook workbook) {
        HSSFCellStyle valueStyle = workbook.createCellStyle();
        valueStyle.setAlignment(HorizontalAlignment.LEFT);
        valueStyle.setHidden(true);
        BorderStyle borderstyle = BorderStyle.DOTTED;
        valueStyle.setBorderLeft(borderstyle);
        valueStyle.setBorderRight(borderstyle);
        valueStyle.setBorderTop(borderstyle);
        valueStyle.setBorderBottom(borderstyle);
        short backColorIndex = IndexedColors.BLACK.index;
        valueStyle.setBottomBorderColor(backColorIndex);
        valueStyle.setTopBorderColor(backColorIndex);
        valueStyle.setLeftBorderColor(backColorIndex);
        valueStyle.setRightBorderColor(backColorIndex);
        valueStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        HSSFFont defaultFont = workbook.createFont();
        defaultFont.setFontName(EASResource.getString((String)"com.kingdee.eas.hr.org.ORGAutoGenerateResource", (String)"12_PersonPlanControllerBean"));
        defaultFont.setColor(IndexedColors.BLACK.index);
        short size = 12;
        defaultFont.setFontHeightInPoints(size);
        valueStyle.setFont(defaultFont);
        valueStyle.setDataFormat(HSSFDataFormat.getBuiltinFormat((String)"@"));
        return valueStyle;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.repaint();
        this.btnRefreshSheet.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnRefreshSheet.setVisible(true);
        this.btnRefreshSheet.setEnabled(true);
        this.txtFile.setEditable(false);
        this.lstPersonPlanItem = (List)this.getUIContext().get("lstPersonPlanItem");
        this.schemeInfo = (PersonPlanSchemeInfo)this.getUIContext().get("schemeInfo");
        this.startYear = this.schemeInfo.getStartYear();
        this.endYear = this.schemeInfo.getEndYear();
        this.startMonth = this.schemeInfo.getStartMonth();
        this.endMonth = this.schemeInfo.getEndMonth();
        this.period = this.schemeInfo.getPeriod();
        this.ppType = this.schemeInfo.getPlanType();
    }

    private boolean checkFileData() throws Exception {
        if (this.sheetNum < 0) {
            return false;
        }
        if (this.wb == null) {
            this.initSheet();
        }
        this.sheet = this.wb.getSheetAt(this.sheetNum);
        int rowCount = this.sheet.getPhysicalNumberOfRows();
        int count = 0;
        count = this.ppType == PersonPlanType.PERSON ? 3 : 5;
        boolean PersonPlanDataError = true;
        int sum = 0;
        for (int i = 1; i < rowCount; ++i) {
            HSSFRow row = this.sheet.getRow(i);
            if (row == null || row.getCell(2) == null || this.ppType == PersonPlanType.POSITION && StringUtils.isEmpty((String)row.getCell(2).getStringCellValue())) continue;
            int k = this.lstPersonPlanItem.size() + count - 1;
            for (int j = count; j < k && row != null; ++j) {
                HSSFCell fCell = row.getCell((int)((short)j));
                String cellData = ExcelUtil.getCellValue((HSSFCell)fCell);
                if (fCell != null && !"".equals(cellData.trim())) {
                    if ("--".equals(cellData)) continue;
                    Pattern pattern = Pattern.compile("[0-9]*");
                    if (!pattern.matcher(cellData).matches()) {
                        PersonPlanDataError = false;
                    } else {
                        sum += Integer.parseInt(cellData);
                    }
                    if (sum >= 0) continue;
                    this.isSumOverFlow = true;
                    continue;
                }
                PersonPlanDataError = false;
            }
        }
        return PersonPlanDataError;
    }

    private boolean checkFileItem() throws PersonPlanException {
        if (this.sheetNum < 0) {
            return false;
        }
        if (this.wb == null) {
            try {
                this.initSheet();
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        if (this.wb == null) {
            return false;
        }
        this.sheet = this.wb.getSheetAt(this.sheetNum);
        int rowCount = this.sheet.getPhysicalNumberOfRows();
        if (rowCount < 1) {
            return false;
        }
        HSSFRow row = this.sheet.getRow(0);
        if (row == null) {
            MsgBox.showWarning((String)EASResource.getString((String)RES, (String)"template_error"));
            this.txtFile.setText("");
            this.comboLabel.removeAllItems();
            SysUtil.abort();
        }
        int count = 0;
        count = this.ppType == PersonPlanType.PERSON ? 3 : 5;
        HSSFRow headRow = this.sheet.getRow(0);
        boolean PersonPlanItemError = true;
        try {
            for (int i = count; i < this.lstPersonPlanItem.size() + count; ++i) {
                String value;
                HSSFCell fCell = headRow.getCell((int)((short)(i - 1)));
                if (fCell.getCellType() != CellType.STRING) {
                    Date date = fCell.getDateCellValue();
                    int year = date.getYear() + 1900;
                    int month = date.getMonth() + 1;
                    value = HRResourceUtils.getMessage((String)"com.kingdee.eas.hr.org.ORGAutoGenerateResource", (String)"85_ImportDataPersonPlanUI", (String[])new String[]{String.valueOf(year), String.valueOf(month)});
                } else {
                    value = ExcelUtil.getCellValue((HSSFCell)fCell);
                }
                if (value != null && this.lstPersonPlanItem.get(i - count).equals(value.trim())) continue;
                PersonPlanItemError = false;
            }
        }
        catch (Exception ex) {
            throw new PersonPlanException(PersonPlanException.TEMPLATE_ERROR);
        }
        return PersonPlanItemError;
    }
}

