/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.org.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.hr.base.HRInitFactory;
import com.kingdee.eas.hr.base.IHRInit;
import com.kingdee.eas.hr.org.JobException;
import com.kingdee.eas.hr.org.JobGradeFactory;
import com.kingdee.eas.hr.org.JobGradeInfo;
import com.kingdee.eas.hr.org.client.AbstractJobGradeMainListUI;
import com.kingdee.eas.hr.org.client.JobGradeBatchAddUI;
import com.kingdee.eas.hr.org.client.JobGradeEditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.Map;
import org.apache.log4j.Logger;

public class JobGradeMainListUI
extends AbstractJobGradeMainListUI {
    private static Logger logger = Logger.getLogger(JobGradeMainListUI.class);
    int groupModel = 0;

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnBatchAdd.setIcon(EASResource.getIcon((String)"imgTbtn_BatchAdd"));
        this.btnLocate.setVisible(false);
        if (this.groupModel == 0 && !SysContext.getSysContext().getCurrentCtrlUnit().getId().toString().equals("00000000-0000-0000-0000-000000000000CCE7AED4")) {
            this.btnAddNew.setVisible(false);
            this.btnEdit.setVisible(false);
            this.btnRemove.setVisible(false);
            this.btnBatchAdd.setVisible(false);
            this.menuItemAddNew.setEnabled(false);
            this.menuItemEdit.setEnabled(false);
            this.menuItemRemove.setEnabled(false);
            this.menuItemBatchAdd.setEnabled(false);
            this.actionAddNew.setEnabled(false);
            this.actionEdit.setEnabled(false);
            this.actionRemove.setEnabled(false);
            this.actionBatchAdd.setEnabled(false);
        }
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.PEOPLE_ORGANIZATION;
    }

    public void onLoad() throws Exception {
        IHRInit iHR = HRInitFactory.getRemoteInstance();
        this.groupModel = iHR.getJobSystemScheme();
        super.onLoad();
        this.btnQuery.setVisible(false);
        this.tblMain.setColumnMoveable(true);
    }

    protected String getEditUIName() {
        return JobGradeEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return JobGradeFactory.getRemoteInstance();
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        if (SysContext.getSysContext().getCurrentCtrlUnit() == null) {
            return filter;
        }
        if (this.groupModel == 0) {
            filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)"00000000-0000-0000-0000-000000000000CCE7AED4", CompareType.EQUALS));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString(), CompareType.EQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("JobSystem.id", (Object)"00000000-0000-0000-0000-0000000000017D16BC74"));
        filter.setMaskString("(#0 and #1)");
        return filter;
    }

    @Override
    public void actionBatchAdd_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"Owner", (Object)this);
        IUIFactory uiFactory = null;
        try {
            uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            IUIWindow curDialog = uiFactory.create(JobGradeBatchAddUI.class.getName(), (Map)uiContext);
            curDialog.show();
        }
        catch (UIException ex1) {
            this.handleException((Exception)((Object)ex1));
        }
        this.tblMain.removeRows();
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        int i;
        this.checkSelected();
        if (this.tblMain.getSelectManager().size() > 1) {
            throw new JobException(JobException.MUST_DEL_LAST_GRADE);
        }
        KDTSelectBlock sb = this.tblMain.getSelectManager().get();
        Object[] infos = new JobGradeInfo[sb.getBottom() - sb.getTop() + 1];
        for (int j = sb.getTop(); j <= sb.getBottom(); ++j) {
            infos[j - sb.getTop()] = new JobGradeInfo();
            infos[j - sb.getTop()].setId(BOSUuid.read((String)this.getColumnValue(j, this.getKeyFieldName())));
            infos[j - sb.getTop()].setGrade(Integer.parseInt(this.getColumnValue(j, "grade")));
        }
        Arrays.sort(infos);
        for (i = 0; i < infos.length - 1; ++i) {
            if (infos[i].getGrade() + 1 == infos[i + 1].getGrade()) continue;
            throw new JobException(JobException.MUST_DEL_LAST_GRADE);
        }
        if (this.confirmRemove()) {
            for (i = infos.length - 1; i >= 0; --i) {
                try {
                    this.getBizInterface().delete((IObjectPK)new ObjectUuidPK(infos[i].getId()));
                    this.refresh(e);
                    continue;
                }
                catch (ObjectNotFoundException onfe) {
                    logger.error((Object)onfe.getMessage());
                    this.refreshList();
                    throw new EASBizException(EASBizException.CHECKEXIST);
                }
            }
        }
    }

    protected String getColumnValue(int rowIndex, String columnName) {
        Object keyValue;
        IRow row = this.tblMain.getRow(rowIndex);
        if (row == null) {
            return null;
        }
        ICell cell = row.getCell(columnName);
        if (cell == null) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
            SysUtil.abort();
        }
        if ((keyValue = cell.getValue()) != null) {
            return keyValue.toString();
        }
        return null;
    }
}

