/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.org.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.OrgBlankException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.org.JobGradeCollection;
import com.kingdee.eas.hr.org.JobGradeFactory;
import com.kingdee.eas.hr.org.JobGradeModuleException;
import com.kingdee.eas.hr.org.JobGradeModuleFactory;
import com.kingdee.eas.hr.org.JobGradeModuleInfo;
import com.kingdee.eas.hr.org.client.AbstractJobGradeModuleEditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.UIManager;
import org.apache.log4j.Logger;

public class JobGradeModuleEditUI
extends AbstractJobGradeModuleEditUI {
    private static final Logger logger = CoreUIObject.getLogger(JobGradeModuleEditUI.class);
    private final Color editColor = UIManager.getColor("TextField.requiredBackground");

    public void onLoad() throws Exception {
        this.kdtJobGradeEntries.checkParsed();
        super.onLoad();
    }

    private boolean getEnableModID(String jobModID) {
        if (this.getUIContext().get(jobModID) != null) {
            return true;
        }
        boolean jobGradeStateEnable = this.getJobGradeModuleState(jobModID);
        return jobGradeStateEnable;
    }

    private void setbtnStateByData() {
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.btnEntryDel.setEnabled(true);
            this.btnRemove.setEnabled(false);
            this.btnEntryAdd.setEnabled(true);
            this.btnMovePre.setEnabled(true);
            this.btnMoveNext.setEnabled(true);
        } else if (OprtState.VIEW.equals(this.getOprtState())) {
            this.btnEntryDel.setEnabled(false);
            this.btnRemove.setEnabled(false);
            this.btnMovePre.setEnabled(false);
            this.btnMoveNext.setEnabled(false);
        } else if (this.getEnableModID(this.editData.getId().toString())) {
            this.btnEntryDel.setEnabled(false);
            this.btnRemove.setEnabled(false);
            this.btnEntryAdd.setEnabled(true);
            this.btnMovePre.setEnabled(true);
            this.btnMoveNext.setEnabled(true);
        } else {
            this.btnEntryDel.setEnabled(true);
            this.btnRemove.setEnabled(true);
            this.btnEntryAdd.setEnabled(true);
            this.btnMovePre.setEnabled(true);
            this.btnMoveNext.setEnabled(true);
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        if (this.getEnableModID(this.editData.getId().toString())) {
            this.btnEntryDel.setEnabled(false);
            this.btnRemove.setEnabled(false);
            this.btnEntryAdd.setEnabled(true);
            this.btnMovePre.setEnabled(true);
            this.btnMoveNext.setEnabled(true);
        } else {
            this.btnEntryDel.setEnabled(true);
            this.btnRemove.setEnabled(true);
            this.btnEntryAdd.setEnabled(true);
            this.btnMovePre.setEnabled(true);
            this.btnMoveNext.setEnabled(true);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.setbtnStateByData();
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        JobGradeCollection c = null;
        try {
            c = JobGradeFactory.getRemoteInstance().getJobGradeCollection(" where jobGradeModule = '" + ((JobGradeModuleInfo)dataObject).getId().toString() + "' ");
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        int size = c.size();
        for (int i = size - 1; i > 1; --i) {
            for (int j = 0; j < i; ++j) {
                if (c.get(j).getGrade() <= c.get(j + 1).getGrade()) continue;
                c.swap(j, j + 1);
            }
        }
        super.setDataObject(dataObject);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnEntryAdd.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnEntryDel.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnMovePre.setIcon(EASResource.getIcon((String)"imgTbtn_movetop"));
        this.btnMoveNext.setIcon(EASResource.getIcon((String)"imgTbtn_movedown"));
        this.txtNumber.setRequired(true);
        this.txtName.setRequired(true);
        this.kdtJobGradeEntries.getColumn("number").getStyleAttributes().setBackground(this.editColor);
        this.kdtJobGradeEntries.getColumn("name").getStyleAttributes().setBackground(this.editColor);
    }

    @Override
    protected IObjectValue createNewData() {
        return new JobGradeModuleInfo();
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        if (StringUtils.isEmpty((String)this.txtNumber.getText())) {
            this.txtNumber.requestFocusInWindow();
            throw new OrgBlankException(OrgBlankException.NUMBER_CAN_NOT_BLANK);
        }
        if (StringUtils.isEmpty((String)this.editData.getName())) {
            this.txtName.requestFocusInWindow();
            throw new OrgBlankException(OrgBlankException.NAME_CAN_NOT_BLANK);
        }
        this.checkNumber(this.txtNumber.getText());
        this.checkName(this.txtName.getSelectedItem().toString());
        String nameStr = null;
        String numberStr = null;
        for (int i = 0; i < this.kdtJobGradeEntries.getRowCount(); ++i) {
            nameStr = (String)this.kdtJobGradeEntries.getCell(i, "name").getValue();
            numberStr = (String)this.kdtJobGradeEntries.getCell(i, "number").getValue();
            if (nameStr != null && !"".equals(nameStr.trim()) && numberStr != null && !"".equals(numberStr.trim())) continue;
            throw new JobGradeModuleException(JobGradeModuleException.JOBGRADE_NAME_NUMBER_NOTNULL);
        }
        this.checkJobGradeNumberISRep();
        this.checkAndReplaceCU(this.editData);
    }

    private void checkJobGradeNumberISRep() throws JobGradeModuleException {
        String numberStr = null;
        String name = null;
        int s = 0;
        for (int i = 0; i < this.kdtJobGradeEntries.getRowCount(); ++i) {
            numberStr = (String)this.kdtJobGradeEntries.getCell(i, "number").getValue();
            name = (String)this.kdtJobGradeEntries.getCell(i, "name").getValue();
            if (++s >= this.kdtJobGradeEntries.getRowCount()) continue;
            this.checkJobGradeNumberISRepOne(s, numberStr, name);
        }
    }

    private void checkJobGradeNumberISRepOne(int s, String number, String name) throws JobGradeModuleException {
        if (number == null || name == null) {
            return;
        }
        String numberStr = null;
        String nameStr = null;
        for (int i = s; i < this.kdtJobGradeEntries.getRowCount(); ++i) {
            numberStr = (String)this.kdtJobGradeEntries.getCell(i, "number").getValue();
            nameStr = (String)this.kdtJobGradeEntries.getCell(i, "name").getValue();
            if (number.equals(numberStr)) {
                throw new JobGradeModuleException(JobGradeModuleException.JOBGRADENUMBER_REP);
            }
            if (!name.equals(nameStr)) continue;
            throw new JobGradeModuleException(JobGradeModuleException.JOBGRADENAME_REP);
        }
    }

    private void checkNumber(String number) throws JobGradeModuleException, EASBizException, BOSException {
        Object jgmi = null;
        if (this.editData.getId() != null) {
            String id = this.editData.getId().toString();
            if (JobGradeModuleFactory.getRemoteInstance().exists("where id!='" + id + "' and number='" + number + "'")) {
                throw new JobGradeModuleException(JobGradeModuleException.NUMBER_EXIST);
            }
        } else if (JobGradeModuleFactory.getRemoteInstance().exists(" where number='" + number + "'")) {
            throw new JobGradeModuleException(JobGradeModuleException.NUMBER_EXIST);
        }
    }

    private void checkName(String name) throws JobGradeModuleException, EASBizException, BOSException {
        Object jgmi = null;
        if (this.editData.getId() != null) {
            String id = this.editData.getId().toString();
            if (JobGradeModuleFactory.getRemoteInstance().exists("where id!='" + id + "' and name= '" + name + "'")) {
                throw new JobGradeModuleException(JobGradeModuleException.NAME_EXIST);
            }
        } else if (JobGradeModuleFactory.getRemoteInstance().exists(" where  name='" + name + "'")) {
            throw new JobGradeModuleException(JobGradeModuleException.NAME_EXIST);
        }
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return JobGradeModuleFactory.getRemoteInstance();
    }

    @Override
    public void actionAddJobGrade_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddJobGrade_actionPerformed(e);
        this.kdtJobGradeEntries.addRow();
    }

    @Override
    public void actionDelJobGrade_actionPerformed(ActionEvent e) throws Exception {
        super.actionDelJobGrade_actionPerformed(e);
        int[] rows = KDTableUtil.getSelectedRows((KDTable)this.kdtJobGradeEntries);
        if (rows.length > 1 && OprtState.EDIT.equals(this.getOprtState())) {
            throw new JobGradeModuleException(JobGradeModuleException.SELECTED_ONE);
        }
        for (int i = rows.length - 1; i >= 0; --i) {
            if (rows[i] < this.kdtJobGradeEntries.getRowCount() - 1 && OprtState.EDIT.equals(this.getOprtState())) {
                throw new JobGradeModuleException(JobGradeModuleException.DELETE__THE_LAST_ONE);
            }
            this.kdtJobGradeEntries.removeRow(rows[i]);
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("adminCU.id"));
        sic.add(new SelectorItemInfo("jobGradeEntries.grade"));
        sic.add(new SelectorItemInfo("jobGradeEntries.number"));
        sic.add(new SelectorItemInfo("jobGradeEntries.name"));
        sic.add(new SelectorItemInfo("jobGradeEntries.id"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("CU.id"));
        return sic;
    }

    protected IObjectPK getBizCUPK() {
        return new ObjectUuidPK(SysContext.getSysContext().getCurrentCtrlUnit().getId());
    }

    protected void lockUIForViewStatus() {
        super.lockUIForViewStatus();
        this.btnEntryAdd.setEnabled(false);
        this.btnEntryDel.setEnabled(false);
        this.btnMovePre.setEnabled(false);
        this.btnMoveNext.setEnabled(false);
    }

    protected void unLockUI() {
        super.unLockUI();
        this.btnEntryAdd.setEnabled(true);
        this.btnEntryDel.setEnabled(true);
        this.btnMovePre.setEnabled(true);
        this.btnMoveNext.setEnabled(true);
    }

    @Override
    public void actionMovePre_actionPerformed(ActionEvent e) throws Exception {
        super.actionMovePre_actionPerformed(e);
        int selectRowIndex = this.kdtJobGradeEntries.getSelectManager().getActiveRowIndex();
        IRow curRow = this.kdtJobGradeEntries.getRow(selectRowIndex);
        this.checkSelect(curRow);
        IRow preRow = this.kdtJobGradeEntries.getRow(selectRowIndex - 1);
        if (selectRowIndex != 0) {
            String strOldGrade = curRow.getCell("grade").getValue().toString();
            String strNewGrade = preRow.getCell("grade").getValue().toString();
            this.kdtJobGradeEntries.removeRow(selectRowIndex);
            curRow.getCell("grade").setValue((Object)strNewGrade);
            preRow.getCell("grade").setValue((Object)strOldGrade);
            this.kdtJobGradeEntries.addRow(selectRowIndex - 1, curRow);
            this.kdtJobGradeEntries.getSelectManager().select(selectRowIndex - 1, 2);
        }
    }

    @Override
    public void actionMoveNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionMoveNext_actionPerformed(e);
        int selectRowIndex = this.kdtJobGradeEntries.getSelectManager().getActiveRowIndex();
        IRow curRow = this.kdtJobGradeEntries.getRow(selectRowIndex);
        this.checkSelect(curRow);
        IRow nextRow = this.kdtJobGradeEntries.getRow(selectRowIndex + 1);
        int rowCount = this.kdtJobGradeEntries.getRowCount();
        if (selectRowIndex != rowCount - 1) {
            String strOldGrade = curRow.getCell("grade").getValue().toString();
            String strNewGrade = null;
            if (nextRow.getCell("grade").getValue() != null) {
                strNewGrade = nextRow.getCell("grade").getValue().toString();
            } else {
                MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.org.ORGAutoGenerateResource", (String)"35_JobGradeModuleEditUI"));
                SysUtil.abort();
            }
            this.kdtJobGradeEntries.removeRow(selectRowIndex);
            curRow.getCell("grade").setValue((Object)strNewGrade);
            nextRow.getCell("grade").setValue((Object)strOldGrade);
            this.kdtJobGradeEntries.addRow(selectRowIndex + 1, curRow);
            this.kdtJobGradeEntries.getSelectManager().select(selectRowIndex + 1, 2);
        }
    }

    private void checkSelect(IRow curRow) throws Exception {
        int selectedRowCount = KDTableUtil.getSelectedRowCount((KDTable)this.kdtJobGradeEntries);
        if (selectedRowCount > 1) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.org.ORGAutoGenerateResource", (String)"36_JobGradeModuleEditUI"));
            SysUtil.abort();
        } else if (selectedRowCount == 0) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.org.ORGAutoGenerateResource", (String)"37_JobGradeModuleEditUI"));
            SysUtil.abort();
        }
        if (curRow.getCell("grade").getValue() == null || "".equals(curRow.getCell("grade").getValue())) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.org.ORGAutoGenerateResource", (String)"35_JobGradeModuleEditUI"));
            SysUtil.abort();
        }
    }

    private void checkAndReplaceCU(JobGradeModuleInfo editData) throws Exception {
        if (editData.getId() == null) {
            editData.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
            editData.setAdminCU(SysContext.getSysContext().getCurrentCtrlUnit());
        }
    }

    private boolean getJobGradeModuleState(String jobModID) {
        if (StringUtils.isEmpty((String)jobModID)) {
            return false;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select fid from T_HR_JobGradeModuleState where fEnable='1'").append(" and fJobGradeModule='").append(jobModID).append("'");
        try {
            ISQLExecutor iSql = SQLExecutorFactory.getRemoteInstance((String)sql.toString());
            IRowSet rows = iSql.executeSQL();
            if (rows.next()) {
                return true;
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return false;
    }
}

