/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.org.client;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.HierarchyFactory;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.hr.base.util.HRResourceUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import javax.imageio.ImageIO;

public class PositionSpecHelper {
    private String resClass = "com.kingdee.eas.hr.org.client.PositionResource.";
    private String hierarchyId = null;
    private static final int FIX_WIDTH = 540;
    private static final int FIX_HEIGHT = 20;
    private IMetaDataPK queryPK = null;
    private IQueryExecutor queryExcu = null;

    private String getDefaultHierarchy() throws Exception {
        if (this.hierarchyId == null) {
            this.hierarchyId = HierarchyFactory.getRemoteInstance().getDefaultHierarchy().getId().toString();
        }
        return this.hierarchyId;
    }

    private String[] getNamesFromRowSet(IRowSet rows) throws Exception {
        int size = rows.size();
        if (size > 0) {
            String[] positions = new String[size];
            int i = 0;
            while (rows.next()) {
                positions[i] = rows.getString("Child.name");
                ++i;
            }
            return positions;
        }
        return null;
    }

    private PositionInfo getParentPosition(String positionId) throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(new FilterInfo());
        viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("Hierarchy.id", (Object)this.getDefaultHierarchy()));
        viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("Parent.id", (Object)positionId, CompareType.NOTEQUALS));
        viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("Child.id", (Object)positionId));
        viewInfo.getFilter().setMaskString("#0 and #1 and #2");
        this.queryExcu.setObjectView(viewInfo);
        IRowSet rows = this.queryExcu.executeQuery();
        if (rows.next()) {
            PositionInfo info = new PositionInfo();
            info.setId(BOSUuid.read((String)rows.getString("Parent.id")));
            info.setName(rows.getString("Parent.name"));
            return info;
        }
        return null;
    }

    private String[] getSameLevelPosition(String positionId) throws Exception {
        PositionInfo parent = this.getParentPosition(positionId);
        if (parent == null) {
            return null;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(new FilterInfo());
        viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("Hierarchy.id", (Object)this.getDefaultHierarchy()));
        viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("Parent.id", (Object)parent.getId()));
        viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("Child.id", (Object)positionId, CompareType.NOTEQUALS));
        viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("Child.id", (Object)parent.getId(), CompareType.NOTEQUALS));
        viewInfo.getFilter().setMaskString("#0 and #1 and #2 and #3");
        this.queryExcu.setObjectView(viewInfo);
        IRowSet rows = this.queryExcu.executeQuery();
        return this.getNamesFromRowSet(rows);
    }

    private String[] getSubordinatePosition(String positionId) throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(new FilterInfo());
        viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("Hierarchy.id", (Object)this.getDefaultHierarchy()));
        viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("Parent.id", (Object)positionId));
        viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("Child.id", (Object)positionId, CompareType.NOTEQUALS));
        viewInfo.getFilter().setMaskString("#0 and #1 and #2");
        this.queryExcu.setObjectView(viewInfo);
        IRowSet rows = this.queryExcu.executeQuery();
        return this.getNamesFromRowSet(rows);
    }

    private BufferedImage createMap(int height, String parentName, String name, String[] names1, String[] names2) throws Exception {
        int i;
        height = (height + 1) * 20 + 180;
        BufferedImage image = new BufferedImage(540, height, 1);
        Graphics2D g2d = image.createGraphics();
        FontMetrics fm = g2d.getFontMetrics();
        g2d.setColor(Color.WHITE);
        g2d.fillRect(0, 0, 540, height);
        String drawStr = null;
        drawStr = HRResourceUtils.getMessage((String)"com.kingdee.eas.hr.org.client.PositionResource", (String)"42_DIRECT_SUPERIOR_POSITION", (String[])new String[]{parentName});
        int width = fm.stringWidth(drawStr) + 20;
        int X = (540 - width) / 2;
        int Y = 35;
        g2d.setColor(Color.BLACK);
        g2d.drawRect(X, 20, width, 20);
        g2d.drawString(drawStr, X + 10, Y);
        drawStr = EASResource.getString((String)(this.resClass + "SAMELEVEL_POSITION"));
        width = fm.stringWidth(drawStr) + 20;
        X = (200 - width) / 2;
        Y = 95;
        if (names1 == null) {
            g2d.drawRect(20, 80, 200, 40);
            g2d.drawString(drawStr, 30 + X, Y);
        } else {
            g2d.drawRect(20, 80, 200, (names1.length + 1) * 20);
            g2d.drawString(drawStr, 30 + X, Y);
            for (i = 0; i < names1.length; ++i) {
                Y += 20;
                if (names1[i] == null) continue;
                g2d.drawString(names1[i], 30, Y);
            }
        }
        drawStr = HRResourceUtils.getMessage((String)"com.kingdee.eas.hr.org.client.PositionResource", (String)"43_POSITION_SELF", (String[])new String[]{name});
        width = fm.stringWidth(drawStr) + 20;
        X = (200 - width) / 2;
        Y = 105;
        g2d.draw(new Ellipse2D.Double(320.0, 80.0, 200.0, 40.0));
        g2d.drawString(drawStr, 330 + X, Y);
        drawStr = EASResource.getString((String)(this.resClass + "JUNIOR_POSITION"));
        width = fm.stringWidth(drawStr) + 20;
        X = (200 - width) / 2;
        Y = 155;
        if (names2 == null) {
            g2d.drawRect(320, 140, 200, 40);
            g2d.drawString(drawStr, 330 + X, Y);
        } else {
            g2d.drawRect(320, 140, 200, (names2.length + 1) * 20);
            g2d.drawString(drawStr, 330 + X, Y);
            for (i = 0; i < names2.length; ++i) {
                g2d.drawString(names2[i], 330, Y += 20);
            }
        }
        g2d.drawLine(270, 40, 270, 60);
        g2d.drawLine(120, 60, 420, 60);
        g2d.drawLine(420, 60, 420, 80);
        g2d.drawLine(120, 60, 120, 80);
        g2d.drawLine(420, 120, 420, 140);
        g2d.dispose();
        return image;
    }

    private BufferedImage createMap(int height, String name, String[] names2) {
        height = (height + 1) * 20 + 120;
        BufferedImage image = new BufferedImage(540, height, 1);
        Graphics2D g2d = image.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        FontMetrics fm = g2d.getFontMetrics();
        g2d.setColor(Color.WHITE);
        g2d.fillRect(0, 0, 540, height);
        String drawStr = HRResourceUtils.getMessage((String)"com.kingdee.eas.hr.org.client.PositionResource", (String)"43_POSITION_SELF", (String[])new String[]{name});
        int width = fm.stringWidth(drawStr) + 20;
        int X = (540 - width) / 2;
        int Y = 45;
        g2d.setColor(Color.BLACK);
        g2d.draw(new Ellipse2D.Double(X, 20.0, width, 40.0));
        g2d.drawString(drawStr, X + 10, Y);
        g2d.drawLine(270, 60, 270, 80);
        drawStr = EASResource.getString((String)(this.resClass + "JUNIOR_POSITION"));
        width = fm.stringWidth(drawStr) + 20;
        X = (200 - width) / 2;
        Y = 95;
        if (names2 == null) {
            g2d.drawRect(170, 80, 200, 40);
            g2d.drawString(drawStr, 170 + X, Y);
        } else {
            g2d.drawRect(170, 80, 200, (names2.length + 1) * 20);
            g2d.drawString(drawStr, 170 + X, Y);
            for (int i = 0; i < names2.length; ++i) {
                Y += 20;
                if (names2[i] == null) continue;
                g2d.drawString(names2[i], 180, Y);
            }
        }
        g2d.dispose();
        return image;
    }

    public byte[] creatPositionMap(String positionId) throws Exception {
        this.queryPK = new MetaDataPK("com.kingdee.eas.hr.org.app.PositionHierarchyQuery");
        this.queryExcu = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)this.queryPK);
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)positionId));
        PositionInfo parentInfo = this.getParentPosition(positionId);
        String name = PositionFactory.getRemoteInstance().getPositionInfo((IObjectPK)pk).getName();
        String parentName = null;
        String[] names1 = null;
        String[] names2 = this.getSubordinatePosition(positionId);
        int height = 0;
        BufferedImage image = null;
        if (parentInfo == null) {
            if (names2 != null) {
                height = names2.length;
            }
            image = this.createMap(height, name, names2);
        } else {
            parentName = parentInfo.getName();
            names1 = this.getSameLevelPosition(positionId);
            if (names1 == null && names2 != null) {
                height = names2.length;
            } else if (names2 == null && names1 != null) {
                height = names1.length;
            } else if (names1 != null && names2 != null) {
                height = Math.max(names1.length, names2.length);
            }
            image = this.createMap(height, parentName, name, names1, names2);
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, "JPG", bos);
        byte[] bts = bos.toByteArray();
        bos.close();
        return bts;
    }
}

