/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.org.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.DefaultNoteDataProvider;
import com.kingdee.bos.ctrl.reportone.r1.print.data.R1PrintDataSource;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.HierarchyCollection;
import com.kingdee.eas.basedata.org.HierarchyFactory;
import com.kingdee.eas.basedata.org.HierarchyInfo;
import com.kingdee.eas.basedata.org.IHierarchy;
import com.kingdee.eas.basedata.org.IPositionHierarchy;
import com.kingdee.eas.basedata.org.PositionCollection;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionHierarchyCollection;
import com.kingdee.eas.basedata.org.PositionHierarchyFactory;
import com.kingdee.eas.basedata.org.PositionHierarchyInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.base.client.CustomFilterBuilder;
import com.kingdee.eas.hr.base.client.DataProviderSetting;
import com.kingdee.eas.hr.org.IOrgHRCommon;
import com.kingdee.eas.hr.org.IPersonPlan;
import com.kingdee.eas.hr.org.IPersonPlanScheme;
import com.kingdee.eas.hr.org.OrgHRCommonFactory;
import com.kingdee.eas.hr.org.PersonPlanFactory;
import com.kingdee.eas.hr.org.PersonPlanSchemeFactory;
import com.kingdee.eas.hr.org.PersonPlanSchemeInfo;
import com.kingdee.eas.hr.org.PersonPlanType;
import com.kingdee.eas.hr.org.PositionBaseFacadeFactory;
import com.kingdee.eas.hr.org.SchemeStatus;
import com.kingdee.eas.hr.org.client.PositionSpecHelper;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.ColInfo;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;

public class PositionSpecNoteDataProvider
extends DefaultNoteDataProvider {
    private List positionIds = null;

    public PositionSpecNoteDataProvider(List positionIds) {
        this.positionIds = positionIds;
        DataProviderSetting.addDataSource((DefaultNoteDataProvider)this, (DataProviderSetting)this.getDataProviderSetting());
    }

    public IRowSet getData(R1PrintDataSource dataSource) throws Exception {
        IRowSet rs = null;
        String dsId = dataSource.getId();
        if (!"positionMap".equals(dsId)) {
            rs = super.getData(dataSource);
        }
        rs = this.preGetPositionOutLineData(dataSource, rs);
        return rs;
    }

    private IRowSet preGetPositionOutLineData(R1PrintDataSource dataSource, IRowSet rs) throws Exception {
        String dsId = dataSource.getId();
        if ("positionMap".equals(dsId) && dataSource.getAssociateParameter() != null && dataSource.getAssociateParameter().getValue() != null) {
            String positionId = dataSource.getAssociateParameter().getValue().toString();
            DynamicRowSet drs = new DynamicRowSet(1);
            drs.setColInfo(1, new ColInfo("positionMap", "positionMap", -2, null));
            PositionSpecHelper helper = new PositionSpecHelper();
            drs.moveToInsertRow();
            byte[] bts = helper.creatPositionMap(positionId);
            ByteArrayInputStream bais = new ByteArrayInputStream(bts);
            drs.updateBinaryStream("positionMap", (InputStream)bais, bts.length);
            drs.insertRow();
            drs.beforeFirst();
            return drs;
        }
        if ("positionBaseInfo".equals(dsId)) {
            this.updateRowSet(rs);
        }
        return rs;
    }

    private DataProviderSetting getDataProviderSetting() {
        String dsName = "positionBaseInfo";
        String query = "com.kingdee.eas.hr.org.app.PositionSpecDSQuery";
        DataProviderSetting mainDs = new DataProviderSetting(dsName);
        mainDs.setQueryPK((IMetaDataPK)new MetaDataPK(query));
        mainDs.setFilter(new DataProviderSetting.IHRCustomFilter(){

            public void build(CustomFilterBuilder builder) {
                FilterInfo filter = new FilterInfo();
                if (PositionSpecNoteDataProvider.this.positionIds != null && PositionSpecNoteDataProvider.this.positionIds.size() > 0) {
                    filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(PositionSpecNoteDataProvider.this.positionIds), CompareType.INCLUDE));
                }
                builder.setFilter(filter);
            }
        });
        this.addSubDs(mainDs, "positionComplexIndex", "com.kingdee.eas.hr.org.app.PositionSpecDS2Query");
        this.addSubDs(mainDs, "positionPosiQual", "com.kingdee.eas.hr.org.app.PositionSpecDS3Query");
        this.addSubDs(mainDs, "positionResponsibility", "com.kingdee.eas.hr.org.app.PositionSpecDS4Query");
        return mainDs;
    }

    private void addSubDs(DataProviderSetting dpSeting, String dsName, String queryName) {
        DataProviderSetting subDs = new DataProviderSetting(dsName);
        subDs.setQueryPK((IMetaDataPK)new MetaDataPK(queryName));
        subDs.setForeignKey("position.id");
        dpSeting.append(subDs);
    }

    private HROrgUnitInfo getCurrHRO() {
        return SysContext.getSysContext().getCurrentHRUnit();
    }

    public HierarchyInfo getHierarchy() throws Exception {
        if (this.getCurrHRO() == null) {
            return null;
        }
        IHierarchy iHierarchy = HierarchyFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isDefault", (Object)1));
        evi.setFilter(filter);
        SorterItemInfo sortInfo = new SorterItemInfo("isDefault");
        sortInfo.setSortType(SortType.DESCEND);
        evi.getSorter().add(sortInfo);
        HierarchyCollection hierarchyCollection = iHierarchy.getHierarchyCollection(evi);
        HierarchyInfo hierarchyInfo = null;
        if (hierarchyCollection != null && hierarchyCollection.size() > 0) {
            hierarchyInfo = hierarchyCollection.get(0);
        }
        return hierarchyInfo;
    }

    private PositionInfo getParentPosition(PositionInfo info) throws Exception {
        IPositionHierarchy iPH = PositionHierarchyFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = null;
        FilterItemInfo filterItem2 = null;
        filterItem = new FilterItemInfo("child.id", (Object)info.getId().toString());
        filter.getFilterItems().add(filterItem);
        if (this.getHierarchy() != null) {
            filterItem2 = new FilterItemInfo("hierarchy.id", (Object)this.getHierarchy().getId().toString());
            filter.getFilterItems().add(filterItem2);
        }
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("parent.id"));
        evi.getSelector().add(new SelectorItemInfo("parent.number"));
        evi.getSelector().add(new SelectorItemInfo("parent.name"));
        PositionHierarchyCollection phColl = iPH.getPositionHierarchyCollection(evi);
        PositionInfo pInfo = new PositionInfo();
        if (phColl.size() > 0) {
            pInfo = phColl.get(0).getParent();
        }
        if (pInfo != null) {
            info.put("SuperPosition", (Object)pInfo);
        } else {
            info.put("SuperPosition", (Object)"Me");
        }
        return pInfo;
    }

    private PositionCollection getSumPosition(PositionInfo info) throws Exception {
        IPositionHierarchy iPH = PositionHierarchyFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = null;
        FilterItemInfo filterItem2 = null;
        filterItem = new FilterItemInfo("parent.id", (Object)info.getId().toString());
        filter.getFilterItems().add(filterItem);
        if (this.getHierarchy() != null) {
            filterItem2 = new FilterItemInfo("hierarchy.id", (Object)this.getHierarchy().getId().toString());
            filter.getFilterItems().add(filterItem2);
        }
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("child.id"));
        evi.getSelector().add(new SelectorItemInfo("child.number"));
        evi.getSelector().add(new SelectorItemInfo("child.name"));
        PositionHierarchyCollection phColl = iPH.getPositionHierarchyCollection(evi);
        PositionInfo pInfo = null;
        PositionCollection positionColl = new PositionCollection();
        if (phColl != null) {
            int len = phColl.size();
            for (int i = 0; i < len; ++i) {
                pInfo = phColl.get(i).getChild();
                if (pInfo == null) continue;
                positionColl.add(pInfo);
            }
        }
        return positionColl;
    }

    private PositionInfo getPositionInfoById(String positionId) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)positionId));
        evi.setFilter(filter);
        PositionCollection coll = PositionFactory.getRemoteInstance().getPositionCollection(evi);
        PositionInfo positionInfo = null;
        if (coll != null && coll.size() > 0) {
            positionInfo = coll.get(0);
        }
        return positionInfo;
    }

    private int getPositionPlan(String positionId) throws BOSException, EASBizException {
        if (this.getCurrHRO() == null) {
            return 0;
        }
        IPersonPlanScheme iPPScheme = PersonPlanSchemeFactory.getRemoteInstance();
        IOrgHRCommon iOrgHRCommon = OrgHRCommonFactory.getRemoteInstance();
        HROrgUnitInfo hro = iOrgHRCommon.getPositionOrgHRO(positionId);
        if (hro == null || hro.getId() == null) {
            return 0;
        }
        PersonPlanSchemeInfo schemeInfo = iPPScheme.getDefaultScheme(hro.getId().toString());
        int count = 0;
        if (schemeInfo != null && schemeInfo.getStatus() == SchemeStatus.EXECUTE && schemeInfo.getPlanType() == PersonPlanType.POSITION) {
            IPersonPlan iPPlan = PersonPlanFactory.getRemoteInstance();
            count = iPPlan.getCurrPlanCountByPosition(positionId, schemeInfo.getId().toString());
        }
        return count;
    }

    private void updateRowSet(IRowSet rs) {
        try {
            while (rs.next()) {
                int count;
                String positionId = rs.getString("id");
                PositionInfo positionInfo = this.getPositionInfoById(positionId);
                PositionInfo parentPositionInfo = this.getParentPosition(positionInfo);
                if (parentPositionInfo != null) {
                    rs.updateString("parentPosition", parentPositionInfo.getName());
                }
                if (positionInfo != null) {
                    PositionCollection coll = this.getSumPosition(positionInfo);
                    rs.updateString("sumPositions", this.formatSumPosition(coll));
                }
                if ((count = this.getPositionPlan(positionId)) < 0) {
                    count = 0;
                }
                rs.updateString("positionPlan", Integer.toString(count));
                try {
                    HierarchyInfo hierarchyInfo = this.getHierarchy();
                    PositionHierarchyInfo positionHierarchyInfo = this.getPositionLongNumber(hierarchyInfo.getId(), positionId);
                    int personCount = this.getPersonCountOfPosition(hierarchyInfo.getId().toString(), positionHierarchyInfo);
                    rs.updateString("persons", Integer.toString(personCount));
                }
                catch (Exception e) {
                    rs.updateString("persons", Integer.valueOf(0).toString());
                }
                SimpleDateFormat sdf = new SimpleDateFormat(CtrlFormatUtilities.getDateFormatString());
                rs.updateString("positionConstrueDate", sdf.format(Calendar.getInstance().getTime()));
            }
            rs.beforeFirst();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    protected PositionHierarchyInfo getPositionLongNumber(BOSUuid hierarchyID, String positionId) throws BOSException, EASBizException {
        PositionHierarchyCollection positionHierarchyCollection = null;
        PositionHierarchyInfo positionHierarchyInfo = new PositionHierarchyInfo();
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add(new SelectorItemInfo("longNumber"));
        evi.getSelector().add(new SelectorItemInfo("level"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("child.id", (Object)positionId));
        filterInfo.getFilterItems().add(new FilterItemInfo("hierarchy.id", (Object)hierarchyID));
        evi.setFilter(filterInfo);
        positionHierarchyCollection = PositionHierarchyFactory.getRemoteInstance().getPositionHierarchyCollection(evi);
        if (positionHierarchyCollection != null && positionHierarchyCollection.size() == 1) {
            positionHierarchyInfo = positionHierarchyCollection.get(0);
        }
        return positionHierarchyInfo;
    }

    private int getPersonCountOfPosition(String hirerarchyId, PositionHierarchyInfo info) throws EASBizException, BOSException {
        return PositionBaseFacadeFactory.getRemoteInstance().getPersonCountOfPosition(hirerarchyId, info);
    }

    private String formatSumPosition(PositionCollection coll) {
        StringBuffer str = new StringBuffer();
        int len = coll.size();
        for (int i = 0; i < len; ++i) {
            PositionInfo position = coll.get(i);
            if (position == null) continue;
            if (i == 0) {
                str.append(position.getName());
                continue;
            }
            str.append("," + position.getName());
        }
        return str.toString();
    }
}

