/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.org.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.BoAttchAssoCollection;
import com.kingdee.eas.base.attachment.BoAttchAssoFactory;
import com.kingdee.eas.base.attachment.BoAttchAssoInfo;
import com.kingdee.eas.base.attachment.IBoAttchAsso;
import com.kingdee.eas.base.codingrule.CodingRuleFactory;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRule;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.IPosition;
import com.kingdee.eas.basedata.org.OrgUnitLayerTypeFactory;
import com.kingdee.eas.basedata.org.OrgUnitLayerTypeInfo;
import com.kingdee.eas.basedata.org.PositionCollection;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.org.AdminStandardLibInfo;
import com.kingdee.eas.hr.org.AdminStandardProEntryCollection;
import com.kingdee.eas.hr.org.AdminStandardProEntryFactory;
import com.kingdee.eas.hr.org.AdminStandardProEntryInfo;
import com.kingdee.eas.hr.org.IAdminStandardProEntry;
import com.kingdee.eas.hr.org.IPositionDuty;
import com.kingdee.eas.hr.org.IPositionQualification;
import com.kingdee.eas.hr.org.IPositionRequirement;
import com.kingdee.eas.hr.org.PositionDutyCollection;
import com.kingdee.eas.hr.org.PositionDutyFactory;
import com.kingdee.eas.hr.org.PositionDutyInfo;
import com.kingdee.eas.hr.org.PositionQualificationCollection;
import com.kingdee.eas.hr.org.PositionQualificationFactory;
import com.kingdee.eas.hr.org.PositionQualificationInfo;
import com.kingdee.eas.hr.org.PositionRequirementCollection;
import com.kingdee.eas.hr.org.PositionRequirementFactory;
import com.kingdee.eas.hr.org.PositionRequirementInfo;
import com.kingdee.eas.hr.org.PositionStandardProEntryCollection;
import com.kingdee.eas.hr.org.PositionStandardProEntryFactory;
import com.kingdee.eas.hr.org.PositionStandardProEntryInfo;
import com.kingdee.eas.hr.org.util.OrgBatchAdjustUtil;
import com.kingdee.shr.attachment.ISHRAttachmentExt;
import com.kingdee.shr.attachment.SHRAttachmentExtCollection;
import com.kingdee.shr.attachment.SHRAttachmentExtFactory;
import com.kingdee.shr.attachment.SHRAttachmentExtInfo;
import com.kingdee.shr.base.syssetting.ml.SHRWebResource;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class OrgPosStandardLibUtil {
    public static boolean isExistOrgNumberRule(Context ctx, AdminOrgUnitInfo orgInfo) throws BOSException {
        boolean isExistNumberRule = false;
        String cu = orgInfo.getCU().getId().toString();
        if (!StringUtils.isEmpty((CharSequence)cu)) {
            FullOrgUnitInfo fullOrgUnitInfo = new FullOrgUnitInfo();
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            try {
                if (iCodingRuleManager.isExist((IObjectValue)fullOrgUnitInfo, cu) || iCodingRuleManager.isExist((IObjectValue)orgInfo, cu)) {
                    isExistNumberRule = true;
                }
            }
            catch (EASBizException e) {
                e.printStackTrace();
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
        }
        return isExistNumberRule;
    }

    public static boolean isExistPosNumberRule(Context ctx, AdminOrgUnitInfo orgInfo) throws BOSException {
        boolean isExistNumberRule = false;
        String cu = orgInfo.getCU().getId().toString();
        if (StringUtils.isNotBlank((CharSequence)cu)) {
            PositionInfo positionInfo = new PositionInfo();
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            try {
                if (iCodingRuleManager.isExist((IObjectValue)positionInfo, cu)) {
                    isExistNumberRule = true;
                }
            }
            catch (EASBizException e) {
                e.printStackTrace();
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
        }
        return isExistNumberRule;
    }

    public static String[] getOrgBatchNumberAction(Context ctx, String adminOrgUnitId, int size) throws BOSException {
        String[] numbers = new String[size];
        try {
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            IFullOrgUnit iFullOrgUnit = FullOrgUnitFactory.getLocalInstance((Context)ctx);
            AdminOrgUnitInfo parentAdminOrg = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(adminOrgUnitId.trim()));
            if (parentAdminOrg != null) {
                String mainOrgID = parentAdminOrg.getCU().getId().toString();
                AdminOrgUnitInfo adminOrg = new AdminOrgUnitInfo();
                FullOrgUnitInfo fullOrgUnitInfo = new FullOrgUnitInfo();
                String num = null;
                int count = 0;
                if (iCodingRuleManager.isExist((IObjectValue)adminOrg, mainOrgID)) {
                    adminOrg.setCompany(parentAdminOrg.getCompany());
                    adminOrg.setParent(parentAdminOrg);
                    if (adminOrg.getUnitLayerType() != null && adminOrg.getUnitLayerType().getId() != null) {
                        OrgUnitLayerTypeInfo unitLayerType = OrgUnitLayerTypeFactory.getLocalInstance((Context)ctx).getOrgUnitLayerTypeInfo((IObjectPK)new ObjectUuidPK(adminOrg.getUnitLayerType().getId()));
                        adminOrg.setUnitLayerType(unitLayerType);
                    }
                    int j = 0;
                    while (j < size) {
                        num = iCodingRuleManager.getNonbreakNumber((IObjectValue)adminOrg, mainOrgID);
                        if (iFullOrgUnit.exists(" select id where number='" + num + "'")) {
                            if (++count <= 1000) continue;
                            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{num});
                        }
                        numbers[j] = num;
                        ++j;
                    }
                } else if (iCodingRuleManager.isExist((IObjectValue)fullOrgUnitInfo, mainOrgID)) {
                    FullOrgUnitInfo parentOrgInfo = new FullOrgUnitInfo();
                    parentOrgInfo.setNumber(parentAdminOrg.getNumber());
                    parentOrgInfo.setName(parentAdminOrg.getName());
                    parentOrgInfo.setId(parentAdminOrg.getId());
                    fullOrgUnitInfo.setParent(parentOrgInfo);
                    int j = 0;
                    while (j < size) {
                        num = iCodingRuleManager.getNonbreakNumber((IObjectValue)fullOrgUnitInfo, mainOrgID);
                        if (iFullOrgUnit.exists(" select id where number='" + num + "'")) {
                            if (++count <= 1000) continue;
                            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{num});
                        }
                        numbers[j] = num;
                        ++j;
                    }
                }
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return numbers;
    }

    public static String[] getPosBatchNumberAction(Context ctx, AdminOrgUnitInfo orgInfo, int i) throws BOSException {
        String[] numbers = new String[i];
        AdminOrgUnitInfo adminOrgUnit = null;
        PositionInfo positionInfo = new PositionInfo();
        try {
            adminOrgUnit = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgInfo.getId()));
            if (adminOrgUnit != null) {
                positionInfo.setAdminOrgUnit(adminOrgUnit);
                ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
                String mainOrgID = adminOrgUnit.getCU().getId().toString();
                if (iCodingRuleManager.isExist((IObjectValue)positionInfo, mainOrgID)) {
                    int j = 0;
                    String number = null;
                    IPosition iPosition = PositionFactory.getLocalInstance((Context)ctx);
                    int count = 0;
                    while (j < i) {
                        number = iCodingRuleManager.getNonbreakNumber((IObjectValue)positionInfo, mainOrgID);
                        if (iPosition.exists(" select id where number='" + number + "'")) {
                            if (++count <= 1000) continue;
                            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{number});
                        }
                        numbers[j] = number;
                        ++j;
                    }
                }
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return numbers;
    }

    public static Map recycleOrgBatchNumber(Context ctx, AdminOrgUnitInfo orgInfo, String[] numbers) throws BOSException {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        String adminOrgUnitId = orgInfo.getId().toString();
        try {
            orgInfo = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(adminOrgUnitId));
            if (orgInfo != null) {
                ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
                ICodingRule iCodingRule = CodingRuleFactory.getLocalInstance((Context)ctx);
                String mainOrgID = orgInfo.getCU().getId().toString();
                FullOrgUnitInfo fullOrgUnitInfo = new FullOrgUnitInfo();
                AdminOrgUnitInfo adminOrg = new AdminOrgUnitInfo();
                if (iCodingRuleManager.isExist((IObjectValue)adminOrg, mainOrgID)) {
                    adminOrg.setCompany(orgInfo.getCompany());
                    if (adminOrg.getUnitLayerType() != null && adminOrg.getUnitLayerType().getId() != null) {
                        OrgUnitLayerTypeInfo unitLayerType = OrgUnitLayerTypeFactory.getLocalInstance((Context)ctx).getOrgUnitLayerTypeInfo((IObjectPK)new ObjectUuidPK(adminOrg.getUnitLayerType().getId()));
                        adminOrg.setUnitLayerType(unitLayerType);
                    }
                    adminOrg.setParent(orgInfo);
                    adminOrg.setCU(orgInfo.getCU());
                    boolean isSucess = false;
                    for (int i = 0; i < numbers.length; ++i) {
                        String number = numbers[i];
                        adminOrg.setNumber(number);
                        CodingRuleInfo codingRuleInfo = iCodingRuleManager.getCodingRule((IObjectValue)adminOrg, mainOrgID);
                        if (codingRuleInfo == null) continue;
                        CodingRuleInfo info = codingRuleInfo;
                        isSucess = iCodingRule.recycleNumber((IObjectValue)adminOrg, info, null, number);
                        result.put(number, isSucess);
                    }
                } else if (iCodingRuleManager.isExist((IObjectValue)fullOrgUnitInfo, mainOrgID)) {
                    FullOrgUnitInfo parentOrgInfo = new FullOrgUnitInfo();
                    parentOrgInfo.setNumber(orgInfo.getNumber());
                    parentOrgInfo.setName(orgInfo.getName());
                    parentOrgInfo.setId(orgInfo.getId());
                    fullOrgUnitInfo.setParent(parentOrgInfo);
                    fullOrgUnitInfo.setCU(orgInfo.getCU());
                    boolean isSucess = false;
                    for (int i = 0; i < numbers.length; ++i) {
                        String number = numbers[i];
                        fullOrgUnitInfo.setNumber(number);
                        CodingRuleInfo codingRuleInfo = iCodingRuleManager.getCodingRule((IObjectValue)fullOrgUnitInfo, mainOrgID);
                        if (codingRuleInfo == null) continue;
                        CodingRuleInfo info = codingRuleInfo;
                        isSucess = iCodingRule.recycleNumber((IObjectValue)fullOrgUnitInfo, info, null, number);
                        result.put(number, isSucess);
                    }
                }
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public static Map<String, Boolean> recyclePosBatchNumber(Context ctx, AdminOrgUnitInfo orgInfo, String[] numbers) throws BOSException {
        AdminOrgUnitInfo adminOrgUnit = null;
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        PositionInfo positionInfo = new PositionInfo();
        try {
            adminOrgUnit = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgInfo.getId()));
            if (adminOrgUnit != null) {
                positionInfo.setAdminOrgUnit(adminOrgUnit);
                ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
                String mainOrgID = adminOrgUnit.getCU().getId().toString();
                boolean isSucess = false;
                if (iCodingRuleManager.isExist((IObjectValue)positionInfo, mainOrgID)) {
                    ICodingRule iCodingRule = CodingRuleFactory.getLocalInstance((Context)ctx);
                    for (int i = 0; i < numbers.length; ++i) {
                        String number = numbers[i];
                        positionInfo.setNumber(number);
                        positionInfo.setCU(orgInfo.getCU());
                        CodingRuleInfo codingRuleInfo = iCodingRuleManager.getCodingRule((IObjectValue)positionInfo, mainOrgID);
                        if (codingRuleInfo == null) continue;
                        CodingRuleInfo info = codingRuleInfo;
                        isSucess = iCodingRule.recycleNumber((IObjectValue)positionInfo, info, null, number);
                        result.put(number, isSucess);
                    }
                }
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public static String getIndexSuffix(int index) {
        StringBuffer sortCodeSuffix = new StringBuffer();
        int digit = new Integer(index).toString().length();
        int zeroNum = 6 - digit;
        for (int i = 0; i < zeroNum; ++i) {
            sortCodeSuffix.append("0");
        }
        sortCodeSuffix.append(index);
        return sortCodeSuffix.toString();
    }

    public static int getOrgNumberByLib(Context ctx, String libNumber) throws BOSException {
        int index = 0;
        if (StringUtils.isEmpty((CharSequence)libNumber)) {
            return index;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)(libNumber + "-%"), CompareType.LIKE));
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        SorterItemInfo sortInfo = new SorterItemInfo("number");
        sortInfo.setSortType(SortType.DESCEND);
        sorter.add(sortInfo);
        view.setSorter(sorter);
        AdminOrgUnitCollection coll = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitCollection(view);
        for (int i = 0; i < coll.size(); ++i) {
            AdminOrgUnitInfo info = coll.get(i);
            String indexStr = info.getNumber().substring(libNumber.length() + 1);
            if (index != 0) break;
            try {
                index = Integer.parseInt(indexStr);
                continue;
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        return index;
    }

    public static int getPosNumberByLib(Context ctx, String libNumber) throws BOSException {
        int index = 0;
        if (StringUtils.isEmpty((CharSequence)libNumber)) {
            return index;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)(libNumber + "-%"), CompareType.LIKE));
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        SorterItemInfo sortInfo = new SorterItemInfo("number");
        sortInfo.setSortType(SortType.DESCEND);
        sorter.add(sortInfo);
        view.setSorter(sorter);
        PositionCollection coll = PositionFactory.getLocalInstance((Context)ctx).getPositionCollection(view);
        for (int i = 0; i < coll.size(); ++i) {
            PositionInfo info = coll.get(i);
            String indexStr = info.getNumber().substring(libNumber.length() + 1);
            if (index != 0) break;
            try {
                index = Integer.parseInt(indexStr);
                continue;
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        return index;
    }

    public static Map setPositionInstruction(Context ctx, String posLibId, String positionId) throws BOSException, EASBizException {
        IPositionQualification iPositionQualification;
        PositionQualificationCollection qualifications;
        IPositionRequirement iPositionRequirement;
        PositionRequirementCollection requirements;
        PositionInfo positionInfo = new PositionInfo();
        positionInfo.setId(BOSUuid.read((String)positionId));
        String oql = "where position = '" + posLibId + "'";
        IPositionDuty iPositionDuty = PositionDutyFactory.getLocalInstance(ctx);
        PositionDutyCollection dutys = iPositionDuty.getPositionDutyCollection(oql);
        int size = dutys.size();
        if (size > 0) {
            PositionDutyInfo dutyInfo = null;
            for (int i = 0; i < size; ++i) {
                dutyInfo = dutys.get(i);
                dutyInfo.setId(BOSUuid.create((String)"824531B5"));
                dutyInfo.setPosition(positionInfo);
                iPositionDuty.addnew(dutyInfo);
            }
        }
        if ((size = (requirements = (iPositionRequirement = PositionRequirementFactory.getLocalInstance(ctx)).getPositionRequirementCollection(oql)).size()) > 0) {
            PositionRequirementInfo requirement = null;
            for (int i = 0; i < size; ++i) {
                requirement = requirements.get(i);
                requirement.setId(BOSUuid.create((String)"E0383C84"));
                requirement.setPosition(positionInfo);
                iPositionRequirement.addnew(requirement);
            }
        }
        if ((size = (qualifications = (iPositionQualification = PositionQualificationFactory.getLocalInstance(ctx)).getPositionQualificationCollection(oql)).size()) > 0) {
            PositionQualificationInfo qualification = null;
            for (int i = 0; i < size; ++i) {
                qualification = qualifications.get(i);
                qualification.setId(BOSUuid.create((String)"3E96F1F0"));
                qualification.setPosition(positionInfo);
                iPositionQualification.addnew(qualification);
            }
        }
        return null;
    }

    public static void copyAttachment(Context ctx, String positionLibId, String positionId) throws BOSException, EASBizException {
        IBoAttchAsso iBoAttchAsso = BoAttchAssoFactory.getLocalInstance((Context)ctx);
        ISHRAttachmentExt iSHRAttachmentExt = SHRAttachmentExtFactory.getLocalInstance((Context)ctx);
        String oql = "where boID = '" + positionLibId + "'";
        BoAttchAssoCollection boAttach = iBoAttchAsso.getBoAttchAssoCollection(oql);
        SHRAttachmentExtCollection shrAttachExt = iSHRAttachmentExt.getSHRAttachmentExtCollection(oql);
        if (boAttach != null && boAttach.size() > 0) {
            BoAttchAssoInfo boAttchAssoInfo = null;
            int size = boAttach.size();
            for (int i = 0; i < size; ++i) {
                boAttchAssoInfo = boAttach.get(i);
                boAttchAssoInfo.setId(BOSUuid.create((BOSObjectType)iBoAttchAsso.getType()));
                boAttchAssoInfo.setBoID(positionId);
                boAttchAssoInfo.setAssoBusObjType(String.valueOf(BOSUuid.getBOSObjectType((String)positionId, (boolean)true)));
                iBoAttchAsso.addnew(boAttchAssoInfo);
            }
        }
        if (shrAttachExt != null && shrAttachExt.size() > 0) {
            SHRAttachmentExtInfo sHRAttachmentExtInfo = null;
            String bunding = null;
            int size = shrAttachExt.size();
            for (int i = 0; i < size; ++i) {
                sHRAttachmentExtInfo = shrAttachExt.get(i);
                sHRAttachmentExtInfo.setId(BOSUuid.create((BOSObjectType)iSHRAttachmentExt.getType()));
                sHRAttachmentExtInfo.setBoID(positionId);
                bunding = sHRAttachmentExtInfo.getBunding();
                String[] arr = bunding.split("#");
                bunding = arr[0] + "#com.kingdee.eas.basedata.org.app.Position.form";
                sHRAttachmentExtInfo.setBunding(bunding);
                iSHRAttachmentExt.addnew((CoreBaseInfo)sHRAttachmentExtInfo);
            }
        }
    }

    public static String verifyBeforeAdminPosStandardProEnable(Context ctx, String projectId) throws BOSException {
        String orgInfo = OrgPosStandardLibUtil.verifyAdminStandardProEntry(ctx, projectId);
        String positionInfo = OrgPosStandardLibUtil.verifyPositionStandardProEntry(ctx, projectId);
        return orgInfo + positionInfo;
    }

    private static String verifyPositionStandardProEntry(Context ctx, String projectId) throws BOSException {
        StringBuilder message = new StringBuilder();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("project", (Object)projectId, CompareType.EQUALS));
        view.setFilter(filter);
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("positionStandardLib.name"));
        sic.add(new SelectorItemInfo("parent.name"));
        sic.add(new SelectorItemInfo("adminStandardLib.name"));
        sic.add(new SelectorItemInfo("isRespPosition"));
        view.setSelector(sic);
        try {
            List<String> result;
            HashMap<String, String> nodeMap = new HashMap<String, String>();
            HashMap<String, String> nameMap = new HashMap<String, String>();
            HashMap<String, String> orgMap = new HashMap<String, String>();
            HashMap<String, Integer> respPosMap = new HashMap<String, Integer>();
            PositionStandardProEntryCollection posColl = PositionStandardProEntryFactory.getLocalInstance(ctx).getPositionStandardProEntryCollection(view);
            boolean flag = false;
            String rootId = null;
            boolean needNext = true;
            int size = posColl.size();
            for (int i = 0; i < size; ++i) {
                PositionStandardProEntryInfo pos = posColl.get(i);
                String libId = pos.getId().toString();
                orgMap.put(pos.getAdminStandardLib().getId().toString(), pos.getAdminStandardLib().getName());
                nameMap.put(libId, pos.getPositionStandardLib().getName());
                PositionStandardProEntryInfo parent = pos.getParent();
                if (parent != null) {
                    nodeMap.put(libId, parent.getId().toString());
                } else {
                    if (flag) {
                        message.append(SHRWebResource.getString((String)"com.kingdee.eas.hr.org.OrganisationBizResource", (String)"label386")).append("\t");
                        needNext = false;
                        break;
                    }
                    rootId = libId;
                    nodeMap.put(libId, null);
                    flag = true;
                }
                if (!pos.isIsRespPosition()) continue;
                String adminStandardLibId = pos.getAdminStandardLib().getId().toString();
                if (respPosMap.containsKey(adminStandardLibId)) {
                    respPosMap.put(adminStandardLibId, (Integer)respPosMap.get(adminStandardLibId) + 1);
                    continue;
                }
                respPosMap.put(adminStandardLibId, 1);
            }
            if (!flag && nodeMap.size() > 0) {
                message.append(SHRWebResource.getString((String)"com.kingdee.eas.hr.org.OrganisationBizResource", (String)"label387")).append("\t");
                needNext = false;
            }
            if (needNext && (result = OrgPosStandardLibUtil.verifyTree(nodeMap, nameMap, rootId)).size() > 0) {
                String l = LocaleUtils.getShortCode((Context)ctx);
                String separator = "l1".equals(l) ? "], [" : "\u3011 \u3001\u3010";
                String string2 = StringUtils.join((Object[])result.toArray(), (String)separator);
                string2 = MessageFormat.format(SHRWebResource.getString((String)"com.kingdee.eas.hr.org.OrganisationBizResource", (String)"label389"), string2);
                message.append(string2).append("\t");
                needNext = false;
            }
            if (needNext) {
                StringBuilder noRespPos = new StringBuilder();
                StringBuilder multRespPos = new StringBuilder();
                for (Map.Entry entry : orgMap.entrySet()) {
                    if (respPosMap.containsKey(entry.getKey())) {
                        if ((Integer)respPosMap.get(entry.getKey()) <= 1) continue;
                        multRespPos.append(", ").append((String)entry.getValue());
                        continue;
                    }
                    noRespPos.append(", ").append((String)entry.getValue());
                }
                if (!StringUtils.isEmpty((CharSequence)noRespPos.toString())) {
                    noRespPos.append(SHRWebResource.getString((String)"com.kingdee.eas.hr.org.OrganisationBizResource", (String)"label390"));
                    message.append(noRespPos.substring(1).toString());
                    needNext = false;
                }
                if (!StringUtils.isEmpty((CharSequence)multRespPos.toString())) {
                    multRespPos.append(SHRWebResource.getString((String)"com.kingdee.eas.hr.org.OrganisationBizResource", (String)"label391"));
                    message.append(message + multRespPos.substring(1).toString());
                    needNext = false;
                }
            }
            view = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("project", (Object)projectId, CompareType.EQUALS));
            view.setFilter(filter);
            sic = view.getSelector();
            sic.add(new SelectorItemInfo("adminStandardLib.name"));
            view.setSelector(sic);
            AdminStandardProEntryCollection orgEntry = AdminStandardProEntryFactory.getLocalInstance(ctx).getAdminStandardProEntryCollection(view);
            HashSet<String> orgSet = new HashSet<String>();
            int n = orgEntry.size();
            for (int i = 0; i < n; ++i) {
                orgSet.add(orgEntry.get(i).getAdminStandardLib().getId().toString());
            }
            StringBuilder errorOrg = new StringBuilder();
            for (Map.Entry node : orgMap.entrySet()) {
                if (orgSet.contains(node.getKey())) continue;
                errorOrg.append(", ").append((String)node.getValue());
            }
            if (!StringUtils.isEmpty((CharSequence)errorOrg.toString())) {
                errorOrg.append(SHRWebResource.getString((String)"com.kingdee.eas.hr.org.OrganisationBizResource", (String)"label392")).append("\t");
                message.append(errorOrg.toString().substring(1));
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return message.toString();
    }

    private static String verifyAdminStandardProEntry(Context ctx, String projectId) throws BOSException {
        StringBuilder message = new StringBuilder();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("project", (Object)projectId, CompareType.EQUALS));
        view.setFilter(filter);
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("adminStandardLib.name"));
        sic.add(new SelectorItemInfo("parent.name"));
        view.setSelector(sic);
        try {
            List<String> result;
            String l;
            String separator;
            HashMap<String, String> nodeMap = new HashMap<String, String>();
            HashMap<String, String> nameMap = new HashMap<String, String>();
            AdminStandardProEntryCollection orgEntry = AdminStandardProEntryFactory.getLocalInstance(ctx).getAdminStandardProEntryCollection(view);
            AdminStandardProEntryInfo org = null;
            AdminStandardLibInfo parent = null;
            boolean flag = false;
            String rootId = null;
            String libId = null;
            HashSet orgRepeat = new HashSet();
            boolean needNext = true;
            if (orgEntry.isEmpty()) {
                message.append(SHRWebResource.getString((String)"com.kingdee.eas.hr.org.OrganisationBizResource", (String)"label393")).append("\t");
                needNext = false;
            }
            int size = orgEntry.size();
            for (int i = 0; i < size; ++i) {
                org = orgEntry.get(i);
                nameMap.put(org.getAdminStandardLib().getId().toString(), org.getAdminStandardLib().getName());
                parent = org.getParent();
                libId = org.getAdminStandardLib().getId().toString();
                if (nodeMap.containsKey(libId)) {
                    orgRepeat.add(nameMap.get(libId));
                    continue;
                }
                if (parent != null) {
                    nodeMap.put(libId, parent.getId().toString());
                    continue;
                }
                if (flag) {
                    message.append(SHRWebResource.getString((String)"com.kingdee.eas.hr.org.OrganisationBizResource", (String)"label396")).append("\t");
                    needNext = false;
                    break;
                }
                rootId = org.getAdminStandardLib().getId().toString();
                nodeMap.put(rootId, null);
                flag = true;
            }
            if (!flag && nodeMap.size() > 0) {
                message.append(SHRWebResource.getString((String)"com.kingdee.eas.hr.org.OrganisationBizResource", (String)"label397")).append("\t");
                needNext = false;
            }
            String string = separator = "l1".equals(l = LocaleUtils.getShortCode((Context)ctx)) ? "], [" : "\u3011 \u3001\u3010";
            if (orgRepeat.size() > 0) {
                String temp = StringUtils.join(orgRepeat, (String)separator);
                temp = MessageFormat.format(SHRWebResource.getString((String)"com.kingdee.eas.hr.org.OrganisationBizResource", (String)"label394"), temp) + "\t";
                message.append(temp);
            }
            if (needNext && (result = OrgPosStandardLibUtil.verifyTree(nodeMap, nameMap, rootId)) != null && result.size() > 0) {
                String node = StringUtils.join((Object[])result.toArray(), (String)separator);
                node = MessageFormat.format(SHRWebResource.getString((String)"com.kingdee.eas.hr.org.OrganisationBizResource", (String)"label395"), node);
                message.append(node).append("\t");
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return message.toString();
    }

    public static List<String> verifyTree(Map<String, String> nodeMap, Map<String, String> nameMap, String rootId) {
        HashSet<String> appeared = null;
        HashSet<String> qualified = new HashSet<String>();
        qualified.add(rootId);
        String keyString = null;
        ArrayList<String> result = new ArrayList<String>();
        Iterator<Map.Entry<String, String>> iterator = nodeMap.entrySet().iterator();
        while (iterator.hasNext()) {
            appeared = new HashSet<String>();
            Map.Entry<String, String> node = iterator.next();
            keyString = node.getKey();
            if (OrgPosStandardLibUtil.whetherTreeNode(nodeMap, appeared, qualified, keyString)) {
                qualified.addAll(appeared);
                continue;
            }
            result.add(nameMap.get(keyString));
        }
        return result;
    }

    private static boolean whetherTreeNode(Map<String, String> nodeMap, Set<String> appeared, Set<String> qualified, String nodeId) {
        if (qualified.contains(nodeId)) {
            return true;
        }
        String parent = nodeMap.get(nodeId);
        if (nodeMap.containsKey(parent) && !appeared.contains(parent)) {
            appeared.add(nodeId);
            return OrgPosStandardLibUtil.whetherTreeNode(nodeMap, appeared, qualified, parent);
        }
        return false;
    }

    public static AdminStandardProEntryCollection getOrgEntryByProjectId(Context ctx, String projectId) throws BOSException, ParserException {
        String oql_base;
        AdminStandardProEntryCollection result = new AdminStandardProEntryCollection();
        String oql = oql_base = "select adminStandardLib.name, adminStandardLib.orgUnitLayerType.name, adminStandardLib.adminStandardLibSort.name, parent.name, state where state=1 and project.id ='" + projectId + "'";
        IAdminStandardProEntry iAdminStandardProEntry = AdminStandardProEntryFactory.getLocalInstance(ctx);
        AdminStandardProEntryCollection orgEntrys = iAdminStandardProEntry.getAdminStandardProEntryCollection(oql);
        HashSet<String> orgLibIdSet = new HashSet<String>();
        AdminStandardProEntryCollection orgEntryColl = null;
        int size = orgEntrys.size();
        for (int j = 0; j < size; ++j) {
            if (j == 0) {
                oql = oql_base + " and parent is null";
                orgEntryColl = iAdminStandardProEntry.getAdminStandardProEntryCollection(oql);
            } else {
                oql = oql_base + " and parent.id in (" + OrgBatchAdjustUtil.idsSetToIdSql(orgLibIdSet) + ")  order by index asc";
                orgEntryColl = iAdminStandardProEntry.getAdminStandardProEntryCollection(oql);
            }
            orgLibIdSet = new HashSet();
            if (orgEntryColl.size() <= 0) break;
            for (int i = 0; i < orgEntryColl.size(); ++i) {
                result.add(orgEntryColl.get(i));
                orgLibIdSet.add(orgEntryColl.get(i).getAdminStandardLib().getId().toString());
            }
        }
        return result;
    }

    public static PositionStandardProEntryCollection getPosEntryByProjectId(Context ctx, String projectId) throws BOSException, ParserException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("project", (Object)projectId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)1, CompareType.EQUALS));
        view.setFilter(filter);
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("positionStandardLib.name"));
        sic.add(new SelectorItemInfo("positionStandardLib.hrJob.name"));
        sic.add(new SelectorItemInfo("adminStandardLib.name"));
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("parent.positionStandardLib.name"));
        sic.add(new SelectorItemInfo("isRespPosition"));
        view.setSelector(sic);
        SorterItemCollection sorterItemCollection = new SorterItemCollection();
        sorterItemCollection.getSorter().decode("order by adminStandardLib");
        view.setSorter(sorterItemCollection);
        PositionStandardProEntryCollection collection = PositionStandardProEntryFactory.getLocalInstance(ctx).getPositionStandardProEntryCollection(view);
        AdminStandardProEntryCollection orgEntrys = OrgPosStandardLibUtil.getOrgEntryByProjectId(ctx, projectId);
        HashMap<String, Integer> orgMap = new HashMap<String, Integer>();
        int size = orgEntrys.size();
        for (int i = 0; i < size; ++i) {
            orgMap.put(orgEntrys.get(i).getAdminStandardLib().getId().toString(), i);
        }
        PositionStandardProEntryInfo entryInfo = null;
        ArrayList<PositionStandardProEntryInfo> posList = new ArrayList<PositionStandardProEntryInfo>();
        int size2 = collection.size();
        for (int i = 0; i < size2; ++i) {
            entryInfo = collection.get(i);
            entryInfo.setIndex((Integer)orgMap.get(entryInfo.getAdminStandardLib().getId().toString()));
            posList.add(entryInfo);
        }
        Comparator<PositionStandardProEntryInfo> indexCompare = new Comparator<PositionStandardProEntryInfo>(){

            @Override
            public int compare(PositionStandardProEntryInfo o1, PositionStandardProEntryInfo o2) {
                if (o1.getIndex() > o2.getIndex()) {
                    return 1;
                }
                return -1;
            }
        };
        Collections.sort(posList, indexCompare);
        PositionStandardProEntryCollection result = new PositionStandardProEntryCollection();
        String rootEntryOrgId = null;
        int size3 = posList.size();
        for (int i = 0; i < size3; ++i) {
            entryInfo = (PositionStandardProEntryInfo)posList.get(i);
            if (entryInfo.getParent() != null) continue;
            rootEntryOrgId = entryInfo.getAdminStandardLib().getId().toString();
            break;
        }
        boolean flag = false;
        int size4 = posList.size();
        for (int i = 0; i < size4; ++i) {
            entryInfo = (PositionStandardProEntryInfo)posList.get(i);
            if (entryInfo.getParent() == null) {
                result.addObject(0, (IObjectValue)entryInfo);
                flag = true;
                continue;
            }
            if (StringUtils.equals((CharSequence)rootEntryOrgId, (CharSequence)entryInfo.getAdminStandardLib().getId().toString())) {
                if (flag) {
                    result.addObject(1, (IObjectValue)entryInfo);
                    continue;
                }
                result.addObject(0, (IObjectValue)entryInfo);
                continue;
            }
            result.add(entryInfo);
        }
        return result;
    }
}

