/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.org.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.util.HRUtil;
import com.kingdee.eas.hr.org.app.AbstractHRCommonCronJobFacadeControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.MSFServiceFacadeFactory;
import com.kingdee.util.StringUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.log4j.Logger;

public class HRCommonCronJobFacadeControllerBean
extends AbstractHRCommonCronJobFacadeControllerBean {
    private static final long serialVersionUID = 4073860122595064999L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.org.app.HRCommonCronJobFacadeControllerBean");

    @Override
    protected void _processRegisterJob(Context ctx) throws BOSException, EASBizException {
        IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)"select FRriggerType, FOsfName, FClass, FMethod from T_HR_CommonCronJob where FEnabled = '1' order by FNumber");
        int threadSize = iRowSet.size();
        if (threadSize > 0) {
            if (threadSize > 6) {
                threadSize = 6;
            }
            ExecutorService fixedThreadPool = Executors.newFixedThreadPool(threadSize);
            try {
                while (iRowSet.next()) {
                    String triggerType = iRowSet.getString("FRriggerType");
                    String osfName = iRowSet.getString("FOsfName");
                    String className = iRowSet.getString("FClass");
                    String methodName = iRowSet.getString("FMethod");
                    if (StringUtils.isEmpty((String)triggerType)) continue;
                    InnerRunnable runnable = new InnerRunnable(ctx, triggerType, osfName, className, methodName);
                    fixedThreadPool.submit(runnable);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
            DbUtil.execute((Context)ctx, (String)("UPDATE T_HR_CommonCronJob SET FLastUpdateTime = " + HRUtil.getCurrentDate() + ", FLastUpdateUserID = '" + userInfo.getId().toString() + "' where FEnabled = '1'"));
        }
    }

    class InnerRunnable
    implements Runnable {
        private Context ctx;
        private String triggerType;
        private String osfName;
        private String className;
        private String methodName;

        public InnerRunnable(Context ctx, String triggerType, String osfName, String className, String methodName) {
            this.ctx = ctx;
            this.triggerType = triggerType;
            this.osfName = osfName;
            this.className = className;
            this.methodName = methodName;
        }

        @Override
        public void run() {
            String startTime = HRUtil.getCurrentDate();
            String message = "success";
            String conditionSql = "";
            Object[] objectParam = null;
            if ("reflection".equalsIgnoreCase(this.triggerType) && !StringUtils.isEmpty((String)this.className) && !StringUtils.isEmpty((String)this.methodName)) {
                try {
                    Class<?> clazz = Class.forName(this.className);
                    Method method = clazz.getMethod(this.methodName, Context.class);
                    method.invoke(clazz.newInstance(), this.ctx);
                }
                catch (ClassNotFoundException e) {
                    message = ClassNotFoundException.class.getName() + ": " + e.getMessage();
                    e.printStackTrace();
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
                catch (NoSuchMethodException e) {
                    message = NoSuchMethodException.class.getName() + ": " + e.getMessage();
                    e.printStackTrace();
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
                catch (SecurityException e) {
                    message = SecurityException.class.getName() + ": " + e.getMessage();
                    e.printStackTrace();
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    message = IllegalAccessException.class.getName() + ": " + e.getMessage();
                    e.printStackTrace();
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
                catch (IllegalArgumentException e) {
                    message = IllegalArgumentException.class.getName() + ": " + e.getMessage();
                    e.printStackTrace();
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    message = InvocationTargetException.class.getName() + ": " + e.getMessage();
                    e.printStackTrace();
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
                catch (InstantiationException e) {
                    message = InstantiationException.class.getName() + ": " + e.getMessage();
                    e.printStackTrace();
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
                catch (Exception e) {
                    message = Exception.class.getName() + ": " + e.getMessage();
                    e.printStackTrace();
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
                conditionSql = " where FClass = ? AND FMethod = ? ";
                objectParam = new Object[]{message, this.className, this.methodName};
            } else if ("osf".equalsIgnoreCase(this.triggerType) && !StringUtils.isEmpty((String)this.osfName)) {
                HashMap param = new HashMap();
                try {
                    MSFServiceFacadeFactory.getLocalInstance((Context)this.ctx).processService(this.osfName, param);
                }
                catch (EASBizException e) {
                    message = EASBizException.class.getName() + ": " + e.getMessage();
                    e.printStackTrace();
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
                catch (BOSException e) {
                    message = BOSException.class.getName() + ": " + e.getMessage();
                    e.printStackTrace();
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
                catch (Exception e) {
                    message = Exception.class.getName() + ": " + e.getMessage();
                    e.printStackTrace();
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
                conditionSql = " where FOsfName = ? ";
                objectParam = new Object[]{message, this.osfName};
            }
            String endTime = HRUtil.getCurrentDate();
            if (!StringUtils.isEmpty((String)conditionSql)) {
                String sql = String.format("UPDATE T_HR_CommonCronJob SET FStartTime = %s , FEndTime = %s, FMessage = ? %s", startTime, endTime, conditionSql);
                try {
                    DbUtil.execute((Context)this.ctx, (String)sql, objectParam);
                }
                catch (BOSException e) {
                    e.printStackTrace();
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

