/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.org.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.org.PositionCollection;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.org.OrgAdjustEnableException;
import com.kingdee.eas.hr.org.OrgVerAdjEnum;
import com.kingdee.eas.hr.org.OrgVerEffectInfo;
import com.kingdee.eas.hr.org.PositionVerAdjRecCollection;
import com.kingdee.eas.hr.org.PositionVerAdjRecInfo;
import com.kingdee.eas.hr.org.app.IOrgVersionChecker;
import com.kingdee.eas.hr.org.app.OrgVersionUtils;
import com.kingdee.eas.hr.org.app.PositionValidateCircleHelper;
import com.kingdee.eas.hr.org.util.OrgVersionCheckPositionHelper;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;

public class OrgVersionPositionCheckHandler
implements IOrgVersionChecker {
    @Override
    public OrgVerEffectInfo check(Context ctx, OrgVerEffectInfo checkResultInfo) throws BOSException, EASBizException {
        Object errorMsg = null;
        this.positionAddNewCheck(ctx, checkResultInfo);
        try {
            this.positionAlreadyAddNewCheck(ctx, checkResultInfo);
        }
        catch (SQLException e) {
            throw new OrgAdjustEnableException(OrgAdjustEnableException.POSITIONVALIDFAILD, e);
        }
        try {
            this.positionCircleCheck(ctx, checkResultInfo);
        }
        catch (SQLException e) {
            throw new OrgAdjustEnableException(OrgAdjustEnableException.POSITIONVALIDFAILD, e);
        }
        return checkResultInfo;
    }

    private void positionMove(Context ctx, OrgVerEffectInfo checkResultInfo) throws BOSException, EASBizException, SQLException {
    }

    private void positionAlreadyAddNewCheck(Context ctx, OrgVerEffectInfo checkResultInfo) throws BOSException, EASBizException, SQLException {
        String l = LocaleUtils.getShortCode((Context)ctx);
        StringBuffer sql = new StringBuffer();
        sql.append(" select ").append("p.fname_" + l + " positionName,p.fnumber positionNumber,org.fid fid,org.fname_" + l + " fname_" + l + ",org.fnumber,org.fdisplayname_" + l + " fdisplayname_" + l + " ").append(" from T_ORG_Position p inner join t_org_admin  org on org.fid=p.FAdminOrgUnitID where ").append(checkResultInfo.getOrgWhereStr()).append(" and not exists (select FPositionID from T_HR_PositionVer b where b.fOrgAdjSchm ='").append(checkResultInfo.getAdjSchmInfo().getId().toString()).append("'").append(" and b.FPositionID = p.fid )");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        StringBuffer sb = null;
        String afterAdjSchmEable = EASResource.getString((String)"com.kingdee.eas.hr.org.HROrgAdjSchmVerResource", (String)"AfterAdjSchmEable");
        String postionNotChange = EASResource.getString((String)"com.kingdee.eas.hr.org.HROrgAdjSchmVerResource", (String)"PostionNotChange");
        while (rowSet.next()) {
            sb = new StringBuffer();
            sb.append(afterAdjSchmEable).append(rowSet.getString("fdisplayname_" + l + "")).append(" ").append(rowSet.getString("positionName")).append(rowSet.getString("positionNumber")).append(postionNotChange);
            checkResultInfo.appendWarningMsg(sb.toString());
        }
    }

    private void positionCircleCheck(Context ctx, OrgVerEffectInfo checkResultInfo) throws BOSException, SQLException {
        PositionValidateCircleHelper helper = new PositionValidateCircleHelper();
        String errorStr = helper.checkPositionCircle(ctx, checkResultInfo.getAdjSchmInfo().getId().toString());
        if (!StringUtils.isEmpty((String)errorStr)) {
            checkResultInfo.appendErrorMsg(errorStr);
        }
    }

    private void positionAddNewCheck(Context ctx, OrgVerEffectInfo checkResultInfo) throws BOSException {
        PositionVerAdjRecCollection ovColl = null;
        HashMap<String, PositionVerAdjRecInfo> addNew = new HashMap<String, PositionVerAdjRecInfo>();
        try {
            ovColl = OrgVersionUtils.getPositionVerAdjRecCollection(ctx, checkResultInfo.getAdjSchmInfo().getId().toString());
            for (int i = 0; i < ovColl.size(); ++i) {
                if (!OrgVerAdjEnum.ADDNEW.equals((Object)ovColl.get(i).getAdjType())) continue;
                addNew.put(ovColl.get(i).getPositionVer().getNumber(), ovColl.get(i));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (addNew.size() == 0) {
            return;
        }
        OrgVersionCheckPositionHelper helper = new OrgVersionCheckPositionHelper();
        PositionCollection pColl = helper.getAddPositionExistNumberPosition(ctx, addNew);
        PositionInfo pInfo = null;
        ArrayList<PositionInfo> replaceList = new ArrayList<PositionInfo>();
        ArrayList<PositionInfo> manualList = new ArrayList<PositionInfo>();
        PositionVerAdjRecInfo recInfo = null;
        for (int i = 0; i < pColl.size(); ++i) {
            pInfo = pColl.get(i);
            recInfo = (PositionVerAdjRecInfo)addNew.get(pInfo.getNumber());
            if (pInfo.getName().equals(recInfo.getPositionVer().getName()) && pInfo.getAdminOrgUnit().getId().equals((Object)recInfo.getPositionVer().getAdminOrgUnit().getAdminOrgUnit().getId())) {
                replaceList.add(pInfo);
                continue;
            }
            manualList.add(pInfo);
        }
        helper.operateReplacePosition(ctx, replaceList, addNew, checkResultInfo);
        helper.operateManualPosition(ctx, manualList, addNew, checkResultInfo);
    }
}

