/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.org.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.hr.util.HRParamUtil;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.IPosition;
import com.kingdee.eas.basedata.org.JobCollection;
import com.kingdee.eas.basedata.org.JobFactory;
import com.kingdee.eas.basedata.org.JobInfo;
import com.kingdee.eas.basedata.org.PositionCollection;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.org.PositionMemberInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.hr.base.EmployeeTypeFactory;
import com.kingdee.eas.hr.base.EmployeeTypeInfo;
import com.kingdee.eas.hr.base.HRInitFactory;
import com.kingdee.eas.hr.base.util.HRUtilExtend;
import com.kingdee.eas.hr.base.util.OrgStringUtil;
import com.kingdee.eas.hr.org.IOrgHRCommon;
import com.kingdee.eas.hr.org.IPersonPlan;
import com.kingdee.eas.hr.org.IPersonPlanScheme;
import com.kingdee.eas.hr.org.OrgHRCommonFactory;
import com.kingdee.eas.hr.org.Period;
import com.kingdee.eas.hr.org.PersonPlanCollection;
import com.kingdee.eas.hr.org.PersonPlanException;
import com.kingdee.eas.hr.org.PersonPlanFactory;
import com.kingdee.eas.hr.org.PersonPlanInfo;
import com.kingdee.eas.hr.org.PersonPlanRowInfo;
import com.kingdee.eas.hr.org.PersonPlanSchemeFactory;
import com.kingdee.eas.hr.org.PersonPlanSchemeInfo;
import com.kingdee.eas.hr.org.PersonPlanSchemeTypeEnum;
import com.kingdee.eas.hr.org.PersonPlanType;
import com.kingdee.eas.hr.org.PlanActualInfo;
import com.kingdee.eas.hr.org.PosPerPlanInfo;
import com.kingdee.eas.hr.org.SchemeStatus;
import com.kingdee.eas.hr.org.app.AbstractPersonPlanControllerBean;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.ColInfo;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.VerticalAlignment;

@Deprecated
public class PersonPlanControllerBean
extends AbstractPersonPlanControllerBean {
    private int levelOfRoot;
    private DefaultKingdeeTreeNode rootForAdmin;

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PersonPlanInfo ppInfo = (PersonPlanInfo)model;
        if (ppInfo.getType() == PersonPlanType.POSITION) {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("adminOrgUnit");
            PositionInfo position = PositionFactory.getLocalInstance((Context)ctx).getPositionInfo((IObjectPK)new ObjectUuidPK(ppInfo.getPosition().getId()), selector);
            ppInfo.setAdminOrg(position.getAdminOrgUnit());
        }
        StringBuffer oql = new StringBuffer("");
        oql.append("select id where scheme='");
        oql.append(ppInfo.getScheme().getId());
        oql.append("' and adminOrg='");
        oql.append(ppInfo.getAdminOrg().getId());
        oql.append("' and year=");
        oql.append(ppInfo.getYear());
        if (ppInfo.getType() == PersonPlanType.POSITION) {
            oql.append(" and position='");
            oql.append(ppInfo.getPosition().getId());
            oql.append("' ");
        } else if (ppInfo.getType() == PersonPlanType.JOB) {
            oql.append(" and job='");
            oql.append(ppInfo.getJob().getId());
            oql.append("' ");
        }
        PersonPlanCollection ppColl = this.getPersonPlanCollection(ctx, oql.toString());
        if (ppColl.size() > 0) {
            ppInfo.setId(ppColl.get(0).getId());
            ObjectUuidPK pk = new ObjectUuidPK(ppColl.get(0).getId());
            this.update(ctx, (IObjectPK)pk, (CoreBaseInfo)ppInfo);
            return pk;
        }
        ppInfo.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
        return super._addnew(ctx, (IObjectValue)ppInfo);
    }

    @Override
    protected int _getHistoryCount(Context ctx, String schemeId, String adminId, PersonPlanType planType, String objId, int year, int month) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer("");
        sql.append("SELECT FPlan1,FPlan2,FPlan3,FPlan4,FPlan5,FPlan6,FPlan7,FPlan8,FPlan9,FPlan10,FPlan11,FPlan12 ");
        sql.append(" FROM T_HR_PersonPlan WHERE FSchemeID='");
        sql.append(schemeId);
        sql.append("' AND FAdminOrgID='");
        sql.append(adminId);
        sql.append("' AND FYear=");
        sql.append(year);
        if (planType == PersonPlanType.POSITION) {
            sql.append(" AND FPositionID='");
            sql.append(objId);
            sql.append("'");
        } else if (planType == PersonPlanType.JOB) {
            sql.append(" AND FJobID='");
            sql.append(objId);
            sql.append("'");
        }
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rows.next()) {
                if (rows.getString(month) == null) {
                    return -1;
                }
                return rows.getInt(month);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return 0;
    }

    @Override
    protected ArrayList _getHistoryData(Context ctx, String schemeId, String adminId, PersonPlanType planType, String objId, ArrayList month) throws BOSException, EASBizException {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int count = 0;
        int size = month.size();
        for (int i = 0; i < size; ++i) {
            String[] strList = month.get(i).toString().split("-@@-");
            count = this._getHistoryCount(ctx, schemeId, adminId, planType, objId, Integer.parseInt(strList[0]), Integer.parseInt(strList[1]));
            if (count == -1) {
                list.add(null);
                continue;
            }
            list.add(count);
        }
        return list;
    }

    @Override
    protected List _getReportData(Context ctx, IObjectValue adminInfo, IObjectValue schemeInfo, int level, boolean isInvalidPosition) throws BOSException, EASBizException {
        return this._getReportData(ctx, adminInfo, schemeInfo, level, isInvalidPosition, true);
    }

    @Override
    protected List _getReportData(Context ctx, IObjectValue adminInfo, IObjectValue schemeInfo, int level) throws BOSException, EASBizException {
        return this._getReportData(ctx, adminInfo, schemeInfo, level, true);
    }

    @Override
    protected List _getReportData(Context ctx, IObjectValue adminInfo, IObjectValue schemeInfo) throws BOSException, EASBizException {
        return this._getReportData(ctx, adminInfo, schemeInfo, 2);
    }

    private AdminOrgUnitInfo createBlankOrg(int level, boolean isLeaf, String name) {
        AdminOrgUnitInfo info = new AdminOrgUnitInfo();
        info.setName(name);
        info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        info.setLevel(level);
        info.setIsLeaf(isLeaf);
        return info;
    }

    private void buildAdminNode(AdminOrgUnitCollection col, DefaultKingdeeTreeNode root, boolean showVirtualOrg) {
        AdminOrgUnitInfo adminInfo = (AdminOrgUnitInfo)root.getUserObject();
        if (adminInfo != null) {
            adminInfo.setLevel(root.getLevel());
            adminInfo.setIsLeaf(root.isLeaf());
            if (!showVirtualOrg) {
                if (!adminInfo.isIsVirtual()) {
                    col.add(adminInfo);
                }
            } else {
                col.add(adminInfo);
            }
        }
        int size = root.getChildCount();
        for (int i = 0; i < size; ++i) {
            this.buildAdminNode(col, (DefaultKingdeeTreeNode)root.getChildAt(i), showVirtualOrg);
        }
    }

    private void buildAdminNode(AdminOrgUnitCollection col, DefaultKingdeeTreeNode root, boolean showVirtualOrg, int level) {
        AdminOrgUnitInfo adminInfo = (AdminOrgUnitInfo)root.getUserObject();
        if (adminInfo != null) {
            if (root.getLevel() - this.levelOfRoot > level) {
                return;
            }
            adminInfo.setLevel(root.getLevel());
            if (level == 100) {
                adminInfo.setIsLeaf(root.isLeaf());
            } else if (root.getLevel() - this.levelOfRoot == level) {
                adminInfo.setIsLeaf(true);
            } else {
                adminInfo.setIsLeaf(root.isLeaf());
            }
            if (!showVirtualOrg) {
                if (!adminInfo.isIsVirtual()) {
                    col.add(adminInfo);
                }
            } else {
                col.add(adminInfo);
            }
        }
        int size = root.getChildCount();
        for (int i = 0; i < size; ++i) {
            this.buildAdminNode(col, (DefaultKingdeeTreeNode)root.getChildAt(i), showVirtualOrg, level);
        }
    }

    private IRowSet getAdminSumData(IRowSet rows, IRowSet rows2) throws BOSException, EASBizException {
        HashMap<String, int[]> map = new HashMap<String, int[]>();
        ArrayList<String> yearList = new ArrayList<String>();
        DynamicRowSet drs = null;
        try {
            int[] sum;
            String longNumber = null;
            String year = null;
            while (rows.next()) {
                longNumber = rows.getString("FLongNumber");
                year = rows.getString("FYear");
                if (!yearList.contains(year)) {
                    yearList.add(year);
                }
                int[] counts = new int[12];
                if (map.get(year + "$@" + longNumber) != null) {
                    counts = (int[])map.get(year + "$@" + longNumber);
                }
                counts[0] = counts[0] + rows.getInt("FPlan1");
                counts[1] = counts[1] + rows.getInt("FPlan2");
                counts[2] = counts[2] + rows.getInt("FPlan3");
                counts[3] = counts[3] + rows.getInt("FPlan4");
                counts[4] = counts[4] + rows.getInt("FPlan5");
                counts[5] = counts[5] + rows.getInt("FPlan6");
                counts[6] = counts[6] + rows.getInt("FPlan7");
                counts[7] = counts[7] + rows.getInt("FPlan8");
                counts[8] = counts[8] + rows.getInt("FPlan9");
                counts[9] = counts[9] + rows.getInt("FPlan10");
                counts[10] = counts[10] + rows.getInt("FPlan11");
                counts[11] = counts[11] + rows.getInt("FPlan12");
                map.put(year + "$@" + longNumber, counts);
            }
            while (rows2.next()) {
                longNumber = rows2.getString("FLongNumber");
                int size = yearList.size();
                for (int i = 0; i < size; ++i) {
                    year = yearList.get(i).toString();
                    if (map.get(year + "$@" + longNumber) != null) continue;
                    map.put(year + "$@" + longNumber, new int[12]);
                }
            }
            String key = null;
            String key2 = null;
            Iterator iter = map.keySet().iterator();
            Iterator iter2 = null;
            ArrayList<String> keyList = new ArrayList<String>();
            while (iter.hasNext()) {
                keyList.add(iter.next().toString());
            }
            Collections.sort(keyList);
            for (int i = 0; i < keyList.size(); ++i) {
                key = keyList.get(i).toString();
                sum = (int[])map.get(key);
                iter2 = map.keySet().iterator();
                while (iter2.hasNext()) {
                    key2 = iter2.next().toString();
                    if (key2.toString().indexOf(key + "!") <= -1) continue;
                    int[] temp = (int[])map.get(key2);
                    sum[0] = sum[0] + temp[0];
                    sum[1] = sum[1] + temp[1];
                    sum[2] = sum[2] + temp[2];
                    sum[3] = sum[3] + temp[3];
                    sum[4] = sum[4] + temp[4];
                    sum[5] = sum[5] + temp[5];
                    sum[6] = sum[6] + temp[6];
                    sum[7] = sum[7] + temp[7];
                    sum[8] = sum[8] + temp[8];
                    sum[9] = sum[9] + temp[9];
                    sum[10] = sum[10] + temp[10];
                    sum[11] = sum[11] + temp[11];
                }
                map.put(key, sum);
            }
            drs = new DynamicRowSet(14);
            drs.setColInfo(1, new ColInfo("FPlan1", "FPlan1", 4, null));
            drs.setColInfo(2, new ColInfo("FPlan2", "FPlan2", 4, null));
            drs.setColInfo(3, new ColInfo("FPlan3", "FPlan3", 4, null));
            drs.setColInfo(4, new ColInfo("FPlan4", "FPlan4", 4, null));
            drs.setColInfo(5, new ColInfo("FPlan5", "FPlan5", 4, null));
            drs.setColInfo(6, new ColInfo("FPlan6", "FPlan6", 4, null));
            drs.setColInfo(7, new ColInfo("FPlan7", "FPlan7", 4, null));
            drs.setColInfo(8, new ColInfo("FPlan8", "FPlan8", 4, null));
            drs.setColInfo(9, new ColInfo("FPlan9", "FPlan9", 4, null));
            drs.setColInfo(10, new ColInfo("FPlan10", "FPlan10", 4, null));
            drs.setColInfo(11, new ColInfo("FPlan11", "FPlan11", 4, null));
            drs.setColInfo(12, new ColInfo("FPlan12", "FPlan12", 4, null));
            drs.setColInfo(13, new ColInfo("FAdminOrgID", "FAdminOrgID", 12, null));
            drs.setColInfo(14, new ColInfo("FYear", "FYear", 4, null));
            iter = map.keySet().iterator();
            String[] keys = null;
            while (iter.hasNext()) {
                key = iter.next().toString();
                sum = (int[])map.get(key);
                drs.moveToInsertRow();
                drs.updateInt("FPlan1", sum[0]);
                drs.updateInt("FPlan2", sum[1]);
                drs.updateInt("FPlan3", sum[2]);
                drs.updateInt("FPlan4", sum[3]);
                drs.updateInt("FPlan5", sum[4]);
                drs.updateInt("FPlan6", sum[5]);
                drs.updateInt("FPlan7", sum[6]);
                drs.updateInt("FPlan8", sum[7]);
                drs.updateInt("FPlan9", sum[8]);
                drs.updateInt("FPlan10", sum[9]);
                drs.updateInt("FPlan11", sum[10]);
                drs.updateInt("FPlan12", sum[11]);
                keys = StringUtils.split((String)key, (String)"$@");
                drs.updateInt("FYear", Integer.parseInt(keys[0]));
                drs.updateString("FAdminOrgID", keys[1]);
                drs.insertRow();
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return drs;
    }

    private IRowSet getAdminOrgUnits(Context ctx, AdminOrgUnitInfo adminInfo, boolean showVirtualOrg) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FLongNumber FROM T_ORG_Admin ");
        sql.append("WHERE ");
        sql.append(this.getAdminWhereSql("FID", "FLongNumber", adminInfo));
        if (!showVirtualOrg) {
            sql.append(" AND FIsVirtual = 0");
        }
        return DbUtil.executeQuery((Context)ctx, (String)sql.toString());
    }

    private IRowSet getAdminOrgUnits(Context ctx, AdminOrgUnitInfo adminInfo, boolean showVirtualOrg, int level) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        int levelStop = adminInfo.getLevel() + level;
        sql.append("SELECT FLongNumber FROM T_ORG_Admin ");
        sql.append("WHERE ");
        sql.append(this.getAdminWhereSql("FID", "FLongNumber", adminInfo));
        if (!showVirtualOrg) {
            sql.append(" AND FIsVirtual = 0");
        }
        sql.append(" and T_ORG_Admin.FLevel <=" + levelStop);
        return DbUtil.executeQuery((Context)ctx, (String)sql.toString());
    }

    private List getPersonData(Context ctx, AdminOrgUnitInfo adminInfo, PersonPlanSchemeInfo schemeInfo, int level, boolean showVirtualOrg) throws BOSException, EASBizException {
        DefaultKingdeeTreeNode root;
        HashMap nodeMap = (HashMap)adminInfo.get("NodeMap");
        this.rootForAdmin = root = (DefaultKingdeeTreeNode)nodeMap.get(adminInfo.getId().toString());
        if (root == null) {
            return null;
        }
        this.levelOfRoot = root.getLevel();
        AdminOrgUnitCollection col = new AdminOrgUnitCollection();
        if (!Boolean.valueOf(schemeInfo.get("isOrgMulti").toString()).booleanValue()) {
            this.buildAdminNode(col, root, showVirtualOrg, level);
        } else {
            this.buildAdminNode(col, root, showVirtualOrg);
        }
        String where = this.getWhereStr(adminInfo, col);
        int startYear = schemeInfo.getStartYear();
        int startMonth = schemeInfo.getStartMonth();
        int endYear = schemeInfo.getEndYear();
        int endMonth = schemeInfo.getEndMonth();
        Period period = schemeInfo.getPeriod();
        String startDate = this.getStartDateStr(startYear, startMonth, period);
        String endDate = this.getEndDateStr(endYear, endMonth, period);
        ArrayList<PersonPlanRowInfo> list = new ArrayList<PersonPlanRowInfo>(col.size());
        PersonPlanRowInfo sumRow = null;
        PersonPlanRowInfo selfRow = null;
        PersonPlanRowInfo sumSubRow = null;
        IRowSet planRows = null;
        IRowSet planRow = null;
        schemeInfo.put("realPlanType", (Object)PersonPlanType.PERSON);
        IRowSet actualRows = this.getActualSelf(ctx, startDate, endDate, where, schemeInfo, false, false);
        IRowSet actualSelfRows = this.getPersonActualSelf(ctx, startDate, endDate, where, schemeInfo);
        int colCount = this.getColumnCount(period, startYear, startMonth, endYear, endMonth);
        planRow = this.getPlanOfAdminOrg(ctx, schemeInfo, startYear, endYear, adminInfo, level, showVirtualOrg, true);
        IRowSet adminRows = this.getAdminOrgUnits(ctx, adminInfo, showVirtualOrg, level);
        planRows = this.getAdminSumData(planRow, adminRows);
        AdminOrgUnitInfo unitInfo = null;
        int baseLevel = 0;
        int tempLevel = 0;
        boolean isLeaf = false;
        schemeInfo.put("rowType", "actualRows");
        HashMap actualDataMap = this.getActualDataMap2(schemeInfo, actualRows);
        schemeInfo.put("rowType", "actualSelfRows");
        HashMap actualSelfDataMap = this.getActualDataMap2(schemeInfo, actualSelfRows);
        HashMap planDataMap = this.getPlanDataMap(schemeInfo, planRows);
        HashMap planSelfDataMap = this.getPlanDataMap(schemeInfo, planRow);
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            sumRow = new PersonPlanRowInfo();
            unitInfo = col.get(i);
            if (i == 0) {
                baseLevel = unitInfo.getLevel();
            } else {
                tempLevel = unitInfo.getLevel() - baseLevel;
                unitInfo.setLevel(unitInfo.getLevel() + tempLevel);
                isLeaf = !Boolean.valueOf(schemeInfo.get("isOrgMulti").toString()).booleanValue() ? (level == 100 ? unitInfo.isIsLeaf() : (level - tempLevel == 0 ? true : unitInfo.isIsLeaf())) : (level - tempLevel == 1 ? true : unitInfo.isIsLeaf());
            }
            sumRow.adminInfo = unitInfo;
            sumRow.detailList = this.getColListByPeriod2(actualDataMap, planDataMap, startYear, startMonth, colCount, schemeInfo, unitInfo.getId().toString(), unitInfo.getLongNumber(), false);
            list.add(sumRow);
            if (unitInfo.isIsLeaf()) continue;
            selfRow = new PersonPlanRowInfo();
            selfRow.adminInfo = this.createBlankOrg(unitInfo.getLevel() + 1, true, "@SELF_ORG@");
            selfRow.detailList = this.getColListByPeriod2(actualSelfDataMap, planSelfDataMap, startYear, startMonth, colCount, schemeInfo, unitInfo.getId().toString(), null, true);
            list.add(selfRow);
            sumSubRow = new PersonPlanRowInfo();
            sumSubRow.adminInfo = this.createBlankOrg(unitInfo.getLevel() + 1, isLeaf, "@CHILDREN_ORG@");
            sumSubRow.detailList = this.getSubRowColList(sumRow.detailList, selfRow.detailList);
            list.add(sumSubRow);
        }
        return list;
    }

    private List getSubRowColList(List sumRow, List selfRow) {
        int size = sumRow.size();
        ArrayList<PlanActualInfo> colList = new ArrayList<PlanActualInfo>(size);
        PlanActualInfo paInfo = null;
        PlanActualInfo sumRowInfo = null;
        PlanActualInfo selfRowInfo = null;
        for (int i = 0; i < size; ++i) {
            paInfo = new PlanActualInfo();
            sumRowInfo = (PlanActualInfo)sumRow.get(i);
            selfRowInfo = (PlanActualInfo)selfRow.get(i);
            paInfo.actualCount = sumRowInfo.actualCount - selfRowInfo.actualCount;
            paInfo.planCount = sumRowInfo.planCount - selfRowInfo.planCount;
            paInfo.difference = sumRowInfo.difference - selfRowInfo.difference;
            colList.add(paInfo);
        }
        return colList;
    }

    private HashMap getPositionByAdmin(Context ctx, AdminOrgUnitInfo adminInfo, PersonPlanSchemeInfo schemeInfo, boolean isInvalidPosition, boolean showVirtualOrg) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT P.FID id,P.FName_");
        sql.append(ctx.getLocale());
        sql.append(" name,P.FAdminOrgUnitID adminId FROM T_ORG_Position P, T_ORG_Admin A WHERE P.FAdminOrgUnitID=A.FID ");
        sql.append(" AND  ");
        sql.append(this.getAdminWhereSql("A.FID", "A.FLongNumber", adminInfo));
        sql.append(" ");
        sql.append(" AND (P.FID IN (SELECT FPositionID FROM T_HR_PersonPlan WHERE FSchemeID = '");
        sql.append(schemeInfo.getId().toString());
        sql.append("'))");
        if (!isInvalidPosition) {
            sql.append(" and P.FDeletedStatus = 1");
        }
        if (!showVirtualOrg) {
            sql.append(" AND A.FIsVirtual = 0");
        }
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashMap<String, ArrayList> map = new HashMap<String, ArrayList>();
        try {
            String adminId = null;
            while (rows.next()) {
                ArrayList list;
                adminId = rows.getString("adminId");
                PositionInfo info = new PositionInfo();
                info.setId(BOSUuid.read((String)rows.getString("id")));
                info.setName(rows.getString("name"));
                if (map.get(adminId) == null) {
                    list = new ArrayList();
                    list.add(info);
                    map.put(adminId, list);
                    continue;
                }
                list = (ArrayList)map.get(adminId);
                list.add(info);
                map.put(adminId, list);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return map;
    }

    private HashMap getActualDataMap(PersonPlanSchemeInfo schemeInfo, IRowSet actualDataRows) throws BOSException, EASBizException {
        HashMap<String, Integer> actualDataMap = new HashMap<String, Integer>();
        try {
            StringBuffer key = null;
            actualDataRows.beforeFirst();
            while (actualDataRows.next()) {
                key = schemeInfo.getPlanType() == PersonPlanType.JOB ? new StringBuffer() : new StringBuffer(actualDataRows.getString("FAdminOrgID"));
                key.append(actualDataRows.getString("ObjID")).append(actualDataRows.getInt("FYear"));
                if (schemeInfo.getPeriod() == Period.MONTH) {
                    key.append(actualDataRows.getInt("FMonth"));
                } else if (schemeInfo.getPeriod() == Period.QUARTER) {
                    key.append(actualDataRows.getInt("FQuarter"));
                } else if (schemeInfo.getPeriod() == Period.HALF_YEAR) {
                    key.append(actualDataRows.getInt("FHalfYear"));
                }
                actualDataMap.put(key.toString(), actualDataRows.getInt("Count"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return actualDataMap;
    }

    private HashMap getActualDataMap2(PersonPlanSchemeInfo schemeInfo, IRowSet actualDataRows) throws BOSException, EASBizException {
        HashMap<String, Integer> actualDataMap = new HashMap<String, Integer>();
        HashMap<String, Integer> actualDataOfAdminMap = new HashMap<String, Integer>();
        try {
            StringBuffer key = null;
            actualDataRows.beforeFirst();
            while (actualDataRows.next()) {
                key = schemeInfo.getPlanType() == PersonPlanType.JOB ? new StringBuffer() : new StringBuffer(actualDataRows.getString("FAdminOrgID"));
                key.append(actualDataRows.getString("ObjID")).append(actualDataRows.getInt("FYear"));
                if (schemeInfo.getPeriod() == Period.MONTH) {
                    key.append(actualDataRows.getInt("FMonth"));
                } else if (schemeInfo.getPeriod() == Period.QUARTER) {
                    key.append(actualDataRows.getInt("FQuarter"));
                } else if (schemeInfo.getPeriod() == Period.HALF_YEAR) {
                    key.append(actualDataRows.getInt("FHalfYear"));
                }
                if ((schemeInfo.get("rowType").toString().equals("actualRows") || schemeInfo.get("rowType").toString().equals("adminActualRows")) && !Boolean.valueOf(schemeInfo.get("isOrgMulti").toString()).booleanValue()) {
                    key = schemeInfo.getPlanType() == PersonPlanType.JOB ? new StringBuffer() : new StringBuffer(actualDataRows.getString("FAdminOrgID"));
                    key.append("&!" + actualDataRows.getString("ObjID")).append("&!" + actualDataRows.getInt("FYear"));
                    if (schemeInfo.getPeriod() == Period.MONTH) {
                        key.append("&!" + actualDataRows.getInt("FMonth"));
                    } else if (schemeInfo.getPeriod() == Period.QUARTER) {
                        key.append("&!" + actualDataRows.getInt("FQuarter"));
                    } else if (schemeInfo.getPeriod() == Period.HALF_YEAR) {
                        key.append("&!" + actualDataRows.getInt("FHalfYear"));
                    }
                    actualDataOfAdminMap.put(key.toString(), new Integer(actualDataRows.getInt("Count")));
                    continue;
                }
                actualDataMap.put(key.toString(), new Integer(actualDataRows.getInt("Count")));
            }
            if ((schemeInfo.get("rowType").toString().equals("actualRows") || schemeInfo.get("rowType").toString().equals("adminActualRows")) && !Boolean.valueOf(schemeInfo.get("isOrgMulti").toString()).booleanValue()) {
                this.setGatherValue(actualDataOfAdminMap, actualDataMap, this.rootForAdmin);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return actualDataMap;
    }

    private void setActualDataMap(PersonPlanSchemeInfo schemeInfo, IRowSet positionActualDataRows, HashMap posiMaps, HashMap posiActualDataMap, HashMap adminActualDataMap) throws BOSException, EASBizException {
        HashMap<String, Integer> actualDataOfAdminMap = new HashMap<String, Integer>();
        try {
            String orgIDStr = null;
            String positionIDStr = null;
            StringBuffer key = null;
            StringBuffer keyOfAdmin = null;
            positionActualDataRows.beforeFirst();
            ArrayList positionList = null;
            while (positionActualDataRows.next()) {
                key = new StringBuffer(positionActualDataRows.getString("FAdminOrgID"));
                orgIDStr = key.toString();
                key.append(positionActualDataRows.getString("ObjID")).append(positionActualDataRows.getInt("FYear"));
                positionIDStr = positionActualDataRows.getString("ObjID");
                if (schemeInfo.getPeriod() == Period.MONTH) {
                    key.append(positionActualDataRows.getInt("FMonth"));
                } else if (schemeInfo.getPeriod() == Period.QUARTER) {
                    key.append(positionActualDataRows.getInt("FQuarter"));
                } else if (schemeInfo.getPeriod() == Period.HALF_YEAR) {
                    key.append(positionActualDataRows.getInt("FHalfYear"));
                }
                keyOfAdmin = new StringBuffer(positionActualDataRows.getString("FAdminOrgID"));
                keyOfAdmin.append("&!temp").append("&!" + positionActualDataRows.getInt("FYear"));
                if (schemeInfo.getPeriod() == Period.MONTH) {
                    keyOfAdmin.append("&!" + positionActualDataRows.getInt("FMonth"));
                } else if (schemeInfo.getPeriod() == Period.QUARTER) {
                    keyOfAdmin.append("&!" + positionActualDataRows.getInt("FQuarter"));
                } else if (schemeInfo.getPeriod() == Period.HALF_YEAR) {
                    keyOfAdmin.append("&!" + positionActualDataRows.getInt("FHalfYear"));
                }
                if (!this.positionListContains(positionList = (ArrayList)posiMaps.get(orgIDStr), positionIDStr)) continue;
                posiActualDataMap.put(key.toString(), new Integer(positionActualDataRows.getInt("Count")));
                Integer countOfAdmin = (Integer)actualDataOfAdminMap.get(keyOfAdmin.toString());
                if (countOfAdmin == null) {
                    countOfAdmin = new Integer(0);
                }
                countOfAdmin = new Integer(countOfAdmin + new Integer(positionActualDataRows.getInt("Count")));
                actualDataOfAdminMap.put(keyOfAdmin.toString(), countOfAdmin);
            }
            this.setGatherValue(actualDataOfAdminMap, adminActualDataMap, this.rootForAdmin);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private boolean positionListContains(ArrayList positionList, String positionIDStr) {
        if (positionList == null) {
            return false;
        }
        int count = positionList.size();
        for (int i = 0; i < count; ++i) {
            if (!((PositionInfo)positionList.get(i)).getId().toString().equals(positionIDStr)) continue;
            return true;
        }
        return false;
    }

    private void setGatherValue(HashMap actualDataOfAdminMap, HashMap actualDataMap, DefaultKingdeeTreeNode rootNode) {
        Object[] keys = actualDataOfAdminMap.keySet().toArray();
        AdminOrgUnitInfo adminInfo = (AdminOrgUnitInfo)rootNode.getUserObject();
        int allChildSum = 0;
        boolean isContain = false;
        ArrayList<String[]> thisKeyIndexs = new ArrayList<String[]>();
        String[] componentOfKey = null;
        for (int i = 0; i < keys.length; ++i) {
            componentOfKey = keys[i].toString().split("&!");
            if (this.containKey(thisKeyIndexs, componentOfKey)) continue;
            isContain = true;
            thisKeyIndexs.add(componentOfKey);
        }
        if (!isContain) {
            return;
        }
        Integer count = null;
        String searchKey = null;
        String finalKey = null;
        int count2 = thisKeyIndexs.size();
        for (int j = 0; j < count2; ++j) {
            allChildSum = 0;
            componentOfKey = (String[])thisKeyIndexs.get(j);
            for (int i = 0; i < rootNode.getChildCount(); ++i) {
                allChildSum += this.setGatherValueChild(actualDataOfAdminMap, actualDataMap, (DefaultKingdeeTreeNode)rootNode.getChildAt(i), componentOfKey);
            }
            searchKey = finalKey = adminInfo.getId().toString();
            for (int k = 1; k < componentOfKey.length; ++k) {
                searchKey = searchKey + "&!" + componentOfKey[k];
                finalKey = finalKey + componentOfKey[k];
            }
            count = (Integer)actualDataOfAdminMap.get(searchKey);
            if (count == null) {
                count = new Integer(0);
            }
            actualDataMap.put(finalKey, new Integer(count + allChildSum));
        }
    }

    private int setGatherValueChild(HashMap actualDataOfAdminMap, HashMap actualDataMap, DefaultKingdeeTreeNode rootNode, String[] componentOfKey) {
        Integer count;
        String searchKey;
        AdminOrgUnitInfo adminInfo = (AdminOrgUnitInfo)rootNode.getUserObject();
        int sumOfChild = 0;
        for (int i = 0; i < rootNode.getChildCount(); ++i) {
            sumOfChild += this.setGatherValueChild(actualDataOfAdminMap, actualDataMap, (DefaultKingdeeTreeNode)rootNode.getChildAt(i), componentOfKey);
        }
        String finalKey = searchKey = adminInfo.getId().toString();
        for (int i = 1; i < componentOfKey.length; ++i) {
            searchKey = searchKey + "&!" + componentOfKey[i];
            finalKey = finalKey + componentOfKey[i];
        }
        if (componentOfKey[0].equals(adminInfo.getId().toString()) && (count = (Integer)actualDataOfAdminMap.get(searchKey)) != null) {
            sumOfChild += count.intValue();
        }
        if (sumOfChild != 0) {
            actualDataMap.put(finalKey, new Integer(sumOfChild));
        }
        return sumOfChild;
    }

    private HashMap getPlanDataMap(PersonPlanSchemeInfo schemeInfo, IRowSet planDataRows) throws BOSException, EASBizException {
        HashMap<String, Integer> planDataMap = new HashMap<String, Integer>();
        try {
            StringBuffer key = null;
            planDataRows.beforeFirst();
            while (planDataRows.next()) {
                key = new StringBuffer();
                if (schemeInfo.getPlanType() == PersonPlanType.PERSON) {
                    key.append(planDataRows.getString("FAdminOrgID"));
                } else if (schemeInfo.getPlanType() == PersonPlanType.POSITION) {
                    key.append(planDataRows.getString("FPositionID"));
                } else if (schemeInfo.getPlanType() == PersonPlanType.JOB) {
                    key.append(planDataRows.getString("FJobID"));
                }
                key.append(planDataRows.getString("FYear"));
                for (int i = 1; i <= 12; ++i) {
                    planDataMap.put(key.toString() + i, planDataRows.getInt(i));
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return planDataMap;
    }

    private List getColListByPeriod2(HashMap actualMap, HashMap planMap, int startYear, int startMonth, int colCount, PersonPlanSchemeInfo schemeInfo, String orgId, String objId, boolean isSelf) throws BOSException, EASBizException {
        PlanActualInfo paInfo = null;
        ArrayList<PlanActualInfo> colList = new ArrayList<PlanActualInfo>(colCount);
        Period period = schemeInfo.getPeriod();
        int actualMonth = 0;
        int planMonth = 0;
        int tempYear = startYear;
        int t = startMonth;
        for (int j = 0; j < colCount; ++j) {
            paInfo = new PlanActualInfo();
            actualMonth = t + 1;
            startYear = tempYear++;
            if (period == Period.MONTH) {
                planMonth = t + 1;
                t = t == 11 ? 0 : ++t;
            } else if (period == Period.QUARTER) {
                planMonth = (t + 1) * 3;
                if (t == 3) {
                    t = 0;
                    ++tempYear;
                } else {
                    ++t;
                }
            } else if (period == Period.HALF_YEAR) {
                planMonth = (t + 1) * 6;
                if (t == 1) {
                    t = 0;
                    ++tempYear;
                } else {
                    ++t;
                }
            } else if (period == Period.YEAR) {
                actualMonth = 12;
                planMonth = 12;
                ++tempYear;
            }
            Object obj = null;
            if (isSelf) {
                obj = planMap.get(orgId + startYear + planMonth);
                paInfo.planCount = obj == null ? 0 : (Integer)obj;
                obj = schemeInfo.getPlanType() == PersonPlanType.PERSON ? (period == Period.YEAR ? actualMap.get(orgId + "temp" + startYear) : actualMap.get(orgId + "temp" + startYear + actualMonth)) : (period == Period.YEAR ? actualMap.get(orgId + objId + startYear) : actualMap.get(orgId + objId + startYear + actualMonth));
                paInfo.actualCount = obj == null ? 0 : (Integer)obj;
            } else {
                obj = planMap.get(objId + startYear + planMonth);
                paInfo.planCount = obj == null ? 0 : (Integer)obj;
                obj = schemeInfo.getPlanType() == PersonPlanType.PERSON ? (period == Period.YEAR ? actualMap.get(orgId + "temp" + startYear) : actualMap.get(orgId + "temp" + startYear + actualMonth)) : (schemeInfo.getPlanType() == PersonPlanType.POSITION ? (period == Period.YEAR ? actualMap.get(orgId + objId + startYear) : actualMap.get(orgId + objId + startYear + actualMonth)) : (period == Period.YEAR ? actualMap.get(objId + startYear) : actualMap.get(objId + startYear + actualMonth)));
                paInfo.actualCount = obj == null ? 0 : (Integer)obj;
            }
            paInfo.difference = paInfo.actualCount - paInfo.planCount;
            colList.add(paInfo);
        }
        return colList;
    }

    private List getPositionData(Context ctx, AdminOrgUnitInfo adminInfo, PersonPlanSchemeInfo schemeInfo, int level, boolean isInvalidPosition, boolean showVirtualOrg) throws BOSException, EASBizException {
        HashMap nodeMap = (HashMap)adminInfo.get("NodeMap");
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)nodeMap.get(adminInfo.getId().toString());
        if (root == null) {
            return null;
        }
        this.rootForAdmin = root;
        AdminOrgUnitCollection col = new AdminOrgUnitCollection();
        this.levelOfRoot = root.getLevel();
        if (!Boolean.valueOf(schemeInfo.get("isOrgMulti").toString()).booleanValue()) {
            this.buildAdminNode(col, root, showVirtualOrg, level);
        } else {
            this.buildAdminNode(col, root, showVirtualOrg);
        }
        String where = this.getWhereStr(adminInfo, col);
        int startYear = schemeInfo.getStartYear();
        int startMonth = schemeInfo.getStartMonth();
        int endYear = schemeInfo.getEndYear();
        int endMonth = schemeInfo.getEndMonth();
        Period period = schemeInfo.getPeriod();
        String startDate = this.getStartDateStr(startYear, startMonth, period);
        String endDate = this.getEndDateStr(endYear, endMonth, period);
        ArrayList<PersonPlanRowInfo> list = new ArrayList<PersonPlanRowInfo>(col.size());
        PersonPlanRowInfo adminRow = null;
        PersonPlanRowInfo posiRow = null;
        IRowSet posiPlanRows = null;
        IRowSet adminPlanRows = null;
        IRowSet posiActualRows = null;
        int colCount = 0;
        AdminOrgUnitInfo unitInfo = null;
        IRowSet planRow = null;
        IRowSet adminRows = null;
        HashMap adminActualDataMap = new HashMap();
        HashMap posiActualDataMap = new HashMap();
        ArrayList posiList = null;
        PositionInfo pInfo = null;
        HashMap posiMaps = null;
        HashMap adminPlanDataMap = null;
        HashMap posiPlanDataMap = null;
        if (Boolean.valueOf(schemeInfo.get("isOrgMulti").toString()).booleanValue()) {
            posiPlanRows = this.getPlanByAdminOrg(ctx, schemeInfo, startYear, endYear, adminInfo, showVirtualOrg, isInvalidPosition);
            schemeInfo.setPlanType(PersonPlanType.PERSON);
            IRowSet adminActualRows = this.getPersonActual(ctx, startDate, endDate, where, schemeInfo);
            schemeInfo.setPlanType(PersonPlanType.POSITION);
            colCount = this.getColumnCount(period, startYear, startMonth, endYear, endMonth);
            schemeInfo.setPlanType(PersonPlanType.PERSON);
            planRow = this.getPlanOfAdminOrg(ctx, schemeInfo, startYear, endYear, adminInfo, level, showVirtualOrg, isInvalidPosition);
            adminRows = this.getAdminOrgUnits(ctx, adminInfo, showVirtualOrg);
            adminPlanRows = this.getAdminSumData(planRow, adminRows);
            schemeInfo.setPlanType(PersonPlanType.POSITION);
            posiActualRows = this.getPersonActual(ctx, startDate, endDate, where, schemeInfo);
            posiMaps = this.getPositionByAdmin(ctx, adminInfo, schemeInfo, isInvalidPosition, showVirtualOrg);
            adminActualDataMap = this.getActualDataMap(schemeInfo, adminActualRows);
            posiActualDataMap = this.getPlanDataMap(schemeInfo, posiPlanRows);
        } else {
            posiPlanRows = this.getPlanByAdminOrg(ctx, schemeInfo, startYear, endYear, adminInfo, showVirtualOrg, level, isInvalidPosition);
            schemeInfo.setPlanType(PersonPlanType.POSITION);
            colCount = this.getColumnCount(period, startYear, startMonth, endYear, endMonth);
            schemeInfo.setPlanType(PersonPlanType.PERSON);
            planRow = this.getPlanOfAdminOrg(ctx, schemeInfo, startYear, endYear, adminInfo, level, showVirtualOrg, isInvalidPosition);
            adminRows = this.getAdminOrgUnits(ctx, adminInfo, showVirtualOrg, level);
            adminPlanRows = this.getAdminSumData(planRow, adminRows);
            schemeInfo.setPlanType(PersonPlanType.POSITION);
            posiActualRows = this.getActualSelf(ctx, startDate, endDate, where, schemeInfo, isInvalidPosition, false);
            posiMaps = this.getPositionByAdmin(ctx, adminInfo, schemeInfo, isInvalidPosition, showVirtualOrg);
            this.setActualDataMap(schemeInfo, posiActualRows, posiMaps, posiActualDataMap, adminActualDataMap);
        }
        schemeInfo.setPlanType(PersonPlanType.PERSON);
        adminPlanDataMap = this.getPlanDataMap(schemeInfo, adminPlanRows);
        schemeInfo.setPlanType(PersonPlanType.POSITION);
        posiPlanDataMap = this.getPlanDataMap(schemeInfo, posiPlanRows);
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            adminRow = new PersonPlanRowInfo();
            unitInfo = col.get(i);
            posiList = (ArrayList)posiMaps.get(unitInfo.getId().toString());
            if (posiList != null && posiList.size() > 0) {
                unitInfo.setIsLeaf(false);
            } else if (unitInfo.getLevel() == adminInfo.getLevel() + level - 1) {
                unitInfo.setIsLeaf(true);
            }
            adminRow.adminInfo = unitInfo;
            schemeInfo.setPlanType(PersonPlanType.PERSON);
            adminRow.detailList = this.getColListByPeriod2(adminActualDataMap, adminPlanDataMap, startYear, startMonth, colCount, schemeInfo, unitInfo.getId().toString(), unitInfo.getLongNumber(), false);
            schemeInfo.setPlanType(PersonPlanType.POSITION);
            list.add(adminRow);
            if (posiList == null) continue;
            int length = posiList.size();
            for (int t = 0; t < length; ++t) {
                posiRow = new PersonPlanRowInfo();
                posiRow.adminInfo = this.createBlankOrg(unitInfo.getLevel() + 1, true, "");
                pInfo = (PositionInfo)posiList.get(t);
                posiRow.objName = pInfo.getName();
                posiRow.detailList = this.getColListByPeriod2(posiActualDataMap, posiPlanDataMap, startYear, startMonth, colCount, schemeInfo, unitInfo.getId().toString(), pInfo.getId().toString(), false);
                list.add(posiRow);
            }
        }
        return list;
    }

    private List getJobData(Context ctx, AdminOrgUnitInfo adminInfo, PersonPlanSchemeInfo schemeInfo, int level, boolean showVirtualOrg, boolean isShowDisableJob) throws BOSException, EASBizException {
        HashMap nodeMap = (HashMap)adminInfo.get("NodeMap");
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)nodeMap.get(adminInfo.getId().toString());
        if (root == null) {
            return null;
        }
        this.rootForAdmin = root;
        AdminOrgUnitCollection col = new AdminOrgUnitCollection();
        this.levelOfRoot = root.getLevel();
        if (!Boolean.valueOf(schemeInfo.get("isOrgMulti").toString()).booleanValue()) {
            this.buildAdminNode(col, root, showVirtualOrg, level);
        } else {
            this.buildAdminNode(col, root, showVirtualOrg);
        }
        String where = this.getWhereStr(adminInfo, col);
        int startYear = schemeInfo.getStartYear();
        int startMonth = schemeInfo.getStartMonth();
        int endYear = schemeInfo.getEndYear();
        int endMonth = schemeInfo.getEndMonth();
        Period period = schemeInfo.getPeriod();
        String startDate = this.getStartDateStr(startYear, startMonth, period);
        String endDate = this.getEndDateStr(endYear, endMonth, period);
        IRowSet jobRowsTemp = this.getJobsByAdminOrg(ctx, adminInfo, showVirtualOrg, isShowDisableJob);
        ArrayList jobList = this.getJobList(jobRowsTemp);
        ArrayList<PersonPlanRowInfo> list = new ArrayList<PersonPlanRowInfo>(jobList.size());
        PersonPlanRowInfo row = null;
        IRowSet planRows = null;
        IRowSet rows = this.getActualSelf(ctx, startDate, endDate, where, schemeInfo, false, isShowDisableJob);
        planRows = this.getPlanByAdminOrg(ctx, schemeInfo, startYear, endYear, adminInfo, showVirtualOrg, level, true);
        int colCount = this.getColumnCount(period, startYear, startMonth, endYear, endMonth);
        schemeInfo.put("rowType", "rows");
        HashMap actualDataMap = this.getActualDataMap(schemeInfo, rows);
        schemeInfo.put("rowType", "planRows");
        HashMap planDataMap = this.getPlanDataMap(schemeInfo, planRows);
        int count = jobList.size();
        for (int i = 0; i < count; ++i) {
            String[] jobData = (String[])jobList.get(i);
            row = new PersonPlanRowInfo();
            row.objName = jobData[1];
            row.detailList = this.getColListByPeriod2(actualDataMap, planDataMap, startYear, startMonth, colCount, schemeInfo, null, jobData[0], false);
            list.add(row);
        }
        return list;
    }

    private int getColumnCount(Period period, int startYear, int startMonth, int endYear, int endMonth) {
        int startMonthCount = 0;
        int endMonthCount = 0;
        int colmnLength = 0;
        if (period == Period.MONTH) {
            startMonthCount = startYear * 12 + startMonth + 1;
            endMonthCount = endYear * 12 + endMonth + 1;
            colmnLength = endMonthCount - startMonthCount + 1;
        } else if (period == Period.QUARTER) {
            startMonthCount = startYear * 4 + startMonth + 1;
            endMonthCount = endYear * 4 + endMonth + 1;
            colmnLength = endMonthCount - startMonthCount + 1;
        } else if (period == Period.HALF_YEAR) {
            startMonthCount = startYear * 2 + startMonth + 1;
            endMonthCount = endYear * 2 + endMonth + 1;
            colmnLength = endMonthCount - startMonthCount + 1;
        } else if (period == Period.YEAR) {
            colmnLength = endYear - startYear + 1;
        }
        return colmnLength;
    }

    private String getStartDateStr(int year, int month, Period period) {
        GregorianCalendar startDate = null;
        startDate = period == Period.MONTH ? new GregorianCalendar(year, month, 1) : (period == Period.QUARTER ? new GregorianCalendar(year, (month + 1) * 3 - 3, 1) : (period == Period.HALF_YEAR ? new GregorianCalendar(year, (month + 1) * 6 - 6, 1) : new GregorianCalendar(year, 0, 1)));
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        return format.format(startDate.getTime());
    }

    private String getEndDateStr(int year, int month, Period period) {
        GregorianCalendar startDate = null;
        startDate = period == Period.MONTH ? new GregorianCalendar(year, month, 1) : (period == Period.QUARTER ? new GregorianCalendar(year, (month + 1) * 3 - 1, 1) : (period == Period.HALF_YEAR ? new GregorianCalendar(year, (month + 1) * 6 - 1, 1) : new GregorianCalendar(year, 11, 1)));
        startDate.set(5, startDate.getActualMaximum(5));
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        return format.format(startDate.getTime());
    }

    private String getWhereStr(AdminOrgUnitInfo adminInfo, AdminOrgUnitCollection col) {
        StringBuffer inStr = new StringBuffer(" IN ( '");
        inStr.append(adminInfo.getId());
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            inStr.append("', '");
            inStr.append(col.get(i).getId());
        }
        inStr.append("') ");
        return inStr.toString();
    }

    private IRowSet getPersonActualSelf(Context ctx, String startDate, String endDate, String where, PersonPlanSchemeInfo schemeInfo) throws BOSException, EASBizException {
        Period period = schemeInfo.getPeriod();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FYear,FHalfYear,FQuarter,FMonth,FAdminOrgID,'temp' ObjID,SUM(FCount) Count ");
        sql.append("FROM( SELECT FID, FYear,FHalfYear,FQuarter, FMonth ");
        sql.append("      FROM T_HR_PersonFixedTime  ");
        sql.append("      WHERE( FFixedTime IN ");
        sql.append("             ( SELECT MAX(FFixedTime) AS FFixedTime  ");
        sql.append("               FROM T_HR_PersonFixedTime  ");
        sql.append("               WHERE FIsSuccess = 1 AND (FFixedTime >= {ts'");
        sql.append(startDate);
        sql.append("'} AND FFixedTime <= {ts'");
        sql.append(endDate);
        sql.append("'} ) ");
        if (period == Period.MONTH) {
            sql.append("               GROUP BY FYear, FMonth ");
        } else if (period == Period.QUARTER) {
            sql.append("               GROUP BY FYear, FQuarter ");
        } else if (period == Period.HALF_YEAR) {
            sql.append("               GROUP BY FYear, FHalfYear ");
        } else if (period == Period.YEAR) {
            sql.append("               GROUP BY FYear ");
        }
        sql.append("              )");
        sql.append("           )");
        sql.append("     )A INNER JOIN  ");
        sql.append("      T_HR_PersonFixedHistory B ON A.FID = B.FFixedTimeID ");
        sql.append("WHERE B.FAdminOrgID ");
        sql.append(where);
        sql.append(" GROUP BY FYear,FHalfYear,FQuarter,FMonth,FAdminOrgID");
        return DbUtil.executeQuery((Context)ctx, (String)sql.toString());
    }

    private IRowSet getPersonActual(Context ctx, String startDate, String endDate, String where, PersonPlanSchemeInfo schemeInfo) throws BOSException, EASBizException {
        Period period = schemeInfo.getPeriod();
        StringBuffer sql = new StringBuffer();
        if (schemeInfo.getPlanType() == PersonPlanType.PERSON) {
            sql.append("SELECT FYear,FHalfYear,FQuarter,FMonth,FAdminOrgID,'temp' ObjID, FCount Count ");
        } else if (schemeInfo.getPlanType() == PersonPlanType.POSITION) {
            sql.append("SELECT FYear,FHalfYear,FQuarter,FMonth,FAdminOrgID,FPositionID ObjID,FCount Count ");
        } else {
            sql.append("SELECT FYear,FHalfYear,FQuarter,FMonth,FJobID ObjID,SUM(FCount) Count ");
        }
        sql.append("FROM( SELECT FID, FYear,FHalfYear,FQuarter, FMonth ");
        sql.append("      FROM T_HR_PersonFixedTime  ");
        sql.append("      WHERE( FFixedTime IN ");
        sql.append("             ( SELECT MAX(FFixedTime) AS FFixedTime  ");
        sql.append("               FROM T_HR_PersonFixedTime  ");
        sql.append("               WHERE FIsSuccess = 1 AND (FFixedTime >= {ts'");
        sql.append(startDate);
        sql.append("'} AND FFixedTime <= {ts'");
        sql.append(endDate);
        sql.append("'} ) ");
        if (period == Period.MONTH) {
            sql.append("               GROUP BY FYear, FMonth ");
        } else if (period == Period.QUARTER) {
            sql.append("               GROUP BY FYear, FQuarter ");
        } else if (period == Period.HALF_YEAR) {
            sql.append("               GROUP BY FYear, FHalfYear ");
        } else if (period == Period.YEAR) {
            sql.append("               GROUP BY FYear ");
        }
        sql.append("              )");
        sql.append("           )");
        sql.append("     )A INNER JOIN  ");
        if (schemeInfo.getPlanType() == PersonPlanType.PERSON) {
            sql.append("      T_HR_PersonFixedHistory2 B ON A.FID = B.FFixedTimeID ");
            sql.append("WHERE B.FAdminOrgID ");
            sql.append(where);
        } else if (schemeInfo.getPlanType() == PersonPlanType.POSITION) {
            sql.append("      T_HR_PersonFixedHistory B ON A.FID = B.FFixedTimeID ");
            sql.append("WHERE B.FAdminOrgID ");
            sql.append(where);
        } else {
            sql.append("      T_HR_PersonFixedHistory B ON A.FID = B.FFixedTimeID ");
            sql.append("WHERE B.FAdminOrgID ");
            sql.append(where);
            sql.append(" GROUP BY FYear,FHalfYear,FQuarter,FMonth,FJobID");
        }
        return DbUtil.executeQuery((Context)ctx, (String)sql.toString());
    }

    private IRowSet getActualSelf(Context ctx, String startDate, String endDate, String where, PersonPlanSchemeInfo schemeInfo, boolean isInvalidPosition, boolean isShowDisableJob) throws BOSException, EASBizException {
        Period period = schemeInfo.getPeriod();
        StringBuffer sql = new StringBuffer();
        if (!Boolean.valueOf(schemeInfo.get("isOrgMulti").toString()).booleanValue()) {
            if (schemeInfo.getPlanType() == PersonPlanType.PERSON) {
                sql.append("SELECT FYear,FHalfYear,FQuarter,FMonth,FAdminOrgID,'temp' ObjID, sum(FCount) Count ");
            } else if (schemeInfo.getPlanType() == PersonPlanType.POSITION) {
                sql.append("SELECT FYear,FHalfYear,FQuarter,FMonth,FAdminOrgID,FPositionID ObjID,FCount Count ");
            } else {
                sql.append("SELECT FYear,FHalfYear,FQuarter,FMonth,FJobID ObjID,SUM(FCount) Count ");
            }
        } else if (schemeInfo.getPlanType() == PersonPlanType.PERSON) {
            sql.append("SELECT FYear,FHalfYear,FQuarter,FMonth,FAdminOrgID,'temp' ObjID, FCount Count ");
        } else if (schemeInfo.getPlanType() == PersonPlanType.POSITION) {
            sql.append("SELECT FYear,FHalfYear,FQuarter,FMonth,FAdminOrgID,FPositionID ObjID,FCount Count ");
        } else {
            sql.append("SELECT FYear,FHalfYear,FQuarter,FMonth,FJobID ObjID,SUM(FCount) Count ");
        }
        sql.append("FROM( SELECT FID, FYear,FHalfYear,FQuarter, FMonth ");
        sql.append("      FROM T_HR_PersonFixedTime  ");
        sql.append("      WHERE( FFixedTime IN ");
        sql.append("             ( SELECT MAX(FFixedTime) AS FFixedTime  ");
        sql.append("               FROM T_HR_PersonFixedTime  ");
        sql.append("               WHERE FIsSuccess = 1 AND (FFixedTime >= {ts'");
        sql.append(startDate);
        sql.append("'} AND FFixedTime <= {ts'");
        sql.append(endDate);
        sql.append("'} ) ");
        if (period == Period.MONTH) {
            sql.append("               GROUP BY FYear, FMonth ");
        } else if (period == Period.QUARTER) {
            sql.append("               GROUP BY FYear, FQuarter ");
        } else if (period == Period.HALF_YEAR) {
            sql.append("               GROUP BY FYear, FHalfYear ");
        } else if (period == Period.YEAR) {
            sql.append("               GROUP BY FYear ");
        }
        sql.append("              )");
        sql.append("           )");
        sql.append("     )A INNER JOIN  ");
        if (schemeInfo.getPlanType() == PersonPlanType.PERSON) {
            if (!Boolean.valueOf(schemeInfo.get("isOrgMulti").toString()).booleanValue()) {
                sql.append("      T_HR_PersonFixedHistory B ON A.FID = B.FFixedTimeID ");
                if (schemeInfo.get("realPlanType") != PersonPlanType.PERSON) {
                    sql.append("INNER JOIN T_ORG_Position on T_ORG_Position.Fid = B.FPositionID ");
                }
            } else {
                sql.append("      T_HR_PersonFixedHistory2 B ON A.FID = B.FFixedTimeID ");
            }
            sql.append("WHERE B.FAdminOrgID ");
            sql.append(where);
            if (!Boolean.valueOf(schemeInfo.get("isOrgMulti").toString()).booleanValue()) {
                if (schemeInfo.get("realPlanType") != PersonPlanType.PERSON) {
                    sql.append(" and T_ORG_Position.FadminORGUnitID = B.FAdminOrgID");
                    sql.append(" AND ((T_ORG_Position.Fid IN (SELECT FPositionID FROM T_HR_PersonPlan WHERE FSchemeID = '" + schemeInfo.getId().toString() + "')) OR (T_ORG_Position.FDeletedStatus = 1))");
                }
                if (schemeInfo.get("realPlanType") != PersonPlanType.PERSON && !isInvalidPosition) {
                    sql.append(" and T_ORG_Position.FDeletedStatus = 1");
                }
                sql.append(" group by FYear,FHalfYear,FQuarter,FMonth,FAdminOrgID");
            }
        } else if (schemeInfo.getPlanType() == PersonPlanType.POSITION) {
            sql.append("      T_HR_PersonFixedHistory B ON A.FID = B.FFixedTimeID ");
            sql.append("WHERE B.FAdminOrgID ");
            sql.append(where);
        } else {
            sql.append("      T_HR_PersonFixedHistory B ON A.FID = B.FFixedTimeID ");
            if (!isShowDisableJob) {
                sql.append("INNER JOIN T_ORG_Job on T_ORG_Job.FID = B.FJobID");
            }
            sql.append(" WHERE B.FAdminOrgID ");
            sql.append(where);
            if (!isShowDisableJob) {
                sql.append(" and T_ORG_Job.FState = 1");
            }
            sql.append(" GROUP BY FYear,FHalfYear,FQuarter,FMonth,FJobID");
        }
        return DbUtil.executeQuery((Context)ctx, (String)sql.toString());
    }

    private IRowSet getPlanOfAdminOrg(Context ctx, PersonPlanSchemeInfo schemeInfo, int startYear, int endYear, AdminOrgUnitInfo adminInfo, int level, boolean showVirtualOrg, boolean isInvalidPosition) throws BOSException, EASBizException {
        int levelStop = adminInfo.getLevel() + level;
        StringBuffer sql = new StringBuffer();
        if (schemeInfo.getPlanType() == PersonPlanType.PERSON) {
            sql.append("SELECT  FPlan1, FPlan2 ,FPlan3,FPlan4,");
            sql.append("FPlan5, FPlan6, FPlan7, FPlan8,");
            sql.append("FPlan9, FPlan10,FPlan11,FPlan12,FYear,T_ORG_Admin.FId FAdminOrgID,FLongNumber ");
            sql.append("FROM  T_HR_PersonPlan  RIGHT OUTER JOIN T_ORG_Admin ");
            sql.append("ON T_HR_PersonPlan.FAdminOrgID = T_ORG_Admin.FId ");
            sql.append("LEFT JOIN T_ORG_Position ");
            sql.append("ON T_HR_PersonPlan.FPositionID = T_ORG_Position.FID ");
            sql.append("WHERE (");
            sql.append(this.getAdminWhereSql("T_ORG_Admin.FID", "FLongNumber", adminInfo));
            sql.append(") AND FYear >= ");
            sql.append(startYear);
            sql.append(" AND FYear <= ");
            sql.append(endYear);
            sql.append(" AND FSchemeID = '");
            sql.append(schemeInfo.getId());
            sql.append("'");
            if (!showVirtualOrg) {
                sql.append(" AND T_ORG_Admin.FIsVirtual = 0");
            }
            if (!isInvalidPosition) {
                sql.append(" AND T_ORG_Position.FDeletedStatus = 1");
            }
            if (!Boolean.valueOf(schemeInfo.get("isOrgMulti").toString()).booleanValue()) {
                sql.append(" and T_ORG_Admin.FLevel <= " + levelStop);
                if (schemeInfo.get("realPlanType") != PersonPlanType.PERSON) {
                    sql.append(" and T_ORG_Position.FadminORGUnitID = T_ORG_Admin.Fid");
                }
            }
        }
        return DbUtil.executeQuery((Context)ctx, (String)sql.toString());
    }

    private IRowSet getPlanByAdminOrg(Context ctx, PersonPlanSchemeInfo schemeInfo, int startYear, int endYear, AdminOrgUnitInfo adminInfo, boolean showVirtualOrg, boolean isInvalidPosition) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        if (schemeInfo.getPlanType() == PersonPlanType.PERSON) {
            sql.append("SELECT SUM(FPlan1), SUM(FPlan2) ,SUM(FPlan3), SUM(FPlan4),");
            sql.append("SUM(FPlan5), SUM(FPlan6), SUM( FPlan7), SUM(FPlan8),");
            sql.append("SUM(FPlan9), SUM(FPlan10),SUM(FPlan11),SUM(FPlan12),FYear ");
            sql.append("FROM  T_HR_PersonPlan  INNER JOIN T_ORG_Admin ");
            sql.append("ON T_HR_PersonPlan.FAdminOrgID = T_ORG_Admin.FId ");
            sql.append("WHERE ");
            sql.append(this.getAdminWhereSql("T_ORG_Admin.FID", "FLongNumber", adminInfo));
            sql.append(" AND FYear >= ");
            sql.append(startYear);
            sql.append(" AND FYear <= ");
            sql.append(endYear);
            sql.append(" AND FSchemeID = '");
            sql.append(schemeInfo.getId());
            sql.append("' ");
            if (!showVirtualOrg) {
                sql.append(" AND T_ORG_Admin.FIsVirtual = 0");
            }
            sql.append(" GROUP BY FYear");
        } else if (schemeInfo.getPlanType() == PersonPlanType.POSITION) {
            sql.append("SELECT FPlan1,FPlan2,FPlan3,FPlan4,FPlan5,FPlan6,FPlan7,");
            sql.append("FPlan8,FPlan9,FPlan10,FPlan11,FPlan12,FYear,FPositionID,T_HR_PersonPlan.FJobID ");
            sql.append("FROM  T_HR_PersonPlan  INNER JOIN T_ORG_Admin ");
            sql.append("ON T_HR_PersonPlan.FAdminOrgID = T_ORG_Admin.FId ");
            sql.append("LEFT JOIN T_ORG_Position ");
            sql.append("ON T_HR_PersonPlan.FPositionID = T_ORG_Position.FID ");
            sql.append("WHERE ");
            sql.append(this.getAdminWhereSql("T_ORG_Admin.FID", "FLongNumber", adminInfo));
            sql.append(" AND FYear >= ");
            sql.append(startYear);
            sql.append(" AND FYear <= ");
            sql.append(endYear);
            sql.append(" AND FSchemeID = '");
            sql.append(schemeInfo.getId());
            sql.append("' ");
            if (!showVirtualOrg) {
                sql.append(" AND T_ORG_Admin.FIsVirtual = 0");
            }
            if (!isInvalidPosition) {
                sql.append(" AND T_ORG_Position.FDeletedStatus = 1");
            }
        } else if (schemeInfo.getPlanType() == PersonPlanType.JOB) {
            sql.append("SELECT SUM(FPlan1), SUM(FPlan2) ,SUM(FPlan3), SUM(FPlan4),");
            sql.append(" SUM(FPlan5), SUM(FPlan6), SUM(FPlan7), SUM(FPlan8),");
            sql.append(" SUM(FPlan9), SUM(FPlan10),SUM(FPlan11),SUM(FPlan12),FYear,FJobID ");
            sql.append("FROM  T_HR_PersonPlan  INNER JOIN T_ORG_Admin ");
            sql.append("ON T_HR_PersonPlan.FAdminOrgID = T_ORG_Admin.FId ");
            sql.append("WHERE ");
            sql.append(this.getAdminWhereSql("T_ORG_Admin.FID", "FLongNumber", adminInfo));
            sql.append(" AND FYear >= ");
            sql.append(startYear);
            sql.append(" AND FYear <= ");
            sql.append(endYear);
            sql.append(" AND FSchemeID = '");
            sql.append(schemeInfo.getId());
            sql.append("' ");
            if (!showVirtualOrg) {
                sql.append(" AND T_ORG_Admin.FIsVirtual = 0");
            }
            sql.append("GROUP BY FJobID,FYear");
        }
        return DbUtil.executeQuery((Context)ctx, (String)sql.toString());
    }

    private IRowSet getPlanByAdminOrg(Context ctx, PersonPlanSchemeInfo schemeInfo, int startYear, int endYear, AdminOrgUnitInfo adminInfo, boolean showVirtualOrg, int level, boolean isInvalidPosition) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        int levelStop = adminInfo.getLevel() + level;
        if (schemeInfo.getPlanType() == PersonPlanType.PERSON) {
            sql.append("SELECT SUM(FPlan1), SUM(FPlan2) ,SUM(FPlan3), SUM(FPlan4),");
            sql.append("SUM(FPlan5), SUM(FPlan6), SUM( FPlan7), SUM(FPlan8),");
            sql.append("SUM(FPlan9), SUM(FPlan10),SUM(FPlan11),SUM(FPlan12),FYear ");
            sql.append("FROM  T_HR_PersonPlan  INNER JOIN T_ORG_Admin ");
            sql.append("ON T_HR_PersonPlan.FAdminOrgID = T_ORG_Admin.FId ");
            sql.append("WHERE ");
            sql.append(this.getAdminWhereSql("T_ORG_Admin.FID", "FLongNumber", adminInfo));
            sql.append(" AND FYear >= ");
            sql.append(startYear);
            sql.append(" AND FYear <= ");
            sql.append(endYear);
            sql.append(" AND FSchemeID = '");
            sql.append(schemeInfo.getId());
            sql.append("' ");
            if (!showVirtualOrg) {
                sql.append(" AND T_ORG_Admin.FIsVirtual = 0");
            }
            if (!Boolean.valueOf(schemeInfo.get("isOrgMulti").toString()).booleanValue()) {
                sql.append(" and T_ORG_Admin.FLevel <=" + levelStop);
            }
            sql.append(" GROUP BY FYear");
        } else if (schemeInfo.getPlanType() == PersonPlanType.POSITION) {
            sql.append("SELECT FPlan1,FPlan2,FPlan3,FPlan4,FPlan5,FPlan6,FPlan7,");
            sql.append("FPlan8,FPlan9,FPlan10,FPlan11,FPlan12,FYear,FPositionID,T_HR_PersonPlan.FJobID ");
            sql.append("FROM  T_HR_PersonPlan  INNER JOIN T_ORG_Admin ");
            sql.append("ON T_HR_PersonPlan.FAdminOrgID = T_ORG_Admin.FId ");
            sql.append("LEFT JOIN T_ORG_Position ");
            sql.append("ON T_HR_PersonPlan.FPositionID = T_ORG_Position.FID ");
            sql.append("WHERE ");
            sql.append(this.getAdminWhereSql("T_ORG_Admin.FID", "FLongNumber", adminInfo));
            sql.append(" AND FYear >= ");
            sql.append(startYear);
            sql.append(" AND FYear <= ");
            sql.append(endYear);
            sql.append(" AND FSchemeID = '");
            sql.append(schemeInfo.getId());
            sql.append("' ");
            if (!showVirtualOrg) {
                sql.append(" AND T_ORG_Admin.FIsVirtual = 0");
            }
            if (!Boolean.valueOf(schemeInfo.get("isOrgMulti").toString()).booleanValue()) {
                sql.append(" and T_ORG_Admin.FLevel <=" + levelStop);
            }
            if (!isInvalidPosition) {
                sql.append(" AND T_ORG_Position.FDeletedStatus = 1");
            }
        } else if (schemeInfo.getPlanType() == PersonPlanType.JOB) {
            sql.append("SELECT SUM(FPlan1), SUM(FPlan2) ,SUM(FPlan3), SUM(FPlan4),");
            sql.append(" SUM(FPlan5), SUM(FPlan6), SUM(FPlan7), SUM(FPlan8),");
            sql.append(" SUM(FPlan9), SUM(FPlan10),SUM(FPlan11),SUM(FPlan12),FYear,FJobID ");
            sql.append("FROM  T_HR_PersonPlan  INNER JOIN T_ORG_Admin ");
            sql.append("ON T_HR_PersonPlan.FAdminOrgID = T_ORG_Admin.FId ");
            sql.append("WHERE ");
            sql.append(this.getAdminWhereSql("T_ORG_Admin.FID", "FLongNumber", adminInfo));
            sql.append(" AND FYear >= ");
            sql.append(startYear);
            sql.append(" AND FYear <= ");
            sql.append(endYear);
            sql.append(" AND FSchemeID = '");
            sql.append(schemeInfo.getId());
            sql.append("' ");
            if (!showVirtualOrg) {
                sql.append(" AND T_ORG_Admin.FIsVirtual = 0");
            }
            if (!Boolean.valueOf(schemeInfo.get("isOrgMulti").toString()).booleanValue()) {
                sql.append(" and T_ORG_Admin.FLevel <=" + levelStop);
            }
            sql.append(" GROUP BY FJobID,FYear");
        }
        return DbUtil.executeQuery((Context)ctx, (String)sql.toString());
    }

    private String getAdminWhereSql(String adminIdColName, String adminLongNumberName, AdminOrgUnitInfo adminInfo) {
        StringBuffer adminWhereSql = new StringBuffer();
        if (Boolean.valueOf(true).equals(adminInfo.get("isMultOrg"))) {
            Object[] orgs = (Object[])adminInfo.get("adminInfos");
            adminWhereSql.append(OrgStringUtil.getOrgsSqlIncludeChild((String)adminIdColName, (String)adminLongNumberName, (Object[])orgs));
        } else {
            adminWhereSql.append("(");
            adminWhereSql.append(adminLongNumberName + " = '");
            adminWhereSql.append(adminInfo.getLongNumber());
            adminWhereSql.append("' OR " + adminLongNumberName + " Like '");
            adminWhereSql.append(adminInfo.getLongNumber());
            adminWhereSql.append("!%'");
            adminWhereSql.append(")");
        }
        return adminWhereSql.toString();
    }

    private IRowSet getJobsByAdminOrg(Context ctx, AdminOrgUnitInfo adminInfo, boolean showVirtualOrg, boolean isShowDisableJob) throws BOSException, EASBizException {
        CtrlUnitInfo cuInfo = ContextUtil.getCurrentCtrlUnit((Context)ctx).getCU();
        String cuID = cuInfo.getId().toString();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("adminOrg.longNumber", (Object)(adminInfo.getLongNumber() + "%"), CompareType.LIKE));
        viewInfo.setFilter(fi);
        if (Boolean.valueOf(true).equals(adminInfo.get("isMultOrg"))) {
            Object[] orgs = (Object[])adminInfo.get("adminInfos");
            String oql = "where CtrlUnit.id = '" + cuID + "' and " + OrgStringUtil.getOrgsSqlIncludeChild((String)"adminOrg.id", (String)"adminOrg.longNumber", (Object[])orgs);
            try {
                viewInfo = new EntityViewInfo(oql);
            }
            catch (ParserException e) {
                throw new BOSException((Throwable)e);
            }
        }
        if (!showVirtualOrg) {
            try {
                FilterInfo isVirtualFilter = new FilterInfo("adminOrg.isVirtual = 0");
                viewInfo.getFilter().mergeFilter(isVirtualFilter, "and");
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        if (!isShowDisableJob) {
            try {
                FilterInfo isShowDisableJobFilter = new FilterInfo();
                isShowDisableJobFilter.getFilterItems().add(new FilterItemInfo("state", (Object)2, CompareType.NOTEQUALS));
                viewInfo.getFilter().mergeFilter(isShowDisableJobFilter, "and");
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.org.app.JobsByAdminOrgUnit");
        IQueryExecutor queryExcu = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        queryExcu.setObjectView(viewInfo);
        return queryExcu.executeQuery();
    }

    private int getCurrentOrgPlanCount(Context ctx, BOSUuid orgId) throws BOSException, EASBizException {
        Calendar now = Calendar.getInstance(ctx.getLocale());
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FPlan1, FPlan2 ,FPlan3, FPlan4,");
        sql.append("FPlan5, FPlan6, FPlan7,FPlan8,");
        sql.append("FPlan9, FPlan10,FPlan11,FPlan12 ");
        sql.append("FROM  T_HR_PersonPlan ");
        sql.append("INNER JOIN T_HR_PersonPlanScheme ");
        sql.append("ON T_HR_PersonPlan.FSchemeID = T_HR_PersonPlanScheme.FID ");
        sql.append("WHERE T_HR_PersonPlan.FAdminOrgID = '");
        sql.append(orgId.toString());
        sql.append("' AND FYear = ");
        sql.append(now.get(1));
        sql.append(" AND T_HR_PersonPlanScheme.FStatus = 2 ");
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rows.next()) {
                if (rows.getString(now.get(2) + 1) == null) {
                    return -1;
                }
                return rows.getInt(now.get(2) + 1);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return -1;
    }

    private int getCurrentOrgPlanCount(Context ctx, String adminOrgId, String schemeId) throws BOSException, EASBizException {
        Calendar now = Calendar.getInstance(ctx.getLocale());
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FPlan1,FPlan2,FPlan3,FPlan4,");
        sql.append("FPlan5,FPlan6,FPlan7,FPlan8,");
        sql.append("FPlan9,FPlan10,FPlan11,FPlan12 ");
        sql.append("FROM T_HR_PersonPlan ");
        sql.append("WHERE FAdminOrgID = '");
        sql.append(adminOrgId);
        sql.append("' AND FYear = ");
        sql.append(now.get(1));
        sql.append(" AND FSchemeID = '");
        sql.append(schemeId);
        sql.append("'");
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rows.next()) {
                if (rows.getString(now.get(2) + 1) == null) {
                    return -1;
                }
                return rows.getInt(now.get(2) + 1);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return -1;
    }

    @Override
    protected int _getCurrentPlanCount(Context ctx, BOSUuid orgId) throws BOSException, EASBizException {
        IAdminOrgUnit iAdmin = AdminOrgUnitFactory.getLocalInstance((Context)ctx);
        AdminOrgUnitInfo adminInfo = iAdmin.getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgId));
        String longNumber = adminInfo.getLongNumber();
        Calendar now = Calendar.getInstance(ctx.getLocale());
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT SUM(FPlan1), SUM(FPlan2) ,SUM(FPlan3), SUM(FPlan4),");
        sql.append("SUM(FPlan5), SUM(FPlan6), SUM( FPlan7), SUM(FPlan8),");
        sql.append("SUM(FPlan9), SUM(FPlan10),SUM(FPlan11),SUM(FPlan12) ");
        sql.append("FROM  T_HR_PersonPlan  INNER JOIN T_ORG_Admin ");
        sql.append("ON T_HR_PersonPlan.FAdminOrgID = T_ORG_Admin.FId ");
        sql.append("INNER JOIN T_HR_PersonPlanScheme ");
        sql.append("ON T_HR_PersonPlan.FSchemeID = T_HR_PersonPlanScheme.FID ");
        sql.append("WHERE (FLongNumber = '");
        sql.append(longNumber);
        sql.append("' OR FLongNumber Like '");
        sql.append(longNumber);
        sql.append("!%') AND FYear = ");
        sql.append(now.get(1));
        sql.append(" AND T_HR_PersonPlanScheme.FStatus = 2 ");
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rows.next()) {
                if (rows.getString(now.get(2) + 1) == null) {
                    return -1;
                }
                return rows.getInt(now.get(2) + 1);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return -1;
    }

    @Override
    protected int _getCurrPlanCountByPosition(Context ctx, String positionId, String schemeId) throws BOSException, EASBizException {
        Calendar now = Calendar.getInstance(ctx.getLocale());
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FPlan1,FPlan2,FPlan3,FPlan4,FPlan5,FPlan6,");
        sql.append("FPlan7,FPlan8,FPlan9,FPlan10,FPlan11,FPlan12 ");
        sql.append(" FROM T_HR_PersonPlan WHERE FSchemeID = '");
        sql.append(schemeId);
        sql.append("' AND FPositionID = '");
        sql.append(positionId);
        sql.append("' AND FYear = ");
        sql.append(now.get(1));
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rows.next()) {
                if (rows.getString(now.get(2) + 1) == null) {
                    return -1;
                }
                return rows.getInt(now.get(2) + 1);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return -1;
    }

    private int getCurrPlanCountByJob(Context ctx, BOSUuid orgId, String schemeId, String jobId) throws BOSException, EASBizException {
        IAdminOrgUnit iAdmin = AdminOrgUnitFactory.getLocalInstance((Context)ctx);
        AdminOrgUnitInfo adminInfo = iAdmin.getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgId));
        String longNumber = adminInfo.getLongNumber();
        Calendar now = Calendar.getInstance(ctx.getLocale());
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT SUM(FPlan1), SUM(FPlan2) ,SUM(FPlan3), SUM(FPlan4),");
        sql.append("SUM(FPlan5), SUM(FPlan6), SUM( FPlan7), SUM(FPlan8),");
        sql.append("SUM(FPlan9), SUM(FPlan10),SUM(FPlan11),SUM(FPlan12) ");
        sql.append("FROM  T_HR_PersonPlan  INNER JOIN T_ORG_Admin ");
        sql.append("ON T_HR_PersonPlan.FAdminOrgID = T_ORG_Admin.FId ");
        sql.append("WHERE (FLongNumber = '");
        sql.append(longNumber);
        sql.append("' OR FLongNumber Like '");
        sql.append(longNumber);
        sql.append("!%') AND FYear = ");
        sql.append(now.get(1));
        sql.append(" AND FSchemeID = '");
        sql.append(schemeId);
        sql.append("' AND FJobID = '");
        sql.append(jobId);
        sql.append("' ");
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rows.next()) {
                if (rows.getString(now.get(2) + 1) == null) {
                    return -1;
                }
                return rows.getInt(now.get(2) + 1);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return -1;
    }

    private int getCurrPlanCountByJob(Context ctx, String adminOrgId, String schemeId, String jobId) throws BOSException, EASBizException {
        Calendar now = Calendar.getInstance(ctx.getLocale());
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FPlan1,FPlan2,FPlan3,FPlan4,");
        sql.append("FPlan5,FPlan6,FPlan7,FPlan8,");
        sql.append("FPlan9,FPlan10,FPlan11,FPlan12 ");
        sql.append("FROM T_HR_PersonPlan ");
        sql.append("WHERE FAdminOrgID = '");
        sql.append(adminOrgId);
        sql.append("' AND FYear = ");
        sql.append(now.get(1));
        sql.append(" AND FSchemeID = '");
        sql.append(schemeId);
        sql.append("' AND FJobID = '");
        sql.append(jobId);
        sql.append("' ");
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rows.next()) {
                if (rows.getString(now.get(2) + 1) == null) {
                    return -1;
                }
                return rows.getInt(now.get(2) + 1);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return -1;
    }

    private int getPlanONCountByPosition(Context ctx, String positionId, boolean paramPartimeOnStr) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT COUNT(1) ");
        sql.append("FROM T_ORG_Position ");
        sql.append("INNER JOIN T_ORG_PositionMember ");
        sql.append("ON T_ORG_Position.FID = T_ORG_PositionMember.FPositionID ");
        sql.append("LEFT OUTER JOIN T_BD_Person ");
        sql.append("INNER JOIN T_HR_BDEmployeeType ");
        sql.append("ON T_BD_Person.FEmployeeTypeID=T_HR_BDEmployeeType.FID ");
        sql.append("ON T_ORG_PositionMember.FPersonID=T_BD_Person.FID ");
        sql.append("WHERE T_ORG_Position.FID='");
        sql.append(positionId);
        sql.append("' AND (T_HR_BDEmployeeType.FIsOnTheStrength = 1 ");
        sql.append("OR T_HR_BDEmployeeType.FIsOnTheStrength IS NULL) ");
        if (!paramPartimeOnStr) {
            sql.append("AND T_ORG_PositionMember.FIsPrimary=1");
        }
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rows.next()) {
                return rows.getInt(1);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return 0;
    }

    private Map getActualONPosition(Context ctx, String positionId, boolean paramPartimeOnStr) throws BOSException, EASBizException {
        if (ctx == null || StringUtils.isEmpty((String)positionId)) {
            return null;
        }
        Map map1 = this.getActualONPositionNotLoan(ctx, positionId, paramPartimeOnStr);
        Map map2 = this.getActualONPositionLoan(ctx, positionId);
        Map map3 = this.getActualONPositionLoanButNotLoanPosition(ctx, positionId, paramPartimeOnStr);
        return this.concatMap(this.concatMap(map1, map2), map3);
    }

    private Map getActualONPositionNotLoan(Context ctx, String positionId, boolean paramPartimeOnStr) throws BOSException, EASBizException {
        HashMap<String, Integer> personMap = new HashMap<String, Integer>();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT T_BD_Person.FID ");
        sql.append("FROM T_ORG_Position ");
        sql.append("INNER JOIN T_ORG_PositionMember ");
        sql.append("ON T_ORG_Position.FID = T_ORG_PositionMember.FPositionID ");
        sql.append("INNER JOIN T_BD_Person ");
        sql.append("INNER JOIN T_HR_BDEmployeeType ");
        sql.append("ON T_BD_Person.FEmployeeTypeID = T_HR_BDEmployeeType.FID ");
        sql.append("ON T_ORG_PositionMember.FPersonID = T_BD_Person.FID ");
        sql.append("LEFT OUTER JOIN (SELECT FID, FPERSONID FROM T_HR_PersonLoan WHERE FSTATE = '1') AS PL ON PL.FPERSONID = T_BD_Person.FID ");
        sql.append("WHERE PL.FID IS NULL AND T_ORG_Position.FID = '");
        sql.append(positionId);
        sql.append("' AND (T_HR_BDEmployeeType.FIsOnTheStrength = 1 ");
        sql.append("OR T_HR_BDEmployeeType.FIsOnTheStrength IS NULL) ");
        if (!paramPartimeOnStr) {
            sql.append("AND T_ORG_PositionMember.FIsPrimary=1");
        }
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rowSet != null) {
                while (rowSet.next()) {
                    String personID = rowSet.getString(1);
                    int num = personMap.containsKey(personID) ? (Integer)personMap.get(personID) + 1 : 1;
                    personMap.put(personID, num);
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return personMap;
    }

    private Map getActualONPositionLoan(Context ctx, String positionId) throws BOSException {
        HashMap<String, Integer> personMap = new HashMap<String, Integer>();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT T_BD_Person.FID ");
        sql.append("FROM (SELECT FPERSONID,FOutPositionID,FPositionStr,FInPositionID FROM T_HR_PersonLoan WHERE FSTATE = '1') AS PL ");
        sql.append("INNER JOIN T_BD_Person ON PL.FPERSONID = T_BD_Person.FID ");
        sql.append("WHERE (PL.FOutPositionID = '");
        sql.append(positionId);
        sql.append("' AND (PL.FPositionStr = '1' OR PL.FPositionStr = '3')) OR (PL.FInPositionID = '");
        sql.append(positionId);
        sql.append("' AND (PL.FPositionStr = '1' OR PL.FPositionStr = '2'))");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rowSet != null) {
                while (rowSet.next()) {
                    String personID = rowSet.getString(1);
                    int num = personMap.containsKey(personID) ? (Integer)personMap.get(personID) + 1 : 1;
                    personMap.put(personID, num);
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), e.getCause());
        }
        return personMap;
    }

    private Map getActualONPositionLoanButNotLoanPosition(Context ctx, String positionId, boolean paramPartimeOnStr) throws BOSException {
        HashMap<String, Integer> personMap = new HashMap<String, Integer>();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT T_BD_Person.FID ");
        sql.append("FROM T_ORG_Position ");
        sql.append("INNER JOIN T_ORG_PositionMember ");
        sql.append("ON T_ORG_Position.FID = T_ORG_PositionMember.FPositionID ");
        sql.append("INNER JOIN T_BD_Person ");
        sql.append("INNER JOIN T_HR_BDEmployeeType ");
        sql.append("ON T_BD_Person.FEmployeeTypeID = T_HR_BDEmployeeType.FID ");
        sql.append("ON T_ORG_PositionMember.FPersonID = T_BD_Person.FID ");
        sql.append("INNER JOIN (SELECT FID, FPERSONID, FOutPositionID, FInPositionID FROM T_HR_PersonLoan WHERE FSTATE = '1') AS PL ON PL.FPERSONID = T_BD_Person.FID ");
        sql.append("WHERE PL.FOutPositionID <> '").append(positionId);
        sql.append("' AND PL.FInPositionID <> '").append(positionId);
        sql.append("' AND T_ORG_Position.FID = '").append(positionId);
        sql.append("' AND (T_HR_BDEmployeeType.FIsOnTheStrength = 1 ");
        sql.append("OR T_HR_BDEmployeeType.FIsOnTheStrength IS NULL) ");
        if (!paramPartimeOnStr) {
            sql.append("AND T_ORG_PositionMember.FIsPrimary=1");
        }
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rowSet != null) {
                while (rowSet.next()) {
                    String personID = rowSet.getString(1);
                    int num = personMap.containsKey(personID) ? (Integer)personMap.get(personID) + 1 : 1;
                    personMap.put(personID, num);
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), e.getCause());
        }
        return personMap;
    }

    private Map getActualONCount(Context ctx, String adminId, boolean paramPartimeOnStr) throws BOSException {
        if (ctx == null || StringUtils.isEmpty((String)adminId)) {
            return null;
        }
        Map map1 = this.getActualONCountNotLoan(ctx, adminId, paramPartimeOnStr);
        Map map2 = this.getActualONCountNoPosition(ctx, adminId, paramPartimeOnStr);
        Map map3 = this.getActualONCountLoan(ctx, adminId);
        Map map4 = this.getActualONCountLoanButNotLoanPosition(ctx, adminId, paramPartimeOnStr);
        return this.concatMap(this.concatMap(this.concatMap(map1, map2), map3), map4);
    }

    private Map getActualONCountNotLoan(Context ctx, String adminId, boolean paramPartimeOnStr) throws BOSException {
        HashMap<String, Integer> personMap = new HashMap<String, Integer>();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT T_BD_Person.FID ");
        sql.append("FROM T_ORG_Admin INNER JOIN T_ORG_Position ");
        sql.append("INNER JOIN T_ORG_PositionMember ");
        sql.append("ON T_ORG_Position.FID = T_ORG_PositionMember.FPositionID ");
        sql.append("ON T_ORG_Admin.FID = T_ORG_Position.FAdminOrgUnitID ");
        sql.append("INNER JOIN T_BD_Person ");
        sql.append("INNER JOIN T_HR_BDEmployeeType ");
        sql.append("ON T_BD_Person.FEmployeeTypeID = T_HR_BDEmployeeType.FID ");
        sql.append("ON T_ORG_PositionMember.FPersonID = T_BD_Person.FID ");
        sql.append("LEFT OUTER JOIN (SELECT FID, FPERSONID FROM T_HR_PersonLoan WHERE FSTATE = '1') AS PL ON PL.FPERSONID = T_BD_Person.FID ");
        sql.append("WHERE PL.FID IS NULL AND T_ORG_Admin.FID = '");
        sql.append(adminId);
        sql.append("' AND (T_HR_BDEmployeeType.FIsOnTheStrength = 1 ");
        sql.append("OR T_HR_BDEmployeeType.FIsOnTheStrength IS NULL) ");
        if (!paramPartimeOnStr) {
            sql.append(" AND T_ORG_PositionMember.FIsPrimary = 1");
        }
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rowSet != null) {
                while (rowSet.next()) {
                    String personID = rowSet.getString(1);
                    int num = personMap.containsKey(personID) ? (Integer)personMap.get(personID) + 1 : 1;
                    personMap.put(personID, num);
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), e.getCause());
        }
        return personMap;
    }

    private Map getActualONCountNoPosition(Context ctx, String adminId, boolean paramPartimeOnStr) throws BOSException {
        HashMap<String, Integer> personMap = new HashMap<String, Integer>();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT p.FID FROM ");
        sql.append("T_HR_PersonPosition pp ");
        sql.append("inner join T_BD_Person p on pp.FPersonID = p.FID ");
        sql.append("inner join T_HR_BDEmployeeType e on p.FEmployeeTypeID = e.FID ");
        sql.append("inner join T_ORG_Admin a on pp.FPersonDep = a.FID ");
        sql.append("where e.FIsOnTheStrength = 1 and pp.FPrimaryPositionID is null and a.FID = '");
        sql.append(adminId);
        sql.append("'");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rowSet != null) {
                while (rowSet.next()) {
                    String personID = rowSet.getString(1);
                    personMap.put(personID, 1);
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), e.getCause());
        }
        return personMap;
    }

    private Map getActualONCountLoan(Context ctx, String adminId) throws BOSException {
        HashMap<String, Integer> personMap = new HashMap<String, Integer>();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT T_BD_Person.FID ");
        sql.append("FROM (SELECT * FROM T_HR_PersonLoan WHERE FSTATE = '1') AS PL ");
        sql.append("INNER JOIN T_BD_Person ON PL.FPERSONID = T_BD_Person.FID ");
        sql.append("WHERE (PL.FOutAdminID = '");
        sql.append(adminId);
        sql.append("' AND (PL.FPositionStr = '1' OR PL.FPositionStr = '3')) OR (PL.FInAdminID = '");
        sql.append(adminId);
        sql.append("' AND (PL.FPositionStr = '1' OR PL.FPositionStr = '2'))");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rowSet != null) {
                while (rowSet.next()) {
                    String personID = rowSet.getString(1);
                    int num = personMap.containsKey(personID) ? (Integer)personMap.get(personID) + 1 : 1;
                    personMap.put(personID, num);
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), e.getCause());
        }
        return personMap;
    }

    private Map getActualONCountLoanButNotLoanPosition(Context ctx, String adminId, boolean paramPartimeOnStr) throws BOSException {
        HashMap<String, Integer> personMap = new HashMap<String, Integer>();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT T_BD_Person.FID ");
        sql.append("FROM T_ORG_Admin INNER JOIN T_ORG_Position ");
        sql.append("INNER JOIN T_ORG_PositionMember ");
        sql.append("ON T_ORG_Position.FID = T_ORG_PositionMember.FPositionID ");
        sql.append("ON T_ORG_Admin.FID = T_ORG_Position.FAdminOrgUnitID ");
        sql.append("INNER JOIN T_BD_Person ");
        sql.append("INNER JOIN T_HR_BDEmployeeType ");
        sql.append("ON T_BD_Person.FEmployeeTypeID = T_HR_BDEmployeeType.FID ");
        sql.append("ON T_ORG_PositionMember.FPersonID = T_BD_Person.FID ");
        sql.append("INNER JOIN (SELECT FID, FPERSONID, FOutPositionID, FInPositionID FROM T_HR_PersonLoan WHERE FSTATE = '1') AS PL ON PL.FPERSONID = T_BD_Person.FID ");
        sql.append("WHERE PL.FOutPositionID <> T_ORG_Position.FID");
        sql.append(" AND PL.FInPositionID <> T_ORG_Position.FID");
        sql.append(" AND T_ORG_Admin.FID = '").append(adminId);
        sql.append("' AND (T_HR_BDEmployeeType.FIsOnTheStrength = 1 ");
        sql.append("OR T_HR_BDEmployeeType.FIsOnTheStrength IS NULL) ");
        if (!paramPartimeOnStr) {
            sql.append(" AND T_ORG_PositionMember.FIsPrimary = 1");
        }
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rowSet != null) {
                while (rowSet.next()) {
                    String personID = rowSet.getString(1);
                    int num = personMap.containsKey(personID) ? (Integer)personMap.get(personID) + 1 : 1;
                    personMap.put(personID, num);
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), e.getCause());
        }
        return personMap;
    }

    private Map getActualONJob(Context ctx, String adminOrgId, String jobId, boolean paramPartimeOnStr) throws BOSException, EASBizException {
        if (ctx == null || StringUtils.isEmpty((String)adminOrgId) || StringUtils.isEmpty((String)jobId)) {
            return null;
        }
        Map map1 = this.getActualONJobNotLoan(ctx, adminOrgId, jobId, paramPartimeOnStr);
        Map map2 = this.getActualONJobLoan(ctx, adminOrgId, jobId);
        Map map3 = this.getActualONJobLoanButNotLoanPosition(ctx, adminOrgId, jobId, paramPartimeOnStr);
        return this.concatMap(this.concatMap(map1, map2), map3);
    }

    private Map getActualONJobNotLoan(Context ctx, String adminID, String jobId, boolean paramPartimeOnStr) throws BOSException, EASBizException {
        HashMap<String, Integer> personMap = new HashMap<String, Integer>();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT T_BD_Person.FID ");
        sql.append("FROM T_ORG_Admin INNER JOIN T_ORG_Position ");
        sql.append("INNER JOIN T_ORG_PositionMember ");
        sql.append("ON T_ORG_Position.FID = T_ORG_PositionMember.FPositionID ");
        sql.append("ON T_ORG_Admin.FId = T_ORG_Position.FAdminOrgUnitID ");
        sql.append("LEFT OUTER JOIN T_BD_Person ");
        sql.append("INNER JOIN T_HR_BDEmployeeType ");
        sql.append("ON T_BD_Person.FEmployeeTypeID = T_HR_BDEmployeeType.FID ");
        sql.append("ON T_ORG_PositionMember.FPersonID = T_BD_Person.FID ");
        sql.append("LEFT OUTER JOIN (SELECT FID, FPERSONID FROM T_HR_PersonLoan WHERE FSTATE = '1') AS PL ON PL.FPERSONID = T_BD_Person.FID ");
        sql.append("WHERE PL.FID IS NULL AND T_ORG_Admin.FID = '");
        sql.append(adminID);
        sql.append("' AND (T_HR_BDEmployeeType.FIsOnTheStrength = 1 ");
        sql.append("OR T_HR_BDEmployeeType.FIsOnTheStrength IS NULL) ");
        sql.append(" AND T_ORG_Position.FJobID = '");
        sql.append(jobId);
        sql.append("'");
        if (!paramPartimeOnStr) {
            sql.append(" AND T_ORG_PositionMember.FIsPrimary = 1");
        }
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rowSet != null) {
                while (rowSet.next()) {
                    String personID = rowSet.getString(1);
                    int num = personMap.containsKey(personID) ? (Integer)personMap.get(personID) + 1 : 1;
                    personMap.put(personID, num);
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return personMap;
    }

    private Map getActualONJobLoan(Context ctx, String adminID, String jobId) throws BOSException {
        HashMap<String, Integer> personMap = new HashMap<String, Integer>();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT T_BD_Person.FID ");
        sql.append("FROM (SELECT * FROM T_HR_PersonLoan WHERE FSTATE = '1') AS PL ");
        sql.append("INNER JOIN T_BD_Person ON PL.FPERSONID = T_BD_Person.FID ");
        sql.append("WHERE (PL.FOutAdminID = '");
        sql.append(adminID);
        sql.append("' AND PL.FOutJobID = '");
        sql.append(jobId);
        sql.append("' AND (PL.FPositionStr = '1' OR PL.FPositionStr = '3')) OR (PL.FInAdminID = '");
        sql.append(adminID);
        sql.append("' AND PL.FInJobID = '");
        sql.append(jobId);
        sql.append("' AND (PL.FPositionStr = '1' OR PL.FPositionStr = '2'))");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rowSet != null) {
                while (rowSet.next()) {
                    String personID = rowSet.getString(1);
                    int num = personMap.containsKey(personID) ? (Integer)personMap.get(personID) + 1 : 1;
                    personMap.put(personID, num);
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), e.getCause());
        }
        return personMap;
    }

    private Map getActualONJobLoanButNotLoanPosition(Context ctx, String adminID, String jobId, boolean paramPartimeOnStr) throws BOSException {
        HashMap<String, Integer> personMap = new HashMap<String, Integer>();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT T_BD_Person.FID ");
        sql.append("FROM T_ORG_Admin INNER JOIN T_ORG_Position ");
        sql.append("INNER JOIN T_ORG_PositionMember ");
        sql.append("ON T_ORG_Position.FID = T_ORG_PositionMember.FPositionID ");
        sql.append("ON T_ORG_Admin.FId = T_ORG_Position.FAdminOrgUnitID ");
        sql.append("LEFT OUTER JOIN T_BD_Person ");
        sql.append("INNER JOIN T_HR_BDEmployeeType ");
        sql.append("ON T_BD_Person.FEmployeeTypeID = T_HR_BDEmployeeType.FID ");
        sql.append("ON T_ORG_PositionMember.FPersonID = T_BD_Person.FID ");
        sql.append("INNER JOIN (SELECT FID, FPERSONID, FOutPositionID, FInPositionID FROM T_HR_PersonLoan WHERE FSTATE = '1') AS PL ON PL.FPERSONID = T_BD_Person.FID ");
        sql.append("WHERE PL.FOutPositionID <> T_ORG_Position.FID");
        sql.append(" AND PL.FInPositionID <> T_ORG_Position.FID");
        sql.append(" AND T_ORG_Admin.FID = '");
        sql.append(adminID);
        sql.append("' AND (T_HR_BDEmployeeType.FIsOnTheStrength = 1 ");
        sql.append("OR T_HR_BDEmployeeType.FIsOnTheStrength IS NULL) ");
        sql.append(" AND T_ORG_Position.FJobID = '");
        sql.append(jobId);
        sql.append("'");
        if (!paramPartimeOnStr) {
            sql.append(" AND T_ORG_PositionMember.FIsPrimary = 1");
        }
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rowSet != null) {
                while (rowSet.next()) {
                    String personID = rowSet.getString(1);
                    int num = personMap.containsKey(personID) ? (Integer)personMap.get(personID) + 1 : 1;
                    personMap.put(personID, num);
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return personMap;
    }

    private int getPlanONCountByJob(Context ctx, String longNumber, String jobId, boolean paramPartimeOnStr) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT COUNT(1) ");
        sql.append("FROM T_ORG_Admin INNER JOIN T_ORG_Position ");
        sql.append("INNER JOIN T_ORG_PositionMember ");
        sql.append("ON T_ORG_Position.FID = T_ORG_PositionMember.FPositionID ");
        sql.append("ON T_ORG_Admin.FId = T_ORG_Position.FAdminOrgUnitID ");
        sql.append("LEFT OUTER JOIN T_BD_Person ");
        sql.append("INNER JOIN T_HR_BDEmployeeType ");
        sql.append("ON T_BD_Person.FEmployeeTypeID = T_HR_BDEmployeeType.FID ");
        sql.append("ON T_ORG_PositionMember.FPersonID = T_BD_Person.FID ");
        sql.append("WHERE (T_ORG_Admin.FLongNumber = '");
        sql.append(longNumber);
        sql.append("' OR T_ORG_Admin.FLongNumber Like '");
        sql.append(longNumber);
        sql.append("!%') AND (T_HR_BDEmployeeType.FIsOnTheStrength=1 ");
        sql.append("OR T_HR_BDEmployeeType.FIsOnTheStrength IS NULL) ");
        sql.append(" AND T_ORG_Position.FJobID = '");
        sql.append(jobId);
        sql.append("'");
        if (!paramPartimeOnStr) {
            sql.append(" AND T_ORG_PositionMember.FIsPrimary=1");
        }
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rows.next()) {
                return rows.getInt(1);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return 0;
    }

    @Override
    protected void _canAddPerson(Context ctx, String positionId) throws BOSException, EASBizException {
        if (HRUtilExtend.isUseSHRPersonPlan((Context)ctx)) {
            return;
        }
        CtrlUnitInfo cuInfo = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        if (cuInfo == null) {
            return;
        }
        HROrgUnitInfo hrOrgInfo = OrgHRCommonFactory.getLocalInstance(ctx).getPositionOrgHRO(positionId);
        if (hrOrgInfo == null) {
            return;
        }
        String hrOrgId = hrOrgInfo.getId().toString();
        int finished = HRInitFactory.getLocalInstance((Context)ctx).isPositionRelatedHROrgFinished(positionId);
        if (finished <= 0) {
            return;
        }
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)positionId));
        PositionInfo posiInfo = PositionFactory.getLocalInstance((Context)ctx).getPositionInfo((IObjectPK)pk);
        if (posiInfo == null) {
            return;
        }
        AdminOrgUnitInfo adminInfo = posiInfo.getAdminOrgUnit();
        if (adminInfo == null) {
            return;
        }
        boolean positionIsAllowOver = HRParamUtil.getParamOfHR((Context)ctx, (String)"IS_POSITION_ALLOW_OVER", (String)hrOrgId);
        String systemParam = ParamManager.getParamValue((Context)ctx, (IObjectPK)new ObjectUuidPK(hrOrgId), (String)"IS_ALLOW_OVER");
        boolean isAllowOverFlag = false;
        if ("0".equals(systemParam)) {
            isAllowOverFlag = true;
        }
        if (isAllowOverFlag && positionIsAllowOver) {
            return;
        }
        PersonPlanSchemeInfo schemeInfo = PersonPlanSchemeFactory.getLocalInstance(ctx).getDefaultScheme(hrOrgId);
        if (schemeInfo != null && schemeInfo.getStatus() != SchemeStatus.EXECUTE) {
            throw new PersonPlanException(PersonPlanException.NOT_EXCUTE_PERSONPLANSCHEME);
        }
        int posiCount = this.planCountFromPosition(ctx, posiInfo, schemeInfo);
        if (posiCount >= 0 && isAllowOverFlag) {
            return;
        }
        if (!positionIsAllowOver || posiCount < 0) {
            // empty if block
        }
        boolean paramPartimeOnStr = HRParamUtil.getParamOfHR((Context)ctx, (String)"IS_AUTH", (String)hrOrgId);
        int actual = -1;
        int plan = 0;
        if (!positionIsAllowOver && posiCount < 0) {
            actual = this.getActualONPlanPersonCount(ctx, positionId, PersonPlanType.POSITION, adminInfo.getId().toString(), paramPartimeOnStr);
            posiCount = posiInfo.getPositionPlanCount();
            if (posiCount > 0 && actual - posiCount >= 0) {
                throw new PersonPlanException(PersonPlanException.POSITION_SURPASS_LIMITS, new Object[]{posiInfo.getName()});
            }
        }
        if (schemeInfo == null) {
            return;
        }
        boolean paramParanormal = this.isCanAllowOver(ctx, schemeInfo, adminInfo.getId().toString(), posiInfo, systemParam);
        if (paramParanormal) {
            return;
        }
        String schemeId = schemeInfo.getId().toString();
        String weidu = null;
        if (schemeInfo.getPlanType() == PersonPlanType.PERSON) {
            plan = this.getCurrentOrgPlanCount(ctx, adminInfo.getId());
            weidu = adminInfo.getId().toString();
        } else if (schemeInfo.getPlanType() == PersonPlanType.JOB) {
            String jobId = null;
            if (posiInfo.getJob() == null) {
                return;
            }
            jobId = posiInfo.getJob().getId().toString();
            plan = this.getCurrPlanCountByJob(ctx, adminInfo.getId(), schemeId, jobId);
            weidu = jobId;
        } else if (schemeInfo.getPlanType() == PersonPlanType.POSITION) {
            plan = posiCount;
            weidu = posiInfo.getId().toString();
        }
        if (actual == -1) {
            actual = this.getActualONPlanPersonCount(ctx, weidu, schemeInfo.getPlanType(), adminInfo.getId().toString(), paramPartimeOnStr);
        }
        if (plan >= 0 && actual - plan >= 0) {
            throw new PersonPlanException(PersonPlanException.NOT_ADD_PERSON_EXCEED_PLAN);
        }
    }

    @Override
    protected void _canAddPersonBatch(Context ctx, List positionInfoList) throws BOSException, EASBizException {
    }

    private PositionCollection getPositionCollectionByIds(Context ctx, List positionInfoList) throws BOSException, EASBizException {
        StringBuffer oql = new StringBuffer("select *,adminOrgUnit.id,adminOrgUnit.longNumber,job.id where id in (");
        for (int i = 0; i < positionInfoList.size(); ++i) {
            PosPerPlanInfo posper = (PosPerPlanInfo)positionInfoList.get(i);
            if (i != 0) {
                oql.append(",");
            }
            oql.append("'");
            oql.append(posper.getPosition().getId().toString());
            oql.append("'");
        }
        oql.append(")");
        IPosition ipos = PositionFactory.getLocalInstance((Context)ctx);
        PositionCollection posCol = ipos.getPositionCollection(oql.toString());
        return posCol;
    }

    private Map getParamsMap(Context ctx, Map postionHroMap) throws BOSException, EASBizException {
        HashMap<String, Boolean> paramsMap = new HashMap<String, Boolean>();
        HashSet<String> hasGetHroParamsSet = new HashSet<String>();
        for (Map.Entry entry : postionHroMap.entrySet()) {
            String hroId;
            String positionId = (String)entry.getKey();
            HROrgUnitInfo hro = (HROrgUnitInfo)postionHroMap.get(positionId);
            if (hro == null || hasGetHroParamsSet.contains(hroId = hro.getId().toString())) continue;
            hasGetHroParamsSet.add(hroId);
            boolean paramPartimeOnStr = HRParamUtil.getParamOfHR((Context)ctx, (String)"IS_AUTH", (String)hroId);
            paramsMap.put(hroId + "IS_AUTH", paramPartimeOnStr);
        }
        return paramsMap;
    }

    @Override
    protected HashMap _getCurrPlanCountByPosition(Context ctx, List positionList, String schemeId) throws BOSException, EASBizException {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        Calendar now = Calendar.getInstance(ctx.getLocale());
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FPlan1,FPlan2,FPlan3,FPlan4,FPlan5,FPlan6,");
        sql.append("FPlan7,FPlan8,FPlan9,FPlan10,FPlan11,FPlan12,FPositionID ");
        sql.append(" FROM T_HR_PersonPlan WHERE FSchemeID='");
        sql.append(schemeId);
        sql.append("' AND FPositionID IN (");
        for (int i = 0; i < positionList.size(); ++i) {
            sql.append("'");
            sql.append(positionList.get(i));
            if (i == positionList.size() - 1) {
                sql.append("' ");
                continue;
            }
            sql.append("', ");
        }
        sql.append(") AND FYear = ");
        sql.append(now.get(1));
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            String positionId = null;
            while (rows.next()) {
                positionId = rows.getString("FPositionID");
                map.put(positionId, rows.getInt(now.get(2) + 1));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return map;
    }

    @Override
    protected HashMap _getCurrPlanCountByPosition(Context ctx, List positionList) throws BOSException, EASBizException {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        Calendar now = Calendar.getInstance(ctx.getLocale());
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FPlan1,FPlan2,FPlan3,FPlan4,FPlan5,FPlan6,");
        sql.append("FPlan7,FPlan8,FPlan9,FPlan10,FPlan11,FPlan12,FPositionID ");
        sql.append(" FROM T_HR_PersonPlan   inner join T_HR_PersonPlanScheme  on T_HR_PersonPlan.FSchemeID=T_HR_PersonPlanScheme.fid WHERE T_HR_PersonPlanScheme.FStatus=2  and  T_HR_PersonPlanScheme.FPlanType=0 ");
        sql.append(" AND FPositionID IN (");
        for (int i = 0; i < positionList.size(); ++i) {
            sql.append("'");
            sql.append(positionList.get(i));
            if (i == positionList.size() - 1) {
                sql.append("' ");
                continue;
            }
            sql.append("', ");
        }
        sql.append(") AND FYear = ");
        sql.append(now.get(1));
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            String positionId = null;
            while (rows.next()) {
                positionId = rows.getString("FPositionID");
                map.put(positionId, rows.getInt(now.get(2) + 1));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return map;
    }

    @Override
    protected HashMap _getFactCountByPosition(Context ctx, List positionList) throws BOSException, EASBizException {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FPositionID,COUNT(1) FROM T_ORG_PositionMember ");
        sql.append("WHERE FPositionID IN (");
        for (int i = 0; i < positionList.size(); ++i) {
            sql.append("'");
            sql.append(positionList.get(i));
            if (i == positionList.size() - 1) {
                sql.append("' ");
                continue;
            }
            sql.append("', ");
        }
        sql.append(") GROUP BY FPositionID ");
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            String positionId = null;
            while (rows.next()) {
                positionId = rows.getString("FPositionID");
                map.put(positionId, rows.getInt(2));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return map;
    }

    @Override
    protected void _addPersonPlanCollForImport(Context ctx, PersonPlanCollection ppColl, boolean isOver) throws BOSException, EASBizException {
        if (ppColl == null || ppColl.size() <= 0) {
            return;
        }
        StringBuffer oqlAdmin = new StringBuffer("select id, number, name where number in (''");
        StringBuffer oqlPosition = new StringBuffer("select id, number, name, job.id, job.number, job.name where number in (''");
        StringBuffer oqlJob = new StringBuffer("select id, number, name where number in (''");
        int size = ppColl.size();
        for (int i = 0; i < size; ++i) {
            JobInfo jobInfo;
            PositionInfo positionInfo;
            PersonPlanInfo ppInfo = ppColl.get(i);
            AdminOrgUnitInfo adminInfo = ppInfo.getAdminOrg();
            if (adminInfo != null && adminInfo.getNumber() != null) {
                oqlAdmin.append(", '").append(adminInfo.getNumber()).append("'");
            }
            if ((positionInfo = ppInfo.getPosition()) != null && positionInfo.getNumber() != null) {
                oqlPosition.append(", '").append(positionInfo.getNumber()).append("'");
            }
            if ((jobInfo = ppInfo.getJob()) == null || jobInfo.getNumber() == null) continue;
            oqlJob.append(", '").append(jobInfo.getNumber()).append("'");
        }
        oqlAdmin.append(")");
        oqlPosition.append(")");
        oqlJob.append(")");
        AdminOrgUnitCollection adminColl = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitCollection(oqlAdmin.toString());
        PositionCollection positionColl = PositionFactory.getLocalInstance((Context)ctx).getPositionCollection(oqlPosition.toString());
        JobCollection jobColl = JobFactory.getLocalInstance((Context)ctx).getJobCollection(oqlJob.toString());
        HashMap adminMap = new HashMap();
        HashMap positionMap = new HashMap();
        HashMap jobMap = new HashMap();
        this.traverse(adminMap, (IObjectCollection)adminColl);
        this.traverse(positionMap, (IObjectCollection)positionColl);
        this.traverse(jobMap, (IObjectCollection)jobColl);
        int size2 = ppColl.size();
        for (int i = 0; i < size2; ++i) {
            JobInfo jobInfo;
            PositionInfo positionInfo;
            PersonPlanInfo ppInfo = ppColl.get(i);
            AdminOrgUnitInfo adminInfo = ppInfo.getAdminOrg();
            if (adminInfo != null && adminInfo.getNumber() != null) {
                Object obj = adminMap.get(adminInfo.getNumber());
                if (!(obj instanceof AdminOrgUnitInfo)) {
                    throw new PersonPlanException(PersonPlanException.ADMIN_NOT_EXIST, new Object[]{adminInfo.getNumber()});
                }
                ppInfo.setAdminOrg((AdminOrgUnitInfo)obj);
            }
            if ((positionInfo = ppInfo.getPosition()) != null && positionInfo.getNumber() != null) {
                Object obj = positionMap.get(positionInfo.getNumber());
                if (!(obj instanceof PositionInfo)) {
                    throw new PersonPlanException(PersonPlanException.POSITION_NOT_EXIST, new Object[]{positionInfo.getNumber()});
                }
                positionInfo = (PositionInfo)obj;
                ppInfo.setPosition(positionInfo);
                if (positionInfo.getJob() != null) {
                    ppInfo.setJob(positionInfo.getJob());
                }
            }
            if ((jobInfo = ppInfo.getJob()) == null || jobInfo.getId() != null || jobInfo.getNumber() == null) continue;
            Object obj = jobMap.get(jobInfo.getNumber());
            if (!(obj instanceof JobInfo)) {
                throw new PersonPlanException(PersonPlanException.JOB_NOT_EXIST, new Object[]{jobInfo.getNumber()});
            }
            ppInfo.setJob((JobInfo)obj);
        }
        this.mySaveBatchData(ctx, (IObjectCollection)ppColl);
    }

    private void traverse(Map data, IObjectCollection coll) {
        if (data == null || coll == null) {
            return;
        }
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            IObjectValue obj = coll.getObject(i);
            if (!(obj instanceof DataBaseInfo)) continue;
            data.put(((DataBaseInfo)obj).getNumber(), obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IObjectPK[] mySaveBatchData(Context ctx, IObjectCollection colls) throws BOSException, EASBizException {
        Connection cn = null;
        IObjectPK[] objectPKArray = null;
        try {
            StringBuffer oql = new StringBuffer();
            cn = this.getConnection(ctx);
            IORMappingDAO dao = this.getDAO(ctx, cn);
            for (PersonPlanInfo ppInfo : colls) {
                if (this._isExistPropertyName(ctx, (CoreBaseInfo)ppInfo, "effectedStatus")) {
                    ppInfo.setInt("effectedStatus", 1);
                }
                oql.delete(0, oql.length());
                oql.append("select id where scheme = '");
                oql.append(ppInfo.getScheme().getId());
                oql.append("' and adminOrg = '");
                oql.append(ppInfo.getAdminOrg().getId());
                oql.append("' and year = ");
                oql.append(ppInfo.getYear());
                if (ppInfo.getType() == PersonPlanType.POSITION) {
                    oql.append(" and position = '");
                    oql.append(ppInfo.getPosition().getId());
                    oql.append("' ");
                } else if (ppInfo.getType() == PersonPlanType.JOB) {
                    oql.append(" and job = '");
                    oql.append(ppInfo.getJob().getId());
                    oql.append("' ");
                }
                PersonPlanCollection coll = this.getPersonPlanCollection(ctx, oql.toString());
                if (coll.size() > 0) {
                    BOSUuid id = coll.get(0).getId();
                    ppInfo.setId(id);
                    ObjectUuidPK pk = new ObjectUuidPK(id);
                    dao.updateBatch((IObjectPK)pk, (IObjectValue)ppInfo);
                    continue;
                }
                dao.addNewBatch((IObjectValue)ppInfo);
            }
            objectPKArray = dao.executeBatchWithReturn();
            ServiceStateManager.getInstance().enableNextCallServices();
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(cn);
            throw throwable;
        }
        SQLUtils.cleanup((Connection)cn);
        return objectPKArray;
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model, boolean isOver) throws BOSException, EASBizException {
        PersonPlanInfo ppInfo = (PersonPlanInfo)model;
        StringBuffer oql = new StringBuffer("");
        oql.append("select id where scheme='");
        oql.append(ppInfo.getScheme().getId());
        oql.append("' and adminOrg='");
        oql.append(ppInfo.getAdminOrg().getId());
        oql.append("' and year=");
        oql.append(ppInfo.getYear());
        if (ppInfo.getType() == PersonPlanType.POSITION) {
            oql.append(" and position='");
            oql.append(ppInfo.getPosition().getId());
            oql.append("' ");
        } else if (ppInfo.getType() == PersonPlanType.JOB) {
            oql.append(" and job='");
            oql.append(ppInfo.getJob().getId());
            oql.append("' ");
        }
        PersonPlanCollection ppColl = this.getPersonPlanCollection(ctx, oql.toString());
        if (ppColl.size() > 0) {
            ppInfo.setId(ppColl.get(0).getId());
            ObjectUuidPK pk = new ObjectUuidPK(ppColl.get(0).getId());
            if (isOver) {
                this.update(ctx, (IObjectPK)pk, (CoreBaseInfo)ppInfo);
            }
            return pk;
        }
        ppInfo.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
        return super._addnew(ctx, (IObjectValue)ppInfo);
    }

    @Override
    protected HashMap _importTemplate(Context ctx, HashMap paramMap) throws BOSException, EASBizException {
        HashMap<String, Object> mapValue = new HashMap<String, Object>();
        Map map = null;
        try {
            map = this.getHSSFWorkbook(ctx, paramMap);
            HSSFWorkbook hssfWorkBook = (HSSFWorkbook)map.get("WorkBook");
            int nextYearPoint = (Integer)map.get("NextYear");
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            hssfWorkBook.write((OutputStream)bos);
            byte[] data = bos.toByteArray();
            bos.close();
            mapValue.put("data", data);
            mapValue.put("nextYearPoint", nextYearPoint);
        }
        catch (Exception ex) {
            new BOSException((Throwable)ex);
        }
        return mapValue;
    }

    private int createHeadByMonth(HashMap paramMap, HSSFWorkbook hssfWorkBook, HSSFSheet sheet, int rowNum, Context ctx) throws Exception {
        int startYear = (Integer)paramMap.get("startYear");
        int startMonth = (Integer)paramMap.get("startMonth");
        int endYear = (Integer)paramMap.get("endYear");
        int endMonth = (Integer)paramMap.get("endMonth");
        PersonPlanType ppType = (PersonPlanType)((Object)paramMap.get("ppType"));
        String positionStr = paramMap.get("positionStr").toString();
        String jobStr = paramMap.get("jobStr").toString();
        String yearStr = paramMap.get("yearStr").toString();
        String monthStr = paramMap.get("monthStr").toString();
        HSSFCellStyle titleStyle = this.createTitleCellStyle(hssfWorkBook, ctx);
        int startMonthCount = startYear * 12 + startMonth + 1;
        int endMonthCount = endYear * 12 + endMonth + 1;
        int colmnLength = endMonthCount - startMonthCount + 1;
        HSSFRow headRow = sheet.createRow(rowNum);
        int count = 0;
        HSSFCell cell1 = headRow.createCell(0);
        cell1.setCellType(CellType.STRING);
        cell1.setCellValue(ResourceBase.getString((String)"com.kingdee.eas.hr.org.ORGAutoGenerateResource", (String)"8_PersonPlanControllerBean", (Locale)ctx.getLocale()));
        cell1.setCellStyle(titleStyle);
        HSSFCell cell2 = headRow.createCell(1);
        cell2.setCellType(CellType.STRING);
        cell2.setCellValue(ResourceBase.getString((String)"com.kingdee.eas.hr.org.ORGAutoGenerateResource", (String)"61_PersonPlanControllerBean", (Locale)ctx.getLocale()));
        cell2.setCellStyle(titleStyle);
        HSSFCell cell3 = headRow.createCell(2);
        cell3.setCellType(CellType.STRING);
        cell3.setCellValue(ResourceBase.getString((String)"com.kingdee.eas.hr.org.ORGAutoGenerateResource", (String)"9_PersonPlanControllerBean", (Locale)ctx.getLocale()));
        cell3.setCellStyle(titleStyle);
        count = 3;
        HSSFCell cell4 = headRow.createCell(3);
        HSSFCell cell5 = headRow.createCell(4);
        if (ppType == PersonPlanType.POSITION) {
            cell4.setCellType(CellType.STRING);
            cell4.setCellValue(ResourceBase.getString((String)"com.kingdee.eas.hr.org.ORGAutoGenerateResource", (String)"10_PersonPlanControllerBean", (Locale)ctx.getLocale()));
            cell4.setCellStyle(titleStyle);
            cell5.setCellType(CellType.STRING);
            cell5.setCellValue(positionStr);
            cell5.setCellStyle(titleStyle);
            count = 5;
        } else if (ppType == PersonPlanType.JOB) {
            cell4.setCellType(CellType.STRING);
            cell4.setCellValue(ResourceBase.getString((String)"com.kingdee.eas.hr.org.ORGAutoGenerateResource", (String)"11_PersonPlanControllerBean", (Locale)ctx.getLocale()));
            cell4.setCellStyle(titleStyle);
            cell5.setCellType(CellType.STRING);
            cell5.setCellValue(jobStr);
            cell5.setCellStyle(titleStyle);
            count = 5;
        }
        int tempYear = startYear;
        int j = startMonth;
        for (int i = count; i < colmnLength + count; ++i) {
            HSSFCell cell = headRow.createCell((int)((short)i));
            cell.setCellType(CellType.STRING);
            cell.setCellValue(tempYear + yearStr + (j + 1) + monthStr);
            cell.setCellStyle(titleStyle);
            if (j == 11) {
                j = 0;
                ++tempYear;
                continue;
            }
            ++j;
        }
        return ++rowNum;
    }

    private int createHeadByQuarter(HashMap paramMap, HSSFWorkbook hssfWorkBook, HSSFSheet sheet, int rowNum, Context ctx) throws Exception {
        int startYear = (Integer)paramMap.get("startYear");
        int startMonth = (Integer)paramMap.get("startMonth");
        int endYear = (Integer)paramMap.get("endYear");
        int endMonth = (Integer)paramMap.get("endMonth");
        PersonPlanType ppType = (PersonPlanType)((Object)paramMap.get("ppType"));
        String positionStr = paramMap.get("positionStr").toString();
        String jobStr = paramMap.get("jobStr").toString();
        String yearStr = paramMap.get("yearStr").toString();
        String quarterStr = paramMap.get("quarterStr").toString();
        HSSFCellStyle titleStyle = this.createTitleCellStyle(hssfWorkBook, ctx);
        int startMonthCount = startYear * 4 + startMonth + 1;
        int endMonthCount = endYear * 4 + endMonth + 1;
        int colmnLength = endMonthCount - startMonthCount + 1;
        int count = 0;
        HSSFRow headRow = sheet.createRow(rowNum);
        HSSFCell cell1 = headRow.createCell(0);
        cell1.setCellType(CellType.STRING);
        cell1.setCellValue(ResourceBase.getString((String)"com.kingdee.eas.hr.org.ORGAutoGenerateResource", (String)"8_PersonPlanControllerBean", (Locale)ctx.getLocale()));
        cell1.setCellStyle(titleStyle);
        HSSFCell cell2 = headRow.createCell(1);
        cell2.setCellType(CellType.STRING);
        cell2.setCellValue(ResourceBase.getString((String)"com.kingdee.eas.hr.org.ORGAutoGenerateResource", (String)"61_PersonPlanControllerBean", (Locale)ctx.getLocale()));
        cell2.setCellStyle(titleStyle);
        HSSFCell cell3 = headRow.createCell(2);
        cell3.setCellType(CellType.STRING);
        cell3.setCellValue(ResourceBase.getString((String)"com.kingdee.eas.hr.org.ORGAutoGenerateResource", (String)"9_PersonPlanControllerBean", (Locale)ctx.getLocale()));
        cell3.setCellStyle(titleStyle);
        count = 3;
        HSSFCell cell4 = headRow.createCell(3);
        HSSFCell cell5 = headRow.createCell(4);
        if (ppType == PersonPlanType.POSITION) {
            cell4.setCellType(CellType.STRING);
            cell4.setCellValue(ResourceBase.getString((String)"com.kingdee.eas.hr.org.ORGAutoGenerateResource", (String)"10_PersonPlanControllerBean", (Locale)ctx.getLocale()));
            cell4.setCellStyle(titleStyle);
            cell5.setCellType(CellType.STRING);
            cell5.setCellValue(positionStr);
            cell5.setCellStyle(titleStyle);
            count = 5;
        } else if (ppType == PersonPlanType.JOB) {
            cell4.setCellType(CellType.STRING);
            cell4.setCellValue(ResourceBase.getString((String)"com.kingdee.eas.hr.org.ORGAutoGenerateResource", (String)"11_PersonPlanControllerBean", (Locale)ctx.getLocale()));
            cell4.setCellStyle(titleStyle);
            cell5.setCellType(CellType.STRING);
            cell5.setCellValue(jobStr);
            cell5.setCellStyle(titleStyle);
            count = 5;
        }
        int tempYear = startYear;
        int j = startMonth;
        for (int i = count; i < colmnLength + count; ++i) {
            HSSFCell cell = headRow.createCell((int)((short)i));
            cell.setCellType(CellType.STRING);
            cell.setCellValue(tempYear + yearStr + (j + 1) + quarterStr);
            cell.setCellStyle(titleStyle);
            if (j == 3) {
                j = 0;
                ++tempYear;
                continue;
            }
            ++j;
        }
        return ++rowNum;
    }

    private int createHeadByHalfYear(HashMap paramMap, HSSFWorkbook hssfWorkBook, HSSFSheet sheet, int rowNum, Context ctx) throws Exception {
        int startYear = (Integer)paramMap.get("startYear");
        int startMonth = (Integer)paramMap.get("startMonth");
        int endYear = (Integer)paramMap.get("endYear");
        int endMonth = (Integer)paramMap.get("endMonth");
        PersonPlanType ppType = (PersonPlanType)((Object)paramMap.get("ppType"));
        String positionStr = paramMap.get("positionStr").toString();
        String jobStr = paramMap.get("jobStr").toString();
        String yearStr = paramMap.get("yearStr").toString();
        String firstHalfYearStr = paramMap.get("firstHalfYearStr").toString();
        String secondHalfYearStr = paramMap.get("secondHalfYearStr").toString();
        HSSFCellStyle titleStyle = this.createTitleCellStyle(hssfWorkBook, ctx);
        int startMonthCount = startYear * 2 + startMonth + 1;
        int endMonthCount = endYear * 2 + endMonth + 1;
        int colmnLength = endMonthCount - startMonthCount + 1;
        int count = 0;
        HSSFRow headRow = sheet.createRow(rowNum);
        HSSFCell cell1 = headRow.createCell(0);
        cell1.setCellType(CellType.STRING);
        cell1.setCellValue(ResourceBase.getString((String)"com.kingdee.eas.hr.org.ORGAutoGenerateResource", (String)"8_PersonPlanControllerBean", (Locale)ctx.getLocale()));
        cell1.setCellStyle(titleStyle);
        HSSFCell cell2 = headRow.createCell(1);
        cell2.setCellType(CellType.STRING);
        cell2.setCellValue(ResourceBase.getString((String)"com.kingdee.eas.hr.org.ORGAutoGenerateResource", (String)"61_PersonPlanControllerBean", (Locale)ctx.getLocale()));
        cell2.setCellStyle(titleStyle);
        HSSFCell cell3 = headRow.createCell(2);
        cell3.setCellType(CellType.STRING);
        cell3.setCellValue(ResourceBase.getString((String)"com.kingdee.eas.hr.org.ORGAutoGenerateResource", (String)"9_PersonPlanControllerBean", (Locale)ctx.getLocale()));
        cell3.setCellStyle(titleStyle);
        count = 3;
        HSSFCell cell4 = headRow.createCell(3);
        HSSFCell cell5 = headRow.createCell(4);
        if (ppType == PersonPlanType.POSITION) {
            cell4.setCellType(CellType.STRING);
            cell4.setCellValue(ResourceBase.getString((String)"com.kingdee.eas.hr.org.ORGAutoGenerateResource", (String)"10_PersonPlanControllerBean", (Locale)ctx.getLocale()));
            cell4.setCellStyle(titleStyle);
            cell5.setCellType(CellType.STRING);
            cell5.setCellValue(positionStr);
            cell5.setCellStyle(titleStyle);
            count = 5;
        } else if (ppType == PersonPlanType.JOB) {
            cell4.setCellType(CellType.STRING);
            cell4.setCellValue(ResourceBase.getString((String)"com.kingdee.eas.hr.org.ORGAutoGenerateResource", (String)"11_PersonPlanControllerBean", (Locale)ctx.getLocale()));
            cell4.setCellStyle(titleStyle);
            cell5.setCellType(CellType.STRING);
            cell5.setCellValue(jobStr);
            cell5.setCellStyle(titleStyle);
            count = 5;
        }
        int tempYear = startYear;
        String tempStr = null;
        int j = startMonth;
        for (int i = count; i < colmnLength + count; ++i) {
            tempStr = tempYear + yearStr;
            tempStr = j == 0 ? tempStr + firstHalfYearStr : tempStr + secondHalfYearStr;
            HSSFCell cell = headRow.createCell((int)((short)i));
            cell.setCellType(CellType.STRING);
            cell.setCellValue(tempStr);
            cell.setCellStyle(titleStyle);
            if (j == 0) {
                j = 1;
                continue;
            }
            ++tempYear;
            j = 0;
        }
        return ++rowNum;
    }

    private int createHeadByYear(HashMap paramMap, HSSFWorkbook hssfWorkBook, HSSFSheet sheet, int rowNum, Context ctx) throws Exception {
        int startYear = (Integer)paramMap.get("startYear");
        int endYear = (Integer)paramMap.get("endYear");
        PersonPlanType ppType = (PersonPlanType)((Object)paramMap.get("ppType"));
        String positionStr = paramMap.get("positionStr").toString();
        String jobStr = paramMap.get("jobStr").toString();
        String yearStr = paramMap.get("yearStr").toString();
        HSSFCellStyle titleStyle = this.createTitleCellStyle(hssfWorkBook, ctx);
        int colmnLength = endYear - startYear + 1;
        int count = 0;
        HSSFRow headRow = sheet.createRow(rowNum);
        HSSFCell cell1 = headRow.createCell(0);
        cell1.setCellType(CellType.STRING);
        cell1.setCellValue(ResourceBase.getString((String)"com.kingdee.eas.hr.org.ORGAutoGenerateResource", (String)"8_PersonPlanControllerBean", (Locale)ctx.getLocale()));
        cell1.setCellStyle(titleStyle);
        HSSFCell cell2 = headRow.createCell(1);
        cell2.setCellType(CellType.STRING);
        cell2.setCellValue(ResourceBase.getString((String)"com.kingdee.eas.hr.org.ORGAutoGenerateResource", (String)"61_PersonPlanControllerBean", (Locale)ctx.getLocale()));
        cell2.setCellStyle(titleStyle);
        HSSFCell cell3 = headRow.createCell(2);
        cell3.setCellType(CellType.STRING);
        cell3.setCellValue(ResourceBase.getString((String)"com.kingdee.eas.hr.org.ORGAutoGenerateResource", (String)"9_PersonPlanControllerBean", (Locale)ctx.getLocale()));
        cell3.setCellStyle(titleStyle);
        count = 3;
        HSSFCell cell4 = headRow.createCell(3);
        HSSFCell cell5 = headRow.createCell(4);
        if (ppType == PersonPlanType.POSITION) {
            cell4.setCellType(CellType.STRING);
            cell4.setCellValue(ResourceBase.getString((String)"com.kingdee.eas.hr.org.ORGAutoGenerateResource", (String)"10_PersonPlanControllerBean", (Locale)ctx.getLocale()));
            cell4.setCellStyle(titleStyle);
            cell5.setCellType(CellType.STRING);
            cell5.setCellValue(positionStr);
            cell5.setCellStyle(titleStyle);
            count = 5;
        } else if (ppType == PersonPlanType.JOB) {
            cell4.setCellType(CellType.STRING);
            cell4.setCellValue(ResourceBase.getString((String)"com.kingdee.eas.hr.org.ORGAutoGenerateResource", (String)"11_PersonPlanControllerBean", (Locale)ctx.getLocale()));
            cell4.setCellStyle(titleStyle);
            cell5.setCellType(CellType.STRING);
            cell5.setCellValue(jobStr);
            cell5.setCellStyle(titleStyle);
            count = 5;
        }
        int tempYear = startYear;
        for (int i = count; i < colmnLength + count; ++i) {
            HSSFCell cell = headRow.createCell((int)((short)i));
            cell.setCellType(CellType.STRING);
            cell.setCellValue(tempYear + yearStr);
            cell.setCellStyle(titleStyle);
            ++tempYear;
        }
        return ++rowNum;
    }

    private void loadTableDataByMonth(Context ctx, HashMap paramMap, HSSFWorkbook hssfWorkBook, HSSFSheet sheet, int rowNum, IRowSet rows) throws Exception {
        int startYear = (Integer)paramMap.get("startYear");
        int startMonth = (Integer)paramMap.get("startMonth");
        int endYear = (Integer)paramMap.get("endYear");
        int endMonth = (Integer)paramMap.get("endMonth");
        PersonPlanType ppType = (PersonPlanType)((Object)paramMap.get("ppType"));
        PersonPlanSchemeInfo schemeInfo = (PersonPlanSchemeInfo)paramMap.get("schemeInfo");
        HSSFCellStyle cellStyle = this.createValueCellStyle(hssfWorkBook, ctx);
        int startMonthCount = startYear * 12 + startMonth + 1;
        int endMonthCount = endYear * 12 + endMonth + 1;
        int colmnLength = endMonthCount - startMonthCount + 1;
        HSSFRow headRow = null;
        int tempYear = startYear;
        String objId = null;
        ArrayList list = null;
        ArrayList<String> monthList = new ArrayList<String>();
        if (ppType != PersonPlanType.PERSON) {
            int j = startMonth;
            int size = colmnLength + 1;
            for (int i = 1; i < size; ++i) {
                monthList.add(tempYear + "-@@-" + (j + 1));
                if (j == 11) {
                    j = 0;
                    ++tempYear;
                    continue;
                }
                ++j;
            }
            HashMap mapValue = this.getHistoryDatas(ctx, schemeInfo.getId().toString(), ppType, monthList, rows);
            rows.beforeFirst();
            String preAdmin = "";
            while (rows.next()) {
                HSSFCell cell;
                int i;
                int size2;
                HSSFCell cell5;
                HSSFCell cell4;
                headRow = sheet.createRow(rowNum);
                objId = rows.getString("id");
                HSSFCell cell1 = headRow.createCell(0);
                cell1.setCellType(CellType.STRING);
                cell1.setCellValue(rows.getString("AdminUnit.number"));
                cell1.setCellStyle(cellStyle);
                HSSFCell cell2 = headRow.createCell(1);
                cell2.setCellType(CellType.STRING);
                cell2.setCellValue(rows.getString("AdminUnit.displayName"));
                cell2.setCellStyle(cellStyle);
                int level = Integer.parseInt(rows.getString("AdminUnit.level"));
                StringBuffer adminName = new StringBuffer();
                for (int i2 = 0; i2 < level; ++i2) {
                    adminName.append("  ");
                }
                adminName.append(rows.getString("AdminUnit.name"));
                HSSFCell cell3 = headRow.createCell(2);
                cell3.setCellType(CellType.STRING);
                cell3.setCellStyle(cellStyle);
                if (preAdmin == rows.getString("AdminUnit.name")) {
                    cell3.setCellValue("");
                } else {
                    cell3.setCellValue(adminName.toString());
                }
                preAdmin = rows.getString("AdminUnit.name");
                if (ppType == PersonPlanType.POSITION) {
                    cell4 = headRow.createCell(3);
                    cell4.setCellType(CellType.STRING);
                    cell4.setCellValue(rows.getString("number"));
                    cell4.setCellStyle(cellStyle);
                    cell5 = headRow.createCell(4);
                    cell5.setCellType(CellType.STRING);
                    cell5.setCellValue(rows.getString("name"));
                    cell5.setCellStyle(cellStyle);
                } else if (ppType == PersonPlanType.JOB) {
                    cell4 = headRow.createCell(3);
                    cell4.setCellType(CellType.STRING);
                    cell4.setCellValue(rows.getString("number"));
                    cell4.setCellStyle(cellStyle);
                    cell5 = headRow.createCell(4);
                    cell5.setCellType(CellType.STRING);
                    cell5.setCellValue(rows.getString("name"));
                    cell5.setCellStyle(cellStyle);
                }
                String key = rows.getString("AdminUnit.id") + "~" + objId;
                if (mapValue.get(key) != null) {
                    list = (ArrayList)mapValue.get(key);
                    size2 = colmnLength + 5;
                    for (i = 5; i < size2; ++i) {
                        cell = headRow.createCell((int)((short)i));
                        cell.setCellType(CellType.STRING);
                        cell.setCellStyle(cellStyle);
                        if (list.size() > i - 5 && list.get(i - 5) != null && !"".equals(list.get(i - 5).toString().trim())) {
                            cell.setCellValue(list.get(i - 5).toString());
                            continue;
                        }
                        cell.setCellValue("0");
                    }
                } else {
                    size2 = colmnLength + 5;
                    for (i = 5; i < size2; ++i) {
                        cell = headRow.createCell((int)((short)i));
                        cell.setCellType(CellType.STRING);
                        cell.setCellStyle(cellStyle);
                        cell.setCellValue("0");
                    }
                }
                ++rowNum;
            }
        } else {
            int j = startMonth;
            int size = colmnLength + 1;
            for (int i = 1; i < size; ++i) {
                monthList.add(tempYear + "-@@-" + (j + 1));
                if (j == 11) {
                    j = 0;
                    ++tempYear;
                    continue;
                }
                ++j;
            }
            this.loadAdminDataByPerson(ctx, monthList, paramMap, rowNum, rows, hssfWorkBook, sheet);
            ++rowNum;
        }
    }

    private void loadTableDataByQuarter(Context ctx, HashMap paramMap, HSSFWorkbook hssfWorkBook, HSSFSheet sheet, int rowNum, IRowSet rows) throws Exception {
        int startYear = (Integer)paramMap.get("startYear");
        int startMonth = (Integer)paramMap.get("startMonth");
        int endYear = (Integer)paramMap.get("endYear");
        int endMonth = (Integer)paramMap.get("endMonth");
        PersonPlanType ppType = (PersonPlanType)((Object)paramMap.get("ppType"));
        PersonPlanSchemeInfo schemeInfo = (PersonPlanSchemeInfo)paramMap.get("schemeInfo");
        HSSFCellStyle cellStyle = this.createValueCellStyle(hssfWorkBook, ctx);
        int startMonthCount = startYear * 4 + startMonth + 1;
        int endMonthCount = endYear * 4 + endMonth + 1;
        int colmnLength = endMonthCount - startMonthCount + 1;
        HSSFRow headRow = null;
        int tempYear = startYear;
        String objId = null;
        ArrayList list = null;
        ArrayList<String> monthList = new ArrayList<String>();
        if (ppType != PersonPlanType.PERSON) {
            int j = startMonth;
            int size = colmnLength + 1;
            for (int i = 1; i < size; ++i) {
                monthList.add(tempYear + "-@@-" + (j + 1) * 3);
                if (j == 3) {
                    j = 0;
                    ++tempYear;
                    continue;
                }
                ++j;
            }
            HashMap mapValue = this.getHistoryDatas(ctx, schemeInfo.getId().toString(), ppType, monthList, rows);
            rows.beforeFirst();
            String preAdmin = "";
            while (rows.next()) {
                HSSFCell cell;
                int i;
                int size2;
                HSSFCell cell5;
                HSSFCell cell4;
                objId = rows.getString("id");
                headRow = sheet.createRow(rowNum);
                HSSFCell cell1 = headRow.createCell(0);
                cell1.setCellType(CellType.STRING);
                cell1.setCellValue(rows.getString("AdminUnit.number"));
                cell1.setCellStyle(cellStyle);
                HSSFCell cell2 = headRow.createCell(1);
                cell2.setCellType(CellType.STRING);
                cell2.setCellValue(rows.getString("AdminUnit.displayName"));
                cell2.setCellStyle(cellStyle);
                int level = Integer.parseInt(rows.getString("AdminUnit.level"));
                StringBuffer adminName = new StringBuffer();
                for (int i2 = 0; i2 < level; ++i2) {
                    adminName.append("  ");
                }
                adminName.append(rows.getString("AdminUnit.name"));
                HSSFCell cell3 = headRow.createCell(2);
                cell3.setCellType(CellType.STRING);
                cell3.setCellStyle(cellStyle);
                if (preAdmin == rows.getString("AdminUnit.name")) {
                    cell3.setCellValue("");
                } else {
                    cell3.setCellValue(adminName.toString());
                }
                preAdmin = rows.getString("AdminUnit.name");
                if (ppType == PersonPlanType.POSITION) {
                    cell4 = headRow.createCell(3);
                    cell4.setCellType(CellType.STRING);
                    cell4.setCellValue(rows.getString("number"));
                    cell4.setCellStyle(cellStyle);
                    cell5 = headRow.createCell(4);
                    cell5.setCellType(CellType.STRING);
                    cell5.setCellValue(rows.getString("name"));
                    cell5.setCellStyle(cellStyle);
                } else if (ppType == PersonPlanType.JOB) {
                    cell4 = headRow.createCell(3);
                    cell4.setCellType(CellType.STRING);
                    cell4.setCellValue(rows.getString("number"));
                    cell4.setCellStyle(cellStyle);
                    cell5 = headRow.createCell(4);
                    cell5.setCellType(CellType.STRING);
                    cell5.setCellValue(rows.getString("name"));
                    cell5.setCellStyle(cellStyle);
                }
                String key = rows.getString("AdminUnit.id") + "~" + objId;
                if (mapValue.get(key) != null) {
                    list = (ArrayList)mapValue.get(key);
                    size2 = colmnLength + 5;
                    for (i = 5; i < size2; ++i) {
                        cell = headRow.createCell((int)((short)i));
                        cell.setCellType(CellType.STRING);
                        cell.setCellStyle(cellStyle);
                        if (list.size() > i - 5 && list.get(i - 5) != null && !"".equals(list.get(i - 5).toString().trim())) {
                            cell.setCellValue(list.get(i - 5).toString());
                            continue;
                        }
                        cell.setCellValue("0");
                    }
                } else {
                    size2 = colmnLength + 5;
                    for (i = 5; i < size2; ++i) {
                        cell = headRow.createCell((int)((short)i));
                        cell.setCellType(CellType.STRING);
                        cell.setCellStyle(cellStyle);
                        cell.setCellValue("0");
                    }
                }
                ++rowNum;
            }
        } else {
            int j = startMonth;
            int size = colmnLength + 2;
            for (int i = 2; i < size; ++i) {
                monthList.add(tempYear + "-@@-" + (j + 1) * 3);
                if (j == 3) {
                    j = 0;
                    ++tempYear;
                    continue;
                }
                ++j;
            }
            this.loadAdminDataByPerson(ctx, monthList, paramMap, rowNum, rows, hssfWorkBook, sheet);
            ++rowNum;
        }
    }

    private void loadTableDataByHalfYear(Context ctx, HashMap paramMap, HSSFWorkbook hssfWorkBook, HSSFSheet sheet, int rowNum, IRowSet rows) throws Exception {
        int startYear = (Integer)paramMap.get("startYear");
        int startMonth = (Integer)paramMap.get("startMonth");
        int endYear = (Integer)paramMap.get("endYear");
        int endMonth = (Integer)paramMap.get("endMonth");
        PersonPlanType ppType = (PersonPlanType)((Object)paramMap.get("ppType"));
        PersonPlanSchemeInfo schemeInfo = (PersonPlanSchemeInfo)paramMap.get("schemeInfo");
        HSSFCellStyle cellStyle = this.createValueCellStyle(hssfWorkBook, ctx);
        int startMonthCount = startYear * 2 + startMonth + 1;
        int endMonthCount = endYear * 2 + endMonth + 1;
        int colmnLength = endMonthCount - startMonthCount + 1;
        HSSFRow headRow = null;
        int tempYear = startYear;
        String objId = null;
        ArrayList list = null;
        ArrayList<String> monthList = new ArrayList<String>();
        if (ppType != PersonPlanType.PERSON) {
            int j = startMonth;
            int size = colmnLength + 1;
            for (int i = 1; i < size; ++i) {
                monthList.add(tempYear + "-@@-" + (j + 1) * 6);
                if (j == 0) {
                    j = 1;
                    continue;
                }
                ++tempYear;
                j = 0;
            }
            HashMap mapValue = this.getHistoryDatas(ctx, schemeInfo.getId().toString(), ppType, monthList, rows);
            rows.beforeFirst();
            String preAdmin = "";
            while (rows.next()) {
                HSSFCell cell;
                int i;
                int size2;
                HSSFCell cell5;
                HSSFCell cell4;
                objId = rows.getString("id");
                headRow = sheet.createRow(rowNum);
                HSSFCell cell1 = headRow.createCell(0);
                cell1.setCellType(CellType.STRING);
                cell1.setCellValue(rows.getString("AdminUnit.number"));
                cell1.setCellStyle(cellStyle);
                HSSFCell cell2 = headRow.createCell(1);
                cell2.setCellType(CellType.STRING);
                cell2.setCellValue(rows.getString("AdminUnit.displayName"));
                cell2.setCellStyle(cellStyle);
                int level = Integer.parseInt(rows.getString("AdminUnit.level"));
                StringBuffer adminName = new StringBuffer();
                for (int i2 = 0; i2 < level; ++i2) {
                    adminName.append("  ");
                }
                adminName.append(rows.getString("AdminUnit.name"));
                HSSFCell cell3 = headRow.createCell(2);
                cell3.setCellType(CellType.STRING);
                cell3.setCellStyle(cellStyle);
                if (preAdmin == rows.getString("AdminUnit.name")) {
                    cell3.setCellValue("");
                } else {
                    cell3.setCellValue(adminName.toString());
                }
                preAdmin = rows.getString("AdminUnit.name");
                if (ppType == PersonPlanType.POSITION) {
                    cell4 = headRow.createCell(3);
                    cell4.setCellType(CellType.STRING);
                    cell4.setCellValue(rows.getString("number"));
                    cell4.setCellStyle(cellStyle);
                    cell5 = headRow.createCell(4);
                    cell5.setCellType(CellType.STRING);
                    cell5.setCellValue(rows.getString("name"));
                    cell5.setCellStyle(cellStyle);
                } else if (ppType == PersonPlanType.JOB) {
                    cell4 = headRow.createCell(3);
                    cell4.setCellType(CellType.STRING);
                    cell4.setCellValue(rows.getString("number"));
                    cell4.setCellStyle(cellStyle);
                    cell5 = headRow.createCell(4);
                    cell5.setCellType(CellType.STRING);
                    cell5.setCellValue(rows.getString("name"));
                    cell5.setCellStyle(cellStyle);
                }
                String key = rows.getString("AdminUnit.id") + "~" + objId;
                if (mapValue.get(key) != null) {
                    list = (ArrayList)mapValue.get(key);
                    size2 = colmnLength + 5;
                    for (i = 5; i < size2; ++i) {
                        cell = headRow.createCell((int)((short)i));
                        cell.setCellType(CellType.STRING);
                        cell.setCellStyle(cellStyle);
                        if (list.size() > i - 5 && list.get(i - 5) != null && !"".equals(list.get(i - 5).toString().trim())) {
                            cell.setCellValue(list.get(i - 5).toString());
                            continue;
                        }
                        cell.setCellValue("0");
                    }
                } else {
                    size2 = colmnLength + 5;
                    for (i = 5; i < size2; ++i) {
                        cell = headRow.createCell((int)((short)i));
                        cell.setCellType(CellType.STRING);
                        cell.setCellStyle(cellStyle);
                        cell.setCellValue("0");
                    }
                }
                ++rowNum;
            }
        } else {
            int j = startMonth;
            int size = colmnLength + 1;
            for (int i = 1; i < size; ++i) {
                monthList.add(tempYear + "-@@-" + (j + 1) * 6);
                if (j == 0) {
                    j = 1;
                    continue;
                }
                ++tempYear;
                j = 0;
            }
            this.loadAdminDataByPerson(ctx, monthList, paramMap, rowNum, rows, hssfWorkBook, sheet);
            ++rowNum;
        }
    }

    private void loadTableDataByYear(Context ctx, HashMap paramMap, HSSFWorkbook hssfWorkBook, HSSFSheet sheet, int rowNum, IRowSet rows) throws Exception {
        int startYear = (Integer)paramMap.get("startYear");
        int endYear = (Integer)paramMap.get("endYear");
        PersonPlanType ppType = (PersonPlanType)((Object)paramMap.get("ppType"));
        PersonPlanSchemeInfo schemeInfo = (PersonPlanSchemeInfo)paramMap.get("schemeInfo");
        HSSFCellStyle cellStyle = this.createValueCellStyle(hssfWorkBook, ctx);
        int colmnLength = endYear - startYear + 1;
        HSSFRow headRow = null;
        int tempYear = startYear;
        String objId = null;
        ArrayList list = null;
        ArrayList<String> monthList = new ArrayList<String>();
        if (ppType != PersonPlanType.PERSON) {
            int size = colmnLength + 1;
            for (int i = 1; i < size; ++i) {
                monthList.add(tempYear + "-@@-" + 12);
                ++tempYear;
            }
            HashMap mapValue = this.getHistoryDatas(ctx, schemeInfo.getId().toString(), ppType, monthList, rows);
            rows.beforeFirst();
            Object posiInfo = null;
            Object jobInfo = null;
            String preAdmin = "";
            while (rows.next()) {
                HSSFCell cell;
                int i;
                int size2;
                HSSFCell cell5;
                HSSFCell cell4;
                objId = rows.getString("id");
                headRow = sheet.createRow(rowNum);
                HSSFCell cell1 = headRow.createCell(0);
                cell1.setCellType(CellType.STRING);
                cell1.setCellValue(rows.getString("AdminUnit.number"));
                cell1.setCellStyle(cellStyle);
                HSSFCell cell2 = headRow.createCell(1);
                cell2.setCellType(CellType.STRING);
                cell2.setCellValue(rows.getString("AdminUnit.displayName"));
                cell2.setCellStyle(cellStyle);
                int level = Integer.parseInt(rows.getString("AdminUnit.level"));
                StringBuffer adminName = new StringBuffer();
                for (int i2 = 0; i2 < level; ++i2) {
                    adminName.append("  ");
                }
                adminName.append(rows.getString("AdminUnit.name"));
                HSSFCell cell3 = headRow.createCell(2);
                cell3.setCellType(CellType.STRING);
                cell3.setCellStyle(cellStyle);
                if (preAdmin == rows.getString("AdminUnit.name")) {
                    cell3.setCellValue("");
                } else {
                    cell3.setCellValue(adminName.toString());
                }
                preAdmin = rows.getString("AdminUnit.name");
                if (ppType == PersonPlanType.POSITION) {
                    cell4 = headRow.createCell(3);
                    cell4.setCellType(CellType.STRING);
                    cell4.setCellValue(rows.getString("number"));
                    cell4.setCellStyle(cellStyle);
                    cell5 = headRow.createCell(4);
                    cell5.setCellType(CellType.STRING);
                    cell5.setCellValue(rows.getString("name"));
                    cell5.setCellStyle(cellStyle);
                } else if (ppType == PersonPlanType.JOB) {
                    cell4 = headRow.createCell(3);
                    cell4.setCellType(CellType.STRING);
                    cell4.setCellValue(rows.getString("number"));
                    cell4.setCellStyle(cellStyle);
                    cell5 = headRow.createCell(4);
                    cell5.setCellType(CellType.STRING);
                    cell5.setCellValue(rows.getString("name"));
                    cell5.setCellStyle(cellStyle);
                }
                String key = rows.getString("AdminUnit.id") + "~" + objId;
                if (mapValue.get(key) != null) {
                    list = (ArrayList)mapValue.get(key);
                    size2 = colmnLength + 5;
                    for (i = 5; i < size2; ++i) {
                        cell = headRow.createCell((int)((short)i));
                        cell.setCellType(CellType.STRING);
                        cell.setCellStyle(cellStyle);
                        if (list.size() > i - 5 && list.get(i - 5) != null && !"".equals(list.get(i - 5).toString().trim())) {
                            cell.setCellValue(list.get(i - 5).toString());
                            continue;
                        }
                        cell.setCellValue("0");
                    }
                } else {
                    size2 = colmnLength + 5;
                    for (i = 5; i < size2; ++i) {
                        cell = headRow.createCell((int)((short)i));
                        cell.setCellType(CellType.STRING);
                        cell.setCellStyle(cellStyle);
                        cell.setCellValue("0");
                    }
                }
                ++rowNum;
            }
        } else {
            int size = colmnLength + 1;
            for (int i = 1; i < size; ++i) {
                monthList.add(tempYear + "-@@-" + 12);
                ++tempYear;
            }
            this.loadAdminDataByPerson(ctx, monthList, paramMap, rowNum, rows, hssfWorkBook, sheet);
            ++rowNum;
        }
    }

    private void loadAdminDataByPerson(Context ctx, ArrayList monthList, HashMap paramMap, int rowNum, IRowSet rows, HSSFWorkbook hssfWorkBook, HSSFSheet sheet) throws Exception {
        int startYear = (Integer)paramMap.get("startYear");
        int startMonth = (Integer)paramMap.get("startMonth");
        int endYear = (Integer)paramMap.get("endYear");
        int endMonth = (Integer)paramMap.get("endMonth");
        Period period = (Period)((Object)paramMap.get("period"));
        PersonPlanType ppType = (PersonPlanType)((Object)paramMap.get("ppType"));
        PersonPlanSchemeInfo schemeInfo = (PersonPlanSchemeInfo)paramMap.get("schemeInfo");
        HSSFCellStyle cellStyle = this.createValueCellStyle(hssfWorkBook, ctx);
        HSSFRow headRow = null;
        int startMonthCount = 0;
        int endMonthCount = 0;
        int colmnLength = 0;
        if (period == Period.MONTH) {
            startMonthCount = startYear * 12 + startMonth + 1;
            endMonthCount = endYear * 12 + endMonth + 1;
            colmnLength = endMonthCount - startMonthCount + 1;
        } else if (period == Period.QUARTER) {
            startMonthCount = startYear * 4 + startMonth + 1;
            endMonthCount = endYear * 4 + endMonth + 1;
            colmnLength = endMonthCount - startMonthCount + 1;
        } else if (period == Period.HALF_YEAR) {
            startMonthCount = startYear * 2 + startMonth + 1;
            endMonthCount = endYear * 2 + endMonth + 1;
            colmnLength = endMonthCount - startMonthCount + 1;
        } else if (period == Period.YEAR) {
            colmnLength = endYear - startYear + 1;
        }
        HashMap mapValue = this.getHistoryDatas(ctx, schemeInfo.getId().toString(), ppType, monthList, rows);
        rows.beforeFirst();
        while (rows.next()) {
            HSSFCell cell;
            headRow = sheet.createRow(rowNum);
            HSSFCell cell1 = headRow.createCell(0);
            cell1.setCellType(CellType.STRING);
            cell1.setCellValue(rows.getString("AdminUnit.number"));
            cell1.setCellStyle(cellStyle);
            HSSFCell cell2 = headRow.createCell(1);
            cell2.setCellType(CellType.STRING);
            cell2.setCellValue(rows.getString("AdminUnit.displayName"));
            cell2.setCellStyle(cellStyle);
            int level = Integer.parseInt(rows.getString("level"));
            StringBuffer adminName = new StringBuffer();
            for (int i = 0; i < level; ++i) {
                adminName.append("  ");
            }
            adminName.append(rows.getString("AdminUnit.name"));
            HSSFCell cell3 = headRow.createCell(2);
            cell3.setCellType(CellType.STRING);
            cell3.setCellStyle(cellStyle);
            cell3.setCellValue(adminName.toString());
            if (mapValue.get(rows.getString("AdminUnit.id")) != null) {
                ArrayList list = (ArrayList)mapValue.get(rows.getString("AdminUnit.id"));
                int size = colmnLength + 3;
                for (int i = 3; i < size; ++i) {
                    cell = headRow.createCell((int)((short)i));
                    cell.setCellType(CellType.STRING);
                    cell.setCellStyle(cellStyle);
                    if (list.size() > i - 3 && list.get(i - 3) != null && !"".equals(list.get(i - 3).toString().trim())) {
                        cell.setCellValue(list.get(i - 3).toString());
                        continue;
                    }
                    cell.setCellValue("0");
                }
            } else {
                int size = colmnLength + 3;
                for (int i = 3; i < size; ++i) {
                    cell = headRow.createCell((int)((short)i));
                    cell.setCellType(CellType.STRING);
                    cell.setCellStyle(cellStyle);
                    cell.setCellValue("0");
                }
            }
            ++rowNum;
        }
    }

    private HSSFCellStyle createTitleCellStyle(HSSFWorkbook workbook, Context ctx) {
        HSSFCellStyle titleStyle = workbook.createCellStyle();
        titleStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        titleStyle.setFillForegroundColor(IndexedColors.LEMON_CHIFFON.index);
        titleStyle.setAlignment(HorizontalAlignment.CENTER);
        titleStyle.setHidden(false);
        titleStyle.setLocked(false);
        titleStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        HSSFFont defaultFont = workbook.createFont();
        defaultFont.setFontName(ResourceBase.getString((String)"com.kingdee.eas.hr.org.ORGAutoGenerateResource", (String)"12_PersonPlanControllerBean", (Locale)ctx.getLocale()));
        defaultFont.setColor(IndexedColors.GREEN.index);
        short size = 13;
        defaultFont.setFontHeight(size);
        defaultFont.setFontHeightInPoints(size);
        titleStyle.setFont(defaultFont);
        titleStyle.setDataFormat(HSSFDataFormat.getBuiltinFormat((String)"@"));
        return titleStyle;
    }

    private HSSFCellStyle createValueCellStyle(HSSFWorkbook workbook, Context ctx) {
        HSSFCellStyle valueStyle = workbook.createCellStyle();
        valueStyle.setAlignment(HorizontalAlignment.LEFT);
        valueStyle.setHidden(true);
        BorderStyle borderstyle = BorderStyle.DOTTED;
        valueStyle.setBorderLeft(borderstyle);
        valueStyle.setBorderRight(borderstyle);
        valueStyle.setBorderTop(borderstyle);
        valueStyle.setBorderBottom(borderstyle);
        short backColorIndex = IndexedColors.BLACK.index;
        valueStyle.setBottomBorderColor(backColorIndex);
        valueStyle.setTopBorderColor(backColorIndex);
        valueStyle.setLeftBorderColor(backColorIndex);
        valueStyle.setRightBorderColor(backColorIndex);
        valueStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        HSSFFont defaultFont = workbook.createFont();
        defaultFont.setFontName(ResourceBase.getString((String)"com.kingdee.eas.hr.org.ORGAutoGenerateResource", (String)"12_PersonPlanControllerBean", (Locale)ctx.getLocale()));
        defaultFont.setColor(IndexedColors.BLACK.index);
        short size = 12;
        defaultFont.setFontHeightInPoints(size);
        valueStyle.setFont(defaultFont);
        valueStyle.setDataFormat(HSSFDataFormat.getBuiltinFormat((String)"@"));
        return valueStyle;
    }

    private HashMap getHistoryDatas(Context ctx, String schemeId, PersonPlanType planType, ArrayList month, IRowSet rows) throws BOSException, EASBizException {
        HashMap mapValue = null;
        LinkedHashMap yearMap = new LinkedHashMap();
        int year = -1;
        ArrayList<String> monthList = new ArrayList<String>();
        int size = month.size();
        for (int i = 0; i < size; ++i) {
            String[] strList = month.get(i).toString().split("-@@-");
            if (year == -1) {
                year = Integer.parseInt(strList[0]);
            }
            if (year != Integer.parseInt(strList[0])) {
                yearMap.put(year, monthList);
                year = Integer.parseInt(strList[0]);
                monthList = new ArrayList();
            }
            if (i == size - 1) {
                yearMap.put(year, monthList);
            }
            monthList.add(strList[1]);
        }
        mapValue = this.getHistoryCount(ctx, schemeId, planType, yearMap, rows);
        return mapValue;
    }

    private HashMap getHistoryCount(Context ctx, String schemeId, PersonPlanType planType, Map yearMap, IRowSet rows) throws BOSException, EASBizException {
        LinkedHashMap<String, ArrayList> mapValue = new LinkedHashMap<String, ArrayList>();
        ArrayList list = null;
        String tempTableName = this.createTempTable(ctx, rows, planType);
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        Iterator itrYear = yearMap.keySet().iterator();
        while (itrYear.hasNext()) {
            int year = (Integer)itrYear.next();
            StringBuffer sql = new StringBuffer("");
            sql.append("SELECT FPlan1,FPlan2,FPlan3,FPlan4,FPlan5,FPlan6,FPlan7,FPlan8,FPlan9,FPlan10,FPlan11,FPlan12,");
            sql.append("FAdminOrgID,FJobID,FPositionID ");
            sql.append(" FROM T_HR_PersonPlan WHERE FSchemeID='");
            sql.append(schemeId);
            sql.append("' AND FYear=");
            sql.append(year);
            if (planType == PersonPlanType.POSITION) {
                sql.append(" AND FPositionID");
            } else if (planType == PersonPlanType.JOB) {
                sql.append(" AND FJobID");
            } else if (planType == PersonPlanType.PERSON) {
                sql.append(" AND FAdminOrgID");
            }
            sql.append(" in (select fid from ");
            sql.append(tempTableName);
            sql.append(")");
            IRowSet rowResult = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            List monthList = (List)yearMap.get(year);
            try {
                while (rowResult.next()) {
                    if (planType == PersonPlanType.POSITION) {
                        String key = rowResult.getString("FAdminOrgID") + "~" + rowResult.getString("FPositionID");
                        list = mapValue != null && ((HashMap)mapValue).get(key) != null ? (ArrayList)((HashMap)mapValue).get(key) : new ArrayList();
                        mapValue.put(key, list);
                    } else if (planType == PersonPlanType.JOB) {
                        String key = rowResult.getString("FAdminOrgID") + "~" + rowResult.getString("FJobID");
                        list = mapValue != null && ((HashMap)mapValue).get(key) != null ? (ArrayList)((HashMap)mapValue).get(key) : new ArrayList();
                        mapValue.put(key, list);
                    } else if (planType == PersonPlanType.PERSON) {
                        list = mapValue != null && ((HashMap)mapValue).get(rowResult.getString("FAdminOrgID")) != null ? (ArrayList)((HashMap)mapValue).get(rowResult.getString("FAdminOrgID")) : new ArrayList();
                        mapValue.put(rowResult.getString("FAdminOrgID"), list);
                    }
                    int monthCount = monthList.size();
                    for (int i = 0; i < monthCount; ++i) {
                        int month = Integer.parseInt(monthList.get(i).toString());
                        if (rowResult.getString(month) == null && list != null) {
                            list.add(null);
                            continue;
                        }
                        if (list == null) continue;
                        list.add(rowResult.getInt(month));
                    }
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            finally {
                if (StringUtils.isEmpty((String)tempTableName)) continue;
                pool.releaseTable(tempTableName);
            }
        }
        return mapValue;
    }

    private String createTempTable(Context ctx, IRowSet rows, PersonPlanType planType) throws BOSException {
        String tempTableName = "tempTableName";
        Object[] obj = null;
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        StringBuffer createTmpSqlBuf = new StringBuffer();
        createTmpSqlBuf.append("create table ");
        createTmpSqlBuf.append(tempTableName);
        try {
            createTmpSqlBuf.append(" (fid varchar(44))");
            tempTableName = pool.createTempTable(createTmpSqlBuf.toString());
            StringBuffer sqlInsert = new StringBuffer();
            sqlInsert.append(" insert into ");
            sqlInsert.append(tempTableName);
            sqlInsert.append(" values(?)");
            ArrayList<Object[]> paramList = new ArrayList<Object[]>();
            rows.beforeFirst();
            if (planType != PersonPlanType.PERSON) {
                while (rows.next()) {
                    obj = new Object[]{rows.getString("id")};
                    paramList.add(obj);
                }
            } else {
                while (rows.next()) {
                    obj = new Object[]{rows.getString("AdminUnit.id")};
                    paramList.add(obj);
                }
            }
            String sql = "insert into " + tempTableName + " values(?)";
            DbUtil.executeBatch((Context)ctx, (String)sql, paramList);
        }
        catch (Exception e1) {
            throw new BOSException((Throwable)e1);
        }
        return tempTableName;
    }

    @Override
    protected List _getReportData(Context ctx, IObjectValue adminInfo, IObjectValue schemeInfo, int level, boolean isInvalidPosition, boolean showVirtualOrg) throws BOSException, EASBizException {
        return this._getReportData(ctx, adminInfo, schemeInfo, level, isInvalidPosition, showVirtualOrg, false);
    }

    @Override
    protected List _getReportData(Context ctx, IObjectValue adminInfo, IObjectValue schemeInfo, int level, boolean isInvalidPosition, boolean showVirtualOrg, boolean isShowDisableJob) throws BOSException, EASBizException {
        AdminOrgUnitInfo adminOrgInfo = (AdminOrgUnitInfo)adminInfo;
        PersonPlanSchemeInfo ppsInfo = (PersonPlanSchemeInfo)schemeInfo;
        if (Boolean.valueOf(true).equals(adminOrgInfo.get("isMultOrg"))) {
            Object[] orgs = (Object[])adminOrgInfo.get("adminInfos");
            level = 100;
            ppsInfo.put("isOrgMulti", new Boolean(true));
            Map nodeMap = (Map)adminOrgInfo.get("NodeMap");
            List rootAdminList = OrgStringUtil.getRootAdminsFromTree((Map)nodeMap, (Object[])orgs);
            adminOrgInfo.put("adminInfos", (Object)rootAdminList.toArray());
            DefaultKingdeeTreeNode root = OrgStringUtil.reBuildTreeNodeByOrgs((Map)nodeMap, (Object[])orgs, (boolean)showVirtualOrg);
            if (root != null) {
                nodeMap.put(adminOrgInfo.getId().toString(), root);
            }
        } else {
            ppsInfo.put("isOrgMulti", new Boolean(false));
        }
        if (ppsInfo.getPlanType() == PersonPlanType.PERSON) {
            return this.getPersonData(ctx, adminOrgInfo, ppsInfo, level, showVirtualOrg);
        }
        if (ppsInfo.getPlanType() == PersonPlanType.POSITION) {
            return this.getPositionData(ctx, adminOrgInfo, ppsInfo, level, isInvalidPosition, showVirtualOrg);
        }
        if (ppsInfo.getPlanType() == PersonPlanType.JOB) {
            return this.getJobData(ctx, adminOrgInfo, ppsInfo, level, showVirtualOrg, isShowDisableJob);
        }
        return null;
    }

    @Override
    protected List _getImportExcelData(Context ctx, HashMap paramMap) throws BOSException, EASBizException {
        Map map = null;
        try {
            map = this.getHSSFWorkbook(ctx, paramMap);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        HSSFWorkbook hssfWorkBook = (HSSFWorkbook)map.get("WorkBook");
        HSSFSheet sheet = hssfWorkBook.getSheetAt(0);
        HSSFRow row = null;
        HSSFCell cell = null;
        ArrayList<String> list = new ArrayList<String>();
        int headSize = 0;
        Iterator rowIter = sheet.rowIterator();
        while (rowIter.hasNext()) {
            ++headSize;
            row = (HSSFRow)rowIter.next();
            Iterator cellIter = row.cellIterator();
            while (cellIter.hasNext()) {
                cell = (HSSFCell)cellIter.next();
                if (headSize == 1 && StringUtils.isEmpty((String)cell.getStringCellValue())) continue;
                list.add(cell.getStringCellValue());
            }
            list.add("Enter");
        }
        return list;
    }

    private Map getHSSFWorkbook(Context ctx, HashMap paramMap) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Period period = (Period)((Object)paramMap.get("period"));
        int nextYearPoint = (Integer)paramMap.get("nextYearPoint");
        PersonPlanSchemeInfo schemeInfo = (PersonPlanSchemeInfo)paramMap.get("schemeInfo");
        int rowNum = 0;
        IRowSet rows = null;
        HSSFWorkbook hssfWorkBook = new HSSFWorkbook();
        HSSFSheet sheet = hssfWorkBook.createSheet();
        UserInfo currentUser = ContextUtil.getCurrentUserInfo((Context)ctx);
        HROrgUnitInfo currentHRUnit = ContextUtil.getCurrentHRUnit((Context)ctx);
        boolean isFromWF = false;
        boolean isGroup = false;
        if (PersonPlanSchemeTypeEnum.Group.equals((Object)schemeInfo.getSchemeType())) {
            isGroup = true;
        }
        if (paramMap.get("isFromWF") != null) {
            isFromWF = (Boolean)paramMap.get("isFromWF");
        }
        isFromWF &= isGroup;
        String hrOrgID = null;
        hrOrgID = currentHRUnit.getId().toString();
        String sql = "select T1.fid from  t_org_admin T1 LEFT OUTER JOIN T_PM_OrgRange T2 ON T1.fid = T2.FOrgID LEFT OUTER JOIN T_PM_User AS T3 ON T2.FUserID = T3.FID left outer join T_ORG_UNITRELATION u on u.ffromunitid=T1.fid left outer join t_org_hro h on h.fid = u.ftounitid where T2.Ftype=20 and T1.fisSealup = 0 and u.FTYPERELATIONID = '00000000-0000-0000-0000-0000000000100FE9F8B5' and T3.fid='" + currentUser.getId() + "' and h.fid='" + hrOrgID + "'";
        FilterInfo filterFromQuery = (FilterInfo)paramMap.get("queryFilter");
        IQueryExecutor queryExcu = null;
        MetaDataPK queryPK = null;
        if (schemeInfo.getPlanType() == PersonPlanType.POSITION) {
            queryPK = new MetaDataPK("com.kingdee.eas.hr.org.app.PositionsByAdminOrgQuery");
            sheet.setColumnWidth(0, 0);
            sheet.setColumnWidth(2, 0);
        } else if (schemeInfo.getPlanType() == PersonPlanType.JOB) {
            queryPK = new MetaDataPK("com.kingdee.eas.hr.org.app.PositionJobList");
            sheet.setColumnWidth(0, 0);
            sheet.setColumnWidth(2, 0);
        } else {
            queryPK = new MetaDataPK("com.kingdee.eas.hr.org.app.AdminByHROAndUserRangeQuery");
            sheet.setColumnWidth(0, 0);
        }
        if (queryPK != null) {
            queryExcu = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            if (schemeInfo.getPlanType() == PersonPlanType.POSITION && !isFromWF) {
                filterInfo.getFilterItems().add(new FilterItemInfo("AdminUnit.id", (Object)sql, CompareType.INNER));
                filterInfo.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)2, CompareType.NOTEQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("deletedStatus", null, CompareType.IS));
                filterInfo.getFilterItems().add(new FilterItemInfo("id", null, CompareType.NOTEQUALS));
                filterInfo.setMaskString("#0 and (#1 or #2) and #3");
            } else if (schemeInfo.getPlanType() == PersonPlanType.JOB) {
                filterInfo.getFilterItems().add(new FilterItemInfo("state", (Object)2, CompareType.NOTEQUALS));
                if (!isFromWF) {
                    filterInfo.getFilterItems().add(new FilterItemInfo("AdminUnit.id", (Object)sql, CompareType.INNER));
                    filterInfo.setMaskString("#0 and #1");
                }
            } else {
                if (!isFromWF) {
                    filterInfo.getFilterItems().add(new FilterItemInfo("OrgRange.type", (Object)20));
                    filterInfo.getFilterItems().add(new FilterItemInfo("isSealUp", (Object)0));
                    filterInfo.getFilterItems().add(new FilterItemInfo("TypeRela.id", (Object)"00000000-0000-0000-0000-0000000000100FE9F8B5"));
                    filterInfo.getFilterItems().add(new FilterItemInfo("PMUser.id", (Object)currentUser.getId().toString()));
                    filterInfo.getFilterItems().add(new FilterItemInfo("ToUnit.id", (Object)hrOrgID));
                }
                filterInfo.setMaskString("#0 and #1 and #2 and #3 and #4");
            }
            viewInfo.setFilter(filterInfo);
            filterInfo.mergeFilter(filterFromQuery, "AND");
            if (paramMap.get("isShowVirtualOrg") != null && !((Boolean)paramMap.get("isShowVirtualOrg")).booleanValue()) {
                FilterInfo virtualFilter = new FilterInfo("AdminUnit.isVirtual = 0");
                filterInfo.mergeFilter(virtualFilter, "AND");
            }
            queryExcu.setObjectView(viewInfo);
            rows = queryExcu.executeQuery();
        }
        if (period == Period.MONTH) {
            rowNum = this.createHeadByMonth(paramMap, hssfWorkBook, sheet, rowNum, ctx);
            this.loadTableDataByMonth(ctx, paramMap, hssfWorkBook, sheet, rowNum, rows);
            nextYearPoint = 11;
        } else if (period == Period.QUARTER) {
            rowNum = this.createHeadByQuarter(paramMap, hssfWorkBook, sheet, rowNum, ctx);
            this.loadTableDataByQuarter(ctx, paramMap, hssfWorkBook, sheet, rowNum, rows);
            nextYearPoint = 3;
        } else if (period == Period.HALF_YEAR) {
            rowNum = this.createHeadByHalfYear(paramMap, hssfWorkBook, sheet, rowNum, ctx);
            this.loadTableDataByHalfYear(ctx, paramMap, hssfWorkBook, sheet, rowNum, rows);
            nextYearPoint = 1;
        } else if (period == Period.YEAR) {
            rowNum = this.createHeadByYear(paramMap, hssfWorkBook, sheet, rowNum, ctx);
            this.loadTableDataByYear(ctx, paramMap, hssfWorkBook, sheet, rowNum, rows);
            nextYearPoint = 0;
        }
        hssfWorkBook.setSheetName(0, ResourceBase.getString((String)"com.kingdee.eas.hr.org.ImportDataPersonPlanResource", (String)"date_end_input", (Locale)ctx.getLocale()));
        map.put("WorkBook", hssfWorkBook);
        map.put("NextYear", nextYearPoint);
        return map;
    }

    @Override
    protected void _canAddPerson(Context ctx, PosPerPlanInfo addPosper, PosPerPlanInfo delPosper) throws BOSException, EASBizException {
        if (HRUtilExtend.isUseSHRPersonPlan((Context)ctx)) {
            return;
        }
        CtrlUnitInfo cuInfo = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        if (cuInfo == null) {
            return;
        }
        PositionInfo inPosiInfo = addPosper.getPosition();
        if (inPosiInfo != null) {
            String positionId = inPosiInfo.getId().toString();
            String hrOrgId = null;
            IOrgHRCommon iOrgHRCommon = OrgHRCommonFactory.getLocalInstance(ctx);
            if (iOrgHRCommon.getPositionOrgHRO(positionId) == null) {
                return;
            }
            hrOrgId = iOrgHRCommon.getPositionOrgHRO(positionId).getId().toString();
            IPosition iPosition = PositionFactory.getLocalInstance((Context)ctx);
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)positionId));
            PositionInfo posiInfo = iPosition.getPositionInfo((IObjectPK)pk);
            if (posiInfo == null) {
                return;
            }
            AdminOrgUnitInfo adminInfo = posiInfo.getAdminOrgUnit();
            String systemParam = ParamManager.getParamValue((Context)ctx, (IObjectPK)new ObjectUuidPK(hrOrgId), (String)"IS_ALLOW_OVER");
            if ("0".equals(systemParam)) {
                return;
            }
            IPersonPlanScheme iPPScheme = PersonPlanSchemeFactory.getLocalInstance(ctx);
            PersonPlanSchemeInfo schemeInfo = iPPScheme.getDefaultScheme(hrOrgId);
            if (schemeInfo == null) {
                return;
            }
            if (schemeInfo.getStatus() != SchemeStatus.EXECUTE) {
                throw new PersonPlanException(PersonPlanException.NOT_EXCUTE_PERSONPLANSCHEME);
            }
            boolean paramParanormal = this.isCanAllowOver(ctx, schemeInfo, adminInfo.getId().toString(), inPosiInfo, systemParam);
            if (paramParanormal) {
                return;
            }
        }
        PersonPlanSimpleInfo addPpsi = this.getPersonPlanSimpleInfo(ctx, addPosper, 1);
        PersonPlanSimpleInfo delPpsi = this.getPersonPlanSimpleInfo(ctx, delPosper, -1);
        if (addPpsi == null) {
            return;
        }
        addPpsi.add(delPpsi);
        if (!this.checkPersonPlanSimpleInfo(addPpsi, ctx)) {
            throw new PersonPlanException(PersonPlanException.NOT_ADD_PERSON_EXCEED_PLAN);
        }
    }

    @Override
    protected void _canAddPersonBatch(Context ctx, List addList, List delList) throws BOSException, EASBizException {
        boolean paramPartimeOnStr;
        IOrgHRCommon iOrgHRCommon;
        if (HRUtilExtend.isUseSHRPersonPlan((Context)ctx)) {
            return;
        }
        CtrlUnitInfo cuInfo = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        if (cuInfo == null) {
            return;
        }
        if (addList == null || addList.size() <= 0) {
            return;
        }
        HashMap<String, PersonPlanSimpleInfo> ppsiMap = new HashMap<String, PersonPlanSimpleInfo>();
        Map adminHrMap = null;
        HashMap<String, HROInfo> hroInfoMap = new HashMap<String, HROInfo>();
        HashSet<String> adminOrgIdSet = new HashSet<String>();
        Iterator<Object> it = addList.iterator();
        PosPerPlanInfo pppi2 = null;
        while (it.hasNext()) {
            pppi2 = (PosPerPlanInfo)it.next();
            if (pppi2 == null) continue;
            if (pppi2.getAdmin() == null && pppi2.getPosition() != null) {
                pppi2.setAdmin(this.getAdminByPosition(ctx, pppi2.getPosition().getId().toString()));
            }
            if (pppi2.getAdmin() == null) continue;
            adminOrgIdSet.add(pppi2.getAdmin().getId().toString());
        }
        if (delList != null && delList.size() > 0) {
            for (PosPerPlanInfo pppi2 : delList) {
                if (pppi2 == null) continue;
                if (pppi2.getAdmin() == null && pppi2.getPosition() != null) {
                    pppi2.setAdmin(this.getAdminByPosition(ctx, pppi2.getPosition().getId().toString()));
                }
                if (pppi2.getAdmin() == null) continue;
                adminOrgIdSet.add(pppi2.getAdmin().getId().toString());
            }
        }
        if ((adminHrMap = (iOrgHRCommon = OrgHRCommonFactory.getLocalInstance(ctx)).getAdminOrgHROBatch(adminOrgIdSet)) == null) {
            return;
        }
        Set adminHrSet = adminHrMap.entrySet();
        it = adminHrSet.iterator();
        IPersonPlanScheme iPPScheme = PersonPlanSchemeFactory.getLocalInstance(ctx);
        PersonPlanSchemeInfo schemeInfo = null;
        String hrOrgId = null;
        Map.Entry entry = null;
        HROrgUnitInfo hrOrgUnitInfo = null;
        while (it.hasNext()) {
            entry = (Map.Entry)it.next();
            hrOrgUnitInfo = (HROrgUnitInfo)entry.getValue();
            hrOrgId = hrOrgUnitInfo.getId().toString();
            if (hroInfoMap.containsKey(hrOrgId)) continue;
            schemeInfo = iPPScheme.getDefaultScheme(hrOrgId);
            paramPartimeOnStr = HRParamUtil.getParamOfHR((Context)ctx, (String)"IS_AUTH", (String)hrOrgId);
            String systemParam = ParamManager.getParamValue((Context)ctx, (IObjectPK)new ObjectUuidPK(hrOrgId), (String)"IS_ALLOW_OVER");
            boolean positionIsAllowOver = HRParamUtil.getParamOfHR((Context)ctx, (String)"IS_POSITION_ALLOW_OVER", (String)hrOrgId);
            hroInfoMap.put(hrOrgId, new HROInfo(schemeInfo, paramPartimeOnStr, positionIsAllowOver, systemParam));
        }
        it = addList.iterator();
        PersonPlanSimpleInfo ppsi = null;
        String key = null;
        HashMap<String, Integer> positionAddCountMap = new HashMap<String, Integer>();
        String positionID = null;
        EmployeeTypeInfo empType = null;
        while (it.hasNext()) {
            PosPerPlanInfo posper = (PosPerPlanInfo)it.next();
            if (posper.getPosition() != null) {
                empType = posper.getEmpType();
                positionID = posper.getPosition().getId().toString();
                if (empType != null && empType.get("isOnTheStrength") == null) {
                    try {
                        empType = (EmployeeTypeInfo)EmployeeTypeFactory.getLocalInstance((Context)ctx).getValue("select id, isOnTheStrength where id = '" + empType.getId().toString() + "'");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (empType != null && !empType.isIsOnTheStrength() || posper.getAdmin() == null) continue;
                if (adminHrMap.containsKey(posper.getAdmin().getId().toString())) {
                    hrOrgId = ((HROrgUnitInfo)adminHrMap.get(posper.getAdmin().getId().toString())).getId().toString();
                    paramPartimeOnStr = ((HROInfo)hroInfoMap.get((Object)hrOrgId)).paramPartimeOnStr;
                    if (posper.isPlurFlag() && !paramPartimeOnStr) continue;
                    if (positionAddCountMap.containsKey(positionID)) {
                        int count = (Integer)positionAddCountMap.get(positionID);
                        positionAddCountMap.put(posper.getPosition().getId().toString(), count + 1);
                    } else {
                        positionAddCountMap.put(posper.getPosition().getId().toString(), 1);
                    }
                }
            }
            if ((ppsi = this.getPersonPlanSimpleInfo(ctx, posper, adminHrMap, hroInfoMap, 1)) == null) continue;
            key = ppsi.getAdminOrgId() + ppsi.getWeidu();
            if (ppsiMap.containsKey(key)) {
                ((PersonPlanSimpleInfo)ppsiMap.get(key)).add(ppsi);
                continue;
            }
            ppsiMap.put(key, ppsi);
        }
        if (delList != null && delList.size() > 0) {
            for (PosPerPlanInfo pppi2 : delList) {
                if (pppi2.getPosition() != null) {
                    empType = pppi2.getEmpType();
                    positionID = pppi2.getPosition().getId().toString();
                    if (empType != null && empType.get("isOnTheStrength") == null) {
                        try {
                            empType = (EmployeeTypeInfo)EmployeeTypeFactory.getLocalInstance((Context)ctx).getValue("select id, isOnTheStrength where id = '" + empType.getId().toString() + "'");
                        }
                        catch (Exception posper) {
                            // empty catch block
                        }
                    }
                    if (empType != null && !empType.isIsOnTheStrength() || pppi2.getAdmin() == null) continue;
                    if (adminHrMap.containsKey(pppi2.getAdmin().getId().toString())) {
                        hrOrgId = ((HROrgUnitInfo)adminHrMap.get(pppi2.getAdmin().getId().toString())).getId().toString();
                        paramPartimeOnStr = ((HROInfo)hroInfoMap.get((Object)hrOrgId)).paramPartimeOnStr;
                        if (pppi2.isPlurFlag() && !paramPartimeOnStr) continue;
                        if (positionAddCountMap.containsKey(positionID)) {
                            int count = (Integer)positionAddCountMap.get(positionID);
                            positionAddCountMap.put(pppi2.getPosition().getId().toString(), count - 1);
                        }
                    }
                }
                if ((ppsi = this.getPersonPlanSimpleInfo(ctx, pppi2, adminHrMap, hroInfoMap, -1)) == null || !ppsiMap.containsKey(key = ppsi.getAdminOrgId() + ppsi.getWeidu())) continue;
                ((PersonPlanSimpleInfo)ppsiMap.get(key)).add(ppsi);
            }
        }
        this.checkPositionPlan(ctx, hroInfoMap, positionAddCountMap, adminHrMap);
        Set keySet = ppsiMap.keySet();
        it = keySet.iterator();
        while (it.hasNext()) {
            ppsi = (PersonPlanSimpleInfo)ppsiMap.get(it.next());
            if (this.checkPersonPlanSimpleInfo(ppsi, ctx)) continue;
            throw new PersonPlanException(PersonPlanException.NOT_ADD_PERSON_EXCEED_PLAN);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private PersonPlanSimpleInfo getPersonPlanSimpleInfo(Context ctx, PosPerPlanInfo posper, int num) throws EASBizException, BOSException {
        if (posper == null) {
            return null;
        }
        String personID = posper.getPersonID();
        String hrOrgId = null;
        IOrgHRCommon iOrgHRCommon = OrgHRCommonFactory.getLocalInstance(ctx);
        String adminOrgId = null;
        PositionInfo posiInfo = posper.getPosition();
        AdminOrgUnitInfo adminInfo = posper.getAdmin();
        EmployeeTypeInfo empType = posper.getEmpType();
        if (empType != null) {
            if (empType.get("isOnTheStrength") == null) {
                try {
                    empType = (EmployeeTypeInfo)EmployeeTypeFactory.getLocalInstance((Context)ctx).getValue("select id, isOnTheStrength where id = '" + empType.getId().toString() + "'");
                }
                catch (Exception e) {
                    return null;
                }
            }
            if (!empType.isIsOnTheStrength()) {
                return null;
            }
        }
        if (posiInfo == null && adminInfo == null) {
            return null;
        }
        if (posiInfo != null && adminInfo == null) {
            adminInfo = this.getAdminByPosition(ctx, posiInfo.getId().toString());
        }
        if (adminInfo == null) {
            return null;
        }
        adminOrgId = adminInfo.getId().toString();
        HROrgUnitInfo hrOrg = iOrgHRCommon.getAdminOrgHRO(adminOrgId);
        if (hrOrg == null) return null;
        hrOrgId = hrOrg.getId().toString();
        boolean paramPartimeOnStr = HRParamUtil.getParamOfHR((Context)ctx, (String)"IS_AUTH", (String)hrOrgId);
        boolean paramParanormal = this.getIsAllowOverParamInfo(ctx, new ObjectUuidPK(hrOrgId));
        if (paramParanormal) return null;
        if (!paramPartimeOnStr && posper.isPlurFlag()) {
            return null;
        }
        IPersonPlanScheme iPPScheme = PersonPlanSchemeFactory.getLocalInstance(ctx);
        PersonPlanSchemeInfo schemeInfo = iPPScheme.getDefaultScheme(hrOrgId);
        if (schemeInfo == null) {
            throw new PersonPlanException(PersonPlanException.NOT_EXCUTE_PERSONPLANSCHEME);
        }
        if (schemeInfo.getStatus() != SchemeStatus.EXECUTE) {
            throw new PersonPlanException(PersonPlanException.NOT_EXCUTE_PERSONPLANSCHEME);
        }
        PersonPlanType planType = schemeInfo.getPlanType();
        PersonPlanSimpleInfo ppsi = null;
        if (planType == PersonPlanType.PERSON) {
            return new PersonPlanSimpleInfo(personID, hrOrgId, adminOrgId, adminOrgId, schemeInfo, num, paramPartimeOnStr);
        }
        if (planType == PersonPlanType.JOB) {
            if (posiInfo == null) {
                return null;
            }
            if (posiInfo.getJob() == null) {
                EntityViewInfo view = new EntityViewInfo();
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("job.id"));
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)posiInfo.getId().toString()));
                view.setFilter(filter);
                view.setSelector(selector);
                PositionCollection col = PositionFactory.getLocalInstance((Context)ctx).getPositionCollection(view);
                if (col.size() > 0) {
                    posiInfo = col.get(0);
                }
            }
            if (posiInfo.getJob() == null) return null;
            return new PersonPlanSimpleInfo(personID, hrOrgId, adminOrgId, posiInfo.getJob().getId().toString(), schemeInfo, num, paramPartimeOnStr);
        }
        if (planType != PersonPlanType.POSITION) return ppsi;
        if (posiInfo != null) return new PersonPlanSimpleInfo(personID, hrOrgId, adminOrgId, posiInfo.getId().toString(), schemeInfo, num, paramPartimeOnStr);
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private PersonPlanSimpleInfo getPersonPlanSimpleInfo(Context ctx, PosPerPlanInfo posper, Map adminHroMap, Map hroInfoMap, int num) throws EASBizException, BOSException {
        boolean paramPartimeOnStr;
        String adminOrgId;
        HROrgUnitInfo hrOrg;
        if (posper == null) {
            return null;
        }
        String personID = posper.getPersonID();
        AdminOrgUnitInfo adminInfo = posper.getAdmin();
        EmployeeTypeInfo empType = posper.getEmpType();
        if (adminInfo == null) {
            return null;
        }
        if (empType != null) {
            if (empType.get("isOnTheStrength") == null) {
                try {
                    empType = (EmployeeTypeInfo)EmployeeTypeFactory.getLocalInstance((Context)ctx).getValue("select id, isOnTheStrength where id = '" + empType.getId().toString() + "'");
                }
                catch (Exception e) {
                    return null;
                }
            }
            if (!empType.isIsOnTheStrength()) {
                return null;
            }
        }
        if ((hrOrg = (HROrgUnitInfo)adminHroMap.get(adminOrgId = adminInfo.getId().toString())) == null) {
            return null;
        }
        String hrOrgId = hrOrg.getId().toString();
        HROInfo hroInfo = (HROInfo)hroInfoMap.get(hrOrgId);
        if (hroInfo == null) {
            return null;
        }
        PersonPlanSchemeInfo schemeInfo = hroInfo.getSchemeInfo();
        if (schemeInfo == null) {
            return null;
        }
        if (schemeInfo.getStatus() != SchemeStatus.EXECUTE) {
            return null;
        }
        if (posper.getPosition() != null) {
            posper.getPosition().setHrOrgUnit(hrOrg);
        }
        if (!(paramPartimeOnStr = hroInfo.isParamPartimeOnStr()) && posper.isPlurFlag()) {
            return null;
        }
        PersonPlanType planType = schemeInfo.getPlanType();
        PersonPlanSimpleInfo ppsi = null;
        PositionInfo posiInfo = posper.getPosition();
        String systemParam = hroInfo.systemParam;
        boolean paramParanormal = this.isCanAllowOver(ctx, schemeInfo, adminInfo.getId().toString(), posiInfo, systemParam);
        if (paramParanormal) {
            return null;
        }
        if (planType == PersonPlanType.PERSON) {
            return new PersonPlanSimpleInfo(personID, hrOrgId, adminOrgId, adminOrgId, schemeInfo, num, paramPartimeOnStr);
        }
        if (planType == PersonPlanType.JOB) {
            if (posiInfo == null) {
                return null;
            }
            if (posiInfo.getJob() == null) {
                EntityViewInfo view = new EntityViewInfo();
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("job.id"));
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)posiInfo.getId().toString()));
                view.setFilter(filter);
                view.setSelector(selector);
                PositionCollection col = PositionFactory.getLocalInstance((Context)ctx).getPositionCollection(view);
                if (col.size() > 0) {
                    posiInfo = col.get(0);
                }
            }
            if (posiInfo.getJob() == null) return null;
            return new PersonPlanSimpleInfo(personID, hrOrgId, adminOrgId, posiInfo.getJob().getId().toString(), schemeInfo, num, paramPartimeOnStr);
        }
        if (planType != PersonPlanType.POSITION) return ppsi;
        if (posiInfo != null) return new PersonPlanSimpleInfo(personID, hrOrgId, adminOrgId, posiInfo.getId().toString(), schemeInfo, num, paramPartimeOnStr);
        return null;
    }

    private boolean checkPersonPlanSimpleInfo(PersonPlanSimpleInfo ppsi, Context ctx) throws EASBizException, BOSException {
        int plan = 0;
        PersonPlanSchemeInfo schemeInfo = ppsi.getSchemeInfo();
        String adminOrgId = ppsi.getAdminOrgId();
        String weidu = ppsi.getWeidu();
        boolean paramPartimeOnStr = ppsi.isParamPartimeOnStr();
        String schemeId = schemeInfo.getId().toString();
        Map addPersonMap = ppsi.getPersonMap();
        Map actualPersonMap = new HashMap();
        if (schemeInfo.getPlanType() == PersonPlanType.PERSON) {
            plan = this.getCurrentOrgPlanCount(ctx, ppsi.adminOrgId, schemeId);
            actualPersonMap = this.getActualONCount(ctx, adminOrgId, paramPartimeOnStr);
        } else if (schemeInfo.getPlanType() == PersonPlanType.JOB) {
            plan = this.getCurrPlanCountByJob(ctx, adminOrgId, schemeId, weidu);
            actualPersonMap = this.getActualONJob(ctx, adminOrgId, weidu, paramPartimeOnStr);
        } else if (schemeInfo.getPlanType() == PersonPlanType.POSITION) {
            plan = this._getCurrPlanCountByPosition(ctx, weidu, schemeId);
            actualPersonMap = this.getActualONPosition(ctx, weidu, paramPartimeOnStr);
        }
        Map newPersonMap = this.concatMap(addPersonMap, actualPersonMap);
        if (newPersonMap == null) {
            return true;
        }
        int num = 0;
        if (newPersonMap.containsKey(null)) {
            num = (Integer)newPersonMap.get(null);
            newPersonMap.remove(null);
        }
        for (Map.Entry entry : newPersonMap.entrySet()) {
            if ((Integer)entry.getValue() <= 0) continue;
            ++num;
        }
        if (addPersonMap != null) {
            addPersonMap.clear();
        }
        if (actualPersonMap != null) {
            actualPersonMap.clear();
        }
        newPersonMap.clear();
        return plan < 0 || num <= plan;
    }

    private AdminOrgUnitInfo getAdminByPosition(Context ctx, String positionID) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)positionID));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("adminOrgUnit.id"));
        view.setFilter(filter);
        view.setSelector(selector);
        CoreBaseCollection col = PositionFactory.getLocalInstance((Context)ctx).getCollection(view);
        if (col.size() > 0) {
            return ((PositionInfo)col.get(0)).getAdminOrgUnit();
        }
        return null;
    }

    @Override
    protected void _canModifyEmpType(Context ctx, String personID) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("position"));
        selector.add(new SelectorItemInfo("isPrimary"));
        selector.add(new SelectorItemInfo("person.employeeType.*"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)personID));
        view.setSelector(selector);
        view.setFilter(filter);
        PositionMemberCollection col = PositionMemberFactory.getLocalInstance((Context)ctx).getPositionMemberCollection(view);
        ArrayList<PosPerPlanInfo> addList = new ArrayList<PosPerPlanInfo>();
        ArrayList<PosPerPlanInfo> delList = new ArrayList<PosPerPlanInfo>();
        PositionMemberInfo pmInfo = null;
        if (col != null || col != null && col.size() > 0) {
            int size = col.size();
            for (int i = 0; i < size; ++i) {
                pmInfo = col.get(i);
                addList.add(new PosPerPlanInfo(personID, pmInfo.getPosition(), !pmInfo.isIsPrimary(), null));
                delList.add(new PosPerPlanInfo(personID, pmInfo.getPosition(), !pmInfo.isIsPrimary(), pmInfo.getPerson().getEmployeeType()));
            }
        } else {
            addList.add(new PosPerPlanInfo(personID, null, false, null));
        }
        this._canAddPersonBatch(ctx, addList, null);
    }

    private Map concatMap(Map map1, Map map2) {
        if (map1 == null) {
            return map2;
        }
        if (map2 == null) {
            return map1;
        }
        for (Map.Entry entry : map2.entrySet()) {
            Object key = entry.getKey();
            if (map1.containsKey(key)) {
                Integer i = (Integer)map1.get(key) + (Integer)entry.getValue();
                map1.put(key, i);
                continue;
            }
            map1.put(key, entry.getValue());
        }
        return map1;
    }

    private boolean isCanAllowOver(Context ctx, PersonPlanSchemeInfo schemeInfo, String adminOrgID, PositionInfo posiInfo, String systemParam) throws BOSException, EASBizException {
        boolean returnValue = true;
        if ("0".equals(systemParam)) {
            returnValue = true;
        } else if ("1".equals(systemParam)) {
            returnValue = false;
        } else if ("2".equals(systemParam)) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.appendFilterItem("scheme", (Object)schemeInfo.getId().toString());
            filter.appendFilterItem("adminOrg", (Object)adminOrgID);
            if (schemeInfo.getPlanType() == PersonPlanType.POSITION) {
                if (posiInfo != null) {
                    filter.appendFilterItem("position", (Object)posiInfo.getId().toString());
                }
            } else if (schemeInfo.getPlanType() == PersonPlanType.JOB && posiInfo != null) {
                if (posiInfo.getJob() == null) {
                    posiInfo = PositionFactory.getLocalInstance((Context)ctx).getPositionInfo((IObjectPK)new ObjectUuidPK(posiInfo.getId().toString()));
                }
                if (posiInfo.getJob() != null) {
                    filter.appendFilterItem("job", (Object)posiInfo.getJob().getId().toString());
                }
            }
            view.setFilter(filter);
            PersonPlanCollection infoColl = PersonPlanFactory.getLocalInstance(ctx).getPersonPlanCollection(view);
            if (infoColl.size() > 0) {
                PersonPlanInfo info = infoColl.get(0);
                returnValue = info.isIsAllowOver();
            }
        }
        return returnValue;
    }

    private boolean getIsAllowOverParamInfo(Context ctx, ObjectUuidPK hrOrgID) throws EASBizException, BOSException {
        String systemParam = ParamManager.getParamValue((Context)ctx, (IObjectPK)hrOrgID, (String)"IS_ALLOW_OVER");
        return "0".equals(systemParam);
    }

    private boolean containKey(ArrayList keys, String[] key) {
        String[] keyThatContains = null;
        int count = keys.size();
        for (int i = 0; i < count; ++i) {
            keyThatContains = (String[])keys.get(i);
            boolean isAllTheSame = true;
            int count2 = keyThatContains.length;
            for (int j = 0; j < count2; ++j) {
                if (keyThatContains[j].equals(key[j])) continue;
                isAllTheSame = false;
            }
            if (!isAllTheSame) continue;
            return true;
        }
        return false;
    }

    private ArrayList getJobList(IRowSet jobRow) throws BOSException {
        ArrayList<String[]> result = new ArrayList<String[]>();
        String[] data = null;
        try {
            while (jobRow.next()) {
                if (data != null && jobRow.getString("id").equals(data[0])) continue;
                data = new String[]{jobRow.getString("id"), jobRow.getString("name")};
                result.add(data);
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), e.getCause());
        }
        return result;
    }

    public int getActualONPlanPersonCount(Context ctx, String weidu, PersonPlanType type, String adminOrgId, boolean paramPartimeOnStr) throws BOSException, EASBizException {
        Map newPersonMap = new HashMap();
        if (type == PersonPlanType.PERSON) {
            newPersonMap = this.getActualONCount(ctx, adminOrgId, paramPartimeOnStr);
        } else if (type == PersonPlanType.JOB) {
            newPersonMap = this.getActualONJob(ctx, adminOrgId, weidu, paramPartimeOnStr);
        } else if (type == PersonPlanType.POSITION) {
            newPersonMap = this.getActualONPosition(ctx, weidu, paramPartimeOnStr);
        }
        int num = 0;
        if (newPersonMap.containsKey(null)) {
            num = (Integer)newPersonMap.get(null);
            newPersonMap.remove(null);
        }
        for (Map.Entry entry : newPersonMap.entrySet()) {
            if ((Integer)entry.getValue() <= 0) continue;
            ++num;
        }
        return num;
    }

    private int planCountFromPosition(Context ctx, PositionInfo position, PersonPlanSchemeInfo schemeInfo) throws BOSException, EASBizException {
        IPersonPlan iPPlan;
        int count;
        if (schemeInfo != null && schemeInfo.getStatus() == SchemeStatus.EXECUTE && schemeInfo.getPlanType() == PersonPlanType.POSITION && (count = (iPPlan = PersonPlanFactory.getLocalInstance(ctx)).getCurrPlanCountByPosition(position.getId().toString(), schemeInfo.getId().toString())) > 0) {
            return count;
        }
        return -1;
    }

    private void checkPositionPlan(Context ctx, Map hroInfoMap, Map positionAddCountMap, Map adminHrMap) throws BOSException, EASBizException {
        if (positionAddCountMap.isEmpty()) {
            return;
        }
        Iterator iter = positionAddCountMap.keySet().iterator();
        String positionID = null;
        PositionInfo positionInfo = null;
        String adminID = null;
        String hrOrgID = null;
        HROInfo hroInfo = null;
        int addCount = 0;
        while (iter.hasNext()) {
            int actual;
            int planCount;
            positionID = iter.next().toString();
            positionInfo = PositionFactory.getLocalInstance((Context)ctx).getPositionInfo((IObjectPK)new ObjectUuidPK(positionID));
            adminID = positionInfo.getAdminOrgUnit().getId().toString();
            hrOrgID = ((HROrgUnitInfo)adminHrMap.get(adminID)).getId().toString();
            hroInfo = (HROInfo)hroInfoMap.get(hrOrgID);
            if (hroInfo.positionIsAllowOver || (addCount = ((Integer)positionAddCountMap.get(positionID)).intValue()) <= 0 || (planCount = this.planCountFromPosition(ctx, positionInfo, hroInfo.schemeInfo)) != -1 || (planCount = positionInfo.getPositionPlanCount()) <= 0 || (actual = this.getActualONPlanPersonCount(ctx, positionID, PersonPlanType.POSITION, adminID, hroInfo.paramPartimeOnStr)) + addCount <= planCount) continue;
            throw new PersonPlanException(PersonPlanException.POSITION_SURPASS_LIMITS, new Object[]{positionInfo.getName()});
        }
    }

    static class HROInfo {
        PersonPlanSchemeInfo schemeInfo;
        boolean paramPartimeOnStr;
        String systemParam;
        boolean positionIsAllowOver;

        public PersonPlanSchemeInfo getSchemeInfo() {
            return this.schemeInfo;
        }

        public void setSchemeInfo(PersonPlanSchemeInfo schemeInfo) {
            this.schemeInfo = schemeInfo;
        }

        public boolean isParamPartimeOnStr() {
            return this.paramPartimeOnStr;
        }

        public void setParamPartimeOnStr(boolean paramPartimeOnStr) {
            this.paramPartimeOnStr = paramPartimeOnStr;
        }

        public HROInfo(PersonPlanSchemeInfo schemeInfo, boolean paramPartimeOnStr, boolean posiIsAllowOver, String systemParam) {
            this.schemeInfo = schemeInfo;
            this.paramPartimeOnStr = paramPartimeOnStr;
            this.positionIsAllowOver = posiIsAllowOver;
            this.systemParam = systemParam;
        }
    }

    class PersonPlanSimpleInfo {
        String hroId;
        String adminOrgId;
        String weidu;
        PersonPlanSchemeInfo schemeInfo;
        boolean paramPartimeOnStr;
        Map personMap;

        public PersonPlanSimpleInfo() {
        }

        public PersonPlanSimpleInfo(String personID, String hroId, String adminOrgId, String weidu, PersonPlanSchemeInfo schemeInfo, int num, boolean paramPartimeOnStr) {
            this.hroId = hroId;
            this.adminOrgId = adminOrgId;
            this.weidu = weidu;
            this.schemeInfo = schemeInfo;
            this.paramPartimeOnStr = paramPartimeOnStr;
            this.personMap = new HashMap();
            this.personMap.put(personID, num);
        }

        public Map getPersonMap() {
            return this.personMap;
        }

        public void setPersonMap(Map personMap) {
            this.personMap = personMap;
        }

        public boolean isParamPartimeOnStr() {
            return this.paramPartimeOnStr;
        }

        public void setParamPartimeOnStr(boolean paramPartimeOnStr) {
            this.paramPartimeOnStr = paramPartimeOnStr;
        }

        public String getHroId() {
            return this.hroId;
        }

        public void setHroId(String hroId) {
            this.hroId = hroId;
        }

        public String getAdminOrgId() {
            return this.adminOrgId;
        }

        public void setAdminOrgId(String adminOrgId) {
            this.adminOrgId = adminOrgId;
        }

        public String getWeidu() {
            return this.weidu;
        }

        public void setWeidu(String weidu) {
            this.weidu = weidu;
        }

        public PersonPlanSchemeInfo getSchemeInfo() {
            return this.schemeInfo;
        }

        public void setSchemeInfo(PersonPlanSchemeInfo schemeInfo) {
            this.schemeInfo = schemeInfo;
        }

        private void add(PersonPlanSimpleInfo ppsi) {
            if (this.equals(ppsi)) {
                this.personMap = PersonPlanControllerBean.this.concatMap(this.personMap, ppsi.personMap);
            }
        }

        public boolean equals(PersonPlanSimpleInfo ppsi) {
            if (ppsi == null) {
                return false;
            }
            return this.getAdminOrgId().equals(ppsi.getAdminOrgId()) && this.getWeidu().equals(ppsi.getWeidu());
        }
    }
}

