/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.org.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.org.PersonVerAdjRecCollection;
import com.kingdee.eas.hr.org.PersonVerAdjRecInfo;
import com.kingdee.eas.hr.org.PersonVerCollection;
import com.kingdee.eas.hr.org.app.AbstractPersonVerAdjRecControllerBean;
import com.kingdee.eas.hr.org.util.OrgVerAdjUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class PersonVerAdjRecControllerBean
extends AbstractPersonVerAdjRecControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.org.app.PersonVerAdjRecControllerBean");

    @Override
    protected void _adjRecForMove(Context ctx, PersonVerCollection perVerColl, PersonVerAdjRecCollection perVerAdjRecColl) throws BOSException, EASBizException {
        String personIdStr = OrgVerAdjUtil.convertColToString((IObjectCollection)perVerColl);
        String orgAdjSchm = perVerColl.get(0).getOrgAdjSchm().getId().toString();
        Timestamp currentTime = OrgVerAdjUtil.getTime();
        UserInfo curUser = ContextUtil.getCurrentUserInfo((Context)ctx);
        Connection conn = null;
        PreparedStatement insertBatchPs = null;
        StringBuffer sql = new StringBuffer();
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            Map<String, PersonVerAdjRecInfo> existRecMap = this.getExistPersonVerAdjMap(ctx, personIdStr, orgAdjSchm);
            sql.append("delete from T_HR_PersonVerAdjRec where").append(" fPersonVer in (").append(personIdStr).append(") and ").append(" fOrgAdjSchm='").append(orgAdjSchm).append("'").append(" and fEnableStatus=").append(0).append(" AND FISPRIMARYADJ = 1");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            StringBuffer insertSql = new StringBuffer();
            insertSql.append("insert into T_HR_PersonVerAdjRec(fid,fPersonVer,fOrgAdjSchm,fAdjType,").append("fBeforeAdjPos,fAfterAdjPos,fBeforeAdjOrg,FAfterAdjOrg,fEnableStatus,fIsPrimaryAdj").append(",FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime,FControlUnitID) ").append("values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            insertBatchPs = conn.prepareStatement(insertSql.toString());
            PersonVerAdjRecInfo personVerAdj = null;
            int size = perVerAdjRecColl.size();
            for (int i = 0; i < size; ++i) {
                personVerAdj = perVerAdjRecColl.get(i);
                personVerAdj.setLastUpdateTime(currentTime);
                personVerAdj.setLastUpdateUser(curUser);
                personVerAdj.setCreateTime(currentTime);
                personVerAdj.setCreator(curUser);
                this.addPersonMoveAdjStatement(ctx, insertBatchPs, personVerAdj, existRecMap);
            }
            insertBatchPs.executeBatch();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e.getMessage());
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(null, insertBatchPs, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(null, (Statement)insertBatchPs, (Connection)conn);
        if (perVerColl.get(0).getPrimaryPosition() != null) {
            this.updatePositionAdjRec(ctx, orgAdjSchm, true, personIdStr);
        } else {
            this.updatePositionAdjRec(ctx, orgAdjSchm, false, personIdStr);
        }
        String deleteSql = "DELETE FROM T_HR_PersonVerAdjRec WHERE FPERSONVER = " + personIdStr + " AND FORGADJSCHM = '" + orgAdjSchm + "' AND fBeforeAdjPos=fAfterAdjPos AND fBeforeAdjOrg = FAfterAdjOrg AND FISPRIMARYADJ = 1";
        DbUtil.execute((Context)ctx, (String)deleteSql);
    }

    private void addPersonMoveAdjStatement(Context ctx, PreparedStatement ps, PersonVerAdjRecInfo adjInfo, Map<String, PersonVerAdjRecInfo> existRecMap) throws SQLException {
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        Timestamp curTime = OrgVerAdjUtil.getTime();
        String cuId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        ps.setString(1, BOSUuid.create((BOSObjectType)adjInfo.getBOSType()).toString());
        ps.setString(2, adjInfo.getPersonVer().getId().toString());
        ps.setString(3, adjInfo.getOrgAdjSchm().getId().toString());
        ps.setInt(4, adjInfo.getAdjType().getValue());
        String personVerID = adjInfo.getPersonVer().getId().toString();
        if (existRecMap.get(personVerID) != null) {
            PersonVerAdjRecInfo existAdjRecInfo = existRecMap.get(personVerID);
            ps.setString(5, existAdjRecInfo.getBeforeAdjPos());
            ps.setString(6, adjInfo.getAfterAdjPos());
            ps.setString(7, existAdjRecInfo.getBeforeAdjOrg());
        } else {
            ps.setString(5, adjInfo.getBeforeAdjPos());
            ps.setString(6, adjInfo.getAfterAdjPos());
            ps.setString(7, adjInfo.getBeforeAdjOrg());
        }
        ps.setString(8, adjInfo.getAfterAdjOrg());
        ps.setInt(9, adjInfo.getEnableStatus().getValue());
        ps.setInt(10, adjInfo.getIsPrimaryAdj());
        ps.setString(11, userId);
        ps.setTimestamp(12, curTime);
        ps.setString(13, userId);
        ps.setTimestamp(14, curTime);
        ps.setString(15, cuId);
        ps.addBatch();
    }

    private Map<String, PersonVerAdjRecInfo> getExistPersonVerAdjMap(Context ctx, String personIdStr, String orgAdjSchm) throws BOSException, SQLException {
        HashMap<String, PersonVerAdjRecInfo> existRecMap = new HashMap<String, PersonVerAdjRecInfo>();
        StringBuffer sql = new StringBuffer();
        sql.append("select rec.fPersonVer,posVer.fid as posVerID,orgVer.fid as orgVerID").append(" from T_HR_PersonVerAdjRec rec").append(" left join T_HR_PositionVer posVer on posVer.FPositionID=rec.fBeforeAdjPos and posVer.fOrgAdjSchm=?").append(" left join T_HR_AdminOrgUnitVer orgVer on orgVer.FAdminOrgUnitID=rec.fBeforeAdjOrg and orgVer.fOrgAdjSchm=?").append(" where rec.fPersonVer in (").append(personIdStr).append(") and ").append(" rec.fOrgAdjSchm=?").append(" and rec.fEnableStatus=?").append(" and rec.FISPRIMARYADJ=1");
        IRowSet existRs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{orgAdjSchm, orgAdjSchm, orgAdjSchm, 0});
        PersonVerAdjRecInfo recInfo = null;
        while (existRs.next()) {
            recInfo = new PersonVerAdjRecInfo();
            recInfo.setBeforeAdjPos(existRs.getString("posVerID"));
            recInfo.setBeforeAdjOrg(existRs.getString("orgVerID"));
            existRecMap.put(existRs.getString("fPersonVer"), recInfo);
        }
        return existRecMap;
    }

    private void updatePositionAdjRec(Context ctx, String orgAdjSchm, boolean onPositionMove, String personIdStr) throws BOSException {
        StringBuffer updateAdjRecSql = new StringBuffer();
        if (onPositionMove) {
            updateAdjRecSql.append("update T_HR_PersonVerAdjRec rec set ").append(" fBeforeAdjPos=(select FPositionID from T_HR_PositionVer pv where pv.FID=rec.fBeforeAdjPos").append(" and pv.fOrgAdjSchm ='").append(orgAdjSchm).append("')").append(" where rec.fOrgAdjSchm='").append(orgAdjSchm).append("'").append(" and rec.fPersonVer in (").append(personIdStr).append(") and rec.FISPRIMARYADJ=1");
            DbUtil.execute((Context)ctx, (String)updateAdjRecSql.toString());
            updateAdjRecSql = new StringBuffer();
            updateAdjRecSql.append("update T_HR_PersonVerAdjRec rec set ").append(" fAfterAdjPos=(select FPositionID from T_HR_PositionVer pv where pv.FID=rec.fAfterAdjPos").append(" and pv.fOrgAdjSchm ='").append(orgAdjSchm).append("')").append(" where rec.fOrgAdjSchm='").append(orgAdjSchm).append("'").append(" and rec.fPersonVer in (").append(personIdStr).append(") and rec.FISPRIMARYADJ=1");
            DbUtil.execute((Context)ctx, (String)updateAdjRecSql.toString());
        }
        updateAdjRecSql = new StringBuffer();
        updateAdjRecSql.append("update T_HR_PersonVerAdjRec rec set ").append(" fBeforeAdjOrg=(select FAdminOrgUnitID from T_HR_AdminOrgUnitVer pv where pv.FID=rec.fBeforeAdjOrg").append(" and pv.fOrgAdjSchm ='").append(orgAdjSchm).append("')").append(" where rec.fOrgAdjSchm='").append(orgAdjSchm).append("'").append(" and rec.fPersonVer in (").append(personIdStr).append(") and rec.FISPRIMARYADJ=1");
        DbUtil.execute((Context)ctx, (String)updateAdjRecSql.toString());
        updateAdjRecSql = new StringBuffer();
        updateAdjRecSql.append("update T_HR_PersonVerAdjRec rec set ").append(" FAfterAdjOrg=(select FAdminOrgUnitID from T_HR_AdminOrgUnitVer pv where pv.FID=rec.FAfterAdjOrg").append(" and pv.fOrgAdjSchm ='").append(orgAdjSchm).append("')").append(" where rec.fOrgAdjSchm='").append(orgAdjSchm).append("'").append(" and rec.fPersonVer in (").append(personIdStr).append(") and rec.FISPRIMARYADJ=1");
        DbUtil.execute((Context)ctx, (String)updateAdjRecSql.toString());
    }
}

