/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.org.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.base.core.hr.util.HRParamUtil;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.IJob;
import com.kingdee.eas.basedata.org.IPosition;
import com.kingdee.eas.basedata.org.JobCollection;
import com.kingdee.eas.basedata.org.JobFactory;
import com.kingdee.eas.basedata.org.PositionCollection;
import com.kingdee.eas.basedata.org.PositionException;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.benefit.util.ExportUtil;
import com.kingdee.eas.hr.benefit.util.HrLocaleUtil;
import com.kingdee.eas.hr.org.OrgHRCommonFactory;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;

public class PositionDataImport
extends AbstractDataTransmission {
    private static final String resStr = "com.kingdee.eas.hr.org.JobGradeResource.";

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return PositionFactory.getLocalInstance((Context)ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            if (coreBaseInfo.getId() == null) {
                this.getController(ctx).addnew(coreBaseInfo);
            } else {
                this.getController(ctx).update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        IPosition iPosition = null;
        PositionCollection posiColl = null;
        PositionInfo info = new PositionInfo();
        String flag = (String)this.getContextParameter("FLAG");
        boolean isFromHR = false;
        if (!StringUtils.isEmpty((String)flag) && "HR".equals(flag.trim())) {
            isFromHR = true;
        }
        String str = null;
        str = (String)((DataToken)hsData.get((Object)"FNumber")).data;
        if (StringUtils.isEmpty((String)str)) {
            throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.hr.org.JobGradeResource.P_I_Number_ERRPR"));
        }
        info.setNumber(str);
        CtrlUnitInfo cuInfo = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        String cuID = cuInfo.getId().toString();
        StringBuffer filterSql = null;
        try {
            iPosition = PositionFactory.getLocalInstance((Context)ctx);
            filterSql = new StringBuffer();
            filterSql.append("where number = '");
            filterSql.append(str.trim());
            filterSql.append("'");
            posiColl = iPosition.getPositionCollection(filterSql.toString());
            if (posiColl != null && posiColl.size() > 0) {
                if ((Integer)this.getContextParameter().get("DATATASKMODE") == 8) {
                    throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.hr.org.JobGradeResource.P_I_POSITION_EXIST"));
                }
                info.setId(posiColl.get(0).getId());
            }
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        str = (String)((DataToken)hsData.get((Object)"FName_L1")).data;
        info.setName(str, new Locale("L1"));
        str = (String)((DataToken)hsData.get((Object)"FName_L2")).data;
        info.setName(str, new Locale("L2"));
        str = (String)((DataToken)hsData.get((Object)"FName_L3")).data;
        info.setName(str, new Locale("L3"));
        if (StringUtils.isEmpty((String)info.getName(new Locale("L1"))) && StringUtils.isEmpty((String)info.getName(new Locale("L2"))) && StringUtils.isEmpty((String)info.getName(new Locale("L3")))) {
            throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.hr.org.JobGradeResource.P_I_Name_ERRPR"));
        }
        str = (String)((DataToken)hsData.get((Object)"FDescription_L1")).data;
        info.setDescription(str, new Locale("L1"));
        str = (String)((DataToken)hsData.get((Object)"FDescription_L2")).data;
        info.setDescription(str, new Locale("L2"));
        str = (String)((DataToken)hsData.get((Object)"FDescription_L3")).data;
        info.setDescription(str, new Locale("L3"));
        Date date = null;
        try {
            str = (String)((DataToken)hsData.get((Object)"FEffectDate")).data;
            if (!str.trim().equalsIgnoreCase("")) {
                date = DateTimeUtils.parseDate((String)str);
                info.setEFFDT(date);
            }
            if (!(str = (String)((DataToken)hsData.get((Object)"FValiDate")).data).trim().equalsIgnoreCase("")) {
                date = DateTimeUtils.parseDate((String)str);
                info.setLEFFDT(date);
            }
            if (StringUtils.isEmpty((String)(str = ((DataToken)hsData.get((Object)"FAdminOrgUnitID")).data.toString()))) {
                throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.hr.org.JobGradeResource.P_I_Admin_NOT_NULL"));
            }
            IAdminOrgUnit iAdmin = AdminOrgUnitFactory.getLocalInstance((Context)ctx);
            filterSql = new StringBuffer();
            filterSql.append("where number = '");
            filterSql.append(str.trim());
            filterSql.append("'");
            AdminOrgUnitCollection adminColl = iAdmin.getAdminOrgUnitCollection(filterSql.toString());
            if (adminColl == null || adminColl.size() == 0) {
                throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.hr.org.JobGradeResource.P_I_Admin_NOT_FOUND"));
            }
            info.setAdminOrgUnit(adminColl.get(0));
            info.setCU(adminColl.get(0).getCU());
            str = ((DataToken)hsData.get((Object)"FParentPositionID")).data.toString();
            if (StringUtils.isEmpty((String)str)) {
                throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.hr.org.JobGradeResource.P_I_Position_NOT_NULL"));
            }
            filterSql = new StringBuffer();
            filterSql.append("where number = '");
            filterSql.append(str.trim());
            filterSql.append("'");
            posiColl = iPosition.getPositionCollection(filterSql.toString());
            if (posiColl == null || posiColl.size() == 0) {
                throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.hr.org.JobGradeResource.P_I_Position_NOT_FOUND"));
            }
            info.put("SuperPosition", (Object)posiColl.get(0));
            AdminOrgUnitInfo adminOrgUnit = info.getAdminOrgUnit();
            if (adminOrgUnit.isIsStartSHR()) {
                throw new PositionException(PositionException.ORG_STARTSHR);
            }
            HROrgUnitInfo hrOrgUnitInfo = null;
            if (adminOrgUnit != null && adminOrgUnit.getId() != null) {
                hrOrgUnitInfo = OrgHRCommonFactory.getLocalInstance(ctx).getAdminOrgHRO(adminOrgUnit.getId().toString());
            }
            if ((str = (String)((DataToken)hsData.get((Object)"FJobID")).data) != null && !str.trim().equalsIgnoreCase("")) {
                IJob iJob = JobFactory.getLocalInstance((Context)ctx);
                JobCollection jobColl = null;
                if (hrOrgUnitInfo != null && hrOrgUnitInfo.getCU() != null) {
                    cuID = hrOrgUnitInfo.getCU().getId().toString();
                }
                FilterInfo databaseDFilter = iJob.getDatabaseDFilter((IObjectPK)new ObjectUuidPK(cuID), "id", "adminCU.id");
                FilterInfo numFilter = new FilterInfo();
                numFilter.getFilterItems().add(new FilterItemInfo("number", (Object)str.trim()));
                databaseDFilter.mergeFilter(numFilter, "and");
                EntityViewInfo viewInfo = new EntityViewInfo();
                viewInfo.setFilter(databaseDFilter);
                jobColl = iJob.getJobCollection(viewInfo);
                if (jobColl == null || jobColl.size() == 0) {
                    throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.hr.org.JobGradeResource.P_I_JOB_NOT_FOUND"));
                }
                info.setJob(jobColl.get(0));
            } else if (isFromHR) {
                if (hrOrgUnitInfo != null) {
                    if (HRParamUtil.getParamOfHR((Context)ctx, (String)"IS_JOB_POSITION_MUST", (String)hrOrgUnitInfo.getId().toString())) {
                        throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.hr.org.JobGradeResource.P_T_JOB_NOT_NULL"));
                    }
                } else {
                    throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.hr.org.JobGradeResource.P_T_JOB_NO_HRORG"));
                }
            }
            str = (String)((DataToken)hsData.get((Object)"FIsPrimary")).data;
            info.setIsRespPosition(this.getBooleanFromAlias(str).booleanValue());
            if (str != null && !str.trim().equalsIgnoreCase("") && hrOrgUnitInfo != null && hrOrgUnitInfo.getCU() != null) {
                cuID = hrOrgUnitInfo.getCU().getId().toString();
            }
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage());
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage());
        }
        catch (ParseException e) {
            throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.hr.org.JobGradeResource.FormatError"));
        }
        return info;
    }

    private Boolean getBooleanFromAlias(String isPrimary) {
        if (isPrimary.equalsIgnoreCase("Y") || isPrimary.equalsIgnoreCase(EASResource.getString((String)"com.kingdee.eas.hr.org.JobGradeResource.YES"))) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        HashMap<String, String[]> exportMap = new HashMap<String, String[]>();
        exportMap.put("queryFiled", new String[]{"isRespPosition", "valiDate", "description", "effectDate", "number", "name", "parPosition.number", "job.number", "admin.number"});
        exportMap.put("excelFiled", new String[]{"FIsPrimary", "FValiDate", "FDescription" + HrLocaleUtil.getLocal((Context)ctx), "FEffectDate", "FNumber", "FName" + HrLocaleUtil.getLocal((Context)ctx), "FParentPositionID", "FJobID", "FAdminOrgUnitID"});
        exportMap.put("FiledType", new String[0]);
        return ExportUtil.transeExport((IRowSet)rs, exportMap);
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filterInfo = new FilterInfo();
        return filterInfo;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.hr.org.app.PositionExportQuery";
    }
}

