/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.org.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.org.JobCategoryFactory;
import com.kingdee.eas.basedata.org.JobCategoryInfo;
import com.kingdee.eas.basedata.org.JobFactory;
import com.kingdee.eas.basedata.org.JobInfo;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.eip.sso.ldapAdapter.ILdapValueMap;
import com.kingdee.eas.hr.base.PositionTypeLdapFactory;
import com.kingdee.eas.hr.base.PositionTypeLdapInfo;
import com.kingdee.eas.hr.emp.UserInfoToLdapFacadeFactory;
import com.kingdee.eas.hr.org.HRPositionFacadeFactory;
import com.kingdee.eas.hr.org.IHRPositionFacade;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class PositionInfoFetchLdapImpl
implements ILdapValueMap {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.emp.app.PositionInfoFetchLdapImpl");
    private static final String NAME_ENTITY = "name";
    private static final String DESCRIPT_ENTITY = "description";
    private static final String EMPLOYEES_ENTITY = "employees";
    private static final String SIMPLENAME_ENTITY = "simplename";

    public Map getContentInfoMap(Context ctx, String pubPositionId) {
        Map retMap = null;
        if (pubPositionId == null || "".equals(pubPositionId)) {
            return null;
        }
        try {
            retMap = this.loadPubPositionMap(ctx, pubPositionId);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return retMap;
    }

    private Map loadPubPositionMap(Context ctx, String pubPositionId) throws EASBizException, BOSException {
        HashMap<String, Object> retMap = null;
        if (pubPositionId != null) {
            retMap = new HashMap<String, Object>();
            PositionTypeLdapInfo positionTypeLdapInfo = PositionTypeLdapFactory.getLocalInstance((Context)ctx).getPositionTypeLdapInfo((IObjectPK)new ObjectUuidPK(pubPositionId));
            retMap.put(NAME_ENTITY, positionTypeLdapInfo.getName());
            retMap.put(DESCRIPT_ENTITY, positionTypeLdapInfo.getDescription());
            retMap.put(SIMPLENAME_ENTITY, positionTypeLdapInfo.getSimpleName());
            ArrayList ls = UserInfoToLdapFacadeFactory.getLocalInstance((Context)ctx).loadEmpCollByPubPosition(positionTypeLdapInfo.getId().toString());
            retMap.put(EMPLOYEES_ENTITY, ls);
        }
        return retMap;
    }

    private Map loadPositionMap(Context ctx, String positionId) throws EASBizException, BOSException {
        String NAME_ENTITY = NAME_ENTITY;
        String DESCRIPT_ENTITY = DESCRIPT_ENTITY;
        String PARENT_POSITIONID_ENTITY = "ParentPositionID";
        String JOBNAME_ENTITY = "jobname";
        String JOBCATEGORY_ENTITY = "jobCategory";
        HashMap<String, String> retMap = null;
        PositionInfo position = PositionFactory.getLocalInstance((Context)ctx).getPositionInfo((IObjectPK)new ObjectUuidPK(positionId));
        IHRPositionFacade iHRPositionFacade = HRPositionFacadeFactory.getLocalInstance(ctx);
        if (position != null) {
            JobInfo job;
            retMap = new HashMap<String, String>();
            String parentAllStr = iHRPositionFacade.getAllParentPositionStr(position);
            if (!"".equals(parentAllStr) && parentAllStr != null) {
                position.setName(parentAllStr + "_" + position.getName());
            } else {
                position.setName(position.getName());
            }
            retMap.put(NAME_ENTITY, position.getName());
            retMap.put(DESCRIPT_ENTITY, position.getDescription());
            PositionInfo parentPos = iHRPositionFacade.getParentPosition(position);
            if (parentPos != null) {
                retMap.put(PARENT_POSITIONID_ENTITY, parentPos.getName());
            }
            if ((job = position.getJob()) != null) {
                job = JobFactory.getLocalInstance((Context)ctx).getJobInfo((IObjectPK)new ObjectUuidPK(job.getId().toString()));
                retMap.put(JOBNAME_ENTITY, job.getName());
                JobCategoryInfo jobCategory = job.getJobCategory();
                if (jobCategory != null) {
                    jobCategory = JobCategoryFactory.getLocalInstance((Context)ctx).getJobCategoryInfo((IObjectPK)new ObjectUuidPK(jobCategory.getId().toString()));
                    retMap.put(JOBCATEGORY_ENTITY, jobCategory.getName());
                }
            }
        }
        return retMap;
    }
}

