/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.org.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.HistoryUtil;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.DeletedStatusEnum;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.IPosition;
import com.kingdee.eas.basedata.org.IPositionHierarchy;
import com.kingdee.eas.basedata.org.JobFactory;
import com.kingdee.eas.basedata.org.JobInfo;
import com.kingdee.eas.basedata.org.PositionCollection;
import com.kingdee.eas.basedata.org.PositionException;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionHierarchyCollection;
import com.kingdee.eas.basedata.org.PositionHierarchyFactory;
import com.kingdee.eas.basedata.org.PositionHierarchyInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.app.cache.OrgCacheFactory;
import com.kingdee.eas.basedata.org.util.HRHistoryUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.AssignTypeEnum;
import com.kingdee.eas.hr.base.EmpPosOrgRelationCollection;
import com.kingdee.eas.hr.base.EmpPosOrgRelationFactory;
import com.kingdee.eas.hr.base.EmpPosOrgRelationInfo;
import com.kingdee.eas.hr.base.IEmpPosOrgRelation;
import com.kingdee.eas.hr.base.util.HRUtilExtend;
import com.kingdee.eas.hr.base.util.SystemInitUtil;
import com.kingdee.eas.hr.emp.PersonOptFacadeFactory;
import com.kingdee.eas.hr.emp.app.util.SHRBizManageRelationUtil;
import com.kingdee.eas.hr.org.HRAdminOrgException;
import com.kingdee.eas.hr.org.HRJobFactory;
import com.kingdee.eas.hr.org.HRJobInfo;
import com.kingdee.eas.hr.org.HRPositionException;
import com.kingdee.eas.hr.org.HRVerifyModelFacadeFactory;
import com.kingdee.eas.hr.org.HrOrgBizException;
import com.kingdee.eas.hr.org.IRelationBetweenPositionAndLib;
import com.kingdee.eas.hr.org.JobException;
import com.kingdee.eas.hr.org.JobGradeFactory;
import com.kingdee.eas.hr.org.JobGradeInfo;
import com.kingdee.eas.hr.org.JobLevelFactory;
import com.kingdee.eas.hr.org.JobLevelInfo;
import com.kingdee.eas.hr.org.OrgOperatorException;
import com.kingdee.eas.hr.org.OrgnizationBizException;
import com.kingdee.eas.hr.org.PositionActionEnum;
import com.kingdee.eas.hr.org.PositionExtendCollection;
import com.kingdee.eas.hr.org.PositionExtendFactory;
import com.kingdee.eas.hr.org.PositionExtendInfo;
import com.kingdee.eas.hr.org.PositionStandardLibFactory;
import com.kingdee.eas.hr.org.PositionStandardLibInfo;
import com.kingdee.eas.hr.org.RelationBetweenPositionAndLibCollection;
import com.kingdee.eas.hr.org.RelationBetweenPositionAndLibFactory;
import com.kingdee.eas.hr.org.RelationBetweenPositionAndLibInfo;
import com.kingdee.eas.hr.org.app.AbstractPositionOptFacadeControllerBean;
import com.kingdee.eas.hr.org.app.OrgVersionEnableFacadeControllerBean;
import com.kingdee.eas.hr.org.util.OrgAdjLockManager;
import com.kingdee.eas.hr.org.util.OrgAdjustUtil;
import com.kingdee.eas.hr.org.util.OrgPosStandardLibUtil;
import com.kingdee.eas.hr.org.util.OrgUtils;
import com.kingdee.eas.hr.org.util.PositionActionUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.bizmanage.AdminOrgBURelationInfo;
import com.kingdee.shr.base.bizmanage.util.SHRBizManageCommonTool;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.base.syssetting.web.dynamic.model.FieldInfo;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class PositionOptFacadeControllerBean
extends AbstractPositionOptFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.org.app.PositionOptFacadeControllerBean");

    @Override
    protected void _updateRespPosition(Context ctx, String adminOrgUnitId, PositionInfo oldRespPos, PositionInfo newRespPos, Date effectDate) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)adminOrgUnitId)) {
            return;
        }
        if (StringUtils.isEmpty((String)newRespPos.getString("IsFromOrgAdjSchm"))) {
            OrgAdjLockManager.checkIfOrgLocked(ctx, adminOrgUnitId, null);
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("EFFDT"));
        sic.add(new SelectorItemInfo("isRespPosition"));
        sic.add(new SelectorItemInfo("index"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("lastUpdateUser"));
        Date now = new Date();
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        if (oldRespPos != null) {
            oldRespPos.setIsRespPosition(false);
            oldRespPos.setEFFDT(effectDate);
            oldRespPos.setIndex(0);
            oldRespPos.setLastUpdateTime(new Timestamp(now.getTime()));
            oldRespPos.setLastUpdateUser(userInfo);
            PositionFactory.getLocalInstance((Context)ctx).updatePartial((CoreBaseInfo)oldRespPos, sic);
            this.updatePositionHistoryLog(ctx, oldRespPos, PositionActionEnum.MODIFY);
        }
        if (newRespPos != null) {
            newRespPos.setIsRespPosition(true);
            newRespPos.setEFFDT(effectDate);
            newRespPos.setIndex(-1);
            newRespPos.setLastUpdateTime(new Timestamp(now.getTime()));
            newRespPos.setLastUpdateUser(userInfo);
            PositionFactory.getLocalInstance((Context)ctx).updatePartial((CoreBaseInfo)newRespPos, sic);
            this.updatePositionHistoryLog(ctx, newRespPos, PositionActionEnum.MODIFY);
        }
    }

    protected void updatePositionHistoryLog(Context ctx, PositionInfo oldRespPos, PositionActionEnum type) throws BOSException, EASBizException {
        PositionInfo historyInfo = (PositionInfo)PositionFactory.getLocalInstance((Context)ctx).getHisValueByCurrentIDAndDate((IObjectPK)new ObjectUuidPK(oldRespPos.getId().toString()), oldRespPos.getEFFDT());
        PositionActionUtil.updateAction(ctx, type, oldRespPos.getEFFDT(), oldRespPos.getId().toString(), oldRespPos.getParent() == null ? null : oldRespPos.getParent().getId().toString(), historyInfo.getAdminOrgUnit().getId().toString(), historyInfo.getHistoryRelateID(), null);
    }

    @Override
    protected IObjectPK _addNewPosition(Context ctx, PositionInfo info) throws BOSException, EASBizException {
        PositionInfo parentPosInfo;
        AdminOrgUnitInfo adminOrgInfo;
        SystemInitUtil.checkInitState((Context)ctx);
        boolean isPositionCanDuplicate = HRUtilExtend.isPositionCanDuplicate((Context)ctx);
        if (!isPositionCanDuplicate) {
            this.verifyPositionNameDuplicate(ctx, info);
        }
        IPosition iPosition = PositionFactory.getLocalInstance((Context)ctx);
        if (info.getAdminOrgUnit() == null) {
            throw new PositionException(PositionException.NOT_ADMINORGUNIT);
        }
        SHRBizManageRelationUtil.checkAdminBizManageDelegated((Context)ctx, (String)info.getAdminOrgUnit().getId().toString());
        if (StringUtils.isEmpty((String)info.getString("IsFromOrgAdjSchm"))) {
            OrgAdjLockManager.checkIfOrgLocked(ctx, info.getAdminOrgUnit().getId().toString(), null);
        }
        if (!(adminOrgInfo = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(info.getAdminOrgUnit().getId().toString()))).isIsStartSHR()) {
            throw new HRPositionException(HRPositionException.ORG_NOT_SHR, new Object[]{adminOrgInfo.getName()});
        }
        if (adminOrgInfo.isIsSealUp()) {
            throw new HrOrgBizException(HrOrgBizException.EXCEPTION18);
        }
        if (info.getParent() == null) {
            if (iPosition.exists("where id is not null")) {
                throw new PositionException(PositionException.NO_PARENT_POSITION);
            }
            info.setParent(info);
        }
        if (info.getParent() != null && info.getParent().getId() != null && (parentPosInfo = PositionFactory.getLocalInstance((Context)ctx).getPositionInfo((IObjectPK)new ObjectUuidPK(info.getParent().getId().toString()))).getDeletedStatus().getValue() == 2) {
            throw new HRPositionException(HRPositionException.FORBBIDEN_POSITION);
        }
        this.checkPositionStandardRelation(ctx, info);
        AdminOrgBURelationInfo adminBURelainfo = SHRBizManageCommonTool.getCurrentAdminOrgBURelation((Context)ctx, (String)adminOrgInfo.getId().toString(), (String)"SGuJm3nXW0GshQfKRXenomWJ1dE=");
        if (adminBURelainfo == null) {
            throw new HRAdminOrgException(HRAdminOrgException.ERROR_POSITION_ADMINORG_BURELATION_ISNULL);
        }
        Date effdt = info.getEFFDT();
        this.checkEffdt(ctx, effdt, info, null);
        info.setDeletedStatus(DeletedStatusEnum.NORMAL);
        ObjectUuidPK pk2 = new ObjectUuidPK(info.getAdminOrgUnit().getId());
        AdminOrgUnitInfo ouPartAdminInfo = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)pk2);
        info.setAdminOrgUnit(ouPartAdminInfo);
        if (info.getCU() == null) {
            info.setCU(ouPartAdminInfo.getCU());
        }
        boolean primaryPosition = info.isIsRespPosition();
        String originalPositionId = null;
        if (primaryPosition) {
            info.setIndex(-1);
            PositionCollection pCol = iPosition.getPositionCollection("where index = -1 and adminOrgUnit = '" + info.getAdminOrgUnit().getId().toString() + "'");
            if (pCol != null && pCol.size() > 0) {
                originalPositionId = pCol.get(0).getId().toString();
            }
        } else if (info.getIndex() == 0 || info.getIndex() == -1) {
            info.setIndex(OrgUtils.getMaxIndex(ctx, info.getAdminOrgUnit().getId().toString()) + 1);
        }
        this.checkJobGradeIsAble(ctx, info);
        PositionOptFacadeControllerBean.checkPositionEffdt(ctx, info);
        this.setJobLevel(ctx, info);
        if (info.getId() == null) {
            info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        }
        info.put("IS_FROM_SHR_OPT_CURD", (Object)"IS_FROM_SHR_OPT_CURD");
        this.setPositionExtendInfo(ctx, info);
        ServiceStateManager.getInstance().enableNextCallServices();
        IObjectPK pk = PositionFactory.getLocalInstance((Context)ctx).addnew((CoreBaseInfo)info);
        info.setId(BOSUuid.read((String)pk.toString()));
        this.updatePositionHistoryLog(ctx, info, PositionActionEnum.ADDNEW);
        this.updatePositionStandardLib(ctx, info, null);
        if (primaryPosition) {
            this.updateAdminRespPosition(ctx, info.getAdminOrgUnit(), info, info.getEFFDT());
            if (!StringUtils.isEmpty((String)originalPositionId)) {
                this.updateIndex(ctx, info, originalPositionId);
            }
        }
        return pk;
    }

    protected void updateIndex(Context ctx, PositionInfo info, String originalPositionId) throws BOSException, EASBizException {
        IPosition iPosition = PositionFactory.getLocalInstance((Context)ctx);
        PositionInfo positionInfo = iPosition.getPositionInfo((IObjectPK)new ObjectUuidPK(originalPositionId));
        positionInfo.put("IS_FROM_SHR_OPT_CURD", (Object)"IS_FROM_SHR_OPT_CURD");
        int index = OrgUtils.getMaxIndex(ctx, info.getAdminOrgUnit().getId().toString()) + 1;
        positionInfo.setIndex(index);
        iPosition.update((IObjectPK)new ObjectUuidPK(originalPositionId), (CoreBaseInfo)positionInfo);
    }

    @Override
    protected void _updatePosition(Context ctx, IObjectPK pk, PositionInfo info) throws BOSException, EASBizException {
        PositionInfo parentPosInfo;
        boolean primaryPosition;
        AdminOrgBURelationInfo adminBURelainfo;
        if (info.getAdminOrgUnit() == null) {
            throw new HRPositionException(HRPositionException.NOT_ADMINORGUNIT);
        }
        boolean isPositionCanDuplicate = HRUtilExtend.isPositionCanDuplicate((Context)ctx);
        if (!isPositionCanDuplicate) {
            this.verifyPositionNameDuplicate(ctx, info);
        }
        if (StringUtils.isEmpty((String)info.getString("IsFromOrgAdjSchm"))) {
            OrgAdjLockManager.checkIfOrgLocked(ctx, info.getAdminOrgUnit().getId().toString(), null);
        }
        if (info.getAdminOrgUnit() != null && info.getAdminOrgUnit().isIsStartSHR() && (adminBURelainfo = SHRBizManageCommonTool.getCurrentAdminOrgBURelation((Context)ctx, (String)info.getAdminOrgUnit().getId().toString(), (String)"SGuJm3nXW0GshQfKRXenomWJ1dE=")) == null) {
            throw new HRAdminOrgException(HRAdminOrgException.ERROR_POSITION_ADMINORG_BURELATION_ISNULL);
        }
        this.checkPositionStandardRelation(ctx, info);
        IPosition iPosition = PositionFactory.getLocalInstance((Context)ctx);
        PositionInfo oldInfo = iPosition.getPositionInfo(pk);
        String historyOperateState = info.getExtendedProperty("historyOperateState");
        Date effdt = info.getEFFDT();
        this.checkEffdt(ctx, effdt, info, historyOperateState);
        ObjectUuidPK adminPK = new ObjectUuidPK(oldInfo.getAdminOrgUnit().getId());
        this.verifyParentPositionChange(ctx, info, oldInfo);
        AdminOrgUnitInfo ouPartAdminInfo = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)adminPK);
        if ("change".equals(historyOperateState)) {
            if (!info.getAdminOrgUnit().getId().toString().equals(adminPK.toString())) {
                throw new HRPositionException(HRPositionException.ERROR_CHANGE_ADMINORG);
            }
        } else if ("revise".equals(historyOperateState) && !info.getAdminOrgUnit().getId().toString().equals(adminPK.toString())) {
            HRVerifyModelFacadeFactory.getLocalInstance(ctx).verifyReviseAdminOrg((CoreBaseInfo)info);
            this.updatePersonRecord(ctx, info);
        }
        if (primaryPosition = info.isIsRespPosition()) {
            info.setIndex(-1);
        }
        boolean resPosChanged = false;
        PositionInfo oldRespPoitionInfo = ouPartAdminInfo.getResponPosition();
        if (oldInfo.isIsRespPosition() != primaryPosition) {
            resPosChanged = true;
        }
        info.setCU(oldInfo.getCU());
        if (oldInfo.getParent() != null && info.getParent() == null) {
            info.setParent(oldInfo.getParent());
        }
        if (info.getParent() != null && (parentPosInfo = PositionFactory.getLocalInstance((Context)ctx).getPositionInfo((IObjectPK)new ObjectUuidPK(info.getParent().getId().toString()))).getDeletedStatus().getValue() == 2) {
            throw new HRPositionException(HRPositionException.FORBBIDEN_POSITION);
        }
        String hrJobId = info.getString("HRJob");
        if (hrJobId == null && info.getJob() != null) {
            throw new OrgnizationBizException(OrgnizationBizException.POSI_MAINTAI_HRJOB);
        }
        if (hrJobId != null) {
            HRJobInfo hrJobInfo = HRJobFactory.getLocalInstance(ctx).getHRJobInfo((IObjectPK)new ObjectUuidPK(hrJobId));
            info.setJob(hrJobInfo.getJob());
        } else if (info.containsKey("HRJob")) {
            info.setJob(null);
        }
        info.put("IS_FROM_SHR_OPT_CURD", (Object)"IS_FROM_SHR_OPT_CURD");
        if ("revise".equals(historyOperateState)) {
            if (oldInfo.getEFFDT().after(info.getEFFDT())) {
                this.deletePositionHisWhenRevise(ctx, pk.toString(), info.getEFFDT());
            }
            ServiceStateManager.getInstance().enableNextCallServices();
            iPosition.revise(pk, (CoreBaseInfo)info);
        } else {
            info.setCreateTime(new Timestamp(System.currentTimeMillis()));
            info.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
            ServiceStateManager.getInstance().enableNextCallServices();
            iPosition.update(pk, (CoreBaseInfo)info);
        }
        this.setPositionExtendInfo(ctx, info);
        this.updatePositionHistoryLog(ctx, info, PositionActionEnum.MODIFY);
        if (primaryPosition && !oldInfo.isIsRespPosition()) {
            this.changeRespPostion(ctx, pk.toString(), adminPK.toString(), oldRespPoitionInfo, info.getEFFDT());
        } else if (!primaryPosition && oldInfo.isIsRespPosition()) {
            this.updateAdminRespPosition(ctx, oldInfo.getAdminOrgUnit(), null, info.getEFFDT());
        }
        this.checkJobGradeIsAble(ctx, info);
        this.updatePositionStandardLib(ctx, info, pk);
    }

    protected void updatePositionStandardLib(Context ctx, PositionInfo info, IObjectPK pk) throws EASBizException, BOSException {
        PositionStandardLibInfo posStdInfo = (PositionStandardLibInfo)info.get("positionStandardLib");
        IRelationBetweenPositionAndLib iRelationBetweenPositionAndLib = RelationBetweenPositionAndLibFactory.getLocalInstance(ctx);
        if (posStdInfo != null) {
            if (pk != null && !"".equals(pk.toString())) {
                String oql = "where position.id = '" + pk + "'";
                RelationBetweenPositionAndLibCollection collection = iRelationBetweenPositionAndLib.getRelationBetweenPositionAndLibCollection(oql);
                if (null != collection && collection.size() > 0) {
                    RelationBetweenPositionAndLibInfo relinfo = collection.get(0);
                    relinfo.setPositionStandardLib(posStdInfo);
                    iRelationBetweenPositionAndLib.update((IObjectPK)new ObjectUuidPK(relinfo.getId()), relinfo);
                } else {
                    RelationBetweenPositionAndLibInfo relation = new RelationBetweenPositionAndLibInfo();
                    relation.setPosition(info);
                    relation.setPositionStandardLib(posStdInfo);
                    iRelationBetweenPositionAndLib.addnew(relation);
                }
            } else {
                RelationBetweenPositionAndLibInfo relation = new RelationBetweenPositionAndLibInfo();
                relation.setPosition(info);
                relation.setPositionStandardLib(posStdInfo);
                iRelationBetweenPositionAndLib.addnew(relation);
                Object doNotNeedCopyPosInstruction = info.get("NotCopyPosLibInstruction");
                if (doNotNeedCopyPosInstruction != null && ((Boolean)doNotNeedCopyPosInstruction).booleanValue()) {
                    return;
                }
                OrgPosStandardLibUtil.setPositionInstruction(ctx, posStdInfo.getId().toString(), info.getId().toString());
                OrgPosStandardLibUtil.copyAttachment(ctx, posStdInfo.getId().toString(), info.getId().toString());
            }
        } else if (pk != null) {
            iRelationBetweenPositionAndLib.delete("where position.id = '" + pk + "'");
        }
    }

    protected IObjectPK setPositionExtendInfo(Context ctx, PositionInfo info) throws EASBizException, BOSException {
        String sql = "select * where position ='" + info.getId().toString() + "'";
        PositionExtendInfo peInfo = null;
        PositionExtendCollection peColl = PositionExtendFactory.getLocalInstance(ctx).getPositionExtendCollection(sql);
        if (peColl.size() > 0) {
            peInfo = peColl.get(0);
        } else {
            peInfo = new PositionExtendInfo();
            peInfo.setPosition(info);
        }
        List extFields = (List)info.get("extFields");
        if (extFields != null) {
            for (int i = 0; i < extFields.size(); ++i) {
                peInfo.put(((FieldInfo)extFields.get(i)).getName().substring(((String)info.get("prefix")).length()), info.get(((FieldInfo)extFields.get(i)).getName()));
            }
        }
        String hrJobId = info.getString("HRJob");
        String lowJobLevelId = info.getString("lowJobLevel");
        String highJobLevelId = info.getString("highJobLevel");
        String isShowInOrgChart = info.getString("isShowInOrgChart");
        peInfo.setEFFDT(info.getEFFDT());
        peInfo.setLEFFDT(HRHistoryUtil.getMaxEndDate());
        if (hrJobId == null && info.getJob() != null) {
            throw new OrgnizationBizException(OrgnizationBizException.POSI_MAINTAI_HRJOB);
        }
        if (hrJobId != null) {
            HRJobInfo hrJobInfo = HRJobFactory.getLocalInstance(ctx).getHRJobInfo((IObjectPK)new ObjectUuidPK(hrJobId));
            peInfo.setHrJob(hrJobInfo);
            info.setJob(hrJobInfo.getJob());
        } else if (info.containsKey("HRJob")) {
            peInfo.setHrJob(null);
            info.setJob(null);
        }
        if (StringUtils.isEmpty((String)lowJobLevelId) && !StringUtils.isEmpty((String)highJobLevelId) || !StringUtils.isEmpty((String)lowJobLevelId) && StringUtils.isEmpty((String)highJobLevelId)) {
            throw new JobException(JobException.JOB_JOBLEVEL_NOT_ALL_NULL);
        }
        if (!StringUtils.isEmpty((String)lowJobLevelId) && !StringUtils.isEmpty((String)highJobLevelId)) {
            JobLevelInfo lowJobLevel = JobLevelFactory.getLocalInstance(ctx).getJobLevelInfo((IObjectPK)new ObjectUuidPK(lowJobLevelId));
            JobLevelInfo highJobLevel = JobLevelFactory.getLocalInstance(ctx).getJobLevelInfo((IObjectPK)new ObjectUuidPK(highJobLevelId));
            if (lowJobLevel.getIndex() > highJobLevel.getIndex()) {
                throw new JobException(JobException.JOB_HIGHLEVEL_SMALL_LOWLEVEL);
            }
            peInfo.setLowJobLevel(lowJobLevel);
            peInfo.setHighJobLevel(highJobLevel);
        } else if (info.containsKey("lowJobLevel") && info.containsKey("highJobLevel")) {
            peInfo.setLowJobLevel(null);
            peInfo.setHighJobLevel(null);
        }
        if (null != isShowInOrgChart) {
            if ("true".equals(isShowInOrgChart)) {
                peInfo.setIsShowInOrgChart(true);
            } else if ("false".equals(isShowInOrgChart)) {
                peInfo.setIsShowInOrgChart(false);
            }
        } else if (info.containsKey("isShowInOrgChart")) {
            peInfo.setIsShowInOrgChart(false);
        }
        IObjectPK Pk = PositionExtendFactory.getLocalInstance(ctx).save((CoreBaseInfo)peInfo);
        return Pk;
    }

    protected void verifyParentPositionChange(Context ctx, PositionInfo info, PositionInfo oldInfo) throws BOSException, EASBizException {
        if (info.getParent() != null && !HRUtilExtend.isObjectEquelsByPkValue((CoreBaseInfo)oldInfo.getParent(), (CoreBaseInfo)info.getParent()) && HRUtilExtend.isObjectEquelsByPkValue((CoreBaseInfo)info, (CoreBaseInfo)info.getParent())) {
            String sql = "select fid from t_org_positionHierarchy where fhierarchyid='00000000-0000-0000-0000-000000000001396FCAD0' and fchildid=FParentID ";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            try {
                if (rs.next()) {
                    throw new HRPositionException(HRPositionException.PARENTPOSITIONCANTSELF);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    protected void verifyPositionNameDuplicate(Context ctx, PositionInfo position) throws EASBizException {
        StringBuffer oql = new StringBuffer();
        oql.append("select id,name where adminorgunit = '").append(position.getAdminOrgUnit().getId()).append("'");
        if (position.getId() != null) {
            oql.append(" and id != '").append(position.getId()).append("'");
        }
        oql.append(" and deletedStatus = '1' ");
        try {
            PositionCollection pCol = PositionFactory.getLocalInstance((Context)ctx).getPositionCollection(oql.toString());
            for (int i = 0; i < pCol.size(); ++i) {
                this.positionNameMutiLangRepeatCheck(position, pCol.get(i));
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    protected void positionNameMutiLangRepeatCheck(PositionInfo newPosition, PositionInfo oldPosition) throws EASBizException {
        for (int i = 1; i < 4; ++i) {
            String positionName;
            String nameLocal = "name_l" + i;
            if (newPosition.get(nameLocal) == null || newPosition.get(nameLocal).equals("") || !(positionName = (String)newPosition.get(nameLocal)).equals(oldPosition.get(nameLocal))) continue;
            if (i == 1) {
                throw new HrOrgBizException(HrOrgBizException.EXCEPTION23, new Object[]{positionName});
            }
            if (i == 2) {
                throw new HrOrgBizException(HrOrgBizException.EXCEPTION24, new Object[]{positionName});
            }
            if (i != 3) continue;
            throw new HrOrgBizException(HrOrgBizException.EXCEPTION25, new Object[]{positionName});
        }
    }

    protected void updatePersonRecord(Context ctx, PositionInfo positionInfo) throws BOSException, EASBizException {
        String positionId = positionInfo.getId().toString();
        String empPosRelationOql = "select id where position = '" + positionId + "'";
        IEmpPosOrgRelation iEmpPosOrgRelation = EmpPosOrgRelationFactory.getLocalInstance((Context)ctx);
        EmpPosOrgRelationCollection empPosRelationColl = iEmpPosOrgRelation.getEmpPosOrgRelationCollection(empPosRelationOql);
        if (empPosRelationColl != null) {
            String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
            AdminOrgUnitInfo adminOrgInfo = positionInfo.getAdminOrgUnit();
            String adminOrgId = adminOrgInfo.getId().toString();
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("adminOrg"));
            int size = empPosRelationColl.size();
            for (int i = 0; i < size; ++i) {
                EmpPosOrgRelationInfo empPosRelationInfo = empPosRelationColl.get(i);
                empPosRelationInfo.setAdminOrg(adminOrgInfo);
                iEmpPosOrgRelation.update((IObjectPK)new ObjectUuidPK(empPosRelationInfo.getId().toString()), (CoreBaseInfo)empPosRelationInfo);
            }
            Connection conn = null;
            Statement stmt = null;
            try {
                conn = this.getConnection(ctx);
                stmt = conn.createStatement();
                StringBuffer personPositionSql = new StringBuffer("update t_hr_personposition set fpersondep = '").append(adminOrgId).append("',").append(" flastupdateuserid = '").append(userId).append("', flastupdatetime = getdate()").append(" where fprimarypositionid = '").append(positionId).append("'");
                stmt.addBatch(personPositionSql.toString());
                StringBuffer personPositionHisSql = new StringBuffer("update t_hr_personpositionhis set fpersondep = '").append(adminOrgId).append("',").append(" flastupdateuserid = '").append(userId).append("', flastupdatetime = getdate()").append(" where fprimarypositionid = '").append(positionId).append("'");
                stmt.addBatch(personPositionHisSql.toString());
                StringBuffer empFlowInOutSql = new StringBuffer("update t_hr_empflowinout set fadminorgid = '").append(adminOrgId).append("',").append(" flastupdateuserid = '").append(userId).append("', flastupdatetime = getdate()").append(" where fpositionid = '").append(positionId).append("'");
                stmt.addBatch(empFlowInOutSql.toString());
                StringBuffer empPostExpSql = new StringBuffer("update t_hr_emppostexperiencehis set fadminorgid = '").append(adminOrgId).append("'").append(" where fpositionid = '").append(positionId).append("'");
                stmt.addBatch(empPostExpSql.toString());
                stmt.executeBatch();
            }
            catch (Exception e) {
                try {
                    SQLException sqle;
                    logger.error((Object)"batch Position Revise  error! \n", (Throwable)e);
                    if (e instanceof SQLException && (sqle = ((SQLException)e).getNextException()) != null) {
                        logger.error((Object)"**************************** Next exception is: ***************************");
                        logger.error((Object)"sql exception :", (Throwable)sqle);
                    }
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(stmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        }
    }

    protected void deletePositionHisWhenRevise(Context ctx, String pk, Date effdt) throws BOSException {
        String sql = "delete from T_ORG_PositionHis where fhistoryrelateid = '" + pk + "' and feffdt >= " + HRUtilExtend.getDateStringWithoutMininuteTs((Date)effdt) + " and fleffdt <> " + HRUtilExtend.getDateStringWithoutMininuteTs((Date)HistoryUtil.getMaxDate());
        DbUtil.execute((Context)ctx, (String)sql);
        sql = "delete from t_hr_positionextendhis where FPositionID = '" + pk + "' and feffdt >= " + HRUtilExtend.getDateStringWithoutMininuteTs((Date)effdt);
        DbUtil.execute((Context)ctx, (String)sql);
    }

    protected void checkEffdt(Context ctx, Date effdt, PositionInfo positionInfo, String historyOperateState) throws EASBizException, BOSException {
        Date earlyEffdt = HRVerifyModelFacadeFactory.getLocalInstance(ctx).getEarlyEffdt((CoreBaseInfo)positionInfo);
        Date oldEffdt = HRVerifyModelFacadeFactory.getLocalInstance(ctx).getOldEffdt((CoreBaseInfo)positionInfo);
        if (effdt == null) {
            if (historyOperateState == null) {
                positionInfo.setEFFDT(earlyEffdt);
            } else if (historyOperateState.equals("change")) {
                positionInfo.setEFFDT(DateTimeUtils.truncateDate((Date)new Date()));
            } else if (historyOperateState.equals("revise")) {
                positionInfo.setEFFDT(oldEffdt);
            }
        }
        if ((effdt = positionInfo.getEFFDT()).before(earlyEffdt)) {
            Object[] params = new String[]{HRUtilExtend.getDateStringWithoutMininute((Date)earlyEffdt)};
            throw new HRPositionException(HRPositionException.ERROR_EFFDT, params);
        }
        if (effdt.after(new Date())) {
            Object[] params = new String[]{HRUtilExtend.getDateStringWithoutMininute((Date)new Date())};
            throw new HRPositionException(HRPositionException.ERROR_FUTURE_EFFDT, params);
        }
        if (historyOperateState != null && historyOperateState.equals("revise") && effdt.after(oldEffdt)) {
            Object[] params = new String[]{HRUtilExtend.getDateStringWithoutMininute((Date)oldEffdt)};
            throw new HRPositionException(HRPositionException.ERROR_REVISE_EFFDT, params);
        }
        if (historyOperateState != null && historyOperateState.equals("change") && !effdt.after(oldEffdt)) {
            Object[] params = new String[]{HRUtilExtend.getDateStringWithoutMininute((Date)oldEffdt)};
            throw new HRPositionException(HRPositionException.ERROR_CHANGE_EFFDT, params);
        }
    }

    protected void updatePHByParentChanged(Context ctx, PositionInfo info, PositionInfo oldInfo) throws BOSException, EASBizException {
        String ql;
        IPositionHierarchy iPH = PositionHierarchyFactory.getLocalInstance((Context)ctx);
        if (!iPH.exists(ql = "where child='" + info.getId() + "' and hierarchy='" + "00000000-0000-0000-0000-000000000001396FCAD0" + "'")) {
            return;
        }
        PositionHierarchyInfo oldPHInfo = iPH.getPositionHierarchyInfo(ql);
        PositionInfo oldParentInfo = oldInfo.getParent();
        if (oldParentInfo == null) {
            oldParentInfo = oldPHInfo.getParent();
        }
        if (oldParentInfo != null && !oldParentInfo.getId().toString().equals(info.getParent().getId().toString())) {
            oldPHInfo.setParent(info.getParent());
            iPH.update((IObjectPK)new ObjectUuidPK(oldPHInfo.getId()), (CoreBaseInfo)oldPHInfo);
        }
    }

    @Override
    protected void _delete(Context ctx, String positionId) throws BOSException, EASBizException {
        String[] ids = positionId.split(",");
        for (int i = 0; i < ids.length; ++i) {
            Object[] params;
            PositionInfo posInfo;
            String id = ids[i];
            if (this.isPositionReferencedByEmpPosOrgRelation(ctx, id).booleanValue()) {
                posInfo = PositionFactory.getLocalInstance((Context)ctx).getPositionInfo((IObjectPK)new ObjectUuidPK(id));
                params = new String[]{posInfo.getName() + "(" + posInfo.getNumber() + ")"};
                throw new HRPositionException(HRPositionException.POSITION_REFERENCED_BY_EMPPOSORGRELATION, params);
            }
            if (this.existSubPosition(ctx, id)) {
                posInfo = PositionFactory.getLocalInstance((Context)ctx).getPositionInfo((IObjectPK)new ObjectUuidPK(id));
                params = new String[]{posInfo.getName() + "(" + posInfo.getNumber() + ")"};
                throw new HRPositionException(HRPositionException.POSITION_EXIST_CHILDREN, params);
            }
            OrgAdjLockManager.checkIfOrgLocked(ctx, null, id);
            ObjectUuidPK pk = new ObjectUuidPK(ids[i]);
            Object[] param = new Object[]{ids[i]};
            DbUtil.execute((Context)ctx, (String)"delete from T_HR_PositionFact  where FPositionId = ?", (Object[])param);
            DbUtil.execute((Context)ctx, (String)"delete from T_ORG_PositionHIS  where FHistoryRelateID = ?", (Object[])param);
            DbUtil.execute((Context)ctx, (String)"delete from T_HR_PositionExtend  where FPositionId = ?", (Object[])param);
            DbUtil.execute((Context)ctx, (String)"delete from T_HR_PositionExtendHis  where FPositionId = ?", (Object[])param);
            DbUtil.execute((Context)ctx, (String)"delete from T_HR_RelBetweenPositionAndLib  where FPositionId = ?", (Object[])param);
            DbUtil.execute((Context)ctx, (String)"delete from T_HR_PositionDuty  where FPositionId = ?", (Object[])param);
            DbUtil.execute((Context)ctx, (String)"delete from T_HR_PositionRequirement  where FPositionId = ?", (Object[])param);
            DbUtil.execute((Context)ctx, (String)"delete from T_HR_PositionQualification  where FPositionId = ?", (Object[])param);
            IPosition iPosition = PositionFactory.getLocalInstance((Context)ctx);
            iPosition.delete((IObjectPK)pk);
        }
    }

    protected void changeRespPostion(Context ctx, String positionId, String adminOrgId, PositionInfo oldRespPoitionInfo, Date effDT) throws BOSException, EASBizException {
        SelectorItemCollection sic = null;
        String now = DateTimeUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss");
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        if (oldRespPoitionInfo != null) {
            oldRespPoitionInfo = PositionFactory.getLocalInstance((Context)ctx).getPositionInfo((IObjectPK)new ObjectUuidPK(oldRespPoitionInfo.getId()));
            oldRespPoitionInfo.setIsRespPosition(false);
            int index = OrgUtils.getMaxIndex(ctx, oldRespPoitionInfo.getAdminOrgUnit().getId().toString()) + 1;
            oldRespPoitionInfo.setIndex(index);
            oldRespPoitionInfo.put("IS_FROM_SHR_OPT_CURD", (Object)true);
            PositionFactory.getLocalInstance((Context)ctx).update((IObjectPK)new ObjectUuidPK(oldRespPoitionInfo.getId()), (CoreBaseInfo)oldRespPoitionInfo);
            String hisSql = "update T_ORG_PositionHis set fisrespposition = 0, findex = " + index + ",flastupdatetime = {ts '" + now + "'},flastupdateuserid = ? where fhistoryrelateid = ? and fleffdt = " + HRUtilExtend.getDateStringWithoutMininuteTs((Date)HistoryUtil.getMaxDate());
            DbUtil.execute((Context)ctx, (String)hisSql, (Object[])new Object[]{userInfo.getId().toString(), oldRespPoitionInfo.getId().toString()});
            this.updatePositionHistoryLog(ctx, oldRespPoitionInfo, PositionActionEnum.MODIFY);
        }
        sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("EFFDT"));
        sic.add(new SelectorItemInfo("name"));
        AdminOrgUnitInfo adminInfo = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(adminOrgId), sic);
        PositionInfo positionInfo = new PositionInfo();
        positionInfo.setId(BOSUuid.read((String)positionId));
        this.updateAdminRespPosition(ctx, adminInfo, positionInfo, effDT);
    }

    @Override
    protected void _movePosition(Context ctx, PositionInfo positionInfo) throws BOSException, EASBizException {
        IPosition iPosition = PositionFactory.getLocalInstance((Context)ctx);
        IAdminOrgUnit iAdminOrgUnit = AdminOrgUnitFactory.getLocalInstance((Context)ctx);
        String positionId = positionInfo.getId().toString();
        AdminOrgUnitInfo newAdminInfo = positionInfo.getAdminOrgUnit();
        if (newAdminInfo == null) {
            return;
        }
        if (StringUtils.isEmpty((String)positionInfo.getString("IsFromOrgAdjSchm"))) {
            OrgAdjLockManager.checkIfOrgLocked(ctx, positionInfo.getAdminOrgUnit().getId().toString(), null);
        }
        Date effectDate = positionInfo.getEFFDT();
        SelectorItemCollection posSic = null;
        posSic = new SelectorItemCollection();
        posSic.add(new SelectorItemInfo("id"));
        posSic.add(new SelectorItemInfo("EFFDT"));
        posSic.add(new SelectorItemInfo("isRespPosition"));
        posSic.add(new SelectorItemInfo("adminOrgUnit"));
        posSic.add(new SelectorItemInfo("index"));
        posSic.add(new SelectorItemInfo("job"));
        posSic.add(new SelectorItemInfo("parent"));
        posSic.add(new SelectorItemInfo("job"));
        posSic.add(new SelectorItemInfo("job.name"));
        posSic.add(new SelectorItemInfo("name"));
        posSic.add(new SelectorItemInfo("adminOrgUnit.name"));
        PositionInfo oldPosInfo = iPosition.getPositionInfo((IObjectPK)new ObjectUuidPK(positionId), posSic);
        AdminOrgUnitInfo oldAdminInfo = oldPosInfo.getAdminOrgUnit();
        SelectorItemCollection adminSic = new SelectorItemCollection();
        adminSic.add(new SelectorItemInfo("responPosition"));
        adminSic.add(new SelectorItemInfo("EFFDT"));
        adminSic.add(new SelectorItemInfo("name"));
        newAdminInfo = iAdminOrgUnit.getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(newAdminInfo.getId()), adminSic);
        if (oldAdminInfo != null && oldAdminInfo.getId().equals((Object)newAdminInfo.getId())) {
            if (positionInfo.get("isFromOrgMoving") != null) {
                return;
            }
            throw new OrgOperatorException(OrgOperatorException.ADMIN_NOT_CHANGE, new Object[]{oldPosInfo.getName()});
        }
        if (oldPosInfo.isIsRespPosition()) {
            logger.info((Object)"--------2.1 \u3001the position is responPosition----------");
            StringBuffer oql = new StringBuffer();
            oql.append(" where adminOrgUnit.id ='").append((Object)(oldAdminInfo == null ? "" : oldAdminInfo.getId())).append("'").append(" and id <> '").append(positionId).append("' and deletedStatus=1");
        }
        logger.info((Object)"--------move position start----------");
        logger.info((Object)"--------1 \u3001move person----------");
        AssignTypeEnum assignType = null;
        if (positionInfo.containsKey("move_person_type")) {
            assignType = (AssignTypeEnum)positionInfo.get("move_person_type");
        }
        this.updatePersonAdmin(ctx, positionId, newAdminInfo.getId().toString(), effectDate, assignType);
        positionInfo.setIsRespPosition(oldPosInfo.isIsRespPosition());
        positionInfo.setIndex(oldPosInfo.getIndex());
        positionInfo.setJob(oldPosInfo.getJob());
        if (oldPosInfo.isIsRespPosition()) {
            logger.info((Object)"--------2.2 \u3001update the position's old adminOrgUnit----------");
            this.updateAdminRespPosition(ctx, oldAdminInfo, null, effectDate);
            if (newAdminInfo.getResponPosition() != null) {
                logger.info((Object)"--------2.4 \u3001the new admin has responPosition----------");
                positionInfo.setIsRespPosition(false);
                positionInfo.setIndex(0);
            } else {
                logger.info((Object)"--------2.4 \u3001the new admin hasnot responPosition----------");
                this.updateAdminRespPosition(ctx, newAdminInfo, positionInfo, effectDate);
            }
        } else {
            logger.info((Object)"--------2.3 \u3001check the new admin  has responPosition----------");
        }
        if (positionInfo.getParent() != null) {
            this.updatePHByParentChanged(ctx, positionInfo, oldPosInfo);
        } else {
            positionInfo.setParent(oldPosInfo.getParent());
        }
        positionInfo.setName(oldPosInfo.getName());
        iPosition.updatePartial((CoreBaseInfo)positionInfo, posSic);
        PositionInfo historyInfo = (PositionInfo)PositionFactory.getLocalInstance((Context)ctx).getHisValueByCurrentIDAndDate((IObjectPK)new ObjectUuidPK(positionInfo.getId().toString()), positionInfo.getEFFDT());
        PositionActionUtil.updateAction(ctx, PositionActionEnum.MOVE, positionInfo.getEFFDT(), positionInfo.getId().toString(), historyInfo.getParent().getId().toString(), historyInfo.getAdminOrgUnit().getId().toString(), historyInfo.getHistoryRelateID(), oldPosInfo.getAdminOrgUnit().getId().toString());
        String userId = HRFilterUtils.getCurrentUserId((Context)ctx);
        Date date = new Date();
        java.sql.Date nowDate = new java.sql.Date(date.getTime());
        String updateSql = "update T_ORG_Position set FLASTUPDATETIME = {" + nowDate + "},FLASTUPDATEUSERID = '" + userId + "' where fid = '" + positionId + "'";
        String updateSql2 = "update T_ORG_PositionHIS set FLASTUPDATETIME = {" + nowDate + "},FLASTUPDATEUSERID = '" + userId + "' where fhistoryrelateid = '" + positionId + "' and fleffdt > {2199-12-30 00:00:00}";
        DbUtil.execute((Context)ctx, (String)updateSql);
        DbUtil.execute((Context)ctx, (String)updateSql2);
    }

    protected void updateAdminRespPosition(Context ctx, AdminOrgUnitInfo adminInfo, PositionInfo respPosition, Date effectDate) throws BOSException, EASBizException {
        if (adminInfo == null || adminInfo.getId() == null) {
            return;
        }
        String adminOrgId = adminInfo.getId().toString();
        String selectOrgsql = "select min(feffdt) feffdt from t_org_adminHis where fhistoryRelateId='" + adminOrgId + "'";
        IRowSet hisRs = DbUtil.executeQuery((Context)ctx, (String)selectOrgsql);
        java.sql.Date earlyDate = null;
        try {
            if (hisRs.next()) {
                earlyDate = hisRs.getDate("feffdt");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (earlyDate != null && DateTimeUtils.dayAfter((Date)earlyDate, (Date)effectDate)) {
            throw new OrgOperatorException(OrgOperatorException.ADMIN_EFFDT_ERROR1, new Object[]{adminInfo.getName(), HRUtilExtend.getDateStringWithoutMininute((Date)effectDate), HRUtilExtend.getDateStringWithoutMininute((Date)earlyDate)});
        }
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = this.getConnection(ctx);
            stmt = conn.createStatement();
            if (respPosition == null) {
                String sql = "update T_ORG_Admin set fresponpositionid = null where fid = '" + adminOrgId + "'";
                stmt.addBatch(sql);
                String hisSql = "update T_ORG_AdminHis set fresponpositionid = null where fhistoryrelateid = '" + adminOrgId + "' and fleffdt = " + HRUtilExtend.getDateStringWithoutMininuteTs((Date)HistoryUtil.getMaxDate());
                stmt.addBatch(hisSql);
                String ousql = "update T_ORG_OUPartAdmin set fresponpositionid = null where funitid = '" + adminOrgId + "'";
                stmt.addBatch(ousql);
            } else {
                String respPositionId = respPosition.getId().toString();
                String sql = "update T_ORG_Admin set fresponpositionid = '" + respPositionId + "' where fid = '" + adminOrgId + "'";
                stmt.addBatch(sql);
                String hisSql = "update T_ORG_AdminHis set fresponpositionid = '" + respPositionId + "' where fhistoryrelateid = '" + adminOrgId + "' and fleffdt = " + HRUtilExtend.getDateStringWithoutMininuteTs((Date)HistoryUtil.getMaxDate());
                stmt.addBatch(hisSql);
                String ousql = "update T_ORG_OUPartAdmin set fresponpositionid = '" + respPositionId + "' where funitid = '" + adminOrgId + "'";
                stmt.addBatch(ousql);
            }
            stmt.executeBatch();
        }
        catch (Exception e) {
            try {
                SQLException sqle;
                logger.error((Object)"batch updateAdminRespPosition error! \n", (Throwable)e);
                if (e instanceof SQLException && (sqle = ((SQLException)e).getNextException()) != null) {
                    logger.error((Object)"**************************** Next exception is: ***************************");
                    logger.error((Object)"sql exception :", (Throwable)sqle);
                }
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        OrgCacheFactory.getOrgCache((Context)ctx).clearOrgCache();
    }

    protected void updatePersonAdmin(Context ctx, String positionID, String adminOrgID, Date effectDate, AssignTypeEnum assignType) throws BOSException, EASBizException {
        PersonOptFacadeFactory.getLocalInstance((Context)ctx).updatePersonAdmin(positionID, adminOrgID, effectDate, assignType);
    }

    @Override
    protected IObjectPK _revisionHistory(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        PositionInfo pInfo = (PositionInfo)model;
        OrgAdjLockManager.checkIfOrgLocked(ctx, null, pk.toString());
        PositionFactory.getLocalInstance((Context)ctx).revisionHistory(pk, (CoreBaseInfo)model);
        String parentId = "";
        if (pInfo.getParent() != null) {
            pInfo.getParent().getId().toString();
        }
        PositionActionUtil.updateAction(ctx, PositionActionEnum.MOVE, pInfo.getEFFDT(), pInfo.getId().toString(), parentId, pInfo.getAdminOrgUnit().getId().toString(), pk.toString(), null);
        return null;
    }

    protected void checkPosCanOprration(Context ctx, String positionID, String type) throws EASBizException, BOSException {
        Integer status = null;
        String msg = "";
        if ("enable".equals(type)) {
            msg = SHRServerResource.getString((String)"com.kingdee.eas.hr.org.HrOrgBizResource", (String)"label8", (Context)ctx);
            status = 1;
        } else {
            msg = SHRServerResource.getString((String)"com.kingdee.eas.hr.org.HrOrgBizResource", (String)"label60", (Context)ctx);
            status = 2;
        }
        String sql = "where id ='" + positionID + "' and deletedStatus = " + status;
        boolean flag = PositionFactory.getLocalInstance((Context)ctx).exists(sql);
        if (flag) {
            throw new OrgnizationBizException(OrgnizationBizException.STATUS_POSI, new Object[]{msg, msg});
        }
    }

    @Override
    protected void _enable(Context ctx, String positionID) throws BOSException, EASBizException {
        this.checkPosCanOprration(ctx, positionID, "enable");
        IPosition iPosition = PositionFactory.getLocalInstance((Context)ctx);
        PositionInfo posInfo = PositionFactory.getLocalInstance((Context)ctx).getPositionInfo((IObjectPK)new ObjectUuidPK(positionID));
        boolean isPositionCanDuplicate = HRUtilExtend.isPositionCanDuplicate((Context)ctx);
        if (!isPositionCanDuplicate) {
            this.verifyPositionNameDuplicate(ctx, posInfo);
        }
        if (this.existDisablePrePosition(ctx, positionID)) {
            throw new PositionException(HRPositionException.EXIST_PRE_POSITION);
        }
        PositionInfo info = iPosition.getPositionInfo((IObjectPK)new ObjectUuidPK(positionID));
        if (DateTimeUtils.truncateDate((Date)OrgUtils.getSealUpDate(ctx)).after(posInfo.getEFFDT())) {
            info.setEFFDT(DateTimeUtils.truncateDate((Date)OrgUtils.getSealUpDate(ctx)));
        }
        info.setDeletedStatus(DeletedStatusEnum.NORMAL);
        info.setValiDate(null);
        info.put("IS_FROM_SHR_OPT_CURD", (Object)"true");
        iPosition.update((IObjectPK)new ObjectUuidPK(positionID), (CoreBaseInfo)info);
        if (info.isIsRespPosition()) {
            String adminOrgId = info.getAdminOrgUnit().getId().toString();
            DbUtil.execute((Context)ctx, (String)"UPDATE T_ORG_POSITION SET FISRESPPOSITION = 0  WHERE FISRESPPOSITION = 1 AND FADMINORGUNITID = ? AND FID <> ? ", (Object[])new Object[]{adminOrgId, positionID});
            DbUtil.execute((Context)ctx, (String)"UPDATE T_ORG_ADMIN SET FRESPONPOSITIONID = ? WHERE FID = ? AND FRESPONPOSITIONID <> ? ", (Object[])new Object[]{positionID, adminOrgId, positionID});
            DbUtil.execute((Context)ctx, (String)"UPDATE T_ORG_OUPARTADMIN SET FRESPONPOSITIONID = ? WHERE FUNITID = ? AND FRESPONPOSITIONID <> ? ", (Object[])new Object[]{positionID, adminOrgId, positionID});
        }
        this.updatePositionHistoryLog(ctx, info, PositionActionEnum.ENABLE);
    }

    protected boolean existDisablePrePosition(Context ctx, String pId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select fid from t_org_position where fdeletedstatus =2 and fid = (select fparentid from t_org_position where fid =?) and fparentid <> fid");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{pId});
        return rowSet.size() > 0;
    }

    @Override
    protected void _disable(Context ctx, String positionID) throws BOSException, EASBizException {
        this.checkPosCanOprration(ctx, positionID, "disable");
        this.disableOpt(ctx, positionID, null);
    }

    protected boolean existSubPosition(Context ctx, String pId) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("select fid from t_org_position where fdeletedstatus =1 and  fparentid = ? and fparentid <> fid");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{pId});
        return rowSet.size() > 0;
    }

    protected boolean existPerson(Context ctx, String pId) throws BOSException, EASBizException {
        String dateFilter = HRUtilExtend.getDateStringWithoutMininute((Date)new Date());
        StringBuffer sql = new StringBuffer();
        sql.append(" select top 1 relation.fpersonid ").append(" from t_hr_emporgrelation relation ").append(" inner join T_HR_EmpLaborRelationHis emplabor ").append(" on emplabor.fhistoryrelateid = relation.FlaborRelationID ").append(" and relation.Feffdt >= emplabor.feffdt and relation.feffdt < emplabor.fleffdt ").append(" inner join t_hr_bdemployeetype emptype on emplabor.FLaborRelationStateID = emptype.fid ");
        sql.append(" where relation.FEFFDT  <= to_date('").append(dateFilter).append("')");
        sql.append(" and relation.FLEFFDT  >= to_date('").append(dateFilter).append("')");
        sql.append(" and relation.fpositionid  = ?  ");
        sql.append(" and emptype.FIsInCount =1  ");
        sql.append(" and relation.FASSIGNTYPE =1  ");
        sql.append(" and relation.FIsLatestInAday = 1  ");
        sql.append(" and emplabor.FIsSystem =1  ");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{pId});
        return rowSet.size() > 0;
    }

    protected Boolean isPositionReferencedByEmpPosOrgRelation(Context ctx, String positionId) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("position.id", (Object)positionId));
        return EmpPosOrgRelationFactory.getLocalInstance((Context)ctx).exists(filter);
    }

    protected static void checkPositionEffdt(Context ctx, PositionInfo positionInfo) throws BOSException, EASBizException {
        if (positionInfo.getAdminOrgUnit() == null || positionInfo.getEFFDT() == null) {
            return;
        }
        if (!HistoryUtil.historyExists((Context)ctx, (BOSObjectType)new AdminOrgUnitInfo().getBOSType(), (String)positionInfo.getAdminOrgUnit().getId().toString(), (Date)positionInfo.getEFFDT())) {
            throw new OrgOperatorException(OrgOperatorException.POSITION_EFFDT_ERROR, new Object[]{positionInfo.getName(), HRUtilExtend.getDateStringWithoutMininute((Date)positionInfo.getEFFDT()), positionInfo.getAdminOrgUnit().getName()});
        }
    }

    @Override
    protected void _importUpdate(Context ctx, PositionInfo positionInfo) throws BOSException, EASBizException {
        Date effdt;
        boolean isPositionCanDuplicate = HRUtilExtend.isPositionCanDuplicate((Context)ctx);
        if (!isPositionCanDuplicate) {
            this.verifyPositionNameDuplicate(ctx, positionInfo);
        }
        ObjectUuidPK pk = new ObjectUuidPK(positionInfo.getId().toString());
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("EFFDT"));
        PositionInfo oldPositionInfo = PositionFactory.getLocalInstance((Context)ctx).getPositionInfo((IObjectPK)pk, selector);
        Date oldEffdt = oldPositionInfo.getEFFDT();
        Date date = effdt = positionInfo.getEFFDT() == null ? oldEffdt : DateTimeUtils.truncateDate((Date)positionInfo.getEFFDT());
        if (effdt.after(oldEffdt)) {
            positionInfo.setExtendedProperty("historyOperateState", "change");
        } else {
            positionInfo.setExtendedProperty("historyOperateState", "revise");
        }
        if (positionInfo.get("isrespposition") == null) {
            positionInfo.setIsRespPosition(false);
        }
        positionInfo.put("isFromImport", (Object)"true");
        this.setJobLevel(ctx, positionInfo);
        this._updatePosition(ctx, (IObjectPK)pk, positionInfo);
        this.updatePositionStandardLib(ctx, positionInfo, (IObjectPK)pk);
    }

    @Override
    protected void _updatePositionToPersonEmpPos(Context ctx, IObjectPK pk, PositionInfo positionInfo) throws BOSException, EASBizException {
    }

    protected void checkJobGradeIsAble(Context ctx, PositionInfo info) throws BOSException, EASBizException {
        if (info.getLowJobGrade() == null && info.getHighJobGrade() == null) {
            return;
        }
        if (info.getHighJobGrade() == null && info.getLowJobGrade() != null || info.getLowJobGrade() == null && info.getHighJobGrade() != null) {
            throw new JobException(JobException.JOB_JOBGRADE_NOT_ALL_NULL);
        }
        JobGradeInfo highJobGrade = JobGradeFactory.getLocalInstance(ctx).getJobGradeInfo((IObjectPK)new ObjectUuidPK(info.getHighJobGrade().getId()));
        JobGradeInfo lowJobGrade = JobGradeFactory.getLocalInstance(ctx).getJobGradeInfo((IObjectPK)new ObjectUuidPK(info.getLowJobGrade().getId()));
        if (lowJobGrade.getGrade() > highJobGrade.getGrade()) {
            throw new JobException(JobException.JOB_HIGHGRADE_SMALL_LOWGRADE);
        }
    }

    protected void setJobLevel(Context ctx, PositionInfo info) throws EASBizException, BOSException {
        JobInfo jobInfo;
        if (info.getJob() != null && (jobInfo = JobFactory.getLocalInstance((Context)ctx).getJobInfo((IObjectPK)new ObjectUuidPK(info.getJob().getId()))).getJobLevel() != null) {
            info.setJobLevel(jobInfo.getJobLevel());
        }
    }

    protected void disableOpt(Context ctx, String positionID, Date effectDate) throws BOSException, EASBizException {
        if (this.existPerson(ctx, positionID)) {
            PositionInfo posInfo = PositionFactory.getLocalInstance((Context)ctx).getPositionInfo((IObjectPK)new ObjectUuidPK(positionID));
            Object[] params = new String[]{posInfo.getName() + "(" + posInfo.getNumber() + ")"};
            throw new PositionException(PositionException.NO_INVAID_POSITION, params);
        }
        OrgVersionEnableFacadeControllerBean orgVersionEnableFacadeControllerBean = new OrgVersionEnableFacadeControllerBean();
        orgVersionEnableFacadeControllerBean._effectPersonNoPrimaryByPositionAction(ctx, positionID);
        if (this.existSubPosition(ctx, positionID)) {
            throw new HRPositionException(HRPositionException.EXIST_SUB_POSITION);
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("parent.id"));
        sic.add(new SelectorItemInfo("EFFDT"));
        sic.add(new SelectorItemInfo("deletedStatus"));
        sic.add(new SelectorItemInfo("valiDate"));
        IPosition iPosition = PositionFactory.getLocalInstance((Context)ctx);
        PositionInfo info = iPosition.getPositionInfo((IObjectPK)new ObjectUuidPK(positionID));
        info.setDeletedStatus(DeletedStatusEnum.DELETED);
        info.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        info.setCreateTime(new Timestamp(System.currentTimeMillis()));
        if (effectDate != null) {
            info.setEFFDT(effectDate);
        } else {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("*"));
            PositionInfo positionInfo = PositionFactory.getLocalInstance((Context)ctx).getPositionInfo((IObjectPK)new ObjectUuidPK(positionID), selector);
            if (DateTimeUtils.truncateDate((Date)OrgUtils.getSealUpDate(ctx)).after(positionInfo.getEFFDT())) {
                info.setEFFDT(DateTimeUtils.truncateDate((Date)OrgUtils.getSealUpDate(ctx)));
            }
        }
        info.setValiDate(new Date());
        StringBuffer billCheckResult = new StringBuffer();
        billCheckResult = this.existPersonBill(ctx, positionID, info.getEFFDT());
        if (billCheckResult.length() > 0) {
            NumericExceptionSubItem error = new NumericExceptionSubItem("101", billCheckResult.toString());
            throw new EASBizException(error);
        }
        info.put("IS_FROM_SHR_OPT_CURD", (Object)"true");
        iPosition.update((IObjectPK)new ObjectUuidPK(positionID), (CoreBaseInfo)info);
        if (info.isIsRespPosition()) {
            DbUtil.execute((Context)ctx, (String)"UPDATE T_ORG_ADMIN SET FRESPONPOSITIONID = null WHERE FRESPONPOSITIONID = ?", (Object[])new Object[]{positionID});
            DbUtil.execute((Context)ctx, (String)"UPDATE T_ORG_ADMINHIS SET FRESPONPOSITIONID = null WHERE FRESPONPOSITIONID = ?", (Object[])new Object[]{positionID});
            DbUtil.execute((Context)ctx, (String)"UPDATE T_ORG_OUPartAdmin SET FRESPONPOSITIONID = null WHERE FRESPONPOSITIONID = ?", (Object[])new Object[]{positionID});
        }
        this.updatePositionHistoryLog(ctx, info, PositionActionEnum.DISABLE);
    }

    @Override
    protected void _disablePosition(Context ctx, String positionID, Date effectDate) throws BOSException, EASBizException {
        this.disableOpt(ctx, positionID, effectDate);
    }

    protected StringBuffer existPersonBill(Context ctx, String positionId, Date checkDate) throws BOSException, EASBizException {
        StringBuffer billCheckResult = new StringBuffer();
        StringBuffer resultBuffer = new StringBuffer();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String effectDate = dateFormat.format(checkDate);
        IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)OrgAdjustUtil.getPersonBillSqlByPosition(ctx, "T_HR_EmpEnrollBizBill", effectDate, positionId, null));
        if (executeQuery.size() > 0) {
            resultBuffer.append("\u3001" + EASResource.getString((String)"com.kingdee.eas.hr.org.HrOrgBizResource", (String)"label10", (Locale)ctx.getLocale()));
        }
        if ((executeQuery = DbUtil.executeQuery((Context)ctx, (String)OrgAdjustUtil.getPersonBillSqlByPosition(ctx, "T_HR_EmpHireBizBill", effectDate, positionId, null))).size() > 0) {
            resultBuffer.append("\u3001" + EASResource.getString((String)"com.kingdee.eas.hr.org.HrOrgBizResource", (String)"label11", (Locale)ctx.getLocale()));
        }
        if ((executeQuery = DbUtil.executeQuery((Context)ctx, (String)OrgAdjustUtil.getPersonBillSqlByPosition(ctx, "T_HR_FluctuationBizBill", effectDate, positionId, null))).size() > 0) {
            resultBuffer.append("\u3001" + EASResource.getString((String)"com.kingdee.eas.hr.org.HrOrgBizResource", (String)"label12", (Locale)ctx.getLocale()));
        }
        if ((executeQuery = DbUtil.executeQuery((Context)ctx, (String)OrgAdjustUtil.getPersonBillSqlByPosition(ctx, "T_HR_ResignBizBill", effectDate, positionId, null))).size() > 0) {
            resultBuffer.append("\u3001" + EASResource.getString((String)"com.kingdee.eas.hr.org.HrOrgBizResource", (String)"label13", (Locale)ctx.getLocale()));
        }
        if ((executeQuery = DbUtil.executeQuery((Context)ctx, (String)OrgAdjustUtil.getPersonBillSqlByPosition(ctx, "T_HR_RetireBizBill", effectDate, positionId, null))).size() > 0) {
            resultBuffer.append("\u3001" + EASResource.getString((String)"com.kingdee.eas.hr.org.HrOrgBizResource", (String)"label14", (Locale)ctx.getLocale()));
        }
        if ((executeQuery = DbUtil.executeQuery((Context)ctx, (String)OrgAdjustUtil.getPersonBillSqlByPosition(ctx, "T_HR_ReinviteBizBill", effectDate, positionId, null))).size() > 0) {
            resultBuffer.append("\u3001" + EASResource.getString((String)"com.kingdee.eas.hr.org.HrOrgBizResource", (String)"label15", (Locale)ctx.getLocale()));
        }
        if ((executeQuery = DbUtil.executeQuery((Context)ctx, (String)OrgAdjustUtil.getPersonBillSqlByPosition(ctx, "T_HR_reinviteFireBizBill", effectDate, positionId, null))).size() > 0) {
            resultBuffer.append("\u3001" + EASResource.getString((String)"com.kingdee.eas.hr.org.HrOrgBizResource", (String)"label16", (Locale)ctx.getLocale()));
        }
        if ((executeQuery = DbUtil.executeQuery((Context)ctx, (String)OrgAdjustUtil.getPersonBillSqlByPosition(ctx, "T_HR_PluralityAddBizBill", effectDate, positionId, null))).size() > 0) {
            resultBuffer.append("\u3001" + EASResource.getString((String)"com.kingdee.eas.hr.org.HrOrgBizResource", (String)"label17", (Locale)ctx.getLocale()));
        }
        if ((executeQuery = DbUtil.executeQuery((Context)ctx, (String)OrgAdjustUtil.getPersonBillSqlByPosition(ctx, "T_HR_PluralityDelBizBill", effectDate, positionId, null))).size() > 0) {
            resultBuffer.append("\u3001" + EASResource.getString((String)"com.kingdee.eas.hr.org.HrOrgBizResource", (String)"label18", (Locale)ctx.getLocale()));
        }
        if ((executeQuery = DbUtil.executeQuery((Context)ctx, (String)OrgAdjustUtil.getPersonBillSqlByPosition(ctx, "T_HR_LoanBizBill", effectDate, positionId, null))).size() > 0) {
            resultBuffer.append("\u3001" + EASResource.getString((String)"com.kingdee.eas.hr.org.HrOrgBizResource", (String)"label19", (Locale)ctx.getLocale()));
        }
        if ((executeQuery = DbUtil.executeQuery((Context)ctx, (String)OrgAdjustUtil.getPersonBillSqlByPosition(ctx, "T_HR_LoanOutBizBill", effectDate, positionId, null))).size() > 0) {
            resultBuffer.append("\u3001" + EASResource.getString((String)"com.kingdee.eas.hr.org.HrOrgBizResource", (String)"label20", (Locale)ctx.getLocale()));
        }
        if ((executeQuery = DbUtil.executeQuery((Context)ctx, (String)OrgAdjustUtil.getPersonBillSqlByPosition(ctx, "T_HR_LoanInBizBill", effectDate, positionId, null))).size() > 0) {
            resultBuffer.append("\u3001" + EASResource.getString((String)"com.kingdee.eas.hr.org.HrOrgBizResource", (String)"label21", (Locale)ctx.getLocale()));
        }
        if ((executeQuery = DbUtil.executeQuery((Context)ctx, (String)OrgAdjustUtil.getPersonBillSqlByPosition(ctx, "T_HR_FlucInBizBill", effectDate, positionId, null))).size() > 0) {
            resultBuffer.append("\u3001" + EASResource.getString((String)"com.kingdee.eas.hr.org.HrOrgBizResource", (String)"label22", (Locale)ctx.getLocale()));
        }
        if ((executeQuery = DbUtil.executeQuery((Context)ctx, (String)OrgAdjustUtil.getPersonBillSqlByPosition(ctx, "T_HR_FlucOutBizBill", effectDate, positionId, null))).size() > 0) {
            resultBuffer.append("\u3001" + EASResource.getString((String)"com.kingdee.eas.hr.org.HrOrgBizResource", (String)"label23", (Locale)ctx.getLocale()));
        }
        if (resultBuffer.length() > 0) {
            billCheckResult.append(EASResource.getString((String)"com.kingdee.eas.hr.org.HrOrgBizResource", (String)"label24", (Locale)ctx.getLocale()) + "\uff1a").append(resultBuffer.substring(1)).append("\uff09");
        }
        return billCheckResult;
    }

    @Override
    protected void _showInOrgChart(Context ctx, String positionId) throws BOSException, EASBizException {
        PositionExtendInfo extendInfo = this.getPositionExtendInfoByPosId(ctx, positionId);
        if (extendInfo.isIsShowInOrgChart()) {
            throw new HRPositionException(HRPositionException.EXIST_ISSHOWINORGCHART);
        }
        extendInfo.setIsShowInOrgChart(true);
        PositionExtendFactory.getLocalInstance(ctx).save((CoreBaseInfo)extendInfo);
    }

    @Override
    protected void _notShowInOrgChart(Context ctx, String positionId) throws BOSException, EASBizException {
        PositionExtendInfo extendInfo = this.getPositionExtendInfoByPosId(ctx, positionId);
        if (!extendInfo.isIsShowInOrgChart()) {
            throw new HRPositionException(HRPositionException.EXIST_NOTSHOWINORGCHART);
        }
        extendInfo.setIsShowInOrgChart(false);
        PositionExtendFactory.getLocalInstance(ctx).save((CoreBaseInfo)extendInfo);
    }

    protected PositionExtendInfo getPositionExtendInfoByPosId(Context ctx, String positionId) throws BOSException, EASBizException {
        PositionExtendInfo result = null;
        String sql = "select * where position ='" + positionId + "'";
        PositionExtendCollection extendCollection = PositionExtendFactory.getLocalInstance(ctx).getPositionExtendCollection(sql);
        if (extendCollection.size() > 0) {
            result = extendCollection.get(0);
        } else {
            result = new PositionExtendInfo();
            PositionInfo positionInfo = new PositionInfo();
            positionInfo.setId(BOSUuid.read((String)positionId));
            result.setPosition(positionInfo);
        }
        return result;
    }

    @Override
    protected void _updateRootPosition(Context ctx, IObjectPK pk, Map param) throws BOSException, EASBizException {
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)"SELECT FID FROM T_ORG_Position WHERE FPARENTID = FID");
        try {
            if (rows.next()) {
                String oldRootId = rows.getString("FID");
                if (oldRootId.equals(pk.toString())) {
                    return;
                }
                IPosition iPosition = PositionFactory.getLocalInstance((Context)ctx);
                PositionInfo newRoot = iPosition.getPositionInfo(pk);
                EntityViewInfo entityViewInfo = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("parent", (Object)oldRootId, CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)pk.toString(), CompareType.NOTEQUALS));
                filter.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)1, CompareType.EQUALS));
                entityViewInfo.setFilter(filter);
                PositionCollection subPositionCollection = iPosition.getPositionCollection(entityViewInfo);
                IPositionHierarchy iPositionHierarchy = PositionHierarchyFactory.getLocalInstance((Context)ctx);
                PositionHierarchyInfo newRootHierarchy = iPositionHierarchy.getPositionHierarchyInfo("where child = '" + pk.toString() + "' and hierarchy = '" + "00000000-0000-0000-0000-000000000001396FCAD0" + "'");
                Object[] objs = new Object[]{pk.toString(), pk.toString()};
                DbUtil.execute((Context)ctx, (String)"update T_ORG_Position set FPARENTID = ? where FID = ?", (Object[])objs);
                String sql = "UPDATE T_ORG_PositionHierarchy SET FLongNumber = ? , FLevel = 0, FParentID = ?  WHERE  FChildID = ? and FHierarchyID = '00000000-0000-0000-0000-000000000001396FCAD0'";
                objs = new Object[]{newRoot.getNumber(), pk.toString(), pk.toString()};
                DbUtil.execute((Context)ctx, (String)sql, (Object[])objs);
                PositionHierarchyCollection hierarchyColl = iPositionHierarchy.getPositionHierarchyCollection("where longNumber like '" + newRootHierarchy.getLongNumber() + "!%'");
                PositionHierarchyInfo positionHierarchy = null;
                ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
                int size = hierarchyColl.size();
                for (int i = 0; i < size; ++i) {
                    positionHierarchy = hierarchyColl.get(i);
                    String longNumber = StringUtils.replace((String)positionHierarchy.getLongNumber(), (String)newRootHierarchy.getLongNumber(), (String)newRoot.getNumber());
                    int level = positionHierarchy.getLevel() - newRootHierarchy.getLevel();
                    objs = new Object[]{longNumber, level, positionHierarchy.getId().toString()};
                    paramsList.add(objs);
                }
                if (paramsList.size() > 0) {
                    sql = "UPDATE T_ORG_PositionHierarchy SET FLongNumber = ? , FLevel = ? WHERE  FID = ?";
                    DbUtil.executeBatch((Context)ctx, (String)sql, paramsList);
                }
                PositionInfo positionInfo = null;
                int size2 = subPositionCollection.size();
                for (int i = 0; i < size2; ++i) {
                    positionInfo = subPositionCollection.get(i);
                    positionInfo.setParent(newRoot);
                    positionInfo.put("IS_FROM_SHR_OPT_CURD", (Object)"IS_FROM_SHR_OPT_CURD");
                    iPosition.update((IObjectPK)new ObjectUuidPK(positionInfo.getId().toString()), (CoreBaseInfo)positionInfo);
                }
                newRoot.setParent(newRoot);
                newRoot.put("IS_FROM_SHR_OPT_CURD", (Object)"IS_FROM_SHR_OPT_CURD");
                iPosition.update(pk, (CoreBaseInfo)newRoot);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    protected void checkPositionStandardRelation(Context ctx, PositionInfo position) throws EASBizException, BOSException {
        String isSync = ParamManager.getParamValue((Context)ctx, null, (String)"IS_USE_SHR_PositionEdit");
        PositionStandardLibInfo posStdInfo = (PositionStandardLibInfo)position.get("positionStandardLib");
        if (posStdInfo != null && "false".equals(isSync)) {
            PositionStandardLibInfo standardLibInfo = PositionStandardLibFactory.getLocalInstance(ctx).getPositionStandardLibInfo((IObjectPK)new ObjectUuidPK(posStdInfo.getId()));
            if (!StringUtils.equals((String)position.getName(), (String)standardLibInfo.getName())) {
                throw new BOSException(EASResource.getString((String)"com.kingdee.eas.hr.org.OrganisationBizResource", (String)"label400", (Locale)ctx.getLocale()));
            }
        }
    }

    private Boolean getIsRealTimeSync(Context ctx) {
        boolean isRealTimeSync = false;
        try {
            String isRealTimeSyncString = ParamManager.getParamValue((Context)ctx, null, (String)"SHR_EMPLOYEE_CHANGES_REAL_TIME_SYNC");
            if ("true".equals(isRealTimeSyncString)) {
                isRealTimeSync = true;
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            e.printStackTrace();
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return isRealTimeSync;
    }
}

