/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.org.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.util.StringCollUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.util.HRUtilExtend;
import com.kingdee.eas.hr.org.AbstractPositionVerInfo;
import com.kingdee.eas.hr.org.AdminOrgUnitVerCollection;
import com.kingdee.eas.hr.org.AdminOrgUnitVerFactory;
import com.kingdee.eas.hr.org.AdminOrgUnitVerInfo;
import com.kingdee.eas.hr.org.EnableStateEnum;
import com.kingdee.eas.hr.org.HROrgAdjSchmFactory;
import com.kingdee.eas.hr.org.HROrgAdjSchmInfo;
import com.kingdee.eas.hr.org.HrOrgBizException;
import com.kingdee.eas.hr.org.IPositionVer;
import com.kingdee.eas.hr.org.IPositionVerAdjRec;
import com.kingdee.eas.hr.org.OrgAdjSchmVerException;
import com.kingdee.eas.hr.org.OrgOperatorException;
import com.kingdee.eas.hr.org.OrgPosVerAdjRecFactory;
import com.kingdee.eas.hr.org.OrgVerAdjEnum;
import com.kingdee.eas.hr.org.OrgVerAdjRecFactory;
import com.kingdee.eas.hr.org.PersonVerCollection;
import com.kingdee.eas.hr.org.PersonVerFactory;
import com.kingdee.eas.hr.org.PersonVerInfo;
import com.kingdee.eas.hr.org.PositionVerAdjRecCollection;
import com.kingdee.eas.hr.org.PositionVerAdjRecFactory;
import com.kingdee.eas.hr.org.PositionVerAdjRecInfo;
import com.kingdee.eas.hr.org.PositionVerCollection;
import com.kingdee.eas.hr.org.PositionVerFactory;
import com.kingdee.eas.hr.org.PositionVerInfo;
import com.kingdee.eas.hr.org.app.AbstractPositionVerControllerBean;
import com.kingdee.eas.hr.org.app.AdminOrgUnitVerControllerBean;
import com.kingdee.eas.hr.org.app.PersonVerControllerBean;
import com.kingdee.eas.hr.org.app.PositionVerAdjRecControllerBean;
import com.kingdee.eas.hr.org.util.OrgAdjustUtil;
import com.kingdee.eas.hr.org.util.OrgVerAdjUtil;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.web.json.JSONUtils;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class PositionVerControllerBean
extends AbstractPositionVerControllerBean {
    private static final long serialVersionUID = 7767578340415055345L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.org.app.PositionVerControllerBean");

    public IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PositionVerInfo info = (PositionVerInfo)model;
        this._checkNumberDup(ctx, model);
        String checkName = info.getName();
        if (checkName.contains("copy")) {
            info.setName(checkName.substring(5));
            if (info.getAdminOrgUnit().getResponPosition() != null) {
                info.setIsRespPosition(false);
            }
        }
        PositionInfo position = new PositionInfo();
        position.setId(BOSUuid.create((BOSObjectType)position.getBOSType()));
        info.setPosition(position);
        String orgAdjSchm = info.getOrgAdjSchm().getId().toString();
        AdminOrgUnitVerInfo adminVerInfo = AdminOrgUnitVerFactory.getLocalInstance(ctx).getAdminOrgUnitVerInfo("select * where id ='" + info.getAdminOrgUnit().getId() + "'");
        boolean isExistRes = PositionVerFactory.getLocalInstance(ctx).exists("select id where adminOrgUnit ='" + info.getAdminOrgUnit().getId() + "' AND orgAdjSchm = '" + orgAdjSchm + "' AND isRespPosition = 1");
        if (!isExistRes) {
            info.setIsRespPosition(true);
        } else {
            info.setIsRespPosition(false);
        }
        boolean primaryPosition = info.isIsRespPosition();
        if (primaryPosition && !checkName.contains("copy")) {
            info.setIndex(-1);
        } else {
            info.setIndex(this._getMaxIndex(ctx, info.getAdminOrgUnit().getId().toString(), orgAdjSchm) + 1);
        }
        if (info.getCU() == null) {
            HROrgAdjSchmInfo orgAdjSchem = HROrgAdjSchmFactory.getLocalInstance(ctx).getHROrgAdjSchmInfo((IObjectPK)new ObjectUuidPK(orgAdjSchm));
            info.setCU(orgAdjSchem.getCU());
        }
        IObjectPK pk = super._addnew(ctx, (IObjectValue)info);
        info.setId(BOSUuid.read((String)pk.toString()));
        if (!isExistRes) {
            if (AdminOrgUnitFactory.getLocalInstance((Context)ctx).exists(" where id = '" + adminVerInfo.getAdminOrgUnit().getId().toString() + "'")) {
                adminVerInfo.setResponPosition(info);
                AdminOrgUnitVerControllerBean adminOrgUnitVerControllerBean = new AdminOrgUnitVerControllerBean();
                adminOrgUnitVerControllerBean._update(ctx, (IObjectPK)new ObjectUuidPK(adminVerInfo.getId().toString()), (IObjectValue)adminVerInfo);
            } else {
                DbUtil.execute((Context)ctx, (String)("UPDATE T_HR_AdminOrgUnitVer SET FResponPositionID = '" + pk.toString() + "' WHERE FID = '" + adminVerInfo.getId().toString() + "'"));
            }
        }
        if (!primaryPosition || !checkName.contains("copy")) {
            // empty if block
        }
        if (!checkName.contains("copy")) {
            PositionVerAdjRecFactory.getLocalInstance(ctx).adjRecForAddPosition(info);
        }
        String Res_Position = EASCommonResource.getString((String)"com.kingdee.eas.hr.org.HROrgAdjSchmVerResource.Position", (Locale)ctx.getLocale());
        String Res_AddNew = EASCommonResource.getString((String)"com.kingdee.eas.hr.org.HROrgAdjSchmVerResource.AddNew", (Locale)ctx.getLocale());
        if (checkName.contains("copy")) {
            OrgPosVerAdjRecFactory.getLocalInstance(ctx).writeOptPosRecorder(info, Res_Position + Res_AddNew, OrgVerAdjEnum.POSITION_COPY_ADDNEW);
        } else {
            OrgPosVerAdjRecFactory.getLocalInstance(ctx).writeOptPosRecorder(info, Res_Position + Res_AddNew, OrgVerAdjEnum.POSITION_ADDNEW);
        }
        OrgVerAdjUtil.updateOrgAdjSchm(ctx, orgAdjSchm);
        return pk;
    }

    public void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this._checkNumberDup(ctx, model);
        PositionVerInfo positionVerInfo = (PositionVerInfo)model;
        String posId = pk.toString();
        String orgAdjSchm = positionVerInfo.getOrgAdjSchm().getId().toString();
        String orgAdminId = positionVerInfo.getAdminOrgUnit().getId().toString();
        AdminOrgUnitVerInfo positionOfOrg = AdminOrgUnitVerFactory.getLocalInstance(ctx).getAdminOrgUnitVerInfo("select responPosition where id ='" + orgAdminId + "'");
        if (positionOfOrg.getResponPosition() == null || positionVerInfo.isIsRespPosition() && !posId.equals(positionOfOrg.getResponPosition().getId().toString())) {
            this.updateResponPositionInfo(ctx, positionOfOrg, orgAdjSchm, orgAdminId, posId);
            positionVerInfo.setIsRespPosition(true);
            positionVerInfo.setIndex(-1);
        }
        PositionVerAdjRecFactory.getLocalInstance(ctx).adjRecForEditPosition(positionVerInfo);
        OrgPosVerAdjRecFactory.getLocalInstance(ctx).writeEditPosOptRecorder(positionVerInfo);
        super._update(ctx, pk, model);
        OrgVerAdjUtil.updateOrgAdjSchm(ctx, orgAdjSchm);
    }

    private void updateResponPositionInfo(Context ctx, AdminOrgUnitVerInfo positionOfOrg, String orgAdjSchm, String orgAdminId, String posId) throws BOSException, EASBizException {
        Serializable info;
        String sql = null;
        if (positionOfOrg.getResponPosition() != null) {
            sql = "UPDATE T_HR_PositionVer SET FIsRespPosition=0,FIndex=0 WHERE FID=? and fOrgAdjSchm=? ";
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{positionOfOrg.getResponPosition().getId().toString(), orgAdjSchm});
            info = new PositionVerInfo();
            PositionVerCollection positionVerColl = PositionVerFactory.getLocalInstance(ctx).getPositionVerCollection("select * where id = '" + positionOfOrg.getResponPosition().getId().toString() + "'");
            info = positionVerColl.get(0);
            ((AbstractPositionVerInfo)info).setIsRespPosition(false);
            PositionVerAdjRecFactory.getLocalInstance(ctx).adjRecForEditPosition((PositionVerInfo)info);
        }
        sql = "UPDATE T_HR_AdminOrgUnitVer SET FResponPositionID = ? where FID=? and fOrgAdjSchm=?";
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{posId, orgAdminId, orgAdjSchm});
        info = new AdminOrgUnitVerInfo();
        AdminOrgUnitVerCollection adminVerColl = AdminOrgUnitVerFactory.getLocalInstance(ctx).getAdminOrgUnitVerCollection("select * where id = '" + orgAdminId + "'");
        info = adminVerColl.get(0);
        OrgVerAdjRecFactory.getLocalInstance(ctx).adjRecForEditOrg((AdminOrgUnitVerInfo)info);
    }

    @Override
    protected void _move(Context ctx, Map movParam) throws BOSException, EASBizException {
        String positionId = (String)movParam.get("positionVerId");
        String schemeId = (String)movParam.get("schemeId");
        String targetOrgId = (String)movParam.get("targetOrgId");
        PositionVerInfo positionVerInfo = this.getPositionVerInfo(ctx, positionId, schemeId);
        if (positionVerInfo.getParentPosition() == null) {
            throw new HrOrgBizException(HrOrgBizException.EXCEPTION20);
        }
        String beforeParentId = "";
        String beforeAdminOrgId = "";
        if (positionVerInfo.getParentPosition() != null) {
            beforeParentId = positionVerInfo.getParentPosition().getId().toString();
        }
        if (positionVerInfo.getAdminOrgUnit() != null) {
            beforeAdminOrgId = positionVerInfo.getAdminOrgUnit().getId().toString();
        }
        String beforeMoveId = positionVerInfo.getId().toString();
        PositionVerInfo newPositionVerInfo = positionVerInfo;
        SelectorItemCollection adminSic = new SelectorItemCollection();
        adminSic.add(new SelectorItemInfo("responPosition"));
        adminSic.add(new SelectorItemInfo("id"));
        adminSic.add(new SelectorItemInfo("name"));
        adminSic.add(new SelectorItemInfo("number"));
        adminSic.add(new SelectorItemInfo("adminOrgUnit.id"));
        adminSic.add(new SelectorItemInfo("adminOrgUnit.number"));
        adminSic.add(new SelectorItemInfo("adminOrgUnit.name"));
        adminSic.add(new SelectorItemInfo("parent.responPosition"));
        adminSic.add(new SelectorItemInfo("CU.id"));
        AdminOrgUnitVerInfo tagerAdmin = AdminOrgUnitVerFactory.getLocalInstance(ctx).getAdminOrgUnitVerInfo((IObjectPK)new ObjectUuidPK(targetOrgId), adminSic);
        String backPositionVerId = "";
        String systemAdminId = "";
        try {
            String checkSql = "SELECT FBackPositionVerId,FADMINORGID FROM T_HR_PositionVerAdjRec WHERE FpositionVer = '" + positionId + "' AND FadjType = 17";
            IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)checkSql);
            while (executeQuery.next()) {
                backPositionVerId = executeQuery.getString("FBackPositionVerId");
                systemAdminId = executeQuery.getString("FADMINORGID");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (!backPositionVerId.equals("") && systemAdminId.equals(tagerAdmin.getAdminOrgUnit().getId().toString())) {
            PositionVerInfo oldPositionVerInfo = this.getPositionVerInfo(ctx, backPositionVerId, schemeId);
            this._unSealUp(ctx, oldPositionVerInfo);
            ObjectUuidPK oldPositionVerPK = new ObjectUuidPK(oldPositionVerInfo.getId());
            PersonVerControllerBean personVerControllerBean = new PersonVerControllerBean();
            String getPersonSql = "select * where primaryPosition.id = '" + positionId + "'";
            PersonVerCollection personVerColl = PersonVerFactory.getLocalInstance(ctx).getPersonVerCollection(getPersonSql);
            for (int i = 0; i < personVerColl.size(); ++i) {
                PersonVerInfo personVerInfo = personVerColl.get(i);
                personVerControllerBean._moveByPosition(ctx, schemeId, personVerInfo.getId().toString(), oldPositionVerInfo.getId().toString(), true);
            }
            personVerControllerBean._movePersonNoPrimary(ctx, schemeId, oldPositionVerInfo, positionId, oldPositionVerInfo.getAdminOrgUnit().getId().toString(), true);
            String getChildsql = "select * where parentPosition.id= '" + positionId + "'";
            PositionVerCollection positionVerColl = PositionVerFactory.getLocalInstance(ctx).getPositionVerCollection(getChildsql);
            for (int i = 0; i < positionVerColl.size(); ++i) {
                PositionVerInfo childPositionVerInfo = positionVerColl.get(i);
                childPositionVerInfo.setParentPosition(oldPositionVerInfo);
                this._update(ctx, (IObjectPK)new ObjectUuidPK(childPositionVerInfo.getId().toString()), (IObjectValue)childPositionVerInfo);
            }
            String deletePositionVerSql = "DELETE FROM T_HR_PositionVer WHERE FID = '" + positionId + "'";
            String deletePositionAdjSql = "DELETE FROM T_HR_PositionVerAdjRec WHERE fPositionVer = '" + positionId + "' AND fOrgAdjSchm = '" + schemeId + "'";
            DbUtil.execute((Context)ctx, (String)deletePositionVerSql);
            DbUtil.execute((Context)ctx, (String)deletePositionAdjSql);
        } else {
            AdminOrgUnitVerCollection afterAdminOrgUnitVerColl;
            if (tagerAdmin.getResponPosition() == null) {
                // empty if block
            }
            newPositionVerInfo.setDeletedStatus(positionVerInfo.getDeletedStatus());
            this._sealUp(ctx, positionVerInfo);
            String autoNumber = PositionVerControllerBean.getAutoPositionNumberAction(ctx, tagerAdmin, tagerAdmin.getAdminOrgUnit());
            if (StringUtils.isEmpty((String)autoNumber)) {
                autoNumber = "copy_" + positionVerInfo.getNumber();
            }
            BOSUuid newId = BOSUuid.create((String)"FBF1F8E4");
            newPositionVerInfo.setId(newId);
            newPositionVerInfo.setNumber(autoNumber);
            newPositionVerInfo.setName("copy_" + positionVerInfo.getName());
            newPositionVerInfo.setAdminOrgUnit(tagerAdmin);
            newPositionVerInfo.setHrJob(positionVerInfo.getHrJob());
            newPositionVerInfo.setLowJobLevel(positionVerInfo.getLowJobLevel());
            newPositionVerInfo.setHighJobLevel(positionVerInfo.getHighJobLevel());
            newPositionVerInfo.setHighJobGrade(positionVerInfo.getHighJobGrade());
            newPositionVerInfo.setLowJobGrade(positionVerInfo.getLowJobGrade());
            newPositionVerInfo.setPositionStandardLib(positionVerInfo.getPositionStandardLib());
            newPositionVerInfo.setDomain(positionVerInfo.getDomain());
            newPositionVerInfo.setProductLine(positionVerInfo.getProductLine());
            IPositionVerAdjRec iPositionVerAdjRec = PositionVerAdjRecFactory.getLocalInstance(ctx);
            if (tagerAdmin.getResponPosition() != null) {
                newPositionVerInfo.setParentPosition(tagerAdmin.getResponPosition());
            } else if (tagerAdmin.getParent() != null && tagerAdmin.getParent().getResponPosition() != null) {
                if (tagerAdmin.getParent().getResponPosition() != null && !tagerAdmin.getParent().getResponPosition().getId().toString().equals(beforeMoveId)) {
                    String targetResp = tagerAdmin.getParent().getResponPosition().getId().toString();
                    if (iPositionVerAdjRec.exists("where adjtype = 18 and positionver = '" + targetResp + "'")) {
                        PositionVerAdjRecCollection positionVerAdjRecColl = iPositionVerAdjRec.getPositionVerAdjRecCollection("where adjtype = 17 and backPositionVerId = '" + targetResp + "' ");
                        newPositionVerInfo.setParentPosition(positionVerAdjRecColl.get(0).getPositionVer());
                    } else {
                        newPositionVerInfo.setParentPosition(tagerAdmin.getParent().getResponPosition());
                    }
                }
            } else {
                try {
                    if (newPositionVerInfo.getParentPosition() != null) {
                        String parentVerID = newPositionVerInfo.getParentPosition().getId().toString();
                        String sql = "SELECT FID FROM T_HR_PositionVerAdjRec WHERE FAdjType = 18 AND FPositionVer = '" + parentVerID + "' AND FOrgAdjSchm = '" + schemeId + "'";
                        IRowSet exe = DbUtil.executeQuery((Context)ctx, (String)sql);
                        if (exe.size() > 0 && (exe = DbUtil.executeQuery((Context)ctx, (String)(sql = "SELECT FPositionVer FROM T_HR_PositionVerAdjRec WHERE FAdjType = 17 AND FBackPositionVerId = '" + parentVerID + "' AND FOrgAdjSchm = '" + schemeId + "'"))).size() > 0) {
                            while (exe.next()) {
                                String newParentVerID = exe.getString("FPositionVer");
                                PositionVerCollection positionVerColl = PositionVerFactory.getLocalInstance(ctx).getPositionVerCollection("select * where id = '" + newParentVerID + "'");
                                for (int i = 0; i < positionVerColl.size(); ++i) {
                                    PositionVerInfo info = positionVerColl.get(i);
                                    newPositionVerInfo.setParentPosition(info);
                                }
                            }
                        }
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    throw new EASBizException(new NumericExceptionSubItem("03", e.getMessage()));
                }
            }
            IObjectPK pk = this._addnew(ctx, (IObjectValue)newPositionVerInfo);
            PositionVerAdjRecInfo adjRecInfo = new PositionVerAdjRecInfo();
            adjRecInfo.setPositionVer(newPositionVerInfo);
            adjRecInfo.setOrgAdjSchm(newPositionVerInfo.getOrgAdjSchm());
            adjRecInfo.setEnableStatus(EnableStateEnum.UNABLE);
            adjRecInfo.setAdjType(OrgVerAdjEnum.POSITION_COPY_ADDNEW);
            String afterParentId = "";
            String afterAdminOrgId = "";
            if (newPositionVerInfo.getParentPosition() != null) {
                afterParentId = newPositionVerInfo.getParentPosition().getId().toString();
            }
            if (newPositionVerInfo.getAdminOrgUnit() != null) {
                afterAdminOrgId = newPositionVerInfo.getAdminOrgUnit().getId().toString();
            }
            if (!beforeParentId.equals("")) {
                PositionVerCollection beforePositionVerColl = PositionVerFactory.getLocalInstance(ctx).getPositionVerCollection("SELECT * WHERE id = '" + beforeParentId + "'");
                if (beforePositionVerColl.size() > 0) {
                    adjRecInfo.setBeforeAdjParent(beforePositionVerColl.get(0).getPosition().getId().toString());
                }
            } else {
                adjRecInfo.setBeforeAdjParent(null);
            }
            if (!afterParentId.equals("")) {
                PositionVerCollection afterPositionVerColl = PositionVerFactory.getLocalInstance(ctx).getPositionVerCollection("SELECT * WHERE id = '" + afterParentId + "'");
                if (afterPositionVerColl.size() > 0) {
                    adjRecInfo.setAfterAdjParent(afterPositionVerColl.get(0).getPosition().getId().toString());
                }
            } else {
                adjRecInfo.setAfterAdjParent(null);
            }
            AdminOrgUnitVerCollection beforeAdminOrgUnitVerColl = AdminOrgUnitVerFactory.getLocalInstance(ctx).getAdminOrgUnitVerCollection("SELECT * WHERE id = '" + beforeAdminOrgId + "'");
            if (beforeAdminOrgUnitVerColl.size() > 0) {
                adjRecInfo.setAdminOrgID(beforeAdminOrgUnitVerColl.get(0).getAdminOrgUnit().getId().toString());
            }
            if ((afterAdminOrgUnitVerColl = AdminOrgUnitVerFactory.getLocalInstance(ctx).getAdminOrgUnitVerCollection("SELECT * WHERE id = '" + afterAdminOrgId + "'")).size() > 0) {
                adjRecInfo.setAfterAdjOrgID(afterAdminOrgUnitVerColl.get(0).getAdminOrgUnit().getId().toString());
            }
            adjRecInfo.setBackPositionVerId(positionId);
            iPositionVerAdjRec.save((CoreBaseInfo)adjRecInfo);
            String getChildsql = "select * where parentPosition.id= '" + positionId + "' AND deletedStatus <> 2 AND adminOrgUnit IS NOT NULL";
            PositionVerCollection positionVerColl = PositionVerFactory.getLocalInstance(ctx).getPositionVerCollection(getChildsql);
            for (int i = 0; i < positionVerColl.size(); ++i) {
                PositionVerInfo childPositionVerInfo = positionVerColl.get(i);
                childPositionVerInfo.setParentPosition(newPositionVerInfo);
                this._update(ctx, (IObjectPK)new ObjectUuidPK(childPositionVerInfo.getId().toString()), (IObjectValue)childPositionVerInfo);
            }
            PersonVerControllerBean personVerControllerBean = new PersonVerControllerBean();
            String getPersonSql = "select * where primaryPosition.id = '" + positionId + "' and orgAdjSchm = '" + schemeId + "'";
            PersonVerCollection personVerColl = PersonVerFactory.getLocalInstance(ctx).getPersonVerCollection(getPersonSql);
            for (int i = 0; i < personVerColl.size(); ++i) {
                PersonVerInfo personVerInfo = personVerColl.get(i);
                personVerControllerBean._moveByPosition(ctx, schemeId, personVerInfo.getId().toString(), newId.toString(), true);
            }
            personVerControllerBean._movePersonNoPrimary(ctx, schemeId, newPositionVerInfo, positionId, targetOrgId, true);
        }
        String sql = " update T_HR_PositionVer set FAdminOrgUnitID=? where fid=?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{tagerAdmin.getId().toString(), newPositionVerInfo.getId().toString()});
        OrgVerAdjUtil.updateOrgAdjSchm(ctx, positionVerInfo.getOrgAdjSchm().getId().toString());
    }

    private static String getAutoPositionNumberAction(Context ctx, AdminOrgUnitVerInfo adminVer, AdminOrgUnitInfo adminOrgUnitInfo) throws BOSException, EASBizException {
        String number = "";
        if (adminOrgUnitInfo != null && adminOrgUnitInfo.getId() != null) {
            PositionInfo positionInfo = new PositionInfo();
            AdminOrgUnitInfo adminOrgUnit = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(adminOrgUnitInfo.getId().toString()));
            if (adminOrgUnit != null) {
                positionInfo.setAdminOrgUnit(adminOrgUnit);
                ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
                String mainOrgID = adminOrgUnit.getCU().getId().toString();
                if (iCodingRuleManager.isExist((IObjectValue)positionInfo, mainOrgID)) {
                    number = iCodingRuleManager.readNumber((IObjectValue)positionInfo, mainOrgID);
                    for (int count = 0; count < 3000 && (PositionVerFactory.getLocalInstance(ctx).exists(" select id where number='" + number + "'") || PositionFactory.getLocalInstance((Context)ctx).exists(" select id where number='" + number + "'")); ++count) {
                        number = iCodingRuleManager.getNonbreakNumber((IObjectValue)positionInfo, mainOrgID);
                    }
                    iCodingRuleManager.getNonbreakNumber((IObjectValue)positionInfo, mainOrgID);
                }
            } else {
                positionInfo = new PositionInfo();
                adminOrgUnit = new AdminOrgUnitInfo();
                adminOrgUnit.setName(adminVer.getName());
                adminOrgUnit.setNumber(adminVer.getNumber());
                positionInfo.setAdminOrgUnit(adminOrgUnit);
                String mainOrgID = adminVer.getCU().getId().toString();
                ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
                if (iCodingRuleManager.isExist((IObjectValue)positionInfo, mainOrgID)) {
                    number = iCodingRuleManager.readNumber((IObjectValue)positionInfo, mainOrgID);
                    for (int count = 0; count < 3000 && (PositionVerFactory.getLocalInstance(ctx).exists(" select id where number='" + number + "'") || PositionFactory.getLocalInstance((Context)ctx).exists(" select id where number='" + number + "'")); ++count) {
                        number = iCodingRuleManager.getNonbreakNumber((IObjectValue)positionInfo, mainOrgID);
                    }
                    iCodingRuleManager.getNonbreakNumber((IObjectValue)positionInfo, mainOrgID);
                }
            }
        }
        return number;
    }

    public void addNewPositionMove(Context ctx, String schemeId, String positionId, String targetOrgId) throws BOSException, EASBizException {
        AdminOrgUnitVerCollection afterAdminOrgUnitVerColl = AdminOrgUnitVerFactory.getLocalInstance(ctx).getAdminOrgUnitVerCollection("SELECT * WHERE id = '" + targetOrgId + "'");
        String adminId = "";
        if (afterAdminOrgUnitVerColl.size() > 0) {
            adminId = afterAdminOrgUnitVerColl.get(0).getAdminOrgUnit().getId().toString();
            String updatePositionVerSql = "UPDATE T_HR_PositionVer SET FADMINORGUNITID = '" + targetOrgId + "' WHERE FID = '" + positionId + "'";
            DbUtil.execute((Context)ctx, (String)updatePositionVerSql);
            String updatePositionVerAdjSql = "UPDATE T_HR_PositionVerAdjRec SET fAfterAdjParent = '" + adminId + "'WHERE FPOSITIONVER = '" + positionId + "' AND FORGADJSCHM = '" + schemeId + "'";
            DbUtil.execute((Context)ctx, (String)updatePositionVerAdjSql);
            String getPositionPersonSql = "SELECT FID FROM T_HR_PersonVer WHERE FPRIMARYPOSITION = '" + positionId + "'";
            IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)getPositionPersonSql);
            try {
                while (executeQuery.next()) {
                    String personVerId = executeQuery.getString("FID");
                    String updatePersonVerSql = "UPDATE T_HR_PersonVer SET FPERSONDEP = '" + targetOrgId + "' WHERE FID = '" + personVerId + "'";
                    DbUtil.execute((Context)ctx, (String)updatePersonVerSql);
                    String updatePersonVerAdjSql = "UPDATE T_HR_PersonVerAdjRec SET FAFTERADJORG = (SELECT FADMINORGUNITID FROM T_HR_AdminOrgUnitVer WHERE FID = '" + targetOrgId + "') WHERE FPERSONVER = '" + personVerId + "' AND FADJTYPE = 22 AND FORGADJSCHM = '" + schemeId + "'";
                    DbUtil.execute((Context)ctx, (String)updatePersonVerAdjSql);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    private void updatePrimaryPositionOfOrg(Context ctx, PositionVerInfo positionVerInfo, AdminOrgUnitVerInfo newAdminInfo) throws BOSException, EASBizException {
        String orgAdjSchm = positionVerInfo.getOrgAdjSchm().getId().toString();
        String posId = positionVerInfo.getId().toString();
        String oldAdminId = positionVerInfo.getAdminOrgUnit().getId().toString();
        String sql = null;
        if (positionVerInfo.isIsRespPosition()) {
            StringBuffer oql = new StringBuffer();
            oql.append(" where adminOrgUnit.id ='").append(oldAdminId).append("'").append(" and id <> '").append(posId).append("'").append(" and deletedStatus=1").append(" and orgAdjSchm='").append(orgAdjSchm).append("'");
            if (this.exists(ctx, oql.toString())) {
                throw new OrgOperatorException(OrgOperatorException.ERROR_MOVE_RESP, new Object[]{positionVerInfo.getName(), positionVerInfo.getAdminOrgUnit().getName()});
            }
            sql = " update T_HR_AdminOrgUnitVer set FResponPositionID=null where fid=? and fOrgAdjSchm=?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{oldAdminId, orgAdjSchm});
            sql = " update T_HR_PositionVer set FIsRespPosition=0 where fid=? and fOrgAdjSchm=?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{posId, orgAdjSchm});
        }
        if (newAdminInfo.getResponPosition() == null) {
            sql = " update T_HR_AdminOrgUnitVer set FResponPositionID=?  where fid=? and fOrgAdjSchm=?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{posId, newAdminInfo.getId().toString(), orgAdjSchm});
            sql = " update T_HR_PositionVer set FIsRespPosition=1,fIndex=-1 where fid=? and fOrgAdjSchm=?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{posId, orgAdjSchm});
        }
    }

    @Override
    protected PositionVerInfo _getPositionInfo(Context ctx, PositionVerInfo positionVerInfo) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select name,number,deletedStatus,orgAdjSchm.id,position.id where id='").append(positionVerInfo.getId()).append("'");
        return this.getPositionVerInfo(ctx, sql.toString());
    }

    private PositionVerInfo getPositionVerInfo(Context ctx, String positionId, String orgAdjSchm) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("index"));
        sic.add(new SelectorItemInfo("isRespPosition"));
        sic.add(new SelectorItemInfo("orgAdjSchm.*"));
        sic.add(new SelectorItemInfo("parentPosition.id"));
        sic.add(new SelectorItemInfo("parentPosition.name"));
        sic.add(new SelectorItemInfo("parentPosition.number"));
        sic.add(new SelectorItemInfo("adminOrgUnit.id"));
        sic.add(new SelectorItemInfo("adminOrgUnit.name"));
        sic.add(new SelectorItemInfo("adminOrgUnit.number"));
        sic.add(new SelectorItemInfo("adminOrgUnit.adminOrgUnit"));
        sic.add(new SelectorItemInfo("job.id"));
        sic.add(new SelectorItemInfo("jobLevel.id"));
        sic.add(new SelectorItemInfo("lowJobGrade.id"));
        sic.add(new SelectorItemInfo("highJobGrade.id"));
        sic.add(new SelectorItemInfo("hrJob.id"));
        sic.add(new SelectorItemInfo("lowJobLevel.id"));
        sic.add(new SelectorItemInfo("highJobLevel.id"));
        sic.add(new SelectorItemInfo("domain.id"));
        sic.add(new SelectorItemInfo("productLine.id"));
        sic.add(new SelectorItemInfo("deletedStatus"));
        sic.add(new SelectorItemInfo("positionStandardLib.id"));
        sic.add(new SelectorItemInfo("positionStandardLib.name"));
        sic.add(new SelectorItemInfo("positionStandardLib.number"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)positionId));
        filter.getFilterItems().add(new FilterItemInfo("orgAdjSchm.id", (Object)orgAdjSchm));
        view.setSelector(sic);
        view.setFilter(filter);
        PositionVerCollection posColl = this.getPositionVerCollection(ctx, view);
        if (posColl.size() > 0) {
            return posColl.get(0);
        }
        return null;
    }

    @Override
    protected int _getMaxIndex(Context ctx, String adminId, String orgSchmId) throws BOSException {
        int maxIndex;
        block6: {
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT count(fid) FROM T_HR_PositionVer WHERE FAdminOrgUnitID='").append(adminId).append("'").append(" and fOrgAdjSchm='").append(orgSchmId).append("'");
            IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            maxIndex = -1;
            try {
                if (!rows.next()) break block6;
                int count = rows.getInt(1);
                if (count == 0) {
                    maxIndex = -1;
                    break block6;
                }
                sql = new StringBuffer();
                sql.append("SELECT MAX(FIndex) FROM T_HR_PositionVer WHERE FAdminOrgUnitID='").append(adminId).append("'").append(" and fOrgAdjSchm='").append(orgSchmId).append("'");
                rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                try {
                    if (rows.next()) {
                        maxIndex = rows.getInt(1);
                    }
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return maxIndex;
    }

    @Override
    protected void _deletePostionVerInfo(Context ctx, PositionVerInfo positionVerInfo) throws BOSException, EASBizException {
        this.checkBeforeDeletePosition(ctx, positionVerInfo);
        StringBuffer updateSql = new StringBuffer();
        updateSql.append("delete from T_HR_PositionVer where fid=? and fOrgAdjSchm=?");
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String orgAdjSchm = positionVerInfo.getOrgAdjSchm().getId().toString();
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.prepareStatement(updateSql.toString());
            ps.setString(1, positionVerInfo.getId().toString());
            ps.setString(2, orgAdjSchm);
            ps.executeUpdate();
            updateSql = new StringBuffer();
            updateSql.append("delete from T_HR_PositionVerAdjRec where fPositionVer=? and fOrgAdjSchm=?");
            ps = conn.prepareStatement(updateSql.toString());
            ps.setString(1, positionVerInfo.getId().toString());
            ps.setString(2, orgAdjSchm);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rs, (Statement)ps, (Connection)conn);
        OrgVerAdjUtil.updateOrgAdjSchm(ctx, orgAdjSchm);
    }

    private void checkBeforeDeletePosition(Context ctx, PositionVerInfo positionVerInfo) throws BOSException, EASBizException {
        String orgAdjSchm = positionVerInfo.getOrgAdjSchm().getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("select per.fid from T_HR_PersonVer per inner join T_HR_PositionVer posVer on posVer.fid=per.fPrimaryPosition").append(" where per.fOrgAdjSchm='").append(orgAdjSchm).append("' and posVer.fOrgAdjSchm='").append(orgAdjSchm).append("'").append(" and posVer.fid='").append(positionVerInfo.getId()).append("'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rs.next()) {
                throw new OrgAdjSchmVerException(OrgAdjSchmVerException.POSITION_DELETE_HASPERSONERROR);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _sealUp(Context ctx, PositionVerInfo positionVerInfo) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(positionVerInfo.getId().toString());
        String orgAdjSchm = positionVerInfo.getOrgAdjSchm().getId().toString();
        StringBuffer updateSql = new StringBuffer();
        updateSql.append("update T_HR_PositionVer set FDeletedStatus=2,fPosStateType=").append(4).append(" where fid='").append(pk.toString()).append("'").append(" and fOrgAdjSchm='").append(orgAdjSchm).append("'");
        DbUtil.execute((Context)ctx, (String)updateSql.toString());
        PositionVerAdjRecFactory.getLocalInstance(ctx).adjRecForSealUpPosition(positionVerInfo);
        String Res_Position = EASCommonResource.getString((String)"com.kingdee.eas.hr.org.HROrgAdjSchmVerResource.Position", (Locale)ctx.getLocale());
        String Res_SealUP = EASCommonResource.getString((String)"com.kingdee.eas.hr.org.HROrgAdjSchmVerResource.SealUP", (Locale)ctx.getLocale());
        OrgPosVerAdjRecFactory.getLocalInstance(ctx).writeOptPosRecorder(positionVerInfo, Res_Position + Res_SealUP, OrgVerAdjEnum.SEALUP);
        OrgVerAdjUtil.updateOrgAdjSchm(ctx, orgAdjSchm);
    }

    @Override
    protected void _unSealUp(Context ctx, PositionVerInfo positionVerInfo) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(positionVerInfo.getId().toString());
        StringBuffer updateSql = new StringBuffer();
        updateSql.append("update T_HR_PositionVer set FDeletedStatus=1,fPosStateType=").append(3).append(" where fid='").append(pk.toString()).append("'").append(" and fOrgAdjSchm='").append(positionVerInfo.getOrgAdjSchm().getId()).append("'");
        DbUtil.execute((Context)ctx, (String)updateSql.toString());
        PositionVerAdjRecFactory.getLocalInstance(ctx).adjRecForUnSealUpPosition(positionVerInfo);
        String Res_Position = EASCommonResource.getString((String)"com.kingdee.eas.hr.org.HROrgAdjSchmVerResource.Position", (Locale)ctx.getLocale());
        String Res_Un_SealUp = EASCommonResource.getString((String)"com.kingdee.eas.hr.org.HROrgAdjSchmVerResource.Un_SealUp", (Locale)ctx.getLocale());
        OrgPosVerAdjRecFactory.getLocalInstance(ctx).writeOptPosRecorder(positionVerInfo, Res_Position + Res_Un_SealUp, OrgVerAdjEnum.UnSealUP);
        OrgVerAdjUtil.updateOrgAdjSchm(ctx, positionVerInfo.getOrgAdjSchm().getId().toString());
    }

    @Override
    protected void _updateIndex(Context ctx, Map indexMap, String orgAdjSchm, boolean needRecordAdjInfo, PositionVerInfo positionInfo) throws BOSException, EASBizException {
        String sql = "UPDATE T_HR_PositionVer SET FIndex=? WHERE FID=? and fOrgAdjSchm=?";
        Iterator iterator = indexMap.keySet().iterator();
        Connection con = null;
        PreparedStatement pstmt = null;
        ArrayList<String> idList = new ArrayList<String>();
        try {
            con = this.getConnection(ctx);
            pstmt = con.prepareStatement(sql);
            String id = null;
            while (iterator.hasNext()) {
                id = (String)iterator.next();
                pstmt.setInt(1, (Integer)indexMap.get(id));
                pstmt.setString(2, id);
                pstmt.setString(3, orgAdjSchm);
                pstmt.addBatch();
                idList.add(id);
            }
            pstmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)con);
        if (!needRecordAdjInfo) {
            return;
        }
        if (positionInfo != null) {
            String Res_MovePosWithSameLevel = EASCommonResource.getString((String)"com.kingdee.eas.hr.org.HROrgAdjSchmVerResource.MovePosWithSameLevel", (Locale)ctx.getLocale());
            OrgPosVerAdjRecFactory.getLocalInstance(ctx).writeOptPosRecorder(positionInfo, Res_MovePosWithSameLevel, OrgVerAdjEnum.MOVE);
        }
        String idStr = StringCollUtil.getStrFromList(idList);
        StringBuffer delSql = new StringBuffer();
        delSql.append("delete from T_HR_PositionVerAdjRec where fPositionVer in ").append(idStr).append(" and fOrgAdjSchm='").append(orgAdjSchm).append("'").append(" and fAdjType = ").append(10).append(" and fEnableStatus =0 ");
        DbUtil.execute((Context)ctx, (String)delSql.toString());
        StringBuffer insertSql = new StringBuffer();
        Timestamp curTime = OrgVerAdjUtil.getTime();
        String curUser = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        insertSql.append("insert into T_HR_PositionVerAdjRec(fid,fPositionVer,fOrgAdjSchm,fAdjType,fEnableStatus,fCreatorID,fCreateTime,fLastUpdateTime,fLastUpdateUserID)").append(" values(?,?,?,?,?,?,?,?,?)");
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = this.getConnection(ctx);
            ps = conn.prepareStatement(insertSql.toString());
            int size = idList.size();
            for (int i = 0; i < size; ++i) {
                ps.setString(1, BOSUuid.create((String)"1E425C6D").toString());
                ps.setString(2, (String)idList.get(i));
                ps.setString(3, orgAdjSchm);
                ps.setInt(4, 10);
                ps.setInt(5, 0);
                ps.setString(6, curUser);
                ps.setTimestamp(7, curTime);
                ps.setTimestamp(8, curTime);
                ps.setString(9, curUser);
                ps.addBatch();
            }
            ps.executeBatch();
            ps.clearBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
        OrgVerAdjUtil.updateOrgAdjSchm(ctx, orgAdjSchm);
    }

    @Override
    protected PositionVerInfo _getResponPositionByAdmin(Context ctx, AdminOrgUnitVerInfo adminOrg) throws BOSException {
        AdminOrgUnitVerInfo parentAdminInfo = null;
        AdminOrgUnitVerInfo curAdminInfo = this.getResponPositionByAdminVer(ctx, adminOrg);
        if (curAdminInfo != null && curAdminInfo.getResponPosition() != null) {
            return curAdminInfo.getResponPosition();
        }
        if (curAdminInfo != null && curAdminInfo.getParent() != null && (parentAdminInfo = this.getResponPositionByAdminVer(ctx, curAdminInfo.getParent())).getResponPosition() != null) {
            return parentAdminInfo.getResponPosition();
        }
        return null;
    }

    private AdminOrgUnitVerInfo getResponPositionByAdminVer(Context ctx, AdminOrgUnitVerInfo adminInfo) throws BOSException {
        String orgAdjSchm = adminInfo.getOrgAdjSchm().getId().toString();
        StringBuffer oql = new StringBuffer();
        oql.append("select id,number,name,isRespPosition,responPosition.id,parent.id,parent.name,parent.orgAdjSchm.id").append(" where id='").append(adminInfo.getId().toString()).append("'").append(" and responPosition.orgAdjSchm='").append(orgAdjSchm).append("'").append(" and orgAdjSchm='").append(orgAdjSchm).append("'");
        AdminOrgUnitVerCollection orgColl = AdminOrgUnitVerFactory.getLocalInstance(ctx).getAdminOrgUnitVerCollection(oql.toString());
        if (orgColl.size() > 0) {
            return orgColl.get(0);
        }
        return null;
    }

    @Override
    protected boolean _isSystemPosition(Context ctx, String positionVerID) throws BOSException, EASBizException {
        StringBuffer oql = new StringBuffer();
        oql.append("select position.id where id='").append(positionVerID).append("'");
        PositionVerInfo positionVer = this.getPositionVerInfo(ctx, oql.toString());
        return PositionFactory.getLocalInstance((Context)ctx).exists((IObjectPK)new ObjectUuidPK(positionVer.getPosition().getId().toString()));
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PositionVerInfo info = (PositionVerInfo)model;
        String orgAdjSchm = info.getOrgAdjSchm().getId().toString();
        StringBuffer oql = new StringBuffer();
        oql.append("where number='").append(info.getNumber().trim()).append("'");
        if (info.getId() != null) {
            oql.append(" and id<>'").append(info.getId()).append("'").append(" and orgAdjSchm='").append(orgAdjSchm).append("'");
        }
        if (super._exists(ctx, oql.toString())) {
            String number = this._getPropertyAlias(ctx, info, "number") + info.getNumber();
            throw new HrOrgBizException(HrOrgBizException.EXCEPTION21, new Object[]{number});
        }
    }

    private void doWithCodeRule(Context ctx, PositionVerInfo info) throws BOSException, EASBizException {
        ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        CtrlUnitInfo cuInfo = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        String cuId = cuInfo.getId().toString();
        PositionInfo tmpInfo = new PositionInfo();
        tmpInfo.setCU(info.getCU());
        if (codingRuleManager.isExist((IObjectValue)tmpInfo, cuId)) {
            String rdNum = codingRuleManager.getNumber((IObjectValue)tmpInfo, cuId);
            info.setNumber(rdNum);
        }
    }

    public static void positionAllMoveAdminToAdmin(Context ctx, String schemeId, String adminVerID, String toAdminVerID) throws BOSException, EASBizException {
        try {
            String getPositionSQL = "SELECT FID FROM T_HR_PositionVer WHERE FAdminOrgUnitID = '" + adminVerID + "' AND fOrgAdjSchm = '" + schemeId + "' AND FDeletedStatus = 1";
            IRowSet execute = DbUtil.executeQuery((Context)ctx, (String)getPositionSQL);
            String positionIds = "";
            while (execute.next()) {
                positionIds = positionIds + "," + execute.getString("FID");
            }
            if (!positionIds.equals("")) {
                PositionVerControllerBean.moveBatchPositionDo(ctx, schemeId, positionIds, toAdminVerID);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void moveBatchPositionDo(Context ctx, String schemeId, String ids, String targetOrgVerId) throws BOSException, SQLException, EASBizException {
        HashSet<String> idsSet = new HashSet<String>();
        String[] array = null;
        array = ids.substring(1).split(",");
        for (int i = 0; i < array.length; ++i) {
            idsSet.add(array[i]);
        }
        IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)("SELECT FID AS id FROM T_HR_POSITIONVER WHERE FOrgAdjSchm = '" + schemeId + "' AND FISRESPPOSITION = 1 AND FAdminOrgUnitID = '" + targetOrgVerId + "'"));
        if (executeQuery.size() < 1) {
            String moveResPositionID = "";
            IRowSet execute = DbUtil.executeQuery((Context)ctx, (String)("SELECT FID AS id FROM T_HR_POSITIONVER WHERE FID IN (" + PositionVerControllerBean.idsSetToIdSql(idsSet) + ") AND fOrgAdjSchm = '" + schemeId + "' AND FISRESPPOSITION = 1"));
            while (execute.next()) {
                moveResPositionID = execute.getString("id");
                PositionVerControllerBean.movePositionDo(schemeId, moveResPositionID, targetOrgVerId, ctx);
                idsSet.remove(moveResPositionID);
            }
        }
        for (int i = 0; i < array.length; ++i) {
            if (idsSet.size() <= 0) continue;
            String sql2 = "SELECT FID FROM T_HR_POSITIONVER WHERE FID IN (" + PositionVerControllerBean.idsSetToIdSql(idsSet) + ") AND FPARENTPOSITION IN (" + PositionVerControllerBean.idsSetToIdSql(idsSet) + ") AND fOrgAdjSchm = '" + schemeId + "'";
            IRowSet executeQuery2 = DbUtil.executeQuery((Context)ctx, (String)sql2);
            while (executeQuery2.next()) {
                String positionVerId = executeQuery2.getString("FID");
                PositionVerControllerBean.movePositionDo(schemeId, positionVerId, targetOrgVerId, ctx);
                idsSet.remove(positionVerId);
            }
        }
        if (idsSet.size() > 0) {
            String sql2 = "SELECT FID FROM T_HR_POSITIONVER WHERE FID IN (" + PositionVerControllerBean.idsSetToIdSql(idsSet) + ") AND fOrgAdjSchm = '" + schemeId + "'";
            IRowSet executeQuery2 = DbUtil.executeQuery((Context)ctx, (String)sql2);
            while (executeQuery2.next()) {
                String positionVerId = executeQuery2.getString("FID");
                PositionVerControllerBean.movePositionDo(schemeId, positionVerId, targetOrgVerId, ctx);
            }
        }
    }

    public static String idsSetToIdSql(HashSet<String> idsSet) {
        String result = "";
        Iterator<String> it = idsSet.iterator();
        while (it.hasNext()) {
            result = result + ",'" + it.next() + "'";
        }
        if (result.length() > 0) {
            return result.substring(1);
        }
        return "";
    }

    public static void movePositionDo(String schemeId, String posVerId, String targetOrgVerId, Context ctx) throws BOSException, EASBizException {
        String deleteSql;
        String sql;
        PositionVerAdjRecControllerBean positionVerAdjRecControllerBean;
        OrgVerAdjUtil.checkSchemeEnable(null, schemeId);
        IPositionVer iPositionVer = PositionVerFactory.getLocalInstance(ctx);
        PositionVerInfo oldVerInfo = iPositionVer.getPositionVerInfo("select adminOrgUnit.id,deletedStatus,name where id ='" + posVerId + "'");
        if (targetOrgVerId.equals(oldVerInfo.getAdminOrgUnit().getId().toString())) {
            JSONUtils.ERROR((String)EASResource.getString((String)"com.kingdee.eas.hr.org.HrOrgBizResource", (String)"label25", (Locale)ctx.getLocale()));
            return;
        }
        if (oldVerInfo.getDeletedStatus() != null && oldVerInfo.getDeletedStatus().getValue() == 2) {
            JSONUtils.ERROR((String)EASResource.getString((String)"com.kingdee.eas.hr.org.HrOrgBizResource", (String)"label26", (Locale)ctx.getLocale()));
            return;
        }
        boolean isPositionCanDuplicate = HRUtilExtend.isPositionCanDuplicate((Context)ctx);
        if (!isPositionCanDuplicate) {
            PositionVerControllerBean.verifyPositionVerNameDuplicate(ctx, oldVerInfo, targetOrgVerId);
        }
        String oldAdminVerID = oldVerInfo.getAdminOrgUnit().getId().toString();
        HashMap<String, String> moveParam = new HashMap<String, String>();
        moveParam.put("schemeId", schemeId);
        moveParam.put("positionVerId", posVerId);
        moveParam.put("targetOrgId", targetOrgVerId);
        String backPositionId = "";
        boolean isNeedEmptyRes = false;
        String checkSql = "SELECT FID FROM T_HR_PositionVer WHERE FID = '" + posVerId + "' AND FISRESPPOSITION = 1 AND FADMINORGUNITID = '" + oldAdminVerID + "' AND FID IN (SELECT FPOSITIONVER FROM T_HR_positionverAdjRec WHERE FORGADJSCHM = '" + schemeId + "' AND FADJTYPE IN (16,17))";
        IRowSet executeQuery2 = DbUtil.executeQuery((Context)ctx, (String)checkSql);
        if (executeQuery2.size() != 0) {
            isNeedEmptyRes = true;
        }
        if ((positionVerAdjRecControllerBean = new PositionVerAdjRecControllerBean()).isPositionAddnew(ctx, schemeId, posVerId, "16")) {
            PositionVerControllerBean positionVerControllerBean = new PositionVerControllerBean();
            positionVerControllerBean.addNewPositionMove(ctx, schemeId, posVerId, targetOrgVerId);
        } else {
            try {
                sql = "SELECT FBackPositionVerId FROM T_HR_PositionVerAdjRec WHERE fOrgAdjSchm = '" + schemeId + "' AND fAdjType = 17 AND FPOSITIONVER = '" + posVerId + "'";
                IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql);
                while (executeQuery.next()) {
                    backPositionId = executeQuery.getString("FBackPositionVerId");
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            iPositionVer.move(moveParam);
        }
        if (isNeedEmptyRes) {
            AdminOrgUnitVerInfo oldOrgVer = AdminOrgUnitVerFactory.getLocalInstance(ctx).getAdminOrgUnitVerInfo("where orgAdjSchm.id = '" + schemeId + "' and id = '" + oldAdminVerID + "'");
            oldOrgVer.setResponPosition(null);
            AdminOrgUnitVerControllerBean adminOrgUnitVerControllerBean = new AdminOrgUnitVerControllerBean();
            adminOrgUnitVerControllerBean._update(ctx, (IObjectPK)new ObjectUuidPK(oldOrgVer.getId().toString()), (IObjectValue)oldOrgVer);
        }
        if (!"".equals(backPositionId)) {
            String getChildsql = "select * where parentPosition.id= '" + backPositionId + "'";
            PositionVerCollection positionVerColl = PositionVerFactory.getLocalInstance(ctx).getPositionVerCollection(getChildsql);
            for (int i = 0; i < positionVerColl.size(); ++i) {
                String id = positionVerColl.get(i).getId().toString();
                if (!"".equals(OrgAdjustUtil.getPositionEditDescription(schemeId, id, ctx))) continue;
                String deleteSql2 = "DELETE FROM T_HR_PositionVerAdjRec WHERE FPOSITIONVER = '" + id + "' AND fOrgAdjSchm = '" + schemeId + "' AND fAdjType = 20";
                DbUtil.execute((Context)ctx, (String)deleteSql2);
            }
        }
        if ("".equals(OrgAdjustUtil.getAdminDescription(schemeId, targetOrgVerId, ctx))) {
            deleteSql = "DELETE FROM T_HR_OrgVerAdjRec WHERE FORGVERID = '" + targetOrgVerId + "' AND fOrgAdjSchm = '" + schemeId + "' AND fAdjType = 13";
            DbUtil.execute((Context)ctx, (String)deleteSql);
        }
        if ("".equals(OrgAdjustUtil.getAdminDescription(schemeId, oldAdminVerID, ctx))) {
            deleteSql = "DELETE FROM T_HR_OrgVerAdjRec WHERE FORGVERID = '" + oldAdminVerID + "' AND fOrgAdjSchm = '" + schemeId + "' AND fAdjType = 13";
            DbUtil.execute((Context)ctx, (String)deleteSql);
        }
        sql = "select adminVer.FID  from T_HR_HROrgAdjSchm hrAdjSchm left join T_HR_AdminOrgUnitVer adminVer ON adminVer.FADMINORGUNITID = hrAdjSchm.FADMINORGUNITID WHERE hrAdjSchm.fid = '" + schemeId + "' AND adminVer.FORGADJSCHM = '" + schemeId + "'";
        DbUtil.execute((Context)ctx, (String)("delete from T_HR_OrgVerAdjRec where FORGVERID in (" + sql + ")"));
    }

    private static void verifyPositionVerNameDuplicate(Context ctx, PositionVerInfo positionVer, String targetOrgVerId) throws EASBizException {
        StringBuffer oql = new StringBuffer();
        oql.append("select id,name where adminorgunit = '").append(targetOrgVerId).append("'");
        if (positionVer.getId() != null) {
            oql.append(" and id != '").append(positionVer.getId()).append("'");
        }
        oql.append(" and deletedStatus = '1' ");
        try {
            PositionVerCollection pCol = PositionVerFactory.getLocalInstance(ctx).getPositionVerCollection(oql.toString());
            for (int i = 0; i < pCol.size(); ++i) {
                PositionVerControllerBean.positionVerNameMutiLangRepeatCheck(positionVer, pCol.get(i));
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    private static void positionVerNameMutiLangRepeatCheck(PositionVerInfo newPositionVer, PositionVerInfo oldPositionVer) throws EASBizException {
        for (int i = 1; i < 4; ++i) {
            String newPositionVerName;
            String nameLocal = "name_l" + i;
            if (newPositionVer.get(nameLocal) == null || newPositionVer.get(nameLocal).equals("") || !(newPositionVerName = (String)newPositionVer.get(nameLocal)).equals(oldPositionVer.get(nameLocal))) continue;
            throw new HrOrgBizException(HrOrgBizException.EXCEPTION19, new Object[]{newPositionVerName});
        }
    }
}

